/*
 * Copyright (C) 1998  Mark Baysinger (mbaysing@ucsd.edu)
 * Copyright (C) 1998,1999  Ross Combs (rocombs@cs.nmsu.edu)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#ifndef INCLUDED_CHANNEL_TYPES
#define INCLUDED_CHANNEL_TYPES

#ifdef CHANNEL_INTERNAL_ACCESS
#ifdef JUST_NEED_TYPES
#include "connection.h"
#include "list.h"
#else
#define JUST_NEED_TYPES
#include "connection.h"
#undef JUST_NEED_TYPES
#endif

typedef struct channelmember
{   
    t_connection *         connection;
    struct channelmember * next;
} t_channelmember;

#endif

typedef struct channel
#ifdef CHANNEL_INTERNAL_ACCESS
{ 
    char const *      name;
    char const *      shortname;
    int               permanent;
    int               allowbots;
    int               allowopers;
    char const *      clienttag;
    t_channelmember * memberlist;
    t_list *          banlist;  /* of char * */
    t_connection *    opr;      /* operator */
    t_connection *    next_opr; /* designated operator */
    struct channel *  next;
}
#endif
t_channel;

#endif

#ifndef JUST_NEED_TYPES
#ifndef INCLUDED_CHANNEL_PROTOS
#define INCLUDED_CHANNEL_PROTOS

#define JUST_NEED_TYPES
#include "connection.h"
#undef JUST_NEED_TYPES

#define CHANNEL_NAME_BANNED "Void"
#define CHANNEL_NAME_KICKED "Void"
#define CHANNEL_NAME_CHAT   "Chat"

extern t_channel * channel_create(char const * fullname, char const * shortname, char const * clienttag, int permflag, int botflag, int operflag);
extern int channel_destroy(t_channel * channel);
extern char const * channel_get_name(t_channel const * channel);
extern char const * channel_get_clienttag(t_channel const * channel);
extern int channel_get_permanent(t_channel const * channel);
extern int channel_add_connection(t_channel * channel, t_connection * connection);
extern int channel_del_connection(t_channel * channel, t_connection * connection);
extern void channel_update_latency(t_connection * conn);
extern void channel_update_flags(t_connection * conn);
extern void channel_message_send(t_channel const * channel, unsigned int type, t_connection * conn, char const * text);
extern t_connection * channel_get_operator(t_channel const * channel);
extern int channel_choose_operator(t_channel * channel, t_connection * tryop);
extern int channel_set_next_operator(t_channel * channel, t_connection * conn);
extern int channel_ban_user(t_channel * channel, char const * user);
extern int channel_unban_user(t_channel * channel, char const * user);
extern int channel_check_banning(t_channel const * channel, t_connection const * user);
extern char const * channel_banlist_get_first(t_channel const * channel);
extern char const * channel_banlist_get_next(void);
extern int channel_get_length(t_channel const * channel);
extern t_connection * channel_get_first(t_channel const * channel);
extern t_connection * channel_get_next(void);

extern void channellist_init(void);
extern void channellist_unload(void);
extern t_channel * channellist_find_channel(char const * name);
extern t_channel * channellist_get_first(void);
extern t_channel * channellist_get_next(void);
extern int channellist_get_length(void);

#endif
#endif
