//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#include <gtkmm.h>
#include <libglademm.h>
#include <iostream>

#include "resizable.hh"

namespace Bmp
{
    Resizable::Resizable (BaseObjectType                       *  obj,
                          Glib::RefPtr<Gnome::Glade::Xml> const&  xml)

        : 
          Gtk::Alignment  (obj),
          handle_state    (Gtk::STATE_NORMAL),
          handle_window   (Glib::RefPtr<Gdk::Window>(0)),
          moving          (false)
      {
        GTK_WIDGET_SET_FLAGS (GTK_WIDGET (gobj()), GTK_NO_WINDOW | GTK_CAN_FOCUS);
      }

    Resizable::~Resizable () {}

    void
    Resizable::on_realize ()
    {
      int attributes_mask = 0;

      GTK_WIDGET_SET_FLAGS (GTK_WIDGET(gobj()), GTK_REALIZED);

      GdkWindowAttr attributes;

      set_window (get_parent_window());

      attributes.window_type = GDK_WINDOW_CHILD;
      attributes.wclass = GDK_INPUT_ONLY;
      attributes.x = 0; 
      attributes.y = get_allocation().get_height() - 8; 
      attributes.width = get_allocation().get_width(); 
      attributes.height = 8; 
      attributes.cursor = gdk_cursor_new_for_display (get_display()->gobj(), GDK_SB_V_DOUBLE_ARROW);
      attributes.event_mask = get_events ();
      attributes.event_mask |= GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK |
                               GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK |
                               GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK;

      attributes_mask = GDK_WA_X | GDK_WA_Y | GDK_WA_CURSOR;
      handle_window = Gdk::Window::create (get_window(), &attributes, attributes_mask);
      gdk_window_set_user_data (handle_window->gobj(), gpointer (GTK_WIDGET(gobj())));
      gdk_cursor_unref (attributes.cursor);
      handle_window->show ();
    }

    void
    Resizable::on_size_request (Gtk::Requisition * req)
    {
      GtkWidget * child = GTK_WIDGET(get_child()->gobj());
      if (child && GTK_WIDGET_VISIBLE (child))
        {
          GtkRequisition child_requisition;
          gtk_widget_size_request (child, &child_requisition);
          req->width = child_requisition.width;
          req->height = child_requisition.height + 8;
        }
    }

    void
    Resizable::on_size_allocate (Gtk::Allocation & allocation)
    {
      set_allocation (allocation); 

      if (handle_window)
        {
          handle_window->move_resize (0, allocation.get_height() - 8, allocation.get_width(), 8);
        }

      GtkWidget * child = GTK_WIDGET (get_child()->gobj());
      if (child)
        {
          GtkAllocation child_allocation;

          child_allocation.x      = allocation.get_x();
          child_allocation.y      = allocation.get_y();
          child_allocation.width  = allocation.get_width(); 
          child_allocation.height = allocation.get_height() - 8;

          gtk_widget_size_allocate (child, &child_allocation);
        }
    }

    bool
    Resizable::on_enter_notify_event (GdkEventCrossing * event)
    {
      handle_state = Gtk::STATE_PRELIGHT;
      queue_draw ();
      return true;
    }

    bool
    Resizable::on_leave_notify_event (GdkEventCrossing * event)
    {
      if (!moving)
        {
          handle_state = Gtk::STATE_NORMAL;
          queue_draw ();
        }
      return true;
    }

    bool
    Resizable::on_button_press_event (GdkEventButton * event)
    {
      if (event->type == GDK_BUTTON_PRESS)
        {
          moving = true;
          h_original = get_allocation().get_height();
        }
      return true;
    }

    bool
    Resizable::on_button_release_event (GdkEventButton * event)
    {
      int h_cur = get_allocation().get_height();
      int h_dta = h_original - h_cur; 
      if (h_dta > 0) signal_shrink_delta_.emit (h_dta);
      return (moving = false);
    }

    bool
    Resizable::on_motion_notify_event (GdkEventMotion * event)
    {
      if (!moving) return true;

      int x, y;
      GdkModifierType state;

      if (event->is_hint) 
        {
          gdk_window_get_pointer (event->window, &x, &y, &state);
        }
      else
        {
          x = int(event->x);
          y = int(event->y);
          state = GdkModifierType(event->state);
        }

      int newsize = get_allocation().get_height() + y;
      if (newsize > 32)
        {
          set_size_request (get_allocation().get_width(), get_allocation().get_height() + y);
        }
      return true;
    }

    bool
    Resizable::on_expose_event (GdkEventExpose * event)
    {

      GtkWidget * child = GTK_WIDGET (get_child()->gobj());

      if (child)
        {
          gtk_container_propagate_expose (GTK_CONTAINER(gobj()), child, event);
        }

      gtk_paint_handle (get_style()->gobj(), 
                        get_window()->gobj(), 
                        GtkStateType(handle_state), 
                        GTK_SHADOW_NONE,
                        0,
                        GTK_WIDGET(gobj()),
                        "paned",
                        0, GTK_WIDGET(gobj())->allocation.height - 8, 
                        GTK_WIDGET(gobj())->allocation.width, 8, 
                        GTK_ORIENTATION_HORIZONTAL); 

      return false;
    }
}
