/*
 *
 *  BlueZ - Bluetooth protocol stack for Linux
 *
 *  Copyright (C) 2005-2006  Marcel Holtmann <marcel@holtmann.org>
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>

#include <dbus/dbus-glib.h>

#include <glib/gi18n.h>

#include <gtk/gtk.h>

#include "device-store.h"

static DBusGConnection *conn;

#if 0
static gint page_forward(gint current_page, gpointer data)
{
	return current_page + 1;
}
#endif

static void close_callback(GtkWidget *assistant, gpointer data)
{
	gtk_widget_destroy(assistant);

	gtk_main_quit();
}

static void cancel_callback(GtkWidget *assistant, gpointer data)
{
	gtk_widget_destroy(assistant);

	gtk_main_quit();
}

static GtkWidget *create_vbox(GtkWidget *assistant, GtkAssistantPageType type,
				const gchar *title, const gchar *section)
{
	GtkWidget *vbox;
	GtkWidget *label;
	GdkPixbuf *pixbuf;
	gchar *str;

	vbox = gtk_vbox_new(FALSE, 6);

	gtk_container_set_border_width(GTK_CONTAINER(vbox), 24);

	gtk_assistant_append_page(GTK_ASSISTANT(assistant), vbox);

	gtk_assistant_set_page_type(GTK_ASSISTANT(assistant), vbox, type);

	str = g_strdup_printf(" %s", title);

	gtk_assistant_set_page_title(GTK_ASSISTANT(assistant), vbox, str);

	g_free(str);

	gtk_assistant_set_page_complete(GTK_ASSISTANT(assistant), vbox, TRUE);

	//pixbuf = gtk_widget_render_icon(GTK_WIDGET(assistant),
	//		GTK_STOCK_DIALOG_INFO, GTK_ICON_SIZE_DIALOG, NULL);

	pixbuf = gtk_icon_theme_load_icon(gtk_icon_theme_get_default(),
					"stock_bluetooth", 32, 0, NULL);

	gtk_assistant_set_page_header_image(GTK_ASSISTANT(assistant),
								vbox, pixbuf);

	g_object_unref(pixbuf);

	if (section) {
		label = gtk_label_new(NULL);

		str = g_strdup_printf("<b>%s</b>\n", section);

		gtk_label_set_markup(GTK_LABEL(label), str);

		g_free(str);

		gtk_misc_set_alignment(GTK_MISC(label), 0, 0);

		gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);
	}

	return vbox;
}

static void create_intro(GtkWidget *assistant)
{
	GtkWidget *vbox;
	GtkWidget *label;

	vbox = create_vbox(assistant, GTK_ASSISTANT_PAGE_INTRO,
			_("Introduction"),
			_("Welcome to the Bluetooth device setup wizard"));

	label = gtk_label_new(NULL);

	gtk_label_set_markup(GTK_LABEL(label), _("The device wizard will "
				"walk you through the process of configuring "
				"Bluetooth enabled devices for use with this "
				"computer."));

	gtk_misc_set_alignment(GTK_MISC(label), 0, 0);

	gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);

	gtk_widget_set_size_request(GTK_WIDGET(label), 380, -1);

	gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, TRUE, 0);
}

static void create_type(GtkWidget *assistant)
{
	GtkWidget *vbox;
	GtkWidget *button;
	GSList *group = NULL;

	vbox = create_vbox(assistant, GTK_ASSISTANT_PAGE_CONTENT,
				_("Device type"),
				_("Select type of device you wanna setup"));

	button = gtk_radio_button_new_with_label(group, _("Mouse"));

	group = gtk_radio_button_get_group(GTK_RADIO_BUTTON(button));

	gtk_widget_set_sensitive(GTK_WIDGET(button), FALSE);

	gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);

	button = gtk_radio_button_new_with_label(group, _("Keyboard"));

	group = gtk_radio_button_get_group(GTK_RADIO_BUTTON(button));

	gtk_widget_set_sensitive(GTK_WIDGET(button), FALSE);

	gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);

	button = gtk_radio_button_new_with_label(group, _("Mobile phone"));

	group = gtk_radio_button_get_group(GTK_RADIO_BUTTON(button));

	gtk_widget_set_sensitive(GTK_WIDGET(button), FALSE);

	gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);

	button = gtk_radio_button_new_with_label(group, _("Printer"));

	group = gtk_radio_button_get_group(GTK_RADIO_BUTTON(button));

	gtk_widget_set_sensitive(GTK_WIDGET(button), FALSE);

	gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);

	button = gtk_radio_button_new_with_label(group, _("Headset"));

	group = gtk_radio_button_get_group(GTK_RADIO_BUTTON(button));

	gtk_widget_set_sensitive(GTK_WIDGET(button), FALSE);

	gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);

	button = gtk_radio_button_new_with_label(group, _("Any device"));

	group = gtk_radio_button_get_group(GTK_RADIO_BUTTON(button));

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), TRUE);

	gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
}

static void create_list(GtkWidget *assistant)
{
	GtkWidget *vbox;
	GtkWidget *tree;
	GtkWidget *scrolled;
	GtkTreeModel *store;
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;

	vbox = create_vbox(assistant, GTK_ASSISTANT_PAGE_PROGRESS,
				_("Device search"),
				_("Select device you wanna setup"));

	scrolled = gtk_scrolled_window_new(NULL, NULL);

	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled),
				GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(scrolled),
							GTK_SHADOW_OUT);

	gtk_container_add(GTK_CONTAINER(vbox), scrolled);

	tree = gtk_tree_view_new();

	gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(tree), TRUE);

	gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(tree), TRUE);

	column = gtk_tree_view_column_new();

	gtk_tree_view_column_set_title(column, "Device");

	renderer = gtk_cell_renderer_pixbuf_new();
	gtk_tree_view_column_set_spacing(column, 4);
	gtk_tree_view_column_pack_start(column, renderer, FALSE);
	gtk_tree_view_column_add_attribute(column, renderer, "icon-name", 4);

	renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_column_pack_start(column, renderer, TRUE);
	gtk_tree_view_column_set_attributes(column, renderer, "text", 1, NULL);
	gtk_tree_view_column_add_attribute(column, renderer, "sensitive", 6);

	gtk_tree_view_append_column(GTK_TREE_VIEW(tree), column);

        gtk_tree_view_column_set_min_width(GTK_TREE_VIEW_COLUMN(column), 280);

	column = gtk_tree_view_column_new();

	gtk_tree_view_column_set_title(column, "Type");

        renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_column_pack_start(column, renderer, TRUE);
	gtk_tree_view_column_set_attributes(column, renderer, "text", 2, NULL);
	gtk_tree_view_column_add_attribute(column, renderer, "sensitive", 6);

	gtk_tree_view_append_column(GTK_TREE_VIEW(tree), column);

	store = GTK_TREE_MODEL(bluetooth_device_store_new());

	gtk_tree_view_set_model(GTK_TREE_VIEW(tree), GTK_TREE_MODEL(store));

	gtk_container_add(GTK_CONTAINER(scrolled), tree);

	bluetooth_device_store_add_device(BLUETOOTH_DEVICE_STORE(store),
					"00:11:22:33:44:55", 0x000100, 0);

	bluetooth_device_store_add_name(BLUETOOTH_DEVICE_STORE(store),
					"00:11:22:33:44:55", "Test device");
}

static void create_summary(GtkWidget *assistant)
{
	GtkWidget *vbox;

	vbox = create_vbox(assistant, GTK_ASSISTANT_PAGE_SUMMARY,
				_("Summary"),
				_("Succesfully configured new device"));
}

static void create_wizard(void)
{
	GtkWidget *assistant;

	assistant = gtk_assistant_new();

	gtk_window_set_title(GTK_WINDOW(assistant), _("Bluetooth device wizard"));

	gtk_window_set_icon_name(GTK_WINDOW(assistant), "stock_bluetooth");

        gtk_window_set_position(GTK_WINDOW(assistant), GTK_WIN_POS_CENTER);

        gtk_window_set_default_size(GTK_WINDOW(assistant), 440, 440);

#if 0
	gtk_assistant_set_forward_page_func(GTK_ASSISTANT(assistant),
						page_forward, NULL, NULL);
#endif

	create_intro(assistant);

	create_type(assistant);

	create_list(assistant);

	create_summary(assistant);

	g_signal_connect(G_OBJECT(assistant), "close",
					G_CALLBACK(close_callback), NULL);

	g_signal_connect(G_OBJECT(assistant), "cancel",
					G_CALLBACK(cancel_callback), NULL);

	gtk_widget_show_all(assistant);

	gtk_assistant_update_buttons_state(GTK_ASSISTANT(assistant));
}

int main(int argc, char *argv[])
{
	GError *error = NULL;

	bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
	textdomain(GETTEXT_PACKAGE);

	gtk_init(&argc, &argv);

	conn = dbus_g_bus_get(DBUS_BUS_SYSTEM, &error);
	if (error != NULL) {
		g_printerr(_("Connecting to system bus failed: %s\n"),
							error->message);
		g_error_free(error);
		exit(EXIT_FAILURE);
	}

	create_wizard();

	gtk_main();

	dbus_g_connection_unref(conn);

	return 0;
}
