/*
 *
 *  Universal Protocol Analyzer library
 *
 *  Copyright (C) 2006-2008  Marcel Holtmann <marcel@holtmann.org>
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>

#include "upa-bluetooth-hci.h"

struct hci_command_hdr {
	guint16 opcode;
	guint8  plen;
} __attribute__ ((packed));
#define HCI_COMMAND_HDR_SIZE 3

struct hci_event_hdr {
	guint8  evt;
	guint8  plen;
} __attribute__ ((packed));
#define HCI_EVENT_HDR_SIZE 2

struct hci_acldata_hdr {
	guint16 handle;
	guint16 dlen;
} __attribute__ ((packed));
#define HCI_ACLDATA_HDR_SIZE 4

struct hci_command_complete_evt {
	guint8  num_cmds;
	guint16 opcode;
	guint8  params[0];
} __attribute__ ((packed));

struct hci_command_status_evt {
	guint8  status;
	guint8  num_cmds;
	guint16 opcode;
} __attribute__ ((packed));

G_DEFINE_TYPE(UpaBluetoothHci, upa_bluetooth_hci, UPA_TYPE_PACKET)

static void upa_bluetooth_hci_init(UpaBluetoothHci *self)
{
	//UpaPacket *packet = UPA_PACKET(self);

	self->type = 0xff;
}

static void upa_bluetooth_hci_class_init(UpaBluetoothHciClass *klass)
{
}

UpaPacket *upa_bluetooth_hci_new(guint8 type)
{
	UpaPacket *packet;

	packet = g_object_new(UPA_TYPE_BLUETOOTH_HCI, NULL);

	UPA_BLUETOOTH_HCI(packet)->type = type;

	return packet;
}

UpaPacket *upa_bluetooth_hci_new_from_data(guint8 type,
						gpointer data, gsize size)
{
	UpaPacket *packet;
	gpointer ptr;

	packet = upa_bluetooth_hci_new(type);

	switch (type) {
	case 0x00:
		ptr = upa_packet_alloc_data_with_head(packet, size,
							HCI_COMMAND_HDR_SIZE);
		memcpy(ptr, data, size);
		break;

	case 0x01:
		ptr = upa_packet_alloc_data_with_head(packet, size,
							HCI_EVENT_HDR_SIZE);
		memcpy(ptr, data, size);
		break;

	case 0x02:
	case 0x03:
		ptr = upa_packet_alloc_head(packet, HCI_ACLDATA_HDR_SIZE);
		memcpy(ptr, data, HCI_ACLDATA_HDR_SIZE);
		ptr = upa_packet_alloc_data(packet,
						size - HCI_ACLDATA_HDR_SIZE);
		memcpy(ptr, data + HCI_ACLDATA_HDR_SIZE,
						size - HCI_ACLDATA_HDR_SIZE);
		break;

	case 0xff:
		ptr = upa_packet_alloc_data(packet, size);
		memcpy(ptr, data, size);
		break;
	}

	return packet;
}
