# -*- coding: utf-8 -*-

# Bluemindo: A really simple but powerful audio player in Python/PyGTK.
# Copyright (C) 2007-2009  Erwan Briand

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3 of the License.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gettext import gettext as _
from gtk.glade import XML as glade_XML
from gtk import WRAP_WORD
from ConfigParser import ConfigParser, DuplicateSectionError
from os.path import join
from os import getcwd

class Config:
    def __init__(self, plugin, notify, config_file, get_configuration):
        self.plugin = plugin
        self.notify = notify
        self.config_file = config_file
        self.get_configuration = get_configuration

    def save_config(self, name):
        if name == self.plugin['name']:
            entry = self.conf_widgets.get_widget('entry1')
            tview = self.conf_widgets.get_widget('textview1')
            spbutton = self.conf_widgets.get_widget('spinbutton1')

            title = entry.get_text()
            tbuff = tview.get_buffer()
            text = tbuff.get_text(tbuff.get_start_iter(), tbuff.get_end_iter())
            timeout = int(spbutton.get_value())

            configparser = ConfigParser()
            configparser.read(self.config_file)

            try:
                configparser.add_section(self.plugin['name'])
            except DuplicateSectionError:
                pass

            configparser.set(self.plugin['name'], 'title', title)
            configparser.set(self.plugin['name'], 'text', text)
            configparser.set(self.plugin['name'], 'timeout', timeout)

            configparser.write(open(self.config_file, 'w'))

            # Reload configuration
            newconf = self.get_configuration()
            self.notify._reload_conf(newconf)

    def configuration(self, args):
        (name, widgets) = args
        if name == self.plugin['name']:
            # Load the glade and put the vertical box in the module's
            # configuration one
            config = self.get_configuration()

            self.conf_widgets = glade_XML(join(getcwd(), 'plugins',
                                'notification', 'configuration.glade'),
                                'vbox1', domain='bluemindo')

            hbox = widgets.get_widget('hbox2')

            try:
                kids = hbox.get_children()
                hbox.remove(kids[2])
            except:
                pass

            hbox.add(self.conf_widgets.get_widget('vbox1'))

            entry = self.conf_widgets.get_widget('entry1')
            tview = self.conf_widgets.get_widget('textview1')
            spbutton = self.conf_widgets.get_widget('spinbutton1')
            label = self.conf_widgets.get_widget('label6')

            label.set_markup(_('Available tags:\n'
            '<b><tt>{title}</tt></b>\t\tInsert the title\n'
            '<b><tt>{artist}</tt></b>\tInsert the artist\n'
            '<b><tt>{album}</tt></b>\t\tInsert the album\n'
            '<b><tt>{comment}</tt></b>\tInsert the comment\n'
            '<b><tt>{genre}</tt></b>\t\tInsert the genre\n'
            '<b><tt>{year}</tt></b>\t\tInsert the year\n'
            '<b><tt>{track}</tt></b>\t\tInsert the track number\n'
            '<b><tt>{length}</tt></b>\tInsert the length'))

            spbutton.set_value(float(config['timeout']))
            entry.set_text(config['title'])

            tview.set_wrap_mode(WRAP_WORD)
            tbuff = tview.get_buffer()
            tbuff.set_text(config['text'])