'\"
'\" Copyright 2000 by Bell Labs Innovations for Lucent Technologies.
'\"
'\" Permission to use, copy, modify, and distribute this software and its
'\" documentation for any purpose and without fee is hereby granted, provided
'\" that the above copyright notice appear in all copies and that both that the
'\" copyright notice and warranty disclaimer appear in supporting documentation,
'\" and that the names of Lucent Technologies any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the software
'\" without specific, written prior permission.
'\"
'\" Lucent Technologies disclaims all warranties with regard to this software,
'\" including all implied warranties of merchantability and fitness.  In no event
'\" shall Lucent Technologies be liable for any special, indirect or
'\" consequential damages or any damages whatsoever resulting from loss of use,
'\" data or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or performance
'\" of this software.  
'\"
'\" The hierarchical table widget created by George Howlett.
'\"
.so man.macros
.HS hiertable BLT 
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
hiertable \- Create and manipulate hierarchical table widgets
.BE
.SH SYNOPSIS
\fBhiertable\fR \fIpathName \fR?\fIoptions\fR?
.SH DESCRIPTION
The \fBhiertable\fR widget displays a scrollable tree of entries, one
entry per line.  Each entry has a text label, an icon, and may have
children (sub-entries).  A button on the left side of the entry
controls whether its children are displayed.
.PP
Entries may have data fields associated with them.  Data fields are
displayed (as text or Tk image) in columns that can run vertically on
either side the entry.  Each column can have its own color, font, etc.
Any data field, including the entry's label, can be edited in-place.
.PP
Single or multiple entries can be selected.  Individual entries can be
hidden.  There is also a \fBfind\fR operation that can apply
operations to all entries that match user-specified criteria.
.SH INTRODUCTION
The hiertable widget represents an hierarchical table of data.  Each
row entry is a node in a general-ordered tree.  Entries are drawn with
both a text label and an icon.  An entry may have sub-entries or
\fIchildren\fR.  Each sub-entry in turn may have children.  Children
are revealed or hidden by opening or closing the entry.
.SH ENTRIES
Entries are uniquely identified by a serial number or \fIindex\fR.
Until an entry is deleted, its index is valid, even if the entry is
moved to another position within the tree.  Note that an index doesn't
indicate anything about the entry's relative position or order in the
tree.
.PP
If an entry has children, it is drawn with a button on its left side.
Clicking the mouse on this button opens or closes the sub-hierarchy.
When an entry is \fIopen\fR, its children are exposed.  When it is
\fIclosed\fR, they are hidden again.  The button is normally a
\f(CW+\fR or \f(CW\-\fR symbol (ala Windows Explorer), but can be
replaced with a pair of Tk images (open and closed images).
.PP
You can bind Tcl commands to be invoked when events occur on entries
(much like Tk canvas items).  You can bind an entry using its index or
its \fIbindtags\fR.  Bindtags are simply names that associate a
binding with one or more entries.  There is a built-in tag \f(CWall\fR
that all entries automatically have.
.PP
An entry can have an arbitrary number of \fIdata fields\fR.  A data
field is simply a name-value pair, representing some bit of data in
the entry.  The field names and their values are strings.  Entries are
not required to contain fields found in other entries.  For example,
each entry could have its own unique set of field names.
.SH "COLUMNS"
Data fields can be displayed in the widget in columns.  A column is
associated with a specific data field.  Each entry's value for that
field is drawn in a column along side the hierarchy.  Any entry that
doesn't have the specific field is left blank.  The widget has a
built-in column, named after the widget, that holds the tree.
.PP
You can control the appearance and location of any column.  The width
of a column is determined by the widest value in the column.  Users
can override the width of a column by grabbing a side of the column
and dragging it. Columns can be hidden or reordered.
.SH "LAZY INSERTION/DELETION OF ENTRIES"
In the case of a file browser, it doesn't make sense to load the
contents of the entire filesystem.  There can be tens of thousands of
entries and you really need to view only a small subset of those.  The
hiertable lets you do \fIlazy\fR insertion and deletion of entries.
This means that you insert entries for a particular directory only
when necessary.  
.PP
The hiertable can invoke Tcl procedures whenever an entry is opened
and/or closed.   This can allow entries to be inserted only for
that directory when needed.  At the same time, when an entry is
closed, its children can be removed, freeing memory and resources.
.SH "TREE DATA OBJECT"
Data is not stored directly in the \fBhiertable\fR widget.  Instead it
uses an external \fItree data object\fR to the represent the hierarchy
(see the \fBtree\fR manual entry for details).  You can create trees
and then attach the \fBhiertable\fR to them using the \fB\-tree\fR
configuration option.  
.PP
If no tree is specified, the widget automatically creates an new tree
(the tree's name is the widget's pathname).  The tree will
automatically contain one entry for the root node.  When the widget is
destroyed the tree is released.
.PP
While entries and their data can be added or deleted using various
widget operations, tree data objects themselves have both C and Tcl
interfaces.  If the tree is modified through one of these interfaces,
the widget is notified and will automatically redraw itself.
.SH EXAMPLE
The \fBhiertable\fR command creates a new hiertable widget.  
.DS
hiertable .h \-bg white
.DE
A new Tcl command \f(CW.h\fR is also created.  This command can be used
to query and modify the hiertable.  For example, to change the background
color of the table to "green", you use the new command and the widget's
\fBconfigure\fR operation.
.DS
# Change the background color.
\&.h configure \-background "green"
.DE
By default, the hiertable will automatically create a new tree object
to contain the data.  The name of the new tree is the pathname of the
widget.  Above, the new tree object name is ".h".  But you can use the
\fB\-tree\fR option to specify the name of another tree.
.DS
# View the tree "myTree".
\&.h configure \-tree "myTree"
.DE
When a new tree is created, it contains only a root entry.  The entry
is automatically opened.  The index of the root entry is always
\f(CW0\fR (you can use also use the index \f(CWroot\fR). The
\fBinsert\fR operation lets you insert one or more new entries into
the tree.  The last argument is the entry's \fIpathname\fR.  
.DS
# Create a new entry named "myEntry"
set index [\&.h insert end "myEntry"]
.DE
This appends a new entry named "myEntry".  It will positioned as the
last child of the root of the tree (using the position "end").  You
can supply another position to order the entry within its siblings.
.DS
# Prepend "fred".
set index [\&.h insert 0 "fred"]
.DE
Entry names do not need to be unique.  By default, the entry's label
is its name.  To supply a different text label, add the \fB\-label\fR
option.
.DS
# Create a new entry named "fred"
set index [\&.h insert end "fred" -label "Fred Flintstone"]
.DE
The \fBinsert\fR operation returns the index of the new node.  You can
also use the \fBindex\fR operation to get this information.
.DS
# Get the index of "fred"
\&.h index "fred"
.DE
To insert an entry somewhere other than root, use the \fB\-at\fR switch.
It takes the index of the entry where the new child will be added.
.DS
# Create a new entry "barney" in "fred".
\&.h insert -at $index end "barney" 
.DE
A pathname describes the path to an entry in the hierarchy.  It's a
list of entry names that compose the path in the tree.  Therefore, you
can also add "barney" to "fred" as follows.
.DS
# Create a new sub-entry of "fred"
\&.h insert end "fred barney" 
.DE
Every name in the list is ancestor of the next.  All ancestors must
already exist.  That means that an entry "fred" is an ancestor of
"barney" and must already exist.  But you can use the
\fB\-autocreate\fR configuration option to force the creation of
ancestor nodes.
.DS
# Force the creation of ancestors.
\&.h configure -autocreate yes 
\&.h insert end "fred barney wilma betty" 
.DE
Sometimes the pathname is already separated by a character sequence
rather than formed as a list.  A file name is a good example of this.
You can use the \fB\-separator\fR option to specify a separator string
to split the path into its components.  Each pathname inserted is
automatically split using the separator string as a separator.
Multiple separators are treated as one.
.DS
\&.h configure -separator /
\&.h insert end "/usr/local/tcl/bin" 
.DE
If the path is prefixed by extraneous characters, you can
automatically trim it off using the \fB\-trim\fR option.  It removed
the string from the path before it is parsed.
.DS
\&.h configure -trim C:/windows -separator /
\&.h insert end "C:/window/system" 
.DE
You can insert more than one entry at a time with the \fBinsert\fR
operation.  This can be much faster than looping over a list of names.
.DS
# The slow way
foreach f [glob $dir/*] {
    \&.h insert end $f
}
# The fast way
eval .h insert end [glob $dir/*]
.DE
In this case, the \fBinsert\fR operation will return a list of indices
of the new entries.
.PP
You can delete entries with the \fBdelete\fR operation.  It takes one or
more indices as its argument. It deletes the entry and all its
children.
.DS
\&.h delete $index
.DE
Entries have several configuration options.  They control the appearance
of the entry's icon and label.  We have already seen the \fB\-label\fR
option that sets the entry's text label.   The \fBentry configure\fR
operation lets you set or modify an entry's configuration options.
.DS
\&.h entry configure $index -color red -font fixed
.DE
You can hide an entry and its children using the \fB\-hide\fR option.
.DS
\&.h entry configure $index -hide yes
.DE
More that one entry can be configured at once.  All entries specified
are configured with the same options.
.DS
\&.h entry configure $i1 $i2 $i3 $i4 -color brown 
.DE
An icon is displayed for each entry.  It's a Tk image drawn to the
left of the label.  You can set the icon with the entry's
\fB\-icons\fR option.  It takes a list of two image names: one to
represent the open entry, another when it is closed.
.DS
set im1 [image create photo -file openfolder.gif]
set im2 [image create photo -file closefolder.gif]
\&.h entry configure $index -icons "$im1 $im2"
.DE
If \fB\-icons\fR is set to the empty string, no icons are display.
.PP
If an entry has children, a button is displayed to the left of the
icon. Clicking the mouse on this button opens or closes the
sub-hierarchy.  The button is normally a \f(CW+\fR or \f(CW\-\fR
symbol, but can be configured in a variety of ways using the \fBbutton
configure\fR operation.  For example, the \f(CW+\fR and \f(CW\-\fR
symbols can be replaced with Tk images.
.DS
set im1 [image create photo -file closefolder.gif]
set im2 [image create photo -file downarrow.gif]
\&.h button configure $index -images "$im1 $im2" \\
    -openrelief raised -closerelief raised
.DE
Entries can contain an arbitrary number of \fIdata fields\fR.  Data
fields are name-value pairs.  Both the value and name are strings.
The entry's \fB\-data\fR option lets you set data fields.
.DS
\&.h entry configure $index -data {mode 0666 group users}
.DE
The \fB\-data\fR takes a list of name-value pairs.  
.PP
You can display these data fields as \fIcolumns\fR in the
\fBhiertable\fR widget.  You can create and configure columns with
the \fBcolumn\fR operation.  For example, to add a new column to the
widget, use the \fBcolumn insert\fR operation.  The last argument is
the name of the data field that you want to display.
.DS
\&.h column insert end "mode"
.DE
The column title is displayed at the top of the column.  By default,
it's is the field name.  You can override this using the column's
\fB\-text\fR option.
.DS
\&.h column insert end "mode" -text "File Permissions"
.DE
Columns have several configuration options.  The \fBcolumn
configure\fR operation lets you query or modify column options.
.DS
\&.h column configure "mode" -justify left
.DE
The \fB\-justify\fR option says how the data is justified within in
the column.  The \fB\-hide\fR option indicates whether the column is
displayed.
.DS
\&.h column configure "mode" -hide yes
.DE
Entries can be selected by clicking on the mouse.  Selected entries
are drawn using the colors specified by the \fB\-selectforeground\fR 
and \fB\-selectbackground\fR configuration options.
The selection itself is managed by the \fBselection\fR operation.
.DS
# Clear all selections
\&.h selection clear 0 end
# Select the root node
\&.h selection set 0 
.DE
The \fBcurselection\fR operation returns a list of indices for
all selected entries.
.DS
set indices [\&.h curselection]
.DE
You can use the \fBget\fR operation to convert the indices to 
their pathnames.
.DS
set names [eval .h get -full $indices]
.DE
If an hiertable is exporting its selection (using the
\fB\-exportselection\fR option), then it will observe the standard X11
protocols for handling the selection.  Hiertable selections are
available as type \fBSTRING\fR; the value of the selection will be the
pathnames of the selected entries, separated by newlines.
.PP
The \fBhiertable\fR supports two modes of selection: \f(CWsingle\fR
and \f(CWmultiple\fR.  In single select mode, only one entry can be
selected at a time, while multiple select mode allows several entries
to be selected.  The mode is set by the widget's \fB\-selectmode\fR
option.
.DS
\&.h configure -selectmode "multiple"
.DE
You can be notified when the list of selected entries changes.  The widget's
\fB\-selectcommand\fR specifies a Tcl procedure that is called whenever
the selection changes.
.DS
proc SelectNotify { widget } {
   set indices [\&$widget curselection]
}
\&.h configure -selectcommand "SelectNotify .h"
.DE
The widget supports the standard Tk scrolling and scanning operations.
The \fBhiertable\fR can be both horizontally and vertically. You can
attach scrollbars to the \fBhiertable\fR the same way as the listbox
or canvas widgets.
.DS
scrollbar .xbar -orient horizontal -command ".h xview"
scrollbar .ybar -orient vertical -command ".h yview"
\&.h configure -xscrollcommand ".xbar set" \\
    -yscrollcommand ".ybar set"
.DE
There are three different modes of scrolling: \f(CWlistbox\fR,
\f(CWcanvas\fR, and \f(CWhierbox\fR.  In \f(CWlistbox\fR mode, the last
entry can always be scrolled to the top of the widget.  In \f(CWhierbox\fR
mode, the last entry is always drawn at the bottom of the widget.
The scroll mode is set by the widget's \fB\-selectmode\fR
option.
.DS
\&.h configure -scrollmode "listbox"
.DE
Entries can be programmatically opened or closed using the \fBopen\fR
and \fBclose\fR operations respectively.  
.DS
\&.h open $index
\&.h close $index
.DE
When an entry is opened, a Tcl procedure can be automatically invoked.
The \fB\-opencommand\fR option specifies this procedure.  This
procedure can lazily insert entries as needed.
.DS
proc AddEntries { dir } {
   eval .h insert end [glob -nocomplain $dir/*] 
}
\&.h configure -opencommand "AddEntries %P"
.DE
Now when an entry is opened, the procedure \f(CWAddEntries\fR is
called and adds children to the entry.  Before the command is invoked,
special "%" substitutions (like \fBbind\fR) are performed. Above,
\f(CW%P\fR is translated to the pathname of the entry.
.PP
The same feature exists when an entry is closed.  The
\fB\-closecommand\fR option specifies the procedure.
.DS
proc DeleteEntries { index } {
   .h entry delete $index 0 end
}
\&.h configure -closecommand "DeleteEntries %#"
.DE
When an entry is closed, the procedure \f(CWDeleteEntries\fR is called
and deletes the entry's children using the \fBentry delete\fR operation
(\f(CW%#\fR is the index of entry).
.SH SYNTAX
The \fBhiertable\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into an hiertable widget.
.DS
\fBhiertable \fIpathName \fR?\fIoption value\fR?...
.DE
Additional options, described above, may be specified on the command
line or in the option database to configure aspects of the hiertable
such as its colors, font, text, and relief.  The \fBhiertable\fR command
returns its \fIpathName\fR argument.  At the time this command is
invoked, there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.
.SH "HIERTABLE INDICES"
Each entry in the hiertable widget is identified by a unique
serial number or \fIindex\fR.  Many of the operations in the \fBhiertable\fR
widget take one or more indices as arguments.  You can use either the
entry's serial number or one of several special non-numeric indices
shown below.
.TP 15
\fInumber\fR 
Identifies the entry.  The number doesn't indicate the location or 
position an entry. For example, you can't determine the order of 
two entries from their node numbers.
Node \f(CW0\fR is always the root of the hierarchy.
.TP 15
\fBactive\fR
The entry where the mouse pointer is currently located.
When an entry is active, it is drawn using its active icon 
(see the \fB\-activeicon\fR option).
The \fBactive\fR index is changed automatically by moving the mouse
pointer over another entry or by using the \fBentry activate\fR
operation. Note that there can be only one active entry at a time.
.TP 15
\fBanchor\fR
The entry representing the fixed end of the current selection.  
The anchor is set by the \fBselection anchor\fR operation.
.TP 15
\fBcurrent\fR
The entry where the mouse pointer is currently located.
But unlike \fBactive\fR, this index changes while the
selection is dragged.  It is used to determine the
current entry during button drags.
.TP 15
\fBdown\fR
The next open entry from the current focus. The \fBdown\fR of
the last open entry is the same.
.TP 15
\fBend\fR
The last open entry (in depth-first order) on the tree.  
.TP 15
\fBfocus\fR
The entry that currently has focus.  When an entry has focus,
it receives key events.  To indicate focus, the entry
is drawn with a dotted line around its label.  You can change the 
focus using the \fBfocus\fR operation.
.TP 15
\fBlast\fR
The last open entry from the current focus. But unlike \fBup\fR,
when the focus is at root, \fBlast\fR wraps around to the last
open entry in the tree.
.TP 15
\fBmark\fR
The entry representing the non-fixed end of the current selection.  
The mark is set by the \fBselection mark\fR operation.
.TP 15
\fBnext\fR
The next open entry from the current focus.  But unlike \fBdown\fR,
when the focus is on last open entry, \fBnext\fR wraps around to the 
root entry.
.TP 15
\fBnextsibling\fR
The next sibling from the entry with the current focus.  If the entry
is already the last sibling then it is the \fBnextsibling\fB.
.TP 15
\fBparent\fR
The parent of the entry with the current focus. The \fBparent\fR
of the root is also the root.
.TP 15
\fBprevsibling\fR
The previous sibling from the entry with the current focus.  If the entry
is already the first sibling then it is the \fBprevsibling\fB.
.TP 15
\fBroot\fR
The root entry. You can also use index \f(CW0\fR to indicate
the root.
.TP 15
\fBup\fR
The last open entry (in depth-first order) from the current focus. The
\fBup\fR of the root entry (i.e. the root has focus) is also the root.
.TP 15
\fBview.top\fR
First entry that's current visible in the widget.
.TP 15
\fBview.bottom\fR
Last entry that's current visible in the widget.
.TP 15
\fIpath\fR 
Absolute path of an entry.  Path names refer to the node name, not
their entry labels. Paths don't have to start with a separator (see
the \fB\-separator\fR configuration option), but component names must
be separated by the designated separator.
.TP 15
\fB@\fIx\fB,\fIy\fR
Indicates the entry that covers the point in the hiertable window
specified by \fIx\fR and \fIy\fR (in pixel coordinates).  If no
entry covers that point, then the closest entry to that
point is used.
.LP
.SH "HIERTABLE OPERATIONS"
The \fBhiertable\fR operations have the invoked by specifying
the widget's pathname, the operation, and any arguments that pertain 
to that operation.  The general form is:
.sp
.CS
\fIpathName operation \fR?\fIarg arg ...\fR?
.CE
.sp
\fIOperation\fR and the \fIarg\fRs determine the exact behavior of the
command.  The following operation are available for hiertable widgets:
.TP
\fIpathName \fBbbox\fR ?\fB-screen\fR? \fIindex...\fR
Returns a list of 4 numbers, representing a bounding box of around
the specified entries. Each entry is given an \fIindex\fR.  
If the \fB\-screen\fR flag is given, then the x-y coordinates
of the bounding box are returned as screen coordinates, not 
virtual coordinates. Virtual coordinates start from \f(CW0\fR from the
root entry.
The returned list contains the following values.
.RS
.TP 1.25i
\fIx\fR 
X-coordinate of the upper-left corner of the bounding box.
.TP
\fIy\fR
Y-coordinate of the upper-left corner of the bounding box.
.TP
\fIwidth\fR
Width of the bounding box.
.TP
\fIheight\fR
Height of the bounding box.
.RE
.TP
\fIpathName \fBbind\fR \fItagName\fR ?\fIsequence command\fR?
Associates \fIcommand\fR with \fItagName\fR such that whenever the
event sequence given by \fIsequence\fR occurs for an entry with this
tag, \fIcommand\fR will be invoked.  The syntax is similar to the 
\fBbind\fR command except that it operates on \fBhiertable\fR entries, 
rather than widgets. See the \fBbind\fR manual entry for
complete details on \fIsequence\fR and the substitutions performed on 
\fIcommand\fR before invoking it.  
.sp
If all arguments are specified then a new binding is created, replacing 
any existing binding for the same \fIsequence\fR and \fItagName\fR.
If the first character of \fIcommand\fR is \f(CW+\fR then \fIcommand\fR 
augments an existing binding rather than replacing it. 
If no \fIcommand\fR argument is provided then the command currently
associated with \fItagName\fR and \fIsequence\fR (it's an error occurs 
if there's no such binding) is returned.  If both \fIcommand\fR and 
\fIsequence\fR are missing then a list of all the event sequences for 
which bindings have been defined for \fItagName\fR. 
.TP
\fIpathName \fBbutton \fIoperation\fR ?\fIargs\fR?
See the 
.SB "BUTTON OPERATIONS"
section below.
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBconfigure\fR
operation described below.
.TP
\fIpathName \fBclose \fR?\fB\-recurse\fR? \fIindex...\fR
Closes the entry specified by \fIindex\fR.  In addition, if a Tcl
script was specified by the \fB\-closecommand\fR option, it is
invoked.  If the entry is already closed, this command has no effect.
If the \fB\-recurse\fR flag is present, each child entry is
recursively closed.
.TP
\fIpathName \fBcolumn \fIoperation\fR ?\fIargs\fR?
See the 
.SB "COLUMN OPERATIONS"
section below.
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR and \fIvalue\fR are described below:
.RS
.TP
\fB\-activebackground \fIcolor\fR
Sets the background color for active entries.  An entry
is active when the mouse passes over it or using the 
\fBactivate\fR operation.  
.TP
\fB\-activeforeground \fIcolor\fR
Sets the foreground color for active entries.  An entry
is active when the mouse passes over it or using the 
\fBactivate\fR operation.  
.TP
\fB\-activeicons \fIimages\fR
Specifies images to be displayed for an entry's icon
when it is active. \fIImages\fR is a list of two Tk images: 
the first image is displayed when the entry is open, the
second when it is closed.
.TP
\fB\-autocreate \fIboolean\fR
Normally it is an error to insert an entry whose ancestors
do not already exist.  If \fIboolean\fR is true, it indicates 
to automatically create missing ancestor entries.  The default is 
\f(CWno\fR.
.TP
\fB\-allowduplicates \fIboolean\fR
Normally it is an error to insert an entry with the same
pathname as another entry.
If \fIboolean\fR is true, it indicates that duplicate entries 
should be allowed.  The default is \f(CWno\fR.
.TP
\fB\-background \fIcolor\fR
Sets the background color the hiertable.  The default is \f(CWwhite\fR.
.TP
\fB\-borderwidth \fIpixels\fR
Sets the width of the 3\-D border around the outside edge of the widget.  The
\fB\-relief\fR option determines if the border is to be drawn.  The
default is \f(CW2\fR.
.TP
\fB\-closecommand \fIstring\fR
Specifies a Tcl script to be invoked when an entry is closed.  Individual
entries may override this with their own \fB\-closecommand\fR option.
The default is \f(CW""\fR.
Percent substitutions are performed on \fIstring\fR before 
it is executed.  The following substitutions are valid:
.RS 
.TP 5
\f(CW%W\fR
The pathname of the widget.
.TP 5
\f(CW%p\fR
The name of the entry.
.TP 5
\f(CW%P\fR
The full pathname of the entry.
.TP 5
\f(CW%#\fR
The index of the node.
.TP 5
\f(CW%%\fR
Translates to a single percent.
.RE
.TP
\fB\-cursor \fIcursor\fR
Specifies the widget's cursor.  The default cursor is \f(CW""\fR.
.TP
\fB\-dashes \fInumber\fR
Sets the dash style of the horizontal and vertical lines drawn connecting 
entries. \fINumber\fR is the length in pixels which represents the lengths 
of the dashes and gaps.  If \fInumber\fR is \f(CW0\fR, solid lines will 
be drawn. The default is \f(CW1\fR.
.TP
\fB\-exportselection \fIboolean\fR 
Indicates if the selection is exported.  If an hiertable is exporting its
selection then it will observe the standard X11 protocols for handling
the selection.  Selections are available as type \fBSTRING\fR;
the value of the selection will be the text of the selected entries,
with newlines separating the entries.  The default is \f(CWno\fR.
.TP
\fB\-flat \fIboolean\fR
Indicates whether to display the tree as a flattened list. 
If \fIboolean\fR is true, then the hierarchy will be a list of full
paths for the entries.  This option also has affect on sorting. 
See the 
.SB "SORT OPERATIONS"
section for more information.
The default is \f(CWno\fR.
.TP
\fB\-focusdashes \fIdashList\fR 
Sets the dash style of the outline rectangle drawn around the focused
entry's label. \fINumber\fR is the length in pixels which represents
the lengths of the dashes and gaps.  If \fInumber\fR is \f(CW0\fR,
a solid line will be drawn. The default is \f(CW1\fR.
.TP
\fB\-focusforeground \fIcolor\fR 
Sets the color to draw the focus rectangle. This is the dotted
rectangle drawn around the entry currently accepting key events.
The default is \f(CWblack\fR.
.TP
\fB\-font \fIfontName\fR 
Specifies the font to use for entry labels.  Individual entries may
override this with their own \fB\-font\fR option.  The default is
\f(CW*-Helvetica-Bold-R-Normal-*-12-120-*\fR.
.TP
\fB\-foreground \fIcolor\fR 
Specifies the text color of entry labels.  Individual entries may
override this with their own \fB\-foreground\fR option.  The default is
\f(CWblack\fR.
.TP
\fB\-height \fIpixels\fR
Specifies the requested height of widget.  The default is
\f(CW400\fR.
.TP
\fB\-hideroot \fIboolean\fR
If \fIboolean\fR is true, it indicates that the root entry 
should no be displayed.  The default is \f(CWno\fR.
.TP 
\fB\-highlightbackground  \fIcolor\fR
Specifies the color to display in the traversal highlight region when
the \fBhiertable\fR does not have the input focus.  
.TP 
\fB\-highlightcolor \fIcolor\fR
Specifies the color to use for the traversal highlight rectangle that is
drawn around the widget when it has the input focus. 
The default is \f(CWblack\fR.
.TP 
\fB\-highlightthickness \fIpixels\fR
Specifies a non-negative value indicating the width of the highlight
rectangle to draw around the outside of the widget when it has the
input focus.
The value may have any of the forms acceptable to \fBTk_GetPixels\fR.
If the value is zero, no focus highlight is drawn around the widget.
The default is \f(CW2\fR.
.TP
\fB\-icons \fIimages\fR
Specifies images to be displayed for the entry's icon.
\fIImages\fR is a list of two Tk images: 
the first image is displayed when the entry is open, the
second when it is closed.
.TP
\fB\-linecolor \fIcolor\fR
Sets the color of lines drawn connecting entries.  
The default is \f(CWblack\fR.
.TP
\fB\-linespacing \fIpixels\fR
Sets the number of pixels spacing between entries.  
The default is \f(CW0\fR.
.TP
\fB\-linewidth \fIpixels\fR
Set the width of the lines drawn connecting entries.  If \fIpixels\fR
is \f(CW0\fR, no vertical or horizontal lines are drawn. 
The default is \f(CW1\fR.
.TP
\fB\-opencommand \fIstring\fR
Specifies a Tcl script to be invoked when an entry is open.  For
example, this may be used to populate the hierarchy as it is
traversed.  Individual entries may override this with their own
\fB\-opencommand\fR option.  The default is \f(CW""\fR.
Percent substitutions are performed on \fIstring\fR before 
it is executed.  The following substitutions are valid:
.RS 
.TP 5
\f(CW%W\fR
The pathname of the widget.
.TP 5
\f(CW%p\fR
The name of the entry.
.TP 5
\f(CW%P\fR
The full pathname of the entry.
.TP 5
\f(CW%#\fR
The index of the node.
.TP 5
\f(CW%%\fR
Translates to a single percent.
.RE
.TP
\fB\-relief \fIrelief\fR
Specifies the 3-D effect for the widget.  \fIRelief\fR
specifies how the hiertable should appear relative to widget it is packed
into; for example, \f(CWraised\fR means the hiertable should
appear to protrude.  The default is \f(CWsunken\fR.
.TP
\fB\-scrollmode \fImode\fR 
Specifies the style of scrolling to be used.  The following
styles are valid.  This is the default is \f(CWhierbox\fR.
.RS
.TP 1.25i
\f(CWlistbox\fR
Like the \fBlistbox\fR widget, the last entry can always be
scrolled to the top of the widget window.  This allows the scrollbar
thumb to shrink as the last entry is scrolled upward.
.TP 1.25i
\f(CWhierbox\fR
Like the \fBhierbox\fR widget, the last entry can only be
viewed at the bottom of the widget window.  The scrollbar
stays a constant size.  
.TP 1.25i
\f(CWcanvas\fR
Like the \fBcanvas\fR widget, the entries are bound within
the scrolling area. 
.RE
.TP 
\fB\-selectbackground \fIcolor\fR
Specifies the color to use when displaying background of selected
entries. The default is \f(CW#ffffea\fR.
.TP 
\fB\-selectborderwidth \fIpixels\fR
Specifies a non-negative value indicating the width
of the raised 3-D border to draw around the labels of selected entries.
The default is \f(CW0\fR.
.TP 
\fB\-selectcommand \fIstring\fR
Specifies a Tcl script to invoked when the set of selected
entries changes.
The default is \f(CW""\fR.
.TP
\fB\-selectforeground \fIcolor\fB
Specifies the color to use when drawing the labels of selected
entries. The default is \f(CWblack\fR.
.TP 
\fB\-selectmode \fImode\fR
Specifies the selection mode. If \fImode\fR is 
\f(CWsingle\fR, only one entry can be selected
at a time.  If \f(CWmultiple\fR more than one
entry can be selected.
The default is \f(CWsingle\fR.
.TP
\fB\-separator \fIstring\fR
Normally entry pathnames are Tcl lists, where each element is a path
component.  But if \fIstring\fR is not the empty string, it specifies 
a character sequence to use when spliting the path components.  The separator
may several characters (such as "::").  Multiple separator are treated
as one. The default is \f(CW""\fR.
.TP
\fB\-showtitles \fIboolean\fR
If \fIboolean\fR is false, it indicates that column titles should
not be displayed.  The default is \f(CWyes\fR.
.TP 
\fB\-sortselection \fIboolean\fR
Normally entries in the selection are ordered as they are selected.
If \fIboolean\fR is true, then the entries are ordered in the same
way they are currently displayed (depth-first or sorted).
The default is \f(CWno\fR.
.TP
\fB\-takefocus\fR \fIfocus\fR 
Provides information used when moving the focus from window to window
via keyboard traversal (e.g., Tab and Shift-Tab).  If \fIfocus\fR is
\f(CW0\fR, this means that this window should be skipped entirely during
keyboard traversal.  \f(CW1\fR means that the this window should always
receive the input focus.  An empty value means that the traversal
scripts make the decision whether to focus on the window.
The default is \f(CW"1"\fR.
.TP
\fB\-trim \fIstring\fR
Specifies leading characters to trim from entry pathnames before
parsing.  This only makes sense if the \fB\-separator\fR is also
set.  The default is \f(CW""\fR.
.TP
\fB\-width \fIpixels\fR
Specifies the requested width of the widget.  If \fIpixels\fR is 0,
then the with is computed from the contents of the hiertable. The
default is \f(CW200\fR.
.TP 
\fB\-xscrollcommand \fIstring\fR
Specifies the prefix for a command used to communicate with horizontal
scrollbars.  Whenever the horizontal view in the widget's window 
changes, the widget will generate a Tcl command by concatenating the 
scroll command and two numbers.  If this option is not specified, then 
no command will be executed.
.TP
\fB\-xscrollincrement\fR \fIpixels\fR
Specifies the horizontal scrolling distance. The default is 20 pixels.
.TP
\fB\-yscrollcommand \fIstring\fR
Specifies the prefix for a command used to communicate with vertical
scrollbars.   Whenever the vertical view in the widget's window 
changes, the widget will generate a Tcl command by concatenating the 
scroll command and two numbers.  If this option is not specified, then 
no command will be executed.
.TP
\fB\-yscrollincrement\fR \fIpixels\fR
Specifies the vertical scrolling distance. The default is 20 pixels.
.RE
.TP
\fIpathName \fBcurselection\fR
Returns a list containing the indices of
all of the entries in the hiertable that are currently selected.
If there are no entries selected in the hiertable then the empty
string is returned.
.TP
\fIpathName \fBdelete \fIindex\fR ?\fIindex...\fR?
Deletes one or more entries of the hiertable.  The 
entry given by \fIindex\fR and its children are deleted.
.TP
\fIpathName \fBentry \fIoperation\fR ?\fIargs\fR?
See the 
.SB "ENTRY OPERATIONS"
section.
.TP
\fIpathName \fBfind \fR?\fIflags\fR? \fIfirst\fR \fIlast\fR
Finds for all entries matching the criteria given by \fIflags\fR.  A
list of indices for all matching entries is returned. \fIFirst\fR and
\fIlast\fR are indices designating the range of the search in
depth-first order. If \fIlast\fR is before \fIfirst\fR, then entries
are searched in reverse order.  The valid flags are:
.RS
.TP 1.25i
\fB\-name\fI pattern\fR
Specifies pattern to match against entry names.
.TP 1.25i
\fB\-full\fI pattern\fR
Specifies pattern to match against entry pathnames.
.TP 1.25i
\fB\-\fIoption\fI pattern\fR
Specifies pattern to match against the entry's configuration option.
.TP 1.25i
\fB\-exact\fR
Patterns must match entries exactly.  The is the default.
.TP 1.25i
\fB\-glob\fR
Use global pattern matching.  Matching is done in a fashion
similar to that used by the C-shell.  For  the  two
strings  to match, their contents must be identical
except that the  following  special  sequences  may
appear in pattern:
.RS 
.TP 5
\f(CW*\fR
Matches  any  sequence  of  characters in
string, including a null string.
.TP 5
\f(CW?\fR
Matches any single character in string.
.TP 5
\f(CW[\fIchars\f(CW]\fR
Matches any character in the set given by \fIchars\fR. If a sequence of the
form \fIx\fR-\fIy\fR appears in \fIchars\fR, then any character between 
\fIx\fR and \fIy\fR,
inclusive, will match.
.TP 5
\f(CW\\\fIx\fR
Matches  the  single  character  \fIx\fR.  This
provides a way of  avoiding  the  special
interpretation of the characters \f(CW*?[]\\\fR in
the pattern.
.RE
.TP 1.25i
\fB\-regexp\fR
Use regular expression pattern matching (i.e. the same as implemented
by the \fBregexp\fR command).  
.TP 1.25i
\fB\-nonmatching\fR
Expose entries that don't match.  
.TP 1.25i
\fB\-exec\fI string\fR
Specifies a Tcl script to be invoked for each matching entry.
Percent substitutions are performed on \fIstring\fR before 
it is executed.  The following substitutions are valid:
.RS 
.TP 5
\f(CW%W\fR
The pathname of the widget.
.TP 5
\f(CW%p\fR
The name of the entry.
.TP 5
\f(CW%P\fR
The full pathname of the entry.
.TP 5
\f(CW%#\fR
The index of the node.
.TP 5
\f(CW%%\fR
Translates to a single percent.
.RE
.TP 1.25i
\fB\-count\fI number\fR
Stop searching after \fInumber\fR matches.
.TP 1.25i
\fB\-\-\fR
Indicates the end of flags.
.RE
.TP
\fIpathName \fBfocus \fR \fIindex\fR
Sets the focus to the entry given by \fIindex\fR.  When an entry
has focus, it can receive keyboard events.   
.TP
\fIpathName \fBget \fR?\fB\-full\fR? \fIindex\fR \fIindex\fR...
Translates indices to their entry names.  It returns a list of names 
for all the indices specified.  If the \fB\-full\fR
flag is set, then the full pathnames are returned.
.TP 
\fIpathName \fBhide \fR?\fBflags\fR? \fIindex\fR ?\fIindex...\fR?
Hides all entries matching the criteria given by \fIflags\fR.  The
search is performed recursively for each entry given by \fIindex\fR.
The valid flags are described below:
.RS
.TP 1.25i
\fB\-name\fI pattern\fR
Specifies pattern to match against entry names.
.TP 1.25i
\fB\-full\fI pattern\fR
Specifies pattern to match against entry pathnames.
.TP 1.25i
\fB\-\fIoption\fI pattern\fR
Specifies pattern to match against the entry's configuration option.
.TP 1.25i
\fB\-exact\fR
Match patterns exactly.  The is the default.
.TP 1.25i
\fB\-glob\fR
Use global pattern matching.  Matching is done in a fashion
similar to that used by the C-shell.  For  the  two
strings  to match, their contents must be identical
except that the  following  special  sequences  may
appear in pattern:
.RS 
.TP 5
\f(CW*\fR
Matches  any  sequence  of  characters in
string, including a null string.
.TP 5
\f(CW?\fR
Matches any single character in string.
.TP 5
\f(CW[\fIchars\f(CW]\fR
Matches any character in the set given by \fIchars\fR. If a sequence of the
form \fIx\fR-\fIy\fR appears in \fIchars\fR, then any character between 
\fIx\fR and \fIy\fR,
inclusive, will match.
.TP 5
\f(CW\\\fIx\fR
Matches  the  single  character  \fIx\fR.  This
provides a way of  avoiding  the  special
interpretation of the characters \f(CW*?[]\\\fR in
the pattern.
.RE
.TP 1.25i
\fB\-regexp\fR
Use regular expression pattern matching (i.e. the same as implemented
by the \fBregexp\fR command).  
.TP 1.25i
\fB\-nonmatching\fR
Hide entries that don't match.  
.TP 1.25i
\fB\-\-\fR
Indicates the end of flags.
.RE
.TP
\fIpathName \fBindex \fR?\fB\-at\fR \fIindex\fR? \fIstring\fR 
Returns the index of the entry specified by \fIstring\fR.  \fIString\fR
may be in any form listed under the 
.SB "HIERTABLE INDICES"
section above.
Some special indices are normally relative to the entry that 
has focus.  The \fB\-at\fR flag lets you select another entry.
.TP
\fIpathName \fBinsert \fR?\fB\-at \fIindex\fR? \fIposition\fR \fIpath\fR ?\fIoptions...\fR? ?\fIpath\fR? ?\fIoptions...\fR? 
Inserts one or more entries at \fIposition\fR.  \fIPosition\fR is the
location (number or \f(CWend\fR) where the new entries are added to
the parent entry.  \fIPath\fR is the pathname of the new entry.
Pathnames can be formated either as a Tcl list (each element is a path
component) or as a string separated by a special character sequence
(using the \fB\-separator\fR option).  Pathnames are normally
absolute, but the \fB\-at\fR switch lets you select a relative
starting point.  Its value is the index of the starting entry.  
.sp
All ancestors of the new entry must already exist, unless the
\fB\-autocreate\fR option is set.  It is also an error if an entry
already exists, unless the \fB\-allowduplicates\fR option is set.
.sp
\fIOption\fR and \fIvalue\fR may have any of the values accepted by the 
\fBentry configure\fR operation described in the
.SB "ENTRY OPERATIONS"
section below.  This command returns a list containing the indices of
the new entries.
.TP
\fIpathName \fBmove \fIindex\fR \fIhow\fR \fIdestIndex\fR
Moves the entry given by \fIindex\fR to the destination entry.  The
entry can not be an ancestor of the destination.  \fIDestIndex\fR is
the index of the destination entry and can not be the root of the
tree.  In conjunction with \fIhow\fR, it describes how the move is
performed.
.RS
.TP 8
\f(CWbefore\fR
Moves the entry before the destination entry.
.TP 8
\f(CWafter\fR
Moves the entry after the destination entry.
.TP 8
\f(CWinto\fR
Moves the entry to the end of the destination's list of children.
.RE
.TP
\fIpathName \fBnearest \fIx y\fR ?\fIvarName\fR?
Returns the index of the entry closest to the given X-Y screen
coordinate.  The optional argument \fIvarName\fR is the name of
variable which is set to either \f(CWbutton\fR or \f(CWselect\fR to
indicate over what part of the entry the coordinate lies.  
If the coordinate is not directly over any entry, then
\fIvarName\fR will contain the empty string.
.TP
\fIpathName \fBopen \fR?\fB\-recurse\fR? \fIindex...\fR
Opens the one or more entries specified by \fIindex\fR.  
If an entry is not already open, the Tcl script specified by the 
\fB\-opencommand\fR option is also invoked. If the \fB\-recurse\fR flag 
is set, then each child is recursively opened too.  
.TP
\fIpathName \fBrange\fR ?\fB-open\fR? \fIfirst last\fR
Returns the indices in depth-first order of the entries
between the \fIfirst\fR and \fIlast\fR indices.  If the \fB\-open\fR
flag is present, it indicates to consider only open entries.
If \fIlast\fR is before \fIfirst\fR, then the indices are
returned in reverse order.
.TP
\fIpathName \fBscan\fR \fIoption args\fR
This command implements scanning.  It has
two forms, depending on \fIoption\fR:
.RS
.TP
\fIpathName \fBscan mark \fIx y\fR
Records \fIx\fR and \fIy\fR and the current view in the hiertable
window;  used in conjunction with later \fBscan dragto\fR commands.
Typically this command is associated with a mouse button press in
the widget.  It returns an empty string.
.TP
\fIpathName \fBscan dragto \fIx y\fR.
Computes the difference between its \fIx\fR and \fIy\fR
arguments and the \fIx\fR and \fIy\fR arguments to the last
\fBscan mark\fR command for the widget.
It then adjusts the view by 10 times the
difference in coordinates.  This command is typically associated
with mouse motion events in the widget, to produce the effect of
dragging the list at high speed through the window.  The return
value is an empty string.
.RE
.TP
\fIpathName \fBsee\fR ?\fB\-anchor \fIanchor\fR? \fIindex\fR
Adjusts the view (visible entries) so that the entry given by \fIindex\fR
is visible in the widget window.  By default the entry is displayed
in the middle of the window.  This can changed using the \fB\-anchor\fR 
flag.  Its value is a Tk anchor position.
.TP
\fIpathName \fBselection \fIoption arg\fR
This command is used to adjust the selection within an hiertable.  It
has several forms, depending on \fIoption\fR:
.RS
.TP
\fIpathName \fBselection anchor \fIindex\fR
Sets the selection anchor to the entry given by \fIindex\fR.
.VS 8.0
If \fIindex\fR refers to a non-existent entry, then the closest
entry is used.
.VE
The selection anchor is the end of the selection that is fixed
while dragging out a selection with the mouse.
The index \fBanchor\fR may be used to refer to the anchor
entry.
.TP
\fIpathName \fBselection cancel\fR
Clears the temporary selection of entries back to the
current anchor.  Temporary selections are created by 
the \fBselection mark\fR operation.
.TP
\fIpathName \fBselection clear \fIfirst \fR?\fIlast\fR?
Removes the entries between \fIfirst\fR and \fIlast\fR
(inclusive) from the selection.  Both \fIfirst\fR and 
\fIlast\fR are indices representing a range of entries.
If \fIlast\fR isn't given, then only \fIfirst\fR is deselected.
Entries outside the selection are not affected.
.TP
\fIpathName \fBselection clearall\fR
Clears the entire selection.  
.TP
\fIpathName \fBselection mark \fIindex\fR
Sets the selection mark to the entry given by \fIindex\fR.  This
causes the range of entries between the anchor and the mark to be
temporarily added to the selection.  The selection mark is the end of
the selection that is fixed while dragging out a selection with the
mouse.  The index \fBmark\fR may be used to refer to the anchor entry.
.VS 8.0
If \fIindex\fR refers to a non-existent entry, then the mark
is ignored.
.VE
Resetting the mark will unselect
the previous range.  Setting the anchor finalizes the range.
.TP
\fIpathName \fBselection includes \fIindex\fR
Returns 1 if the entry indicated by \fIindex\fR is currently
selected, 0 if it isn't.
.TP
\fIpathName \fBselection present\fR
Returns 1 if any entries are currently selected and 0 otherwise.
.TP
\fIpathName \fBselection set \fIfirst \fR?\fIlast\fR?
Selects all of the entries in the range between
\fIfirst\fR and \fIlast\fR, inclusive, without affecting
the selection state of entries outside that range.
.TP
\fIpathName \fBselection toggle \fIfirst \fR?\fIlast\fR?
Selects/deselects entries in the range between
\fIfirst\fR and \fIlast\fR, inclusive, in the selection.
If an entry is in the selection, it is deselected, otherwise
it is selected.  
.RE
.TP 
\fIpathName \fBshow \fR?\fBflags\fR? \fIindex\fR ?\fIindex...\fR?
Exposes all entries matching the criteria given by \fIflags\fR.  This
is the inverse of the \fBhide\fR operation.  The search is performed
recursively for each entry given by \fIindex\fR.  The valid flags are
described below:
.RS
.TP 1.25i
\fB\-name\fI pattern\fR
Specifies pattern to match against entry names.
.TP 1.25i
\fB\-full\fI pattern\fR
Specifies pattern to match against entry pathnames.
.TP 1.25i
\fB\-\fIoption\fI pattern\fR
Specifies pattern to match against the entry's configuration option.
.TP 1.25i
\fB\-exact\fR
Match patterns exactly.  The is the default.
.TP 1.25i
\fB\-glob\fR
\fB\-glob\fR
Use global pattern matching.  Matching is done in a fashion
similar to that used by the C-shell.  For  the  two
strings  to match, their contents must be identical
except that the  following  special  sequences  may
appear in pattern:
.RS 
.TP 5
\f(CW*\fR
Matches  any  sequence  of  characters in
string, including a null string.
.TP 5
\f(CW?\fR
Matches any single character in string.
.TP 5
\f(CW[\fIchars\f(CW]\fR
Matches any character in the set given by \fIchars\fR. If a sequence of the
form \fIx\fR-\fIy\fR appears in \fIchars\fR, then any character between 
\fIx\fR and \fIy\fR,
inclusive, will match.
.TP 5
\f(CW\\\fIx\fR
Matches  the  single  character  \fIx\fR.  This
provides a way of  avoiding  the  special
interpretation of the characters \f(CW*?[]\\\fR in
the pattern.
.RE
.TP 1.25i
\fB\-regexp\fR
Use regular expression pattern matching (i.e. the same as implemented
by the \fBregexp\fR command).  
.TP 1.25i
\fB\-nonmatching\fR
Expose entries that don't match.  
.TP 1.25i
\fB\-\-\fR
Indicates the end of flags.
.RE
.TP
\fIpathName \fBsort\fR ?\fIflags\fR? \fIindex...\fR
Sorts the children for each entries specified by \fIindex\fR.  
By default, entries are sorted by name, but you can specify a 
Tcl proc to do your own comparisons.
.RS
.TP 1.25i
\fB\-command\fI string\fR
Specifies a Tcl proc to use to compare entries when sorting.  The
procedure is called with three arguments: the pathname of the widget
and the indices of two entries.  The procedure returns 1 if the first
entry is greater than the second, -1 is the second is greater, and 0
if equal.
.TP 1.25i
\fB\-recurse\fR
Recursively sort the entire branch, not just the children.
.RE
.TP
\fIpathName \fBtext \fIoperation\fR ?\fIargs\fR?
See the 
.SB "TEXT OPERATIONS"
section.
.TP
\fIpathName \fBtoggle \fIindex\fR
Opens or closes the entry given by \fIindex\fR.  If the corresponding 
\fB\-opencommand\fR or \fB\-closecommand\fR option is set, then that
command is also invoked. 
.TP
\fIpathName \fBxview \fIargs\fR
This command is used to query and change the horizontal position of the
information in the widget's window.  It can take any of the following
forms:
.RS
.TP
\fIpathName \fBxview\fR
Returns a list containing two elements.
Each element is a real fraction between 0 and 1;  together they describe
the horizontal span that is visible in the window.
For example, if the first element is .2 and the second element is .6,
20% of the hiertable's text is off-screen to the left, the middle 40% is visible
in the window, and 40% of the text is off-screen to the right.
These are the same values passed to scrollbars via the \fB\-xscrollcommand\fR
option.
.TP
\fIpathName \fBxview\fR \fIindex\fR
Adjusts the view in the window so that the character position given by
\fIindex\fR is displayed at the left edge of the window.
Character positions are defined by the width of the character \fB0\fR.
.TP
\fIpathName \fBxview moveto\fI fraction\fR
Adjusts the view in the window so that \fIfraction\fR of the
total width of the hiertable text is off-screen to the left.
\fIfraction\fR must be a fraction between 0 and 1.
.TP
\fIpathName \fBxview scroll \fInumber what\fR
This command shifts the view in the window left or right according to
\fInumber\fR and \fIwhat\fR.
\fINumber\fR must be an integer.
\fIWhat\fR must be either \fBunits\fR or \fBpages\fR or an abbreviation
of one of these.
If \fIwhat\fR is \fBunits\fR, the view adjusts left or right by
\fInumber\fR character units (the width of the \fB0\fR character)
on the display;  if it is \fBpages\fR then the view adjusts by
\fInumber\fR screenfuls.
If \fInumber\fR is negative then characters farther to the left
become visible;  if it is positive then characters farther to the right
become visible.
.RE
.TP
\fIpathName \fByview \fI?args\fR?
This command is used to query and change the vertical position of the
text in the widget's window.
It can take any of the following forms:
.RS
.TP
\fIpathName \fByview\fR
Returns a list containing two elements, both of which are real fractions
between 0 and 1.
The first element gives the position of the hiertable entry at the
top of the window, relative to the hiertable as a whole (0.5 means
it is halfway through the hiertable, for example).
The second element gives the position of the hiertable entry just after
the last one in the window, relative to the hiertable as a whole.
These are the same values passed to scrollbars via the \fB\-yscrollcommand\fR
option.
.TP
\fIpathName \fByview\fR \fIindex\fR
Adjusts the view in the window so that the entry given by
\fIindex\fR is displayed at the top of the window.
.TP
\fIpathName \fByview moveto\fI fraction\fR
Adjusts the view in the window so that the entry given by \fIfraction\fR
appears at the top of the window.
\fIFraction\fR is a fraction between 0 and 1;  0 indicates the first
entry in the hiertable, 0.33 indicates the entry one-third the
way through the hiertable, and so on.
.TP
\fIpathName \fByview scroll \fInumber what\fR
This command adjusts the view in the window up or down according to
\fInumber\fR and \fIwhat\fR.
\fINumber\fR must be an integer.
\fIWhat\fR must be either \fBunits\fR or \fBpages\fR.
If \fIwhat\fR is \fBunits\fR, the view adjusts up or down by
\fInumber\fR lines;  if it is \fBpages\fR then
the view adjusts by \fInumber\fR screenfuls.
If \fInumber\fR is negative then earlier entrys
become visible;  if it is positive then later entrys
become visible.
.RE
.SH "GLOBAL VS. LOCAL ATTRIBUTES"
Many configuration options in the \fBhiertable\fR widget can be set
globally or locally.  For example, there is a \fB\-closecommand\fR
configuration option for both widget and individual entries.  Options
set at the widget level are global for all entries.  If the entry
option is set, it overrides the global widget option.  This is done to
avoid wasting memory by replicated options. Most entries will have
redundant options.
.SH "ENTRY OPERATIONS"
The following entry operations are available.
.TP
\fIpathName \fBentry activate\fR \fIindex\fR
Sets the active entry to \fIindex\fR.  \fIIndex\fR is an entry index.
When an entry is active it is drawn using its active icon 
(see the \fB\-activeicon\fR option). 
Note that there can be only one active entry at a time.
The index of the currently active entry is \fBactive\fR.
.TP
\fIpathName \fBentry cget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBconfigure\fR
operation described below.
.TP
\fIpathName \fBentry children\fR \fIindex\fR  ?\fIfirst\fR? ?\fIlast\fR?
Returns a list of indices for the given range of children of \fIindex\fR.  
\fIIndex\fR is index of the entry to be examined.
If only a \fIfirst\fR argument is present, then the index 
of the that child at that numeric position is returned.  If both \fIfirst\fR 
and \fIlast\fR arguments are given, then the indices of all the children
in that range are returned.  Otherwise the indices of all children
are returned.  
.TP
\fIpathName \fBentry configure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR and \fIvalue\fR are described below:
.RS
.TP
\fB\-activeicons \fIimages\fR
Specifies images to be displayed for the entry's icon
when it is active. This overrides the global \fB\-activeicons\fR
configuration option for the specific entry.
\fIImages\fR is a list of two Tk images: 
the first image is displayed when the entry is open, the
second when it is closed.
.TP
\fB\-bindtags \fItagList\fR
Specifies the binding tags for entries.  \fITagList\fR is a list
of binding tag names.  The tags and their order will determine how
events are handled for entries.  Each tag in the list matching the current 
event sequence will have its Tcl command executed.  The default value 
is \f(CWall\fR.
.TP
\fB\-button \fIstring\fR
Indicates whether a button should be displayed on the left side
of the entry.  \fIString\fR can be \f(CWyes\fR, \f(CWno\fR, 
or \f(CWauto\fR.  If \f(CWauto\fR, then a button is automatically
displayed if the entry has children.  This is the default.
This is typically used when performing lazy insertions.  An
entry may require a button, while it has no children yet.
.TP
\fB\-closecommand \fIstring\fR
Specifies a Tcl script to be invoked when the entry is closed.  This
overrides the global \fB\-closecommand\fR option for this entry.
The default is \f(CW""\fR.
Percent substitutions are performed on \fIstring\fR before 
it is executed.  The following substitutions are valid:
.RS 
.TP 5
\f(CW%W\fR
The pathname of the widget.
.TP 5
\f(CW%p\fR
The name of the entry.
.TP 5
\f(CW%P\fR
The full pathname of the entry.
.TP 5
\f(CW%#\fR
The index of the node.
.TP 5
\f(CW%%\fR
Translates to a single percent.
.RE
.TP
\fB\-data \fIstring\fR
Sets data fields for the entry.  \fIString\fR is a list of 
name-value pairs to be set.  Entries are not required to 
contain the same fields.
The default is \f(CW""\fR.
.TP
\fB\-font \fIfontName\fR 
Specifies the font to use for entry labels.  Individual entries may
override this with their own \fB\-font\fR option.  The default is
\f(CW*-Helvetica-Bold-R-Normal-*-12-120-*\fR.
.TP
\fB\-foreground \fIcolor\fR 
Specifies the text color of the entry label.  This overrides 
the global \fB\-foreground\fR configuration option.  The default is
\f(CW""\fR.
.TP
\fB\-icons \fIimages\fR
Specifies images to be displayed for the entry's icon.
This overrides the global \fB\-icons\fR configuration option.
\fIImages\fR is a list of two Tk images: 
the first image is displayed when the entry is open, the
second when it is closed.
.TP
\fB\-label \fIstring\fR
Sets the text displayed in the entry's the label.  If not set, this 
defaults to the name of the entry.  \fIString\fR may contain newlines
but not tabs.  The default is \f(CW""\fR.
.TP
\fB\-opencommand \fIstring\fR
Specifies a Tcl script to be invoked when thex entry is open.  For
example, this may be used to populate the hierarchy as it is
traversed.  This overrides the global \fB\-opencommand\fR option.  
The default is \f(CW""\fR.
Percent substitutions are performed on \fIstring\fR before 
it is executed.  The following substitutions are valid:
.RS 
.TP 5
\f(CW%W\fR
The pathname of the widget.
.TP 5
\f(CW%p\fR
The name of the entry.
.TP 5
\f(CW%P\fR
The full pathname of the entry.
.TP 5
\f(CW%#\fR
The index of the node.
.TP 5
\f(CW%%\fR
Translates to a single percent.
.RE
.RE
.TP
\fIpathName \fBentry delete\fR \fIindex\fR ?\fIfirst\fR ?\fIlast\fR?
Deletes the one or more children of the entry given by \fIindex\fR.
If present, \fIfirst\fR and \fIlast\fR are the positions designating
a range of children nodes to be deleted.
.TP
\fIpathName \fBentry isbefore \fIindex1\fR  \fIindex2\fR
Returns 1 if \fIindex1\fR is before \fIindex2\fR and 0 otherwise.
.TP
\fIpathName \fBentry ishidden \fIindex\fR
Returns 1 if the entry is currently hidden and 0 otherwise.  An
entry is not hidden if all of its ancestor entries are open.
.TP
\fIpathName \fBentry isopen \fIindex\fR
Returns 1 if the entry is currently open and 0 otherwise.
.TP
\fIpathName \fBentry size\fR \fB\-recurse\fR \fIindex\fR
Returns the number of children at \fIindex\fR.  
If the \fB\-recurse\fR flag is set, then number of entries
in the entire branch is returned.  The entry \fIindex\fR is
not counted.
.RE
.SH "BUTTON OPERATIONS"
The following operation are available for hiertable buttons.
.TP
\fIpathName \fBbutton activate\fR \fIindex\fR
Sets the active entry to \fIindex\fR.  \fIIndex\fR is an entry index.
When an entry is active it is drawn using its active icon 
(see the \fB\-activeicon\fR option). 
Note that there can be only one active entry at a time.
The index of the currently active entry is \fBactive\fR.
.TP
\fIpathName \fBbutton bind\fR \fItagName\fR ?\fIsequence command\fR?
Associates \fIcommand\fR with \fItagName\fR such that whenever the
event sequence given by \fIsequence\fR occurs for an button of an
entry with this tag, \fIcommand\fR will be invoked.  The syntax is
similar to the \fBbind\fR command except that it operates on
\fBhiertable\fR entries, rather than widgets. See the \fBbind\fR
manual entry for complete details on \fIsequence\fR and the
substitutions performed on \fIcommand\fR before invoking it.
.sp
If all arguments are specified then a new binding is created, replacing 
any existing binding for the same \fIsequence\fR and \fItagName\fR.
If the first character of \fIcommand\fR is \f(CW+\fR then \fIcommand\fR 
augments an existing binding rather than replacing it. 
If no \fIcommand\fR argument is provided then the command currently
associated with \fItagName\fR and \fIsequence\fR (it's an error occurs 
if there's no such binding) is returned.  If both \fIcommand\fR and 
\fIsequence\fR are missing then a list of all the event sequences for 
which bindings have been defined for \fItagName\fR. 
.TP
\fIpathName \fBbutton cget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBconfigure\fR
operation described below.
.TP
\fIpathName \fBbutton configure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR and \fIvalue\fR are described below:
.RS
.TP
\fB\-activebackground \fIcolor\fR
Sets the background color for active buttons.  An button
is active when the mouse passes over it or using the 
\fBbutton activate\fR operation.  
.TP
\fB\-activeforeground \fIcolor\fR
Sets the foreground color for active buttons.  An entry
is active when the mouse passes over it or using the 
\fBbutton activate\fR operation.  
.TP
\fB\-background \fIcolor\fR
Sets the background of the button.  The default is \f(CWwhite\fR.
.TP
\fB\-borderwidth \fIpixels\fR
Sets the width of the 3\-D border around the outside edge of the button.  
The \fB\-relief\fR option determines if the border is to be drawn.  The
default is \f(CW1\fR.
.TP
\fB\-closerelief \fIrelief\fR
Specifies the 3-D effect for the closed button.  \fIRelief\fR
specifies how the button should appear relative to the widget; 
for example, \f(CWraised\fR means the button should
appear to protrude.  The default is \f(CWsolid\fR.
.TP
\fB\-cursor \fIcursor\fR
Specifies the widget's cursor.  The default cursor is \f(CW""\fR.
.TP
\fB\-foreground \fIcolor\fR 
Specifies the foreground color of buttons. 
The default is \f(CWblack\fR.
.TP
\fB\-images \fIimages\fR
If set, specifies images to be displayed for the button.
\fIImages\fR is a list of two Tk images: 
the first image is displayed when the button is open, the
second when it is closed.  
.TP
\fB\-openrelief \fIrelief\fR
Specifies the 3-D effect for the open button.  \fIRelief\fR
specifies how the button should appear relative to the widget; 
for example, \f(CWraised\fR means the button should
appear to protrude.  The default is \f(CWflat\fR.
.TP
\fB\-size \fIpixels\fR
Sets the requested size for the button.  
The default is \f(CW0\fR.
.RE
.SH "COLUMN OPERATIONS"
The following operation are available for hiertable columns.
.TP
\fIpathName \fBcolumn activate\fR \fIcolumn\fR
Sets the active column to \fIcolumn\fR.  \fIColumn\fR is the
name of a column in the widget.
When a column is active, it's drawn using its \fB\-activetitlebackground\fR
and \fB\-activetitleforeground\fR options.  If \fIcolumn\fR is the \f(CW""\fR,
then no column will be active.  If no column argument is provided, then
the name of the currently active column is returned.
.TP
\fIpathName \fBcolumn cget\fR \fIname\fR \fIoption\fR
Returns the current value of the column configuration option given
by \fIoption\fR for \fIname\fR.  \fIName\fR is the name of column
that corresponds to a data field.
\fIOption\fR may have any of the values accepted by the \fBconfigure\fR
operation described below.
.TP
\fIpathName \fBcolumn configure\fR \fIname\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the column designated
by \fIname\fR. \fIName\fR is the name of the column corresponding
to a data field.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR and \fIvalue\fR are described below:
.RS
.TP
\fB\-background \fIcolor\fR
Sets the background of the column.  This overrides
the widget's \fB\-background\fR. The default is \f(CWwhite\fR.
.TP
\fB\-borderwidth \fIpixels\fR
Sets the width of the 3\-D border around the outside edge of the column.  
The \fB\-relief\fR option determines if the border is to be drawn.  The
default is \f(CW0\fR.
.TP
\fB\-edit \fIboolean\fR
Indicates whether the column data fields can be editted. If \fIboolean\fR is 
false, the column data fields in the column may not be edited.
The default is \f(CWyes\fR.
.TP
\fB\-foreground \fIcolor\fR 
Specifies the foreground color of the data fields in the column. 
Individual entries may override this with their own \fB\-foreground\fR option.
The default is \f(CWblack\fR.
.TP
\fB\-font \fIfontName\fR 
Specifies the font to use for column data fields.  Individual entries may
override this with their own \fB\-font\fR option.  The default is
\f(CW*-Helvetica-Bold-R-Normal-*-12-120-*\fR.
.TP
\fB\-hide \fIboolean\fR
If \fIboolean\fR is true, then the column is not displayed.
The default is \f(CWyes\fR.
.TP
\fB\-justify \fIjustify\fR
Specifies how the column data fields title should be justified within
the column.  This matters only when the column is wider than the 
data field to be display.
\fIJustify\fR must be \f(CWleft\fR, \f(CWright\fR, or \f(CWcenter\fR.  
The default is \f(CWleft\fR.
.TP
\fB\-pad \fIpad\fR
Sets the padding to the left and right sides of the column.
\fIPad\fR can be a list of one or two screen distances.  If \fIpad\fR
has two elements, the left side of the legend is padded by the first
distance and the right side by the second.  If \fIpad\fR has just one
distance, both the left and right sides are padded evenly.  The
default is \f(CW2\fR.
.TP
\fB\-relief \fIrelief\fR
Specifies the 3-D effect for the column.  \fIRelief\fR
specifies how the button should appear relative to the widget; 
for example, \f(CWraised\fR means the column should
appear to protrude.  The default is \f(CWflat\fR.
.TP
\fB\-state \fIstate\fR
Sets the state of the column. If \fIstate\fR is \f(CWdisable\fR then
the column can not be activated nor invoked.
The default is \f(CWnormal\fR.
.TP
\fB\-text \fIstring\fR
Sets the title for the column.
The default is \f(CW""\fR.
.TP
\fB\-titleforeground \fIcolor\fR 
Specifies the foreground color of the column title. 
The default is \f(CWblack\fR.
.TP
\fB\-titleshadow \fIcolor\fR 
Specifies the color of the drop shadow used for the column title.  
The default is \f(CW""\fR.
.TP
\fB\-width \fIpixels\fR
Specifies the requested width of the column.  This overriders
the computed with of the column.  If \fIpixels\fR is 0,
the width is computed as from the contents of the column. The
default is \f(CW0\fR.
.RE
.TP
\fIpathName \fBcolumn delete\fR \fIfield\fR ?\fIfield\fR...?
Deletes one of more columns designated by \fIfield\fR.  Note
that this does not delete the data fields themselves.
.TP
\fIpathName \fBcolumn insert\fR \fIposition\fR \fIfield\fR ?\fIoptions\fR...?
Inserts one of more columns designated by \fIfield\fR.  A column displays
each entry's data field by the same name.  Entries are not required
to have a data field.  In this case, the cell is left blank.
\fIPosition\fR
indicates where in the list of columns to add the new column.  It may be
either a number or \f(CWend\fR. 
.TP
\fIpathName \fBcolumn invoke\fR \fIfield\fR
Invokes the Tcl command associated with the column \fIfield\fR, 
if there is one (using the column's \fB\-command\fR option).  
The command is ignored if the column's \fB\-state\fR option 
set to \f(CWdisabled\fR.
.TP
\fIpathName \fBcolumn move \fIname\fR \fIdest\fR 
Moves the column \fIname\fR to the destination position.  
\fIDest\fR is the name of another column or a screen position
in the form \f(CW@\fIx\f(CW,\fIy\fR.
.TP
\fIpathName \fBcolumn names\fR
Returns a list of the names of all columns in the widget.
The list is ordered as the columns are drawn from left-to-right.
.TP
\fIpathName \fBcolumn nearest\fR \fIx\fR ?\fIy\fR?
Returns the name of the column closest to the given X-Y screen
coordinate.  If you provide a \fIy\fR argument (it's optional),
a name is returned only when if the point is over a column's title.
.SH "SORT OPERATIONS"
.TP
\fIpathName \fBsort auto\fR ?\fIboolean\fR
Turns on/off automatic sorting of entries.  If \fIboolean\fR is
true, entries will be automatically sorted as they are opened,
closed, inserted, or deleted.  If no \fIboolean\fR argument is
provided, the current state is returned.
.TP
\fIpathName \fBsort cget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBconfigure\fR
operation described below.
.TP
\fIpathName \fBsort configure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the sorting configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given sorting option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR and \fIvalue\fR are described below:
.RS
.TP
\fB\-column\fI string\fR
Specifies the column to sort. Entries in the widget are rearranged
according to this column.  If \fIcolumn\fR is \f(CW""\fR then
no sort is performed.
.TP
\fB\-command\fI string\fR
Specifies a Tcl procedure to be called when sorting entries. 
The procedure is called with three arguments: the pathname of the widget
and the fields of two entries.  The procedure returns 1 if the first
entry is greater than the second, -1 is the second is greater, and 0
if equal.  
.TP
\fB\-decreasing\fI boolean\fR
Indicates to sort in ascending/descending order.  If \fIboolean\fR 
is true, then the entries as in descending order. The default is 
\f(CWno\fR.
.TP
\fB\-mode\fI string\fR
Specifies how to compare entries when sorting. \fIString\fR
may be one of the following:
.RS 
.TP 1.5i
\f(CWascii\fR
Use string comparison based upon the ASCII collation order.
.TP 1.5i
\f(CWdictionary\fR 
Use dictionary-style comparison.  This is the same as \f(CWascii\fR
except (a) case is ignored except as a tie-breaker and (b) if two
strings contain embedded numbers, the numbers compare as integers, not
characters.  For example, "bigBoy" sorts between
"bigbang" and "bigboy", and "x10y" sorts between "x9y" and "x11y".
.TP 1.5i
\f(CWinteger\fR
Compares fields as integers.
.TP 1.5i
\f(CWreal\fR
Compares fields as floating point numbers.
.TP 1.5i
\f(CWcommand\fR
Use the Tcl proc specified by the \fB\-command\fR option to compare entries 
when sorting.   If no command is specified, the sort reverts to 
\f(CWascii\fR sorting.
.RE
.TP
\fIpathName \fBsort once\fR ?\fIflags\fR? \fIindex...\fR
Sorts the children for each entries specified by \fIindex\fR.  
By default, entries are sorted by name, but you can specify a 
Tcl proc to do your own comparisons.
.TP 1.25i
\fB\-recurse\fR
Recursively sort the entire branch, not just the children.
.RE
.SH "DEFAULT BINDINGS"
To be announced.
.PP
Tk automatically creates class bindings for hiertables that give them
Motif-like behavior.  Much of the behavior of an hiertable is determined
by its \fB\-selectmode\fR option, which selects one of two ways
of dealing with the selection.
.PP
If the selection mode is \fBsingle\fR, at most one entry can be 
selected in the hiertable at once.
Clicking button 1 on an entry selects
it and deselects any other selected item.
.PP
If the selection mode is \fBmultiple\fR,
any number of entries may be selected at once, including discontiguous
ranges.  Clicking Control-Button-1 on an entry
toggles its selection state without affecting any other entries.
Pressing Shift-Button-1 on an entry selects
it, extends the entry.
.PP
In addition to the above behavior, the following additional behavior
is defined by the default bindings:
.IP [1]
In \fBextended\fR mode, the selected range can be adjusted by pressing
button 1 with the Shift key down:  this modifies the selection to
consist of the entries between the anchor and the entry under
the mouse, inclusive.
The un-anchored end of this new selection can also be dragged with
the button down.
.IP [2]
In \fBextended\fR mode, pressing button 1 with the Control key down
starts a toggle operation: the anchor is set to the entry under
the mouse, and its selection state is reversed.  The selection state
of other entries isn't changed.
If the mouse is dragged with button 1 down, then the selection state
of all entries between the anchor and the entry under the mouse
is set to match that of the anchor entry;  the selection state of
all other entries remains what it was before the toggle operation
began.
.IP [3]
If the mouse leaves the hiertable window with button 1 down, the window
scrolls away from the mouse, making information visible that used
to be off-screen on the side of the mouse.
The scrolling continues until the mouse re-enters the window, the
button is released, or the end of the hiertable is reached.
.IP [4]
Mouse button 2 may be used for scanning.
If it is pressed and dragged over the hiertable, the contents of
the hiertable drag at high speed in the direction the mouse moves.
.IP [5]
If the Up or Down key is pressed, the location cursor (active
entry) moves up or down one entry.
If the selection mode is \fBbrowse\fR or \fBextended\fR then the
new active entry is also selected and all other entries are
deselected.
In \fBextended\fR mode the new active entry becomes the
selection anchor.
.IP [6]
In \fBextended\fR mode, Shift-Up and Shift-Down move the location
cursor (active entry) up or down one entry and also extend
the selection to that entry in a fashion similar to dragging
with mouse button 1.
.IP [7]
The Left and Right keys scroll the hiertable view left and right
by the width of the character \fB0\fR.
Control-Left and Control-Right scroll the hiertable view left and
right by the width of the window.
Control-Prior and Control-Next also scroll left and right by
the width of the window.
.IP [8]
The Prior and Next keys scroll the hiertable view up and down
by one page (the height of the window).
.IP [9]
The Home and End keys scroll the hiertable horizontally to
the left and right edges, respectively.
.IP [10]
Control-Home sets the location cursor to the the first entry in
the hiertable, selects that entry, and deselects everything else
in the hiertable.
.IP [11]
Control-End sets the location cursor to the the last entry in
the hiertable, selects that entry, and deselects everything else
in the hiertable.
.IP [12]
In \fBextended\fR mode, Control-Shift-Home extends the selection
to the first entry in the hiertable and Control-Shift-End extends
the selection to the last entry.
.IP [13]
In \fBmultiple\fR mode, Control-Shift-Home moves the location cursor
to the first entry in the hiertable and Control-Shift-End moves
the location cursor to the last entry.
.IP [14]
The space and Select keys make a selection at the location cursor
(active entry) just as if mouse button 1 had been pressed over
this entry.
.IP [15]
In \fBextended\fR mode, Control-Shift-space and Shift-Select
extend the selection to the active entry just as if button 1
had been pressed with the Shift key down.
.IP [16]
In \fBextended\fR mode, the Escape key cancels the most recent
selection and restores all the entries in the selected range
to their previous selection state.
.IP [17]
Control-slash selects everything in the widget, except in
\fBsingle\fR and \fBbrowse\fR modes, in which case it selects
the active entry and deselects everything else.
.IP [18]
Control-backslash deselects everything in the widget, except in
\fBbrowse\fR mode where it has no effect.
.IP [19]
The F16 key (labelled Copy on many Sun workstations) or Meta-w
copies the selection in the widget to the clipboard, if there is
a selection.

.PP
The behavior of hiertablees can be changed by defining new bindings for
individual widgets or by redefining the class bindings.

.SH KEYWORDS
hiertable, widget

