#!/usr/bin/env ruby
#
#    This program can be distributed under the terms of the GNU GPL.
#    See the file COPYING.
#
#    Author: Martin Prtel <martin.partel@gmail.com>
#

require 'common.rb'


# Some useful shorthands
nobody_uid = Etc.getpwnam('nobody').uid
nogroup_gid = Etc.getgrnam('nogroup').gid


# Let's start by checking that mounting works at all
testenv('mounting', "") do
    assert { File.basename(pwd) == TESTDIR_NAME }
end

# Setting the owner of files to nobody/nogroup
testenv('set_owner', "-u nobody -g nogroup") do
    touch('src/file')

    assert { File.stat('mnt/file').uid == nobody_uid }
    assert { File.stat('mnt/file').gid == nogroup_gid }
end

# Setting permission bits
testenv('permbits', "-p 0600:u+D") do
    touch('src/file')
    chmod(0777, 'src/file')

    assert { File.stat('mnt/file').mode & 0777 == 0600 }
end

# Setting the file owner
testenv('simple_pattern', "-u nobody") do
    touch('src/file')

    assert { File.stat('mnt/file').uid == nobody_uid }
end

# Test setting chmod policy
testenv('chmod_policy', "--chmod-deny") do
    touch('src/file')

    assert_exception(Errno::EPERM) { chmod(0777, 'mnt/file') }
end

# Test --mirror
testenv('mirror', "-u nobody -m #{Process.uid} -p 0600,u+D") do
    touch('src/file')

    assert { File.stat('mnt/file').uid == Process.uid }
end

# Test --create-with-perms
testenv('create_with_perms', "--create-with-perms=og=r:ogd+x") do
    touch('src/file')
    mkdir('src/dir')

    assert { File.stat('mnt/file').mode & 0077 == 0044 }
    assert { File.stat('mnt/dir').mode & 0077 == 0055 }
end
