/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Clib/ctrace.c                */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Fri Mar 31 18:06:36 1995                          */
/*    Last change :  Mon Dec 11 12:56:02 2000 (serrano)                */
/*    -------------------------------------------------------------    */
/*    We dump a execution trace                                        */
/*=====================================================================*/
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    Globals variables                                                */
/*---------------------------------------------------------------------*/
struct dframe *top_of_frame = 0L;
struct dframe frame;
static struct dframe top;

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    init_trace ...                                                   */
/*---------------------------------------------------------------------*/
void
init_trace()
{
   top.symbol = BUNSPEC;
   top.link   = 0;

   top_of_frame = &top;
}

/*---------------------------------------------------------------------*/
/*    dump_trace_stack ...                                             */
/*---------------------------------------------------------------------*/
obj_t
dump_trace_stack( obj_t port, int depth )
{
   long           level = 0L;
   struct dframe *runner = top_of_frame;
   obj_t          old = 0;
   int            recursion = 0;

   while( (level < depth) && runner && (runner != &frame) )
   {
      if( SYMBOLP( runner->symbol ) )
      {
	 if( EQP( runner->symbol, old ) )
	    recursion++, depth++;
	 else
	 {
	    if( recursion > 0 )
	       fprintf( OUTPUT_PORT( port ).file,
			" (%d times)\n",
			1 + recursion );
	    else
	    {
	       if( level > 0 )
		  fprintf( OUTPUT_PORT( port ).file, "\n" );
	    }
	    
	    fprintf( OUTPUT_PORT( port ).file,
		     "  %3ld. %s",
		     level,
		     BSTRING_TO_STRING( SYMBOL( runner->symbol ).string ) );
	    
	    recursion = 0;
	 }
	 old = runner->symbol;
			
	 level++; 
      }
      
      runner = runner->link;
   }
   fprintf( OUTPUT_PORT( port ).file, "\n" );
   
   return BUNSPEC;
}

/*---------------------------------------------------------------------*/
/*    cref ...                                                         */
/*---------------------------------------------------------------------*/
obj_t
cref( obj )
obj_t obj;
{
   return CREF( obj );
}

/*---------------------------------------------------------------------*/
/*    car ...                                                          */
/*---------------------------------------------------------------------*/
obj_t
car( obj_t obj )
{
   return CAR( obj );
}

/*---------------------------------------------------------------------*/
/*    cdr ...                                                          */
/*---------------------------------------------------------------------*/
obj_t
cdr( obj_t obj )
{
   return CDR( obj );
}

/*---------------------------------------------------------------------*/
/*    byteshow ...                                                     */
/*---------------------------------------------------------------------*/
static void
byteshow( unsigned char *addr )
{
#define PP_CHAR( c ) (((c) >= 33) && ((c) < 127)) ? c : '.'

   printf( "  %08lx  :  %02x %02x %02x %02x  :  %c%c%c%c\n",
           (unsigned long)addr,
           addr[ 0 ],
           addr[ 1 ],
           addr[ 2 ],
           addr[ 3 ],
           PP_CHAR( addr[ 0 ] ),
           PP_CHAR( addr[ 1 ] ),
           PP_CHAR( addr[ 2 ] ),
           PP_CHAR( addr[ 3 ] ) );
}
             
/*---------------------------------------------------------------------*/
/*    memshow ...                                                      */
/*---------------------------------------------------------------------*/
void
memshow( char *from, char *to, long step )
{
   char *i;

   step *= 4;
      
   if( from > to )
      for( i = from; i > to; i -= step )
         byteshow( (unsigned char *)i );
   else
      for( i = from; i < to; i += step )
         byteshow( (unsigned char *)i );

   puts( "" );
   return ;
}
