/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Clib/cdlopen.c               */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Thu Feb 17 14:34:53 2000                          */
/*    Last change :  Wed Jul 11 17:20:09 2001 (serrano)                */
/*    -------------------------------------------------------------    */
/*    The dlopen interface.                                            */
/*=====================================================================*/
#include <string.h>
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    static char *bgl_error;                                          */
/*---------------------------------------------------------------------*/
static char dload_error[ 81 ];

/*---------------------------------------------------------------------*/
/*    char *                                                           */
/*    bgl_dload_error ...                                              */
/*---------------------------------------------------------------------*/
char *
bgl_dload_error() {
   dload_error[ 80 ] = 0;
   return dload_error;
}

#if HAVE_DLOPEN
#include <dlfcn.h>
#ifndef RTLD_GLOBAL
#   define RTLD_GLOBAL 0
#endif
   
/*---------------------------------------------------------------------*/
/*    int                                                              */
/*    bgl_dload ...                                                    */
/*---------------------------------------------------------------------*/
int
bgl_dload( char *filename, char *init_sym ) {
   void *handle = dlopen( filename, RTLD_LAZY | RTLD_GLOBAL );

   if( !handle ) {
      char *error;
      
      if( (error = dlerror()) != NULL ) {
	 strncpy( dload_error, error, 80 );
      } else {
	 strcpy( dload_error, "dlopen error" );
      }
      return 1;
   } else {
      void (*init)() = dlsym( handle, init_sym );
      char *error;

      if( (error = dlerror()) != NULL ) {
	 strncpy( dload_error, error, 80 );
	 
	 return 2;
      } else {
	 init();
	 return 0;
      }
   }
}
#else
/*---------------------------------------------------------------------*/
/*    int                                                              */
/*    bgl_dload ...                                                    */
/*---------------------------------------------------------------------*/
int
bgl_dload( char *filename, char *init_sym ) {
   strcpy( dload_error, "Feature not supported" );
   
   return 3;
}
#endif
