;*=====================================================================*/
;*    .../prgm/project/bigloo/comptime/Globalize/integration.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jan 26 17:10:12 1995                          */
;*    Last change :  Mon May 15 07:51:01 2000 (serrano)                */
;*    Copyright   :  1995-2000 Manuel Serrano, see LICENSE file        */
;*    -------------------------------------------------------------    */
;*    The computation of the L property:                               */
;*    L(f,g) stand for `f be integrated in g ?'                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module globalize_integration
   (include "Tools/trace.sch")
   (import  tools_shape
	    type_type
	    ast_var
	    ast_node
	    globalize_ginfo
	    globalize_globalize
	    (union globalize_kapture))
   (export  (set-integration!)))

;*---------------------------------------------------------------------*/
;*    set-integration! ...                                             */
;*---------------------------------------------------------------------*/
(define (set-integration!)
   (trace (globalize 2) "set-integration!" #\Newline)
   ;; fist of all, we compute the transitive closure of `cfrom' for
   ;; all globalized function.
   (for-each set-cfrom*! *E*)
   (for-each set-cfrom*! *G1*)
   (trace (globalize 2)
	  "looping on: " (shape *E*) " " (shape *G1*)
	  #\Newline)
   ;; we can now compute the integration properties
   (let loop ((tg    *E*)    ;; the `true globalised'
	      (fg    *G1*)   ;; the `false globalised'
	      (round 0))
      (trace (globalize 2)
	     "  set-integration!    tg: " (shape tg) #\Newline
	     "                      fg: " (shape fg) #\Newline)
      ;; we mark tg locals
      (for-each (lambda (local)
		   (sfun/Ginfo-mark-set! (local-value local) round))
		tg)
      (let ((new-tg (get-new-tg tg fg round)))
	 (trace (globalize 2) "     new-tg: " (shape new-tg) #\Newline)
	 (if (null? new-tg)
	     ;; we have reached the fix point
	     (set-integrators! tg fg round)
	     ;; we have not reached the fix point we keep going
	     (let ((new-fg (get-new-fg fg round)))
		(trace (globalize 2) "     new-fg: "
		       (shape new-fg) #\Newline)
		(loop (append new-tg tg)
		      new-fg
		      (+fx round 1)))))))

;*---------------------------------------------------------------------*/
;*    set-cfrom*! ...                                                  */
;*---------------------------------------------------------------------*/
(define (set-cfrom*! local::local)
   (let ((info (local-value local)))
      (if (or (pair? (sfun/Ginfo-cfrom* info))
	      (null? (sfun/Ginfo-cfrom* info)))
	  (sfun/Ginfo-cfrom* info)
	  (begin
	     ;; we mark the function as seen
	     (sfun/Ginfo-cfrom*-set! info '())
	     (let loop ((cfrom      (sfun/Ginfo-cfrom info))
			(cfrom*-set '())
			(global     #f))
		(cond
		   ((null? cfrom)
		    (let ((res (let ((u (union cfrom*-set)))
				  (if (global? global)
				      (cons global u)
				      u))))
		       (trace (globalize 2) "     cfrom*( "
			      (shape local) " ): " (shape res)
			      #\Newline)
		       (sfun/Ginfo-cfrom*-set! info res)
		       res))
		   ((global? (car cfrom))
		    (loop (cdr cfrom)
			  cfrom*-set
			  (car cfrom)))
		   (else
		    (let ((cfrom* (set-cfrom*! (car cfrom))))
		       (if (and (pair? cfrom*) (global? (car cfrom*)))
			   (loop (cdr cfrom)
				 (cons (cons (car cfrom) (cdr cfrom*))
				       cfrom*-set)
				 (car cfrom*))
			   (loop (cdr cfrom)
				 (cons (cons (car cfrom) cfrom*)
				       cfrom*-set)
				 global))))))))))

;*---------------------------------------------------------------------*/
;*    get-new-tg ...                                                   */
;*    -------------------------------------------------------------    */
;*    Each functions of `fg' which is called by two functions (or      */
;*    more) functions of `tg' goes into `tg'.                          */
;*---------------------------------------------------------------------*/
(define (get-new-tg tg fg round)
   (let loop ((new-tg '())
	      (fg     fg))
      (if (null? fg)
	  new-tg
	  (let ((local (car fg)))
	     (trace (globalize 2) "      get-new-tg: " (shape local)
		    " ... "
		    (shape (sfun/Ginfo-cfrom* (local-value local)))
		    #\Newline)
	     (let liip ((cfrom (sfun/Ginfo-cfrom* (local-value local)))
			(new   0))
		(cond
		   ((null? cfrom)
		    (if (<fx new 2)
			;; no, it is not a new one
			(loop new-tg (cdr fg))
			;; yes, it is a a new one
			(begin
			   (sfun/Ginfo-mark-set! (local-value local)
						 (-fx round 1))
			   (loop (cons local new-tg) (cdr fg)))))
		   ((global? (car cfrom))
		    (liip (cdr cfrom) (+fx new 1)))
		   ((or (not (sfun/Ginfo-G? (local-value (car cfrom))))
			(<fx (sfun/Ginfo-mark (local-value (car cfrom)))
			     round))
		    ;; called by a non true globalised functions
		    (liip (cdr cfrom) new))
		   (else
		    (liip (cdr cfrom) (+fx new 1)))))))))

;*---------------------------------------------------------------------*/
;*    get-new-fg ...                                                   */
;*---------------------------------------------------------------------*/
(define (get-new-fg fg round)
   (let loop ((old-fg fg)
	      (new-fg '()))
      (cond
	 ((null? old-fg)
	  new-fg)
	 ((=fx (sfun/Ginfo-mark (local-value (car old-fg))) (-fx round 1))
	  (loop (cdr old-fg) new-fg))
	 (else
	  (loop (cdr old-fg) (cons (car old-fg) new-fg))))))

;*---------------------------------------------------------------------*/
;*    set-integrators! ...                                             */
;*    -------------------------------------------------------------    */
;*    This function set the `integrator' field of non globalized       */
;*    functions.                                                       */
;*---------------------------------------------------------------------*/
(define (set-integrators! tg fg round)
   (trace (globalize 2) "set-integrators: " (shape tg)
	  " " (shape fg) " " (shape round) #\Newline)
   (let loop ((roots tg))
      (if (null? roots)
	  'done
	  (let liip ((roots     roots)
		     (new-roots '()))
	     (if (null? roots)
		 (loop new-roots)
		 (let ((root (car roots)))
		    (let laap ((cto  (sfun/Ginfo-cto (local-value root)))
			       (new  new-roots))
		       (if (null? cto)
			   (liip (cdr roots) new)
			   (let* ((to   (car cto))
				  (info (local-value to)))
			      (cond
				 ((not (sfun/Ginfo-G? info))
				  ;; not a globalized function. We skip it
				  (laap (cdr cto) new))
				 ((=fx (sfun/Ginfo-mark info) round)
				  ;; this is a true globalized function,
				  ;; we skip it.
				  (laap (cdr cto) new))
				 ((local? (sfun/Ginfo-integrator info))
				  ;; this function has its intergrator, we
				  ;; skip it.
				  (laap (cdr cto) new))
				 (else
				  ;; the function is no more globalized
				  ;; because it is integrated
				  (sfun/Ginfo-G?-set! info #f)
				  (let ((integrator (get-integrator root)))
				     ;; we set its integrator
				     (sfun/Ginfo-integrator-set! info
								 integrator)
				     ;; we maintain the integrated list
				     (sfun/Ginfo-integrated-set!
				      (local-value integrator)
				      (cons to (sfun/Ginfo-integrated
						(local-value integrator)))))
				  (laap (cdr cto)
					(cons to new)))))))))))))

;*---------------------------------------------------------------------*/
;*    get-integrator ...                                               */
;*---------------------------------------------------------------------*/
(define (get-integrator local)
   (if (sfun/Ginfo-G? (local-value local))
       local
       (sfun/Ginfo-integrator (local-value local))))
				  

