;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bmacs/ude/ude-profile.el             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Aug 12 08:40:54 1998                          */
;*    Last change :  Mon Oct  4 18:10:16 1999 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The BEE profiler.                                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'ude-profile)
(require 'ude-config)
(require 'ude-custom)
(require 'ude-autoload)
(require 'ude-toolbar)

;*---------------------------------------------------------------------*/
;*    ude-compile-for-profile ...                                      */
;*---------------------------------------------------------------------*/
(defun ude-compile-for-profile ()
  (interactive)
  (let ((ude-compile-command (format "%s -f %s %s"
				     ude-make
				     ude-makefile
				     ude-makefile-profile-entry))
	(ude-compile-mode 'prof))
    (ude-compile)))

;*---------------------------------------------------------------------*/
;*    ude-compile-for-extra-profile ...                                */
;*---------------------------------------------------------------------*/
(defun ude-compile-for-extra-profile ()
  (interactive)
  (let ((ude-compile-command (format "%s -f %s %s"
				     ude-make
				     ude-makefile
				     ude-makefile-extra-profile-entry))
	(ude-compile-mode 'Xprof))
    (ude-compile)))

;*---------------------------------------------------------------------*/
;*    ude-compile-for-clean-profile ...                                */
;*---------------------------------------------------------------------*/
(defun ude-compile-for-clean-profile ()
  (interactive)
  (let ((ude-compile-command (format "%s -f %s %s"
				     ude-make
				     ude-makefile
				     ude-makefile-clean-profile-entry)))
    (ude-compile)))

;*---------------------------------------------------------------------*/
;*    ude-profile-default-args ...                                     */
;*---------------------------------------------------------------------*/
(defvar ude-profile-default-args "")

;*---------------------------------------------------------------------*/
;*    ude-global-profile-success-hook ...                              */
;*---------------------------------------------------------------------*/
(defvar ude-global-profile-success-hook nil)

;*---------------------------------------------------------------------*/
;*    ude-profile-load-hooks ...                                       */
;*---------------------------------------------------------------------*/
(defvar ude-profile-load-hooks nil)

;*---------------------------------------------------------------------*/
;*    ude-run-for-profile ...                                          */
;*---------------------------------------------------------------------*/
(defun ude-run-for-profile (arg)
  (interactive
   (let ((arg (read-string (format "Profiling run argument: [%s] "
				   ude-profile-default-args))))
     (list (if (and (stringp arg) (> (length arg) 0))
	       arg
	     ude-profile-default-args))))
  ;; we remember the buffer local highlighting function
  (setq ude-global-profile-success-hook ude-profile-success-hook)
  ;; we remember the run argument for later profile
  (setq ude-profile-default-args arg)
  ;; we setup success hook
  (ude-success-hook 'ude-profile-success)
  ;; the run for profiling
  (let* ((ude-compile-command (format "%s -f %s %s %s=\"%s\""
				      ude-make
				      ude-makefile
				      ude-makefile-run-profile-entry
				      ude-makefile-run-profile-args
				      arg))) 
    (ude-compile)))

;*---------------------------------------------------------------------*/
;*    ude-open-profile ...                                             */
;*---------------------------------------------------------------------*/
(defun ude-open-profile (fname)
  (interactive "Ffile name: ")
  (find-alternate-file fname)
  (ude-profile-init-toolbar (current-buffer))
  (run-hooks 'ude-profile-load-hooks))
  
;*---------------------------------------------------------------------*/
;*    ude-reload-profile ...                                           */
;*---------------------------------------------------------------------*/
(defun ude-reload-profile ()
  (interactive)
  (ude-open-profile (buffer-name)))
  
;*---------------------------------------------------------------------*/
;*    Various profile toolbar button                                   */
;*---------------------------------------------------------------------*/
(defvar ude-profile-stop-button
  (toolbar-make-button-list ude-stop-icon))
(defvar ude-record-button
  (toolbar-make-button-list ude-record-icon))
(defvar ude-profile-help-button
  (toolbar-make-button-list ude-help-icon))
(defvar ude-profile-quit-button
  (toolbar-make-button-list ude-quit-icon))
(defvar ude-profile-reload-button
  (toolbar-make-button-list ude-dbg-file-icon))
(defvar ude-profile-open-button
  (toolbar-make-button-list ude-open-icon))
(defvar ude-profile-compile-button
  (toolbar-make-button-list ude-profile-compile-icon))
(defvar ude-profile-extra-compile-button
  (toolbar-make-button-list ude-profile-extra-compile-icon))
(defvar ude-clean-button
  (toolbar-make-button-list ude-clean-icon))

;*---------------------------------------------------------------------*/
;*    ude-profile-opened-toolbar ...                                   */
;*---------------------------------------------------------------------*/
(defvar ude-profile-opened-toolbar 
  '(;;close button
    [ude-close-toolbar-button ude-close-profile-toolbar t "Close toolbar"]
    [:style 2d :size 2]
    
    ;; the quit button
    [ude-profile-quit-button delete-frame t "Close Profile Frame"]
    [:style 2d :size 2]

    ;; open profile button
    [ude-profile-reload-button ude-reload-profile t "Reload Profile"]
    [ude-profile-open-button ude-open-profile t "Open Profile"]
    [:style 2d :size 2]

    ;; compilation
    [ude-profile-compile-button ude-compile-for-profile t "Compile for profile"]
    [ude-profile-extra-compile-button ude-compile-for-extra-profile t "High profile Compile"]
    [:style 2d :size 2]

    ;; clean
    [ude-clean-button ude-compile-for-clean-profile t "Clean profile"]
    [:style 2d :size 2]
    
    ;; the record button
    [ude-record-button ude-run-for-profile t "Record execution"]
    [:style 2d :size 2]

    ;; flushing right
    nil
    [:style 2d :size 2]
    ;; the help action
    [ude-profile-help-button describe-mode t "Help"]))

;*---------------------------------------------------------------------*/
;*    ude-profile-closed-toolbar ...                                   */
;*---------------------------------------------------------------------*/
(defvar ude-profile-closed-toolbar
  '([ude-open-toolbar-button ude-open-profile-toolbar t "Open toolbar"]))

;*---------------------------------------------------------------------*/
;*    Opening/closing toolbars ...                                     */
;*---------------------------------------------------------------------*/
(defun ude-close-profile-toolbar ()
  (ude-open-close-toolbar ude-profile-closed-toolbar))

(defun ude-open-profile-toolbar ()
  (ude-open-close-toolbar ude-profile-opened-toolbar))

;*---------------------------------------------------------------------*/
;*    ude-profile-success ...                                          */
;*---------------------------------------------------------------------*/
(defun ude-profile-success (buffer msg)
  (setq ude-profile-success-hook ude-global-profile-success-hook)
  (if (functionp ude-profile-success-hook)
      (funcall ude-profile-success-hook buffer msg)))
      
;*---------------------------------------------------------------------*/
;*    ude-load-profile-file ...                                        */
;*---------------------------------------------------------------------*/
(defun ude-load-profile-file (buffer msg)
  ;; we load the PROF file
  (if (file-exists-p "PROF")
      ;; we have to fetch the function that highlight profile
      ;; buffer while we are in the source buffer because the
      ;; highlighting function is buffer local
      (let ((buffer (let ((buf (find-buffer-visiting "PROF")))
		      (if (bufferp buf)
			  (let ((win (get-buffer-window buf t)))
			    (if (windowp win)
				(progn
				  (select-window win)
				  (switch-to-buffer "*scratch*")))
			    (kill-buffer (buffer-name buf))
			    (find-alternate-file "PROF")
			    (current-buffer))
			(find-file-other-frame "PROF")))))
	(set-buffer buffer)
	(ude-profile-init-toolbar buffer)
	buffer)
    t))

;*---------------------------------------------------------------------*/
;*    ude-create-profile-buffer ...                                    */
;*---------------------------------------------------------------------*/
(defun ude-create-profile-buffer ()
  (let ((buffer (create-file-buffer "PROF")))
    (set-buffer buffer)
    (ude-profile-init-toolbar buffer)
    buffer))
    
;*---------------------------------------------------------------------*/
;*    ude-profile-init-toolbar ...                                     */
;*    -------------------------------------------------------------    */
;*    This hook simply set the UDE profile toolbar for the buffer      */
;*---------------------------------------------------------------------*/
(defun ude-profile-init-toolbar (buffer)
  (set-specifier default-toolbar-visible-p t)
  (set-specifier default-toolbar ude-profile-opened-toolbar buffer)
  buffer)

  



