;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bmacs/bee/bee-config.el              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon May 25 07:28:09 1998                          */
;*    Last change :  Thu Sep 27 06:38:50 2001 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The Bee configuration file.                                      */
;*    -------------------------------------------------------------    */
;*    Bdb configuration is set into bee-bdb.el                         */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'bee-config)
(require 'ude-custom)
(require 'dbg-config)

;; bee version
(defconst bee-version "0.3"
  "*The Bee version.")

;; bee group
(defgroup bee nil
  "Bigloo Emacs Environment."
  :tag "Bee"
  :prefix "bee-"
  :group 'processes)

;; online documentation info pages
(defcustom bee-info-file-list '("bigloo.info" "biglook.info" "r5rs.info")
  "*The info docline pages."
  :group 'bee
  :type '(repeat (string)))

;; compiler and interpreter
(defcustom bee-bigloo "bigloo"
  "*The name of the Bigloo compiler."
  :group 'bee
  :type 'string)

;; C extractor
(defcustom bee-cigloo "cigloo"
  "*The name of the Cigloo binary file."
  :group 'bee
  :type 'string)

;; indentation
(defcustom bee-external-indent "bpp"
  "*The external Bee indent program."
  :group 'bee
  :type 'string)

;; bigloo make-make
(defcustom bee-bmake "bmake"
  "*The name of the Bigloo Makefile generator.
Setting that variable must change the buffer local UDE-MAKEMAKE"
  :group 'bee
  :type 'string
  :set (lambda (symbol value)
	 (set-default symbol value)
	 (setq ude-makemake value)))

;; bee-bmake-application-option
(defcustom bee-bmake-application-option "-fapplication -main"
  "*The name of the bmake option to produce an application Makefile"
  :group 'bee
  :type 'string)

;; bee-bmake-library-option
(defcustom bee-bmake-library-option "-flibrary -heap"
  "*The name of the bmake option to produce a library Makefile"
  :group 'bee
  :type 'string)

;; compile configuration
(defcustom bee-compilation-font-lock-keywords
  '(("^#.*$" . font-lock-comment-face)
    ("^[^: ]+:$" . font-lock-function-name-face)
    ("^[^:]+:$" . font-lock-keyword-face)
    ("[0-9]+ error.? occured, ending.*$" . ude-error-face)
    ("Compilation finished.*$" . ude-ok-face))
  "The regular expressions for compilation font lock errors."
  :group 'bee)

(defcustom bee-error-regexp "^File \"\\([^\"]+\\)\", line \\([0-9]+\\)"
  "*The expression that matches Bigloo errors."
  :group 'bee
  :type 'string)

(defcustom bee-compilation-error-regexp-alist (list bee-error-regexp 1 2)
  "The expression for compilation errors."
  :group 'bee)

;; afile
(defcustom bee-afile-name ".afile"
  "*The name of the Bee afile file."
  :group 'bee
  :type 'string)

(defcustom bee-make-afile (concat ude-make " " bee-afile-name)
  "*The name of the command to build the afile."
  :group 'bee
  :type 'string)

;; tags
(defcustom bee-make-tags (concat ude-make " " ude-tagsfile-name)
  "*The name of the command to build the tagsfile."
  :group 'bee
  :type 'string)

;; profiling faces
(defcustom bee-ident-profile-face 'font-lock-function-name-face
  "The face to display Bigloo identifiers on profile."
  :group 'bee
  :type 'symbol)

(defcustom bee-module-profile-face 'ude-font-lock-face-1
  "The face to display Bigloo modules on profile."
  :group 'bee
  :type 'symbol)

(defface bee-c-profile-face
  '((((class color)) (:foreground "gray75" :bold nil))
    (t (:bold t)))
  "The face to display C identifiers on profile."
  :group 'bee)

;; user menu
(defcustom bee-user-menu nil
  "*Non-nil means a popup menu user part."
  :group 'bee
  :type 'boolean)

;; tmp dir (for macro expansion)
(defcustom bee-tmp-dir (let ((dir (getenv "TMPDIR")))
			 (if (stringp dir)
			     dir
			   "/tmp"))
  "*The tmp directory."
  :group 'bee
  :type 'string)

;; use highligh identifier to jump to definitions
(defcustom bee-tags-balloon-p t
  "*Non-nil means that identifier below the mouse are highlighed for
a short [find-definition] facility."
  :group 'bee
  :type 'boolean)

;; a name of a binary file that implements a Bigloo interface builder
(defcustom bee-interface-builder (file-installed-p "buildoo" exec-path)
  "*The name of an interace builder."
  :group 'bee
  :type '(choice (boolean) (string)))

;; the option to the interface builder when called from the bee
(defcustom bee-interface-builder-bee-options '("-no-event-loop" "--bee")
  "*The interface builder bee options"
  :group 'bee
  :type '(repeat (string)))

;; the file suffixes for interface file
(defcustom bee-interface-builder-suffix (list "bld")
  "*The suffix for interface builder files."
  :group 'bee
  :type '(repeat (string)))

;; a name of a binary file that implements a profiler
(defcustom bee-profiler (file-installed-p "kprof" exec-path)
  "*The name of a visual profiler."
  :group 'bee
  :type '(choice (boolean) (string)))

;; the option to the profiler when called from the bee
(defcustom bee-profiler-bee-options '("-no-event-loop" "--emacs")
  "*The profiler bee options"
  :group 'bee
  :type '(repeat (string)))

;; a name of a binary file that implements a bigloo browser
(defcustom bee-browser (file-installed-p "kbrowse" exec-path)
  "*The name of a visual browser."
  :group 'bee
  :type '(choice (boolean) (string)))

;; the kbrowse version we are configurated for
(defcustom bee-browser-version 2
  "*The version of kbrowse Bee is tuned for."
  :group 'bee
  :type '(choice (number)))

;; the option to the browser when called from the bee
(defcustom bee-browser-bee-options '("-no-event-loop" "--emacs")
  "*The browser bee options"
  :group 'bee
  :type '(repeat (string)))

;; a name of a binary file that implements the Bigloo debugger
(defcustom bee-kbdb (file-installed-p "kbdb" exec-path)
  "*The name of the Bigloo debugger."
  :group 'bee
  :type '(choice (boolean) (string)))

;; the options send to kbdb when called from the bee
(defcustom bee-kbdb-bee-options '("-no-event-loop" "--bee" "-mode" "scheme")
  "*The kbdb bee options"
  :group 'bee
  :type '(repeat (string)))

;; the name of the begoo binary file
(defcustom bee-begoo (file-installed-p "begoo" exec-path)
  "*The name of the Begoo tool."
  :group 'bee
  :type '(choice (boolean) (string)))

;; the name of the Makefile entry the delivers the name of the bmg file
(defcustom bee-begoo-getbmg-entry "getbegoo"
  "*The name of the Makefile entry that delivers the name of the bmg file."
  :group 'bee
  :type 'string)

;; the option to begoo when called from the bee
(defcustom bee-begoo-bee-options '("-no-event-loop" "--emacs")
  "*The Begoo bee options"
  :group 'bee
  :type '(repeat (string)))

;; select if when the import is clicked the whole module is import or
;; only the wanted binding
(defcustom bee-import-mode 'all
  "*The bee import mode"
  :group 'bee
  :type 'symbol)

;*---------------------------------------------------------------------*/
;*    bee-customize ...                                                */
;*    -------------------------------------------------------------    */
;*    This function invoked BEE customization in a new frame.          */
;*---------------------------------------------------------------------*/
(defun bee-customize ()
  "Invokes Ude customization in a new frame."
  (interactive)
  (if (ude-empty-window-p)
      (customize-group 'bee)
    (let ((pop-up-frames t))
      (customize-group-other-window 'bee))))

