/** 
 * @namespace   biewlib
 * @file        biewlib/sysdep/ia32/_inlines.h
 * @brief       This file includes 32-bit Intel architecture little inline functions.
 * @version     -
 * @remark      this source file is part of Binary vIEW project (BIEW).
 *              The Binary vIEW (BIEW) is copyright (C) 1995 Nick Kurshev.
 *              All rights reserved. This software is redistributable under the
 *              licence given in the file "Licence.en" ("Licence.ru" in russian
 *              translation) distributed in the BIEW archive.
 * @note        Requires POSIX compatible development system
 *
 * @author      Nick Kurshev
 * @since       2000
 * @note        Development, fixes and improvements
**/
#if !defined(__GNUC__) || !defined(__GNUC_MINOR__) || (__GNUC__ < 2 && __GNUC_MINOR__ < 5) || !defined(NDEBUG)
#include "biewlib/sysdep/generic/_inlines.h"
#else
#ifndef ___INLINES_H
#define ___INLINES_H 1

#define __NEAR__           /**< Obsolete for ia32 platform modifier of near call and data */
#define __FAR__            /**< Obsolete for ia32 platform modifier of far call and data */
#define __HUGE__           /**< Obsolete for ia32 platform modifier of huge pointer */
#define __INTERRUPT__      /**< Impossible for definition with gcc modifier of interrupt call */
#define halloc malloc      /**< For ia32 platform is alias of huge malloc */
#define hrealloc realloc   /**< For ia32 platform is alias of huge realloc */
#define hfree free         /**< For ia32 platform is alias of huge free */
#define HMemCpy memcpy     /**< For ia32 platform is alias of huge memcpy */

#ifdef __EXPERIMENTAL_VERSION
#define __FASTCALL__ __attribute__ (( __regparm__(3) , __stdcall__ )) /**< Fastcall modifier for ia32 */
#else
#define __FASTCALL__ __attribute__ (( __stdcall__ ))                  /**< Fastcall modifier for ia32 */
#endif
#define __NORETURN__ __attribute__ (( __noreturn__ ))                 /**< Noreturn modifier for ia32 */
#define __CONSTFUNC__ __attribute__ (( __const__ ))                   /**< Modifier of contant function for ia32 */
#ifdef __clpusplus
extern "C" {
#endif

                /** Changes byte order in 16-bit number */
__inline static unsigned short __FASTCALL__ __CONSTFUNC__ ByteSwapS(unsigned short _val)
{
  __asm("xchgb %b0,%h0"	:
        "=q" (_val)	:
        "0" (_val));
    return _val;
}

                /** Changes byte order in 32-bit number */
__inline static unsigned long __FASTCALL__ __CONSTFUNC__ ByteSwapL(unsigned long _val)
{
#if __CPU__ > 386
 __asm("bswap	%0"	:
      "=r" (_val)       :
#else
 __asm("xchgb	%b0,%h0\n"
      "	rorl	$16,%0\n"
      "	xchgb	%b0,%h0":
      "=q" (_val)	:
#endif
      "0" (_val));
  return _val;
}

#ifndef __BEOS__
                /** Translates byte via table lookup 
                  * @return         byte readed from table \e t at offset \e i
                  * @param t        pointer to 256-byte memory block from which will be readed byte
                  * @param i        index of memory block where byte is to be readed
                  * @warning        BEOS can not to process EBX in assembler statements
                **/
__inline static unsigned char __FASTCALL__ __CONSTFUNC__ __Xlat__(const unsigned char *_table,unsigned char _idx)
{
 __asm("xlatb"   :
      "=a" (_idx):
      "0"(_idx),
      "b"(_table));
  return _idx;
}
#else
#define __Xlat__(t,i) (t[i])
#endif

#ifdef __cplusplus
}
#endif

#endif
#endif
