#!/usr/bin/env python
# -*- coding: UTF-8 -*-
# generated by wxGlade 0.4.1 on Wed Jan 31 21:51:50 2007

import wx, copy

class JournalDialog(wx.Dialog):
	def __init__(self, *args, **kwds):
		# begin wxGlade: JournalDialog.__init__
		kwds["style"] = wx.DEFAULT_DIALOG_STYLE
		wx.Dialog.__init__(self, *args, **kwds)
		self.label_1 = wx.StaticText(self, -1, _("PubMed"))
		self.pubmed = wx.TextCtrl(self, -1, "")
		self.label_2 = wx.StaticText(self, -1, _("ISO"))
		self.iso = wx.TextCtrl(self, -1, "")
		self.label_3 = wx.StaticText(self, -1, _("Full"))
		self.full = wx.TextCtrl(self, -1, "", style=wx.TE_MULTILINE)
		self.button_Cancel = wx.Button(self, wx.ID_CANCEL, _("Cancel"))
		self.button_OK = wx.Button(self, wx.ID_OK, _("OK"))

		self.__set_properties()
		self.__do_layout()
		# end wxGlade

	def __set_properties(self):
		# begin wxGlade: JournalDialog.__set_properties
		self.SetTitle(_("Journal abbreviations"))
		self.SetSize((535, 197))
		self.button_OK.SetDefault()
		# end wxGlade

	def __do_layout(self):
		# begin wxGlade: JournalDialog.__do_layout
		sizer_2 = wx.BoxSizer(wx.VERTICAL)
		sizer_3 = wx.BoxSizer(wx.HORIZONTAL)
		grid_sizer_1 = wx.FlexGridSizer(3, 2, 5, 5)
		grid_sizer_1.Add(self.label_1, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_sizer_1.Add(self.pubmed, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_sizer_1.Add(self.label_2, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_sizer_1.Add(self.iso, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_sizer_1.Add(self.label_3, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_sizer_1.Add(self.full, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_sizer_1.AddGrowableCol(1)
		sizer_2.Add(grid_sizer_1, 1, wx.ALL|wx.EXPAND, 5)
		sizer_3.Add(self.button_Cancel, 0, wx.ADJUST_MINSIZE, 0)
		sizer_3.Add(self.button_OK, 0, wx.ADJUST_MINSIZE, 0)
		sizer_2.Add(sizer_3, 0, wx.TOP|wx.ALIGN_RIGHT, 10)
		self.SetSizer(sizer_2)
		self.Layout()
		# end wxGlade
		
	def setValues(self,pubmed,iso,full):
		self.pubmed.SetValue(pubmed)
		self.iso.SetValue(iso)
		self.full.SetValue(full)
		
	def getValues(self):
		return self.pubmed.GetValue(),self.iso.GetValue(),self.full.GetValue()

# end of class JournalDialog


class Pref_JournalsBase(wx.Panel):
	def __init__(self, *args, **kwds):
		# begin wxGlade: Pref_JournalsBase.__init__
		kwds["style"] = wx.TAB_TRAVERSAL
		wx.Panel.__init__(self, *args, **kwds)
		self.window_1 = ListJournals(self, journals)

		self.__set_properties()
		self.__do_layout()
		# end wxGlade

	def __set_properties(self):
		# begin wxGlade: Pref_JournalsBase.__set_properties
		pass
		# end wxGlade

	def __do_layout(self):
		# begin wxGlade: Pref_JournalsBase.__do_layout
		sizer_1 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_1.Add(self.window_1, 1, wx.EXPAND, 0)
		self.SetSizer(sizer_1)
		sizer_1.Fit(self)
		# end wxGlade

# end of class Pref_JournalsBase


class Pref_Journals(Pref_JournalsBase):
	def __init__(self, parent, id, journals):
		wx.Panel.__init__(self, parent, id, style = wx.TAB_TRAVERSAL)
		self.window_1 = ListJournals(self, journals)
		#self.__set_properties()
		self._Pref_JournalsBase__do_layout()
		
	def getSettings(self):
		return self.window_1.journals

class ListJournals(wx.ListCtrl):
	def __init__(self, parent, journals):
		wx.ListCtrl.__init__(self, parent, -1, style=wx.LC_REPORT|wx.LC_VIRTUAL) #|wx.LC_SINGLE_SEL|wx.LC_SORT_ASCENDING|wx.SUNKEN_BORDER)
		self.keys = journals.keys()
		self.keys.sort()
		self.journals = copy.deepcopy(journals)
		self.__set_layout()
		self.Bind(wx.EVT_LIST_ITEM_ACTIVATED, self.onActivate)
		self.Bind(wx.EVT_LIST_ITEM_RIGHT_CLICK, self.onRightClick)
		self.Bind(wx.EVT_LIST_KEY_DOWN, self.onKeyDown)
		
	def __set_layout(self):
		self.SetItemCount(len(self.keys))
		self.InsertColumn(0, _("PubMed journal name"))
		self.InsertColumn(1,_("ISO journal abbreviation"))
		self.InsertColumn(2,_("Full journal name"))
		width = self.GetParent().GetParent().GetParent().GetClientSizeTuple()[0]/3	# why self.GetClientSizeTuple() does not work ?
		for i in xrange(3):
			#self.SetColumnWidth(i,wx.LIST_AUTOSIZE_USEHEADER)
			self.SetColumnWidth(i,width)
		self.setPopMenu()
			
	def OnGetItemText(self, item, column):
		return self.journals[self.keys[item]][column]
		
	def editJournal(self,index):
		dlg = JournalDialog(self, -1)
		apply(dlg.setValues,self.journals[self.keys[index]])
		try:
			answer = dlg.ShowModal()
			if answer == wx.ID_OK:
				values = dlg.getValues()
				if self.keys[index] == values[0].upper():
					self.journals[self.keys[index]] = values
				else:
					self.journals[values[0].upper()] = values
					del self.journals[self.keys[index]]
					self.keys = self.journals.keys()
					self.keys.sort()
					newindex = self.keys.index(values[0].upper())
					self.RefreshItems(min(index,newindex),max(index,newindex))
		finally:
			dlg.Destroy()

	def onActivate(self,evt):
		self.editJournal(evt.GetIndex())
		
	def setPopMenu(self):
		self.popUp = wx.Menu()
		self.popNewJournalID,self.popEditJournalID,self.popDeleteJournalID = wx.NewId(),wx.NewId(),wx.NewId()
		self.popUp.Append(self.popNewJournalID,_('New journal'))
		self.popUp.Append(self.popEditJournalID,_('Edit journal'))
		self.popUp.Append(self.popDeleteJournalID,_('Delete journal'))
		wx.EVT_MENU(self,self.popNewJournalID,self.popNewJournal)
		wx.EVT_MENU(self,self.popEditJournalID,self.popEditJournal)
		wx.EVT_MENU(self,self.popDeleteJournalID,self.popDeleteJournal)
			
	def onKeyDown(self,evt):
		try:
			k = chr(evt.GetKeyCode())
			for key in self.keys:
				if key.startswith(k):
					self.showItem( self.keys.index(key) )
					return
			evt.Skip()
		except ValueError:
			evt.Skip()
		
	def onRightClick(self,evt):
		where = evt.GetPoint()	# position relative to the window
		pw = self.GetPosition()
		where.x = where.x + pw.x
		where.y = where.y + pw.y
		# deselect everything if we did not click in a selected item
		if not self.IsSelected(evt.GetIndex()):
			item = self.GetFirstSelected()
			while item != -1:
				self.Select(item,False)
				item = self.GetNextSelected(item)
			self.Select(evt.GetIndex(),True)	# select the item
		self.Focus(evt.GetIndex())			# focus
		# showing menu
		self.popUp.Enable(self.popEditJournalID,self.GetSelectedItemCount() == 1) # enable only if single selection
		self.PopupMenu(self.popUp,where)
		
	def showItem(self,index):
		item = self.GetFirstSelected()
		while item != -1:
			self.Select(item,False)
			item = self.GetNextSelected(item)
		self.Select(index)
		self.Focus(index)
		self.EnsureVisible(index)
		
	def popNewJournal(self,evt):
		dlg = JournalDialog(self, -1)
		try:
			answer = dlg.ShowModal()
			if answer == wx.ID_OK:
				if dlg.getValues()[0] in self.keys:
					answer = wx.MessageBox("The journal %s already exists. Do you want to replace it?"%dlg.getValues()[0],style = wx.ICON_QUESTION|wx.YES_NO)
					if answer == wx.YES:
						self.journals[dlg.getValues()[0]] = tuple(dlg.getValues())
						self.showItem( self.keys.index(dlg.getValues()[0]) )
				elif dlg.getValues()[0] != "":
					self.journals[dlg.getValues()[0]] = tuple(dlg.getValues())
					self.keys = self.journals.keys()
					self.keys.sort()
					self.SetItemCount(len(self.keys))
					self.showItem( self.keys.index(dlg.getValues()[0]) )
				else:
					wx.LogError(_("The PubMed journal name must be non empty"))
		finally:
			dlg.Destroy()
		
	def popEditJournal(self,evt):
		self.editJournal( self.GetFirstSelected() )
		
	def popDeleteJournal(self,evt):
		# we must first collect a list of the items to delete
		# since deleting them directly would break the VIRTUAL list
		# since we must delete backward
		tmpitems = []
		item = self.GetFirstSelected()
		while item != -1:
			tmpitems.append(item)
			item = self.GetNextSelected(item)
		tmpitems.reverse()
		for item in tmpitems:
			del self.journals[self.keys[item]]
			del self.keys[item]
		self.SetItemCount(len(self.keys))
		
# end of class Journals

		
