#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-
#file test_bindings.py

"""Test functions and classes in the LyX.bindings module

Revision History:

2005-05-23 Gnter Milde first version with the unittest framework
"""

from unittest import TestCase, main 

from LyX.bindings import *


class bindingsTests(TestCase):
    """Test public functions in bindings.py"""
    #
    def test_bindfile_path(self):
        """bindings.bindfile_path should return the full path to the given filename arg"""
        # non-existing bindfile --> emtpy string
        self.assertEqual(bindfile_path("foo"), "")
        # existing bindfile --> full path
        for filename in ["cua", "cua.bind"]:
            self.assertEqual(os.path.basename(bindfile_path("cua.bind")), "cua.bind")
            self.assert_(os.path.isabs(bindfile_path("cua.bind")))
    #
    def test_get_bindings(self):
        """bindings.get_bindings should return list of bindfiles and dict of bindings"""
        # without arg, start search in LYXRC_FILE
        bindfiles, bindings = get_bindings()
        # test return types
        self.assertEqual(type(bindfiles), type([]))
        self.assertEqual(type(bindings), type({}))
        # with args, search recursively in given file
        bindfiles, bindings = get_bindings("cua")
        self.assertEqual(bindings["M-x"].strip('"'), "command-execute")
    #
    def test_apropos(self):
        """bindings.apropos should return list of lfuns matching regexp `pattern`"""
        matches = apropos("quit")
        self.assertEqual(type(matches), type([]))
        self.assertEqual(type(matches[0]), type(""))
        self.assert_("quit" in matches[0])
    #
    def test_where_is(self):
        """bindings.where_is should return a key:lfun dictionary matching regexp `lfun`"""
        bindings = where_is("quit")
        self.assertEqual(type(bindings), type({}))
        self.assert_('"lyx-quit"' in bindings.values())
    #
    def test_showkey(self):
        """bindings.showkey should return the lfun bound to the key"""
        lfun = showkey("M-x")
        self.assertEqual(lfun, '"command-execute"')
    
    # print_bindings() does not return values 
    # (just prints them) so I cannot test. 
        

if __name__ == '__main__':    #run tests if called from command-line
    main()
