#------------------------------------------------------------------------------
# ConsoleSetLibPath.py modified fro bibus
#   Initialization script for cx_Freeze which manipulates the path so that the
# directory in which the executable is found is searched for extensions but
# no other directory is searched. The environment variable LD_LIBRARY_PATH is
# manipulated first, however, to ensure that shared libraries found in the
# target directory are found. This requires a restart of the executable because
# the environment variable LD_LIBRARY_PATH is only checked at startup.
#------------------------------------------------------------------------------

import encodings
import os
import sys
import warnings
import zipimport
import ConfigParser
import urllib,urlparse

# reading oopath. Remark = sys.argv[0] does not work because we are not a python script
dirName = os.path.abspath( os.path.dirname(INITSCRIPT_ZIP_FILE_NAME) )
cp=ConfigParser.ConfigParser()
cp.read( os.path.join(dirName,'bibus.cfg') )
oopath = cp.get('PATH','oopath')
oobasis = cp.get('PATH','oobasis')
ooure = cp.get('PATH','ooure')
if not os.path.isabs(oopath):
	# the path is relative to bibus install directory (needed by portable version)
	oopath = os.path.abspath( os.path.join(dirName,oopath) )
	oobasis = os.path.abspath( os.path.join(dirName,oobasis) )
	ooure = os.path.abspath( os.path.join(dirName,ooure) )
	
if sys.platform.startswith('win'):
	LIBPATH = 'PATH'	# Windows
else:
	LIBPATH = 'LD_LIBRARY_PATH'	# linux (unix)

paths = os.environ.get(LIBPATH, "").split(os.pathsep)

pathset = True
if dirName not in paths:
	paths.insert(0, dirName)
	pathset = False
if oobasis not in paths:
	paths.insert(0, oobasis)
	pathset = False
if ooure not in paths:
	paths.insert(0, ooure)
	pathset = False
if not pathset:
	os.environ[LIBPATH] = os.pathsep.join(paths)
	os.environ["URE_BOOTSTRAP"] = urlparse.urlunparse( ('file','',urllib.pathname2url( os.path.join(oopath,"fundamental.ini") ),'','','') )
	os.execv(sys.executable, sys.argv)

sys.frozen = True

m = __import__("__main__")
importer = zipimport.zipimporter(INITSCRIPT_ZIP_FILE_NAME)
if INITSCRIPT_ZIP_FILE_NAME != SHARED_ZIP_FILE_NAME:
    moduleName = m.__name__
else:
    name, ext = os.path.splitext(os.path.basename(os.path.normcase(FILE_NAME)))
    moduleName = "%s__main__" % name
code = importer.get_code(moduleName)
exec code in m.__dict__

if sys.version_info[:2] >= (2, 5):
    module = sys.modules.get("threading")
    if module is not None:
        module._shutdown()

