#!/bin/bash
#
# gen_am.sh script
#
# (C) 2001 The BibleTime team
# released under the GPL
#
# This script creates the Makefile.am files in the
# bibletime/docs/* directories and subdirectories.

# change to the dir the script is located in
cd `dirname $0`

export HEADER=\
"# this Makefile.am was automatically generated by bibletime/docs/gen_am.sh\n"\
"# please do not edit this file but rather run the script to update\n\n"

###########################
# create Makefile.am in /bibletime/docs/
###########################

. gen_am.dat

echo generating Makefile.am
echo -e $HEADER"SUBDIRS = "$DOC_LANGUAGES > Makefile.am

###########################
# create Makefile.am's in /bibletime/docs/??/ directories
###########################

for I1 in $DOC_LANGUAGES; do

  echo generating $I1/Makefile.am
  ( # output to Makefile.am
    echo -e $HEADER

    echo -n "SUBDIRS = "

    for PART in $DOC_PARTS; do
      if test -d $I1/$PART; then
        echo -n "$PART "
      fi
    done

    echo; echo

    if test -e $I1/tips; then
      echo "EXTRA_DIST =  tips"
      echo

      echo 'rcdir = $(kde_datadir)/bibletime';
      echo 'rc_DATA = tips';
    fi
  ) > $I1/Makefile.am

  ###########################
  # create Makefile.am's in /bibletime/docs/LANG/PART directories
  ###########################
  for PART in $DOC_PARTS; do

    if test -d $I1/$PART; then

      ###################################
      #create $PART/Makefile.am
      ###################################

      export I2=$I1/$PART
      export ENGDIR=../../en
      echo generating $I2/Makefile.am
      ( # output to Makefile.am
        echo -e $HEADER
        echo -n "SUBDIRS = "

        if test -d $I2/html; then
          echo -n "html "
        fi
        if test -d $I2/unicode; then
          echo -n "unicode "
        fi

      echo
      echo
  if test $I1 = en; then
      echo 'pot-files:'
      echo '	for f in `ls unicode/*.docbook`; do \'
      echo '		potfile=`echo $$f | sed s/\.docbook$$/\.pot/`; \'
      echo '		potfile=`echo $$potfile | sed s/unicode//`; \'
      echo '		echo "Calling xml2pot $$f > pot/$$potfile"; \'
      echo '		xml2pot $$f > pot/$$potfile; \'
      echo '		done;'
  else
      echo 'po-files:'
      echo '	for f in `ls '$ENGDIR'/'$PART'/pot/*.pot`; do \'
      echo '		pofile=`echo $$f | sed s/\.pot$$/\.po/`; \'
      echo '		pofile=`echo $$pofile | sed s/"..\/..\/en\/'$PART'\/pot\/"//`; \'
      echo '		if test ! -e po/$$pofile; then touch po/$$pofile; fi; \'
      echo '		echo "Calling msgmerge -o po/$$pofile.new po/$$pofile $$f"; \'
      echo '		msgmerge -o po/$$pofile.new po/$$pofile $$f; \'
      echo '		if diff po/$$pofile po/$$pofile.new > /dev/null; then \'
      echo '		rm po/$$pofile.new; \'
      echo '		else \'
      echo '		mv po/$$pofile.new po/$$pofile; \'
      echo '		fi; \'
      echo '	done;'
      echo
      echo
      echo 'unicode-files:'
      echo '	for f in `ls '$ENGDIR'/'$PART'/unicode/*.docbook`; do \'
      echo '		pofile=`echo $$f | sed s/\.docbook$$/\.po/`; \'
      echo '		pofile=`echo $$pofile | sed s/"..\/..\/en\/'$PART'\/unicode\/"//`; \'
      echo '		newfile=`echo $$f | sed s/"..\/..\/en\/'$PART'\/unicode\/"//`; \'
      echo '		echo "Calling po2xml $$f po/$$pofile  > unicode/$$newfile"; \'
      echo '		po2xml $$f po/$$pofile > unicode/$$newfile; \'
      echo '	done;'
  fi;
      echo 'html-files:'
      echo '	if test -e unicode/index.docbook; then \'
      echo '		olddir=$$PWD; \'
      echo '		cd html;\'
      echo '		echo "Validating the XML files..."; \'
      echo '		if meinproc ../unicode/index.docbook; then\'
      echo '			echo "HTML files created successfully."; \'
      echo '		fi; cd $$olddir; \'
      echo '	fi;'
      echo
      ) > $I2/Makefile.am

      #####################################
      #create $PART/html/Makefile.am
      #####################################
      #export I2=$I1/$PART/html

      for SECTION in html unicode; do

          I2=$I1/$PART/$SECTION
          I2_EN=en/$PART/$SECTION

          if test -d $I2; then

            echo generating $I2/Makefile.am

            ( # output to Makefile.am
              echo -e $HEADER

              echo -n "EXTRA_DIST = "
	      FILES=`ls -d $I2/*.png $I2/*.html $I2/*.docbook 2>/dev/null`;
	      if test $SECTION = "html"; then
		if test $PART = "helpdialog"; then
		    FILES=`ls -d $I2/*.png $I2/*.html 2>/dev/null`;
		else
		    FILES=`ls -d $I2/*.png 2>/dev/null`;
		fi;
	      fi;

              for I3 in $FILES; do
                echo -n `basename $I3`" "
              done
              echo

	      #echo "DISTCLEANFILES = index_cache.gz"
	      #echo

              TARGET_ROOT='$(DESTDIR)$(kde_htmldir)/'$I1'/bibletime'
              TARGET_DIR=$TARGET_ROOT/$PART

              EN_FILES=""
              HAS_FILES="NO"

              if  test $PART == helpdialog; then
                for FILE in `ls -d $I2_EN/*.png $I2_EN/*.html $I2_EN/*.docbook 2>/dev/null`; do
                  EN_FILES="$EN_FILES `basename $FILE`";
                  HAS_FILES="YES"
                done
              else
                for FILE in `ls -d $I2_EN/*.png $I2_EN/*.docbook 2>/dev/null`; do
                  EN_FILES="$EN_FILES `basename $FILE`";
                  HAS_FILES="YES"
                done
              fi


              if test $HAS_FILES = YES; then
                echo
                echo 'install-data-local:'
                echo '	mkdir -p '$TARGET_DIR'/;'  #mkdir -p creates all directories leaing to $TARGET_DIR
                echo '	chmod -R a+r+X  '$TARGET_ROOT';'
                echo '	for file in '$EN_FILES'; do \'
                echo '	  if test -e $$file; then \' ## in this directory
                echo '	    $(INSTALL_DATA) $$file '$TARGET_DIR'; \'
                echo '	    chmod a+r '$TARGET_DIR'/$$file; \'
                echo '	  else \'
                echo '	    ln -sf ../../../en/bibletime/'$PART'/$$file '$TARGET_DIR/'$$file; \'
                echo '	  fi; \'
                echo '	done;'
                echo '	if test -d '$TARGET_DIR'/../../common; then \'
                echo '	  ln -sf ../../common '$TARGET_DIR'/common;\'
                echo '	else \'
                ############## Use the english css data ###################
                echo '	  ln -sf ../../../en/common '$TARGET_DIR'/common;\'
                echo '	fi;'
                echo '	chmod -R a+r+X '$TARGET_ROOT
                echo
                echo 'uninstall-local:'
                echo '	for file in '$EN_FILES'; do \'
                echo '	  echo Removing '$TARGET_DIR'/$$file; \'
                echo '	  rm -f '$TARGET_DIR'/$$file; \'
                echo '	done;'
                echo '	echo Removing '$TARGET_DIR'/common;'
                echo '	rm -f '$TARGET_DIR'/common;'
              fi;
            ) > $I2/Makefile.am
          fi # html

      done


    fi  # PART exists?

  done ### PART

done ### language


