/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_XSLFO_ENDNOTE_H
#define INCLUDED_XSLFO_ENDNOTE_H


#include "libraries.h"
#include "usfm.h"
#include "xmlfo-utils.h"
#include "notecaller.h"
#include "xslfofootnoteparagraph.h"
#include "usfm-inline-markers.h"


class XslFoEndnote
{
public:
  XslFoEndnote (const Usfm& usfm, bool show);
  ~XslFoEndnote ();
  void transform (XmlFoBlock * xmlfoblock, ustring& line, UsfmInlineMarkers * inline_markers);
  void end_project (vector<ustring>& xslfo_lines);
  void end_book (vector<ustring>& xslfo_lines);
  bool new_marker (const ustring& marker);
  void dump (vector<ustring>& xslfo_lines);
private:
  bool myshow;
  ustring opening_marker;
  ustring closing_marker;
  double anchor_fontpercentage;
  ustring anchor_italic;
  ustring anchor_bold;
  ustring anchor_underline;
  ustring anchor_smallcaps;
  bool anchor_superscript;
  EndnotePositionType position_type;
  ustring dump_at_marker;
  vector<ustring> content_marker;
  vector <bool> content_apocrypha;
  set<ustring> endnote_markers;
  XslFoFootnoteParagraph * standardparagraph;
  XslFoFootnoteParagraph * extraparagraph;
  NoteCaller * endnotecaller;
  vector <ustring> notes;
  ustring transform_main_parts (XmlFoBlock * xmlfoblock, const ustring& line, UsfmInlineMarkers * inline_markers);
};


#endif
