/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "extra_matter_utils.h"
#include "directories.h"
#include <config.h>
#include "utilities.h"
#include "gwrappers.h"
#include "shell.h"


ustring extra_matter_file_name (const ustring& project, EditExtraMatter which)
// Gives the path of the file with extra matter for a project.
{
  ustring filename;
  ustring matter;
  switch (which) {
    case FrontMatter   : matter = "FrontMatter";   break;
    case BackMatter    : matter = "BackMatter";    break;
    case OtherMaterial : matter = "OtherMaterial"; break;
  }
  filename = gw_build_filename (directories_get_projects(), project, matter, "current_version");
  return filename;
}


void extra_matter_file_ensure_exists (const ustring& project, EditExtraMatter which)
// Ensure the file for the extra matter esists.
{
  ustring filename = extra_matter_file_name (project, which);
  if (!g_file_test (filename.c_str(), G_FILE_TEST_IS_REGULAR)) {
    create_directory (g_path_get_dirname (filename.c_str ()));
    ustring templatename;
    switch (which) {
      case FrontMatter   : templatename = "extra_matter_front_matter";   break;
      case BackMatter    : templatename = "extra_matter_back_matter";    break;
      case OtherMaterial : templatename = "extra_matter_other_material"; break;
    }
    templatename = gw_build_filename (PACKAGE_DATA_DIR, templatename);
    ustring command = "cp" + shell_quote_space (templatename) + shell_quote_space (filename);
    system (command.c_str ());
  }
}


void extra_matter_file_get_relevant_markers (vector<ustring>& markers, EditExtraMatter which)
// Loads "markers" with the relevant and supported markers for extra matter "which".
{
  switch (which) {
    case FrontMatter : {
      markers.push_back ("id FRT");
      markers.push_back ("mt");
      break;
    }
    case BackMatter : {
      markers.push_back ("id BAK");
      break;
    }
    case OtherMaterial : {
      markers.push_back ("id OTH");
      markers.push_back ("cov");
      markers.push_back ("mt");
      break;
    }
  }
}
