/* Anti-Web HTTPD */
/* Hardcore Software */
/* 
This software is Copyright (C) 2001-2004 By Hardcore Software and
others. The software is distributed under the terms of the GNU General
Public License. See the file 'COPYING' for more details.
*/


#include <stdio.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>



#define BACKLOG 15
#define VERSION "3.0.5"
//#define HAVE_IPV6

#define MAXFILEPATH 1024
#define MAXIPLEN 45
#define MAXREQUESTLENGTH 1024
#define MAXCGIARGS 100
#define BLOCKSIZE 4096

#define INITIAL_CONNECTION_SLOTS 10

#define STATE_WANT_TO_READ_HEAD  1
#define STATE_WANT_TO_SEND_HEAD  2
#define STATE_WANT_TO_READ_FILE  3
#define STATE_WANT_TO_SEND_FILE  4
#define STATE_DOING_DIR          5

#define TYPE_GET 0
#define TYPE_HEAD 1
#define TYPE_POST 2


struct connstruct {
  struct connstruct *next;

  int state;
  int reqtype;

  int networkdesc;
  int filedesc;
  DIR *dirp;

  int timeout;

  char ip[MAXIPLEN];

  char actualfile[MAXREQUESTLENGTH];
  char filereq[MAXREQUESTLENGTH];
  char cgiargs[MAXREQUESTLENGTH];
  char virtualhostreq[MAXREQUESTLENGTH];

  int numbytes;
  long offset;
  char databuf[BLOCKSIZE];

};


struct serverstruct {
  struct serverstruct *next;
  int sd;
};


struct cgiextstruct {
  struct cgiextstruct *next;
  char *ext;
};


struct indexstruct {
  struct indexstruct *next;
  char *name;
};



// Global prototypes

extern struct serverstruct *servers;
extern struct connstruct *usedconns;
extern struct connstruct *freeconns;
extern struct cgiextstruct *cgiexts;
extern struct indexstruct *indexlist;


// Conf global prototypes

extern int usevirtualhosts;
extern char *webroot;
extern int allowdirectorylisting;
extern int allowcgi;
extern int permcheck;
extern int maxusers;
extern int usertimeout;
extern int initialslots;
extern char *quote;
extern int initialslots;

extern int numusers;


// Useful macros
#define istimedout(tp,ct) ((ct) > (tp)->timeout)
#define updatetimeout(tp,ct) ((tp)->timeout = (ct)+usertimeout)



// conn.c prototypes
void addconnection(int sd, char *ip);
void removeconnection(struct connstruct *cn);


// proc.c prototypes
int procheadelem(struct connstruct *cn, char *buf);
void procdirlisting(struct connstruct *cn);
void procdodir(struct connstruct *cn);
void procreadhead(struct connstruct *cn);
void procsendhead(struct connstruct *cn);
void procreadfile(struct connstruct *cn);
void procsendfile(struct connstruct *cn);


// net.c prototypes
void addtoservers(int sd);
void selectloop();


// socket.c prototypes
int pollsocket(int sd, long ustimeout);
void handlenewconnection(int listenfd);
int openlistener(int port);
int openlistener6(int port);


// errors.c prototypes
void send505(int sd, char *reason);
void send404(struct connstruct *cn);
void send301(struct connstruct *cn);


// misc.c prototypes
void nada();
void die();
void stripcrlf(char *p);
int iscgi(char *fn);
int split(char *tp, char *sp[], int maxwords, char sc);
int confsplit(char *tp, char *sp[], int maxwords);
int sanitizefile(char *buf);
int sanitizehost(char *buf);
void buildactualfile(struct connstruct *cn);
int issockwriteable(int sd);
int isdir(char *name);
void status();


// mime_types.c prototypes
char *getmimetype(char *fn);


// urldecode.c prototypes
void urldecode(char *buf);


// urlencode.c prototypes
void urlencode(unsigned char *s, unsigned char *t);


// cgi.c prototypes
void addcgiext(char *tp);
void proccgi(struct connstruct *cn);


// conf.c prototypes
void defaultconfvals();
void procconf(char *filename);


// permcheck.c prototypes
void procpermcheck(char *pathtocheck);


// index.c prototypes
void addindex(char *tp);
int procindex(struct connstruct *cn, struct stat *stp);


// main.c prototypes
void initlists();
