/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AutoIndentingTextView.h"
#include <gtkmm/textbuffer.h>
#include <gtkmm/textiter.h>
#include <glibmm/ustring.h>
#include <glibmm/unicode.h>
#include <gdk/gdkkeysyms.h>
#include <stddef.h>

bool
AutoIndentingTextView::on_key_press_event(GdkEventKey* evt)
{
	if (evt->keyval != GDK_Return && evt->keyval != GDK_KP_Enter) {
		return Gtk::TextView::on_key_press_event(evt);
	}
	
	Glib::RefPtr<Gtk::TextBuffer> buffer = get_buffer();
	
	Gtk::TextIter ins_pos = buffer->get_insert()->get_iter();
	int const line_num = ins_pos.get_line();
	Gtk::TextIter line_begin = buffer->get_iter_at_line(line_num);
	
	Gtk::TextIter it = line_begin;
	for (; it != ins_pos && Glib::Unicode::isspace(*it); ++it) {
		// skip leading spaces
	}
	
	Glib::ustring insertion("\n");
	insertion.append(line_begin.get_text(it));
	buffer->insert(ins_pos, insertion);
	
	scroll_mark_onscreen(buffer->get_insert());
	
	return true;
}
