/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef REPLACEMENTFLASH_H_
#define REPLACEMENTFLASH_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "SplittableBuffer.h"
#include "BString.h"
#include <memory>
#include <string>

class Color;
class CraftedResponse;

class ReplacementFlash
{
public:
	static unsigned int const DEFAULT_FRAMERATE = 12 << 8; // 12 fps
	
	ReplacementFlash(int width, int height,
		char const* orig_url,
		Color const* border_color,
		unsigned int frame_rate = DEFAULT_FRAMERATE);
	
	SplittableBuffer& binaryData() { return m_binaryData; }
	
	SplittableBuffer const& binaryData() const { return m_binaryData; }
	
	static BString getContentType() { return BString("application/x-shockwave-flash"); }
	
	static std::auto_ptr<CraftedResponse> createHttpResponse(
		bool is_head_response, int width, int height,
		std::string orig_url, unsigned int frame_rate = DEFAULT_FRAMERATE);
private:
	class Buffer;

	SplittableBuffer m_binaryData;
};

#endif
