/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef IMAGEADSUSPECT_H_
#define IMAGEADSUSPECT_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AdSuspect.h"
#include "ImageHeuristicScore.h"
#include "URI.h"
#include "BString.h"
#include <memory>
#include <iosfwd>

class ImageAdSuspect : public AdSuspect
{
public:
	ImageAdSuspect(int width, int height,
		URI const& location, bool location_absolute,
		BString const& link, ImageHeuristicScore const& score);
	
	virtual ~ImageAdSuspect();
	
	virtual int getWidth() const;
	
	virtual int getHeight() const;
	
	BString const& getLink() const { return m_link; }
	
	virtual URI const& getLocation() const;
	
	virtual bool isLocationAbsolute() const;
	
	virtual HeuristicScore const& getScore() const;
	
	virtual BString getSubstitutionURL() const;
	
	virtual void writeSubstitution(std::ostream& strm) const;
	
	static BString getSubstitutionURL(
		URI const& orig_url, int width, int height);
private:
	int m_width;  //
	int m_height; // -1 if undefined
	URI m_location;
	bool m_isLocationAbsolute;
	BString m_link;
	ImageHeuristicScore m_score;
};


inline
ImageAdSuspect::ImageAdSuspect(
	int width, int height,
	URI const& location, bool location_absolute,
	BString const& link, ImageHeuristicScore const& score)
:	m_width(width),
	m_height(height),
	m_location(location),
	m_isLocationAbsolute(location_absolute),
	m_link(link),
	m_score(score)
{
}

inline BString
ImageAdSuspect::getSubstitutionURL(
	URI const& orig_url, int width, int height)
{
	return AdSuspect::getSubstitutionURL("bf-si-", orig_url, width, height);
}

#endif
