/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ImageAdSuspect.h"
#include "HtmlEscaper.h"
#include "BString.h"
#include <ostream>
#include <algorithm>

using namespace std;

ImageAdSuspect::~ImageAdSuspect()
{
}

int
ImageAdSuspect::getWidth() const
{
	return m_width;
}

int
ImageAdSuspect::getHeight() const
{
	return m_height;
}

URI const&
ImageAdSuspect::getLocation() const
{
	return m_location;
}

bool
ImageAdSuspect::isLocationAbsolute() const
{
	return m_isLocationAbsolute;
}

HeuristicScore const&
ImageAdSuspect::getScore() const
{
	return m_score;
}

BString
ImageAdSuspect::getSubstitutionURL() const
{
	return getSubstitutionURL(m_location, m_width, m_height);
}

void
ImageAdSuspect::writeSubstitution(ostream& strm) const
{
	int width = std::max<int>(m_width, 15);
	int height = std::max<int>(m_height, 15);
	strm << "<a href=\"" << HtmlEscaper::escape(m_link)
	        << "\"><img alt=\"Ad replacement [img]\" border=\"0\" width=\""
		<< width << "\" height=\"" << height << "\" src=\""
		<< HtmlEscaper::escape(getSubstitutionURL())
		<< "\" /></a>";
}
