/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HttpStateResponseStart.h"
#include "HttpResponseParser.h"
#include "SplittableBuffer.h"
#include "HttpRequestMetadata.h"

HttpStateResponseStart::HttpStateResponseStart(HttpResponseParser& parser)
:	m_rParser(parser)
{
}

HttpStateResponseStart::~HttpStateResponseStart()
{	
}

void
HttpStateResponseStart::activate(ConstRequestPtr const& req)
{
	m_ptrRequest = req;
}

HttpState*
HttpStateResponseStart::processNewData(
	SplittableBuffer& input, bool eof,
	SplittableBuffer& body_data, bool& body_eof)
{
	if (!input.empty()) {
		return m_rParser.activateStateStatusLine(m_ptrRequest);
	} else if (eof) {
		return m_rParser.activateStateError("unexpected end of data (in HttpStateResponseStart)");
	}
	return this;
}

void
HttpStateResponseStart::cleanup()
{
	m_ptrRequest.reset(0);
}
