/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HTTPHEADERELEMENT_H_
#define HTTPHEADERELEMENT_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "BString.h"
#include <list>

class HttpHeaderElement
{
public:
	struct Param
	{
		BString name;
		BString value;
		bool isNullValue;
		
		Param() : isNullValue(true) {}
		
		Param(BString const& name)
		: name(name), isNullValue(true) {}
		
		Param(BString const& name, BString const& value)
		: name(name), value(value), isNullValue(false) {}
	};
	
	HttpHeaderElement(BString const& name);
	
	HttpHeaderElement(BString const& name, BString const& value);
	
	~HttpHeaderElement();
	
	BString const& getName() const { return m_name; }
	
	void setName(BString const& name) { m_name = name; }
	
	BString const& getValue() const { return m_value; }
	
	void setValue(BString const& value) { m_value = value; }
	
	bool isNullValue() const { return m_isNullValue; }
	
	void setNullValue() { m_value.clear(); m_isNullValue = true; }
	
	std::list<Param>& parameters() { return m_params; }
	
	std::list<Param> const& parameters() const { return m_params; }
	
	bool hasParameter(BString const& pname) const;
	
	// returns Param() if not found
	Param getParameterByName(BString const& pname) const;
	
	std::list<Param> getParametersByName(BString const& pname) const;
private:
	BString m_name;
	BString m_value;
	bool m_isNullValue;
	std::list<Param> m_params;
};

#endif
