/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "FlashAdSuspect.h"
#include "HtmlEscaper.h"
#include "BString.h"
#include <ostream>
#include <algorithm>
#include <string>

using namespace std;

FlashAdSuspect::~FlashAdSuspect()
{
}

int
FlashAdSuspect::getWidth() const
{
	return m_width;
}

int
FlashAdSuspect::getHeight() const
{
	return m_height;
}

URI const&
FlashAdSuspect::getLocation() const
{
	return m_location;
}

bool
FlashAdSuspect::isLocationAbsolute() const
{
	return m_isLocationAbsolute;
}

HeuristicScore const&
FlashAdSuspect::getScore() const
{
	return m_score;
}

BString
FlashAdSuspect::getSubstitutionURL() const
{
	return getSubstitutionURL(m_location, m_width, m_height);
}

void
FlashAdSuspect::writeSubstitution(ostream& strm) const
{
	int width = std::max<int>(m_width, 15);
	int height = std::max<int>(m_height, 15);
	BString escaped_url = HtmlEscaper::escape(getSubstitutionURL());
	strm << "<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\""
		<< " width=\"" << width << "\" height=\"" << height
		<< "\"><param name=\"movie\" value=\"" << escaped_url
		<< "\" /><embed width=\"" << width << "\" height=\""
		<< height << "\" type=\"application/x-shockwave-flash\" src=\""
		<< escaped_url << "\" /></object>";
}
