/* Bezerk
 * Copyright (C) 1998 Tony Gale.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef __UTIL_H__
#define __UTIL_H__
 
#include <gdk/gdk.h>
#include "reply.h"
#include "bezerk.h"
#include "servers.h"
#include "message.h"

typedef enum {
  ARROW_UP,
  ARROW_DOWN,
} ArrowType;

gushort convert_color (unsigned c);
void extract_color (GdkColor *color, unsigned red, unsigned green, unsigned blue);
void prefs_add_alias(char *name, char *value);
void prefs_save_aliases();
void aliases_init();
void set_channel_status(ChannelInfo *target_channel);
void set_user_status(struct _Connection *connection);
void set_user_mode(struct _Connection *connection, char mode, int adding);
char *bs_strtok(char *string, char *delim);
void cmd_recall_add(char *command, struct _BezBaseWindow *window);
char *cmd_recall_previous(struct _BezBaseWindow *window);
char *cmd_recall_next(struct _BezBaseWindow *window);
char *get_time_string();
char *get_time_diff(char *from);
GSList *split_args(char *string);
GtkWidget *create_pixmap (gchar **data, GdkWindow *window, GdkColor  *background);
GtkWidget *create_arrow_button(GtkWidget *parent, ArrowType type);
GtkWidget *create_labelled_widget(gchar     *handle,
				  gint       handle_width,
				  GtkWidget *widget,
				  gint       widget_width);

#endif /* __UTIL_H__ */
