/* Bezerk
 * Copyright (C) 1998 Tony Gale.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
 
#include <gtk/gtk.h>

#include "ctcp.h"
#include "dcc.h"
#include "ch_utils.h"
#include "util.h"
#include "debug.h"

void nick_popup_whois(GtkWidget *widget, BezChannelWindow *window)
{
  GSList *glist_entry;
  UserInfo *user_info;
  gchar *nick;

  bs_function_enter();

  glist_entry = g_slist_nth(window->current_channel->members,
			    window->current_channel->selected_member);
  user_info = (UserInfo *) glist_entry->data;
  nick = user_info->nick;

  send_args("WHOIS", nick, (BezBaseWindow *) window);
  messages_write();

  bs_function_leave();
  return;
}

void nick_popup_msg(GtkWidget *widget, BezChannelWindow *window)
{
  GSList *glist_entry;
  UserInfo *user_info;
  gchar *nick;

  bs_function_enter();

  glist_entry = g_slist_nth(window->current_channel->members,
			    window->current_channel->selected_member);
  user_info = (UserInfo *) glist_entry->data;
  nick = user_info->nick;

  send_privmsg("MSG", nick, (BezBaseWindow *) window);
  messages_write();

  bs_function_leave();
  return;
}

void nick_popup_version(GtkWidget *widget, BezChannelWindow *window)
{
  GSList *glist_entry;
  UserInfo *user_info;
  gchar *nick;

  bs_function_enter();

  glist_entry = g_slist_nth(window->current_channel->members,
			    window->current_channel->selected_member);
  user_info = (UserInfo *) glist_entry->data;
  nick = user_info->nick;

  ctcp_send_version("VERSION", nick, (BezBaseWindow *) window);
  messages_write();

  bs_function_leave();
  return;
}

void nick_popup_ping(GtkWidget *widget, BezChannelWindow *window)
{
  GSList *glist_entry;
  UserInfo *user_info;
  gchar *nick;
  
  bs_function_enter();

  glist_entry = g_slist_nth(window->current_channel->members,
			    window->current_channel->selected_member);
  user_info = (UserInfo *) glist_entry->data;
  nick = user_info->nick;

  ctcp_send_ping("PING", nick, (BezBaseWindow *) window);
  messages_write();

  bs_function_leave();
  return;
}

void nick_popup_dcc_send(GtkWidget *widget, BezChannelWindow *window)
{
  GSList *glist_entry;
  UserInfo *user_info;
  gchar *nick;
  bs_function_enter();

  glist_entry = g_slist_nth(window->current_channel->members,
			    window->current_channel->selected_member);
  user_info = (UserInfo *) glist_entry->data;
  nick = user_info->nick;

  dcc_send_send(window->connection, nick);

  messages_write();

  bs_function_leave();
  return;
}

void nick_popup_dcc_chat(GtkWidget *widget, BezChannelWindow *window)
{
  GSList *glist_entry;
  UserInfo *user_info;
  gchar *nick;
  bs_function_enter();

  glist_entry = g_slist_nth(window->current_channel->members,
			    window->current_channel->selected_member);
  user_info = (UserInfo *) glist_entry->data;
  nick = user_info->nick;

  dcc_send_chat(window->connection, nick);

  messages_write();

  bs_function_leave();
  return;
}

void nick_popup_clientinfo(GtkWidget *widget, BezChannelWindow *window)
{
  GSList *glist_entry;
  UserInfo *user_info;
  gchar *nick;
  
  bs_function_enter();

  glist_entry = g_slist_nth(window->current_channel->members,
  			    window->current_channel->selected_member);
  user_info = (UserInfo *) glist_entry->data;
  nick = user_info->nick;
  
  ctcp_send_clientinfo("CLIENTINFO", nick, (BezBaseWindow *) window);
  messages_write();
  
  bs_function_leave();
  return;
}

void nick_popup(unsigned row, GdkEventButton *bevent, BezChannelWindow *window)
{
  GtkWidget *menu=NULL;
  GtkWidget *menu_item;
  menu = gtk_menu_new();

  bs_function_enter();

  menu_item = gtk_menu_item_new_with_label("Whois");
  gtk_menu_append(GTK_MENU (menu), menu_item);
  gtk_signal_connect( GTK_OBJECT(menu_item), "activate",
		      GTK_SIGNAL_FUNC(nick_popup_whois), 
		      window);  
  gtk_widget_show(menu_item);

  menu_item = gtk_menu_item_new();
  gtk_menu_append(GTK_MENU (menu), menu_item);
  gtk_widget_show(menu_item);

  menu_item = gtk_menu_item_new_with_label("Msg");
  gtk_menu_append(GTK_MENU (menu), menu_item);
  gtk_signal_connect( GTK_OBJECT(menu_item), "activate",
		      GTK_SIGNAL_FUNC(nick_popup_msg), 
		      window);  
  gtk_widget_show(menu_item);

  menu_item = gtk_menu_item_new_with_label("Version");
  gtk_menu_append(GTK_MENU (menu), menu_item);
  gtk_signal_connect( GTK_OBJECT(menu_item), "activate",
		      GTK_SIGNAL_FUNC(nick_popup_version), 
		      window);  
  gtk_widget_show(menu_item);

  menu_item = gtk_menu_item_new_with_label("Ping");
  gtk_signal_connect( GTK_OBJECT(menu_item), "activate",
		      GTK_SIGNAL_FUNC(nick_popup_ping), 
		      window);  
  gtk_menu_append(GTK_MENU (menu), menu_item);
  gtk_widget_show(menu_item);

  menu_item = gtk_menu_item_new_with_label("Clientinfo");
  gtk_menu_append(GTK_MENU (menu), menu_item);
  gtk_signal_connect( GTK_OBJECT(menu_item), "activate",
  		      GTK_SIGNAL_FUNC(nick_popup_clientinfo),
  		      window);
  gtk_widget_show(menu_item);  		      

  menu_item = gtk_menu_item_new();
  gtk_menu_append(GTK_MENU (menu), menu_item);
  gtk_widget_show(menu_item);

  menu_item = gtk_menu_item_new_with_label("DCC Send");
  gtk_signal_connect( GTK_OBJECT(menu_item), "activate",
		      GTK_SIGNAL_FUNC(nick_popup_dcc_send), 
		      window);  
  gtk_menu_append(GTK_MENU (menu), menu_item);
  gtk_widget_show(menu_item);

  menu_item = gtk_menu_item_new_with_label("DCC Chat");
  gtk_signal_connect( GTK_OBJECT(menu_item), "activate",
		      GTK_SIGNAL_FUNC(nick_popup_dcc_chat), 
		      window);  
  gtk_menu_append(GTK_MENU (menu), menu_item);
  gtk_widget_show(menu_item);

  gtk_menu_popup (GTK_MENU(menu), NULL, NULL, NULL, NULL,
		  bevent->button, bevent->time);

  bs_function_leave();
  return;
}

void channel_popup_promote(GtkWidget *widget, ChannelInfo *target_channel)
{
  BezWindow *new_window;
  gchar title[BUFFLEN];
/*   int glist_num; */
  bs_function_enter();

  if ( target_channel->topic ) {
    g_snprintf(title, BUFFLEN, "%s - %s", target_channel->name, target_channel->topic);
  } else {
    g_snprintf(title, BUFFLEN, "%s", target_channel->name);
  }

  gtk_window_set_title(GTK_WINDOW(target_channel->window->window), "Bezerk");

  gtk_clist_clear(GTK_CLIST(target_channel->window->nick_clist));
  target_channel->window->current_channel = NULL;
  /* This pop is a bit of a hack */
  gtk_statusbar_pop( GTK_STATUSBAR(target_channel->window->channel_status), 1);
  gtk_clist_remove(GTK_CLIST(target_channel->window->ch_clist),target_channel->window->selected_row);

  new_window = create_channel_window(title, FALSE);
  BEZ_CHANNEL_WINDOW(new_window)->connection = target_channel->window->connection;
  target_channel->window = (BezChannelWindow *) new_window;
  BEZ_CHANNEL_WINDOW(new_window)->current_channel = target_channel;

  set_members_list(target_channel);

  set_user_status( BEZ_CHANNEL_WINDOW(new_window)->connection);
  set_channel_status(target_channel);

/*   messages_write(); */

  bs_function_leave();
  return;
}

void channel_popup_part(GtkWidget *widget, ChannelInfo *target_channel)
{
  bs_function_enter();

  send_part("PART", target_channel->name, (BezBaseWindow *) target_channel->window);
  messages_write();

  bs_function_leave();
  return;
}

void channel_popup(ChannelInfo *target_channel, GdkEventButton *bevent)
{
  GtkWidget *menu=NULL;
  GtkWidget *menu_item;

  bs_function_enter();

  while (gtk_events_pending())
        gtk_main_iteration();

  menu = gtk_menu_new();

  menu_item = gtk_menu_item_new_with_label("Promote");
  gtk_menu_append(GTK_MENU (menu), menu_item);
  gtk_signal_connect (GTK_OBJECT(menu_item), "activate",
		      GTK_SIGNAL_FUNC(channel_popup_promote), 
		      target_channel);
  gtk_widget_show(menu_item);

  menu_item = gtk_menu_item_new();
  gtk_menu_append(GTK_MENU (menu), menu_item);
  gtk_widget_show(menu_item);

  menu_item = gtk_menu_item_new_with_label("Part");
  gtk_menu_append(GTK_MENU (menu), menu_item);
  gtk_signal_connect (GTK_OBJECT(menu_item), "activate",
		      GTK_SIGNAL_FUNC(channel_popup_part), 
		      target_channel);  
  gtk_widget_show(menu_item);

  gtk_menu_popup (GTK_MENU(menu), NULL, NULL, NULL, NULL,
		  bevent->button, bevent->time);

  bs_function_leave();
  return;
}
