/* Bezerk
 * Copyright (C) 1998 Tony Gale.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
 
#ifndef __CH_UTILS_H__
#define __CH_UTILS_H__

#include "message.h"
#include "reply.h"

int find_channel_entry(GSList *channel_list, char *channel);
ChannelInfo *find_channel(GSList *channel_list, char *channel);
void set_channel(ChannelInfo *target_channel);
void add_channel_member(ChannelInfo *channel, char* nick);
void remove_members(GSList *members);
int remove_channel_member(ChannelInfo *channel, char *nick);
int is_channel_member(ChannelInfo *channel, char *nick);
void channel_destroy(ChannelInfo *target_channel);
GSList *remove_channel(GSList *channel_list, char *channel);
void set_channel_mode(ChannelInfo *channel, char nick, int adding);
void set_members_list(ChannelInfo *channe);
int change_member_nick(ChannelInfo *channel, char *oldnick, char *newnick);
void set_member_status(ChannelInfo *channel, char *nick, unsigned status);
void clean_up();
void write_messages();
char *complete_nick(ChannelInfo *channel, char* incomplete_nick);

#endif /* __CH_UTILS__ */
