
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bsewaveosc.proc"

#include <bse/bseplugin.h>
#include <bse/bsewaveosc.h>
#include <bse/bseprocedure.h>
#include <bse/bseeditablesample.h>

#line 24 "bsewaveosc.proc"


/* --- request-pcm-position --- */
static void
request_pcm_position_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 26 "bsewaveosc.proc"
 {
#line 28 "bsewaveosc.proc"
  *(in_pspecs++) = bse_param_spec_object ("wosc", NULL, "Wave Oscilator",
				 BSE_TYPE_WAVE_OSC, SFI_PARAM_STANDARD);
#line 30 "bsewaveosc.proc"
}  }
static BseErrorType
#line 30 "bsewaveosc.proc"
request_pcm_position_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 33 "bsewaveosc.proc"
{
#line 34 "bsewaveosc.proc"
  
  BseWaveOsc *self = bse_value_get_object (in_values++);
  
#line 37 "bsewaveosc.proc"
  
  if (!BSE_IS_WAVE_OSC (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  bse_wave_osc_request_pcm_position (self);
  
  return BSE_ERROR_NONE;
}

/* --- bse-wave-osc-mass-seek-perc --- */
static void
bse_wave_osc_mass_seek_perc_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 46 "bsewaveosc.proc"
 {
#line 48 "bsewaveosc.proc"
  *(in_pspecs++)    = bse_param_spec_boxed ("wosc-seq", "Wave Oscilators", NULL, BSE_TYPE_ITEM_SEQ, SFI_PARAM_STANDARD); // FIXME: using BseItemSeq because BseWaveOscSeq requires idl+C++
  *(in_pspecs++) = sfi_pspec_real ("pos_perc", NULL, NULL,
			  0, 0, 100, 1,
			  SFI_PARAM_STANDARD);
#line 52 "bsewaveosc.proc"
}  }
static BseErrorType
#line 52 "bsewaveosc.proc"
bse_wave_osc_mass_seek_perc_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 55 "bsewaveosc.proc"
{
#line 56 "bsewaveosc.proc"
  
  BseItemSeq *iseq = bse_value_get_boxed (in_values++);
  gfloat      pos  = sfi_value_get_real (in_values++);
  guint i, n = iseq ? iseq->n_items : 0;
  BseWaveOsc **woscs = g_alloca (sizeof (BseWaveOsc*) * n);
  for (i = 0; i < n; i++)
#line 62 "bsewaveosc.proc"
    if (!BSE_IS_WAVE_OSC (iseq->items[i]))      
      return BSE_ERROR_PROC_PARAM_INVAL;
    else
      woscs[i] = (BseWaveOsc*) iseq->items[i];
  if (n)
    bse_wave_osc_mass_seek (n, woscs, pos);
  
  return BSE_ERROR_NONE;
}

/* --- set-from-editable-sample --- */
static void
set_from_editable_sample_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 72 "bsewaveosc.proc"
 {
#line 74 "bsewaveosc.proc"
  *(in_pspecs++) = bse_param_spec_object ("wosc", NULL, "Wave Oscilator",
				 BSE_TYPE_WAVE_OSC, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_object ("esample", NULL, "Editable Sample",
				 BSE_TYPE_EDITABLE_SAMPLE, SFI_PARAM_STANDARD);
#line 78 "bsewaveosc.proc"
}  }
static BseErrorType
#line 78 "bsewaveosc.proc"
set_from_editable_sample_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 81 "bsewaveosc.proc"
{
#line 82 "bsewaveosc.proc"
  
  BseWaveOsc *self           = bse_value_get_object (in_values++);
  BseEditableSample *esample = bse_value_get_object (in_values++);

#line 86 "bsewaveosc.proc"
  
  if (!BSE_IS_WAVE_OSC (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  bse_wave_osc_set_from_esample (self, esample);
  
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_request_pcm_position__fill_strings (BseExportStrings *es)
{
  es->blurb = "Request emission of the ::notify_pcm_position signal.";
  es->file = "/opt/src/beast/bse/bsewaveosc.proc";
  es->line = 27;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_request_pcm_position = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseWaveOsc+request-pcm-position", 
    NULL,
    "/Methods/BseWaveOsc/General/Request Pcm Position",
    NULL,
    __enode_request_pcm_position__fill_strings,
  },
  0, request_pcm_position_setup, request_pcm_position_exec, 
};
static void
__enode_bse_wave_osc_mass_seek_perc__fill_strings (BseExportStrings *es)
{
  es->blurb = "Seek a list of wave oscillators to a pcm position given in percentage. The oscillators will seek to the given position syncronously.";
  es->file = "/opt/src/beast/bse/bsewaveosc.proc";
  es->line = 47;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_wave_osc_mass_seek_perc = {
  { (BseExportNode*) &__enode_request_pcm_position, BSE_EXPORT_NODE_PROC,
    "bse-wave-osc-mass-seek-perc", 
    NULL,
    "/Proc/Seek Wave Oscillators",
    NULL,
    __enode_bse_wave_osc_mass_seek_perc__fill_strings,
  },
  0, bse_wave_osc_mass_seek_perc_setup, bse_wave_osc_mass_seek_perc_exec, 
};
static void
__enode_set_from_editable_sample__fill_strings (BseExportStrings *es)
{
  es->blurb = "Set wave to play from editable sample, bypassing undo and storage mechanisms.";
  es->file = "/opt/src/beast/bse/bsewaveosc.proc";
  es->line = 73;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_set_from_editable_sample = {
  { (BseExportNode*) &__enode_bse_wave_osc_mass_seek_perc, BSE_EXPORT_NODE_PROC,
    "BseWaveOsc+set-from-editable-sample", 
    NULL,
    "/Methods/BseWaveOsc/General/Set From Editable Sample",
    NULL,
    __enode_set_from_editable_sample__fill_strings,
  },
  0, set_from_editable_sample_setup, set_from_editable_sample_exec, 
};
BseExportNode* bse__builtin_init_bsewaveosc_genprc_c (void);
BseExportNode* bse__builtin_init_bsewaveosc_genprc_c (void)
{
  return (BseExportNode*) &__enode_set_from_editable_sample;
}

/*
 * Generated data ends here
 */
