#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
# abrowse tests
# Copyright © 2005 Canonical Limited
#	Authors:  Robert Collins <robert.collins@canonical.com>
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

setup_with_trivial_archives

test_class "abrowse"

begin_test "make 2 of each namespace level"
tla branch jane@example.com--2003/hello-world--mainline--1.{0,1}
tla branch jane@example.com--2003/hello-world--{mainline,devel}--1.0
tla branch jane@example.com--2003/hello-world--devel--1.{0,1}
tla branch jane@example.com--2003/{hello,goodbye}-world--mainline--1.0
tla branch jane@example.com--2003/goodbye-world--mainline--1.{0,1}
tla branch jane@example.com--2003/goodbye-world--{mainline,devel}--1.0
tla branch jane@example.com--2003/goodbye-world--devel--1.{0,1}
end_test

begin_test "abrowse does not duplicate output"
[ "$(tla abrowse jane@example.com--2003|wc -l)" -eq "31" ] || test_fail "too much or too little output in $(tla abrowse jane@example.com--2003)"
end_test

begin_test "abrowse with no params in a tree"
tla get jane@example.com--2003/hello-world--mainline--1.0 foo
cd foo
tla abrowse
end_test

clean_workdir
