#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# Simple tree id tests
# Copyright © 2004 Canonical Limited
#     Authors: Robert Collins <robert.collins@canonical.com>
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

setup_with_trivial_tla_archives

test_class "tree-id"

begin_test "id for checkout"
tla get jane@example.com--2003/hello-world--mainline--1.0 hello-world
test $(tla tree-id hello-world) = "jane@example.com--2003/hello-world--mainline--1.0--base-0"
end_test 

begin_test "id after commit"
tla get jane@example.com--2003/hello-world--mainline--1.0 hello-world
cd hello-world
touch garh
tla add garh
tla commit -s 'garh'
test $(tla tree-id) = "jane@example.com--2003/hello-world--mainline--1.0--patch-1"
cd ..
end_test 

clean_workdir
