#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# Test my-revision-library
# Copyright © 2003 Colin Walters <walters@verbum.org>
#             2004 Canonical Ltd
#             2004 Aaron Bentley
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

setup_with_trivial_tla_archives

test_class "cache-config"
begin_test "create default cache"
rm $HOME/.arch-params/=arch-cache
tla get jane@example.com--2003/hello-world--mainline--1.0 foo

begin_test "Cache file created"
test -f $HOME/.arch-params/=arch-cache
end_test
begin_test "Cache file has correct contents"
test $(cat $HOME/.arch-params/=arch-cache) = "$HOME/.arch-cache"
end_test

begin_test "Refusing to use a file as the cache directory"
touch foo
! tla cache-config foo
end_test

begin_test "Setting a relative path as the cache directory"
tla cache-config bar
echo $(pwd) >& 2
cat $HOME/.arch-params/=arch-cache >&2
test $(cat $HOME/.arch-params/=arch-cache) = "$(pwd)/bar"
end_test

begin_test "Disabling the cache"
tla cache-config -d
test "$(cat $HOME/.arch-params/=arch-cache)" = ""
end_test

clean_workdir

# tag: 554b6f6d-1933-48dd-b111-468c3fa6b226
