# Copyright (C) 2001, 2002 Hewlett Packard Corporation
# Licensed under the GNU General Public License

package Bastille::TestAPI;
use lib "/usr/lib";

require Bastille::API;
import Bastille::API;

use Exporter;
@ISA = qw ( Exporter );
@EXPORT = qw(  B_run_test B_is_service_off B_match_line );

$SKIPQ=1;
$ASKQ=0;

###########################################################################
# define tests
###########################################################################
use Bastille::test_AccountSecurity;
use Bastille::test_Apache;
#use Bastille::test_BootSecurity;
#use Bastille::test_ConfigureMiscPAM;
use Bastille::test_DNS;
#use Bastille::test_DisableUserTools;
use Bastille::test_FTP;
#use Bastille::test_FilePermissions;
#use Bastille::test_Firewall;
use Bastille::test_HP_UX;
#use Bastille::test_IOLoader;
#use Bastille::test_Logging;
use Bastille::test_MiscellaneousDaemons;
#use Bastille::test_PSAD;
#use Bastille::test_PatchDownload;
#use Bastille::test_Patches;
#use Bastille::test_Printing;
#use Bastille::test_RemoteAccess;
use Bastille::test_SecureInetd;
use Bastille::test_Sendmail;

#use test_TMPDIR;

use Bastille::IPFilter;
&Bastille::IPFilter::defineTests;

###########################################################################
# &B_run_test($$)
#
# Runs the specified test to determine whether or not the question should
# be answered.
# return values:
# 0:     system is insecure, ask the question
# 1:     system is secure, don't bother
# undef: test is not defined, so you have to ask the question anyway
###########################################################################
sub B_run_test ($$) {
  my $module = $_[0];
  my $key = $_[1];

  if (exists $GLOBAL_TEST{$module}{$key}) {
      my $testout = &{$GLOBAL_TEST{$module}{$key}};
      &ActionLog("\$GLOBAL_TEST{'$module'}{'$key'} returned $testout.\n");
      return $testout;
  } else {
    &ActionLog("\$GLOBAL_TEST{'$module'}{'$key'} is not defined, ask question.\n");
    return undef;
  }
}

###########################################################################
# &B_is_service_off($$)
#
# Runs the specified test to determine whether or not the question should
# be answered.
#
# return values:
# $ASKQ/0:     service is on 
# $SKIPQ/1:     service is off 
# undef: test is not defined
###########################################################################

sub B_is_service_off ($){
   my $service=$_[0];

   
   if(&GetDistro =~ "^HP-UX"){ # not yet implemented for Linux

     # get the list of parameters which could be used to initiate the service
     # (could be in /etc/rc.config.d, /etc/inetd.conf, or /etc/inittab, so we
     # check all of them)
     my @params= @{ &getGlobal('SERVICE',$service) };
     my $grep =&getGlobal('BIN', 'grep');
     my $inetd=&getGlobal('FILE', 'inetd.conf');
     my $inittab=&getGlobal('FILE', 'inittab');
     my $retVals;
     
     foreach my $param (@params) {
        &ActionLog("Checking to see if service $service is off.\n");
        # this line is HP-UX specific

        if (&getGlobal('SERVTYPE', $service) =~ /rc/) {
           my $ch_rc=&getGlobal('BIN', 'ch_rc');
           my $on=`$ch_rc -l -p $param`;

           $on =~ s/\s*\#.*$//; # remove end-of-line comments
	   $on =~ s/^\s*\"(.+)\"\s*$/$1/; # remove surrounding double quotes
	   $on =~ s/^\s*\'(.+)\'\s*$/$1/; # remove surrounding single quotes

           chomp $on;
           &ActionLog("ch_rc returned: $param=$on\n");

           if ($on =~ /^\d+$/ && $on != 0) {
             # service is not off
             ###########################   BREAK out, don't skip question
	       return $ASKQ;
           }
	   elsif($on =~ /^\s*$/) {
	       # if the value returned is an empty string return 
	       # an undef value.
	       return undef;
	   }
       } 
	else {
          # those files which rely on comments to determine what gets
          # turned on, such as inetd.conf and inittab
          my $inettabs=`$grep -e '^[[:space:]]*$param' $inetd $inittab`;
          if ($inettabs =~ /.+/) {  # . matches anything except newlines
             # service is not off
             &ActionLog("Checking inetd.conf and inittab; found $inettabs\n");
             ###########################   BREAK out, don't skip question
             return $ASKQ;
	 } 
        }
     }

     # boot-time parameters are not set; check processes
     my @psnames=@{ &getGlobal('PROCESS',$service)};
     my $grepstring='-e $^ '; # won't match anything and grep won't fail even
                              # if @psnames is empty

     # inetd services don't have a separate process
     unless (&getGlobal('SERVTYPE',$service) eq 'inet') {
       foreach my $psname (@psnames) {
         $grepstring .= '-e ' . $psname . ' ';
       }
     }

     my $ps=&getGlobal('BIN',"ps");
     my $processes = `$ps -ef | $grep $grepstring | $grep -v $grep`;

     if($processes =~ /.+/){  # . matches anything except newlines
       &ErrorLog("WARNING: The following processes were still running even though\n" .
                 "         the corresponding service appears to be turned off.\n" .
                 "         Bastille question and action will be skipped.\n" .

                 "\n$processes\n");
       # processes were still running, service is not off, but we don't know how
       # to configure it so we skip the question
       return $SKIPQ; 
     } else {
       &ActionLog("$service is off.  found no processes in grep $grepstring\n");
       # no processes, so service is off
       return $SKIPQ; 
     }
   } else {
     # not yet implemented for Linux
     # when GLOBAL_SERVICE, GLOBAL_SERVTYPE and GLOBAL_PROCESS are filled 
     # in for Linux, then
     # at least inetd and inittab services should be similar to the above,
     # whereas chkconfig would be used on some Linux distros to determine
     # if non-inetd/inittab services are running at boot time.  Looking at
     # processes should be similar.
     return undef;
   }
}

###########################################################################
# &B_match_line($file,$pattern);
#
# This subroutine will return a 1 if the pattern specified can be matched
# against the file specified.  It will return a 0 otherwise.
#
# return values:
# 0:     pattern not in file 
# 1:     pattern is in file
###########################################################################
sub B_match_line($$) {
    # file to be checked and pattern to check for.
    my ($file,$pattern) = @_;
    # if the file is readable then
    if(-r $file) {
	# if the file can be opened then
	if(open FILE,"<$file") {
	    # look at each line in the file
	    while (my $line = <FILE>) {
		# if a line matches the pattern provided then
		if($line =~ $pattern) {
		    # return the pattern was found
		    return 1;
		}
	    }
	}
	# if the file cann't be opened then
	else {
	    # send a note to that affect to the errorlog
	    &ErrorLog("Unable to open file for read.\n$file\n$!\n");
	}
    }
    # the provided pattern was not matched against a line in the file
    return 0;
}

1;
