# Copyright (C) 2001 Hewlett Packard
# Licensed under the GNU General Public License
# $Id: HP_UX.pm,v 1.17 2001/12/18 00:33:13 hpbuck Exp $
package Bastille::HP_UX;

use Bastille::API;

@ENV="";
$ENV{PATH}="";
$ENV{CDPATH}=".";
$ENV{BASH_ENV}="";

#######################################################################
##                   HP-UX specific hardening steps                  ##
#######################################################################

&StackNoExecute;
&TrustedSystem;
&RestrictSwacls;
&Ndd;
&Netstat;
&IPFilter;


######################################################################
#  StackNoExecute:  This subroutine uses kmtune and mk_kernel
#                   in order to un-set the executable stack kernel
#                   parameter and then recompile the kernel with
#                   the parameter value.
######################################################################

sub StackNoExecute {

  if (&getGlobalConfig("HP_UX","stack_execute") eq "Y") {
       &ActionLog("# sub Stack Execute \n");
       # get binaries to be used...
       my $exportpath = &getGlobal('BIN',"umask") . " 077; export PATH=/usr/bin;";
       my $kmtune = &getGlobal('BIN', "kmtune");       #kmtune's path
       my $mk_kernel = &getGlobal('BIN', "mk_kernel"); #mk_kernel's path
       my @kmdiff;  # will hold current pending kernal parameters
       my @kmq;     # will hold executable stack querry information
       my @kmexecq; #
       # get the current kernel parameter information...
       @kmdiff = `$exportpath $kmtune -d`;
       @kmq = `$exportpath $kmtune -q executable_stack`;
       @kmexecq = split /\s+/, $kmq[2];

       if($kmexecq[1] ne 0){     #executable stack protection is not set
	   if($#kmdiff == 1){ #system tunable parameters are current
	       # going ahead and seting executable_stack param to 0
	       if(&B_System("$exportpath $kmtune -s executable_stack=0","$exportpath $kmtune -s executable_stack=$kmexecq[3]\n")){
		   #changed param successfully
		   &ActionLog("executable_stack tunable parameter is set to secure.\n");

		   if(&B_System("$exportpath $mk_kernel -o /stand/vmunix",
			     "$exportpath $kmtune -s executable_stack=$kmexecq[3]; $mk_kernel -o /stand/vmunix\n")){
		       # Kernel Build Successfull
		       &ActionLog("Kernal Build Successfull: Reboot for changes to take affect\n");
		       &B_TODO("\n Please reboot your system to enable stack execution protection.\n");
		   }
		   else{
		       &ErrorLog("The kernel build failed. Could not compile kernel.\n");
		   }

	       }
	       else{
		   &ErrorLog("The kernel build failed. Could not set tunable parameter.\n");
	       }
	   }
	   else{
	       &ErrorLog("The kernel build failed. Tunable parameters are in and unstable state.\n");
	       &ErrorLog("Resolve the issue shown by the command $kmtune -d\n");
	   }
	   
       }
       else{
	   &ActionLog("System already has kernel level stack execution protection. No changes made.\n");
       }
       
#------------>B_TODO?

   }
}

sub TrustedSystem {
   # do some error checking
   if ( -e &getGlobal("FILE", "nsswitch.conf") ) {
      open(FILE, &getGlobal("FILE", "nsswitch.conf"));
      while (<FILE>) {
         if (/nis/ or /compat/) {
           &B_TODO("Possible conflict between trusted mode and nsswitch.conf found.\n" .
                   "Please use SAM to convert to trusted mode.\n");
           exit 1;
         }
      }
   }

   if (&getGlobalConfig("HP_UX","trusted_system") eq "Y") {
      &ActionLog("# sub Trusted System (convert) \n");
      &B_System(&getGlobal('BIN','tsconvert'), &getGlobal('BIN','tsconvert') . " -r");

      if(&B_System(&getGlobal('BIN','tsconvert'), &getGlobal('BIN','tsconvert') . " -r")){
         &B_TODO("Your system has been converted to a trusted system.\n" . 
		 "You should review the security settings of trusted system.\n" .
		 "These settings can be modified by running SAM as follows:\n" .
		 "# sam\n" .
		 "Make sure that you review all of your settings as some policies may\n" . 
		 "seem restictive.\n\n");
      }

      if (&getGlobalConfig("HP_UX","single_user_password") eq "Y") {
         &ActionLog("# sub Trusted System (sgl user pwd) \n");
         &B_System(&getGlobal('BIN','modprdef') . " -m bootpw=YES", 
                   &getGlobal('BIN','modprdef') . " -m bootpw=NO");   
      }

   } elsif (&getGlobalConfig("HP_UX","single_user_password") eq "Y") {
      &ErrorLog("ERROR:  You can only set a password for single user mode " .
                "if you convert to a trusted system.");
   }
}


sub RestrictSwacls {
   if (&getGlobalConfig("HP_UX","restrict_swacls") eq "Y") {
       &ActionLog("# sub Restrict SWACLS\n");
      # get the current permissions to store for undo later
      my $swacl = &getGlobal('BIN','swacl');
      my $grep  = &getGlobal('BIN','grep');
      my $cut   = &getGlobal('BIN','cut');
      my $hostperms = `$swacl -l host | $grep -E '^any_other' | $cut -d: -f2`;
      my $rootperms = `$swacl -l root | $grep -E '^any_other' | $cut -d: -f2`;
       # if no value is set for current permissions add any_other:-
       # which is effectively the same as removing it all together.
       if($hostperms =~ /^\s*$/){
	   $hostperms = "-";
       }
       if($rootperms =~ /^\s*$/){
	   $rootperms = "-";
       }

      # actually make the change
      # edit host permissions  NO one off of host
      &B_System(&getGlobal('BIN','swacl') . " -l host -D any_other", 
                &getGlobal('BIN','swacl') . " -l host -M any_other:$hostperms");
      # edit user permissions NO one except root
      &B_System(&getGlobal('BIN','swacl') . " -l root -D any_other", 
                &getGlobal('BIN','swacl') . " -l root -M any_other:$rootperms");

   }
}

sub Ndd {

   # key is           NDD_NAME 
   # array element[0] TRANSPORT_NAME 
   # array element[1] NDD_VALUE (new)
   my %newNDD = (
      "ip_forward_directed_broadcasts" =>["ip",   "0"],
      "ip_forward_src_routed"          =>["ip",   "0"],
      "ip_forwarding"                  =>["ip",   "0"],
      "ip_ire_gw_probe"                =>["ip",   "0"],
      "ip_pmtu_strategy"               =>["ip",   "1"],
      "ip_respond_to_echo_broadcast"   =>["ip",   "0"],
      "ip_send_redirects"              =>["ip",   "0"],
      "ip_send_source_quench"          =>["ip",   "0"],
      "ip_strong_es_model"             =>["ip",   "1"],
      "tcp_conn_request_max"           =>["tcp","500"] );


   if (&getGlobalConfig("HP_UX","ndd") eq "Y") {
       &ActionLog("# sub Ndd\n");
       # get all current values (-A) starting with any of the given names
       my $ch_rc = &getGlobal('BIN','ch_rc');
       my @origParams = 
	   `$ch_rc -l -A -v -p TRANSPORT_NAME -p NDD_NAME -p NDD_VALUE`;
       my $ndd_call = &getGlobal('BIN','ndd');
       
       my $nddComplete = 1;
       for my $newNDDKey (keys %newNDD){
	   my $nddGetValue = `$ndd_call -get /dev/$newNDD{$newNDDKey}[0] $newNDDKey`;
	   chomp $nddGetValue;
	   if($nddGetValue ne $newNDD{$newNDDKey}[1]) {
	       $nddComplete = 0;  # if the machine already has the proper ndd values
	   }                      # then mark nddComplete.
       }

      # $#origParams returns the last index (0 if there is one element)
      # if there are any parameters already set in nddconf, then we need to
      # have some manual intervention, because any merge will probably mess
      # things up
      if($#origParams > -1 && (! $nddComplete) ) {
        my $ndd_text = 
           "This version of Bastille cannot resolve the ndd configuration\n" .
           "changes that were selected.  The following are the parameters\n" .
           "and the suggested values.\n" .
           "\n" . 
           "                                  Default    Suggested\n" .
           "                                             for security\n" .
           "---------------------------------------------------------\n" .
           "ip_forward_directed_broadcasts       1   =>    0\n" .
           "ip_forward_src_routed                1   =>    0\n" .
           "ip_forwarding                        2   =>    0\n" .
           "ip_ire_gw_probe                      1   =>    0\n" .
           "ip_pmtu_strategy                     2   =>    1\n" .
           "ip_respond_to_echo_broadcast         1   =>    0\n" .
           "ip_send_redirects                    1   =>    0\n" .
           "ip_send_source_quench                1   =>    0\n" .
           "ip_strong_es_model                   0   =>    1\n" .
           "tcp_conn_request_max                20   =>  500\n" .
           "\n" .
           "You will need to merge your current ndd settings in \n" .
           "&getGlobal('FILE', 'nddconf') with these manually.\n\n" .
           "For more information on each of these parameters, run\n" .
           "\n" .
           "ndd -h\n";
         
        &B_TODO($ndd_text);
      } elsif (! $nddComplete) {
        # setting bastille backend values of nddconf
        my $index = 0;
	# this string will allow bastille to undo the changes made to 
	# the ndd settings.
	my $undoString =""; 

	# This for generates the configuration file for ndd and it generates
	# the undoString which will put the system back to it's initial state
	# when UndoBastille is run.
        for my $newNDDKey (keys %newNDD){
	   # string to be added to the configuration file
           my $paramstring = 
                " -p TRANSPORT_NAME[${index}]=" . $newNDD{$newNDDKey}[0] .
                " -p NDD_NAME[${index}]=" . $newNDDKey .
                " -p NDD_VALUE[${index}]=" . $newNDD{$newNDDKey}[1];

	   # string that receives the current value of the newNDDKey 
           my $ndd_call = &getGlobal('BIN','ndd');
	   my $nddGetValue = `$ndd_call -get /dev/$newNDD{$newNDDKey}[0] $newNDDKey`;
	   chomp $nddGetValue;
	   # string that is generated to put ndd back to its pre-Bastilled state
	   $undoString .= "ndd -set /dev/" . $newNDD{$newNDDKey}[0] .
	       " " . $newNDDKey . " " . $nddGetValue . "\n";


           &B_System (&getGlobal('BIN','ch_rc') . " -a $paramstring " .
                          &getGlobal('FILE', 'nddconf'),
                      &getGlobal('BIN','ch_rc') . " -r $paramstring");

           $index++;
        }    
        # re-read config file after setting new parameters (at run time)
        &B_System (&getGlobal('BIN',"ndd") . " -c","$undoString");
      }
   }
}

# The purpose of this subroutine is to add to the TODO.txt list some information
# about how the user should determine which ports are world listening
sub Netstat {
    if (&getGlobalConfig("HP_UX","scan_ports") eq "Y") {
	&ActionLog("# sub Netstat\n");
	my $netstat_text = 
	    "Run a portscan to see what processes are still listening:\n" .
            "You can either use the built-in tool \"netstat\" like:\n" .
	    "  /usr/bin/netstat -an\n" .
            "or you can download the \"lsof\" tool from\n" .
            "  ftp://vic.cc.purdue.edu/pub/tools/unix/lsof/\n" .
            "and then run\n" .
            "  /path/to/lsof -i\n" .
            "for a comprehensive listing of processes which are listening on\n" .
            "external ports.  More information is in the netstat man page and\n" .
            "the lsof documentation.\n\n";
	&B_TODO($netstat_text);
    }
}

# The purpose of this subroutine is to add to the TODO.txt list some information
# about locating and installing IPFilter
sub IPFilter {
    if(&getGlobalConfig("HP_UX","ipfilter") eq "Y"){
	&ActionLog("# sub IPFilter");
	my $IPFilter_text =
	    "IPFilter is currently available on a DART CD-ROM and at http://software.hp.com\n" .
	    "Install IPFilter from the source of your choice and then write the appropriate\n" .
		"ruleset that matches your systems needs.\n\n";
	&B_TODO($IPFilter_text);
    }
}
	
1;









