# Copyright (C) 1999, 2000 Jay Beale
# Licensed under the GNU General Public License

package Bastille::DNS;
use lib "/usr/lib";

use Bastille::API;
@ENV="";
$ENV{PATH}="";
$ENV{CDPATH}=".";
$ENV{BASH_ENV}="";

######## TO DO: Convert the chown line to API functions, so we don't
#########       have to use GLOBAL_PREFIX

#######################################################################
##                             DNS/BIND/NAMED                        ##
#######################################################################

&chrootBIND;
&DeactivateNamed;


sub chrootBIND {

    if ( &getGlobalConfig("DNS","chrootbind") eq "Y" ) {
	&ActionLog("# sub chrootBIND\n");

	# Only chroot bind if we are running on a Red Hat / Mandrake / HP-UX 
        # system and we haven't already chroot'ed it...
	if($GLOBAL_DISTRO =~ "^HP-UX"){
            my $extrasteps=0;

            # create non-privileged user and group named
            my $groupadd = 'PATH="/usr/bin"; ' . &getGlobal('BIN',"groupadd") . " named";
            my $groupdel = 'PATH="/usr/bin"; ' . &getGlobal('BIN',"groupdel") . " named";

            if (! &B_System($groupadd,$groupdel)) {
               $extrasteps = 1;
            }

            my $jail = &getGlobal('BDIR',"jail");

            my $useradd = 'PATH="/usr/bin"; ' . &getGlobal('BIN',"useradd") . 
                            " -g named -d $jail/bind -s /usr/bin/false named"; 
            my $userdel = 'PATH="/usr/bin"; ' . &getGlobal('BIN',"userdel") . " named";

            if (! &B_System($useradd, $userdel)) {
               $extrasteps = 1;
            }

	    # install generic chroot tree
	    if(&B_install_jail("bind",&getGlobal('BFILE',"jail.generic.hpux"))) {
                my $success=0;
		# add dev/null and dev/log to chroot tree
		&B_mknod("", "$jail/bind/dev/null","c 3 0x000002");
		&B_chmod(0666,"$jail/bind/dev/null");
		&B_System(&getGlobal('BIN','mkfifo') . " -p -m 0666 " . $jail . "/bind/dev/log",
			  &getGlobal('BIN','rm') . " -f " . $jail . "/bind/dev/log\n" . 
			  &getGlobal('BIN',"echo") . " \"Your DNS is not running outside of it's\\n" . 
			  "chroot jail.  You must manually migrate your named server\\n" .
			  "back to your Named server's default defined location(s).\\n".
			  "After you have completed this, feel free to remove the jail directories\\n" .
			  "from your machine.  Be sure to reset NAMED_ARGS to equal \\\"-u daemon\\\"\\n" . 
			  "in /etc/rc.config.d/namesvrs and then restart the daemon using the init\\n" . 
			  "scripts.  Your bind jail directory is located in\\n" .
			  &getGlobal('BDIR',"jail") . "\\n\" >> " . &getGlobal('BFILE',"TOUNDO"));

		if(-e &getGlobal('BIN',"named-xfer")){
		    # install bind 8 specific files and directories.
		    &ActionLog("Bind 8 chroot directory setup\n");
                    if (&B_install_jail("bind", &getGlobal('BFILE',"jail.bind.hpux"))){
                       $success=1;
		    }
                } elsif(-e &getGlobal('FILE',"named")){
		    # install bind 9 specific files and directories.
		    &ActionLog("Bind 9 chroot directory setup\n");
		    if(&B_install_jail("bind",&getGlobal('BFILE',"jail.bind9.hpux"))){
                      $success=1;
		    }
		} else {
                    &ErrorLog("Bind does not appear to be on this system; no action was taken.\n");
                }

                if ($success) {
                   &B_System(&getGlobal('BIN',"cat") . " " .&getGlobal('FILE',"group") . " | " .
                             &getGlobal('BIN',"grep") . " named > $jail/bind/etc/group", "");

                   &B_chmod(0444, "$jail/bind/etc/group");
                   &B_chown("bin", "$jail/bind/etc/group");
                   &B_chgrp("bin", "$jail/bind/etc/group");

                   my $ch_rc = &getGlobal('BIN',"ch_rc");
                   my $initscript = &getGlobal('FILE',"chkconfig_named");
                   my $syslogd = &getGlobal('BIN',"syslogd");
                           #--80 chars wide----------------------------------------------------------------
                   &B_TODO("Chroot'ed Bind:\n" .
                           "Bastille has created a simple \"named\" directory structure in\n" .
                           "$jail/bind/\n\n" .

                           "You need to take the following steps to configure your name server\n" .
                           "to run without root privileges in a chroot jail:\n\n");

                   if ($extrasteps==1) {
                      &B_TODO("First, there were errors recorded in the error log which you will \n" .
                              "need to resolve.  Depending on the severity of the errors, you may \n" .
                              "or may not be able to continue with the following steps.  The most\n" .
                              "likely error is that a \"named\" user or group already exists, in which\n" .
                              "case the following steps should work just fine and \"named\" will run as\n" .
                              "that user.\n\n");
                   }

                   my $pidfile = &getGlobal('FILE', "named.pid");

                   &B_TODO("1: Stop the currently running \"named\" process using the system\'s\n" .
                           "   init script for \"named\" \n\n" .

                           "   type_this> $initscript stop\n\n" .

                           "   and remove all \"/var/run/named.*\" files if they exist.\n\n" .

                           "   type_this> rm -r /var/run/named.*\n\n" .

                           "2: Next, move all of the configuration files that the current \n" .
                           "   \"named\" implementation requires from their current locations into\n" .
                           "   the equivalent place in the jail  structure.  This is at least a\n" .
                           "   \"named.conf\" file. If there is a directory path specified in the\n" .
                           "   options section of the \"named.conf\", that path must be made as well\n" .
                           "   as all of the files that are referenced from that directory.  Remember\n" .
                           "   that any files owned by the named user can be modified if an attacker\n" .
                           "   breaks into bind as the \"named\" user.\n\n" . 

                           "3: Instruct the \"named\" init script to chroot into the new environment:\n\n" .

                           "   type_this> $ch_rc" . " -a -p NAMED_ARGS=\"-u named -t $jail/bind\"\n\n".

                           "4: Start named in its chroot jail using the named init script\n\n" .

                           "   type_this> $initscript start\n");
                } else {
                   &ErrorLog("Error trying to install the chroot bind jail.\n");
                }
           }
	} else {
	    my $home_dns="/home/dns";
	
	    if (( not ( -d "${GLOBAL_PREFIX}$home_dns" ) ) and (($GLOBAL_DISTRO =~ /^RH/)  or ($GLOBAL_DISTRO =~ /^MN/) )) {
		
		# We place BIND in a chroot'd environment, following the 
		# instructions in SANS Step by Step 4.3.3
		
		my $user ="";
		my $group = "";
		my $gid = "";

		#
		# Create the dns user, if one doesn't yet exist
		#

		# Look for a DNS user already on the operating system
		if (open PASSWD,"/etc/passwd") {
		    my @lines = <PASSWD>;
		    close PASSWD;
		    chomp @lines;

		    foreach $name ( 'dns','named' ) {
			if (grep /^$name:/,@lines) {
			    $user = $name;
			}
		    }
		}
		if ($user) {
		    $home_dns = (getpwnam($user))[7];
		}
		else {
		    $home_dns = '/home/dns';	 
		}

                # Make the dns chroot directory
		&B_create_dir ( $home_dns );  		

		# Look for a DNS group already on the operating system
		if (open PASSWD,"/etc/group") {
		    my @lines = <PASSWD>;
		    close PASSWD;
		    chomp @lines;

		    foreach $name ( 'dns','named' ) {
			if (grep /^$name:/,@lines) {
			    $group = $name;
			    $gid = getgrnam($name);
			}
		    }
		}

		# Create whatever users or groups are necessary
		unless ($group) {
		    $gid = '53';
		    &B_append_line ("/etc/group",":53:","dns:x:53:\n");
		    $group = 'dns';
		}
		unless ($user) {		    
		    &B_append_line ("/etc/passwd",":$gid:","dns:x:53:$gid::$home_dns:/bin/false\n");
		    &B_append_line("/etc/shadow","^dns:","dns:*:11089:0:99999:7:::\n");
		    $user = 'dns';
		}
		
		# Populate the dns chroot directory
		&B_create_dir ("$home_dns");
		&B_create_dir ("$home_dns/etc");
		&B_chmod (0755,"$home_dns/etc");
		&B_create_dir ("$home_dns/lib");
		&B_chmod (0755,"$home_dns/lib");
		&B_create_dir ("$home_dns/dev");
		&B_chmod (0755,"$home_dns/dev");
		&B_create_dir ("$home_dns/usr");
		&B_chmod (0755,"$home_dns/usr");
		&B_create_dir ("$home_dns/usr/sbin");
		&B_chmod (0755,"$home_dns/usr/sbin");
		&B_create_dir ("$home_dns/var");
		&B_chmod (0755,"$home_dns/var");
		&B_create_dir ("$home_dns/var/named");
		&B_chmod (0755,"$home_dns/var/named");
		&B_create_dir ("$home_dns/var/run");
		&B_chmod (0755,"$home_dns/var/run");
		&B_create_dir ("$home_dns/var/run/named");
                &B_chmod (0755,"$home_dns/var/run/named");

		
		unless ($GLOBAL_LOGONLY) {
		    &B_mknod(" -m 666 ","$home_dns/dev/null"," c 1 3");
		    
		    &B_cp("/etc/named.conf","$home_dns/etc/named.conf");
		    
		    # Should we tell them to move their name logs over?
		    
		    &B_cp("/var/named/named.ca","$home_dns/var/named/named.ca");
		    &B_cp("/var/named/named.local","$home_dns/var/named/named.local");
		    
		    my $command=&getGlobal('BIN',"chown");
		    `$command -R $user.$user ${GLOBAL_PREFIX}$home_dns/var/named $home_dns/var/run $home_dns/var/run/named`;
		    &B_cp("/usr/sbin/named","$home_dns/usr/sbin/named");
		    &B_chmod(0755,"$home_dns/usr/sbin/named");
		    # Don't delete named -- let it get loaded from /usr/sbin, but
		    # find data files in the chroot directory.  We'll still put 
		    # a copy of the binary in the chroot directory so the named
		    # binary can be reloaded from there if necessary.
		    #
		    #&B_delete_file("/usr/sbin/named");
		    my $namedxfer = &getGlobal('BIN',"named-xfer");
		    if (-e $namedxfer ) {
			&B_cp($namedxfer,"$home_dns" . $namedxfer);
			&B_chmod(0755,"$home_dns" . $namedxfer);
		    }
		    &B_cp("/lib/libc.so.6","$home_dns/lib/libc.so.6");
		    &B_cp("/lib/ld-linux.so.2","$home_dns/lib/ld-linux.so.2");
		}
		
		# named communicates normally with syslog via the device /dev/log, 
		# which isn't accessible from the chroot'd environment.  We set 
		# syslog to create and listen to a specific device just for bind.
		
		&B_replace_line("/etc/rc.d/init.d/syslog",'daemon syslogd -m 0\s*\$',"daemon syslogd -m 0 -a $home_dns/dev/log\n");
                &B_replace_line("/etc/rc.d/init.d/syslog",'daemon syslogd $SYSLOGD_OPTIONS\s*\$',"daemon syslogd \$SYSLOGD_OPTIONS -a $home_dns/dev/log\n");
	
	
		# Modify named's init script to use the chroot environment

		my $bind8=1;	
		if ($GLOBAL_DISTRO =~ /MN(\d+\.\d+)/) {
			if ($1 >= 8.0) {
				$bind8=0;
			}
		}
		elsif ($GLOBAL_DISTRO =~ /RH(\d+\.\d+)/) {
                        if ($1 >= 7.1) {
                                $bind8=0;
			}	 
		}
	
		if ( $bind8 ) {
		    &B_replace_line("/etc/rc.d/init.d/named",'^\s*daemon\s+named',"daemon named -u $user -g $group -t $home_dns\n");
		}
		else {
		    # Mandrake 8.0 and later, along with Red Hat 7.1 and later, use BIND 9, which deprecated the -g option.
		    # Nicely, all of these run as an alternate user already.

		    if ($GLOBAL_DISTRO =~ /MN/) {
		        &B_replace_line("/etc/rc.d/init.d/named",'^\s*daemon\s+named',"daemon named -u $user -t $home_dns\n");  
		    }
		    elsif ($GLOBAL_DISTRO =~ /RH/) {
			&B_append_line('/etc/sysconfig/named','^\s*ROOTDIR\s*\=\s*',"ROOTDIR=$home_dns\n");
		    }
		}
		
	    }
	    else {
		# We only do this to Red Hat and Mandrake boxes for now, because
		# we'd have to find all the libraries and modify startup files
		# and this can just be totally difficult to automate when you
		# don't know the target...
		
		&ErrorLog("Couldn't chroot named! Not on a Red Hat / Mandrake box or $home_dns already exists.\n");
	    }
	    
	} 
    }
}


sub DeactivateNamed { 


    if (&getGlobalConfig("DNS","namedoff") eq "Y") {

	&ActionLog("# sub DeactivateNamed\n");

	# Deactivate BIND unless it is being used.

	&B_chkconfig_off ("named");
    }

} 


1;





