# Copyright (C) 1999, 2000 Jay Beale
# Copyright (C) 2001 Hewlett Packard
# Licensed under the GNU General Public License

package Bastille::AccountSecurity;
use lib "/usr/lib";


use Bastille::API;

# 5/3/2000 -- new version created from old by JJB

#  TO DO:
#        1) Document by copying text from questions file...

#######################################################################
##                     Account Creation/Security                     ##
#######################################################################

&ProtectRhosts;
&PasswordAging;
&RestrictCron;
&SetUmask;
&RootTTYLogins;
&RestrictPathMDK;

sub ProtectRhosts {

    if ( &getGlobalConfig("AccountSecurity","protectrhost") eq "Y" ) {

	&ActionLog("# sub ProtectRhosts\n");

	# Disallow rlogin,rsh,rexec via Pluggable Authentication Modules
	unless ( $GLOBAL_DISTRO =~ "HP-UX" ) {
	    foreach $service ( "rexec","rlogin","rsh" ) {
		if ( -e $GLOBAL_PREFIX.&getGlobal('DIR', "pamd") . "/$service" ) {
		    &B_prepend_line(&getGlobal('DIR', "pamd") . "/$service","pam_deny","auth      required   pam_deny.so\n");
		}
	    }
	}
	# Deactivate the daemons by removing execute status
	&B_chmod_if_exists(0000,&getGlobal('BIN',"rlogind"));
	&B_chmod_if_exists(0000,&getGlobal('BIN',"rshd"));
	&B_chmod_if_exists(0000,&getGlobal('BIN',"rexecd"));
	
	# Comment out rsh/rlogin/rexec lines from inetd.conf
	if ( -e $GLOBAL_PREFIX . &getGlobal('FILE', "inetd.conf") ) {

	    if ( $GLOBAL_DISTRO =~ "^HP-UX" ){ #send SIGHUP to inetd to re-read inetd.conf
		&B_System(&getGlobal('BIN',"inetd") . " -c", &getGlobal('BIN',"inetd") . " -c");
	    }

	    &B_hash_comment_line( &getGlobal('FILE', "inetd.conf"),"rlogind");
	    &B_hash_comment_line( &getGlobal('FILE', "inetd.conf"),"rexecd");
	    if ( $GLOBAL_DISTRO =~ "HP-UX" ) {
		&B_hash_comment_line( &getGlobal('FILE', "inetd.conf"),"remshd");
	    }
	    else {
		&B_hash_comment_line( &getGlobal('FILE', "inetd.conf"),"rshd");
	    }

	    if ( $GLOBAL_DISTRO =~ "^HP-UX" ){ #re-send SIGHUP to inetd to re-read inetd.conf
		&B_System(&getGlobal('BIN',"inetd") . " -c", &getGlobal('BIN',"inetd") . " -c");
	    }

	}   
    }
}


sub PasswordAging {

# Set default password aging, such that accounts are disabled if the
# password is not changed every 180 days.  We use this hopefully to keep
# passwords fresh and automatically disable accounts that haven't been 
# used in a while.  We could create a cron job that parses lastlog looking
# for unused accounts, but that would fail if your lastlog got deleted by
# an attacker or cycled by your log cycler, as the cron job would disable
# many accounts...

    if (&getGlobalConfig("AccountSecurity","passwdage") eq "Y") {
	&ActionLog("# sub Password Aging\n");
	&ActionLog("adding PASS_MAX_DAYS setting to /etc/login.defs\n");
	
        my $got_replaced=&B_replace_line("/etc/login.defs",'^\s*PASS_MAX_DAYS',"PASS_MAX_DAYS   180\n");
        unless ($got_replaced) {
            B_append_line("/etc/login.defs",'^\s*PASS_MAX_DAYS',"PASS_MAX_DAYS   180\n");
        }
    }				      
}



sub RestrictCron {

   if ( &getGlobalConfig("AccountSecurity","cronuser") eq "Y" ) {

       &ActionLog("# sub RestrictCron\n");

	# We do this even if cron isn't installed/enabled, because
	# it doesn't hurt

       # Create an /etc/cron.allow file, thus restricting crontab's use to
       # root (and other users that might be added to this list)

       # Create the cron.allow file, unless it already exists.
       &B_create_file ("/etc/cron.allow");

       # Append a list of accounts that can use cron -- only adding lines
       # if they're not yet in there...

       &B_append_line("/etc/cron.allow",'^root$',"root\n");
       
   }
}

sub SetUmask {
    if ( &getGlobalConfig("AccountSecurity","umask") ) {

	&ActionLog("# sub SetUmask\n");

	my $umask = &getGlobalConfig("AccountSecurity","umask");
	if ( -e $GLOBAL_PREFIX . &getGlobal('FILE', "profile") ) {
	    &B_append_line( &getGlobal('FILE', "profile"),'/^([^#]*)umask/',"umask $umask\n");
	    &B_replace_line( &getGlobal('FILE', "profile"),'/^([^#]*)umask/',"umask $umask\n");
	}
	if ( -e $GLOBAL_PREFIX . &getGlobal('FILE', "zprofile") ) {
	    &B_append_line(&getGlobal('FILE', "zprofile"),'/^([^#]*)umask/',"umask $umask\n");
	    &B_replace_line(&getGlobal('FILE', "zprofile"),'/^([^#]*)umask/',"umask $umask\n");
	}
	if ( -e $GLOBAL_PREFIX . &getGlobal('FILE', "csh.login") ) {
	     &B_append_line(&getGlobal('FILE', "csh.login"),'/^([^#]*)umask/',"umask $umask\n");
	     &B_replace_line(&getGlobal('FILE', "csh.login"),'/^([^#]*)umask/',"umask $umask\n");
	 }
    }
}

sub RootTTYLogins {
    if ( &getGlobalConfig("AccountSecurity","rootttylogins") eq "Y" ) {
	&ActionLog("# sub RootTTYLogins\n");
	
	my $tty;
	foreach $tty (1,2,3,4,5,6) {
	    &B_delete_line("/etc/securetty","tty$tty");
	}

	# stop root from logging in via xdm as well
	#

	#&B_append_line("/etc/X11/xdm/Xresources","xlogin\.Login\.allowRootLogin","xlogin.Login.allowRootLogin: false");
	&B_create_file("/etc/bastille-no-login");
	&B_append_line("/etc/bastille-no-login",'\broot\b',"root\n");
	&B_prepend_line("/etc/pam.d/xdm",'bastille-no-login',"auth\trequired\t/lib/security/pam_listfile.so onerr=succeed item=user sense=deny file=/etc/bastille-no-login");

	# stop root from logging in via gdm
	#&B_replace_line("/etc/X11/gdm/gdm.conf",'^\s*AllowRoot\b',"AllowRoot=0\n");
	&B_prepend_line("/etc/pam.d/gdm",'bastille-no-login',"auth\trequired\t/lib/security/pam_listfile.so onerr=succeed item=user sense=deny file=/etc/bastille-no-login");
	# stop root from logging in via kdm
	&B_prepend_line("/etc/pam.d/kde",'bastille-no-login',"auth\trequired\t/lib/security/pam_listfile.so onerr=succeed item=user sense=deny file=/etc/bastille-no-login");
    

#    } #Shouldn't make changes when the user picks "no" on a question.  Also, this changes 
#      #systems even when the question wasn't asked (other distros) "else" commented out Jul 23 2001 - RwF
#    else {
#	my $tty;
#        foreach $tty (1,2,3,4,5,6) {
#            &B_append_line("/etc/securetty","tty$tty","tty$tty\n");
 #       }
    }
    #BUG  we need to allow the user to reverse this on gdm,xdm and kdm too
	 	
}

sub RestrictUserView {
    
    # This routine restricts the kdm/gdm userview in Linux-Mandrake
    # Motivation: Compabilitity with msec

    if (&getGlobalConfig("AccountSecurity","forbiduserview") eq "Y") {
	&ActionLog("# sub RestrictUserView\n");

	&B_replace_line("/usr/share/config/kdmrc",'^UserView=',"UserView=false=n");
	&B_replace_line("/etc/X11/gdm/gdm.conf","^Browser=","Browser=0\n");
    }
}

sub RestrictPathMDK {

  # This is only for Mandrake 7.x - 8.x 
    if ( ($GLOBAL_DISTRO =~ /^MN[78]/) ) {
	if (&getGlobalConfig("AccountSecurity","restrict_path_mdk") eq "Y") {

	    &ActionLog("# sub RestrictPathMDK\n");

	    my $line = 'export PATH=$PATH:/usr/X11R6/bin:/usr/games' . "\n";
	    &B_append_line('/etc/profile','^[^\#]*\bexport\s*PATH\=',$line)
		&B_append_line('/etc/zprofile','^[^\#]*\bexport\s*PATH\=',$line);
	}
	if (&getGlobalConfig("AccountSecurity","restrict_path_mdk") eq "N") {
	    &ActionLog("# sub RestrictPathMDK\n");
	    
	    my $insecure_line = 'export PATH=$PATH:/usr/X11R6/bin:/usr/games:.' . "\n";
	    &B_append_line('/etc/profile','^[^\#]*\bexport\s*PATH\=',$insecure_line);
	    &B_append_line('/etc/zprofile','^[^\#]*\bexport\s*PATH\=',$insecure_line);
	}
	
	if (&getGlobalConfig("FilePermissions","security_level")) {
	    my $line = "export SECURE_LEVEL=" . &getGlobalConfig("FilePermissions","security_level") . "\n";
	    &ActionLog("# Sub RestrictPathMDK - security_level\n");
	    B_append_line('/etc/profile',"export SECURE_LEVEL",$line);
	    B_append_line('/etc/zprofile',"export SECURE_LEVEL",$line);
	}
    } # end if Mandrake 7/8
}


1;

