Template: apt-setup/uri_type
Type: select
Choices: cdrom, http, ftp, filesystem, edit sources list by hand
Choices-sv: cdrom, http, ftp, filsystem, redigera kllistan fr hand
Default: cdrom
Description: Choose the method apt should use to access the Debian archive:
 Apt can access the Debian archive in a variety of ways. Choose the access
 method apt should use. For example if you have a Debian cd, select
 "cdrom", while if you plan to install via a Debian mirror, choose "ftp" or
 "http". 
 .
 ${note} 
Description-sv: Vlj metod som apt ska anvnda fr att komma t Debianarkivet:
 Apt kan komma t Debianarkivet p ett flertal olika stt. Vlj det tkomststt
 som apt ska anvnda. Om du exempelvis har en Debian-CD s vljer du "cdrom",
 medan du ska vlja "http" eller "ftp" om du planerar att installera frn en
 Debianspegling.
 .
 ${note}

Template: apt-setup/country
Type: select
Choices: ${countries}
Default: United States
Description: Select a country:
 Select the country the mirror should be in. The goal is to find a mirror
 that is close to you on the network -- be aware that near countries, or
 even your own, may not be the best choice. 
Description-sv: Vlj ett land:
 Vlj det land som speglingen ska vara i. Mlet r att hitta en spegling som
 r nra dig p ntverket -- var medveten om att nrliggande lnder, eller
 till och med ditt eget land, inte behver vara det bsta valet.

Template: apt-setup/mirror
Type: select
Choices: ${mirrors}
Default: http.us.debian.org
Description: Choose the Debian mirror to use:
 Select the Debian mirror apt should use. You should select a mirror that
 is close to you on the net. 
Description-sv: Vlj Debianspegling att anvnda:
 Vlj den Debianspegling som apt ska anvnda. Du br vlja en spegling som
 r nra dig p ntet.

Template: apt-setup/hostname
Type: string
Description: Enter mirror hostname:
 Enter the hostname of the Debian mirror you want to use. 
Description-sv: Ange speglingens vrdnamn:
 Ange vrdnamet p den Debianspegling du vill anvnda.

Template: apt-setup/directory
Type: string
Default: /debian
Description: Enter mirror directory:
 Enter the directory the Debian mirror is located in. 
Description-sv: Ange speglingskatalogen:
 Ange katalogen i vilken Debianspeglingen ligger.

Template: apt-setup/baddir
Type: note
Description: Mirror not found.
 The directory you entered does not exist. 
Description-sv: Speglingen hittades inte.
 Katalogen som du angav existerar inte.

Template: apt-setup/not-mirror
Type: note
Description: Mirror not found.
 The directory you entered does not contain a subdirectory named "dists",
 so it doesn't seem to be a Debian mirror. 
Description-sv: Speglingen hittades inte.
 Katalogen som du angav innehller inte en underkatalog kallad "dists", s det
 verkar inte vara en Debianspegling.

Template: apt-setup/cd/dev
Type: string
Description: Enter CD ROM device file:
 This program was unable to auto-detect a CD ROM drive, or there is no
 usable CD in the drive. Enter the device file to use to access your CD
 ROM, and place a Debian CD in the drive. 
Description-sv: Ange CD-ROM-enhetsfilen:
 Detta program kunde ej automatiskt upptcka en CD-ROM-enhet, eller s finns det
 ingen anvndbar CD i enheten. Ange enhetsfilen som ska anvndas fr att komma
 t din CD-ROM, och placera en Debian-CD i enheten.

Template: apt-setup/cd/bad
Type: note
Description: Bad CD
 Your CD drive was detected, but it does not seem to have a Debian CD in
 it. 
Description-sv: Dlig CD
 Din CD-enhet upptcktes, men den verkar inte ha en Debian-CD i sig.

Template: apt-setup/cd/another
Type: boolean
Default: false
Description: Scan another CD?
 If you have another Debian CD (for example, the second in a two CD set),
 you should insert and scan it now. 
Description-sv: Skanna en annan CD?
 Om du har en annan Debian-CD (exempelvis, den andra i en uppsttning av tv)
 ska du stta in och skanna den nu.

Template: apt-setup/non-free
Type: boolean
Default: false
Description: Use non-free software?
 Some non-free software has been made to work with Debian. Though this
 software is not at all a part of Debian, standard Debian tools can be 
 used to install it. This software has varying licenses which may prevent
 you from using, modifying, or sharing it. Do you want to have it available
 anyway?
Description-sv: Anvnd icke-fri programvara?
 Viss icke-fri ("non-free") programvara har anpassats fr att fungera med
 Debian. Trots att denna programvara inte alls r en del av Debian kan
 standardverktygen anvndas fr att installera den. Denna programvara har
 varierande licenser som kan hindra dig frn att anvnda, ndra eller
 dela med dig av den. Vill du nd gra den tillgnglig?

Template: apt-setup/non-us
Type: boolean
Default: true
Description: Use non-US software?
 Some software in Debian must be downloaded from sites outside the United
 States. This includes some cryptographic software, and some software with
 patent problems in the US. Do you want this software to be made available
 to you? 
Description-sv: Anvnd "non-US"-programvara?
 Viss programvara i Debian mste laddas ner frn sidor utanfr Frenta
 Staterna. Detta innefattar viss kryptografisk programvara, och viss
 programvara som har patentproblem i USA. Vill du att denna programvara ska
 gras tillgnglig fr dig?

Template: apt-setup/contrib
Type: boolean
Default: false
Description: Use contrib software?
 Some additional software has been made to work with Debian. Though this
 software is free, it depends on non-free software for its operation.
 This software is not at all a part of Debian, but standard Debian 
 tools can be used to install it. Would you like to have it available?
Description-sv: Anvnd "contrib"-programvara?
 Viss ytterligare programvara har anpassats fr att fungera med Debian. Trots
 att denna programvara r fri s krver den icke-fri programvara fr dess
 funktion. Denna programvara r inte alls en del av Debian, men Debians
 standardverktyg kan anvndas fr att installera den. Vill du ha den
 tillgnglig?

Template: apt-setup/distribution
Type: select
Choices: stable, unstable, testing
Default: stable
Description: Select Debian distribution to use:
 Debian comes in several flavors. Stable is well-tested and rarely changes.
 Unstable is untested and frequently changing. Testing is a middle ground,
 that receives many of the new versions from unstable if they are not too
 buggy. Which version of Debian do you wish to install?
Description-sv: Vlj Debiandistribution att anvnda:
 Debian kommer i flera skepnader. "Stable" r vltestad och ndras sllan.
 "Unstable" r otestad och ndras ofta. "Testing" r ett mellanting som fr
 mnga av de nya versionerna frn "unstable" om de inte r fr buggiga.
 Vilken version av Debian vill du installera?

Template: apt-setup/badsource
Type: note
Description: Failed to access the Debian archive
 When I tried to access the debian archive using the information you
 provided, apt gave the following error. I will run through the questions
 again, try to correct the error. 
 .
 ${apt_error} 
Description-sv: Misslyckades med att komma t Debianarkivet
 Nr jag frskte komma t debianarkivet genom att anvnda informationen du
 tillhandahll s gav apt fljande fel. Jag kommer att kra igenom frgorna
 igen; frsk att korrigera felet.
 .
 ${apt_error}

Template: apt-setup/another
Type: boolean
Default: false
Description: Add another apt source?
 Apt is now configured, and should be able to install Debian packages.
 However, you may want to add another source to apt, so it can download
 packages from more than one location.
Description-sv: Lgg till en annan apt-klla?
 Apt r nu konfigurerad och br vara kapabel att installera Debianpaket.
 Emellertid s kanske du vill lgga till ytterligare en klla till apt, s
 att det kan ladda ner paket frn mer n en plats.

Template: apt-setup/badedit
Type: select
Choices: edit, revert to backup
Choices-sv: redigera, terg till skerhetskopia
Description: What do you want to do?
 The entries you made in sources.list did not work. Here is the error
 message from apt: 
 .
 ${apt_error} 
 .
 I have a backup of the sources.list from before you edited it. Should I
 revert to that backup, or would you like to edit the existing file and fix
 it? 
Description-sv: Vad vill du gra?
 De poster du skapade i sources.list fungerade inte. Hr r felmeddelandet
 frn apt:
 .
 ${apt_error}
 .
 Jag har en skerhetskopia av sources.list frn fre det att du redigerade
 den. Ska jag terg till den skerhetskopian, eller vill du redigera den
 existerande filen och korrigera den?

Template: apt-setup/non-us-failed
Type: note
Description: Cannot access non-US software.
 I cannot access the Debian archive site that contains non-US software, so
 that software will not be made available to you. The error message I
 received from apt was: 
 .
 ${apt_error} 
Description-sv: Kan ej komma t "non-US"-programvara.
 Jag kan ej komma t Debianarkivet som innehller "non-US"-programvara, s den
 programvaran kommer inte att gras tillgnglig fr dig. Felmeddelandet jag fick
 frn apt var:
 .
 ${apt_error}

Template: apt-setup/http_proxy
Type: string
Description: Enter http proxy information, or leave blank for none:
 If you need to use a http proxy to access the outside world, enter the
 proxy information here. Otherwise, leave this blank. 
 .
 When entering proxy information, use the standard form of
 "http://[[user][:pass]@]host[:port]"
Description-sv: Ange information om http-proxy, eller lmna tomt fr ingen:
 Om du mste anvnda en http-proxy fr att n yttre vrden, lgg till den
 proxyinformationen nu. I annat fall, lmna denna tom.

Template: apt-setup/security-updates
Type: boolean
Default: true
Description: Use security updates from security.debian.org?
 Debian provides timely security updates via the website
 http://security.debian.org/ . Should these updates be tracked each time
 you upgrade your system? If you are on the internet, this is generally a
 good idea.
Description-sv: Anvnda skerhetsuppdateringar frn security.debian.org?
 Debian tillhandahller snabba skerhetsuppdateringar via webbsidan
 http://security.debian.org/ . Ska dessa uppdateringar kollas varje gng du
 uppdaterar ditt system? Om du anvnder internet s r detta generellt en bra
 id.

Template: apt-setup/security-updates-failed
Type: note
Description: Cannot access security updates.
 I cannot access the security updates on security.debian.org, so
 those updates will not be made available to you at this time.
 You may want to invesitgate this later.. Commented out entries
 for security.debian.org have been added to the bottom of
 /etc/apt/sources.list . The error message I received from apt was:
 .
 ${apt_error}
Description-sv: Kan ej n skerhetsuppdateringar.
 Jag kan inte n skerhetsuppdateringarna p security.debian.org, s de
 uppdateringarna kommer inte att gras tillgnglig fr dig nu. Du kanske vill
 underska detta senare... Utkommenterade poster fr security.debian.org har
 gjorts i slutet av /etc/apt/sources.list . Felmeddelandet jag fick frn apt
 var:
 .
 ${apt_error}
