/* BANGARANG MEDIA PLAYER
* Copyright (C) 2009 Andrew Lake (jamboarder@yahoo.com)
* <http://gitorious.org/bangarang>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef NOWPLAYINGDELEGATE_H
#define NOWPLAYINGDELEGATE_H

#include <QItemDelegate>
#include <QPainter>
#include <QStyle>
#include <QStyleOptionViewItem>

class MainWindow;
class MediaIndexer;

/*
 * This ItemDelegate is responsible for painting the currently
 * playing MediaItem for the Now Playing View. It is
 * also responsible for updating the rating when the user changes 
 * the rating from the Now Playing View.
 */
class NowPlayingDelegate : public QItemDelegate
{
    Q_OBJECT
    public:
        NowPlayingDelegate(QObject * parent = 0);
        ~NowPlayingDelegate();
        void paint(QPainter *painter, const QStyleOptionViewItem &option,
                    const QModelIndex &index) const;
        QSize sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const;
        int columnWidth (int column, int viewWidth) const;
        bool editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index);
                    
    private:
        MainWindow * m_parent;  
        QPixmap m_ratingCount;
        QPixmap m_ratingNotCount;
        bool m_nepomukInited;
        MediaIndexer * m_mediaIndexer;
        
};

#endif // NOWPLAYINGDELEGATE_H
