//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_37.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot37(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[37] = {1.655997946274130e-02,1.490840151837081e-01,4.143683016504360e-01,8.128875925516243e-01,1.345359882948675e+00,
    2.012753604351883e+00,2.816297488373125e+00,3.757493346088624e+00,4.838132092738009e+00,6.060313445881383e+00,7.426469845335770e+00,8.939395292626559e+00,
    1.060227999640221e+01,1.241875195203916e+01,1.439292689759376e+01,1.652946850117982e+01,1.883366118508870e+01,2.131149873507376e+01,2.396979286105532e+01,
    2.681630729082503e+01,2.985992497878047e+01,3.311085889016670e+01,3.658092104547190e+01,4.028387084589512e+01,4.423587344119896e+01,4.845611429518804e+01,
    5.296764121319868e+01,5.779854756745025e+01,6.298368540192268e+01,6.856723612980355e+01,7.460674041940034e+01,8.117976965763060e+01,8.839577291261112e+01,
    9.641918476190364e+01,1.055209147624170e+02,1.162194608436121e+02,1.298496805268988e+02};
  constexpr double aw[37] = {2.531535801616495e-01,2.218313079154654e-01,1.702937255822022e-01,1.144740498862206e-01,6.733468872828437e-02,
    3.462398613371497e-02,1.554506744609088e-02,6.084696208937837e-03,2.072740531869709e-03,6.132067059485523e-04,1.571729634858562e-04,3.480610375550448e-05,
    6.638454061426746e-06,1.086555082832821e-06,1.519986077632926e-07,1.808944154744511e-08,1.821950937683603e-09,1.543825612781230e-10,1.093159052133599e-11,
    6.418857138048059e-13,3.098188619564303e-14,1.216890058133903e-15,3.844343085546422e-17,9.636567816848030e-19,1.886372778227056e-20,2.829601860304904e-22,
    3.179499828670935e-24,2.603304950305458e-26,1.500897322805704e-28,5.834567530416297e-31,1.445502443700035e-33,2.115682212372438e-36,1.644241467794919e-39,
    5.783615262462852e-43,7.086972183663917e-47,1.840430346388145e-51,2.875027572792207e-57};
  constexpr double x[14208] = {  8.771922152876884e-04, -5.845418948192864e-06,  2.920151431349345e-08, -1.295968790002941e-10,  5.388111225038518e-13,
 -2.148680329179673e-15,  8.321955423333099e-18, -3.153652979951116e-20,  1.174847920095721e-22, -4.316239465942218e-25,  1.567257001594431e-27, -5.633350934502826e-30,
  7.885739226861336e-03, -5.236706264572075e-05,  2.597911807761383e-07, -1.139580530189390e-09,  4.654969009821622e-12, -1.810391753035376e-14,  6.777163160159664e-17,
 -2.455528211906544e-19,  8.631775818843514e-22, -2.944326347365442e-24,  9.726943193439467e-27, -3.098716408009964e-29,  2.185494294693359e-02, -1.441283966561805e-04,
  7.050577102531551e-07, -3.020061420118663e-09,  1.189137651679138e-11, -4.382260017779812e-14,  1.519002998175207e-16, -4.933091781488879e-19,  1.479583902330184e-21,
 -3.958972611559515e-24,  8.589128017873892e-27, -9.346278331289017e-30,  4.268931134476378e-02, -2.785996758458543e-04,  1.334155895573597e-06, -5.508005885618214e-09,
  2.044335808368411e-11, -6.869076189919827e-14,  2.054664731293038e-16, -5.166070473363542e-19,  8.809110575864451e-22,  5.772865107816841e-25, -1.468699925848555e-26,
  8.887580766256224e-29,  7.024632705613144e-02, -4.520708488967405e-04,  2.103211076449944e-06, -8.246990558129143e-09,  2.803929864786526e-11, -8.075600254811054e-14,
  1.761831052077196e-16, -1.340065368617143e-19, -1.326251168390394e-21,  1.006834756273933e-23, -4.679791699281019e-26,  1.656753625663742e-28,  1.043373100617896e-01,
 -6.597507086944943e-04,  2.958032142935387e-06, -1.082831522551345e-08,  3.237765081165657e-11, -7.032586752877620e-14,  3.867952596784328e-17,  6.295104609418172e-19,
 -4.301315396052826e-21,  1.794144631249561e-23, -5.179269591817969e-26,  6.919146162279729e-29,  1.447285642956947e-01, -8.958952595639103e-04,  3.837473688662810e-06,
 -1.283860508581641e-08,  3.158249539989787e-11, -3.313400277531523e-14, -1.900589666756604e-16,  1.507012302226175e-18, -6.205840946953358e-21,  1.547829061491330e-23,
 -2.257006559187524e-27, -2.191010828790735e-28,  1.911428049463453e-01, -1.153962113087701e-03,  4.677246989373522e-06, -1.390870046672002e-08,  2.459677828262755e-11,
  2.778515885259093e-14, -4.501462844198489e-16,  2.076310952906322e-18, -5.182569592894529e-21, -1.308445179094632e-24,  8.657468334680602e-26, -4.817465059128641e-28,
  2.432608622512940e-01, -1.426787048291304e-03,  5.413951339791105e-06, -1.375844390394913e-08,  1.144180706550563e-11,  1.020677364390758e-13, -6.545140833594484e-16,
  1.940542910672219e-18, -5.748364466620209e-22, -2.662615826076624e-23,  1.529936858394467e-25, -4.028635836762509e-28,  3.007236565232829e-01, -1.706778275663150e-03,
  5.989082146663475e-06, -1.223235993767957e-08, -6.706641851849441e-12,  1.739412896156329e-13, -7.165758182034218e-16,  9.273452853588725e-19,  6.328237569997525e-21,
 -4.601956562597493e-23,  1.277020694765588e-25,  1.255179839962166e-28,  3.631344379713824e-01, -1.986123442456769e-03,  6.352771107489328e-06, -9.322149251916071e-09,
 -2.764464410674257e-11,  2.257089341608462e-13, -5.810573167385638e-16, -7.844986307825036e-19,  1.254904506291896e-20, -4.418915738476493e-23, -8.071278220395254e-27,
  8.040173157835511e-28,  4.300612835795501e-01, -2.257004022729778e-03,  6.467027119610905e-06, -5.173296427920562e-09, -4.845344955695818e-11,  2.420010365570978e-13,
 -2.475371401859433e-16, -2.677872179094667e-18,  1.469791910918349e-20, -1.530778280249857e-23, -1.907570236548327e-25,  1.072311748962227e-27,  5.010398418689983e-01,
 -2.511811462134959e-03,  6.308273793602778e-06, -7.478133832243700e-11, -6.595179483580721e-11,  2.137728027658716e-13,  2.219713371371758e-16, -4.060557387727858e-18,
  1.070924416610560e-20,  3.082478417884235e-23, -3.017126260995845e-25,  5.527717103348511e-28,  5.755763147943787e-01, -2.743359305519470e-03,  5.869019326373947e-06,
  5.567286210711487e-09, -7.721404071258128e-11,  1.410443396499179e-13,  7.152562830514699e-16, -4.324722393297052e-18,  1.153293070937984e-21,  7.166144599596821e-23,
 -2.441742909609893e-25, -5.575561993472948e-28,  6.531506643062893e-01, -2.945085533827810e-03,  5.158545002105175e-06,  1.126951393563602e-08, -8.006768379603803e-11,
  3.364564065897707e-14,  1.099465124314906e-15, -3.202058661376478e-18, -1.063223541604644e-20,  8.339023073247506e-23, -1.915852401797322e-26, -1.519803631180173e-27,
  7.332200292583904e-01, -3.111239482087321e-03,  4.202557028096647e-06,  1.652043432760569e-08, -7.348493378046402e-11, -9.031456024000198e-14,  1.259625052359975e-15,
 -9.074902854750213e-19, -1.979825636300568e-20,  5.493226983498367e-23,  2.576404007723404e-25, -1.564169257526943e-27,  8.152223363566531e-01, -3.237048005867100e-03,
  3.041809506466254e-06,  2.083384113013970e-08, -5.779880098280444e-11, -2.079954365130440e-13,  1.134367655032074e-15,  1.896906346158071e-18, -2.212775009190660e-20,
 -3.951274277750748e-24,  4.190714889240162e-25, -5.131571451618905e-28,  8.985800867574861e-01, -3.318856009578651e-03,  1.729770411750052e-06,  2.380046753597658e-08,
 -3.470220763710139e-11, -2.966285149698480e-13,  7.373921021354249e-16,  4.316134262336092e-18, -1.606590016032654e-20, -6.601594501441647e-23,  3.537074213986790e-25,
  9.980505256913139e-28,  9.827042977439744e-01, -3.354237042453203e-03,  3.294635947700604e-07,  2.513228906324486e-08, -7.024545463747572e-12, -3.384930091470081e-13,
  1.572469786178661e-16,  5.539737984708450e-18, -3.621175394046042e-21, -1.003315274175740e-22,  8.488423994711081e-26,  1.933940831701032e-27,  1.066998576675592e+00,
 -3.342070398794092e-03, -1.090325821410328e-06,  2.469444148902819e-08,  2.168211382391514e-11, -3.248999390323956e-13, -4.653712618874304e-16,  5.141773441070197e-18,
  1.037052732196025e-20, -8.905934944757560e-23, -2.361191336926566e-25,  1.621481364709562e-27,  1.150863302154035e+00, -3.282582015347197e-03, -2.459251384880802e-06,
  2.252102768445970e-08,  4.768177080108263e-11, -2.582281501538817e-13, -9.764922732053156e-16,  3.244711646078026e-18,  2.033286375093972e-20, -3.753543383136829e-23,
 -4.228743122521112e-25,  2.695438715029406e-28,  1.233699885120791e+00, -3.177347422750007e-03, -3.709749014032510e-06,  1.881281903537992e-08,  6.763014855591194e-11,
 -1.514988329391263e-13, -1.252315636929891e-15,  4.797560743629355e-19,  2.242059641444227e-20,  2.840040220160461e-23, -3.719771532535941e-25, -1.178348506778316e-27,
  1.314915080451704e+00, -3.029256057617862e-03, -4.781248560425501e-06,  1.391685431857361e-08,  7.909123692660811e-11, -2.555424132822676e-14, -1.233942241986484e-15,
 -2.243743097094648e-18,  1.619717248209608e-20,  7.646504990007954e-23, -1.266786769934057e-25, -1.750879407384369e-27,  1.393925317596986e+00, -2.842437349948307e-03,
 -5.623980529818104e-06,  8.289981454265706e-09,  8.090731440098032e-11,  9.551863889286035e-14, -9.426888290139790e-16, -4.070500633818574e-18,  4.718600082773071e-21,
  8.527682590062959e-23,  1.565632108655444e-25, -1.156532573033054e-27,  1.470161016993082e+00, -2.622150136117461e-03, -6.202126337077244e-06,  2.450242275614777e-09,
  7.335905876963666e-11,  1.896504872210914e-13, -4.713615780301570e-16, -4.502986032888520e-18, -6.990650908039907e-21,  5.500072895536897e-23,  3.134045193745270e-25,
  5.849235546323342e-29,  1.543070857410204e+00, -2.374638076378922e-03, -6.496098663578398e-06, -3.078552415322049e-09,  5.808795085201209e-11,  2.414975296318642e-13,
  4.549796974290192e-17, -3.558913124105700e-18, -1.429276156221479e-20,  5.479490495410425e-24,  2.746731667913185e-25,  9.927996029511488e-28,  1.612125958162183e+00,
 -2.106954840647519e-03, -6.503791806454715e-06, -7.822850470728813e-09,  3.779426769694750e-11,  2.454871672949630e-13,  4.726969512387257e-16, -1.725802450618559e-18,
 -1.495716355183392e-20, -3.636564742535661e-23,  9.815692261724594e-26,  1.087408085937743e-27,  1.676823939259899e+00, -1.826763829504459e-03, -6.240707242299496e-06,
 -1.140962584342853e-08,  1.576331540500723e-11,  2.065024868318467e-13,  7.136106816825297e-16,  2.603686682962252e-19, -9.893128994666594e-21, -5.182350361277542e-23,
 -8.594683466228427e-26,  4.750722920305951e-28,  1.736692822202029e+00, -1.542118081146973e-03, -5.738932885251623e-06, -1.360510776193107e-08, -4.696956772069538e-12,
  1.380920988058805e-13,  7.352211703749561e-16,  1.714550543108143e-18, -2.332922423723168e-21, -3.926998472918056e-23, -1.696043913223345e-25, -2.469783266579867e-28,
  1.791294734237273e+00, -1.261226743654467e-03, -5.045030883239767e-06, -1.433746782270312e-08, -2.080788363684494e-11,  5.870657840724302e-14,  5.716202652218960e-16,
  2.254318354816015e-18,  3.998576075826749e-21, -1.212607494923791e-23, -1.317938251209568e-25, -5.571009617034687e-28,  1.840229379692471e+00, -9.922150331324695e-04,
 -4.216963036483628e-06, -1.370078901893791e-08, -3.076425540027728e-11, -1.305007088559831e-14,  3.059742106189980e-16,  1.904614978040006e-18,  6.714082041074511e-21,
  1.154678214875435e-23, -3.311168528158122e-26, -3.803916897859296e-28,  1.883137243526483e+00, -7.428849243511655e-04, -3.320249764573330e-06, -1.193981481914096e-08,
 -3.399289169540293e-11, -6.293253365349887e-14,  3.815681976612457e-17,  1.024354605293327e-18,  5.664392295509557e-21,  2.037495874930107e-23,  4.449687256816264e-26,
 -2.420750328431386e-29,  1.919702495218794e+00, -5.204839079330145e-04, -2.423613059651805e-06, -9.417241412214255e-09, -3.118158199895387e-11, -8.419143877116434e-14,
 -1.501603080723408e-16,  1.024335609035884e-19,  2.554584629180732e-21,  1.478982960184587e-23,  5.960308813837140e-26,  1.769144410456584e-28,  1.949655567894060e+00,
 -3.314889689598191e-04, -1.594391791658646e-06, -6.567398907369110e-09, -2.407643956572805e-11, -7.857558968747155e-14, -2.207885507195364e-16, -4.752256290248853e-19,
 -3.522146335279042e-22,  3.704479603914203e-24,  2.878732097063359e-26,  1.407627664019680e-28,  1.972775412030704e+00, -1.814124005157120e-04, -8.940355320393308e-07,
 -3.841808881134513e-09, -1.508833876551284e-11, -5.501362084757252e-14, -1.864001680173231e-16, -5.801210494819660e-19, -1.605602243590120e-21, -3.608868912205280e-24,
 -4.246624214488866e-27,  1.676782739125752e-29,  1.988891578899133e+00, -7.463440107714900e-05, -3.739751357469912e-07, -1.653081195415766e-09, -6.784239586893136e-12,
 -2.640820012087652e-14, -9.846850929453660e-17, -3.531534150495007e-19, -1.218674957828592e-21, -4.034163818380494e-24, -1.271726249469373e-26, -3.762910973991734e-29,
  1.997888457524238e+00, -1.425191573383458e-05, -7.207000554920143e-08, -3.235007838096844e-10, -1.358953752585547e-12, -5.468708139798338e-15, -2.134258559178161e-17,
 -8.135814694678490e-20, -3.042860775073574e-22, -1.119801169483566e-24, -4.062527725696609e-27, -1.454684444933982e-29,  8.542681170456753e-04, -5.617884124202230e-06,
  2.769669385385070e-08, -1.213091308274202e-10,  4.977653965393792e-13, -1.959138784687082e-15,  7.489313361816550e-18, -2.801400101187268e-20,  1.030175061335424e-22,
 -3.736201964836032e-25,  1.339338091486233e-27, -4.753092094485732e-30,  7.680342778987800e-03, -5.034219386856546e-05,  2.465514228657858e-07, -1.067911561365908e-09,
  4.308614662022787e-12, -1.655687818964640e-14,  6.126744177899311e-17, -2.195545676071656e-19,  7.638684285697930e-22, -2.581232240729937e-24,  8.458415961683120e-27,
 -2.677692020013509e-29,  2.128948523906619e-02, -1.386297288142920e-04,  6.699302514642146e-07, -2.836617535598461e-09,  1.105028886017462e-11, -4.033752403177806e-14,
  1.387295383808700e-16, -4.481773907638527e-19,  1.343141015163111e-21, -3.624161748718356e-24,  8.139897206277375e-27, -1.093188310483673e-29,  4.159584824201869e-02,
 -2.681853550638060e-04,  1.269977906010175e-06, -5.191639610485134e-09,  1.911769966425033e-11, -6.392994580511729e-14,  1.913984825627719e-16, -4.881914352422429e-19,
  8.920121484230407e-22,  6.268185174739605e-26, -1.116914976528602e-26,  7.157832694524940e-29,  6.847107887361302e-02, -4.356335104058691e-04,  2.006886403973975e-06,
 -7.811054355259576e-09,  2.646613520562986e-11, -7.657710760043535e-14,  1.718887566033952e-16, -1.709945876744495e-19, -9.957830481731833e-22,  8.336235229053487e-24,
 -3.995347537644794e-26,  1.456653684040076e-28,  1.017448250818741e-01, -6.365975104997980e-04,  2.831154378734498e-06, -1.032146879261256e-08,  3.098176637502606e-11,
 -6.920101428596939e-14,  5.447311373430253e-17,  5.018090041627304e-19, -3.691943298832211e-21,  1.593459843014876e-23, -4.846380697057854e-26,  8.101462933395776e-29,
  1.412054191618055e-01, -8.658031845642315e-04,  3.686419714183387e-06, -1.233882048714064e-08,  3.087750530267712e-11, -3.721098836185873e-14, -1.505592983202482e-16,
  1.317305735362866e-18, -5.652400178419943e-21,  1.521377501848045e-23, -1.053105180171996e-26, -1.589790441900317e-28,  1.866007448807474e-01, -1.117205025954856e-03,
  4.512720364471562e-06, -1.351127395054421e-08,  2.504905847188674e-11,  1.766052770190473e-14, -3.943339193609626e-16,  1.910343162605321e-18, -5.172265073409335e-21,
  1.750694024468653e-24,  6.687493183818875e-26, -4.141422697596701e-28,  2.376392962291531e-01, -1.384132581019399e-03,  5.250013076824013e-06, -1.355987921379853e-08,
  1.333046521562787e-11,  8.700849792013358e-14, -6.005722904830254e-16,  1.907957704122483e-18, -1.427525293206281e-21, -2.086401772142590e-23,  1.350716088452915e-25,
 -4.086827753227976e-28,  2.939914368412576e-01, -1.659454337608070e-03,  5.841761789299508e-06, -1.231276079507711e-08, -3.397579141530374e-12,  1.570764455780710e-13,
 -6.880170778029193e-16,  1.104335967954958e-18,  4.764460468301133e-21, -4.083894898995159e-23,  1.304449288571656e-25,  4.126570326453937e-30,  3.552908698864670e-01,
 -1.935755917983109e-03,  6.238397925660329e-06, -9.729114497768784e-09, -2.327147014620608e-11,  2.115438738871114e-13, -5.976405164245598e-16, -4.083783122134035e-19,
  1.096048580269462e-20, -4.385531061306955e-23,  2.352288720604882e-26,  6.337654044294744e-28,  4.211363286280702e-01, -2.205528937717977e-03,  6.400454639035398e-06,
 -5.910178787588920e-09, -4.367863882407618e-11,  2.352129682341856e-13, -3.160257088296162e-16, -2.217737422473217e-18,  1.402070732682969e-20, -2.201219398107700e-23,
 -1.449633777326749e-25,  1.003868596277649e-27,  4.910934978228242e-01, -2.461366473552416e-03,  6.301186968976385e-06, -1.095554904111463e-09, -6.163207081760586e-11,
  2.177754355131636e-13,  1.132239786822750e-16, -3.702385319315480e-18,  1.160799010143770e-20,  1.928859215701387e-23, -2.740660853662113e-25,  6.943843045735766e-28,
  5.646971756351205e-01, -2.696160703146385e-03,  5.928510211251993e-06,  4.355320281376077e-09, -7.423126946283808e-11,  1.567638692897829e-13,  5.950548720930058e-16,
 -4.248467693571458e-18,  3.552197256056720e-21,  6.149237247312242e-23, -2.621410554918743e-25, -2.641401120341031e-28,  6.414536847070519e-01, -2.903297955250037e-03,
  5.286119437072239e-06,  9.995216860084915e-09, -7.913834857574013e-11,  5.892123120494122e-14,  1.005493754843244e-15, -3.494532314813819e-18, -7.659514114603821e-21,
  8.135106255962341e-23, -8.113270546590069e-26, -1.291199763867526e-27,  7.208435394096788e-01, -3.076846159571438e-03,  4.393693372777680e-06,  1.533185770531798e-08,
 -7.499133514829298e-11, -6.045817119475746e-14,  1.225656393231767e-15, -1.507540438168977e-18, -1.765197092019968e-20,  6.384165337639384e-23,  1.874917951463998e-25,
 -1.610553810262811e-27,  8.023243740578599e-01, -3.211729533173885e-03,  3.286134475590003e-06,  1.987727687844333e-08, -6.168257295601229e-11, -1.802132831809512e-13,
  1.177569195743447e-15,  1.189727283741970e-18, -2.197464334717900e-20,  1.225788441188249e-23,  3.889654285445579e-25, -8.453310391956924e-28,  8.853341339693139e-01,
 -3.303885307271900e-03,  2.011852059868795e-06,  2.319877322795566e-08, -4.044832403552788e-11, -2.775410740261954e-13,  8.507089926151973e-16,  3.766810093683029e-18,
 -1.817824254303335e-20, -5.110187308657073e-23,  3.891674348789657e-25,  6.100524630088456e-28,  9.692945276718773e-01, -3.350397407412825e-03,  6.301541094294864e-07,
  2.496599496466913e-08, -1.374418398249319e-11, -3.328741337812708e-13,  3.101999877917617e-16,  5.366889162890240e-18, -7.151798119693394e-21, -9.526987660707236e-23,
  1.671495519889948e-25,  1.790107199135342e-27,  1.053614734314991e+00, -3.349602272183847e-03, -7.921273050149841e-07,  2.498881406163714e-08,  1.508426848975521e-11,
 -3.343067377187430e-13, -3.172497646229483e-16,  5.420653206687205e-18,  7.012236480026077e-21, -9.700617011596223e-23, -1.596119003609251e-25,  1.842294115556125e-27,
  1.137695355450675e+00, -3.301162448276690e-03, -2.184596070404316e-06,  2.324137836262725e-08,  4.229058291782807e-11, -2.805015825475073e-13, -8.767574703916374e-16,
  3.870508845935872e-18,  1.868109697339444e-20, -5.409016544683845e-23, -4.018171263210987e-25,  6.872397372770039e-28,  1.220932594872857e+00, -3.206104245007368e-03,
 -3.477607954342581e-06,  1.986903461635710e-08,  6.430112685428601e-11, -1.813112976899712e-13, -1.228705374517472e-15,  1.210605456822570e-18,  2.316342022988329e-20,
  1.256545182621291e-23, -4.176229478564500e-25, -8.836745205417033e-28,  1.302722644231725e+00, -3.066816573675592e-03, -4.606675683586268e-06,  1.517659609559337e-08,
  7.827923049946174e-11, -5.586167902415962e-14, -1.289104737308586e-15, -1.682519456667218e-18,  1.883997869601220e-20,  6.984065682902869e-23, -2.047987952466987e-25,
 -1.786072273887049e-27,  1.382466245796841e+00, -2.887009131276673e-03, -5.516674694863159e-06,  9.598513793210420e-09,  8.258231033211863e-11,  7.154635853866788e-14,
 -1.054079381407612e-15, -3.869282213418058e-18,  7.888212452498373e-21,  9.043233472624556e-23,  9.903574122467261e-26, -1.455033153348577e-27,  1.459573397190278e+00,
 -2.671629297460091e-03, -6.165557900011337e-06,  3.653673339455720e-09,  7.702860640057511e-11,  1.768014439264721e-13, -6.002620802852705e-16, -4.692586952774561e-18,
 -4.785122282201998e-21,  6.750319128222528e-23,  3.095196176077422e-25, -2.433034695208033e-28,  1.533468156346098e+00, -2.426738468991124e-03, -6.527305363533669e-06,
 -2.110481075183845e-09,  6.292048329561572e-11,  2.413422636471959e-13, -6.050949252586589e-17, -4.010920531427560e-18, -1.388738689654228e-20,  1.731951001738823e-23,
  3.167062599644110e-25,  9.073097638061544e-28,  1.603593498603950e+00, -2.159350014821328e-03, -6.593873791469439e-06, -7.178265261885704e-09,  4.281325964475738e-11,
  2.561967591884370e-13,  4.174828198460150e-16, -2.224524346366934e-18, -1.618373013525513e-20, -3.143957604502732e-23,  1.491716329350121e-25,  1.227927395370070e-27,
  1.669416171969012e+00, -1.877232541922445e-03, -6.375970163034196e-06, -1.112344003792536e-08,  2.006502994044285e-11,  2.236791070057265e-13,  7.161839366551122e-16,
 -8.668104244710703e-20, -1.181510306366288e-20, -5.478625634775014e-23, -6.073175464841059e-26,  6.753426723400672e-28,  1.730431491444137e+00, -1.588683650764656e-03,
 -5.902550795689389e-06, -1.365718945251111e-08, -1.754822427384144e-12,  1.563037064409024e-13,  7.819614560792777e-16,  1.615948357492722e-18, -3.871153321436911e-21,
 -4.624655859891698e-23, -1.785444633636556e-25, -1.535417325896559e-28,  1.786168009254621e+00, -1.302280754735873e-03, -5.219036833822066e-06, -1.466023379981188e-08,
 -1.949137753364610e-11,  7.319693365017432e-14,  6.364593791454143e-16,  2.374221936409203e-18,  3.461111552189694e-21, -1.790185017822185e-23, -1.573160791092688e-25,
 -6.010977200548327e-28,  1.836191995055142e+00, -1.026616760326800e-03, -4.384333143236162e-06, -1.419468755276489e-08, -3.094737627398602e-11, -5.042086963496378e-15,
  3.623718102606528e-16,  2.125826638844632e-18,  7.101655200351428e-21,  9.861382199421779e-24, -5.182775649890955e-26, -4.723004249728973e-28,  1.880111659227999e+00,
 -7.700293749298562e-04, -3.466832206751798e-06, -1.249371040600063e-08, -3.523995271875074e-11, -6.165141442025336e-14,  6.948909914452493e-17,  1.217691822714987e-18,
  6.429557468236244e-21,  2.212077919048817e-23,  4.245434189157519e-26, -7.090781663751493e-29,  1.917581053923717e+00, -5.403334506259253e-04, -2.539669586018354e-06,
 -9.929812015619076e-09, -3.290116704010688e-11, -8.775112230908361e-14, -1.460643019566011e-16,  1.931748155232912e-19,  3.131845486464049e-21,  1.733364556349410e-23,
  6.768286911489048e-26,  1.899563875801092e-28,  1.948303593222035e+00, -3.445660085601692e-04, -1.675564721658540e-06, -6.965486488444006e-09, -2.570202445272559e-11,
 -8.403533284418422e-14, -2.342309548973830e-16, -4.841278893809282e-19, -1.965612284348963e-22,  4.987882183865113e-24,  3.558978484531037e-26,  1.691892830188247e-28,
  1.972035159976461e+00, -1.887532808541997e-04, -9.416228308234400e-07, -4.092273175292461e-09, -1.623469345638262e-11, -5.968807258940289e-14, -2.033826230579154e-16,
 -6.336102222926111e-19, -1.738378521990778e-21, -3.761442927677026e-24, -3.314824565427563e-27,  2.601151741398720e-29,  1.988586929399340e+00, -7.770743636538144e-05,
 -3.944812518162874e-07, -1.765986186817807e-09, -7.336860340577144e-12, -2.889464840433851e-14, -1.089253233361918e-16, -3.945761953968205e-19, -1.373473672556661e-21,
 -4.577444585524677e-24, -1.448438403342644e-26, -4.279338625619765e-29,  1.997830271622124e+00, -1.484438194844992e-05, -7.608617617862519e-08, -3.461476626985217e-10,
 -1.473640504951606e-12, -6.009405232011045e-15, -2.376322530564940e-17, -9.177296650032139e-20, -3.476850683287688e-22, -1.295865224878172e-24, -4.760396107071377e-27,
 -1.725607237482919e-29,  8.322306954507265e-04, -5.402000935202148e-06,  2.628750765234417e-08, -1.136488407707105e-10,  4.603183940650143e-13, -1.788447525349738e-15,
  6.749122559194847e-18, -2.492270172601690e-20,  9.048317378623871e-23, -3.240036430233688e-25,  1.146833823372286e-27, -4.018923337297463e-30,  7.482839286970203e-03,
 -4.841989495497270e-05,  2.341394367972381e-07, -1.001544976082194e-09,  3.991697253636452e-12, -1.515755135676568e-14,  5.544860984703655e-17, -1.965345062109255e-19,
  6.767603323719676e-22, -2.265352686843364e-24,  7.361957338235287e-27, -2.315152081199024e-29,  2.074547378882938e-02, -1.334034989242700e-04,  6.369256205443501e-07,
 -2.666090195154104e-09,  1.027584159958147e-11, -3.715386424711013e-14,  1.267631271288539e-16, -4.072225148896677e-19,  1.218413221281209e-21, -3.308481404146550e-24,
  7.637966986929496e-27, -1.177990143542947e-29,  4.054303911874504e-02, -2.582696260775471e-04,  1.209472131995941e-06, -4.895740213118795e-09,  1.788394583380857e-11,
 -5.949718988007758e-14,  1.781285026655179e-16, -4.596912741857077e-19,  8.869455607021558e-22, -3.254873334037309e-25, -8.342868087122158e-27,  5.735178236397009e-29,
  6.676007138568175e-02, -4.199462659436488e-04,  1.915644681261369e-06, -7.399626075451705e-09,  2.497544106781787e-11, -7.251256580165464e-14,  1.666977849699665e-16,
 -1.983542130282612e-19, -7.229512792667810e-22,  6.860721549726947e-24, -3.395691312761249e-26,  1.271728552832577e-28,  9.924296083723498e-02, -6.144353836327937e-04,
  2.710225572709574e-06, -9.836757116260741e-09,  2.961189094550003e-11, -6.773788495063643e-14,  6.695338690819793e-17,  3.924781139930027e-19, -3.152312546642322e-21,
  1.406946919443414e-23, -4.474918039249988e-26,  8.700807108266974e-29,  1.378002631694770e-01, -8.368957493281553e-04,  3.541292947026589e-06, -1.185091831028270e-08,
  3.010003545708473e-11, -4.040173303080157e-14, -1.161253303890113e-16,  1.145098003048986e-18, -5.113833235500878e-21,  1.466776781538864e-23, -1.641399834426122e-26,
 -1.101713515868567e-28,  1.822031110960696e-01, -1.081744967252673e-03,  4.352999825843948e-06, -1.310815969109237e-08,  2.531186519584379e-11,  8.819761861242491e-15,
 -3.431485307814675e-16,  1.746320863259342e-18, -5.065306884005295e-21,  4.080384249313699e-24,  5.007518058181835e-26, -3.502385150299891e-28,  2.321857408504482e-01,
 -1.342779597465892e-03,  5.088629189097965e-06, -1.333343549458874e-08,  1.493079558268659e-11,  7.323001719661890e-14, -5.478946910682227e-16,  1.851266901995699e-18,
 -2.085695390079155e-21, -1.581876261926942e-23,  1.172665889397138e-25, -3.984004999238199e-28,  2.874461509124670e-01, -1.613311946972653e-03,  5.693783285865826e-06,
 -1.234287619812748e-08, -4.185862900377305e-13,  1.409509983975440e-13, -6.551750399063117e-16,  1.234281068085337e-18,  3.387952386684760e-21, -3.564678531782252e-23,
  1.284883726933536e-25, -8.858786125188940e-29,  3.476469126499345e-01, -1.886321745446591e-03,  6.119551576129431e-06, -1.006839351684400e-08, -1.918475392745744e-11,
  1.971014684837579e-13, -6.044005599242536e-16, -8.267014241078191e-20,  9.404917972570560e-21, -4.240409191875382e-23,  4.789169722436024e-26,  4.764353072743420e-28,
  4.124161546731084e-01, -2.154620515032065e-03,  6.325493194410403e-06, -6.571835241863361e-09, -3.905499668506804e-11,  2.269331202122329e-13, -3.719676957321095e-16,
 -1.782788083731150e-18,  1.313430172817201e-20, -2.695378970408781e-23, -1.028114796914947e-25,  9.086009372211864e-28,  4.813487444286509e-01, -2.411025996553265e-03,
  6.282267746901996e-06, -2.046710807495453e-09, -5.725756598016682e-11,  2.192913515118641e-13,  1.484722978464154e-17, -3.321873608126140e-18,  1.211268866553942e-20,
  8.966303559322187e-24, -2.414178266101675e-25,  7.810612720762123e-28,  5.540076918057105e-01, -2.648543513865543e-03,  5.973753720526474e-06,  3.193437951771074e-09,
 -7.096273963404881e-11,  1.696325184751638e-13,  4.780074213746145e-16, -4.101419464773775e-18,  5.575102936294666e-21,  5.085312453972310e-23, -2.679401239000268e-25,
 -5.959386636436518e-30,  6.299258001730055e-01, -2.860550657063243e-03,  5.398507801124035e-06,  8.739708111891622e-09, -7.772666279776201e-11,  8.185390265815970e-14,
  9.046505720405951e-16, -3.693511629309480e-18, -4.802312822376508e-21,  7.704342956599350e-23, -1.323839165080491e-25, -1.035411169219317e-27,  7.086075901817002e-01,
 -3.040981162651002e-03,  4.570441729928622e-06,  1.412390581901673e-08, -7.591008083051212e-11, -3.161060892348823e-14,  1.175892206348239e-15, -2.034321737628585e-18,
 -1.523572614841904e-20,  6.992835224480880e-23,  1.170855627933330e-25, -1.577453570942086e-27,  7.895315207151898e-01, -3.184503389636221e-03,  3.518626331932206e-06,
  1.886306703895175e-08, -6.500193225812653e-11, -1.516308212184398e-13,  1.201124221285742e-15,  4.965242109042986e-19, -2.126303640301160e-20,  2.698925072909671e-23,
  3.456681405121745e-25, -1.110831677858794e-27,  8.721525294008908e-01, -3.286688366104213e-03,  2.286174810872822e-06,  2.250833745279235e-08, -4.578677876586218e-11,
 -2.559257338058780e-13,  9.477809486256294e-16,  3.158721510644246e-18, -1.973230845266327e-20, -3.511565752311384e-23,  4.072388298217587e-25,  2.116393246947832e-28,
  9.559049119823650e-01, -3.344162048286166e-03,  9.282083590955396e-07,  2.469328324774354e-08, -2.031519347702614e-11, -3.236550393907671e-13,  4.567633529413237e-16,
  5.084597036721674e-18, -1.044273761095248e-20, -8.707059497800349e-23,  2.411346613966314e-25,  1.559713322010768e-27,  1.040205555458581e+00, -3.354736235204051e-03,
 -4.910352870010185e-07,  2.517631160482606e-08,  8.334405037379521e-12, -3.400773032329424e-13, -1.628628428238349e-16,  5.588098417631321e-18,  3.425054626698137e-21,
 -1.017240695244847e-22, -7.533136913721961e-26,  1.972820547361522e-27,  1.124457534133529e+00, -3.317512561242472e-03, -1.901828365007890e-06,  2.387204218280641e-08,
  3.647924886643753e-11, -3.001776285795050e-13, -7.603285650345064e-16,  4.434112376651744e-18,  1.645293037085438e-20, -6.943758428239802e-23, -3.626175819284081e-25,
  1.089976350085788e-27,  1.208054070527438e+00, -3.232954191013430e-03, -3.233131451149044e-06,  2.086725364267735e-08,  6.038319148992670e-11, -2.103094033792586e-13,
 -1.184386601981285e-15,  1.955778574182228e-18,  2.330664672089831e-20, -4.814105200538965e-24, -4.486886286879283e-25, -5.178616633453998e-28,  1.290382854480818e+00,
 -3.102920306486488e-03, -4.417084078949217e-06,  1.641843015959890e-08,  7.684915754973928e-11, -8.729513103988452e-14, -1.327409154516537e-15, -1.041146256009512e-18,
  2.118792049381199e-20,  6.008628389688069e-23, -2.825195067774865e-25, -1.730977384766650e-27,  1.370830703807181e+00, -2.930659238145448e-03, -5.393521958715265e-06,
  1.092986737275339e-08,  8.375164318856875e-11,  4.497993062081090e-14, -1.158391243157091e-15, -3.564136006335590e-18,  1.119890373206002e-20,  9.303157950720010e-23,
  2.897465524154982e-26, -1.722665054001568e-27,  1.448788538679828e+00, -2.720757169129125e-03, -6.114205043025968e-06,  4.913591576002031e-09,  8.040985000588695e-11,
  1.608034720108564e-13, -7.334160366083802e-16, -4.804466354429322e-18, -2.135631054780252e-21,  7.957068036739133e-23,  2.913271790589828e-25, -5.901438628203139e-28,
  1.523656629831990e+00, -2.479040734485155e-03, -6.546431846226664e-06, -1.065256563818626e-09,  6.772345276431663e-11,  2.384928151586240e-13, -1.789252109012133e-16,
 -4.442820108042114e-18, -1.302658956960295e-20,  3.074624254282130e-23,  3.535138655618366e-25,  7.539039549965107e-28,  1.594850067973873e+00, -2.212433523832504e-03,
 -6.675732108804878e-06, -6.451739471790909e-09,  4.803203876313402e-11,  2.654093843399509e-13,  3.477845093081205e-16, -2.759253446350041e-18, -1.719480222269580e-20,
 -2.435656638109079e-23,  2.057976402911353e-25,  1.340103465986825e-27,  1.661804389058129e+00, -1.928768424607943e-03, -6.507374551399778e-06, -1.076567861524248e-08,
  2.471007104248897e-11,  2.407938355794805e-13,  7.081642107823537e-16, -4.967281288669686e-19, -1.382339058792789e-20, -5.655686078013573e-23, -2.616709968901056e-26,
  8.992241722222170e-28,  1.723981277729767e+00, -1.636559835253897e-03, -6.066499027237291e-06, -1.365922322878057e-08,  1.562508369258696e-12,  1.755981540301604e-13,
  8.252135535884394e-16,  1.464043943441632e-18, -5.665888674006920e-21, -5.348763771042961e-23, -1.825501539069160e-25, -2.173777423279136e-29,  1.780874260137495e+00,
 -1.344741925519005e-03, -5.396779750999636e-06, -1.495953156823959e-08, -1.786924188229161e-11,  8.928157249951876e-14,  7.043823251594804e-16,  2.473399211403658e-18,
  2.696911023891026e-21, -2.473335471614899e-23, -1.844724024362925e-25, -6.302574422170974e-28,  1.832014287997385e+00, -1.062381192653161e-03, -4.557642082692466e-06,
 -1.469015907029505e-08, -3.095629335168472e-11,  4.395106503949216e-15,  4.251267708266030e-16,  2.358317244508542e-18,  7.414072236553481e-21,  7.343003881602408e-24,
 -7.484479605023997e-26, -5.757531053459440e-28,  1.876975109236104e+00, -7.983734090126516e-04, -3.620180130794053e-06, -1.306731124177798e-08, -3.645341857812111e-11,
 -5.955053493452335e-14,  1.065869260567081e-16,  1.436499878967533e-18,  7.255567808883987e-21,  2.373952848694846e-23,  3.803226319698630e-26, -1.328607004683582e-28,
  1.915378317930676e+00, -5.611365220174354e-04, -2.662044369426141e-06, -1.047045928533963e-08, -3.469074575425034e-11, -9.117983838888644e-14, -1.391547097300436e-16,
  3.039171071680402e-19,  3.806632210230173e-21,  2.021131054093623e-23,  7.627226146091585e-26,  1.997938955374984e-28,  1.946897980734763e+00, -3.583119903765706e-04,
 -1.761674419197641e-06, -7.390474589568661e-09, -2.744004747313838e-11, -8.982007738721520e-14, -2.478455548869142e-16, -4.872549576751401e-19,  1.050635085267693e-23,
  6.569776102171842e-24,  4.374694229315563e-26,  2.024284932492250e-28,  1.971264763519045e+00, -1.964872009291612e-04, -9.923289094720984e-07, -4.361849719821518e-09,
 -1.747873678659989e-11, -6.478856053076641e-14, -2.219230283146506e-16, -6.914280821789814e-19, -1.875871278583501e-21, -3.867802396588898e-24, -1.914659559497247e-27,
  3.817361790664594e-29,  1.988269650862454e+00, -8.095009420459160e-05, -4.163969657024583e-07, -1.888144982341425e-09, -7.941816613544274e-12, -3.164655660178227e-14,
 -1.206143651763261e-16, -4.412795616523946e-19, -1.549159212228398e-21, -5.196134118218500e-24, -1.649220893107017e-26, -4.857646312197482e-29,  1.997769649830110e+00,
 -1.547009661595518e-05, -8.038548664567965e-08, -3.707192997235448e-10, -1.599746610117411e-12, -6.611860042628283e-15, -2.649591537892780e-17, -1.036835963975389e-19,
 -3.979549413524640e-22, -1.502381411817296e-24, -5.589115284959513e-27, -2.051223994850118e-29,  8.110348277692896e-04, -5.197033474153385e-06,  2.496675962743884e-08,
 -1.065613287265404e-10,  4.261143546250315e-13, -1.634525894026146e-15,  6.090131039868989e-18, -2.220534714440426e-20,  7.960387815118054e-23, -2.814783347465689e-25,
  9.838989623824464e-28, -3.405223419473779e-30,  7.292831323737529e-03, -4.659379045662467e-05,  2.224943252432974e-07, -9.400325511805066e-10,  3.701420487377726e-12,
 -1.389044652015957e-14,  5.023696615941207e-17, -1.761281192249838e-19,  6.002714837040176e-22, -1.990294881975950e-24,  6.413661296367112e-27, -2.002980082244429e-29,
  2.022185185300273e-02, -1.284333266792338e-04,  6.058950224882133e-07, -2.507459847604728e-09,  9.562286194777051e-12, -3.424407814925737e-14,  1.158892548144129e-16,
 -3.700810339798276e-19,  1.104681111303968e-21, -3.013454303359682e-24,  7.111121708911177e-27, -1.209350917256268e-29,  3.952894684236821e-02, -2.488240690666594e-04,
  1.152401580689102e-06, -4.618888669311318e-09,  1.673572681832665e-11, -5.537336790064753e-14,  1.656523053784149e-16, -4.315561869361395e-19,  8.697962012659233e-22,
 -6.123346166150546e-25, -6.084352760089346e-27,  4.569415687111694e-29,  6.511038371224716e-02, -4.049696060416016e-04,  1.829199651269861e-06, -7.011405587514948e-09,
  2.356473477746400e-11, -6.858086106178196e-14,  1.608553079536488e-16, -2.177883868251563e-19, -4.991121651148240e-22,  5.609282541536518e-24, -2.873754381380318e-26,
  1.103533266859145e-28,  9.682784655428191e-02, -5.932177913349788e-04,  2.594982814380554e-06, -9.373714078319704e-09,  2.827403523089933e-11, -6.601007393860699e-14,
  7.660426268222180e-17,  2.993702026362094e-19, -2.677100952323130e-21,  1.235683654804730e-23, -4.087017908262049e-26,  8.871249327087263e-29,  1.345084516657989e-01,
 -8.091261249628477e-04,  3.401944404048846e-06, -1.137592287283542e-08,  2.926663428535863e-11, -4.282199649487314e-14, -8.627515632679524e-17,  9.897685152913065e-19,
 -4.598668235309724e-21,  1.392639218727721e-23, -2.037108667124332e-26, -7.119688002407997e-29,  1.779447927380039e-01, -1.047543264903671e-03,  4.198136264829163e-06,
 -1.270218985443104e-08,  2.540977140490327e-11,  1.152793607302262e-15, -2.964961342488331e-16,  1.586938848624933e-18, -4.885911013454503e-21,  5.792876869745329e-24,
  3.597724640102963e-26, -2.915146646338802e-28,  2.268950330609500e-01, -1.302706400925663e-03,  4.930107384857453e-06, -1.308352293524526e-08,  1.626805877886588e-11,
  6.069453374362815e-14, -4.970729631453709e-16,  1.776284378688443e-18, -2.574913063434793e-21, -1.147300892469874e-23,  1.001789209137465e-25, -3.767936822320500e-28,
  2.810830657133680e-01, -1.568354043844652e-03,  5.545718880008285e-06, -1.232786381135312e-08,  2.246049428570702e-12,  1.256526162101545e-13, -6.192832664391209e-16,
  1.323145979080882e-18,  2.196041115131864e-21, -3.060674823561829e-23,  1.230234271851186e-25, -1.559309467917158e-28,  3.401987663170527e-01, -1.837853539507167e-03,
  5.997016650814825e-06, -1.034460167615611e-08, -1.538779836325973e-11,  1.826006897173870e-13, -6.027285508544244e-16,  1.942706262882048e-19,  7.917514221067799e-21,
 -4.011180294392093e-23,  6.570012857988416e-26,  3.360625452506057e-28,  4.038983664981993e-01, -2.104342298821289e-03,  6.243030052151530e-06, -7.160907064888950e-09,
 -3.460940833924098e-11,  2.174534492872952e-13, -4.161526839402145e-16, -1.378733215552845e-18,  1.209928605475114e-20, -3.029869182869506e-23, -6.524838538675633e-26,
  7.968751077377414e-28,  4.718049796288922e-01, -2.360881337459909e-03,  6.252355201380059e-06, -2.927756719203498e-09, -5.287548223380968e-11,  2.185755682806960e-13,
 -7.270311470532652e-17, -2.930898570012993e-18,  1.227007542426818e-20,  1.146540611195985e-26, -2.060455648824171e-25,  8.194288827187404e-28,  5.435093136061794e-01,
 -2.600619239246023e-03,  6.005376423741196e-06,  2.085759980378153e-09, -6.746455840616853e-11,  1.797483969076742e-13,  3.659258092193158e-16, -3.895789722966337e-18,
  7.213449133264318e-21,  4.019706545237692e-23, -2.632893268755497e-25,  2.100327334714982e-28,  6.185706082138239e-01, -2.816964098410755e-03,  5.495980286901087e-06,
  7.510322353693555e-09, -7.588092450209442e-11,  1.023096554296852e-13,  7.994899896822369e-16, -3.803915077293019e-18, -2.134335612699487e-21,  7.091490869018241e-23,
 -1.721064582979144e-25, -7.698872189940929e-28,  6.965178368152258e-01, -3.003760367060284e-03,  4.732625280726673e-06,  1.290579986389980e-08, -7.626496746866479e-11,
 -4.125465383484840e-15,  1.112489709574346e-15, -2.480816679668127e-18, -1.265050900535786e-20,  7.324891651169016e-23,  4.968150873732690e-26, -1.476235411886741e-27,
  7.768512135192811e-01, -3.155466852573500e-03,  3.738647957722125e-06,  1.780034481344860e-08, -6.774554596677427e-11, -1.227129041728982e-13,  1.205665577768513e-15,
 -1.657779845253971e-19, -2.005489235519602e-20,  3.977685311345717e-23,  2.923274134152945e-25, -1.300884998035660e-27,  8.590440472823867e-01, -3.267331402256804e-03,
  2.551714501031234e-06,  2.173606555495733e-08, -5.067103533765304e-11, -2.321900680016756e-13,  1.027217516678283e-15,  2.510216200203847e-18, -2.070206693252983e-20,
 -1.875499484965194e-23,  4.079849532751454e-25, -1.737476268213384e-28,  9.425449833680180e-01, -3.335557117398664e-03,  1.222365947082612e-06,  2.431709865480898e-08,
 -2.666734638564003e-11, -3.110248817830004e-13,  5.939965228003333e-16,  4.702267618208967e-18, -1.338788090917470e-20, -7.613682781765404e-23,  3.033569769121438e-25,
  1.258425552429286e-27,  1.026780669870336e+00, -3.357454305617262e-03, -1.883444380132136e-07,  2.525509072177199e-08,  1.506495283998939e-12, -3.420994257101437e-13,
 -5.415350396703170e-18,  5.638696466450176e-18, -2.701665477033213e-22, -1.029846451007075e-22,  1.253156049979294e-26,  2.004226904492518e-27,  1.111158882308546e+00,
 -3.331571870279752e-03, -1.612063061935467e-06,  2.440673352821574e-08,  3.030357132028166e-11, -3.168785659961385e-13, -6.291976841301560e-16,  4.917911177116516e-18,
  1.370466257199458e-20, -8.287267874393475e-23, -3.064950344383929e-25,  1.452356881930440e-27,  1.195072132324608e+00, -3.257801519825520e-03, -2.977071373592345e-06,
  2.179821089382121e-08,  5.589762076455102e-11, -2.379935483416920e-13, -1.119234397066699e-15,  2.695317040827638e-18,  2.280588221164110e-20, -2.309692722151603e-23,
 -4.623886472139828e-25, -9.755282217113351e-29,  1.277901777031219e+00, -3.137448135477501e-03, -4.212748643381847e-06,  1.763231000938206e-08,  7.478271955778400e-11,
 -1.194242432879505e-13, -1.346760276796197e-15, -3.308510004344874e-19,  2.312958907103323e-20,  4.730008333040517e-23, -3.556745009548009e-25, -1.577720712060666e-27,
  1.359022633411387e+00, -2.973259941344085e-03, -5.254298689656397e-06,  1.227554674815020e-08,  8.436536687631666e-11,  1.602458517435662e-14, -1.252665739953810e-15,
 -3.152113612605717e-18,  1.455001032121001e-20,  9.260684978251064e-23, -5.177659245214017e-26, -1.937246996674283e-27,  1.437808087347112e+00, -2.769412847618228e-03,
 -6.047419691403876e-06,  6.224875514326699e-09,  8.343897467727256e-11,  1.415821898651726e-13, -8.684515122933961e-16, -4.824782111610352e-18,  9.314152916465686e-22,
  9.059469449095321e-23,  2.571117911564293e-25, -9.690384568723628e-28,  1.513635669506586e+00, -2.531444540011034e-03, -6.552556941625362e-06,  5.620108332371774e-11,
  7.244005196031751e-11,  2.326598402498875e-13, -3.089738716285084e-16, -4.839170705836429e-18, -1.165775116995559e-20,  4.548866904237050e-23,  3.819463110507698e-25,
  5.257804610713506e-28,  1.585893050812333e+00, -2.266135593249342e-03, -6.748365341997696e-06, -5.640335235599504e-09,  5.341711218696214e-11,  2.727661764895062e-13,
  2.627023262418256e-16, -3.321810908708636e-18, -1.790902991033674e-20, -1.492146797969796e-23,  2.664587667045944e-25,  1.408692051564185e-27,  1.653984389154043e+00,
 -1.981337080474365e-03, -6.634028627883939e-06, -1.033087267103380e-08,  2.969451425050036e-11,  2.575710040698553e-13,  6.877558869168006e-16, -9.717738316490839e-19,
 -1.586810738808940e-20, -5.674227413286799e-23,  1.865171842581712e-26,  1.140062218465038e-27,  1.717336937264141e+00, -1.685746771216479e-03, -6.230140287550837e-06,
 -1.360503776593587e-08,  5.275729536659849e-12,  1.958728806351407e-13,  8.633689462121343e-16,  1.250518298402039e-18, -7.722675981102760e-21, -6.076043667654044e-23,
 -1.798115624005624e-25,  1.538314614631016e-28,  1.775407800359796e+00, -1.388638939682975e-03, -5.577947611154026e-06, -1.523021216104056e-08, -1.590890228601389e-11,
  1.070266874741377e-13,  7.747013934069226e-16,  2.543975313766453e-18,  1.666968071486967e-21, -3.267078266156528e-23, -2.124493344431685e-25, -6.370241324191050e-28,
  1.827690712627626e+00, -1.099555866666198e-03, -4.736891036679945e-06, -1.518417924514682e-08, -3.076087262169693e-11,  1.541757522027733e-14,  4.945164823573272e-16,
  2.599167824495575e-18,  7.618129638567387e-21,  3.809775058977453e-24, -1.026443967106929e-25, -6.893601385538516e-28,  1.873722685486077e+00, -8.279720858724239e-04,
 -3.780526208483981e-06, -1.365994087755510e-08, -3.761545145255564e-11, -5.648274875467989e-14,  1.501899160804349e-16,  1.682632890145356e-18,  8.135965580757262e-21,
  2.512170176326525e-23,  3.049167365452731e-26, -2.131973276415613e-28,  1.913090369872353e+00, -5.829450346582583e-04, -2.791080950404601e-06, -1.104027829953613e-08,
 -3.654697629902662e-11, -9.440297670354453e-14, -1.288259776821537e-16,  4.379771868706815e-19,  4.591291368458482e-21,  2.343983874485229e-23,  8.518808535781690e-26,
  2.044109408111751e-28,  1.945435973586830e+00, -3.727677308526456e-04, -1.853054699647062e-06, -7.844214387187331e-09, -2.929703587919477e-11, -9.593181932450640e-14,
 -2.614459193176544e-16, -4.827787674913464e-19,  2.807616327409800e-22,  8.508740550256467e-24,  5.348217048579453e-26,  2.410020222657063e-28,  1.970462599108118e+00,
 -2.046400555998203e-04, -1.046392780977101e-06, -4.652171771805182e-09, -1.882937328679602e-11, -7.035394529748347e-14, -2.421444225978090e-16, -7.536950569592075e-19,
 -2.016046634972802e-21, -3.906424100448319e-24,  9.906607634531987e-29,  5.404624953600540e-29,  1.987939041520776e+00, -8.437411020936727e-05, -4.398385278139886e-07,
 -2.020439082369214e-09, -8.604725716338260e-12, -3.469535056015925e-14, -1.336932701900944e-16, -4.939772397839150e-19, -1.748626255989847e-21, -5.900415388012858e-24,
 -1.876870928479471e-26, -5.500982433346186e-29,  1.997706454473351e+00, -1.613142044609388e-05, -8.499217242407680e-08, -3.974087073786065e-10, -1.738585639872109e-12,
 -7.284090267938353e-15, -2.958578894763241e-17, -1.173285044918296e-19, -4.562922850385504e-22, -1.745098288474919e-24, -6.575277053208975e-27, -2.443426315791392e-29,
  7.906382237817930e-04, -5.002300871720948e-06,  2.372787703299251e-08, -9.999728799820293e-11,  3.948365553378291e-13, -1.495544996696283e-15,  5.502573000135946e-18,
 -1.981284234895904e-20,  7.014440629740400e-23, -2.449610490203311e-25,  8.457078959143801e-28, -2.891098707271622e-30,  7.109946022676210e-03, -4.485797132680233e-05,
  2.115603110129081e-07, -8.829684243410679e-10,  3.435279913522004e-12, -1.274183227541674e-14,  4.556387223841608e-17, -1.580180022909188e-19,  5.330338323007864e-22,
 -1.750554109192303e-24,  5.592950871598275e-27, -1.734139456277600e-29,  1.971762590420574e-02, -1.237039747165572e-04,  5.767013627599799e-07, -2.359794653973874e-09,
  8.904398935140769e-12, -3.158318703683578e-14,  1.060059595499583e-16, -3.364131317399486e-19,  1.001188448218816e-21, -2.739655372565886e-24,  6.579320961815685e-27,
 -1.202723428202425e-29,  3.855174427314784e-02, -2.398220937438601e-04,  1.098545688634425e-06, -4.359764820582012e-09,  1.566705340667726e-11, -5.153959222129501e-14,
  1.539547738986732e-16, -4.041186308045022e-19,  8.438289015163038e-22, -8.184414789307353e-25, -4.290274042087749e-27,  3.617573019992491e-29,  6.351924852880247e-02,
 -3.906662495823440e-04,  1.747280409104623e-06, -6.645135117026010e-09,  2.223122032230740e-11, -6.479513647302481e-14,  1.545624602445290e-16, -2.307416616765931e-19,
 -3.167406705032581e-22,  4.552321692325683e-24, -2.422051224203370e-26,  9.524786667531798e-29,  9.449579343748142e-02, -5.729002762309720e-04,  2.485169317129719e-06,
 -8.931788553499344e-09,  2.697284942089551e-11, -6.408026369696376e-14,  8.385195701592356e-17,  2.205126181552278e-19, -2.260742259903978e-21,  1.079988236378559e-23,
 -3.698755785028594e-26,  8.735081991070989e-29,  1.313255248579812e-01, -7.824487192785994e-04,  3.268214324560773e-06, -1.091461161721110e-08,  2.839164911788317e-11,
 -4.457620932584477e-14, -6.054762546580017e-17,  8.504699248415614e-19, -4.112652176097001e-21,  1.305845868582861e-23, -2.280300048115568e-26, -4.061416021566621e-29,
  1.738208342487856e-01, -1.014560969126174e-03,  4.048148873594825e-06, -1.229582090357402e-08,  2.536517692614768e-11, -5.447367594830049e-15, -2.542175439447927e-16,
  1.434180013369239e-18, -4.654408810511136e-21,  6.991407666101370e-24,  2.433347202732368e-26, -2.387715130372064e-28,  2.217621011910251e-01, -1.263889037907960e-03,
  4.774704847824683e-06, -1.281415431443696e-08,  1.736663091423340e-11,  4.935194851153600e-14, -4.485473251610956e-16,  1.688020137427828e-18, -2.919734989174776e-21,
 -7.789315696501956e-24,  8.421727944431879e-26, -3.477992881336356e-28,  2.748974452301786e-01, -1.524579233533604e-03,  5.398080484625175e-06, -1.227261742077429e-08,
  4.613511505741421e-12,  1.112413512523306e-13, -5.814103074007994e-16,  1.376725209418746e-18,  1.180983440236072e-21, -2.583791003486987e-23,  1.150865579801813e-25,
 -2.015634982047590e-28,  3.329425126863082e-01, -1.790377860204311e-03,  5.871522178844285e-06, -1.056237395000983e-08, -1.187985644662535e-11,  1.682277936878829e-13,
 -5.939552394603770e-16,  4.250605616042978e-19,  6.524016487228750e-21, -3.722518544345489e-23,  7.774729035205122e-26,  2.147733093659393e-28,  3.955803286960587e-01,
 -2.054750868760675e-03,  6.153918391622624e-06, -7.680420061010605e-09, -3.036312119018626e-11,  2.070452573257545e-13, -4.495039145968150e-16, -1.009445322147786e-18,
  1.096968773281773e-20, -3.224222222862566e-23, -3.279839571195217e-26,  6.775014867613862e-28,  4.624612495856634e-01, -2.311017078818920e-03,  6.212289952914248e-06,
 -3.738914253333072e-09, -4.852783779037399e-11,  2.158902254620388e-13, -1.492821501746520e-16, -2.539769525394500e-18,  1.213084811863012e-20, -7.507207207175990e-24,
 -1.699037504116324e-25,  8.174103754943045e-28,  5.332030556472420e-01, -2.552494185601403e-03,  6.024049025339659e-06,  1.035527354414332e-09, -6.379046370893833e-11,
  1.872489797677898e-13,  2.602784981091499e-16, -3.643817089223311e-18,  8.473695857492333e-21,  2.990387138985274e-23, -2.501276654706495e-25,  3.806584103069565e-28,
  6.073912293643362e-01, -2.772656238150327e-03,  5.578890388594780e-06,  6.313603319083413e-09, -7.365151112980812e-11,  1.202138918145337e-13,  6.923981429929630e-16,
 -3.832757104375478e-18,  2.872266225438761e-22,  6.343054862328352e-23, -2.002160550806761e-25, -5.098331965742755e-28,  6.845794689099767e-01, -2.965300627458336e-03,
  4.880175352122009e-06,  1.168632658746882e-08, -7.608633177151936e-11,  2.169743616481876e-14,  1.037757848257239e-15, -2.843182639030763e-18, -9.993052603495636e-21,
  7.397937411342526e-23, -1.202627390603695e-26, -1.321011335263115e-27,  7.642904910551612e-01, -3.124721855471469e-03,  3.945672617870908e-06,  1.669835133604328e-08,
 -6.991118918234061e-11, -9.390374919578598e-14,  1.192269903980009e-15, -7.824806797569603e-19, -1.842660539972989e-20,  5.028664416686976e-23,  2.323496556425997e-25,
 -1.412477104107503e-27,  8.460171811344722e-01, -3.245888481736696e-03,  2.807534023858639e-06,  2.088954061389313e-08, -5.506300044238262e-11, -2.067687853806693e-13,
  1.088149879463395e-15,  1.840075439366612e-18, -2.108631521421145e-20, -2.695024385033036e-24,  3.924523982697851e-25, -5.251219184348125e-28,  9.292241499961252e-01,
 -3.324618690111671e-03,  1.511408418456284e-06,  2.384147556605321e-08, -3.273488073950310e-11, -2.952398602078346e-13,  7.192674877731466e-16,  4.232444870702929e-18,
 -1.589795672420589e-20, -6.299584266394635e-23,  3.511246718485995e-25,  9.062564299849424e-28,  1.013349758416948e+00, -3.357748926770728e-03,  1.146356122357553e-07,
  2.522450529559612e-08, -5.324023910160206e-12, -3.403391869914340e-13,  1.517914489250444e-16,  5.571000563988289e-18, -3.947445927360364e-21, -1.007329128546660e-22,
  9.954711627474007e-26,  1.934569570689989e-27,  1.097808667725304e+00, -3.343289095744529e-03, -1.316484784342416e-06,  2.484011729897662e-08,  2.382639049566637e-11,
 -3.302801742711272e-13, -4.858211067647504e-16,  5.306490248082292e-18,  1.051682832990666e-20, -9.376120676598083e-23, -2.357560638779128e-25,  1.750705549880412e-27,
  1.181994970743322e+00, -3.280556943637475e-03, -2.710288401002925e-06,  2.265306150865032e-08,  5.087566899248491e-11, -2.638679772578982e-13, -1.033698945224076e-15,
  3.408231256490813e-18,  2.164163501868273e-20, -4.154657588162336e-23, -4.567934113956004e-25,  3.551688864856048e-28,  1.265285949029429e+00, -3.170283625788448e-03,
 -3.994066295849532e-06,  1.880796784215646e-08,  7.207070040982509e-11, -1.517725473436293e-13, -1.345426404692895e-15,  4.336629970454723e-19,  2.456017653112844e-20,
  3.175203418791884e-23, -4.198844297962031e-25, -1.324693908077938e-27,  1.347046490223398e+00, -3.014682143637850e-03, -5.098887848120719e-06,  1.362629405339528e-08,
  8.437835472563922e-11, -1.504282792108648e-14, -1.333909158268789e-15, -2.633741120185249e-18,  1.782559461626763e-20,  8.878378589578776e-23, -1.403948307928632e-25,
 -2.076728418931013e-27,  1.426634182646866e+00, -2.817470508103908e-03, -5.964621393027580e-06,  7.581373966710760e-09,  8.605127795149580e-11,  1.191246770929944e-13,
 -1.002624204344740e-15, -4.740899666076931e-18,  4.366620073507124e-21,  9.991110663762877e-23,  2.058460449602455e-25, -1.361726818326144e-27,  1.503405082986409e+00,
 -2.583842243404301e-03, -6.544776160906166e-06,  1.252017780309850e-09,  7.700790874518822e-11,  2.235779711308853e-13, -4.494258789629645e-16, -5.183028334174986e-18,
 -9.740340440961939e-21,  6.114485197644738e-23,  3.986358840785656e-25,  2.200563740992788e-28,  1.576720126989786e+00, -2.320378305953669e-03, -6.810740275947845e-06,
 -4.741709082876703e-09,  5.892761389525099e-11,  2.778897250114545e-13,  1.616029912551865e-16, -3.901315796318581e-18, -1.823933860773711e-20, -3.016045911708648e-24,
  3.288756678653397e-25,  1.417116840417938e-27,  1.645952123153921e+00, -2.034896717193382e-03, -6.754975552440211e-06, -9.813662556402424e-09,  3.500848723581370e-11,
  2.736913704549394e-13,  6.531318346070183e-16, -1.511990354838170e-18, -1.788464824606652e-20, -5.492014846222163e-23,  7.425912362576000e-26,  1.387600830360516e-27,
  1.710493236379497e+00, -1.736239195233003e-03, -6.392761316473318e-06, -1.348814922318220e-08,  9.403078794389331e-12,  2.169839139262684e-13,  8.945850619700313e-16,
  9.670234044834083e-19, -1.003732470738515e-20, -6.775532082098890e-23, -1.683048407602288e-25,  3.773641630715601e-28,  1.769762834057039e+00, -1.433997728612895e-03,
 -5.762163435350161e-06, -1.546659580441684e-08, -1.357664414339619e-11,  1.264791776255910e-13,  8.464906799286049e-16,  2.576805217724255e-18,  3.311392527934838e-22,
 -4.172468455603867e-23, -2.400668735672367e-25, -6.122945449380624e-28,  1.823215533130903e+00, -1.138188174771635e-03, -4.922041898150551e-06, -1.567321630455008e-08,
 -3.032779945154386e-11,  2.818693523264185e-14,  5.707207185452715e-16,  2.844288561006941e-18,  7.673747827912399e-21, -9.378446954863906e-25, -1.356184362610510e-25,
 -8.103655379937498e-28,  1.870349256011922e+00, -8.588822886048675e-04, -3.948093181499741e-06, -1.427061293420701e-08, -3.870508901629338e-11, -5.228256288668669e-14,
  2.010860720809438e-16,  1.957669270960410e-18,  9.059784905160564e-21,  2.612540369164777e-23,  1.895031894852466e-26, -3.152804038800945e-28,  1.910713079152792e+00,
 -6.058137009594154e-04, -2.927135637715335e-06, -1.164029790721449e-08, -3.846487153771987e-11, -9.733023407253558e-14, -1.143740708708978e-16,  5.990750974089832e-19,
  5.498627094108616e-21,  2.702695664870951e-23,  9.414426094912633e-26,  2.011221409190619e-28,  1.943914646182805e+00, -3.879768075882322e-04, -1.950062219591891e-06,
 -8.328661551839986e-09, -3.127950772517784e-11, -1.023674214963853e-13, -2.747888268375849e-16, -4.684589893831042e-19,  6.282532243364279e-22,  1.087273321490062e-23,
  6.504052768834244e-26,  2.853639289391460e-28,  1.969626935662071e+00, -2.132397327078233e-04, -1.104073938420707e-06, -4.965021439964371e-09, -2.029631446136476e-11,
 -7.642607279829322e-14, -2.641721806331870e-16, -8.204529006570274e-19, -2.155982441892735e-21, -3.849225059853341e-24,  2.910573405027354e-27,  7.461774462326423e-29,
  1.987594350734923e+00, -8.799219388662825e-05, -4.649333272517055e-07, -2.163845104931912e-09, -9.331872983223868e-12, -3.807649000101841e-14, -1.483410115601617e-16,
 -5.534816692569369e-19, -1.975156500285462e-21, -6.701613055779162e-24, -2.134285938012518e-26, -6.210593842580400e-29,  1.997640538031209e+00, -1.683091766687134e-05,
 -8.993291672906441e-08, -4.264312593417835e-10, -1.891642915929208e-12, -8.035281450377835e-15, -3.308522495560636e-17, -1.329879766129925e-19, -5.241211124357836e-22,
 -2.030940437525133e-24, -7.751292226645289e-27, -2.916873017663496e-29,  7.710012152113176e-04, -4.817172557266722e-06,  2.256484956488736e-08, -9.391219911413108e-11,
  3.662026145091244e-13, -1.369894638522888e-15,  4.977957525464831e-18, -1.770303082661985e-20,  6.190527755376712e-23, -2.135443832033897e-25,  7.282674842168324e-28,
 -2.459468934919343e-30,  6.933833290835128e-03, -4.320695591582916e-05,  2.012862556165235e-07, -8.299846939845843e-10,  3.191029932262031e-12, -1.169952266301989e-14,
  4.136899273504569e-17, -1.419275109153623e-19,  4.738634018832946e-22, -1.541389708741040e-24,  4.882130589027633e-27, -1.502549094548174e-29,  1.923186123985868e-02,
 -1.192012590853592e-04,  5.492182434793000e-07, -2.222242487835428e-09,  8.297431969735378e-12, -2.914854786397290e-14,  9.702045342356862e-17, -3.059033811084042e-19,
  9.071711387058294e-22, -2.486985337813543e-24,  6.056589424107289e-27, -1.169791128840372e-29,  3.760970720154733e-02, -2.312388125623999e-04,  1.047699171708014e-06,
 -4.117141336478341e-09,  1.467230981680682e-11, -4.797743855677731e-14,  1.430128393551883e-16, -3.776176815232865e-19,  8.116375797502896e-22, -9.606147556557672e-25,
 -2.874758079490979e-27,  2.843149044749374e-29,  6.198404339532513e-02, -3.770010230933338e-04,  1.669630866885459e-06, -6.299603479647883e-09,  2.097188396084893e-11,
 -6.116416701795782e-14,  1.479831442318783e-16, -2.384342567851288e-19, -1.693231354403541e-22,  3.663247827785338e-24, -2.033096665190415e-26,  8.182052588608983e-29,
  9.224328645576575e-02, -5.534404076112261e-04,  2.380535314640525e-06, -8.510364505297316e-09,  2.571182797839202e-11, -6.200155010924382e-14,  8.906995425466344e-17,
  1.541115208041134e-19, -1.897659195169361e-21,  9.396352435475916e-24, -3.321430736115383e-26,  8.387933057850056e-29,  1.282472027120410e-01, -7.568192517408478e-04,
  3.139934928908595e-06, -1.046754854449924e-08,  2.748744732990414e-11, -4.575803778791361e-14, -3.850753645577182e-17,  7.262076447249904e-19, -3.659328306331364e-21,
  1.211799383902504e-23, -2.404896110562157e-26, -1.707796956916722e-29,  1.698264359985494e-01, -9.827590885798272e-04,  3.903029447242927e-06, -1.189116779761127e-08,
  2.519838411212892e-11, -1.108329572182309e-14, -2.161066167143714e-16,  1.289434141772475e-18, -4.387600464114046e-21,  7.768761263772202e-24,  1.487261932996315e-26,
 -1.923065308425510e-28,  2.167819732042276e-01, -1.226301683514978e-03,  4.622632913686055e-06, -1.252896093684981e-08,  1.824979137487882e-11,  3.914319312225121e-14,
 -4.026284936304883e-16,  1.590722764281887e-18, -3.143115293034559e-21, -4.717121181635041e-24,  6.963481586831206e-26, -3.145604555401845e-28,  2.688845668532651e-01,
 -1.481982256191180e-03,  5.251322972068051e-06, -1.218174760696742e-08,  6.701941007098485e-12,  9.775352583330601e-14, -5.424665247221386e-16,  1.400504583202729e-18,
  3.314566470648005e-22, -2.142113881133015e-23,  1.055511772423318e-25, -2.291933707099468e-28,  3.258741386288837e-01, -1.743915657348094e-03,  5.743741758746405e-06,
 -1.072630526843892e-08, -8.656769047199722e-12,  1.541380627557830e-13, -5.793278701690260e-16,  6.130041732352457e-19,  5.241877543291978e-21, -3.395761991819967e-23,
  8.489111224647469e-26,  1.131799506675242e-28,  3.874591929539856e-01, -2.005896129703852e-03,  6.058973217851655e-06, -8.133697822074444e-09, -2.633218598325570e-11,
  1.959565759846546e-13, -4.730299363686692e-16, -6.771838544178288e-19,  9.792214021199358e-21, -3.299341804216663e-23, -5.635390248903791e-27,  5.575880499427193e-28,
  4.533162755483696e-01, -2.261511099880068e-03,  6.162906102254799e-06, -4.481035278895105e-09, -4.425139571805392e-11,  2.114976615637816e-13, -2.150106520664161e-16,
 -2.157148280595374e-18,  1.174685695172748e-20, -1.359200616851727e-23, -1.345846992181451e-25,  7.834235290383096e-28,  5.230895182716001e-01, -2.504269152438213e-03,
  6.030476059390121e-06,  4.514504918975627e-11, -5.999111912233611e-11,  1.923029086069886e-13,  1.621961100187619e-16, -3.357329953148476e-18,  9.374550796554355e-21,
  2.027385413782528e-23, -2.304609286347890e-25,  5.059548554108878e-28,  5.963903184577016e-01, -2.727741906883150e-03,  5.647665249618838e-06,  5.155279808184253e-09,
 -7.108973631553829e-11,  1.355467331582462e-13,  5.855416553391400e-16, -3.788615006522787e-18,  2.421831557334225e-21,  5.504620543714735e-23, -2.172354913946447e-25,
 -2.675599102133637e-28,  6.727972082038363e-01, -2.925718934812327e-03,  5.013125611665401e-06,  1.047374241939897e-08, -7.540994583138700e-11,  4.561463505278596e-14,
  9.540709185711938e-16, -3.120551505578078e-18, -7.351967618103280e-21,  7.239060468773430e-23, -6.599902255085830e-26, -1.127231095334339e-27,  7.518559764484561e-01,
 -3.092374102182393e-03,  4.139284396223863e-06,  1.556629380325973e-08, -7.150523108982213e-11, -6.561708177874042e-14,  1.162389556193273e-15, -1.341495818188087e-18,
 -1.646412564695510e-20,  5.832186991963199e-23,  1.691542570296636e-25, -1.447925109745242e-27,  8.330801138101492e-01, -3.222440793720831e-03,  3.052790636691007e-06,
  1.997688469422960e-08, -5.893344093872254e-11, -1.801111535924457e-13,  1.130232048181786e-15,  1.166739938326994e-18, -2.090718884879592e-20,  1.244839701311413e-23,
  3.625305041418320e-25, -8.253602666291421e-28,  9.159516565685768e-01, -3.311392378299613e-03,  1.794171864124051e-06,  2.327145625413941e-08, -3.845776019606536e-11,
 -2.766148228070407e-13,  8.303324713023317e-16,  3.690206730625085e-18, -1.790439286679584e-20, -4.826406881823747e-23,  3.826904577361614e-25,  5.258211152777650e-28,
  9.999225112175378e-01, -3.355623029520628e-03,  4.165947309928187e-07,  2.508511731567457e-08, -1.208183054867015e-11, -3.348419292164435e-13,  3.054722742554188e-16,
  5.387592747392499e-18, -7.482014015792504e-21, -9.509070390177052e-23,  1.813557516254036e-25,  1.768956673752069e-27,  1.084416343917268e+00, -3.352622673499000e-03,
 -1.016335940699445e-06,  2.516791236971961e-08,  1.711640814330648e-11, -3.401220513910081e-13, -3.330473584055771e-16,  5.587357236343461e-18,  6.990891840716017e-21,
 -1.015810600017960e-22, -1.536733921859182e-25,  1.965101972437848e-27,  1.168831118983668e+00, -3.301138475381201e-03, -2.433746025882123e-06,  2.342353922809435e-08,
  4.535834968699595e-11, -2.874548372660294e-13, -9.288227925837842e-16,  4.073344990700082e-18,  1.982206822773997e-20, -5.937017405589719e-23, -4.310401209611621e-25,
  8.141719683155401e-28,  1.252542366227769e+00, -3.201314012534004e-03, -3.761557732312746e-06,  1.993506674373241e-08,  6.871379370520731e-11, -1.838273231033271e-13,
 -1.322132783090687e-15,  1.234527902350379e-18,  2.538774558205861e-20,  1.388662566264502e-23, -4.708559692551969e-25, -9.775334312578305e-28,  1.334907247398385e+00,
 -3.054796267681385e-03, -4.927287625760562e-06,  1.497217758284837e-08,  8.375173214598787e-11, -4.787421728407194e-14, -1.399196314856769e-15, -2.013446583852337e-18,
  2.089850460320920e-20,  8.131989461644853e-23, -2.331251057912548e-25, -2.121147798731566e-27,  1.415269476128029e+00, -2.864799994997617e-03, -5.865309718083931e-06,
  8.975902134113215e-09,  8.818248522751579e-11,  9.348792082842618e-14, -1.132861813111568e-15, -4.542153961259118e-18,  8.096145485410320e-21,  1.068322424423818e-22,
  1.374154541326950e-25, -1.745087797779962e-27,  1.492965122761558e+00, -2.636119073903387e-03, -6.522213661504192e-06,  2.519280795301190e-09,  8.135967785395786e-11,
  2.110171757471176e-13, -5.985614090843298e-16, -5.456409679816046e-18, -7.250738117507789e-21,  7.717706402183337e-23,  4.001992020365007e-25, -1.608820262832375e-28,
  1.567329304738255e+00, -2.375075378313980e-03, -6.861799748517293e-06, -3.754232501724848e-09,  6.451500398694196e-11,  2.803913946996252e-13,  4.419740672092660e-17,
 -4.484051716932673e-18, -1.809621588724201e-20,  1.137200203007763e-23,  3.900289799232701e-25,  1.348523397135216e-27,  1.637703724836568e+00, -2.089397633639136e-03,
 -6.869195335390413e-06, -9.208900038266936e-09,  4.063529519488269e-11,  2.887920315072580e-13,  6.024913545369702e-16, -2.115236089011213e-18, -1.979293791600951e-20,
 -5.065694560839533e-23,  1.406508389152849e-25,  1.627556345577773e-27,  1.703444974373378e+00, -1.788025821852645e-03, -6.553569399958361e-06, -1.330180747356126e-08,
  1.395945338892688e-11,  2.387402809320752e-13,  9.167892508178531e-16,  6.055396448469875e-19, -1.259300058554486e-20, -7.407854808827691e-23, -1.458635624714765e-25,
  6.509831921376163e-28,  1.763933468115556e+00, -1.480840925999882e-03, -5.948978823967472e-06, -1.566245708415167e-08, -1.083805858029903e-11,  1.476605024177013e-13,
  9.185502482982916e-16,  2.561463149952945e-18, -1.350148520787674e-21, -5.184995819439683e-23, -2.657117257754721e-25, -5.455051226958245e-28,  1.818582825013876e+00,
 -1.178325025685164e-03, -5.113010873265168e-06, -1.615317939025111e-08, -2.962049379537112e-11,  4.286759131101123e-14,  6.537856825679399e-16,  3.088189395515519e-18,
  7.533415319855072e-21, -7.112147436076101e-24, -1.739994490512181e-25, -9.342042748090319e-28,  1.866849457834749e+00, -8.911626289328543e-04, -4.123089829993616e-06,
 -1.489797811471156e-08, -3.969786660903023e-11, -4.676508654374407e-14,  2.601018616365082e-16,  2.262747693465928e-18,  1.001028043726716e-20,  2.657045343518665e-23,
  2.375627474505522e-27, -4.425466657707117e-28,  1.908242090549365e+00, -6.298001316868672e-04, -3.070576544870175e-06, -1.227145176037244e-08, -4.043746062449316e-11,
 -9.985311407052907e-14, -9.498503224019480e-17,  7.913426110142206e-19,  6.541485137721320e-21,  3.096635342441793e-23,  1.027189941271525e-25,  1.864168302984433e-28,
  1.942330892759226e+00, -4.039857470740071e-04, -2.053077726238473e-06, -8.845875201557432e-09, -3.339385459560318e-11, -1.091171035511592e-13, -2.875616516024729e-16,
 -4.415646659075908e-19,  1.069657157298861e-21,  1.373987858732450e-23,  7.868427554233648e-26,  3.358276634372435e-28,  1.968755926256786e+00, -2.223162842868913e-04,
 -1.165654220642734e-06, -5.302343076119258e-09, -2.189013885874156e-11, -8.304980041103682e-14, -2.881313744997605e-16, -8.916321715245066e-19, -2.291601838313573e-21,
 -3.659816624176658e-24,  6.752667960172800e-27,  1.011158690706209e-28,  1.987234774912552e+00, -9.181812249883166e-05, -4.918211001059511e-07, -2.319446148297791e-09,
 -1.013029780202946e-11, -4.183001523328629e-14, -1.647608438620054e-16, -6.207170511188736e-19, -2.232460251449242e-21, -7.612213676388087e-24, -2.424355627952562e-26,
 -6.984652907395468e-29,  1.997571742282244e+00, -1.757137672837833e-05, -9.523713614213880e-08, -4.580276351915030e-10, -2.060600705108748e-12, -8.875975791913225e-15,
 -3.705512764333909e-17, -1.509921189603289e-19, -6.031396983163001e-22, -2.368267480420123e-24, -9.156753151098002e-27, -3.489675016546893e-29,  7.520865631768150e-04,
 -4.641063980081218e-06,  2.147217507195082e-08, -8.826581376211642e-11,  3.399604085291549e-13, -1.256154934234139e-15,  4.508889415657718e-18, -1.583964619703783e-20,
  5.471697501869224e-23, -1.864665848037223e-25,  6.282659161160611e-28, -2.096337624028928e-30,  6.764164170768041e-03, -4.163565461544810e-05,  1.916252276008590e-07,
 -7.807475144938465e-10,  2.966654788452494e-12, -1.075269094760029e-14,  3.759923263678383e-17, -1.276152887554848e-19,  4.217347606587763e-22, -1.358717875953796e-24,
  4.265992106520214e-27, -1.302966437463008e-29,  1.876367793380207e-02, -1.149119673735028e-04,  5.233290510498067e-07, -2.094023683533136e-09,  7.737068740578760e-12,
 -2.691964126721649e-14,  8.884843942094264e-17, -2.782606500557276e-19,  8.218776062365219e-22, -2.254877629946626e-24,  5.552479021181074e-27, -1.119325893456328e-29,
  3.670120777482840e-02, -2.230509228363531e-04,  9.996709466930834e-07, -3.889877823370977e-09,  1.374624271980044e-11, -4.466910776071490e-14,  1.327978144228596e-16,
 -3.522184575973841e-19,  7.752692254841601e-22, -1.052530218042495e-24, -1.766710768648038e-27,  2.215337622670579e-29,  6.050228255915344e-02, -3.639407444999654e-04,
  1.596009176495123e-06, -5.973648912379899e-09,  1.978357313910298e-11, -5.769318132603536e-14,  1.412498744724590e-16, -2.418926969960561e-19, -5.124982135906316e-23,
  2.918415951369183e-24, -1.699680866218178e-26,  6.998597984480391e-29,  9.006697635270239e-02, -5.347977224541054e-04,  2.280838734991414e-06, -8.108778010838364e-09,
  2.449348912023859e-11, -5.981864810163586e-14,  9.258399188729329e-17,  9.854945107200199e-20, -1.582427472791185e-21,  8.140246496413353e-24, -2.962634166717481e-26,
  7.903430494891740e-29,  1.252693795933612e-01, -7.321948078991202e-04,  3.016932796685668e-06, -1.003511420656201e-08,  2.656462510506228e-11, -4.645104860014234e-14,
 -1.974884937606643e-17,  6.159023181583177e-19, -3.240525219358726e-21,  1.114660304632584e-23, -2.439173845312099e-26,  6.288435393697910e-31,  1.659569540383686e-01,
 -9.520987937133593e-04,  3.762746283597756e-06, -1.149003678884096e-08,  2.492769616111432e-11, -1.585220808556906e-14, -1.819253348192331e-16,  1.153604743522443e-18,
 -4.099143298451272e-21,  8.206725943778313e-24,  7.318714779748365e-27, -1.520589871781096e-28,  2.119497834779122e-01, -1.189916990226273e-03,  4.474061537102178e-06,
 -1.223121145413171e-08,  1.893957282156355e-11,  3.000308826942339e-14, -3.595182220356230e-16,  1.487937133787141e-18, -3.266036952075729e-21, -2.198286599636946e-24,
  5.656244053819538e-26, -2.795051985330754e-28,  2.630397359469703e-01, -1.440554429315983e-03,  5.105847649532062e-06, -1.205957001754517e-08,  8.529999177274983e-12,
  8.520541341314199e-14, -5.032141412598880e-16,  1.399567443215547e-18, -3.661833794073206e-22, -1.740559209426398e-23,  9.513064437465585e-26, -2.423589497604011e-28,
  3.189895576469786e-01, -1.698482711160090e-03,  5.614294346472384e-06, -1.084090076411477e-08, -5.711562934549124e-12,  1.404580119796609e-13, -5.599944496925288e-16,
  7.618482062688120e-19,  4.081489339571085e-21, -3.048799092189577e-23,  8.799021267425282e-26,  3.076157775910808e-29,  3.795319241216747e-01, -1.957821629994068e-03,
  5.958968271282013e-06, -8.524282400495339e-09, -2.252793916354415e-11,  1.844106344841675e-13, -4.877827751805020e-16, -3.828347971818163e-19,  8.605992431663054e-21,
 -3.276251986573148e-23,  1.634199574666569e-26,  4.425499861272869e-28,  4.443684805166944e-01, -2.212434657579049e-03,  6.105024170885325e-06, -5.155518136413933e-09,
 -4.007771997885855e-11,  2.056545931088175e-13, -2.702287933541102e-16, -1.790050323108292e-18,  1.116881246630884e-20, -1.830151078284300e-23, -1.013115538935365e-25,
  7.257395113691587e-28,  5.131689100601470e-01, -2.456039201066762e-03,  6.025386171735571e-06, -8.837642315525010e-10, -5.611357048283710e-11,  1.951020626491762e-13,
  7.248796820614388e-17, -3.047400511486616e-18,  9.944096447557633e-21,  1.152792492016212e-23, -2.062348679369675e-25,  5.884971229929531e-28,  5.855700782546366e-01,
 -2.682332257050287e-03,  5.702795828682400e-06,  4.040259163556323e-09, -6.824681142462390e-11,  1.483372861887503e-13,  4.808312552922264e-16, -3.681105901059085e-18,
  4.244849178862083e-21,  4.618692027468976e-23, -2.241594130104674e-25, -5.218172268096469e-29,  6.611753096227898e-01, -2.885131624520331e-03,  5.131605219296813e-06,
  9.275695580884070e-09, -7.427588076977318e-11,  6.743963452894057e-14,  8.637893966640450e-16, -3.314720282313330e-18, -4.804810058239793e-21,  6.882134134094455e-23,
 -1.108831416520324e-25, -9.103911866607815e-28,  7.395538640512125e-01, -3.058532184290769e-03,  4.319176984919567e-06,  1.441321331186796e-08, -7.254194103342231e-11,
 -3.822802567898836e-14,  1.117775972413255e-15, -1.833572963724100e-18, -1.425806180787903e-20,  6.381911511598126e-23,  1.059558819677270e-25, -1.414056585114112e-27,
  8.202406905494282e-01, -3.197075872201901e-03,  3.286741570518980e-06,  1.900661543072311e-08, -6.226215075070588e-11, -1.526686479106772e-13,  1.153621236305762e-15,
  5.076033149066233e-19, -2.020746466094393e-20,  2.614868973465957e-23,  3.207586735632601e-25, -1.062153273549112e-27,  9.027365471228319e-01, -3.295932847247534e-03,
  2.069558428879131e-06,  2.261299041936027e-08, -4.378274849236158e-11, -2.555131751546155e-13,  9.253971784968101e-16,  3.092458861912689e-18, -1.936182343048404e-20,
 -3.260757841840683e-23,  3.973246518305410e-25,  1.404455269920091e-28,  9.865085857771890e-01, -3.351089978418690e-03,  7.162367165728058e-07,  2.483868241721209e-08,
 -1.869328977909364e-11, -3.257305277778371e-13,  4.524691423207610e-16,  5.094944406896972e-18, -1.075655374560333e-20, -8.634774741480659e-23,  2.539699852389059e-25,
  1.519060053044209e-27,  1.070991510497427e+00, -3.359541165109153e-03, -7.129035580890632e-07,  2.538697468081850e-08,  1.024682404185665e-11, -3.462159740664065e-13,
 -1.740266584302292e-16,  5.751540485585939e-18,  3.244559137631298e-21, -1.059570596826519e-22, -6.428055366089782e-26,  2.081140719913990e-27,  1.155589422166585e+00,
 -3.319472220836865e-03, -2.148502688112493e-06,  2.410210890554596e-08,  3.939593544498297e-11, -3.083083557513115e-13, -8.062334374016164e-16,  4.670204291042067e-18,
  1.738422522139545e-20, -7.576411165789534e-23, -3.854705726072449e-25,  1.251182580531300e-27,  1.239678466322665e+00, -3.230431191590486e-03, -3.515867281815612e-06,
  2.100336441912498e-08,  6.472321121121536e-11, -2.150515764221679e-13, -1.276143505722309e-15,  2.051222439219221e-18,  2.553937156894496e-20, -5.687122824181120e-24,
 -5.047116516040276e-25, -5.495146001061731e-28,  1.322610395660827e+00, -3.093473208404674e-03, -4.739618884695647e-06,  1.630270309596057e-08,  8.245427596905565e-11,
 -8.205324173183089e-14, -1.445784072158868e-15, -1.299835954554737e-18,  2.363576416588302e-20,  7.013936414756137e-23, -3.254189308910023e-25, -2.054748424943004e-27,
  1.403717147398186e+00, -2.911267511512217e-03, -5.749076573855854e-06,  1.040026004453149e-08,  8.977022171033569e-11,  6.480593700297057e-14, -1.255830212793684e-15,
 -4.220637669505389e-18,  1.202157153552659e-20,  1.106874233330048e-22,  5.281243249953901e-26, -2.092147074040754e-27,  1.482316514170991e+00, -2.688153412469465e-03,
 -6.484035162867716e-06,  3.853965482240694e-09,  8.542386728655138e-11,  1.947948068025409e-13, -7.541496186556596e-16, -5.640911150593131e-18, -4.187077367939233e-21,
  9.291616841369527e-23,  3.834963336162831e-25, -6.081790357615844e-28,  1.557718954443226e+00, -2.430132005028452e-03, -6.900471972605314e-06, -2.677116040879360e-09,
  7.012293325359465e-11,  2.798805439296526e-13, -8.937947239255817e-17, -5.053455543243157e-18, -1.739205725052315e-20,  2.811959798144953e-23,  4.461775506073598e-25,
  1.187228537838847e-27,  1.629235543489236e+00, -2.144781726760887e-03, -6.975608058014158e-06, -8.511764387249019e-09,  4.655055950648223e-11,  3.024678907368394e-13,
  5.341319247549621e-16, -2.776558635060096e-18, -2.149745956098788e-20, -4.353310346075449e-23,  2.171016874362712e-25,  1.841442702554519e-27,  1.696187008886880e+00,
 -1.841088696162274e-03, -6.711689527303063e-06, -1.303905736766013e-08,  1.895541585518881e-11,  2.608986450605078e-13,  9.276941061847103e-16,  1.588297534721016e-19,
 -1.535711979286759e-20, -7.924869022975782e-23, -1.102926133460317e-25,  9.736830151990759e-28,  1.757913726547681e+00, -1.529187270137045e-03, -6.137867360345496e-06,
 -1.581101827704903e-08, -7.658619895182654e-12,  1.705596786524372e-13,  9.893708499610121e-16,  2.486296363905603e-18, -3.413567605258013e-21, -6.292729812056145e-23,
 -2.872784001208762e-25, -4.249126335021951e-28,  1.813786477814324e+00, -1.220012451210780e-03, -5.309661457649366e-06, -1.661936605369762e-08, -2.859908979267646e-11,
  5.962303352497365e-14,  7.435814115554329e-16,  3.323736257159867e-18,  7.141864873495844e-21, -1.493006785971649e-23, -2.177702315451807e-25, -1.054004004431779e-27,
  1.863217690300612e+00, -9.248733171117448e-04, -4.305706268400493e-06, -1.554026501757095e-08, -4.056542115943117e-11, -3.972527796036460e-14,  3.280870995504193e-16,
  2.598358928730037e-18,  1.096344067098443e-20,  2.623237386090231e-23, -2.041333818116206e-26, -5.982515138078999e-28,  1.905672812438509e+00, -6.549649252618857e-04,
 -3.221782244848448e-06, -1.293454351648003e-08, -4.245539782572845e-11, -1.018421509112716e-13, -6.972351941600310e-17,  1.019315353953150e-18,  7.732140608446829e-21,
  3.523147643982436e-23,  1.103147258516668e-25,  1.557870096844939e-28,  1.940681415195790e+00, -4.208442223368258e-04, -2.162507281952348e-06, -9.398014720084766e-09,
 -3.564619092100344e-11, -1.161626015429209e-13, -2.993673927143032e-16, -3.987841589048372e-19,  1.624653533769308e-21,  1.719900390502351e-23,  9.468449883818605e-26,
  3.924600913362744e-28,  1.967847599098662e+00, -2.319021133569550e-04, -1.231439844377183e-06, -5.666257628196968e-09, -2.362235195315621e-11, -9.027294789170145e-14,
 -3.141430950893271e-16, -9.670101006738924e-19, -2.417336598145621e-21, -3.291336081082420e-24,  1.191835753972024e-26,  1.350582405921825e-28,  1.986859453031392e+00,
 -9.586684516321565e-05, -5.206552827373029e-07, -2.488444621478941e-09, -1.100789131507766e-11, -4.600116904699695e-14, -1.831836306727550e-16, -6.967337292622989e-19,
 -2.524717831969497e-21, -8.645831049900780e-24, -2.749792019003250e-26, -7.816584407217387e-29,  1.997499897361589e+00, -1.835583344011011e-05, -1.009373041213256e-07,
 -4.924672002035228e-10, -2.247367516927127e-12, -9.818294542328432e-15, -4.156645256716247e-17, -1.717305196133972e-19, -6.953777989189795e-22, -2.767194114993715e-24,
 -1.084013538913557e-26, -4.184259272650244e-29,  7.338592819304808e-04, -4.473432741225721e-06,  2.044481108569477e-08, -8.302169973486064e-11,  3.158845158340563e-13,
 -1.153071886378483e-15,  4.088916932661466e-18, -1.419143226094571e-20,  4.843516167867407e-23, -1.630868307980206e-25,  5.429503340872069e-28, -1.790208327144066e-30,
  6.600629337177841e-03, -4.013933777670616e-05,  1.825341150750354e-07, -7.349536270595066e-10,  2.760343047646888e-12, -9.891707154564516e-15,  3.420781680522203e-17,
 -1.148705540455174e-19,  3.757590793070481e-22, -1.199019232240230e-24,  3.731469205602362e-27, -1.130880308978072e-29,  1.831224710134476e-02, -1.108237837972851e-04,
  4.989261266676065e-07, -1.974424464440664e-09,  7.219383492005385e-12, -2.487787588749258e-14,  8.141343906872531e-17, -2.532174640367986e-19,  7.445826827787979e-22,
 -2.042453766324330e-24,  5.073196594882965e-27, -1.057857994126113e-29,  3.582470837835297e-02, -2.152365972087351e-04,  9.542831223990981e-07, -3.676915131882481e-09,
  1.288394754661713e-11, -4.159753769636206e-14,  1.232772352604398e-16, -3.280279278645903e-19,  7.363265598695386e-22, -1.105275878705750e-24, -9.074780099764295e-28,
  1.708280011751948e-29,  5.907160921342858e-02, -3.514541116123136e-04,  1.526187125410196e-06, -5.666160766284344e-09,  1.866306030739912e-11, -5.438455307170361e-14,
  1.344688119462288e-16, -2.419770663972833e-19,  4.228870445534295e-23,  2.296980061344797e-24, -1.415039937036877e-26,  5.962964253429766e-29,  8.796367190213351e-02,
 -5.169336618253757e-04,  2.185845686906987e-06, -7.726331600452229e-09,  2.331953137381094e-11, -5.756897897181552e-14,  9.467691231480568e-17,  5.237854436329676e-20,
 -1.309886177373975e-21,  7.023120217686445e-24, -2.627125155435266e-26,  7.337320407926084e-29,  1.223881187253838e-01, -7.085338761741573e-04,  2.899030904629383e-06,
 -9.617532467899768e-09,  2.563220226564091e-11, -4.672943149110712e-14, -3.896355306372430e-18,  5.184379573911554e-19, -2.856764776742825e-21,  1.017561069731495e-23,
 -2.406365022051572e-26,  1.358122625374611e-29,  1.622078990998480e-01, -9.225415904602605e-04,  3.627247699426454e-06, -1.109395651503673e-08,  2.456953085459066e-11,
 -1.984535273321433e-14, -1.514160732280671e-16,  1.027203283553708e-18, -3.799947586258397e-21,  8.376183180426420e-24,  1.404149534195461e-27, -1.177263720592190e-28,
  2.072607782587003e-01, -1.154706401887130e-03,  4.329123520267746e-06, -1.192383265472674e-08,  1.945666356405406e-11,  2.186272973163148e-14, -3.193280870465394e-16,
  1.382570966306149e-18, -3.307319698549134e-21, -1.713837103959376e-25,  4.503823296760548e-26, -2.444414314813516e-28,  2.573582987057591e-01, -1.400284062005767e-03,
  4.962005835571390e-06, -1.191010006290434e-08,  1.011650106441397e-11,  7.359665132365674e-14, -4.642793873540358e-16,  1.378537413240428e-18, -9.268735857448676e-22,
 -1.381492371311698e-23,  8.438904206729680e-26, -2.442896986822325e-28,  3.122846296857302e-01, -1.654090064381159e-03,  5.483745584561168e-06, -1.091053521634200e-08,
 -3.035001431248638e-12,  1.272878950258052e-13, -5.369943414894976e-16,  8.755754786259263e-19,  3.047414291337437e-21, -2.696155263545510e-23,  8.786173865606014e-26,
 -3.379343669720938e-29,  3.717953249621818e-01, -1.910564900822688e-03,  5.854633842299798e-06, -8.855862892954555e-09, -1.895750638570279e-11,  1.726052502619993e-13,
 -4.948228650911885e-16, -1.261519334799254e-19,  7.442707880868123e-21, -3.175142272639240e-23,  3.343821714826242e-26,  3.362302895901348e-28,  4.356160154730377e-01,
 -2.163852519998427e-03,  6.039445037884207e-06, -5.764225622264476e-09, -3.603333681874175e-11,  1.986073963654938e-13, -3.154508426093078e-16, -1.443910884142393e-18,
  1.044452205257525e-20, -2.173610069773457e-23, -7.095570482679357e-26,  6.520120602910815e-28,  5.034410711125207e-01, -2.407893498239300e-03,  6.009523094039066e-06,
 -1.750298864911112e-09, -5.220085636254630e-11,  1.958541329821667e-13, -8.332954680424368e-18, -2.724089839545081e-18,  1.021699993139182e-20,  3.812020013735526e-24,
 -1.792391733488340e-25,  6.326877059057020e-28,  5.749322751148038e-01, -2.636534291740203e-03,  5.744827083341982e-06,  2.972636401601914e-09, -6.517292932595813e-11,
  1.586572085518096e-13,  3.798995992070347e-16, -3.520398648140514e-18,  5.746146820422448e-21,  3.723087740820239e-23, -2.223127179693322e-25,  1.303822384948530e-28,
  6.497175653833182e-01, -2.843653642749210e-03,  5.235831153607097e-06,  8.099166371749299e-09, -7.272737660483788e-11,  8.704171664223554e-14,  7.691905975684561e-16,
 -3.429763525575922e-18, -2.416129273953806e-21,  6.365105814074237e-23, -1.459876328779845e-25, -6.849564202969577e-28,  7.273899096291244e-01, -3.023306714307539e-03,
  4.485150959443573e-06,  1.324786499535585e-08, -7.304265120644509e-11, -1.206689087418224e-14,  1.060398840149728e-15, -2.252373523669552e-18, -1.189907349046102e-20,
  6.683644907411522e-23,  4.558910592964141e-26, -1.321128126248993e-27,  8.075063952262421e-01, -3.169886779666251e-03,  3.508747910869227e-06,  1.798750188689517e-08,
 -6.503787699899154e-11, -1.248832977018107e-13,  1.158939810196536e-15, -1.215924090986874e-19, -1.904693136614473e-20,  3.799014952180155e-23,  2.701029047484131e-25,
 -1.228451369966975e-27,  8.895876299413998e-01, -3.278303245583022e-03,  2.336546517618951e-06,  2.187281922117149e-08, -4.866426901243036e-11, -2.323355638638135e-13,
  1.003157363620494e-15,  2.457171344574400e-18, -2.024914076349613e-20, -1.670130892381757e-23,  3.953054078946380e-25, -2.276751827200708e-28,  9.731175655649748e-01,
 -3.344173403544145e-03,  1.012293409608172e-06,  2.448811068408521e-08, -2.508796534811742e-11, -3.132010617725312e-13,  5.898560456670651e-16,  4.703084520188315e-18,
 -1.366690978062632e-20, -7.494129008986223e-23,  3.140414252706213e-25,  1.202036479975929e-27,  1.057543872029575e+00, -3.364023559103141e-03, -4.075052544243100e-07,
  2.549535729934181e-08,  3.293828283893640e-12, -3.484519017864666e-13, -1.210589845173642e-17,  5.794018770714508e-18, -5.939967957160707e-22, -1.066861171005408e-22,
  2.790109406219995e-26,  2.091217968447889e-27,  1.142279003502364e+00, -3.335493100653758e-03, -1.855702136356700e-06,  2.468210876533807e-08,  3.304717813165749e-11,
 -3.260285320597935e-13, -6.681101769950171e-16,  5.179998389198956e-18,  1.439353187681324e-20, -8.996346960838542e-23, -3.216767203927635e-25,  1.638038710618122e-27,
  1.226702108344747e+00, -3.257532701225643e-03, -3.257760747632437e-06,  2.200288464047375e-08,  6.012103338023119e-11, -2.448977889513487e-13, -1.207326430142775e-15,
  2.861271196453130e-18,  2.496668540033089e-20, -2.621897933444506e-23, -5.183217381470832e-25, -6.123490943702234e-29,  1.310161939412999e+00, -3.130585339195269e-03,
 -4.536131129228974e-06,  1.760694688253141e-08,  8.046372619382455e-11, -1.171010984559474e-13, -1.471229985116147e-15, -5.057777151789879e-19,  2.590509472534327e-20,
  5.536048684071967e-23, -4.121652434082715e-25, -1.868037593773523e-27,  1.391980917134714e+00, -2.956736406451134e-03, -5.615618152547107e-06,  1.184527558808455e-08,
  9.075560911484233e-11,  3.329503956562379e-14, -1.368021525967995e-15, -3.771969180837229e-18,  1.602134182694360e-20,  1.108701967319065e-22, -4.572792598851848e-26,
 -2.373714429010355e-27,  1.471460482044643e+00, -2.739817178705984e-03, -6.429461654075469e-06,  5.250877183552713e-09,  8.912590917606665e-11,  1.747879244949941e-13,
 -9.134473165798334e-16, -5.718478191286694e-18, -5.737280017684179e-22,  1.075773348588739e-22,  3.459359810907049e-25, -1.105649322871246e-27,  1.547887842897568e+00,
 -2.485444784523604e-03, -6.925681354029020e-06, -1.510533999771985e-09,  7.568731122456006e-11,  2.759756468257248e-13, -2.384905563652139e-16, -5.590261886908892e-18,
 -1.604654248034088e-20,  4.694095311016693e-23,  4.929487028434420e-25,  9.205355904666071e-28,  1.620544178446265e+00, -2.200982030024017e-03, -7.073078567597131e-06,
 -7.717891913899761e-09,  5.272140408974314e-11,  3.142750142372725e-13,  4.465347032107727e-16, -3.487714649402621e-18, -2.288832129849210e-20, -3.317554182424795e-23,
  3.019835766973022e-25,  2.006776495385848e-27,  1.688714283913059e+00, -1.895402526832537e-03, -6.866162382455058e-06, -1.269281673870810e-08,  2.439609728363292e-11,
  2.831584746802277e-13,  9.248269010744136e-16, -3.790067599151066e-19, -1.827820786745432e-20, -8.269858046158245e-23, -5.953161505305147e-26,  1.340141259247069e-27,
  1.751697567363571e+00, -1.579050953292542e-03, -6.328217994610779e-06, -1.590495308732321e-08, -4.004411364844711e-12,  1.951254578113886e-13,  1.057101297739310e-15,
  2.338564597723832e-18, -5.889852640253803e-21, -7.474260817114779e-23, -3.021281837347322e-25, -2.381382291536456e-28,  1.808820199499901e+00, -1.263295154309387e-03,
 -5.511796783263431e-06, -1.706641007523382e-08, -2.722050021611618e-11,  7.861102874522427e-14,  8.397522594813158e-16,  3.541902340154694e-18,  6.436112038378746e-21,
 -2.460100894664203e-23, -2.665507533788735e-25, -1.160057646001483e-27,  1.859448109018653e+00, -9.600759912514719e-04, -4.496108492556463e-06, -1.619521451429390e-08,
 -4.127508417385223e-11, -3.093762954207022e-14,  4.058933036049367e-16,  2.964086691183038e-18,  1.188628928884523e-20,  2.483671919038274e-23, -5.072996840476737e-26,
 -7.850841838022481e-28,  1.903000404688590e+00, -6.813717445181670e-04, -3.381139967810517e-06, -1.363020532309243e-08, -4.450651309809601e-11, -1.031438632924583e-13,
 -3.752187217604240e-17,  1.287901440833100e-18,  9.081431662832369e-21,  3.976757026095434e-23,  1.161103017590836e-25,  1.035476747546165e-28,  1.938962710016668e+00,
 -4.386052601847267e-04, -2.278783434868885e-06, -9.987333849289411e-09, -3.804216268138937e-11, -1.234749366009357e-13, -3.097070110631580e-16, -3.361228099273039e-19,
  2.316315200203884e-21,  2.134973454239200e-23,  1.133071371607436e-25,  4.549313965435895e-28,  1.966899847716845e+00, -2.420321776805066e-04, -1.301763614324523e-06,
 -6.059077938271991e-09, -2.550544405955323e-11, -9.814614454957192e-14, -3.423194306666299e-16, -1.046156344654373e-18, -2.525703495962614e-21, -2.683767050478839e-24,
  1.877484753411689e-26,  1.783099205774546e-28,  1.986467461723211e+00, -1.001545984207020e-04, -5.516045288275444e-07, -2.672176741934222e-09, -1.197350739000052e-11,
 -5.064110344980438e-14, -2.038715931154698e-16, -7.827238620605633e-19, -2.856618321437548e-21, -9.817086988336220e-24, -3.112871458143429e-26, -8.692700810762769e-29,
  1.997424820720337e+00, -1.918759686691837e-05, -1.070693180350758e-07, -5.300518915772446e-10, -2.454112238225853e-12, -1.087620047628166e-14, -4.670203060538495e-17,
 -1.956639393338405e-19, -8.032667155555256e-22, -3.239986454815455e-24, -1.286092772162453e-26, -5.028460870497092e-29,  7.162864773255012e-04, -4.313775092225276e-06,
  1.947813148482571e-08, -7.814683905512670e-11,  2.937731146713180e-13, -1.059536338477018e-15,  3.712402171179296e-18, -1.273140279030676e-20,  4.293670422063216e-23,
 -1.428649241864185e-25,  4.700275071765193e-28, -1.531616340158802e-30,  6.442937715943872e-03, -3.871360656781373e-05,  1.739732775197309e-07, -6.923272740719228e-10,
  2.570465110783908e-12, -9.107996190418290e-15,  3.115349214547997e-17, -1.035090375016875e-19,  3.351652790873100e-22, -1.059259284327824e-24,  3.267337614395406e-27,
 -9.824143642730423e-30,  1.787678745116548e-02, -1.069252206223386e-04,  4.759100119298754e-07, -1.862790988633233e-09,  6.740804533907739e-12, -2.300640856904615e-14,
  7.464614337059670e-17, -2.305290052512162e-19,  6.745966518856643e-22, -1.848639060221125e-24,  4.622470614641135e-27, -9.901981487727972e-30,  3.497875593929772e-02,
 -2.077753819213036e-04,  9.113700577107658e-07, -3.477269899049686e-09,  1.208085296546733e-11, -3.874647585843190e-14,  1.144163040132799e-16, -3.051077294389411e-19,
  6.960527437450108e-22, -1.127808141481475e-24, -2.488237345725153e-28,  1.300371125385692e-29,  5.768978819181729e-02, -3.395115955101334e-04,  1.459949517909904e-06,
 -5.376080282456036e-09,  1.760709405754579e-11, -5.123838033823768e-14,  1.277240807500452e-16, -2.394050425492595e-19,  1.153988540036782e-22,  1.780693608412652e-24,
 -1.172951324854645e-26,  5.062200439859505e-29,  8.593033242496571e-02, -4.998115040350133e-04,  2.095330788266323e-06, -7.362306260063412e-09,  2.219096953416170e-11,
 -5.528364391335881e-14,  9.559328176398436e-17,  1.431089930319403e-20, -1.075207153600033e-21,  6.035071629175294e-24, -2.317537176861843e-26,  6.731013222605144e-29,
  1.195996465318010e-01, -6.857963695745475e-04,  2.786050361596643e-06, -9.214894267585892e-09,  2.469780235287529e-11, -4.665874705413569e-14,  9.393830486750292e-18,
  4.326982144206678e-19, -2.507597420234033e-21,  9.227951810859017e-24, -2.325289845146816e-26,  2.270991917494814e-29,  1.585749349538745e-01, -8.940494672653531e-04,
  3.496465184826057e-06, -1.070420718902408e-08,  2.413854380895917e-11, -2.314766002583953e-14, -1.243114046459319e-16,  9.104308890209920e-19, -3.498560869526969e-21,
  8.337626560728896e-24, -3.121763752773625e-27, -8.885504312168248e-29,  2.027103199280368e-01, -1.120640434889452e-03,  4.187918484118520e-06, -1.160943145781073e-08,
  1.982035330099158e-11,  1.465144643945098e-14, -2.820963467107971e-16,  1.276965281552051e-18, -3.283562128732607e-21,  1.425108328384993e-24,  3.503253380605686e-26,
 -2.106566389371187e-28,  2.518356534108488e-01, -1.361156840437500e-03,  4.820102467293432e-06, -1.173705294426615e-08,  1.148011437245667e-11,  6.291334625620867e-14,
 -4.261658221761022e-16,  1.341550593441285e-18, -1.366029568316259e-21, -1.065295613766640e-23,  7.375667844984376e-26, -2.378282458246353e-28,  3.057551792408471e-01,
 -1.610744441945110e-03,  5.352609566802414e-06, -1.093942089417623e-08, -6.160831351758537e-13,  1.147043709528274e-13, -5.112540879996607e-16,  9.582373242703602e-19,
  2.139558552408968e-21, -2.349219377308400e-23,  8.525318850608180e-26, -8.229573446714995e-29,  3.642460595157207e-01, -1.864157809781090e-03,  5.746655394159504e-06,
 -9.132212134303592e-09, -1.562431033742264e-11,  1.607129810159117e-13, -4.951906253510798e-16,  9.401123502695191e-20,  6.327033153027341e-21, -3.014688371185168e-23,
  4.609564984901539e-26,  2.410904235574128e-28,  4.270567849902643e-01, -2.115823144447612e-03,  5.966944842555786e-06, -6.309406251838435e-09, -3.213997983142084e-11,
  1.905884482267754e-13, -3.513224246402600e-16, -1.122699260444426e-18,  9.617630900262826e-21, -2.402453126640656e-23, -4.407131037521380e-26,  5.689685585527089e-28,
  4.939054968134745e-01, -2.359915228963796e-03,  5.983637384722319e-06, -2.554212039116783e-09, -4.829176055020416e-11,  1.947758712426264e-13, -8.001917161487520e-17,
 -2.396279018992306e-18,  1.023194377588288e-20, -2.795252322886738e-24, -1.510421914957959e-25,  6.440788021704091e-28,  5.644782563969405e-01, -2.590450471350317e-03,
  5.774348346760150e-06,  1.955716949718916e-09, -6.191648109831442e-11,  1.666139004715926e-13,  2.840920470452634e-16, -3.316779202824432e-18,  6.928197934950750e-21,
  2.849895022896791e-23, -2.132145089547735e-25,  2.771680947996674e-28,  6.384273119025528e-01, -2.801397876723604e-03,  5.326099928973056e-06,  6.950425263450083e-09,
 -7.080975155138433e-11,  1.043432293242673e-13,  6.724109153053132e-16, -3.471598675738367e-18, -2.364650193114864e-22,  5.727463285959048e-23, -1.712198707379417e-25,
 -4.635511459952217e-28,  7.153694239636080e-01, -2.986809486180817e-03,  4.637109699458864e-06,  1.207861244547216e-08, -7.303481458409038e-11,  1.258508979152219e-14,
  9.923651769477081e-16, -2.594405610871753e-18, -9.473804602239019e-21,  6.753555470418824e-23, -9.616170175916913e-27, -1.181621159706796e-27,  7.948843299118388e-01,
 -3.140971266606066e-03,  3.718276763596335e-06,  1.692842340500933e-08, -6.725802349372110e-11, -9.717713541234458e-14,  1.147222043993516e-15, -7.072344854867007e-19,
 -1.749814693338731e-20,  4.768036206770216e-23,  2.137236735278101e-25, -1.322418728715827e-27,  8.765134448957715e-01, -3.258574559341169e-03,  2.594199535043759e-06,
  2.105834741285150e-08, -5.306503003579232e-11, -2.075078455011708e-13,  1.062817772824261e-15,  1.802604957188253e-18, -2.056910552536088e-20, -1.190241129421074e-24,
  3.778323890211701e-25, -5.590881274042405e-28,  9.597589194868917e-01, -3.334906921730805e-03,  1.303538192123311e-06,  2.403740409411096e-08, -3.120002019894290e-11,
 -2.975161035448542e-13,  7.150319080761349e-16,  4.225098887821743e-18, -1.612688466559256e-20, -6.142613178341360e-23,  3.590695487038991e-25,  8.389845196700279e-28,
  1.044083195922983e+00, -3.366059457542791e-03, -1.014746381854238e-07,  2.549234553658485e-08, -3.665000450540562e-12, -3.468013376033763e-13,  1.492857042163127e-16,
  5.713953951339166e-18, -4.392608061992513e-21, -1.037505163094393e-22,  1.181787458901575e-25,  1.995198147889603e-27,  1.128909227735762e+00, -3.349145488666527e-03,
 -1.556562166089635e-06,  2.515787804544678e-08,  2.637826525999097e-11, -3.402737275659327e-13, -5.171256611741048e-16,  5.586436054975858e-18,  1.094151112704329e-20,
 -1.012912280788473e-22, -2.424434139337765e-25,  1.949069506676926e-27,  1.213621548170104e+00, -3.282522678154200e-03, -2.988121166719640e-06,  2.292409202562105e-08,
  5.494027097654336e-11, -2.728229717907245e-13, -1.116196173107484e-15,  3.641105356351640e-18,  2.365034348082183e-20, -4.685358960178946e-23, -5.096054009705328e-25,
  4.604658657401046e-28,  1.297568388733792e+00, -3.166007559120126e-03, -4.317206759174617e-06,  1.887370873469275e-08,  7.776795342641117e-11, -1.524851627328057e-13,
 -1.473510261398133e-15,  3.517350153240045e-19,  2.758223658837311e-20,  3.731210282387731e-23, -4.880061766067712e-25, -1.559540097555633e-27,  1.380065056761479e+00,
 -3.001068054072903e-03, -5.464746206316523e-06,  1.330087382038669e-08,  9.108494490817299e-11, -7.432552970870774e-16, -1.465862791876114e-15, -3.195986225571008e-18,
  1.995398839239388e-20,  1.068893782562693e-22, -1.546772998824523e-25, -2.560606199641876e-27,  1.460398775574566e+00, -2.790976329917830e-03, -6.357783687700269e-06,
  6.703612232496899e-09,  9.238947560445998e-11,  1.509453770331290e-13, -1.073221083285994e-15, -5.672306620158584e-18,  3.535012649913061e-21,  1.202885742018224e-22,
  2.858072651621339e-25, -1.629462705888713e-27,  1.537835167671336e+00, -2.540901736845066e-03, -6.936360791486475e-06, -2.557461502419821e-10,  8.113661496331137e-11,
  2.683172205346642e-13, -4.019251344621481e-16, -6.072834499840779e-18, -1.399291083366424e-20,  6.736553445673550e-23,  5.255148647701152e-25,  5.408240114396172e-28,
  1.611626515388685e+00, -2.257922295844623e-03, -7.160422802435385e-06, -6.823517870279324e-09,  5.910573046400684e-11,  3.237361949371129e-13,  3.384628110172766e-16,
 -4.236743921258984e-18, -2.384362056287141e-20, -1.929712698679267e-23,  3.926033165619089e-25,  2.097794946333465e-27,  1.681021860498931e+00, -1.950934007144025e-03,
 -7.015943379716611e-06, -1.225597268456103e-08,  3.028001233934270e-11,  3.051581157008224e-13,  9.055759351347175e-16, -1.011881157513479e-18, -2.128295923037198e-20,
 -8.378486700668997e-23,  8.127813724797695e-27,  1.739477444523196e-27,  1.745278902150804e+00, -1.630440918542193e-03, -6.519328547314449e-06, -1.593640328851651e-08,
  1.569850423020406e-13,  2.212577788958677e-13,  1.119521218108918e-15,  2.104688838381933e-18, -8.799999492623884e-21, -8.696534557861369e-23, -3.070791960616428e-25,
  2.695203061364378e-29,  1.803677522800998e+00, -1.308215993462953e-03, -5.719151348678924e-06, -1.748823115075021e-08, -2.543858953493482e-11,  9.997754074033407e-14,
  9.416605054649865e-16,  3.731528545577186e-18,  5.346018992609792e-21, -3.630968093612300e-23, -3.194620401968479e-25, -1.239313846945802e-27,  1.855534620574338e+00,
 -9.968334997547022e-04, -4.694432100164765e-06, -1.686000759512536e-08, -4.178947424296675e-11, -2.015646587903627e-14,  4.943440033438112e-16,  3.358291017550995e-18,
  1.273499825846434e-20,  2.205442370774293e-23, -8.998376494166209e-26, -1.004617916345553e-27,  1.900219766277903e+00, -7.090873769209489e-04, -3.549043255426477e-06,
 -1.435884861042952e-08, -4.657529920821396e-11, -1.035774598097320e-13,  2.829507926647278e-18,  1.602317416728516e-18,  1.059757026045271e-20,  4.448164523295958e-23,
  1.190053379760339e-25,  2.266505980319397e-29,  1.937171054544641e+00, -4.573254574776764e-04, -2.402366298698333e-06, -1.061617133977931e-08, -4.058670700457263e-11,
 -1.310117238927111e-13, -3.179587268672067e-16, -2.487882298516540e-19,  3.171488062761090e-21,  2.630188259142630e-23,  1.347911897436923e-25,  5.223068565624919e-28,
  1.965910420303881e+00, -2.527442119493106e-04, -1.376987322236732e-06, -6.483324935700220e-09, -2.755294385552694e-11, -1.067225360557073e-13, -3.727567214118489e-16,
 -1.128363525159523e-18, -2.606773501582889e-21, -1.760647426795500e-24,  2.778021425987807e-26,  2.331473103491240e-28,  1.986057809870101e+00, -1.046990346683869e-04,
 -5.848544115389636e-07, -2.872128926922869e-09, -1.303708866118324e-11, -5.580768176958291e-14, -2.271225137653490e-16, -8.800382429327384e-19, -3.233391873648516e-21,
 -1.114136549093719e-23, -3.515052720351205e-26, -9.588884725463024e-29,  1.997346315975152e+00, -2.007027835747282e-05, -1.136729162890566e-07, -5.711206953069491e-10,
 -2.683303982985164e-12, -1.206580834176483e-14, -5.255875296327134e-17, -2.233384901248551e-19, -9.297252830870934e-22, -3.801553984642449e-24, -1.529230413621301e-26,
 -6.056906255240082e-29,  6.993371986250527e-04, -4.161622761968488e-06,  1.856788769780070e-08, -7.361127253138720e-11,  2.734452722983962e-13, -9.745658042996484e-16,
  3.374410478466256e-18, -1.143621758992402e-20,  3.811636095602772e-23, -1.253445800571134e-25,  4.075830154581023e-28, -1.312752091476968e-30,  6.290815214372890e-03,
 -3.735436647532826e-05,  1.659062325554135e-07, -6.526174515801678e-10,  2.395553383859498e-12, -8.393913811763716e-15,  2.839983548306370e-17, -9.336947990841892e-20,
  2.992838372357195e-22, -9.368200724768463e-25,  2.863954958716202e-27, -8.542412007647331e-30,  1.745656209989951e-02, -1.032055553435798e-04,  4.541887624846188e-07,
 -1.758523954415532e-09,  6.298080947646772e-12, -2.128997977058799e-14,  6.848379523436567e-17, -2.099718829096165e-19,  6.112706982592833e-22, -1.672247893146060e-24,
  4.202214777551568e-27, -9.198433481139811e-30,  3.416197662262684e-02, -2.006481023623120e-04,  8.707774835987517e-07, -3.290029348703210e-09,  1.133270422540410e-11,
 -3.610052139001002e-14,  1.061790080020727e-16, -2.834845227148689e-19,  6.554010482722507e-22, -1.127332986742437e-24,  2.488012210919374e-28,  9.736325452510712e-30,
  5.635469907975357e-02, -3.280853389023703e-04,  1.397093551517711e-06, -5.102400637089112e-09,  1.661243965600316e-11, -4.825296911151964e-14,  1.210814542909789e-16,
 -2.347729387411530e-19,  1.715735727242055e-22,  1.353683038878387e-24, -9.677761724056087e-27,  4.282860571768500e-29,  8.396406057772671e-02, -4.833962957065239e-04,
  2.009077363011236e-06, -7.015971408103194e-09,  2.110825223621317e-11, -5.298829014245670e-14,  9.554371339354299e-17, -1.679275786926182e-20, -8.739336126694197e-22,
  5.165474405454979e-24, -2.034941086044090e-26,  6.114576726407438e-29,  1.169003469179004e-01, -6.639436346262875e-04,  2.677811875189062e-06, -8.827178619892355e-09,
  2.376781770804872e-11, -4.629667540337687e-14,  2.043465061216409e-17,  3.575929623772225e-19, -2.191873944206908e-21,  8.319811039895682e-24, -2.210980736013833e-26,
  2.880734401213358e-29,  1.550538762295615e-01, -8.665850182433927e-04,  3.370316219358396e-06, -1.032184777251491e-08,  2.364775652066046e-11, -2.583760345456689e-14,
 -1.003417856878151e-16,  8.032481155768536e-19, -3.201528337029417e-21,  8.141950007588691e-24, -6.487720968737036e-27, -6.490868898762487e-29,  1.982938902048733e-01,
 -1.087688928650613e-03,  4.050516571625067e-06, -1.129031748340806e-08,  2.004851413558137e-11,  8.298377728063853e-15, -2.478028159790287e-16,  1.172965048392322e-18,
 -3.209181885725677e-21,  2.650522562056738e-24,  2.646869955141262e-26, -1.790143296483922e-28,  2.464672602025229e-01, -1.323156184568528e-03,  4.680399680299065e-06,
 -1.154384802078702e-08,  1.263911717743265e-11,  5.313085345459270e-14, -3.892680986644698e-16,  1.292250667768153e-18, -1.698923744449872e-21, -7.908678943538243e-24,
  6.354793875550590e-26, -2.253991691094688e-28,  2.993970118180389e-01, -1.568448655123104e-03,  5.221350942678248e-06, -1.093158294848502e-08,  1.557513338112521e-12,
  1.027632191236022e-13, -4.835874125099626e-16,  1.013822083199143e-18,  1.354246410700535e-21, -2.016558906048587e-23,  8.082585644083884e-26, -1.168186426613508e-28,
  3.568806750318370e-01, -1.818626922528125e-03,  5.635672897046253e-06, -9.357131457430620e-09, -1.252856921761785e-11,  1.488818827365410e-13, -4.898843051107664e-16,
  2.794867689806945e-19,  5.277259108296216e-21, -2.811615581008089e-23,  5.483870924646081e-26,  1.584367851310137e-28,  4.186884720514556e-01, -2.068398892614288e-03,
  5.888270806139802e-06, -6.793619974623431e-09, -2.841489822811800e-11,  1.818134503056520e-13, -3.785814755818034e-16, -8.290659835103909e-19,  8.726818506246221e-21,
 -2.531211808191449e-23, -2.094020120966348e-26,  4.822429852776258e-28,  4.845613618209659e-01, -2.312181572151922e-03,  5.948478984581127e-06, -3.295842562037150e-09,
 -4.442069181476732e-11,  1.920871267824531e-13, -1.425541941472200e-16, -2.071577629145319e-18,  1.002937198627392e-20, -8.272929542228988e-24, -1.229538623690824e-25,
  6.287733763738073e-28,  5.542089692803840e-01, -2.544178395940445e-03,  5.791984047984746e-06,  9.920508188012546e-10, -5.852341016816579e-11,  1.723436139232700e-13,
  1.944687118463522e-16, -3.080281481614475e-18,  7.803909429769616e-21,  2.024942364954613e-23, -1.984565325748572e-25,  3.877607554288474e-28,  6.273074392519772e-01,
 -2.758474552997283e-03,  5.402778912492625e-06,  5.835007938078168e-09, -6.856937844051266e-11,  1.193156360860149e-13,  5.754005498313090e-16, -3.447533327829076e-18,
  1.697797389470951e-21,  5.008020556184414e-23, -1.869921439583461e-25, -2.564395542611643e-28,  7.034972697389118e-01, -2.949152673245702e-03,  4.775054135607573e-06,
  1.091333778433934e-08, -7.255099678875434e-11,  3.549811785898529e-14,  9.158419536419150e-16, -2.858839926007003e-18, -7.061536961209982e-21,  6.615994078326320e-23,
 -5.790601674994840e-26, -1.009043593104679e-27,  7.823811978241838e-01, -3.110430920384203e-03,  3.914901762066112e-06,  1.583823481462598e-08, -6.892815698851429e-11,
 -6.994306824790759e-14,  1.119849454707776e-15, -1.238175981977979e-18, -1.564191444500026e-20,  5.505350560955677e-23,  1.547555749578255e-25, -1.346958846401862e-27,
  8.635222335039935e-01, -3.236824902401140e-03,  2.841673038947797e-06,  2.017750741453657e-08, -5.695640656007484e-11, -1.814688581697857e-13,  1.104089802060792e-15,
  1.146571499750105e-18, -2.034663749761410e-20,  1.334465201875531e-23,  3.468772549204058e-25, -8.383243166611759e-28,  9.464419626845928e-01, -3.323333753174176e-03,
  1.588798606302539e-06,  2.349157274457845e-08, -3.696946177117604e-11, -2.789959618485414e-13,  8.257975427567413e-16,  3.676494624105846e-18, -1.807182322601816e-20,
 -4.643776685704908e-23,  3.875355307133576e-25,  4.531126491631704e-28,  1.030619269816433e+00, -3.365649144547175e-03,  2.038535577580441e-07,  2.537846605114994e-08,
 -1.055233598776198e-11, -3.413178901846839e-13,  3.067545137205202e-16,  5.514711357031000e-18, -8.021829036578575e-21, -9.731815704791953e-23,  2.020186890299781e-25,
  1.800385360573714e-27,  1.115489662227321e+00, -3.360383754291290e-03, -1.252361934145831e-06,  2.552486601224254e-08,  1.946154053397539e-11, -3.507715684477157e-13,
 -3.563641936170957e-16,  5.876521118399848e-18,  7.141792344610866e-21, -1.092031094734802e-22, -1.515883329050503e-25,  2.163346162945820e-27,  1.200445410288446e+00,
 -3.305312771286084e-03, -2.707942476002521e-06,  2.375806534653759e-08,  4.922461734149120e-11, -2.983044469435223e-13, -1.003931214317980e-15,  4.367043454091444e-18,
  2.160299500428622e-20, -6.667744476828678e-23, -4.777681282842103e-25,  9.843103630689265e-28,  1.284836747132646e+00, -3.199618366527989e-03, -4.083363381643215e-06,
  2.009168206355160e-08,  7.436592566681002e-11, -1.876303854162702e-13, -1.451130509802919e-15,  1.251963552271008e-18,  2.855861762288143e-20,  1.653601667413750e-23,
 -5.477185503218463e-25, -1.136991326224546e-27,  1.367974394431605e+00, -3.044122820369206e-03, -5.296398328024220e-06,  1.475617345039936e-08,  9.071141205046371e-11,
 -3.692215266925161e-14, -1.545842333548987e-15, -2.497306711914599e-18,  2.366320552800693e-20,  9.842001442352256e-23, -2.692719568780116e-25, -2.626318578556907e-27,
  1.449133690958696e+00, -2.841491476017245e-03, -6.268376007470378e-06,  8.204541903804473e-09,  9.513802861109777e-11,  1.232990351363704e-13, -1.229796108163701e-15,
 -5.487843061157363e-18,  8.052496492691636e-21,  1.301326175206001e-22,  2.026097781842517e-25, -2.148567359468209e-27,  1.527560591204109e+00, -2.596382425686453e-03,
 -6.931465398711569e-06,  1.084787640503879e-09,  8.639247269415259e-11,  2.565823334487473e-13, -5.778395876576465e-16, -6.477709626271598e-18, -1.118487964505519e-20,
  8.872498274355233e-23,  5.388652984888723e-25,  4.774904374153444e-29,  1.602479764201838e+00, -2.315516635623290e-03, -7.236415885154631e-06, -5.825628928253625e-09,
  6.565162859777031e-11,  3.303490088542775e-13,  2.090702602146078e-16, -5.007643020849075e-18, -2.423333673989573e-20, -1.741813367240926e-24,  4.850855563389202e-25,
  2.086806088519733e-27,  1.673104950171016e+00, -2.007641133248459e-03, -7.159902970969581e-06, -1.172149737093288e-08,  3.659780838915037e-11,  3.264722059590371e-13,
  8.672564034474728e-16, -1.740976212248378e-18, -2.427381013682035e-20, -8.180733751447908e-23,  9.377134394779752e-26,  2.154090770110441e-27,  1.738651618568977e+00,
 -1.683360105685198e-03, -6.710399503934402e-06, -1.589701100128116e-08,  4.855422108591848e-12,  2.487986653721047e-13,  1.174022589020871e-15,  1.770634187678419e-18,
 -1.215068779669218e-20, -9.912735642359086e-23, -2.984438412304076e-25,  3.809634338790217e-28,  1.798351813742203e+00, -1.354815398522641e-03, -5.931382166466211e-06,
 -1.787798839590387e-08, -2.320448264068517e-11,  1.238492190295341e-13,  1.048323607659538e-15,  3.879112944282579e-18,  3.795579408400993e-21, -5.019306784401796e-23,
 -3.749693329925445e-25, -1.274959291545654e-27,  1.851470878219061e+00, -1.035209629945203e-03, -4.900775106621757e-06, -1.753118678442072e-08, -4.206610338853179e-11,
 -7.117067700133418e-15,  5.941953152500713e-16,  3.777728916956720e-18,  1.345286599110029e-20,  1.749914476050058e-23, -1.396154973082954e-25, -1.256558271049560e-27,
  1.897325522713280e+00, -7.381817735142145e-04, -3.725888973266102e-06, -1.512060613888300e-08, -4.864233082067851e-11, -1.029313396547989e-13,  5.268939410243083e-17,
  1.967979921526135e-18,  1.228454997590276e-20,  4.923007714577889e-23,  1.175576523229637e-25, -9.538156371561897e-29,  1.935302492173680e+00, -4.770652055183250e-04,
 -2.533744495393148e-06, -1.128693729641594e-08, -4.328375270799883e-11, -1.387139448369369e-13, -3.233539395588912e-16, -1.310639579739702e-19,  4.221131304110829e-21,
  3.217375960899450e-23,  1.593161715627340e-25,  5.927634133502684e-28,  1.964876908127987e+00, -2.640789699551187e-04, -1.457504345234165e-06, -6.941744630199985e-09,
 -2.977946425257877e-11, -1.160573039881398e-13, -4.055266125074656e-16, -1.212558752430324e-18, -2.647509764991326e-21, -4.250527475210637e-25,  3.950298981692468e-26,
  3.023260627383459e-28,  1.985629432658488e+00, -1.095193650316302e-04, -6.206093350174610e-07, -3.089956335501610e-09, -1.420980966091155e-11, -6.156638741003961e-14,
 -2.532744244516715e-16, -9.902039809156548e-19, -3.660830050690063e-21, -1.263438141112739e-23, -3.956421851589372e-26, -1.046596311340686e-28,  1.997264171634746e+00,
 -2.100782413595710e-05, -1.207921532154878e-07, -6.160548133118413e-10, -2.937758709344177e-12, -1.340575284074527e-14, -5.925019451724460e-17, -2.554028706668743e-19,
 -1.078265648568622e-21, -4.470061597447679e-24, -1.822448299846514e-26, -7.312768654793030e-29,  6.829823024089503e-04, -4.016540077636173e-06,  1.771017392201981e-08,
 -6.938778491744443e-11,  2.547385724120317e-13, -8.972887528648810e-16,  3.070615946778274e-18, -1.028565551111635e-20,  3.388401704424556e-23, -1.101396355440109e-25,
  3.540153398613201e-28, -1.127157508825301e-30,  6.144003552635034e-03, -3.605780318452128e-05,  1.582993738563791e-07, -6.155954600615337e-10,  2.234284769759610e-12,
 -7.742638084796915e-15,  2.591465260915405e-17, -8.431061049667425e-20,  2.675328746210932e-22, -8.294414953441682e-25,  2.513036234011493e-27, -7.435066870997416e-30,
  1.705087562742132e-02, -9.965477310583661e-05,  4.336773233239183e-07, -1.661073713014135e-09,  5.888252438401392e-12, -1.971476336795667e-14,  6.286960834610485e-17,
 -1.913427734397292e-19,  5.539997248890725e-22, -1.512045730028200e-24,  3.813033893730731e-27, -8.492915865420446e-30,  3.337307089121466e-02, -1.938367753931815e-04,
  8.323616859035596e-07, -3.114346363707008e-09,  1.063554590594611e-11, -3.364514347850574e-14,  9.852897821316610e-17, -2.631583236366279e-19,  6.150919847198927e-22,
 -1.109623220812860e-24,  6.177299730200021e-28,  7.131566840222335e-30,  5.506432972227653e-02, -3.171490594669825e-04,  1.337428196489230e-06, -4.844166410759843e-09,
  1.567591074578418e-11, -4.542523505917716e-14,  1.145914911724753e-16, -2.285740134280528e-19,  2.137735324731430e-22,  1.002212141671780e-24, -7.944653085807415e-27,
  3.611675488257128e-29,  8.206209541928050e-02, -4.676547817191865e-04,  1.926877529064840e-06, -6.686593124319623e-09,  2.007136321562876e-11, -5.070387719554686e-14,
  9.470885938072426e-17, -4.193526292060111e-20, -7.019960906001654e-22,  4.403510761111709e-24, -1.779287794709290e-26,  5.509220228496179e-29,  1.142867555381246e-01,
 -6.429384495336033e-04,  2.574136981726583e-06, -8.454271092668443e-09,  2.284755972759503e-11, -4.569374765894615e-14,  2.950911867158536e-17,  2.920770767087442e-19,
 -1.907962677867590e-21,  7.462018936553861e-24, -2.075268803048308e-26,  3.253823665480279e-29,  1.516406857836014e-01, -8.401115450779547e-04,  3.248706774452454e-06,
 -9.947741088332339e-09,  2.310868550190663e-11, -2.798722275900955e-14, -7.924144653305300e-17,  7.054336691791966e-19, -2.913721849067784e-21,  7.831384250921623e-24,
 -8.897949798180829e-27, -4.531834884938333e-29,  1.940070924039695e-01, -1.055821267552227e-03,  3.916961879402578e-06, -1.096852569262570e-08,  2.015760972538929e-11,
  2.733717099957994e-15, -2.163817932845562e-16,  1.071987387338986e-18, -3.096523997329005e-21,  3.560471257296289e-24,  1.923977771530060e-26, -1.500424246754146e-28,
  2.412486494824988e-01, -1.286263576469626e-03,  4.543120314734433e-06, -1.133361662649552e-08,  1.361120792386042e-11,  4.421622599282236e-14, -3.538856129298917e-16,
  1.233801170609868e-18, -1.940230383644257e-21, -5.560516492502552e-24,  5.397972912732769e-26, -2.090112872526712e-28,  2.932059288112459e-01, -1.527201987768191e-03,
  5.090387276193593e-06, -1.089084148668682e-08,  3.499038632148672e-12,  9.150201366115642e-14, -4.546984398257196e-16,  1.046156048397482e-18,  6.851716688349073e-22,
 -1.704282116108160e-23,  7.514746999133259e-26, -1.395160993619825e-28,  3.496956224482649e-01, -1.773993867267814e-03,  5.522280777754132e-06, -9.534403280603481e-09,
 -9.667775211326480e-12,  1.372367297307322e-13, -4.798435372623015e-16,  4.325998422062769e-19,  4.306044282500384e-21, -2.580465335698950e-23,  6.022821706306832e-26,
  8.865631241904877e-29,  4.105085619477266e-01, -2.021626275664084e-03,  5.804137913740864e-06, -7.219669200276582e-09, -2.487120960178880e-11,  1.724796381344246e-13,
 -3.980236172864501e-16, -5.645092536880190e-19,  7.805386768168899e-21, -2.575082864160810e-23, -1.621490377370645e-27,  3.963244590368042e-28,  4.754075440378361e-01,
 -2.264763732476985e-03,  5.904790610453683e-06, -3.976044654252500e-09, -4.061767448195045e-11,  1.880057344520377e-13, -1.961164387232548e-16, -1.756298550656733e-18,
  9.649605281926445e-21, -1.264702722378730e-23, -9.601274526420470e-26,  5.929321607711523e-28,  5.441249807115397e-01, -2.497810560018494e-03,  5.798384899770872e-06,
  8.347601304521652e-11, -5.503670297621300e-11,  1.760047270224881e-13,  1.118158494964405e-16, -2.820389892799672e-18,  8.394341911272004e-21,  1.267718816185664e-23,
 -1.796018530695870e-25,  4.637917886082426e-28,  6.163604028776011e-01, -2.714990706115113e-03,  5.466297436865194e-06,  4.757706017878880e-09, -6.605274998440226e-11,
  1.319746310924393e-13,  4.798908608472657e-16, -3.365819859454252e-18,  3.363846865271653e-21,  4.243114962141526e-23, -1.941115101688400e-25, -7.128261578582292e-29,
  6.917778615469328e-01, -2.910448072239056e-03,  4.899076515193247e-06,  9.759368144943396e-09, -7.162783890374050e-11,  5.649440268590815e-14,  8.329852508406906e-16,
 -3.047231553854817e-18, -4.731667117518578e-21,  6.301133067882539e-23, -9.812317601421786e-26, -8.168435199704854e-28,  7.700032896799827e-01, -3.078370316363944e-03,
  4.098302009984684e-06,  1.472564091439272e-08, -7.006134706610618e-11, -4.353739847885949e-14,  1.078478746958454e-15, -1.705927303682026e-18, -1.356279172278148e-20,
  6.006536139234768e-23,  9.611546631865426e-26, -1.308912143731587e-27,  8.506219119304945e-01, -3.213138756306222e-03,  3.078220233773848e-06,  1.923861922367004e-08,
 -6.031857975840116e-11, -1.546584905648314e-13,  1.127169385230539e-15,  5.057671706504989e-19, -1.962600019216709e-20,  2.641351346460099e-23,  3.049893474721199e-25,
 -1.054684020251494e-27,  9.331758190627633e-01, -3.309506241434397e-03,  1.866967854503193e-06,  2.285653264816238e-08, -4.234319519698663e-11, -2.580083032453471e-13,
  9.204134163874703e-16,  3.074472050549626e-18, -1.946079352297624e-20, -3.065182526449923e-23,  3.989527838669771e-25,  6.781887259963182e-29,  1.017161858926079e+00,
 -3.362803535896027e-03,  5.071582941436361e-07,  2.515546975810586e-08, -1.729272877659561e-11, -3.321350234507947e-13,  4.570579611191919e-16,  5.203667619626328e-18,
 -1.136142649277034e-20, -8.772980709105875e-23,  2.753602715394248e-25,  1.520806832542397e-27,  1.102030036075850e+00, -3.369172698569273e-03, -9.444280947489446e-07,
  2.577971887312907e-08,  1.237402762220492e-11, -3.573276429922104e-13, -1.892203392069141e-16,  6.041175886659088e-18,  3.124644666070763e-21, -1.133241323209162e-22,
 -5.371036697409390e-26,  2.266553226103157e-27,  1.187182656030647e+00, -3.325822996577609e-03, -2.418321133205552e-06,  2.449666433616361e-08,  4.302788319757537e-11,
 -3.208557006198741e-13, -8.723624758580387e-16,  5.016338371020404e-18,  1.887040833416206e-20, -8.477357061537239e-23, -4.234460876372852e-25,  1.476978140698183e-27,
  1.271974494985364e+00, -3.231300942735727e-03, -3.835253996595302e-06,  2.124963752051360e-08,  7.026842156916099e-11, -2.219331933216244e-13, -1.403222447572493e-15,
  2.171046470066669e-18,  2.874882355241667e-20, -6.226679060692247e-24, -5.866313191255941e-25, -6.177462928325627e-28,  1.355714316988618e+00, -3.085761106493388e-03,
 -5.110646910485512e-06,  1.619961052660330e-08,  8.959675876728151e-11, -7.477270364569956e-14, -1.604649284038710e-15, -1.685698528256256e-18,  2.698468749756432e-20,
  8.534959472137821e-23, -3.836941132642127e-25, -2.549925389464006e-27,  1.437668091350348e+00, -2.891218611783198e-03, -6.160712212540297e-06,  9.744822888624245e-09,
  9.729658086229711e-11,  9.197351101178258e-14, -1.379133880179439e-15, -5.153836300846725e-18,  1.285903994238304e-20,  1.362013724269658e-22,  9.734592432575465e-26,
 -2.625999598554427e-27,  1.517064274181201e+00, -2.651758195516121e-03, -6.909987536265617e-06,  2.507304517957299e-09,  9.137055045915407e-11,  2.405003283836926e-13,
 -7.637164695029520e-16, -6.780365999147160e-18, -7.603815051652931e-21,  1.101528167298609e-22,  5.281727626856094e-25, -5.496881933189716e-28,  1.593101498131564e+00,
 -2.373669231991451e-03, -7.299802096542510e-06, -4.722123650331284e-09,  7.229697568632296e-11,  3.335965796644190e-13,  5.801802546777342e-17, -5.780190288782464e-18,
 -2.392491700332240e-20,  1.946692620794515e-23,  5.743306098743027e-25,  1.946250912382699e-27,  1.664958951073642e+00, -2.065472530789808e-03, -7.296828464031655e-06,
 -1.108258416921202e-08,  4.333098044398771e-11,  3.466109269039986e-13,  8.071979319037355e-16, -2.563942598339404e-18, -2.712741399957484e-20, -7.604003205912521e-23,
  1.975451464710220e-25,  2.558763165497934e-27,  1.731809605957039e+00, -1.737804649369303e-03, -6.900528305175725e-06, -1.577796951269540e-08,  1.011693527427359e-11,
  2.775228249100450e-13,  1.217604160476687e-15,  1.322450990376173e-18, -1.592898332777045e-20, -1.106044688056956e-22, -2.721325165351746e-25,  8.312398720153967e-28,
  1.792836282655416e+00, -1.403130713600174e-03, -6.148059387497937e-06, -1.822804007546515e-08, -2.046703930503443e-11,  1.503243165447367e-13,  1.158346271205404e-15,
  3.968655866761799e-18,  1.705149441824703e-21, -6.631080231206740e-23, -4.307107890166714e-25, -1.246199824521382e-27,  1.847250278766295e+00, -1.075268775345741e-03,
 -5.115189780955200e-06, -1.820457149255472e-08, -4.205701624964702e-11,  8.462123135942302e-15,  7.060849799251338e-16,  4.217109360918815e-18,  1.396825511306487e-20,
  1.072792804127630e-23, -2.009942186134268e-25, -1.537756325226873e-27,  1.894312013345334e+00, -7.687280610219103e-04, -3.912073569654294e-06, -1.591526418374753e-08,
 -5.068361214056138e-11, -1.009594622247782e-13,  1.135691535468912e-16,  2.390338767756857e-18,  1.414006104270905e-20,  5.380360062728558e-23,  1.099160502923034e-25,
 -2.606649138445027e-28,  1.933352816730045e+00, -4.978889212421157e-04, -2.673435902978110e-06, -1.200209418342607e-08, -4.613585021298584e-11, -1.465020977786647e-13,
 -3.249494687801700e-16,  2.382651678658653e-20,  5.500570183479856e-21,  3.908891169088934e-23,  1.869550796681680e-25,  6.632109295175426e-28,  1.963796732933759e+00,
 -2.760804883742520e-04, -1.543742452085724e-06, -7.437325749446526e-09, -3.220073629739559e-11, -1.262069383900155e-13, -4.406643104477194e-16, -1.297191493532422e-18,
 -2.630946178136677e-21,  1.445263863943889e-24,  5.464474489434053e-26,  3.891484410788325e-28,  1.985181185029613e+00, -1.146365184585389e-04, -6.590946827602545e-07,
 -3.327503852303387e-09, -1.550423929111663e-11, -6.799135111178944e-14, -2.827107955610467e-16, -1.114942536355646e-18, -4.145286097745703e-21, -1.431148148508257e-23,
 -4.434896113356095e-26, -1.126329111274954e-28,  1.997178159687973e+00, -2.200455195416391e-05, -1.284759406976858e-07, -6.652836389073931e-10, -3.220693866993136e-12,
 -1.491762576499501e-14, -6.690977064648092e-17, -2.926293667240766e-19, -1.253123699825365e-21, -5.267692763542565e-24, -2.176895915292914e-26, -8.849999959374278e-29,
  6.671943274631367e-04, -3.878121349386351e-06,  1.690139590332244e-08, -6.545162563717639e-11,  2.375070353411781e-13, -8.269309941097218e-16,  2.797220493968276e-18,
 -9.262168478978647e-21,  3.016237175538468e-23, -9.692264709066801e-26,  3.079819831889973e-28, -9.694806279885165e-31,  6.002259187344577e-03, -3.482036060347215e-05,
  1.511217168439468e-07, -5.810527187109940e-10,  2.085465193274995e-12, -7.148074300869496e-15,  2.366945600413193e-17, -7.620853839038661e-20,  2.394062018086498e-22,
 -7.351709785966337e-25,  2.207460454270497e-27, -6.477637867801655e-30,  1.665907135280961e-02, -9.626351389551515e-05,  4.142969599274054e-07, -1.569935840345440e-09,
  5.508622055122909e-12, -1.826822993865354e-14,  5.775222507130977e-17, -1.744570026166207e-19,  5.022232705564141e-22, -1.366793446065809e-24,  3.454607602263176e-27,
 -7.802853434636234e-30,  3.261080890395403e-02, -1.873245279810821e-04,  7.959887455877804e-07, -2.949434836103568e-09,  9.985704486945952e-12, -3.136668175105577e-14,
  9.143013844076872e-17, -2.441091796611263e-19,  5.756600152484848e-22, -1.079281573726189e-24,  8.843214343238134e-28,  5.066211918760174e-30,  5.381677010863259e-02,
 -3.066779581213458e-04,  1.280773584459728e-06, -4.600472610843622e-09,  1.479439372534382e-11, -4.275103591467307e-14,  1.082921935151978e-16, -2.212143171597531e-19,
  2.444998620882492e-22,  7.144491515750229e-25, -6.485412177377145e-27,  3.035985312298464e-29,  8.022180575859235e-02, -4.525553348155215e-04,  1.848532196736218e-06,
 -6.373440875932380e-09,  1.907990817395915e-11, -4.844735155372872e-14,  9.324305720159093e-17, -6.199543907997032e-20, -5.557121587344306e-22,  3.738547761989186e-24,
 -1.549751808751626e-26,  4.929326599795716e-29,  1.117555540893186e-01, -6.227450133471765e-04,  2.474849068427004e-06, -8.095979997189117e-09,  2.194139477037466e-11,
 -4.489404754725534e-14,  3.687176819191676e-17,  2.351630264776251e-19, -1.653920503573521e-21,  6.661223855926861e-24, -1.927317376678554e-26,  3.445276498960474e-29,
  1.483314717002010e-01, -8.145931400714473e-04,  3.131533526818417e-06, -9.582576877304781e-09,  2.253146966769404e-11, -2.966226982492003e-14, -6.075277859126898e-17,
  6.166331536116192e-19, -2.638633953826512e-21,  7.440492979555564e-24, -1.053159407859317e-26, -2.951754976715070e-29,  1.898456528596305e-01, -1.025006576508490e-03,
  3.787275619284304e-06, -1.064583869870303e-08,  2.016272635747149e-11, -2.110331772572752e-15, -1.877331334105387e-16,  9.750855445318990e-19, -2.956013305253804e-21,
  4.205905155633966e-24,  1.322152118011440e-26, -1.240109946714566e-28,  2.361754290583994e-01, -1.250458861032929e-03,  4.408451310858403e-06, -1.110921255305664e-08,
  1.441336116658554e-11,  3.613034209705919e-14, -3.202356284536344e-16,  1.168909995999999e-18, -2.103711088096545e-21, -3.579867207050708e-24,  4.518928997711045e-26,
 -1.902823831984915e-28,  2.871777408748480e-01, -1.487000562931037e-03,  4.960091584049320e-06, -1.082079947623108e-08,  5.222334435088042e-12,  8.094269064468004e-14,
 -4.251872841293225e-16,  1.058832728669620e-18,  1.242151278669685e-22, -1.416415186614461e-23,  6.869172920572668e-26, -1.524900015181453e-28,  3.426872754144904e-01,
 -1.730275697481967e-03,  5.407028393252613e-06, -9.667751135544076e-09, -7.037145039247243e-12,  1.258805674658937e-13, -4.659379347950878e-16,  5.560012923905094e-19,
  3.421218159019282e-21, -2.333523727406080e-23,  6.282597138937847e-26,  3.144208881992081e-29,  4.025143651476577e-01, -1.975546222672445e-03,  5.715226389039616e-06,
 -7.590535711909225e-09, -2.151828058104075e-11,  1.627647642831148e-13, -4.104723255282648e-16, -3.295492337994420e-19,  6.881168769606616e-21, -2.549137594269318e-23,
  1.399857626107855e-26,  3.145931321635001e-28,  4.664426483556871e-01, -2.217727021717480e-03,  5.853301989055391e-06, -4.596118362122853e-09, -3.690843256918119e-11,
  1.827432706399243e-13, -2.410432136701857e-16, -1.455486877338580e-18,  9.131344788951793e-21, -1.597975231227665e-23, -7.099218250130053e-26,  5.423973574665878e-28,
  5.342264981936919e-01, -2.451434175611489e-03,  5.794219651833139e-06, -7.688309694705719e-10, -5.149601079053698e-11,  1.777713834755791e-13,  3.666455727778196e-17,
 -2.545814545077617e-18,  8.726468411782792e-21,  5.916531158482423e-24, -1.581065556047417e-25,  5.084041167682072e-28,  6.055882373029375e-01, -2.671049718570386e-03,
  5.517137888410240e-06,  3.722571930567967e-09, -6.330564857786019e-11,  1.423746177065837e-13,  3.873738406796812e-16, -3.235238143343749e-18,  4.751298500351850e-21,
  3.465258840690407e-23, -1.936644116234790e-25,  8.686441577776633e-29,  6.802151688110359e-01, -2.870806400435373e-03,  5.009353385285696e-06,  8.623418748776227e-09,
 -7.030502514600581e-11,  7.544713644567789e-14,  7.458782071016131e-16, -3.163174687237226e-18, -2.542037022038192e-21,  5.842612803028370e-23, -1.296838877168710e-25,
 -6.175110632593236e-28,  7.577564734159969e-01, -3.044896183330674e-03,  4.268259586007986e-06,  1.359908261692188e-08, -7.067737407470563e-11, -1.827412140337240e-14,
  1.024966369654121e-15, -2.104708304274728e-18, -1.134490955042390e-20,  6.278142619359666e-23,  4.035094211438883e-26, -1.218045604694151e-27,  8.378200471038529e-01,
 -3.187606172879756e-03,  3.303195777469410e-06,  1.825024996809841e-08, -6.314044458039537e-11, -1.275064946718728e-13,  1.132697613842465e-15, -1.047899087696228e-19,
 -1.846715650850126e-20,  3.763638884419990e-23,  2.550774764909749e-25, -1.202537904834753e-27,  9.199693859123371e-01, -3.293485286615105e-03,  2.137014978787496e-06,
  2.213898840654259e-08, -4.727585674821006e-11, -2.349566383377417e-13,  9.976362704413527e-16,  2.437150386414381e-18, -2.027729151902500e-20, -1.474316351915102e-23,
  3.938347261769569e-25, -2.951200854809115e-28,  1.003720663830070e+00, -3.357544011346940e-03,  8.071466842742062e-07,  2.482628926069453e-08, -2.381415783578222e-11,
 -3.194611220893100e-13,  5.972118274206597e-16,  4.791820515078945e-18, -1.430619405607891e-20, -7.547461189534662e-23,  3.348846929788768e-25,  1.175896612910376e-27,
  1.088540197724563e+00, -3.375487875540746e-03, -6.341200396039188e-07,  2.592034181577131e-08,  5.195805626439737e-12, -3.598315769192648e-13, -1.928270785747629e-17,
  6.075670666575640e-18, -9.696060556665607e-22, -1.134736147431911e-22,  4.613195366399148e-26,  2.252266263025545e-27,  1.173842548523393e+00, -3.343982517020258e-03,
 -2.120445800646959e-06,  2.513268494049663e-08,  3.641311951521571e-11, -3.400416084378520e-13, -7.239323838899344e-16,  5.568227970657762e-18,  1.553055120810839e-20,
 -1.002797573402650e-22, -3.487361076422065e-25,  1.905867432876575e-27,  1.258989568646405e+00, -3.260944228213198e-03, -3.573664920031168e-06,  2.233661568701152e-08,
  6.549844403440191e-11, -2.547774748740853e-13, -1.329619919040727e-15,  3.082850356766115e-18,  2.809727342274850e-20, -3.006607008626338e-23, -6.010407640789238e-25,
 -2.825017021173166e-29,  1.343290767620575e+00, -3.125844457475128e-03, -4.907706462892797e-06,  1.761908831457245e-08,  8.771288163635107e-11, -1.137503767491647e-13,
 -1.639320165152673e-15, -7.762055707400378e-19,  2.975446851774560e-20,  6.781445877720274e-23, -4.913802343408437e-25, -2.318894699014034e-27,  1.426005423645546e+00,
 -2.940009965439148e-03, -6.034379120978956e-06,  1.131443738387954e-08,  9.879362966535278e-11,  5.719365891326445e-14, -1.516939313171374e-15, -4.663377062267382e-18,
  1.780339368436448e-20,  1.376606412875510e-22, -2.726527402658536e-26, -3.021145949916425e-27,  1.506346907713410e+00, -2.706892533631675e-03, -6.870972982384106e-06,
  4.006652496156466e-09,  9.598176117922187e-11,  2.198692432633689e-13, -9.563483397925972e-16, -6.956221466985004e-18, -3.265628318001941e-21,  1.306005217819417e-22,
  4.892429007780067e-25, -1.231505141143165e-27,  1.583489693919500e+00, -2.432274138642773e-03, -7.349306805949723e-06, -3.511977505087954e-09,  7.896927836363049e-11,
  3.329611659772294e-13, -1.144077497281709e-16, -6.529977603296951e-18, -2.279061218309454e-20,  4.407801259472254e-23,  6.540790132684071e-25,  1.651486673998805e-27,
  1.656579486760825e+00, -2.124366802956774e-03, -7.425427598134931e-06, -1.033280435304866e-08,  5.045059398979457e-11,  3.650216305332848e-13,  7.228551104671597e-16,
 -3.474066928728853e-18, -2.969447323520001e-20, -6.577568768620313e-23,  3.183097678340083e-25,  2.920265978725899e-27,  1.724746784235120e+00, -1.793763034332558e-03,
 -7.088704373516625e-06, -1.557009563487845e-08,  1.596230252915470e-11,  3.071283167710411e-13,  1.246883493034222e-15,  7.469951308665901e-19, -2.009647200542910e-20,
 -1.206038942306271e-22, -2.238436258465685e-25,  1.379677537751912e-27,  1.787123997974267e+00, -1.453195463164077e-03, -6.368656493837561e-06, -1.852991246706325e-08,
 -1.717352689330931e-11,  1.794619339740004e-13,  1.269849348027265e-15,  3.981594784903217e-18, -1.005129907735573e-21, -8.460858509389069e-23, -4.833235073906992e-25,
 -1.128384705783762e-27,  1.842865960955830e+00, -1.117075533486044e-03, -5.337673433029784e-06, -1.887516801843475e-08, -4.170848664753034e-11,  2.687591861419824e-14,
  8.304680248919329e-16,  4.668583549646810e-18,  1.419263947720080e-20,  1.246935230353148e-24, -2.752652593381916e-25, -1.840965169997390e-27,  1.891173278700579e+00,
 -8.008025205818978e-04, -4.107988455711170e-06, -1.674218369864202e-08, -5.266985154721032e-11, -9.737769881311264e-14,  1.871304738433326e-16,  2.874634133465981e-18,
  1.615281637433098e-20,  5.790959046692796e-23,  9.375288989892598e-26, -4.847433216282438e-28,  1.931317555898249e+00, -5.198652833715245e-04, -2.821988137252166e-06,
 -1.276413125474235e-08, -4.914371749769108e-11, -1.542716359678009e-13, -3.215958951738569e-16,  2.238615460494170e-19,  7.049593121459101e-21,  4.717060690709170e-23,
  2.176081865329041e-25,  7.287955721104278e-28,  1.962667133241492e+00, -2.887963738570415e-04, -1.636166823861934e-06, -7.973317786259390e-09, -3.483362543543017e-11,
 -1.372281876645424e-13, -4.781533040767982e-16, -1.380092175176519e-18, -2.535174016004969e-21,  4.003692536003843e-24,  7.406548250780246e-26,  4.975220148522102e-28,
  1.984711834457597e+00, -1.200733190544117e-04, -7.005592340865984e-07, -3.586829842164015e-09, -1.693452512657715e-11, -7.516650879210311e-14, -3.158662262082878e-16,
 -1.256187295421039e-18, -4.693643583353998e-21, -1.618656382850428e-23, -4.945094616575087e-26, -1.188989349185889e-28,  1.997088034036176e+00, -2.306519237896544e-05,
 -1.367786670488256e-07, -7.192916809019510e-10, -3.535792595100341e-12, -1.662649645024820e-14, -7.569454488270475e-17, -3.359394995424514e-19, -1.459420267083899e-21,
 -6.221603312550350e-24, -2.606384689991141e-26, -1.073617330681126e-28,  6.519473796513553e-04, -3.745988491943740e-06,  1.613824287578002e-08, -6.178026070932217e-11,
  2.216192920756784e-13, -7.628038647763473e-16,  2.550884454076834e-18, -8.350503354964236e-21,  2.688499990767264e-23, -8.541544139961218e-26,  2.683553257130973e-28,
 -8.352768005122564e-31,  5.865352319135745e-03, -3.363872082077118e-05,  1.443446691831977e-07, -5.487988127738880e-10,  1.948015908158127e-12, -6.604771591814637e-15,
  2.163901050731352e-17, -6.895449902526124e-20,  2.144630446197404e-22, -6.523203212829379e-25,  1.941104486109243e-27, -5.649150183923018e-30,  1.628052881277029e-02,
 -9.302302407778098e-05,  3.959747400136157e-07, -1.484647124083216e-09,  5.156731517922043e-12, -1.693902257840151e-14,  5.308521424751490e-17, -1.591471211017105e-19,
  4.554250836304732e-22, -1.235278273775655e-24,  3.125979691996956e-27, -7.139994499264621e-30,  3.187402622752512e-02, -1.810955216910396e-04,  7.615338331156200e-07,
 -2.794565295418624e-09,  9.379771052040463e-12, -2.925233317315112e-14,  8.484718707073272e-17, -2.263024933388821e-19,  5.374916366256586e-22, -1.039958197913178e-24,
  1.070003247379685e-27,  3.438695609612893e-30,  5.261020661409727e-02, -2.966486321304082e-04,  1.226960410954453e-06, -4.370463353730959e-09,  1.396486608316926e-11,
 -4.022544513095789e-14,  1.022112528986315e-16, -2.130263445497472e-19,  2.658586642460173e-22,  4.802443185276230e-25, -5.260649999352261e-27,  2.543998683130878e-29,
  7.844068378355908e-02, -4.380678855217440e-04,  1.773850994320116e-06, -6.075792957248584e-09,  1.813318899828177e-11, -4.623223791874674e-14,  9.127762998549840e-17,
 -7.774032132177283e-20, -4.317748560013725e-22,  3.160392907324058e-24, -1.344994186446217e-26,  4.384092964413946e-29,  1.093035646624794e-01, -6.033289276961352e-04,
  2.379774213897791e-06, -7.752050513744362e-09,  2.105286640620909e-11, -4.393587457715483e-14,  4.275038355302897e-17,  1.859286280517057e-19, -1.427625385484468e-21,
  5.920862352857107e-24, -1.774095348863507e-26,  3.500056174863489e-29,  1.451224839925292e-01, -7.899947525601505e-04,  3.018685807294527e-06, -9.226892845587652e-09,
  2.192499385702898e-11, -3.092244453658235e-14, -4.462948354842061e-17,  5.363989852157847e-19, -2.378635937906131e-21,  6.997166354096654e-24, -1.154337636866938e-26,
 -1.696576256658118e-29,  1.858054216160736e-01, -9.952138923030522e-04,  3.661459015731428e-06, -1.032380844173959e-08,  2.007762062819035e-11, -6.298843877528678e-15,
 -1.617316017866398e-16,  8.830075401001345e-19, -2.796332184370090e-21,  4.632628284838664e-24,  8.282236466881279e-27, -1.009983806421340e-28,  2.312432901388725e-01,
 -1.215720520054601e-03,  4.276546966317347e-06, -1.087322451715685e-08,  1.506172277023267e-11,  2.882972674631059e-14, -2.884655913109759e-16,  1.099862067930413e-18,
 -2.202015166279989e-21, -1.933956633044396e-24,  3.725059454263910e-26, -1.704775100150390e-28,  2.813082798708175e-01, -1.447837688677775e-03,  4.830794988174066e-06,
 -1.072483565666689e-08,  6.741545122391123e-12,  7.109396025995545e-14, -3.955572716197947e-16,  1.055166105810424e-18, -3.378727368662032e-22, -1.155270804730395e-23,
  6.184271930375133e-26, -1.577001072801700e-28,  3.358519478748298e-01, -1.687485249075717e-03,  5.290420941732153e-06, -9.760806642511532e-09, -4.630037078211378e-12,
  1.148964857579419e-13, -4.489600138379143e-16,  6.525260337224395e-19,  2.626587002422676e-21, -2.080872487631656e-23,  6.316878419145786e-26, -1.400347174098783e-29,
  3.947030390572419e-01, -1.930194366335493e-03,  5.622179888952048e-06, -7.909323795296706e-09, -1.836212105798880e-11,  1.528267387978282e-13, -4.167539792228378e-16,
 -1.239010880946723e-19,  5.976686866151800e-21, -2.467725488499491e-23,  2.615976894824859e-26,  2.394163905745352e-28,  4.576650299863724e-01, -2.171130982918829e-03,
  5.794724915130052e-06, -5.157741949455008e-09, -3.331455024865958e-11,  1.765016588561415e-13, -2.777961281977715e-16, -1.172990574558919e-18,  8.510555940729415e-21,
 -1.835925979639340e-23, -4.842047162655862e-26,  4.824309954213364e-28,  5.245133911565547e-01, -2.405131058793180e-03,  5.780167482297343e-06, -1.564299576525072e-09,
 -4.793739377468430e-11,  1.778276483337359e-13, -3.068521836427572e-17, -2.264336010692296e-18,  8.831084311864426e-21,  4.659086222803561e-26, -1.352647879061472e-25,
  5.257336000825558e-28,  5.949925715302361e-01, -2.626750931607205e-03,  5.555826929448607e-06,  2.732936151515834e-09, -6.037243053233006e-11,  1.506028300233444e-13,
  2.990926902469300e-16, -3.064721876555400e-18,  5.860642668189955e-21,  2.702246964535446e-23, -1.869055596635938e-25,  2.153645546522053e-28,  6.688127214051274e-01,
 -2.830336651371349e-03,  5.106137990931582e-06,  7.511552259183834e-09, -6.862428512037756e-11,  9.227810115687939e-14,  6.564792570336224e-16, -3.211917235826154e-18,
 -5.380863185772916e-22,  5.275353367955732e-23, -1.525201911397131e-25, -4.219117837044776e-28,  7.456461872004100e-01, -3.010116594118277e-03,  4.424655761571869e-06,
  1.246663658040451e-08, -7.080184117187419e-11,  5.578963226740729e-15,  9.612934148372135e-16, -2.431374508107784e-18, -9.068315906371296e-21,  6.335988670475484e-23,
 -1.046442973138633e-26, -1.085957324678807e-27,  8.251238360743937e-01, -3.160321953085890e-03,  3.516057919053557e-06,  1.722107667105755e-08, -6.541930426359320e-11,
 -1.004224188429218e-13,  1.121707329582520e-15, -6.721964316927588e-19, -1.694160710928668e-20,  4.675315793001782e-23,  2.001887008099196e-25, -1.281171030586354e-27,
  9.068313009546549e-01, -3.275339702946629e-03,  2.397993560260489e-06,  2.134630443142696e-08, -5.173040998255780e-11, -2.102681904577472e-13,  1.056733964898271e-15,
  1.782794052944893e-18, -2.052851479642231e-20,  6.522331288575077e-25,  3.735885032509205e-25, -6.170787717112182e-28,  9.903052791514227e-01, -3.349902133737900e-03,
  1.102567796868555e-06,  2.439497237621256e-08, -3.004945925356435e-11, -3.035721335087872e-13,  7.245841439540084e-16,  4.293228802143935e-18, -1.677070676685060e-20,
 -6.115615480168614e-23,  3.782154475094839e-25,  7.887353735150280e-28,  1.075030071521975e+00, -3.379315793011913e-03, -3.228145529821246e-07,  2.594593423796537e-08,
 -1.991708216487574e-12, -3.582601997422511e-13,  1.497912220404776e-16,  5.979830807629208e-18, -4.997817242555836e-21, -1.096764008333529e-22,  1.427823417664653e-25,
  2.122489316886346e-27,  1.160434614700351e+00, -3.359730332909053e-03, -1.815585260061617e-06,  2.565999816381607e-08,  2.945144805810411e-11, -3.554923303567819e-13,
 -5.616252400079272e-16,  6.004922770299885e-18,  1.169058282801688e-20, -1.124455121839589e-22, -2.571012464464216e-25,  2.241937783536679e-27,  1.245890335304449e+00,
 -3.288443972816913e-03, -3.299511366047559e-06,  2.334212373340329e-08,  6.009129789502442e-11, -2.855520813394254e-13, -1.230908289930353e-15,  3.960013492751941e-18,
  2.658350761553178e-20, -5.394973659007936e-23, -5.885805742804130e-25,  5.974814191507427e-28,  1.330710238974240e+00, -3.164236721852987e-03, -4.687938981688454e-06,
  1.900215126072748e-08,  8.504324194187898e-11, -1.532451583048956e-13, -1.647385079956924e-15,  2.110114623155368e-19,  3.181832243828564e-20,  4.622149476711082e-23,
 -5.854449922020237e-25, -1.931468736606276e-27,  1.414149731650013e+00, -2.987714959677935e-03, -5.889090462049177e-06,  1.290226517647271e-08,  9.956321296227098e-11,
  1.928916285097577e-14, -1.638795965545965e-15, -4.014852029403520e-18,  2.270666973968272e-20,  1.338211275590122e-22, -1.666941572871212e-25, -3.292906429421472e-27,
  1.495409743803762e+00, -2.761641565362269e-03, -6.813538010604460e-06,  5.576226296973205e-09,  1.001338036222865e-10,  1.945722606552554e-13, -1.151852480772221e-15,
 -6.981837437775587e-18,  1.773246120793681e-21,  1.488728495178023e-22,  4.190197316620158e-25, -1.965881369975770e-27,  1.573642772535597e+00, -2.491215183549774e-03,
 -7.383650387559022e-06, -2.195408079895322e-09,  8.558581481339008e-11,  3.279405467857508e-13, -3.071819780470197e-16, -7.228703844098933e-18, -2.071646600470987e-20,
  7.156989959203995e-23,  7.171129084632756e-25,  1.184197302309633e-27,  1.647962447526333e+00, -2.184251915004467e-03, -7.544334120809494e-06, -9.466283817291274e-09,
  5.791606876854217e-11,  3.810933977002296e-13,  6.119411370006260e-16, -4.459462705474096e-18, -3.180142262905579e-20, -5.038416515795617e-23,  4.532928309436830e-25,
  3.197747611895687e-27,  1.717457136258898e+00, -1.851215214736423e-03, -7.273805152397158e-06, -1.526392657561535e-08,  2.240542228606887e-11,  3.372277717126455e-13,
  1.258131849185379e-15,  3.284163600543824e-20, -2.458310146755981e-20, -1.281612760663806e-22, -1.493587825166946e-25,  2.020147064755102e-27,  1.781207903123150e+00,
 -1.505038538384417e-03, -6.592540189973515e-06, -1.877428130234953e-08, -1.327052533361453e-11,  2.112695494600635e-13,  1.380398653985125e-15,  3.896871103902394e-18,
 -4.410470846834696e-21, -1.048748950666633e-22, -5.282858507242828e-25, -8.936559904724535e-28,  1.838310805581125e+00, -1.160694225612009e-03, -5.568158094304472e-06,
 -1.953707535952724e-08, -4.096080248335357e-11,  4.842707734683140e-14,  9.675373199222450e-16,  5.121177266911025e-18,  1.401898069534713e-20, -1.147557765279655e-23,
 -3.631378405831728e-25, -2.153342013190300e-27,  1.887903047978799e+00, -8.344845255332544e-04, -4.314014367326523e-06, -1.760020929480025e-08, -5.456566441075740e-11,
 -9.186033072692952e-14,  2.751749932667113e-16,  3.425557470133346e-18,  1.829919236100296e-20,  6.115175988252025e-23,  6.620391457699484e-26, -7.803810005808700e-28,
  1.929191953696827e+00, -5.430674710658611e-04, -2.979978679917475e-06, -1.357553094703053e-08, -5.230568688889247e-11, -1.618875979267855e-13, -3.119019212935440e-16,
  4.783624873979431e-19,  8.912297037117579e-21,  5.653319753044069e-23,  2.509119567311008e-25,  7.822618572102566e-28,  1.961485149448430e+00, -3.022781151514479e-04,
 -1.735283291954106e-06, -8.553249116651959e-09, -3.769612276495573e-11, -1.491765904003442e-13, -5.179056395933250e-16, -1.458294805455511e-18, -2.332100167965454e-21,
  7.441649578702964e-24,  9.881118848491522e-26,  6.319962097204133e-28,  1.984220052977629e+00, -1.258546839401118e-04, -7.452778841457892e-07, -3.870233046439187e-09,
 -1.851660227966585e-11, -8.318690170113775e-14, -3.532326059284482e-16, -1.416099423393968e-18, -5.313236989634917e-21, -1.827045868616720e-23, -5.476749801045244e-26,
 -1.221228551430650e-28,  1.996993528749928e+00, -2.419493538145689e-05, -1.457609055031388e-07, -7.786266033530938e-10, -3.887279304481479e-12, -1.856153284798470e-14,
 -8.578983240419651e-17, -3.864354258997171e-19, -1.703360828602718e-21, -7.365116114843651e-24, -3.128063900441508e-26, -1.305610923244025e-28,  6.372170258696783e-04,
 -3.619788859242583e-06,  1.541766231061174e-08, -5.835315208458243e-11,  2.069569787416282e-13, -7.042939597777292e-16,  2.328666936098626e-18, -7.537380715208971e-21,
  2.399472368801518e-23, -7.538126882027384e-26,  2.341863756448737e-28, -7.208472774265222e-31,  5.733065976878992e-03, -3.250978580912220e-05,  1.379418234503702e-07,
 -5.186597471957919e-10,  1.820961367759382e-12, -6.107849727757807e-15,  1.980093770869139e-17, -6.245290572787074e-20,  1.923192094698030e-22, -5.794287059164533e-25,
  1.708700465707465e-27, -4.931626520156603e-30,  1.591466142591455e-02, -8.992511189363496e-05,  3.786430611578375e-07, -1.404781926259964e-09,  4.830338911813604e-12,
 -1.571684429455674e-14,  4.882660851842092e-17, -1.452615093656861e-19,  4.131317714077278e-22, -1.116334694979325e-24,  2.825774686437005e-27, -6.511856290500722e-30,
  3.116161983923138e-02, -1.751348826178451e-04,  7.288805536428506e-07, -2.649060811034489e-09,  8.814584358364746e-12, -2.729012904242168e-14,  7.874594574383738e-17,
 -2.096932447938413e-19,  5.008563420964623e-22, -9.945299577961011e-25,  1.192143711439302e-27,  2.165522005351803e-30,  5.144291657991142e-02, -2.870389929269175e-04,
  1.175829355301024e-06, -4.153330294671774e-09,  1.318440976853486e-11, -3.784297599259508e-14,  9.636794176667074e-17, -2.042807470753131e-19,  2.796177865433678e-22,
  2.909225800863717e-25, -4.235947899286210e-27,  2.124928906215287e-29,  7.671633896858114e-02, -4.241638529052048e-04,  1.702652135169716e-06, -5.792940832180368e-09,
  1.723026691993068e-11, -4.406915533818684e-14,  8.892385101835142e-17, -8.983688221553328e-20, -3.272336488947813e-22,  2.659457947908040e-24, -1.163360816673502e-26,
  3.878839524566476e-29,  1.069277441799979e-01, -5.846571724418791e-04,  2.288741870426460e-06, -7.422176965037462e-09,  2.018480483155615e-11, -4.285236351678969e-14,
  4.734789364432529e-17,  1.435210814955077e-19, -1.226877222845692e-21,  5.241952614814895e-24, -1.620788751324298e-26,  3.454462868702306e-29,  1.420101110681320e-01,
 -7.662822407155359e-04,  2.910047308816156e-06, -8.881093777124539e-09,  2.129700696717810e-11, -3.182169369525136e-14, -3.063871507739900e-17,  4.642226153082745e-19,
 -2.135200810239701e-21,  6.523570186863745e-24, -1.206508708395749e-26, -7.162933718301329e-30,  1.818823724771789e-01, -9.664123127730236e-04,  3.539495948154828e-06,
 -1.000377699840980e-08,  1.991477923103128e-11, -9.893667146765907e-15, -1.382346683655426e-16,  7.962489205820042e-19, -2.624609307950296e-21,  4.881151933853799e-24,
  4.289977413257919e-27, -8.094582397629292e-29,  2.264480122835123e-01, -1.182025920883588e-03,  4.147532034901561e-06, -1.062799002897796e-08,  1.557153866245815e-11,
  2.226808931637548e-14, -2.586644557513490e-16,  1.028556878492144e-18, -2.246571338962919e-21, -5.880707042344277e-25,  3.018889065716845e-26, -1.505541336679770e-28,
  2.755934094754722e-01, -1.409704182422206e-03,  4.702789427189329e-06, -1.060610168930509e-08,  8.070875815310182e-12,  6.195353224819164e-14, -3.662231857766087e-16,
  1.038163655456108e-18, -7.109177613256474e-22, -9.217922651142926e-24,  5.490249174156403e-26, -1.569088385204032e-28,  3.291859102398553e-01, -1.645631488760212e-03,
  5.172920731101858e-06, -9.817082867670264e-09, -2.438331625583048e-12,  1.043495171230778e-13, -4.296217242227553e-16,  7.250767791290074e-19,  1.922704725886485e-21,
 -1.830526765538254e-23,  6.175083146191444e-26, -4.879469652162530e-29,  3.870716086122721e-01, -1.885601340501389e-03,  5.525604342756009e-06, -8.179209702362531e-09,
 -1.540578000785905e-11,  1.428038110740522e-13, -4.176776541673078e-16,  5.336011994004733e-20,  5.109492863483691e-21, -2.344055573128462e-23,  3.518613744675641e-26,
  1.722815365528040e-28,  4.490728172228435e-01, -2.125029550893216e-03,  5.729749103400392e-06, -5.662907355319537e-09, -2.985369207659804e-11,  1.694705780571124e-13,
 -3.069289256415952e-16, -9.115611290103415e-19,  7.819704128387373e-21, -1.989041498878085e-23, -2.861021775713681e-26,  4.175569350941854e-28,  5.149852126622831e-01,
 -2.358977574352211e-03,  5.756911076692641e-06, -2.302906449012980e-09, -4.439317586496555e-11,  1.763622847309571e-13, -9.013723149014405e-17, -1.982713449172783e-18,
  8.740947795132978e-21, -4.901434182642853e-24, -1.121755538325728e-25,  5.204434936302328e-28,  5.845746458596379e-01, -2.582189325230497e-03,  5.582926992393419e-06,
  1.791434948797044e-09, -5.729542932364118e-11,  1.567733479050859e-13,  2.160421207089158e-16, -2.863038840585543e-18,  6.701450415312217e-21,  1.976687604946283e-23,
 -1.751582082441912e-25,  3.136782715885999e-28,  6.575736177254892e-01, -2.789145513068476e-03,  5.189752279600916e-06,  6.429153651989226e-09, -6.662845546915305e-11,
  1.069541652733580e-13,  5.665814251813098e-16, -3.199960414451502e-18,  1.247255530005922e-21,  4.633648520041398e-23, -1.669982749907832e-25, -2.388643231324549e-28,
  7.336774356138914e-01, -2.974140191063759e-03,  4.567466101797068e-06,  1.133592957269501e-08, -7.046522638805266e-11,  2.780237476817124e-14,  8.894941227311148e-16,
 -2.685236868893172e-18, -6.805996921760868e-21,  6.203136706999307e-23, -5.478788024419402e-26, -9.250073451593550e-28,  8.125400886802494e-01, -3.131384815279158e-03,
  3.716369025098422e-06,  1.615975544115734e-08, -6.716037723572463e-11, -7.378695407643845e-14,  1.095559394327403e-15, -1.185963437899744e-18, -1.512802778524029e-20,
  5.362487444201625e-23,  1.433027747326741e-25, -1.294241630164118e-27,  8.937699120844882e-01, -3.255145513099509e-03,  2.649048823879590e-06,  2.048636858029850e-08,
 -5.567849743702216e-11, -1.843816642074072e-13,  1.097479183455387e-15,  1.129083217392392e-18, -2.024335648904169e-20,  1.496986331515754e-23,  3.403499715673386e-25,
 -8.837067582630773e-28,  9.769251535797455e-01, -3.339919261234380e-03,  1.392225529324348e-06,  2.386659410000575e-08, -3.593758634457773e-11, -2.848021604098590e-13,
  8.369714719885941e-16,  3.724320854804383e-18, -1.869272897654238e-20, -4.545213557829911e-23,  4.040351912660228e-25,  3.840471094493835e-28,  1.061509613727253e+00,
 -3.380653989342306e-03, -1.189021046548837e-08,  2.585699715884782e-08, -9.107508784552820e-12, -3.526776637775258e-13,  3.144027932223809e-16,  5.758008424895828e-18,
 -8.821409604427109e-21, -1.021593727494322e-22,  2.313547579005961e-25,  1.887394033650347e-27,  1.146968604755719e+00, -3.373015869103505e-03, -1.505074782400280e-06,
  2.607366807942297e-08,  2.222063291666884e-11, -3.669152154043726e-13, -3.888715869542999e-16,  6.312465526152958e-18,  7.481893413127668e-21, -1.206827790875129e-22,
 -1.531552763278501e-25,  2.462319279332620e-27,  1.232685563722641e+00, -3.313703741246376e-03, -3.013830673261391e-06,  2.425633046647835e-08,  5.409430817957328e-11,
 -3.136691453594856e-13, -1.108442519808737e-15,  4.775129358371761e-18,  2.422556069695107e-20, -7.678225556289472e-23, -5.485043702870410e-25,  1.220299901662454e-27,
  1.317979761558560e+00, -3.200805245555015e-03, -4.451857105180819e-06,  2.033617981319874e-08,  8.158404547454554e-11, -1.925950733531216e-13, -1.627005143497176e-15,
  1.251144098311503e-18,  3.304161494040661e-20,  2.125099467085359e-23, -6.591936504105545e-25, -1.398246158115656e-27,  1.402105665189277e+00, -3.034181278199846e-03,
 -5.724699503668693e-06,  1.449618917230002e-08,  9.954702254472103e-11, -2.130442494300161e-14, -1.740325825518833e-15, -3.212730866268516e-18,  2.736885680453450e-20,
  1.242101914402523e-22, -3.146621658721977e-25, -3.403567221023999e-27,  1.484254623555951e+00, -2.815854688528220e-03, -6.736887078819106e-06,  7.207930413788075e-09,
  1.037330239924105e-10,  1.645933791223845e-13, -1.345721796735351e-15, -6.836290329440731e-18,  7.411513691987259e-21,  1.636837844566505e-22,  3.161053399675490e-25,
 -2.709422832370530e-27,  1.563559640062627e+00, -2.550365991376286e-03, -7.401564094278389e-06, -7.740352532349856e-10,  9.205413105568143e-11,  3.180670050440686e-13,
 -5.184393166318863e-16, -7.844778842730896e-18, -1.761266485022885e-20,  1.011189091328106e-22,  7.556173967039500e-25,  5.362051526897037e-28,  1.639104034092557e+00,
 -2.245044632196383e-03, -7.652115598557525e-06, -8.477898345259100e-09,  6.567408759479369e-11,  3.941650675884621e-13,  4.725830252907503e-16, -5.502351422202381e-18,
 -3.325445936578291e-20, -2.938413230746065e-23,  5.977812956080859e-25,  3.344190439078763e-27,  1.709934743752002e+00, -1.910131706916396e-03, -7.454593469202353e-06,
 -1.484984411322459e-08,  2.945152621361207e-11,  3.673407785369981e-13,  1.247337423002390e-15, -8.286054584698908e-19, -2.928115706272748e-20, -1.321518988905151e-22,
 -4.495737397338645e-26,  2.735681064082217e-27,  1.775080836823651e+00, -1.558683301982300e-03, -6.818960166752901e-06, -1.895096977476629e-08, -8.705098327256166e-12,
  2.456888814153212e-13,  1.486938076935919e-15,  3.691178621295180e-18, -8.574913556954569e-21, -1.266921645683926e-22, -5.598037632960822e-25, -5.123359267108337e-28,
  1.833577437710165e+00, -1.206188329270112e-03, -5.806499051513689e-06, -2.018338853850349e-08, -3.974817716283249e-11,  7.341889457894893e-14,  1.117127593682429e-15,
  5.560180532120340e-18,  1.332074131216945e-20, -2.798640120285716e-23, -4.646018821806051e-25, -2.454739312195364e-27,  1.884494726896718e+00, -8.698564295083253e-04,
 -4.530514556098079e-06, -1.848756492210196e-08, -5.632870919446318e-11, -8.403692305016094e-14,  3.796228185655101e-16,  4.046792786874365e-18,  2.053909922005718e-20,
  6.300778453550392e-23,  2.382706366993213e-26, -1.160944323795258e-27,  1.926970952000228e+00, -5.675734018240240e-04, -3.148014546618664e-06, -1.443872551444082e-08,
 -5.561703559178381e-11, -1.691783359216620e-13, -2.941949012629362e-16,  7.981241844134562e-19,  1.113654895973191e-20,  6.726923104206113e-23,  2.861163838036129e-25,
  8.131520701063698e-28,  1.960247607628347e+00, -3.165814219957153e-04, -1.841641791613361e-06, -9.180944715544087e-09, -4.080730176712909e-11, -1.621044694709650e-13,
 -5.597366338691194e-16, -1.527815679202304e-18, -1.985937456137036e-21,  1.199658365901959e-23,  1.301421270292090e-25,  7.977552578536659e-28,  1.983704408377077e+00,
 -1.320078442203664e-04, -7.935547076165206e-07, -4.180283037362297e-09, -2.026842978125258e-11, -9.216012943981704e-14, -3.953656749835384e-16, -1.597080110329316e-18,
 -6.011701170657541e-21, -2.056855433124499e-23, -6.012488988314004e-26, -1.203779562100774e-28,  1.996894356127441e+00, -2.539948300148088e-05, -1.554902268702788e-07,
 -8.439085803255922e-10, -4.280008861166292e-12, -2.075674439530778e-14, -9.741477905582460e-17, -4.454384723353392e-19, -1.992483500841619e-21, -8.739220813615008e-24,
 -3.763277341899974e-26, -1.591650786005899e-28,  6.229801962746186e-04, -3.499193270907901e-06,  1.473683716545823e-08, -5.515156110294958e-11,  1.934133228347063e-13,
 -6.508541926585421e-16,  2.127974488079782e-18, -6.811221477470751e-21,  2.144224247683561e-23, -6.661827399301409e-26,  2.046749371549412e-28, -6.231078447240505e-31,
  5.605195171893732e-03, -3.143066070697245e-05,  1.318887696387303e-07, -4.904763831277432e-10,  1.703418469020018e-12, -5.652934785610291e-15,  1.813537113111602e-17,
 -5.661966375687841e-20,  1.726394827742461e-22, -5.152309944024109e-25,  1.505713590742922e-27, -4.309657564757265e-30,  1.556091432775856e-02, -8.696210656735113e-05,
  3.622392199897468e-07, -1.329948885341446e-09,  4.527398524689186e-12, -1.459235604027747e-14,  4.493848002324897e-17, -1.326630363122684e-19,  3.749108389248478e-22,
 -1.008857835979582e-24,  2.552358550479331e-27, -5.922833494361900e-30,  3.047254439993607e-02, -1.694286363643270e-04,  6.979203397695259e-07, -2.512293161350576e-09,
  8.287214441047273e-12, -2.546890492702766e-14,  7.309360273649123e-17, -1.942293202618820e-19,  4.659317200555621e-22, -9.452478370324264e-25,  1.264777907242060e-27,
  1.178215340370554e-30,  5.031326321277895e-02, -2.778281884936716e-04,  1.127230520527061e-06, -3.948310877187061e-09,  1.245022050841958e-11, -3.559776407114798e-14,
  9.077470120967201e-17, -1.951963453133648e-19,  2.872564400590826e-22,  1.390937892006768e-25, -3.381401829536273e-27,  1.769044637057189e-29,  7.504649225667143e-02,
 -4.108160765872715e-04,  1.634762238394014e-06, -5.524192545047441e-09,  1.637001603598616e-11, -4.196626604870239e-14,  8.627558923571509e-17, -9.886306836821619e-20,
 -2.394707906446249e-22,  2.226854057962623e-24, -1.003029386992077e-26,  3.416041650216103e-29,  1.046251789403100e-01, -5.666980764338694e-04,  2.201585409093339e-06,
 -7.106013435547234e-09,  1.933942435750345e-11, -4.167205740587001e-14,  5.084433743239461e-17,  1.071582060857225e-19, -1.049472957304726e-21,  4.623735305492365e-24,
 -1.471152696742175e-26,  3.337445846061829e-29,  1.389908760130630e-01, -7.434224105675728e-04,  2.805497576170707e-06, -8.545468806287473e-09,  2.065423366458520e-11,
 -3.240855128709035e-14, -1.856241316935749e-17,  3.995601512217609e-19, -1.909093322390800e-21,  6.037024870293871e-24, -1.220755971942719e-26,  3.426101323466941e-31,
  1.780726025002236e-01, -9.385711258363083e-04,  3.421355349562084e-06, -9.686896363831517e-09,  1.968548710431911e-11, -1.295308675334113e-14, -1.170889094191571e-16,
  7.150994377744232e-19, -2.446609040223339e-21,  4.986791519889047e-24,  1.117573963399756e-27, -6.370141211760818e-29,  2.217854674066884e-01, -1.149351540963140e-03,
  4.021504653008313e-06, -1.037561016900098e-08,  1.595711170880173e-11,  1.639760234390184e-14, -2.308729215036823e-16,  9.565483133824257e-19, -2.247549859853332e-21,
  4.927520675913860e-25,  2.399319870797614e-26, -1.312092213079693e-28,  2.700290345324124e-01, -1.372588673491963e-03,  4.576330380285588e-06, -1.046752283284684e-08,
  9.224392918176330e-12,  5.351013629458765e-14, -3.375200380216974e-16,  1.010515177136076e-18, -1.004885989532121e-21, -7.158632454833657e-24,  4.810044611872684e-26,
 -1.516534132885462e-28,  3.226854041864686e-01, -1.604719851108985e-03,  5.054948731958023e-06, -9.839953457485468e-09, -4.527726134825946e-13,  9.428858206381949e-14,
 -4.085538988214009e-16,  7.765315148227414e-19,  1.307583210413826e-21, -1.588629129220936e-23,  5.901295972060463e-26, -7.422051190222181e-29,  3.796169856657197e-01,
 -1.841793084670151e-03,  5.426067359858398e-06, -8.403397393873505e-09, -1.264973318870512e-11,  1.328151826326448e-13, -4.140193610907367e-16,  2.036475165310190e-19,
  4.292630326714640e-21, -2.189932402037431e-23,  4.145054787772988e-26,  1.139454188690596e-28,  4.406639334964417e-01, -2.079471242869384e-03,  5.659038792305405e-06,
 -6.113859549262216e-09, -2.653986757722595e-11,  1.618256066893924e-13, -3.290584290201131e-16, -6.729735752940237e-19,  7.087300348177587e-21, -2.068684194345740e-23,
 -1.169265215501686e-26,  3.514901537688101e-28,  5.056412212265883e-01, -2.313044632976437e-03,  5.725130422579111e-06, -2.985115145409508e-09, -4.089189735024329e-11,
  1.735642138242603e-13, -1.417697062563868e-16, -1.706647866336106e-18,  8.489199005046620e-21, -8.936136111737060e-24, -8.972839615869036e-26,  4.973339882413418e-28,
  5.743353298545220e-01, -2.537455264778307e-03,  5.599028160129013e-06,  9.000467220003146e-10, -5.411447777558114e-11,  1.610212200709708e-13,  1.389767837909567e-16,
 -2.638530549421286e-18,  7.290478185886351e-21,  1.305901588790717e-23, -1.597304501415717e-25,  3.829647440952141e-28,  6.465005349602383e-01, -2.747336851176698e-03,
  5.260578691688887e-06,  5.380919489906410e-09, -6.436062045182186e-11,  1.194829376452367e-13,  4.777827812926828e-16, -3.134665195790253e-18,  2.793053567789385e-21,
  3.949616436151798e-23, -1.738234173827703e-25, -7.494931334797321e-29,  7.218547888443176e-01, -2.937075454504688e-03,  4.696754630869764e-06,  1.021406825082084e-08,
 -6.970190891608251e-11,  4.822543001559073e-14,  8.115906559491399e-16, -2.867798212316974e-18, -4.621656714593745e-21,  5.907731791213937e-23, -9.161943950561571e-26,
 -7.473643121185033e-28,  8.000752135391128e-01, -3.100896565374365e-03,  3.903794589263018e-06,  1.507479985085353e-08, -6.837614683561647e-11, -4.794489469539851e-14,
  1.055872523955780e-15, -1.638177004458045e-18, -1.310799999967541e-20,  5.822745141301761e-23,  8.715704263744826e-26, -1.248956811147292e-27,  8.807932500390115e-01,
 -3.232985192282166e-03,  2.889423081158103e-06,  1.956745210709264e-08, -5.910055081532633e-11, -1.577354018804371e-13,  1.120123779585356e-15,  4.924659535636308e-19,
 -1.946935464857745e-20,  2.774186943919993e-23,  2.967795439519022e-25, -1.085577469296680e-27,  9.635895516427929e-01, -3.327646061143909e-03,  1.674990310086531e-06,
  2.324715000482462e-08, -4.142466497696962e-11, -2.635324658987369e-13,  9.326545209687467e-16,  3.103118195284385e-18, -2.003510800982320e-20, -2.907116041864836e-23,
  4.121131184190334e-25, -1.382959422828412e-29,  1.047988768457936e+00, -3.379510985541556e-03,  2.972881436788325e-07,  2.565531277282579e-08, -1.607272525629583e-11,
 -3.432325345738553e-13,  4.711358000826171e-16,  5.418822775303007e-18, -1.231336149106788e-20, -9.133370191167270e-23,  3.075729036609611e-25,  1.564298670825342e-27,
  1.133454449475202e+00, -3.383799447988240e-03, -1.190301226064333e-06,  2.637004521270545e-08,  1.480343874913737e-11, -3.741041419196354e-13, -2.094309896017068e-16,
  6.481404750213793e-18,  3.053499478840514e-21, -1.246058781256518e-22, -4.234307566222019e-26,  2.552388929266580e-27,  1.219384391080074e+00, -3.336635855054103e-03,
 -2.717773229845314e-06,  2.507025392612408e-08,  4.756617040760760e-11, -3.385824254236454e-13, -9.643309215855493e-16,  5.502001842184156e-18,  2.108101673661105e-20,
 -9.747362928587244e-23, -4.818442531399769e-25,  1.799078318293955e-27,  1.305106887337355e+00, -3.235422081365668e-03, -4.200124826539565e-06,  2.160860178203932e-08,
  7.734512017762541e-11, -2.311028117293898e-13, -1.577092380403893e-15,  2.315517959415763e-18,  3.331887558585696e-20, -6.162071451512372e-24, -7.066806346143931e-25,
 -7.426547470264694e-28,  1.389878484759410e+00, -3.079256027629993e-03, -5.541210210663274e-06,  1.608323468746210e-08,  9.869649803668138e-11, -6.404871891230877e-14,
 -1.817367831048874e-15, -2.268104232610433e-18,  3.157783196510146e-20,  1.086375895130896e-22, -4.633836228445701e-25, -3.323044639002919e-27,  1.472884002559862e+00,
 -2.869375350656311e-03, -6.640330772760093e-06,  8.892174388321334e-09,  1.066865755469518e-10,  1.300313884992586e-13, -1.532915725944894e-15, -6.502645600506828e-18,
  1.350106532284413e-20,  1.737326701815657e-22,  1.812379386134814e-25, -3.408827690443327e-27,  1.553239728225136e+00, -2.609590140404665e-03, -7.401807793118723e-06,
  7.489697366216166e-10,  9.827293965272373e-11,  3.029285014283552e-13, -7.453945522643486e-16, -8.344273643513070e-18, -1.342472643584320e-20,  1.315854153259961e-22,
  7.617118470383697e-25, -2.866894317129129e-28,  1.630000803407392e+00, -2.306650029887852e-03, -7.747283669515250e-06, -7.363484841292124e-09,  7.365770455641134e-11,
  4.035372166901147e-13,  3.034947326957484e-16, -6.578516145488587e-18, -3.384635641340288e-20, -2.525401420500446e-24,  7.449061479105526e-25,  3.309191342532202e-27,
  1.702173826899468e+00, -1.970472667493989e-03, -7.629716564639799e-06, -1.431822849085092e-08,  3.709525760269669e-11,  3.968881823553430e-13,  1.210302259908385e-15,
 -1.841820373506479e-18, -3.403996983784615e-20, -1.313209671591807e-22,  9.204484485256444e-26,  3.495706238209168e-27,  1.768735557145032e+00, -1.614146611435816e-03,
 -7.047038963450165e-06, -1.904896763304814e-08, -3.426262664486209e-12,  2.825802546599879e-13,  1.585732834679381e-15,  3.339449658914312e-18, -1.354297854294989e-20,
 -1.493848958418643e-22, -5.707785316361370e-25,  4.472161495991015e-29,  1.828658231366810e+00, -1.253619814508963e-03, -6.052462217077074e-06, -2.080610182930446e-08,
 -3.799883365589508e-11,  1.021452807907593e-13,  1.278602058704293e-15,  5.966521176726142e-18,  1.195194331443078e-20, -4.881164106444998e-23, -5.785668019948599e-25,
 -2.715892082394651e-27,  1.880941386096510e+00, -9.070033948054422e-04, -4.757826643547967e-06, -1.940173526020168e-08, -5.790876730879337e-11, -7.348988379548480e-14,
  5.024762255889383e-16,  4.740412638582962e-18,  2.281102368297413e-20,  6.280593616817537e-23, -3.740246007827479e-26, -1.639331182533626e-27,  1.924649171117982e+00,
 -5.934659644580701e-04, -3.326731366020726e-06, -1.535604189572075e-08, -5.906918103239088e-11, -1.759282557148511e-13, -2.664780351128726e-16,  1.195519775306320e-18,
  1.377288636404101e-20,  7.943089879803118e-23,  3.219232510446593e-25,  8.068294569703379e-28,  1.958951101918976e+00, -3.317665924746478e-04, -1.955840022487591e-06,
 -9.860542824029404e-09, -4.418722831797284e-11, -1.760582391659240e-13, -6.033326703027763e-16, -1.583378945268955e-18, -1.451386607707575e-21,  1.796108791811433e-23,
  1.695592858400584e-25,  1.000534492107233e-27,  1.983163354451283e+00, -1.385625919900310e-04, -8.457264115380933e-07, -4.519854695639920e-09, -2.221025762103976e-11,
 -1.022079639097872e-13, -4.428918459475192e-16, -1.801776445314460e-18, -6.796717453275525e-21, -2.307737225926223e-23, -6.524755162231638e-26, -1.109181968644521e-28,
  1.996790204528568e+00, -2.668510898785139e-05, -1.660421335233058e-07, -9.158412041042977e-10, -4.719572058578313e-12, -2.325187267789056e-14, -1.108291390392902e-16,
 -5.145365392427962e-19, -2.335967710334920e-21, -1.039446055962178e-23, -4.538651070629190e-26, -1.945187315148143e-28,  6.092150940557186e-04, -3.383894211679895e-06,
  1.409316536213575e-08, -5.215837320540422e-11,  1.808918965189673e-13, -6.019960010097078e-16,  1.946516835580596e-18, -6.161913832219223e-21,  1.918497757463376e-23,
 -5.895405168002622e-26,  1.791450067345530e-28, -5.394816799724197e-31,  5.481546116149486e-03, -3.039863852787838e-05,  1.261629254348476e-07, -4.641030366686101e-10,
  1.594587004025081e-12, -5.236102553170207e-15,  1.662465537932170e-17, -5.138071020931283e-20,  1.551310880982840e-22, -4.586305525920302e-25,  1.328237459127502e-27,
 -3.770032611709782e-30,  1.521876236264372e-02, -8.412682070736581e-05,  3.467050190961316e-07, -1.259787925119776e-09,  4.246042625775784e-12, -1.355708448894107e-14,
  4.138655270184062e-17, -1.212277872253416e-19,  3.403683502529019e-22, -9.118113281763163e-25,  2.303956613594291e-27, -5.375045395405584e-30,  2.980580877765448e-02,
 -1.639636476981325e-04,  6.685518887095894e-07, -2.383679260174880e-09,  7.794946870248358e-12, -2.377826579525558e-14,  6.785887362728207e-17, -1.798541170263750e-19,
  4.328237378597599e-22, -8.938578395120227e-25,  1.299210341301220e-27,  4.207455928465978e-31,  4.921969078601038e-02, -2.689965301402897e-04,  1.081022895045326e-06,
 -3.754686460624423e-09,  1.175961383457748e-11, -3.348371476467400e-14,  8.543846963125165e-17, -1.859486591407274e-19,  2.900083178898228e-22,  1.848143075933449e-26,
 -2.671157837064820e-27,  1.467662970066842e-29,  7.342897051040394e-02, -3.979987503404501e-04,  1.570016113478284e-06, -5.268875343504487e-09,  1.555116846424124e-11,
 -3.992966444738377e-14,  8.341165672574470e-17, -1.053180360414569e-19, -1.661752093916325e-22,  1.854436599002160e-24, -8.621161118311448e-27,  2.996134468221480e-29,
  1.023930792874755e-01, -5.494212843885836e-04,  2.118142546440949e-06, -6.803182920194091e-09,  1.851840991073826e-11, -4.041943323039919e-14,  5.339883375600656e-17,
  7.612761545916332e-20, -8.932610075714163e-22,  4.064184858703969e-24, -1.327808029123056e-26,  3.171800203430642e-29,  1.360614327424854e-01, -7.213830439092217e-04,
  2.704913298975500e-06, -8.220206959093440e-09,  2.000247902486924e-11, -3.272650282482758e-14, -8.198001560413637e-18,  3.418523871240353e-19, -1.700529839308205e-21,
  5.550799864811399e-24, -1.206288297005991e-26,  5.951025951219592e-30,  1.743723310104076e-01, -9.116599202602929e-04,  3.306993374559958e-06, -9.374147097274419e-09,
  1.939990085890316e-11, -1.553162804819561e-14, -9.813518639492434e-17,  6.396837580308773e-19, -2.266914160502078e-21,  4.979928825458165e-24, -1.354058893111344e-27,
 -4.905452116023857e-29,  2.172516229288934e-01, -1.117673169679784e-03,  3.898539085445008e-06, -1.011796486317868e-08,  1.623178179667167e-11,  1.116994806051860e-14,
 -2.050925474912730e-16,  8.850848072900377e-19, -2.213877054294903e-21,  1.342487098059845e-24,  1.862675878630681e-26, -1.129249310142464e-28,  2.646111092386509e-01,
 -1.336477883987359e-03,  4.451639565138634e-06, -1.031180149866962e-08,  1.021586294088775e-11,  4.574532964445218e-14, -3.097119720025082e-16,  9.745938697508852e-19,
 -1.229552098881109e-21, -5.365782498986319e-24,  4.160346598125377e-26, -1.432383727455704e-28,  3.163466561360559e-01, -1.564752562279031e-03,  4.936886349419263e-06,
 -9.832636929417831e-09,  1.336729518013119e-12,  8.474841898372544e-14, -3.863079863915567e-16,  8.096725167373242e-19,  7.773265065686591e-22, -1.359674763811658e-23,
  5.533755342875856e-26, -9.163352847170139e-29,  3.723359871508536e-01, -1.798791151211384e-03,  5.324098131897966e-06, -8.585080368147690e-09, -1.009225513829349e-11,
  1.229619488905639e-13, -4.065103176879223e-16,  3.287265603669775e-19,  3.535168001640881e-21, -2.015620581074258e-23,  4.534589349251699e-26,  6.458607415729718e-29,
  4.324361186217563e-01, -2.034499373476112e-03,  5.583230048969709e-06, -6.513040380094482e-09, -2.338372625247690e-11,  1.537270223230691e-13, -3.448390097697032e-16,
 -4.581567513839540e-19,  6.337707845453415e-21, -2.086438527424696e-23,  2.346515855414160e-27,  2.871346214651967e-28,  4.964804025564182e-01, -2.267397735180765e-03,
  5.685497329161828e-06, -3.611815795554444e-09, -3.745835118266963e-11,  1.696186831665860e-13, -1.858057412729772e-16, -1.440791188055723e-18,  8.108078957723341e-21,
 -1.209749495474111e-23, -6.860440293467714e-26,  4.610369287806433e-28,  5.642751411935821e-01, -2.492634310585671e-03,  5.604740524489313e-06,  6.013505914383692e-11,
 -5.086654520340562e-11,  1.634968701276614e-13,  6.842614182021648e-17, -2.398912516730777e-18,  7.649792132172581e-21,  7.021199044240025e-24, -1.418498554210977e-25,
  4.256542424889286e-28,  6.355957412943645e-01, -2.705011258081955e-03,  5.319051901831974e-06,  4.370860217492930e-09, -6.186334565546535e-11,  1.299078422848096e-13,
  3.914676053530077e-16, -3.023883441749477e-18,  4.089363845035141e-21,  3.252041362440904e-23, -1.739410491293137e-25,  6.548211874215193e-29,  7.101823847091853e-01,
 -2.899030021059144e-03,  4.812667248299855e-06,  9.107584513982336e-09, -6.854920085214502e-11,  6.672525197534391e-14,  7.295361307868550e-16, -2.982431094709110e-18,
 -2.568274187659699e-21,  5.480871547201101e-23, -1.204757291968558e-25, -5.642299283102167e-28,  7.877352073344801e-01, -3.068961280591050e-03,  4.078100849141576e-06,
  1.397447075292466e-08, -6.908558737326208e-11, -2.319982182416738e-14,  1.004450492152585e-15, -2.023527228317186e-18, -1.096208555418862e-20,  6.063912543720212e-23,
  3.411170459484556e-26, -1.155081264921661e-27,  8.679090041668045e-01, -3.208946875531529e-03,  3.118459489390894e-06,  1.859806970543624e-08, -6.198567186970084e-11,
 -1.307563614420947e-13,  1.125356474421427e-15, -1.123791085474408e-19, -1.826888841508508e-20,  3.861360429022574e-23,  2.458402186407129e-25, -1.218352209446077e-27,
  9.503075176015144e-01, -3.313141935498425e-03,  1.949809427967718e-06,  2.254343457915726e-08, -4.646481744371369e-11, -2.401794100628652e-13,  1.010431411670030e-15,
  2.448423357643061e-18, -2.078611373785796e-20, -1.271018307844957e-23,  4.032463458933444e-25, -3.827899700874885e-28,  1.034477424075411e+00, -3.375906114629560e-03,
  6.033845108758032e-07,  2.534389707236225e-08, -2.281225615053487e-11, -3.301520260525120e-13,  6.168698304463956e-16,  4.974689558875303e-18, -1.536433250235020e-20,
 -7.776461699954311e-23,  3.680502764123703e-25,  1.176015005637708e-27,  1.119902215920023e+00, -3.392052639196841e-03, -8.726871778056112e-07,  2.654683232044202e-08,
  7.285831749109496e-12, -3.769458433565141e-13, -2.725911396474471e-17,  6.507236504573300e-18, -1.435748482359783e-21, -1.240570466641006e-22,  6.945402227417227e-26,
  2.507072167634724e-27,  1.205996286204400e+00, -3.357162253255691e-03, -2.412591221780957e-06,  2.577593568476249e-08,  4.057594074969108e-11, -3.598048373153055e-13,
 -8.013836798401161e-16,  6.116893861250571e-18,  1.724552186064433e-20, -1.150111348434229e-22, -3.914203509941391e-25,  2.294270471214179e-27,  1.292099668489112e+00,
 -3.267965193738929e-03, -3.933555597672357e-06,  2.280711493331332e-08,  7.235043444503098e-11, -2.680549351445547e-13, -1.497403574099578e-15,  3.372665820653899e-18,
  3.258229196888292e-20, -3.486916292991012e-23, -7.232604452520839e-25, -1.079509755735184e-31,  1.377474061362942e+00, -3.122786981452328e-03, -5.338786533272633e-06,
  1.764974152031476e-08,  9.697481629154715e-11, -1.083099656283335e-13, -1.866167076611371e-15, -1.198897791798852e-18,  3.512051980063651e-20,  8.724779876954264e-23,
 -6.039940567183393e-25, -3.033035056810411e-27,  1.461300972881624e+00, -2.922041969361870e-03, -6.523303590037389e-06,  1.061790474470728e-08,  1.089048325319733e-10,
  9.111116360053345e-14, -1.707992863622984e-15, -5.969446951360938e-18,  1.984808605458843e-20,  1.777975397000354e-22,  1.766266413695881e-26, -4.004107705081147e-27,
  1.542683033995966e+00, -2.668741468224062e-03, -7.383189388835426e-06,  2.368753084066131e-09,  1.041334586317369e-10,  2.821913988030816e-13, -9.842946500074583e-16,
 -8.692232333329819e-18, -8.144763462789640e-21,  1.615245577472461e-22,  7.281415081001054e-25, -1.261356657127836e-27,  1.620649716220377e+00, -2.368961095992807e-03,
 -7.828306907867713e-06, -6.120064684971718e-09,  8.178573544559356e-11,  4.084884490151365e-13,  1.041620791693669e-16, -7.657021948208319e-18, -3.336636169630358e-20,
  3.012299729901150e-23,  8.855817210228203e-25,  3.043224361153956e-27,  1.694168787631834e+00, -2.032186971641122e-03, -7.797707156644885e-06, -1.365964383015085e-08,
  4.531866198512571e-11,  4.251891612600755e-13,  1.142777548967358e-15, -3.005715339159573e-18, -3.866213083298074e-20, -1.243377619333452e-22,  2.626438137335930e-25,
  4.253740747176974e-27,  1.762164769622050e+00, -1.671437762422901e-03, -7.275762210556140e-06, -1.905647635399159e-08,  2.613217430310157e-12,  3.217058000057895e-13,
  1.672330365647004e-15,  2.815638231592587e-18, -1.932945588541986e-20, -1.719688882337968e-22, -5.529030923312719e-25,  8.026095659997176e-28,  1.823545317076702e+00,
 -1.303048374437914e-03, -6.305710353334989e-06, -2.139601506936837e-08, -3.563531560852898e-11,  1.348779103244355e-13,  1.450721736869877e-15,  6.316163818523366e-18,
  9.748792204632649e-21, -7.440495287278323e-23, -7.024217156988688e-25, -2.896699650122341e-27,  1.877235750380515e+00, -9.460131496484977e-04, -4.996252962257625e-06,
 -2.033933205020410e-08, -5.924678432622028e-11, -5.975311589099191e-14,  6.457641005593385e-16,  5.506102085333675e-18,  2.502623986726145e-20,  5.970263640317589e-23,
 -1.220365749533984e-25, -2.226258043595867e-27,  1.922220889461213e+00, -6.208332418227575e-04, -3.516791715070040e-06, -1.632963248843055e-08, -6.264872050731635e-11,
 -1.818694984065724e-13, -2.263852309307174e-16,  1.684558290886381e-18,  1.687262237240573e-20,  9.300410354365922e-23,  3.562775490756423e-25,  7.433283473552326e-28,
  1.957591975380216e+00, -3.478989104313546e-04, -2.078527298606011e-06, -1.059650970124627e-08, -4.785680845628250e-11, -1.910748403286822e-13, -6.482104453612560e-16,
 -1.618078553278449e-18, -6.714723303136092e-22,  2.569296335247168e-23,  2.188245771112386e-25,  1.246410360335958e-27,  1.982595220213385e+00, -1.455515566930740e-04,
 -9.021662286027746e-07, -4.892167227857855e-09, -2.436492771213936e-11, -1.134681279141343e-13, -4.965150556741499e-16, -2.033076934674263e-18, -7.675611662734946e-21,
 -2.577968825943818e-23, -6.971556307393284e-26, -8.986927496221636e-29,  1.996680735954423e+00, -2.805872646417776e-05, -1.775011350283056e-07, -9.952242327782898e-10,
 -5.212420643177818e-12, -2.609346186731446e-14, -1.263415290435022e-16, -5.956425585622701e-19, -2.745019289204711e-21, -1.239331056137553e-23, -5.487476810364290e-26,
 -2.383209619071909e-28,  5.959011120949419e-04, -3.273604186930100e-06,  1.348424125313014e-08, -4.935794140126841e-11,  1.693055157023284e-13, -5.572825398516261e-16,
  1.782268656666475e-18, -5.580614187721980e-21,  1.718609628440500e-23, -5.224109851836971e-26,  1.570244383098338e-28, -4.678117775981011e-31,  5.361935499016909e-03,
 -2.941118616291453e-05,  1.207433824294305e-07, -4.394062217060945e-10,  1.493741174463008e-12, -4.853828685838489e-15,  1.525308338187216e-17, -4.667074842215174e-20,
  1.395380500372432e-22, -4.086759522040293e-25,  1.172904479926424e-27, -3.301422636298329e-30,  1.488770821998425e-02, -8.141251571319096e-05,  3.319864081268966e-07,
 -1.193967540888679e-09,  3.984564998399596e-12, -1.260333869451642e-14,  3.813984913304340e-17, -1.108438702410577e-19,  3.091463833148996e-22, -8.242311338750121e-25,
  2.078738859478163e-27, -4.868980647630890e-30,  2.916047280377944e-02, -1.587275645438467e-04,  6.406806408560865e-07, -2.262677829237607e-09,  7.335267738621246e-12,
 -2.220854809488986e-14,  6.301209749008709e-17, -1.665085644722639e-19,  4.015830809610789e-22, -8.416999244603048e-25,  1.304513593949408e-27, -1.526342632944121e-31,
  4.816072012509046e-02, -2.605254234951978e-04,  1.037073837294827e-06, -3.571780373232709e-09,  1.111002846013392e-11, -3.149462166501594e-14,  8.036179098508811e-17,
 -1.766771532280245e-19,  2.888988800604770e-22, -7.623026445235755e-26, -2.082959407177209e-27,  1.213105310712850e-29,  7.186170122484538e-02, -3.856873575227352e-04,
  1.508256517517220e-06, -5.026337638259110e-09,  1.477235225942052e-11, -3.796371306659353e-14,  8.039788152028848e-17, -1.096315329881836e-19, -1.053154732523467e-22,
  1.534813700284017e-24, -7.387512659668283e-27,  2.618132735480256e-29,  1.002287744194052e-01, -5.327977207715052e-04,  2.038255669324839e-06, -6.513285170541121e-09,
  1.772299349095480e-11, -3.911538078009441e-14,  5.515150624822139e-17,  4.978442346263022e-20, -7.561793099579171e-22,  3.560412259557429e-24, -1.192488207045428e-26,
  2.975230641488504e-29,  1.332185620592030e-01, -7.001329165751810e-04,  2.608169427963586e-06, -7.905411079204420e-09,  1.934672576115885e-11, -3.281436024957943e-14,
  6.414082592588188e-19,  2.905401593160928e-19, -1.509311224621553e-21,  5.074818008010108e-24, -1.170667353620613e-26,  1.001111982067222e-29,  1.707778982056054e-01,
 -8.856486799612823e-04,  3.196355350766639e-06, -9.066355767872751e-09,  1.906712499313724e-11, -1.767997076223112e-14, -8.121276518725716e-17,  5.699964981682449e-19,
 -2.089097106613341e-21,  4.886378785507183e-24, -3.233943095595376e-27, -3.676209469278395e-29,  2.128425441634621e-01, -1.086966088982981e-03,  3.778688286671606e-06,
 -9.856728320822295e-09,  1.640792475335766e-11,  6.537159599204166e-15, -1.812937538323878e-16,  8.151484003216240e-19, -2.153287218200686e-21,  1.993268830231607e-24,
  1.403553894053921e-26, -9.601079127806014e-29,  2.593356442501453e-01, -1.301356888268714e-03,  4.328907578844932e-06, -1.014142310731538e-08,  1.105862534495652e-11,
  3.863509248971253e-14, -2.830010032924195e-16,  9.324665382929429e-19, -1.394257850965622e-21, -3.824723148960238e-24,  3.552604688527003e-26, -1.327425017015281e-28,
  3.101658894671880e-01, -1.525728948882610e-03,  4.819077355662169e-06, -9.798185502698204e-09,  2.940832980620724e-12,  7.575145088050775e-14, -3.633595002578793e-16,
  8.271343336766104e-19,  3.266813662396367e-22, -1.146748306293983e-23,  5.104764042428032e-26, -1.023677758059359e-28,  3.652253520166820e-01, -1.756613011632621e-03,
  5.220187757859585e-06, -8.727409276994085e-09, -7.729769818854579e-12,  1.133282787210414e-13, -3.958287798609951e-16,  4.305968258665547e-19,  2.842762870974560e-21,
 -1.829811293612804e-23,  4.726282065234905e-26,  2.394582782701510e-29,  4.243869491425800e-01, -1.990152288672553e-03,  5.502928718978680e-06, -6.863037304854667e-09,
 -2.039287076965024e-11,  1.453191697781150e-13, -3.549407568410491e-16, -2.673262514672022e-19,  5.591158445388341e-21, -2.053599191265225e-23,  1.363231709381818e-26,
  2.266310790805444e-28,  4.875014910288068e-01, -2.222097056196900e-03,  5.638670665169399e-06, -4.184265910041793e-09, -3.411368886134857e-11,  1.647041379725408e-13,
 -2.225844966773184e-16, -1.188791521332530e-18,  7.627947225158958e-21, -1.444875931832095e-23, -4.928875044317230e-26,  4.157961125702558e-28,  5.543942651653846e-01,
 -2.447807086623615e-03,  5.600687092629091e-06, -7.275032745696820e-10, -4.758548244964285e-11,  1.643609198914875e-13,  4.714104050536707e-18, -2.151132939132339e-18,
  7.805006090181296e-21,  1.729051877718873e-24, -1.226168135957891e-25,  4.450312262602754e-28,  6.248611097866580e-01, -2.662265667772238e-03,  5.365650658006494e-06,
  3.402313907579449e-09, -5.917801391392537e-11,  1.383028610463646e-13,  3.087973741079701e-16, -2.875627058935137e-18,  5.135883599360854e-21,  2.565605316171880e-23,
 -1.684418060936767e-25,  1.801431633020296e-28,  6.986639332957818e-01, -2.860110056937253e-03,  4.915424581481827e-06,  8.022396118965863e-09, -6.704641167910470e-11,
  8.322452414853119e-14,  6.451672015573474e-16, -3.034021483069430e-18, -6.874001131684678e-22,  4.954643090201128e-23, -1.413342015952759e-25, -3.852743192892554e-28,
  7.755256473207209e-01, -3.035684517334014e-03,  4.239151158409100e-06,  1.286667923567917e-08, -6.931330132478933e-11,  1.894700297508978e-16,  9.432102064931249e-16,
 -2.339219772077339e-18, -8.766438811069191e-21,  6.102342727687072e-23, -1.393975166829446e-26, -1.023893617631296e-27,  8.551245014172701e-01, -3.183123541599019e-03,
  3.335604149916778e-06,  1.758684316127783e-08, -6.433130414027507e-11, -1.038502760652771e-13,  1.114247290347496e-15, -6.729505877950509e-19, -1.671493811294791e-20,
  4.735130922906671e-23,  1.905783507829161e-25, -1.282502359856160e-27,  9.370878417985046e-01, -3.296474370047342e-03,  2.215715830518141e-06,  2.176290834940852e-08,
 -5.102073892461572e-11, -2.151818609408967e-13,  1.069628273614079e-15,  1.779020792641754e-18, -2.095830701614673e-20,  2.984174984210390e-24,  3.791271285294704e-25,
 -7.044622392793353e-28,  1.020985370490578e+00, -3.369869232790760e-03,  9.051061313998664e-07,  2.492692737543535e-08, -2.925626304430348e-11, -3.137336946633563e-13,
  7.488778625607363e-16,  4.441173688923794e-18, -1.788751597469345e-20, -6.213156839934603e-23,  4.104871269645973e-25,  7.487613430458757e-28,  1.106322061970090e+00,
 -3.397758479803294e-03, -5.536744805849952e-07,  2.660312055047556e-08, -2.449131487387090e-13, -3.754229244561210e-13,  1.536339571347407e-16,  6.390585272827614e-18,
 -5.825582249141673e-21, -1.191153140561735e-22,  1.763501554791689e-25,  2.331220023074963e-27,  1.192531009554859e+00, -3.375215254860369e-03, -2.099625397784690e-06,
  2.636659626320707e-08,  3.320169070800031e-11, -3.769243382254150e-13, -6.230274617439495e-16,  6.599687233059462e-18,  1.284874145752898e-20, -1.285283888243018e-22,
 -2.816919074841619e-25,  2.671486760443756e-27,  1.278966631394938e+00, -3.298319637646888e-03, -3.653107725259706e-06,  2.391991469118978e-08,  6.663821134003130e-11,
 -3.027429469005798e-13, -1.388600517255659e-15,  4.389644646762689e-18,  3.080833997657027e-20, -6.357016498329895e-23, -7.060711980734718e-25,  7.842083989841077e-28,
  1.364898871234258e+00, -3.164623889464078e-03, -5.117759445539773e-06,  1.918156641138519e-08,  9.435868580067028e-11, -1.533710801465379e-13, -1.883564755341179e-15,
 -2.970264455024006e-20,  3.779558402238242e-20,  6.055170313272515e-23, -7.271490945032709e-25, -2.530524920644668e-27,  1.449509281090974e+00, -2.973688992797754e-03,
 -6.385381102375332e-06,  1.237267716652380e-08,  1.103039948190409e-10,  4.819128181458198e-14, -1.865284262145671e-15, -5.232113733797707e-18,  2.621775218440201e-20,
  1.748399855224841e-22, -1.686733204994964e-25, -4.433328116280135e-27,  1.531890157659835e+00, -2.727664538706717e-03, -7.344585678359153e-06,  4.078672316600270e-09,
  1.095212132219577e-10,  2.556238565697417e-13, -1.230412481557656e-15, -8.854332525523713e-18, -1.821830550601358e-21,  1.892272891021794e-22,  6.490945282225556e-25,
 -2.345096761072765e-27,  1.611048186025957e+00, -2.431858447226348e-03, -7.893626415494575e-06, -4.746073988896926e-09,  8.996251881126323e-11,  4.082961795593159e-13,
 -1.249694184167209e-16, -8.700303921816684e-18, -3.161326237414437e-20,  6.808650731074209e-23,  1.008665366994481e-24,  2.503374037265187e-27,  1.685914256564288e+00,
 -2.095211309305392e-03, -7.956986923470812e-06, -1.286505597245975e-08,  5.408915508467119e-11,  4.514620456379896e-13,  1.040640608045984e-15, -4.312115615296116e-18,
 -4.290214656500236e-20, -1.098776439803569e-22,  4.654142674162609e-25,  4.946120657196784e-27,  1.755361159750964e+00, -1.730557356888690e-03, -7.503969598128900e-06,
 -1.896098575567154e-08,  9.454692532956294e-12,  3.627120169373456e-13,  1.741547990345557e-15,  2.093858135864066e-18, -2.590747678557289e-20, -1.931077946844374e-22,
 -4.969417054468979e-25,  1.777541708755439e-27,  1.818230592718334e+00, -1.354530541187844e-03, -6.565788211446714e-06, -2.194264718186015e-08, -3.257508816899042e-11,
  1.718500395975009e-13,  1.631498988952773e-15,  6.579594161005478e-18,  6.533498685440707e-21, -1.050767670056003e-22, -8.315277230638843e-25, -2.944921060595176e-27,
  1.873370189081995e+00, -9.869756614971877e-04, -5.246049200305518e-06, -2.129594495031652e-08, -6.027389944119960e-11, -4.231228498684383e-14,  8.114619411813186e-16,
  6.340185061108974e-18,  2.706227238797534e-20,  5.266397565125962e-23, -2.350055370205825e-25, -2.927703359421378e-27,  1.919680022350523e+00, -6.497687166300959e-04,
 -3.718882525670516e-06, -1.736138916737605e-08, -6.633629354588533e-11, -1.866725273892121e-13, -1.711353555497700e-16,  2.280864969924245e-18,  2.048485460070935e-20,
  1.078731269273976e-22,  3.861050402537542e-25,  5.960653187642596e-28,  1.956166299200036e+00, -3.650490743397732e-04, -2.210408558237801e-06, -1.139365131365145e-08,
 -5.183755426487972e-11, -2.071770756611421e-13, -6.936657247367860e-16, -1.622965023422419e-18,  4.249947460723128e-22,  3.562585308249656e-23,  2.799677344868957e-25,
  1.541391345352018e-27,  1.981998197933305e+00, -1.530105145853592e-04, -9.632883087522634e-07, -5.300828292760469e-09, -2.675821205372608e-11, -1.260962350711929e-13,
 -5.570232827832237e-16, -2.294090990252087e-18, -8.654742358797061e-21, -2.863765157698392e-23, -7.290627397033232e-26, -5.181092002040015e-29,  1.996565583338120e+00,
 -2.952796484731655e-05, -1.899619894904174e-07, -1.082968520851293e-09, -5.766015869971731e-12, -2.933614837493320e-14, -1.443195053867648e-16, -6.910667582452708e-19,
 -3.233352016062799e-21, -1.481318261501891e-23, -6.651473931412969e-26, -2.927216687879851e-28,  5.830187559189530e-04, -3.168054219221427e-06,  1.290783886512966e-08,
 -4.673594630930447e-11,  1.585752665042318e-13, -5.163227289182266e-16,  1.633436516763453e-18, -5.059576874449915e-21,  1.541368597335021e-23, -4.635300600990431e-26,
  1.378281009409584e-28, -4.062892222289486e-31,  5.246189817640945e-03, -2.846593155528658e-05,  1.156107666312769e-07, -4.162635208824006e-10,  1.400222042657227e-12,
 -4.502944763916419e-15,  1.400666666619231e-17, -4.243214997523477e-20,  1.256363355570166e-22, -3.645409912920840e-25,  1.036809203657750e-27, -2.894108895722717e-30,
  1.456728070334501e-02, -7.881286992757133e-05,  3.180331559396522e-07, -1.132182336209527e-09,  3.741406057442508e-12, -1.172413483609801e-14,  3.517036963531831e-17,
 -1.014103058635103e-19,  2.809204019969115e-22, -7.452264789410428e-25,  1.874880431199425e-27, -4.403985763181602e-30,  2.853564424524260e-02, -1.537087659908961e-04,
  6.142182968603949e-07, -2.148786304730901e-09,  6.905849425980267e-12, -2.075078014709947e-14,  5.852528330856316e-17, -1.541326756045327e-19,  3.722182674600330e-22,
 -7.897887907893567e-25,  1.287939781798169e-27, -5.791976559517235e-31,  4.713494436118126e-02, -2.523973035262872e-04,  9.952585839955498e-07, -3.398955928771336e-09,
  1.049902753905574e-11, -2.962426063203547e-14,  7.554373603878704e-17, -1.674913740269617e-19,  2.847774550671496e-22, -1.495315632434994e-25, -1.597719629120417e-27,
  9.986307046923011e-30,  7.034270749472986e-02, -3.738586085383395e-04,  1.449333892358202e-06, -4.795950407270885e-09,  1.403212308659978e-11, -3.607133185626432e-14,
  7.728892981403086e-17, -1.121724155547415e-19, -5.511292883806910e-23,  1.261329619888213e-24, -6.311308274552472e-27,  2.280102393990353e-29,  9.812970734518887e-02,
 -5.167995514368397e-04,  1.961772072641939e-06, -6.235903391807881e-09,  1.695402150723490e-11, -3.777763620332654e-14,  5.622532902928523e-17,  2.754794653940590e-20,
 -6.362805272330374e-22,  3.108978029325101e-24, -1.066242402207038e-26,  2.761278031228759e-29,  1.304591676559135e-01, -6.796418084329199e-04,  2.515140133243563e-06,
 -7.601110258386550e-09,  1.869122393786790e-11, -3.270663702722271e-14,  8.127187138998612e-18,  2.450758373950308e-19, -1.334931998864539e-21,  4.616269768394091e-24,
 -1.120029029864681e-26,  1.282268509576366e-29,  1.672857634138450e-01, -8.605078635092035e-04,  3.089377528232188e-06, -8.764211172219718e-09,  1.869528891150769e-11,
 -1.944495090535881e-14, -6.616252903919377e-17,  5.059320059895796e-19, -1.915876849168091e-21,  4.727814371535976e-24, -4.620061083266448e-27, -2.656811056512092e-29,
  2.085543960206196e-01, -1.057205234254951e-03,  3.661986277206925e-06, -9.593384365273600e-09,  1.649696625518871e-11,  2.452283061755718e-15, -1.594227576907198e-16,
  7.474917033710377e-19, -2.072399602815711e-21,  2.474840366338467e-24,  1.015498769242017e-26, -8.064119790968681e-29,  2.541987127911458e-01, -1.267209351629557e-03,
  4.208296457388671e-06, -9.958663735464691e-09,  1.176549522710632e-11,  3.215121783188102e-14, -2.575353769675960e-16,  8.859102844344705e-19, -1.507746046625785e-21,
 -2.517111226247291e-24,  2.993989617441248e-26, -1.210351921983194e-28,  3.041393355245057e-01, -1.487645730931884e-03,  4.701829932279176e-06, -9.739477872832851e-09,
  4.370536195758612e-12,  6.730955370500051e-14, -3.401126896546170e-16,  8.313680230233127e-19, -5.049732786886359e-23, -9.517577823040993e-24,  4.640905389538371e-26,
 -1.076813632749756e-28,  3.582817569458519e-01, -1.715272358785832e-03,  5.114789924945368e-06, -8.833464953675363e-09, -5.557175967695791e-12,  1.039827523844347e-13,
 -3.825949301244915e-16,  5.113918371796263e-19,  2.218220704735274e-21, -1.639665741108393e-23,  4.757343392747581e-26, -8.540853347992508e-30,  4.165138577131139e-01,
 -1.946463613705314e-03,  5.418708961011754e-06, -7.166537202666692e-09, -1.757217784767276e-11,  1.367303087400907e-13, -3.600313353462127e-16, -1.001141718266960e-19,
  4.863928704787617e-21, -1.980793127217030e-23,  2.236862268592347e-26,  1.714376300589566e-28,  4.787029907584218e-01, -2.177197566152236e-03,  5.585292294910420e-06,
 -4.704033347264798e-09, -3.087558209545889e-11,  1.589897654007642e-13, -2.525340454471998e-16, -9.533652870734306e-19,  7.076580772012217e-21, -1.606899821594770e-23,
 -3.209114182084666e-26,  3.653265709720672e-28,  5.446925745786062e-01, -2.403049203522059e-03,  5.587497290406601e-06, -1.462587070000913e-09, -4.430186545251997e-11,
  1.637795252455535e-13, -5.201814435742080e-17, -1.901285011606923e-18,  7.783700550080306e-21, -2.782758573119083e-24, -1.029754355253282e-25,  4.448569225037381e-28,
  6.142981336578871e-01, -2.619193035158446e-03,  5.400889845836556e-06,  2.477969783126630e-09, -5.634426781247126e-11,  1.447671660356249e-13,  2.307103700672479e-16,
 -2.697784057142724e-18,  5.940391129379545e-21,  1.910481475469378e-23, -1.584764298435745e-25,  2.685366915985439e-28,  6.873027239911117e-01, -2.820419690072041e-03,
  5.005314453777080e-06,  6.963781846108422e-09, -6.523396822539205e-11,  9.768822846691761e-14,  5.601668338820663e-16, -3.028600773873508e-18,  9.908846262237623e-22,
  4.360426251453712e-23, -1.545573399523013e-25, -2.182889650906140e-28,  7.634516869315418e-01, -3.001172552515304e-03,  4.386901279316148e-06,  1.175890386205613e-08,
 -6.908860205936521e-11,  2.201086160184114e-14,  8.741136823959714e-16, -2.584789411772563e-18, -6.590085452976712e-21,  5.960948056961083e-23, -5.561493209852341e-26,
 -8.671910725991692e-28,  8.424466886178635e-01, -3.155612186491337e-03,  3.540406607975537e-06,  1.654237175609936e-08, -6.614272206592977e-11, -7.739326875583631e-14,
  1.088182495184577e-15, -1.179193719021177e-18, -1.488672279384665e-20,  5.384138025702074e-23,  1.339248866938478e-25, -1.282673429919714e-27,  9.239390297409609e-01,
 -3.277718219379398e-03,  2.471835280854362e-06,  2.091355779923335e-08, -5.506402141022384e-11, -1.889886143120067e-13,  1.110088176076669e-15,  1.112935115740088e-18,
 -2.058612597574917e-20,  1.744780406184854e-23,  3.421540081160834e-25, -9.652431019126398e-28,  1.007522257849113e+00, -3.361440319254718e-03,  1.201216870341436e-06,
  2.440964740325240e-08, -3.534147630342512e-11, -2.943350248540303e-13,  8.649037911027476e-16,  3.836211063989438e-18, -1.982193842665882e-20, -4.518242625728221e-23,
  4.337704032074572e-25,  3.098808938962863e-28,  1.092724190251961e+00, -3.400911561518855e-03, -2.347075106120057e-07,  2.653939502001915e-08, -7.702131130038798e-12,
 -3.696134468308029e-13,  3.293266781704634e-16,  6.137113749648526e-18, -9.962739208829065e-21, -1.100880513767926e-22,  2.728822510247206e-25,  2.039026528366517e-27,
  1.178998570378197e+00, -3.390738208450293e-03, -1.780290108487131e-06,  2.683676660204840e-08,  2.552886715350412e-11, -3.896173886786443e-13, -4.331897265627535e-16,
  6.934874849495288e-18,  8.047975451758855e-21, -1.373653956163325e-22, -1.584582546340328e-25,  2.904674935120367e-27,  1.265716746002082e+00, -3.326378689668294e-03,
 -3.359877037524990e-06,  2.493592023075683e-08,  6.026061006127066e-11, -3.344853433084691e-13, -1.252270775782939e-15,  5.333525568022176e-18,  2.802186099144943e-20,
 -9.089239793869549e-23, -6.543926524976982e-25,  1.558791320422515e-27,  1.352159985230609e+00, -3.204619833351048e-03, -4.878631390658004e-06,  2.066431204277506e-08,
  9.083985541426405e-11, -1.984481372254212e-13, -1.867177530603999e-15,  1.208813713652278e-18,  3.942679418250698e-20,  2.943154828251572e-23, -8.237534429205293e-25,
 -1.830106068056130e-27,  1.437513341778720e+00, -3.024148093218219e-03, -6.226295997419494e-06,  1.414277132788954e-08,  1.108088002352667e-10,  1.767032479340708e-15,
 -1.999103178571811e-15, -4.294126572703714e-18,  3.234279030451380e-20,  1.641132683317069e-22, -3.691630780672479e-25, -4.638589911041127e-27,  1.520862338668025e+00,
 -2.786195280386876e-03, -7.284964290032443e-06,  5.870222757887862e-09,  1.143183030311135e-10,  2.231187817932215e-13, -1.478091414469914e-15, -8.798846829424401e-18,
  5.429814327979756e-21,  2.127956014510473e-22,  5.210809637366924e-25, -3.475169567539433e-27,  1.601194128874769e+00, -2.495210181164658e-03, -7.941674185142072e-06,
 -3.241594111055729e-09,  9.807813730531491e-11,  4.022618461692462e-13, -3.823154844297493e-16, -9.664721209536683e-18, -2.841137690738355e-20,  1.104105551322204e-22,
  1.101397548976926e-24,  1.660282126247621e-27,  1.677405143477846e+00, -2.159469320306339e-03, -8.105872794621169e-06, -1.192608245629459e-08,  6.335755310231660e-11,
  4.748298994499439e-13,  9.001146860910708e-16, -5.744244463164426e-18, -4.646858380265969e-20, -8.673404283348871e-23,  6.957557750009688e-25,  5.492434897552004e-27,
  1.748317430151096e+00, -1.791496103145135e-03, -7.730346980257974e-06, -1.874938760934033e-08,  1.713114135612084e-11,  4.051124670564897e-13,  1.787498000434734e-15,
  1.149925174932927e-18, -3.319527722820880e-20, -2.110855003208672e-22, -3.932508387366849e-25,  2.970732630664683e-27,  1.812705738154360e+00, -1.408118679021468e-03,
 -6.832106701546125e-06, -2.243416209583267e-08, -2.873149869033587e-11,  2.132366530659586e-13,  1.818038728226338e-15,  6.721470372552273e-18,  2.121025705548912e-21,
 -1.409022766535658e-22, -9.586701841783915e-25, -2.795751376247479e-27,  1.869336707936048e+00, -1.029982712090974e-03, -5.507411163341881e-06, -2.226597701973041e-08,
 -6.091050181881186e-11, -2.060735858073095e-14,  1.001381577077958e-15,  7.234432302994743e-18,  2.875583104400778e-20,  4.045572823283017e-23, -3.813342396161501e-25,
 -3.741297859092108e-27,  1.917020100049099e+00, -6.803714520660605e-04, -3.933711343962882e-06, -1.845283753548909e-08, -7.010524513734694e-11, -1.899356359988007e-13,
 -9.748858275992994e-17,  3.001543367552586e-18,  2.465199918089915e-20,  1.237736413064407e-22,  4.069915151987604e-25,  3.304976015534805e-28,  1.954669850119946e+00,
 -3.832936587459223e-04, -2.352248488240309e-06, -1.225712046111692e-08, -5.615124317329075e-11, -2.243675667982623e-13, -7.387093343023852e-16, -1.586544859679730e-18,
  1.926338870865190e-21,  4.827971200362808e-23,  3.552689784419921e-25,  1.890705222583755e-27,  1.981370329865143e+00, -1.609787355432447e-04, -1.029552674060362e-06,
 -5.749883856779337e-09, -2.941919119717710e-11, -1.402678767980183e-13, -6.252941760765953e-16, -2.588104388925689e-18, -9.738594543397474e-21, -3.158316172887447e-23,
 -7.391451764629958e-26,  1.078500960294162e-29,  1.996444347506770e+00, -3.110125745571717e-05, -2.035311392242109e-07, -1.180113546946077e-09, -6.389005442952293e-12,
 -3.304421848428215e-14, -1.652018975751825e-16, -8.036062114627511e-19, -3.817791103892306e-21, -1.775022742909692e-23, -8.083036281857972e-26, -3.604461159237071e-28,
  5.705495724073267e-04, -3.066992472457951e-06,  1.236189673239902e-08, -4.427927086444454e-11,  1.486296432133062e-13, -4.787660391496258e-16,  1.498430221481109e-18,
 -4.592008210761714e-21,  1.384005378447197e-23, -4.118126806545604e-26,  1.211438997674432e-28, -3.533943286273881e-31,  5.134144756466748e-03, -2.756065193862753e-05,
  1.107471118329963e-07, -3.945625706019822e-10,  1.313430808720016e-12, -4.180599511300262e-15,  1.287293430488001e-17, -3.861400123233016e-20,  1.132296621633313e-22,
 -3.255075546766643e-25,  9.174427071386431e-28, -2.539750896700180e-30,  1.425703312184655e-02, -7.632194929718604e-05,  3.047985509227286e-07, -1.074150786165232e-09,
  3.515139397361420e-12, -1.091312830042049e-14,  3.245280128166465e-17, -9.283600068269884e-20,  2.553966334151687e-22, -6.739787573900553e-25,  1.690603404642023e-27,
 -3.978633284719048e-30,  2.793047597714705e-02, -1.488963140201435e-04,  5.890823704926838e-07, -2.041537965230328e-09,  6.504537163945946e-12, -1.939664190284212e-14,
  5.437211840800760e-17, -1.426667224064027e-19,  3.447061323337555e-22, -7.388797030913123e-25,  1.255259202715202e-27, -8.892530923775477e-31,  4.614102493682565e-02,
 -2.445955734001242e-04,  9.554597822664323e-07, -3.235614436875040e-09,  9.924298251902567e-12, -2.786646370784448e-14,  7.098066547485834e-17, -1.584761341656313e-19,
  2.783447732301324e-22, -2.052059889672741e-25, -1.199125686211670e-27,  8.183569957355644e-30,  6.887010322748993e-02, -3.624903804604905e-04,  1.393106087751358e-06,
 -4.577108137164034e-09,  1.332899052749465e-11, -3.425424649823898e-14,  7.412990162248586e-17, -1.132563194030115e-19, -1.401576398005100e-23,  1.028031231157709e-24,
 -5.375500658718774e-27,  1.979514240658652e-29,  9.609342999918533e-02, -5.014001436691887e-04,  1.888544122880598e-06, -5.970609929497022e-09,  1.621201387838818e-11,
 -3.642117245471405e-14,  5.672787035937060e-17,  8.897764806110888e-21, -5.317473576959876e-22,  2.706131728220416e-24, -9.496007800572687e-27,  2.540113056213650e-29,
  1.277802720919204e-01, -6.598805062804603e-04,  2.425699621759842e-06, -7.307270891239953e-09,  1.803957324747254e-11, -3.243391567637990e-14,  1.441563441467831e-17,
  2.049316592993391e-19, -1.176668949844142e-21,  4.180141432677842e-24, -1.059291384510360e-26,  1.464016505534579e-29,  1.638925030595566e-01, -8.362084703944699e-04,
  2.985988641627566e-06, -8.468279323883806e-09,  1.829162319885554e-11, -2.086963032182618e-14, -5.282942552505790e-17,  4.473093715307465e-19, -1.749259957590835e-21,
  4.522215120912117e-24, -5.599109636590785e-27, -1.821750851525035e-29,  2.043834441049139e-01, -1.028365336900381e-03,  3.548450337810786e-06, -9.329241444797271e-09,
  1.650940739576385e-11, -1.130114748687191e-15, -1.394075112098626e-16,  6.826721319561148e-19, -1.976810734876369e-21,  2.814241707922859e-24,  6.915249652976931e-27,
 -6.688774055213500e-29,  2.491964558491853e-01, -1.234017748885567e-03,  4.089942134885226e-06, -9.765599108324651e-09,  1.234869183500946e-11,  2.626250691100642e-14,
 -2.334173932285355e-16,  8.364334880867526e-19, -1.578056200970582e-21, -1.422443427152667e-24,  2.488267864750843e-26, -1.087983404193495e-28,  2.982632434889688e-01,
 -1.450497298157348e-03,  4.585418778558458e-06, -9.659215364647351e-09,  5.636983525769215e-12,  5.942570219699093e-14, -3.169060164710006e-16,  8.246189539511106e-19,
 -3.608632442592548e-22, -7.756554901353333e-24,  4.163464588822071e-26, -1.087198618565699e-28,  3.515018308765442e-01, -1.674779402418737e-03,  5.008321882778685e-06,
 -8.906236426663278e-09, -3.568144679192381e-12,  9.497979048985145e-14, -3.673683227175122e-16,  5.732964744727456e-19,  1.662030546902659e-21, -1.450913049231097e-23,
  4.662022091020260e-26, -3.363832157795303e-29,  4.088141514672862e-01, -1.903462510658914e-03,  5.331112304877057e-06, -7.426285324726283e-09, -1.492411812759121e-11,
  1.280728539277756e-13, -3.607613804315528e-16,  4.430871838676819e-20,  4.168630084121482e-21, -1.877721415086194e-23,  2.881023969348497e-26,  1.224286000269560e-28,
  4.700831961236412e-01, -2.132749180070191e-03,  5.525983681697642e-06, -5.172942225313073e-09, -2.775842724171542e-11,  1.526336638746026e-13, -2.761465194320092e-16,
 -7.363876685755867e-19,  6.478724910446010e-21, -1.704657336886694e-23, -1.717089670403881e-26,  3.127418202534356e-28,  5.351696498801827e-01, -2.358431231069200e-03,
  5.565801093004796e-06, -2.145297620176082e-09, -4.104292644813497e-11,  1.619202838350413e-13, -1.017875340914520e-16, -1.654566345625222e-18,  7.614064790051165e-21,
 -6.513952608320963e-24, -8.369984178760982e-26,  4.290495294129153e-28,  6.039079427367133e-01, -2.575882077608250e-03,  5.425312885146723e-06,  1.599899802283122e-09,
 -5.339955902378398e-11,  1.494198322858287e-13,  1.579285244681274e-16, -2.497886242008886e-18,  6.517097442789159e-21,  1.302241608481035e-23, -1.451843096997387e-25,
  3.316170418281936e-28,  6.761016346612316e-01, -2.780060503463546e-03,  5.082684136771142e-06,  5.936370178945109e-09, -6.315260796653335e-11,  1.101196130376808e-13,
  4.760373126604402e-16, -2.972985637673797e-18,  2.447457652101044e-21,  3.727524409386763e-23, -1.608061328766998e-25, -6.904230873781140e-29,  7.515180543419073e-01,
 -2.965531666256977e-03,  4.521393771075460e-06,  1.065812280051328e-08, -6.844457464891975e-11,  4.209923669401797e-14,  7.991063482746597e-16, -2.761838111710830e-18,
 -4.492932175205594e-21,  5.667136877590838e-23, -9.004566695890703e-26, -6.964204859168794e-28,  8.298821180555185e-01, -3.126512999081914e-03,  3.732518851702062e-06,
  1.547311209890019e-08, -6.743236853074897e-11, -5.172510312795914e-14,  1.048793943908066e-15, -1.623632018998449e-18, -1.286549980946016e-20,  5.808232488501282e-23,
  7.853048666173717e-26, -1.226799765430418e-27,  9.108692741469169e-01, -3.256954941582859e-03,  2.717391810660567e-06,  2.000375209759590e-08, -5.857523031092339e-11,
 -1.620463186254633e-13,  1.132140534669770e-15,  4.667835910304323e-19, -1.972245944443134e-20,  3.022297047268576e-23,  2.952086657953896e-25, -1.156817930894623e-27,
  9.940975570236927e-01, -3.350668973983944e-03,  1.490549346336169e-06,  2.379825322608987e-08, -4.101227573636103e-11, -2.723614257841083e-13,  9.632169368916481e-16,
  3.179251714181789e-18, -2.113406241990367e-20, -2.768569071785491e-23,  4.379735805879510e-25, -1.143876121808936e-28,  1.079118801985279e+00, -3.401517984357570e-03,
  8.278342921828615e-08,  2.635750994349649e-08, -1.500164412520555e-11, -3.596871440217414e-13,  4.961227643494164e-16,  5.757171183452854e-18, -1.370878245014060e-20,
 -9.748620911789544e-23,  3.543919085631334e-25,  1.652569008816581e-27,  1.165409181514993e+00, -3.403686016228148e-03, -1.456056933763886e-06,  2.718239129959240e-08,
  1.764841301311742e-11, -3.976593295126681e-13, -2.361584216384767e-16,  7.112316522374151e-18,  3.019859070902577e-21, -1.411140378528903e-22, -2.843558215637855e-26,
  2.978528671048404e-27,  1.252359390797464e+00, -3.352044909679093e-03, -3.055086883072280e-06,  2.584499193340427e-08,  5.328296484104276e-11, -3.626496507861954e-13,
 -1.090905352401259e-15,  6.172966369267749e-18,  2.429707642259049e-20, -1.154806045348000e-22, -5.698302865278636e-25,  2.270207195796475e-27,  1.339265052747640e+00,
 -3.242632606449896e-03, -4.622077845112376e-06,  2.208357731107986e-08,  8.642625177444895e-11, -2.427109212516948e-13, -1.815554440419534e-15,  2.480921223831055e-18,
  3.987602548687321e-20, -4.884838535663288e-24, -8.857564729647974e-25, -9.646207620515364e-28,  1.425318246053058e+00, -3.073249482624857e-03, -6.045952481115895e-06,
  1.591334931914671e-08,  1.103552442275995e-10, -4.753197153052658e-14, -2.103983605433730e-15, -3.167877685130729e-18,  3.793583198371524e-20,  1.452632149834486e-22,
 -5.728633814355186e-25, -4.572722757282232e-27,  1.509601488583846e+00, -2.844161803232290e-03, -7.203406272733635e-06,  7.733003860490150e-09,  1.184061129515110e-10,
  1.847150240048889e-13, -1.720848068101495e-15, -8.498818567604636e-18,  1.342578852034050e-20,  2.302526699007987e-22,  3.437824280977493e-25, -4.570684650606157e-27,
  1.591086013465487e+00, -2.558871886174877e-03, -7.970894191115023e-06, -1.608574364606498e-09,  1.060091846755728e-10,  3.897401725677774e-13, -6.649970753877135e-16,
 -1.050166168137009e-17, -2.362883595405473e-20,  1.556100196988772e-22,  1.150164510636828e-24,  5.057429167186286e-28,  1.668636691139759e+00, -2.224870792283444e-03,
 -8.242586425954105e-06, -1.083527281643205e-08,  7.305627075908117e-11,  4.943318741275632e-13,  7.180295781669981e-16, -7.275346999848567e-18, -4.903077823032645e-20,
 -5.395955702070411e-23,  9.452088848218871e-25,  5.798395251876860e-27,  1.741026342642708e+00, -1.854233558962102e-03, -7.953420092865149e-06, -1.840813175872011e-08,
  2.566434772467859e-11,  4.482716364762413e-13,  1.803661977647962e-15, -3.666571219268128e-20, -4.104241031544424e-20, -2.238050585521001e-22, -2.325938347752440e-25,
  4.361229064985450e-27,  1.806962234148951e+00, -1.463859847541917e-03, -7.103926279949049e-06, -2.285731342417122e-08, -2.401517327346800e-11,  2.591307087870969e-13,
  2.006373423582340e-15,  6.700547612247286e-18, -3.670456705999861e-21, -1.816075376376331e-22, -1.073523020817795e-24, -2.372909441944424e-27,  1.865126942875000e+00,
 -1.075127358441048e-03, -5.780459474053284e-06, -2.324246566595721e-08, -6.106536702975995e-11,  5.961781817415424e-15,  1.217024310462205e-15,  8.174639960738391e-18,
  2.989563177748181e-20,  2.164824441523612e-23, -5.656730614664091e-25, -4.651479577894238e-27,  1.914234245141774e+00, -7.127462370256692e-04, -4.162001185179316e-06,
 -1.960500805226980e-08, -7.392006903783882e-11, -1.911734716584868e-13, -1.708875859965999e-18,  3.864864896399705e-18,  2.940338818711477e-20,  1.402317294573374e-22,
  4.128047592947301e-25, -9.710292860515538e-29,  1.953098085948311e+00, -4.027156089435715e-04, -2.504875696941298e-06, -1.319241739657376e-08, -6.081943984837659e-11,
 -2.426209960649938e-13, -7.819877707999455e-16, -1.494180668998499e-18,  3.941295769025079e-21,  6.426983556241777e-23,  4.472010316760822e-25,  2.297635727297557e-27,
  1.980709493504121e+00, -1.694993720104684e-04, -1.101470809614609e-06, -6.243874445789607e-09, -3.238067568330408e-11, -1.561808257897069e-13, -7.022989730345731e-16,
 -2.918499520453016e-18, -1.092846306090487e-20, -3.450450727911837e-23, -7.144411656925561e-26,  1.083059116596854e-28,  1.996316593768681e+00, -3.278794149506469e-05,
 -2.183283748253599e-07, -1.287848038753473e-09, -7.091434783173704e-12, -3.729349439259298e-14, -1.895139414810624e-16, -9.366560722898302e-19, -4.519031154411298e-21,
 -2.132415477199528e-23, -9.848099805021604e-26, -4.449541241007037e-28,  5.584760837706943e-04, -2.970182991580417e-06,  1.184450415424009e-08, -4.197588801904721e-11,
  1.394037839581824e-13, -4.442979201128897e-16,  1.375837958403635e-18, -4.171941242012234e-21,  1.244113180603696e-23, -3.663259915326407e-26,  1.066211486225848e-28,
 -3.078482548956458e-31,  5.025644611860899e-03, -2.669326304141985e-05,  1.061357445360142e-07, -3.742001476531816e-10,  1.232822817166054e-12, -3.884224533707393e-15,
  1.184075677018816e-17, -3.517127463560052e-20,  1.021458782180015e-22, -2.909509051582594e-25,  8.126364222873631e-28, -2.231188326256222e-30,  1.395654179429751e-02,
 -7.393418032696025e-05,  2.922391269113765e-07, -1.019613205348888e-09,  3.304459630999661e-12, -1.016455241262090e-14,  2.996425448351048e-17, -8.503880409641573e-20,
  2.323095110576893e-22, -6.097390600717000e-25,  1.524204481620836e-27, -3.590997701438378e-30,  2.734416334155255e-02, -1.442799086733326e-04,  5.651957747040878e-07,
 -1.940499268142616e-09,  6.129336405006951e-12, -1.813842485601254e-14,  5.052794833578363e-17, -1.320521111287776e-19,  3.190001704703190e-22, -6.895220215101201e-25,
  1.211038346505248e-27, -1.107398797739527e-30,  4.517768784887881e-02, -2.371045469889318e-04,  9.175670455335110e-07, -3.081193230925407e-09,  9.383650085177715e-12,
 -2.621517636285225e-14,  6.666685954221311e-17, -1.496958811974238e-19,  2.701765009499378e-22, -2.464339729348881e-25, -8.732793514426112e-28,  6.671769684628650e-30,
  6.744208859330501e-02, -3.515616589074213e-04,  1.339438075570753e-06, -4.369229381460389e-09,  1.266143978650285e-11, -3.251320090959243e-14,  7.095772308148351e-17,
 -1.131525218498396e-19,  1.932551605720190e-23,  8.296238964455273e-25, -4.564236929914382e-27,  1.713504782905569e-29,  9.411759851715107e-02, -4.865740251742845e-04,
  1.818429358854301e-06, -5.716971070651748e-09,  1.549721573362974e-11, -3.505854926635984e-14,  5.675292035206835e-17, -6.630580906218436e-21, -4.409003314105598e-22,
  2.347991958324813e-24, -8.427076186664584e-27,  2.319206290869747e-29,  1.251790127705228e-01, -6.408208007132793e-04,  2.339722829754249e-06, -7.023806471649030e-09,
  1.739479806112421e-11, -3.202320209171197e-14,  1.964862048554373e-17,  1.696055193350045e-19, -1.033652184381210e-21,  3.769663580641833e-24, -9.923447461181308e-27,
  1.567701928078190e-29,  1.605948083886381e-01, -8.127220954962086e-04,  2.886111299826181e-06, -8.179017236628134e-09,  1.786253397036898e-11, -2.199341706448412e-14,
 -4.106427398133482e-17,  3.938931833323152e-19, -1.590665476916672e-21,  4.284314628012721e-24, -6.246765945905468e-27, -1.146572193860348e-29,  2.003260552762662e-01,
 -1.000421050095521e-03,  3.438083026300886e-06, -9.065447160567656e-09,  1.645485905960716e-11, -4.253569945804974e-15, -1.211627236756243e-16,  6.210830438112445e-19,
 -1.871194533658972e-21,  3.035679710582278e-24,  4.245073431390736e-27, -5.474634483182803e-29,  2.443250865343533e-01, -1.201763563738893e-03,  3.973956788809965e-06,
 -9.564114554495070e-09,  1.281978916278179e-11,  2.093578419810961e-14, -2.107106066290819e-16,  7.852993096813751e-19, -1.612469365715724e-21, -5.192601272895082e-25,
  2.036573292230786e-26, -9.655082123640622e-29,  2.925338891767847e-01, -1.414275969325757e-03,  4.470087248340086e-06, -9.559920937626185e-09,  6.751302563952807e-12,
  5.209547813487829e-14, -2.940180934858732e-16,  8.089156398854696e-19, -6.112714283744391e-22, -6.186393240474866e-24,  3.688973395709454e-26, -1.064961929560068e-28,
  3.448821683593102e-01, -1.635141155955888e-03,  4.901165653827091e-06, -8.948603463492479e-09, -1.755387971855484e-12,  8.636111841989881e-14, -3.506474077454915e-16,
  6.184808433819409e-19,  1.172857084673161e-21, -1.267983465384054e-23,  4.470933604720848e-26, -5.222068071792267e-29,  4.012850293457943e-01, -1.861173941658079e-03,
  5.240647171655717e-06, -7.645049305885037e-09, -1.244906800556537e-11,  1.194439258860994e-13, -3.577531694519804e-16,  1.671213718628171e-19,  3.514573022201269e-21,
 -1.753003810887973e-23,  3.323954000790972e-26,  8.000007172208709e-29,  4.616402116423128e-01, -2.088796932505097e-03,  5.461343119597711e-06, -5.593022366255802e-09,
 -2.477358060309734e-11,  1.457815770936736e-13, -2.939559551978734e-16, -5.389938684109779e-19,  5.855860573731260e-21, -1.747366199891400e-23, -4.563987219812874e-27,
  2.605358830575200e-28,  5.258247992936000e-01, -2.314018715106636e-03,  5.536223796207792e-06, -2.776225188002661e-09, -3.783256104514067e-11,  1.589487423075869e-13,
 -1.447439393062459e-16, -1.415277974059095e-18,  7.323782256650274e-21, -9.491779660041000e-24, -6.539307898569357e-26,  4.014307656571742e-28,  5.936913208203779e-01,
 -2.532417075676825e-03,  5.439484545344169e-06,  7.695966191233175e-10, -5.037880125209976e-11,  1.523947867479626e-13,  9.097002513460979e-17, -2.282929666207034e-18,
  6.885012350819357e-21,  7.520186209861978e-24, -1.296375492639672e-25,  3.714286376314158e-28,  6.650631427326874e-01, -2.739131090835170e-03,  5.147932541363672e-06,
  4.944140214063478e-09, -6.084265864444184e-11,  1.205556308111632e-13,  3.940830360089842e-16, -2.874441437279093e-18,  3.673214143616383e-21,  3.082148794995293e-23,
 -1.609511203184244e-25,  5.869212439627717e-29,  7.397290538045673e-01, -2.928867472489024e-03,  4.642751653944367e-06,  9.570760957575351e-09, -6.741714429983338e-11,
  6.033542384011088e-14,  7.200634648322841e-16, -2.873721246397195e-18, -2.524512653671733e-21,  5.250809199368202e-23, -1.168466857417109e-25, -5.219873488309522e-28,
  8.174369363307462e-01, -3.095928550308617e-03,  3.911692936853100e-06,  1.438726954419115e-08, -6.821907460538299e-11, -2.714415934045486e-14,  9.978865633620080e-16,
 -2.001370365207724e-18, -1.073076281500662e-20,  6.017095026634007e-23,  2.664292438912674e-26, -1.125087476521043e-27,  8.978864301291891e-01, -3.234271796161546e-03,
  2.951711454396150e-06,  1.904210048726882e-08, -6.154374830843286e-11, -1.347883386158276e-13,  1.136554039237961e-15, -1.447497468501915e-19, -1.843452605411453e-20,
  4.097294853642807e-23,  2.414211401830264e-25, -1.276175794662997e-27,  9.807205223004732e-01, -3.337613824081753e-03,  1.772015596031463e-06,  2.309976390203701e-08,
 -4.622152006657808e-11, -2.482532119199868e-13,  1.042642104151738e-15,  2.490378993354030e-18, -2.181769217638003e-20, -1.038460471997879e-23,  4.242637086058181e-25,
 -5.008648712093920e-28,  1.065516051277649e+00, -3.399595179146701e-03,  3.973982403317147e-07,  2.606063451442373e-08, -2.206352986127181e-11, -3.458985007026323e-13,
  6.506747194810914e-16,  5.265208548247534e-18, -1.694677196474053e-20, -8.198578385297787e-23,  4.173270314398156e-25,  1.199658011934928e-27,  1.151773212378850e+00,
 -3.414025522653708e-03, -1.128437257862912e-06,  2.740090031007028e-08,  9.654715643415075e-12, -4.009311689985058e-13, -3.642445453635926e-17,  7.127706508356072e-18,
 -2.049246430419202e-21, -1.396448130299395e-22,  1.012497946362433e-25,  2.889837152194585e-27,  1.238904313710635e+00, -3.375231112336047e-03, -2.740075607734502e-06,
  2.663813318276695e-08,  4.578259203485784e-11, -3.866733978920309e-13, -9.078323609071056e-16,  6.879763578878221e-18,  1.975527833706476e-20, -1.360902646724758e-22,
 -4.562941777747051e-25,  2.867945818950210e-27,  1.326222280110262e+00, -3.278526093733578e-03, -4.348945784549838e-06,  2.342522231712982e-08,  8.114267063060197e-11,
 -2.853068552948787e-13, -1.728299774161117e-15,  3.747236075580104e-18,  3.905475599235626e-20, -4.088165274338975e-23, -9.069334141003743e-25,  1.616964666427051e-29,
  1.412929764555945e+00, -3.120823335293074e-03, -5.844438520498251e-06,  1.766865688673296e-08,  1.088931928277001e-10, -9.895014473548039e-14, -2.174936550666520e-15,
 -1.875070809604182e-18,  4.270509636043174e-20,  1.184102402073022e-22, -7.671147047468504e-25, -4.205928864640703e-27,  1.498110220398112e+00, -2.901385396976118e-03,
 -7.099128815263691e-06,  9.654732149289446e-09,  1.216684182906495e-10,  1.406153589199588e-13, -1.951537552703165e-15, -7.934325183146870e-18,  2.191121307705919e-20,
  2.396845274797492e-22,  1.207589100978338e-25, -5.537244780653139e-27,  1.580722910842935e+00, -2.622686830506213e-03, -7.979766058913914e-06,  1.489624180226753e-10,
  1.136201526080886e-10,  3.701717368689354e-13, -9.687237193121391e-16, -1.115925416038736e-17, -1.719705255025391e-20,  2.016558953003274e-22,  1.141593507924872e-24,
 -9.399504069619326e-28,  1.659604532158554e+00, -2.291310948369913e-03, -8.365267202734304e-06, -9.586415545233446e-09,  8.309781193953186e-11,  5.089412504819573e-13,
  4.921169674937801e-16, -8.867614984969792e-18, -5.023107683975975e-20, -1.103101519544225e-23,  1.200963472843637e-24,  5.761797138532577e-27,  1.733480765440040e+00,
 -1.918736832686259e-03, -8.171550426230469e-06, -1.792342987307719e-08,  3.506177737656593e-11,  4.913912958354879e-13,  1.783026606485653e-15, -1.480328422184282e-18,
 -4.921658472884242e-20, -2.288267156617846e-22, -7.284132145658269e-27,  5.898272495189410e-27,  1.800991386101752e+00, -1.521794529760880e-03, -7.380339822939178e-06,
 -2.319741550208093e-08, -1.833592795736582e-11,  3.095154404361654e-13,  2.191301318335197e-15,  6.470006723265704e-18, -1.100464751640827e-20, -2.264357117438051e-22,
 -1.162208294764720e-24, -1.592020760414482e-27,  1.860732156238575e+00, -1.122503262598442e-03, -6.065222044455430e-06, -2.421689087857042e-08, -6.063494433157851e-11,
  3.802570065319623e-14,  1.459391096492613e-15,  9.138985356866540e-18,  3.021578644849046e-20, -5.355238760582362e-24, -7.915863762049046e-25, -5.623319506591900e-27,
  1.911315149425892e+00, -7.470036835598964e-04, -4.404483684873474e-06, -2.081828037347957e-08, -7.773461338880153e-11, -1.898047892044622e-13,  1.204616171699993e-16,
  4.889715341899981e-18,  3.474638739351100e-20,  1.564867974802241e-22,  3.952701882713415e-25, -7.404690066822258e-28,  1.951446119028356e+00, -4.234047689201711e-04,
 -2.669186843086491e-06, -1.420538144513581e-08, -6.586284244369674e-11, -2.618742291999400e-13, -8.216855029075843e-16, -1.327381786767079e-18,  6.602558621520748e-21,
  8.431237020582928e-23,  5.583064449603979e-25,  2.761707010695445e-27,  1.980013385193835e+00, -1.786198954901803e-04, -1.179611971345524e-06, -6.787898496677610e-09,
 -3.567967228212769e-11, -1.740573015090154e-13, -7.891035167388171e-16, -3.288624901834521e-18, -1.222056829982739e-20, -3.722793567987759e-23, -6.366113835532219e-26,
  2.549960295907417e-28,  1.996181848072327e+00, -3.459837240695891e-05, -2.344887683351666e-07, -1.407534300881334e-09, -7.884999916779414e-12, -4.217362373314756e-14,
 -2.178858944318961e-16, -1.094348078136425e-18, -5.362590083118363e-21, -2.568435302985494e-23, -1.202980419759023e-25, -5.506435412546647e-28,  5.467817263584774e-04,
 -2.877404547012862e-06,  1.135388872957813e-08, -3.981475997306862e-11,  1.308387921372660e-13, -4.126357839969586e-16,  1.264404693599329e-18, -3.794128055251286e-21,
  1.119597090478337e-23, -3.262667760461996e-26,  9.396087733240874e-29, -2.685731653949210e-31,  4.920541758140919e-03, -2.586180916975499e-05,  1.017611792826439e-07,
 -3.550813464642019e-10,  1.157902208300396e-12, -3.611504018564381e-15,  1.090019144725191e-17, -3.206410777482321e-20,  9.223383434665637e-23, -2.603270562108621e-25,
  7.205140201742817e-28, -1.962272256379999e-30,  1.366540465727433e-02, -7.164432513272765e-05,  2.803144123599780e-07, -9.683299009630323e-10,  3.108171392655233e-12,
 -9.473163181202375e-15,  2.768402485568559e-17, -7.794464523672695e-20,  2.114192241104813e-22, -5.518248163181904e-25,  1.374072160314641e-27, -3.238861021399422e-30,
  2.677594167915761e-02, -1.398498464095597e-04,  5.424864384652898e-07, -1.845267381868534e-09,  5.778400986653836e-12, -1.696899270509586e-14,  4.696973569631298e-17,
 -1.222320193935566e-19,  2.950371400927124e-22, -6.421026497545895e-25,  1.158867528912525e-27, -1.253564213936345e-30,  4.424372011445541e-02, -2.299093948361957e-04,
  8.814765329031874e-07, -2.935163731831200e-09,  8.875012107391766e-12, -2.466450101632672e-14,  6.259503538444406e-17, -1.411983702540240e-19,  2.607432934262095e-22,
 -2.758828671029214e-25, -6.083745711199014e-28,  5.406742497759953e-30,  6.605694570303863e-02, -3.410524822257967e-04,  1.288201659286005e-06, -4.171757003764412e-09,
  1.202794946571998e-11, -3.084813854935220e-14,  6.780235733913855e-17, -1.120900462069679e-19,  4.608090430677257e-23,  6.614213495847963e-25, -3.862961955971849e-27,
  1.479064659036624e-29,  9.219996867767288e-02, -4.722968424807724e-04,  1.751290539559343e-06, -5.474551071816698e-09,  1.480964249460357e-11, -3.370022552231554e-14,
  5.638199561646386e-17, -1.945004752932116e-20, -3.622000168247012e-22,  2.030678678071623e-24, -7.454274447204156e-27,  2.103886716782516e-29,  1.226526379393011e-01,
 -6.224354779018673e-04,  2.257086004644072e-06, -6.750586244226083e-09,  1.675941555887614e-11, -3.149826274311050e-14,  2.395436194933043e-17,  1.386247265743435e-19,
 -9.049213563712079e-22,  3.386687466833133e-24, -9.222218901518904e-27,  1.611035249530626e-29,  1.573894829968627e-01, -7.900209730754048e-04,  2.789663217137831e-06,
 -7.896785539457037e-09,  1.741367442511144e-11, -2.285222261004924e-14, -3.072504530399059e-17,  3.454105435997308e-19, -1.441033977699741e-21,  4.026030073395250e-24,
 -6.628294860967859e-27, -6.084804817001836e-30,  1.963786977392046e-01, -9.733470590902086e-04,  3.330874023561699e-06, -8.803002190714995e-09,  1.634208268687510e-11,
 -6.959455613251446e-15, -1.045940571799945e-16,  5.629816257498244e-19, -1.759404570359372e-21,  3.160531938444888e-24,  2.074634356168150e-27, -4.415952348752972e-29,
  2.395808936778630e-01, -1.170427469870435e-03,  3.860431061665926e-06, -9.355915598068910e-09,  1.318968517268337e-11,  1.613674766444584e-14, -1.894463486245462e-16,
  7.335503221909511e-19, -1.617490994849657e-21,  2.139376695596424e-25,  1.638069466756911e-26, -8.467341104246563e-29,  2.869475828352721e-01, -1.378972234457477e-03,
  4.356049484158085e-06, -9.443940561122477e-09,  7.724470144552103e-12,  4.530843336072441e-14, -2.716738082663552e-16,  7.860672844544678e-19, -8.085395065628953e-22,
 -4.803309387740453e-24,  3.229814225921920e-26, -1.018831093267969e-28,  3.384193417873772e-01, -1.596361712829309e-03,  4.793669428483447e-06, -8.963323177357034e-09,
 -1.108980936760146e-13,  7.815722169059651e-14, -3.328706939314878e-16,  6.490490885320803e-19,  7.479811224868911e-22, -1.094161163068095e-23,  4.210737181631604e-26,
 -6.520213867683462e-29,  3.939235983652775e-01, -1.819618934265329e-03,  5.147788796179718e-06, -7.825588063702204e-09, -1.014560797744452e-11,  1.109261375094959e-13,
 -3.515922488079946e-16,  2.697532323578061e-19,  2.908171269732921e-21, -1.614107486465262e-23,  3.594771599609503e-26,  4.417346870469963e-29,  4.533719711084311e-01,
 -2.045381171962171e-03,  5.391943548516176e-06, -5.966462679850569e-09, -2.192961396360210e-11,  1.385661250560030e-13, -3.065190511774020e-16, -3.616848671474214e-19,
  5.226149233632098e-21, -1.744186379751635e-23,  5.790088768974238e-27,  2.106064551935455e-28,  5.166570788100044e-01, -2.269872233691756e-03,  5.499381427186533e-06,
 -3.356316113256881e-09, -3.469139913085511e-11,  1.550255042226116e-13, -1.811454396731279e-16, -1.186855085843454e-18,  6.939161115431137e-21, -1.176431978557039e-23,
 -4.849569652687115e-26,  3.655398672109696e-28,  5.836487237205200e-01, -2.488877729405592e-03,  5.443984246371064e-06, -1.198369283825039e-11, -4.731412079469748e-11,
  1.538361143585460e-13,  3.016623140881011e-17, -2.059246028642299e-18,  7.066405522270485e-21,  2.668611049169097e-24, -1.128008304174410e-25,  3.907539392674851e-28,
  6.541893379267186e-01, -2.697726674528749e-03,  5.201502485858708e-06,  3.990433347938331e-09, -5.834341249837020e-11,  1.290620746787749e-13,  3.154022618470913e-16,
 -2.740380924912916e-18,  4.667823598958693e-21,  2.446751907754788e-23, -1.559877654895770e-25,  1.629740346120975e-28,  7.280885695591540e-01, -2.891284302520947e-03,
  4.751171527411863e-06,  8.502651779332988e-09, -6.604417807839315e-11,  7.664396134177082e-14,  6.387457855263301e-16, -2.925204940496474e-18, -7.234257183692926e-22,
  4.742532617616575e-23, -1.360583001467190e-25, -3.527673246716066e-28,  8.051168764089960e-01, -3.063963006366330e-03,  4.077777386464838e-06,  1.329270280362908e-08,
 -6.852719614880259e-11, -3.904138177440921e-15,  9.373673730761631e-16, -2.309985224345153e-18, -8.557014349991017e-21,  6.028455589951643e-23, -1.996993927109286e-26,
 -9.889772202368807e-28,  8.849979936366504e-01, -3.209761018863566e-03,  3.174224294293689e-06,  1.803731388741537e-08, -6.396740889075916e-11, -1.076249100204926e-13,
  1.124476769627390e-15, -7.093014797716758e-19, -1.679939454839188e-20,  4.948738434404486e-23,  1.839444260034269e-25, -1.325182011797990e-27,  9.674001566004399e-01,
 -3.322341851299351e-03,  2.044616115285459e-06,  2.232188095812122e-08, -5.093111079260879e-11, -2.224721563689075e-13,  1.102565259724907e-15,  1.789457343732583e-18,
 -2.189231383116739e-20,  6.043415654362577e-24,  3.947317424052539e-25, -8.309400284029230e-28,  1.051926000382797e+00, -3.395171604056423e-03,  7.077823453083700e-07,
  2.565317174488550e-08, -2.881372429644279e-11, -3.285770864795570e-13,  7.900882239868390e-16,  4.679004566589340e-18, -1.958635564771351e-20, -6.437925864816999e-23,
  4.594383823493158e-25,  7.112586300570413e-28,  1.138101140664499e+00, -3.421735760806901e-03, -7.989641849129450e-07,  2.749124693912071e-08,  1.643458146135469e-12,
 -3.994224676981761e-13,  1.614845043123060e-16,  6.982722143997419e-18, -6.973449588915070e-21, -1.331124641597846e-22,  2.236011486171731e-25,  2.647621741478159e-27,
  1.225361589346025e+00, -3.395861229044657e-03, -2.416281737911134e-06,  2.730766981965059e-08,  3.784719715238202e-11, -4.060829854768878e-13, -7.071087779744913e-16,
  7.430277491202468e-18,  1.455922765354000e-20, -1.516757783951560e-22, -3.197641937764205e-25,  3.309183579591164e-27,  1.313040403488485e+00, -3.312171626653558e-03,
 -4.060248919680055e-06,  2.467564044202971e-08,  7.503096348434620e-11, -3.253873663962280e-13, -1.606151705682388e-15,  4.966458369406056e-18,  3.693294722060534e-20,
 -7.684218802702307e-23, -8.835628508410752e-25,  1.048954095725611e-27,  1.400354344609753e+00, -3.166701297885501e-03, -5.622035427354136e-06,  1.939226480739927e-08,
  1.063887664879432e-10, -1.516205058259614e-13, -2.207710083236350e-15, -4.465773946234698e-19,  4.637251049357280e-20,  8.420093546664112e-23, -9.384358949363636e-25,
 -3.531468127641647e-27,  1.486391873489996e+00, -2.957681709712230e-03, -6.971507501206931e-06,  1.162130648741596e-08,  1.239948047991210e-10,  9.119974946499691e-14,
 -2.162581447312155e-15, -7.094666927151508e-18,  3.056589346352234e-20,  2.394050887955583e-22, -1.401111542135689e-25, -6.274403626653301e-27,  1.570104542946088e+00,
 -2.686486350177604e-03, -7.966831046563950e-06,  2.024741856029647e-09,  1.207654926903737e-10,  3.431176941101561e-13, -1.287733528380489e-15, -1.158470230747277e-17,
 -9.129808798427576e-21,  2.460118983749450e-22,  1.063944266478058e-24, -2.622104672307180e-27,  1.650304748456452e+00, -2.358669854005592e-03, -8.471989057938015e-06,
 -8.174865922473985e-09,  9.337369424160715e-11,  5.175908802120517e-13,  2.213294717615915e-16, -1.047160166139464e-17, -4.970330410607593e-20,  4.197205659711861e-23,
  1.445705689421179e-24,  5.281988501678796e-27,  1.725673725589203e+00, -1.984959261989302e-03, -8.382933850746207e-06, -1.728151115298120e-08,  4.531322026885088e-11,
  5.335009762553752e-13,  1.718292647567097e-15, -3.186583872295258e-18, -5.739277570689667e-20, -2.234583164911840e-22,  2.873427347063972e-25,  7.494195704770633e-27,
  1.794784353144990e+00, -1.581955222330178e-03, -7.660255355443121e-06, -2.343834964309983e-08, -1.160527165279590e-11,  3.642329455429430e-13,  2.366241284556342e-15,
  5.978340593757920e-18, -2.000710209788896e-20, -2.739995399141267e-22, -1.207071264289714e-24, -3.671775466405931e-28,  1.856143235960259e+00, -1.172203871818174e-03,
 -6.361614185777854e-06, -2.517897386544600e-08, -5.950288615511538e-11,  7.623063740857281e-14,  1.728743919101160e-15,  1.009619357372619e-17,  2.939079303150313e-20,
 -4.225601313324619e-23, -1.060541288106785e-24, -6.595105674082729e-27,  1.908255050534504e+00, -7.832602615538584e-04, -4.661890201791100e-06, -2.209219699375305e-08,
 -8.149003668936028e-11, -1.851398104679506e-13,  2.738082507783576e-16,  6.094709409267063e-18,  4.065442656363476e-20,  1.713970080469556e-22,  3.435275572781742e-25,
 -1.663284739400228e-27,  1.949708687529226e+00, -4.454584417383854e-04, -2.846150594505864e-06, -1.530217044846361e-08, -7.130040617983211e-11, -2.820138419872189e-13,
 -8.554057991261231e-16, -1.062979374691691e-18,  1.007041261407337e-20,  1.092230700644294e-22,  6.909758812437005e-25,  3.275946691954245e-27,  1.979279501881627e+00,
 -1.883925866707472e-04, -1.264610300329490e-06, -7.387683531176181e-09, -3.935789545259464e-11, -1.941462087695483e-13, -8.868646666886024e-16, -3.701592554511638e-18,
 -1.360339138871323e-20, -3.949238811900500e-23, -4.799659562221130e-26,  4.702692564517576e-28,  1.996039592675053e+00, -3.654405492307653e-05, -2.521649242099969e-07,
 -1.540736980892891e-09, -8.783350953950375e-12, -4.779086606009492e-14, -2.510759909661326e-16, -1.281723403749096e-18, -6.380012009871344e-21, -3.101766802391365e-23,
 -1.473316827889067e-25, -6.831096744884268e-28,  5.354507938967938e-04, -2.788449574174253e-06,  1.088840503820516e-08, -3.778574764597423e-11,  1.228811332188538e-13,
 -3.835254736669077e-16,  1.163013368254754e-18, -3.453947062934370e-21,  1.008630922394046e-23, -2.909424373321730e-26,  8.290773275959742e-29, -2.346593968750629e-31,
  4.818696151659592e-03, -2.506445408935463e-05,  9.760902336698157e-08, -3.371188372836399e-10,  1.088217140110208e-12, -3.360347911250764e-15,  1.004234699754078e-17,
 -2.925717565562922e-20,  8.336067650529987e-23, -2.331619284761866e-25,  6.394501530859484e-28, -1.727721600902652e-30,  1.338323996911332e-02, -6.944745841477314e-05,
  2.689867006568461e-07, -9.200794933314706e-10,  2.925179391009524e-12, -8.834189476991359e-15,  2.559337816857444e-17, -7.148674626771534e-20,  1.925093980218637e-22,
 -4.996159129179335e-25,  1.238696085479477e-27, -2.919865165328322e-30,  2.622508402160822e-02, -1.355969814117401e-04,  5.208869521086797e-07, -1.755467901104845e-09,
  5.450022071072665e-12, -1.588174319435445e-14,  4.367600388239523e-17, -1.131518453424175e-19,  2.727422554089957e-22, -5.968812395919514e-25,  1.101546726410034e-27,
 -1.343873919526381e-30,  4.333796644643041e-02, -2.229960933951464e-04,  8.470905514820040e-07, -2.797029561714058e-09,  8.396429490906421e-12, -2.320872930548494e-14,
  5.875677004761964e-17, -1.330177444416826e-19,  2.504278301975803e-22, -2.957847936990239e-25, -3.944115243719375e-28,  4.350419877244385e-30,  6.471303450478180e-02,
 -3.309438880054685e-04,  1.239275182107381e-06, -3.984158164034675e-09,  1.142700599100951e-11, -2.925835663405990e-14,  6.468785447171141e-17, -1.102630655315333e-19,
  6.726184756371223e-23,  5.192929276298980e-25, -3.258451644104167e-27,  1.273170973134103e-29,  9.033839151046923e-02, -4.585453191406729e-04,  1.686995647824919e-06,
 -5.242915513746843e-09,  1.414911906089539e-11, -3.235483702354349e-14,  5.568571873364970e-17, -2.992655036472280e-20, -2.942451717681851e-22,  1.750407677606326e-24,
 -6.574288111990620e-27,  1.897801647150168e-29,  1.201985027319697e-01, -6.046983071115058e-04,  2.177667189404113e-06, -6.487442818580136e-09,  1.613549730948314e-11,
 -3.087994220008569e-14,  2.744827872800008e-17,  1.115481680141876e-19, -7.894695212053614e-22,  3.031997410912835e-24, -8.512478493448631e-27,  1.608550287145290e-29,
  1.542734402010810e-01, -7.680780115044828e-04,  2.696558299922491e-06, -7.621859973474436e-09,  1.695001298470555e-11, -2.347864445262447e-14, -2.167771188728504e-17,
  3.015648360096249e-19, -1.300921637568969e-21,  3.756862883060517e-24, -6.799366438017230e-27, -1.866988952593274e-30,  1.925379407193829e-01, -9.471181773987233e-04,
  3.226801816536746e-06, -8.542773524797139e-09,  1.617903541138090e-11, -9.286807552665217e-15, -8.960158709963661e-17,  5.085135304039625e-19, -1.644574380049488e-21,
  3.207445184938924e-24,  3.374772463123850e-28, -3.503421088998718e-29,  2.349602447409796e-01, -1.139989494774338e-03,  3.749436153125843e-06, -9.142538915412577e-09,
  1.346858651285546e-11,  1.183067081920247e-14, -1.696295573574227e-16,  6.820332122831492e-19, -1.598862314270148e-21,  7.980145886746702e-25,  1.290504100179464e-26,
 -7.343271333029278e-29,  2.815006760038464e-01, -1.344574980071136e-03,  4.243492522890610e-06, -9.313446523318101e-09,  8.567204142153639e-12,  3.904930581307736e-14,
 -2.500504181061664e-16,  7.576679897899029e-19, -9.592686270013453e-22, -3.599293805065093e-24,  2.794836061942234e-26, -9.561482937719916e-29,  3.321099125448816e-01,
 -1.558442511068481e-03,  4.686149098848934e-06, -8.953020231710405e-09,  1.373841892591544e-12,  7.038875774777829e-14, -3.144191556709329e-16,  6.670014028152363e-19,
  3.836834110912645e-22, -9.317443699380899e-24,  3.904079630872615e-26, -7.348511603556202e-29,  3.867268888269090e-01, -1.778814846085786e-03,  5.052979494632009e-06,
 -7.970625335165490e-09, -8.010803460734607e-12,  1.025885496604473e-13, -3.428216552269289e-16,  3.537982171522350e-19,  2.353359461787722e-21, -1.467341828142932e-23,
  3.722043779918532e-26,  1.469127605708535e-29,  4.452762559196194e-01, -2.002537770629731e-03,  5.318330903717661e-06, -6.295568734760639e-09, -1.923258112456935e-11,
  1.311064613132316e-13, -3.143988884302822e-16, -2.044326192256041e-19,  4.604516949420755e-21, -1.703885321240732e-23,  1.402312130170735e-26,  1.643064208002547e-28,
  5.076653118852222e-01, -2.226047487458441e-03,  5.455876781388401e-06, -3.886821484891557e-09, -3.163692776709627e-11,  1.503039184207612e-13, -2.113347968204807e-16,
 -9.719218057533045e-19,  6.484497973977580e-21, -1.339427291025244e-23, -3.330109839470296e-26,  3.245105397113207e-28,  5.737802977799497e-01, -2.445339066101732e-03,
  5.439399893261776e-06, -7.443756539626238e-10, -4.423469665900168e-11,  1.538938078390840e-13, -2.431847831887318e-17, -1.832420997699406e-18,  7.085420412627162e-21,
 -1.497817207163213e-24, -9.550611217759967e-26,  3.927943363044975e-28,  6.434819363992913e-01, -2.655938784531190e-03,  5.243873161132696e-06,  3.077974189709400e-09,
 -5.569259911545999e-11,  1.357286110324057e-13,  2.408867024841259e-16, -2.578105924972440e-18,  5.438305565328111e-21,  1.839682211660212e-23, -1.469611109581572e-25,
  2.434428968553013e-28,  7.166000720943222e-01, -2.852884645260784e-03,  4.846916314584628e-06,  7.459013013212382e-09, -6.436464119188077e-11,  9.098991473090248e-14,
  5.567649678740932e-16, -2.922115456141244e-18,  8.826157010879060e-22,  4.171984436407214e-23, -1.480721038124370e-25, -1.958211593842597e-28,  7.929272527547279e-01,
 -3.030721375041655e-03,  4.230712530615163e-06,  1.219684280806061e-08, -6.838570121997880e-11,  1.778757931274494e-14,  8.691789254692311e-16, -2.549322366613533e-18,
 -6.411224074225286e-21,  5.866094226950694e-23, -6.005287670322506e-26, -8.301812207356998e-28,  8.722110832185492e-01, -3.183518986679023e-03,  3.384464886004124e-06,
  1.699807385337373e-08, -6.585194814806272e-11, -8.093484536500392e-14,  1.097367488388195e-15, -1.217071450112265e-18, -1.489946774511980e-20,  5.567912849819648e-23,
  1.257558169231967e-25, -1.309808750189569e-27,  9.541451795245219e-01, -3.304927654091154e-03,  2.307447168885879e-06,  2.147284100055616e-08, -5.511228764808714e-11,
 -1.954881869616850e-13,  1.142916302777122e-15,  1.095355110137269e-18, -2.140011192294916e-20,  2.101939299845530e-23,  3.521683355179333e-25, -1.091529480128900e-27,
  1.038358576410905e+00, -3.388286322910872e-03,  1.012640883755686e-06,  2.514065334109364e-08, -3.518540752101203e-11, -3.081156611800101e-13,  9.120028431009784e-16,
  4.018758082289670e-18, -2.156699856657237e-20, -4.552151093977147e-23,  4.798587026626820e-25,  2.187810582199967e-28,  1.124403503361849e+00, -3.426808052838572e-03,
 -4.691742059595802e-07,  2.745391121621487e-08, -6.290546979790877e-12, -3.932302215509225e-13,  3.531698122161511e-16,  6.684847127962208e-18, -1.157734051596427e-20,
 -1.219402637569799e-22,  3.322701155252320e-25,  2.272060710067335e-27,  1.211741573017365e+00, -3.413871043240937e-03, -2.085227175332776e-06,  2.784740124454897e-08,
  2.957293357998264e-11, -4.205095031869847e-13, -4.933752659259634e-16,  7.806629351946000e-18,  8.904595978729843e-21, -1.614652202220707e-22, -1.678582218995163e-25,
  3.562881516653391e-27,  1.299728656490800e+00, -3.343449286799455e-03, -3.757159667032552e-06,  2.582202910561602e-08,  6.814968215084307e-11, -3.621355251615176e-13,
 -1.451008800078958e-15,  6.097338896836888e-18,  3.354434312229144e-20, -1.109594867635170e-22, -8.149147277250134e-25,  2.062054431990160e-27,  1.387599101189365e+00,
 -3.210718064024720e-03, -5.379224327264764e-06,  2.106734573498775e-08,  1.028263706421138e-10, -2.045853802309645e-13, -2.199037006870707e-15,  1.078309411245091e-18,
  4.869298682251217e-20,  4.381935974997943e-23, -1.073630598456819e-24, -2.569449894633639e-27,  1.474450533523712e+00, -3.012862100448248e-03, -6.820097444544617e-06,
  1.361692986667437e-08,  1.252842943609230e-10,  3.703242426450184e-14, -2.346253826552748e-15, -5.980292000596479e-18,  3.901567189886181e-20,  2.281314532904349e-22,
 -4.265747571318218e-25, -6.685557116372857e-27,  1.559231329176157e+00, -2.750090452647376e-03, -7.930719941238263e-06,  4.010098592933435e-09,  1.272923815788999e-10,
  3.082950868916854e-13, -1.614806833746610e-15, -1.172719698632458e-17,  4.600332567871907e-22,  2.857311963923687e-22,  9.087030351482913e-25, -4.448553020816412e-27,
  1.640733932820186e+00, -2.426811974283289e-03, -8.560781309608024e-06, -6.597886561403987e-09,  1.037539598844913e-10,  5.192064084068599e-13, -9.383316820076943e-17,
 -1.202633061445034e-17, -4.709765322057226e-20,  1.041922245508676e-22,  1.657959298747305e-24,  4.272821341389827e-27,  1.717598466692334e+00, -2.052839094821946e-03,
 -8.585602638807219e-06, -1.646893298317382e-08,  5.638729910025772e-11,  5.734544380125028e-13,  1.602166666375372e-15, -5.148973759673964e-18, -6.514672174302127e-20,
 -2.049103733824044e-22,  6.511825329468645e-25,  9.019325617924037e-27,  1.788332183154498e+00, -1.644364888632749e-03, -7.942379116377764e-06, -2.356261564739982e-08,
 -3.739569740988508e-12,  4.229496653693388e-13,  2.523122268354916e-15,  5.170967001583396e-18, -3.073982645915847e-20, -3.221317207090369e-22, -1.186830015102178e-24,
  1.378464847608000e-27,  1.851350698366698e+00, -1.224321429833605e-03, -6.669416267619373e-06, -2.611647085305001e-08, -5.753993452109892e-11,  1.212173769374248e-13,
  2.024313985019204e-15,  1.100358823869701e-17,  2.703358830732032e-20, -9.075004838554012e-23, -1.370549397839576e-24, -7.470088607540380e-27,  1.905045708578181e+00,
 -8.216382527076165e-04, -4.934940479883614e-06, -2.342524216413523e-08, -8.511251184113013e-11, -1.763677914287404e-13,  4.636188777810480e-16,  7.496864374676329e-18,
  4.705131029892597e-20,  1.833274318028612e-22,  2.437215844153805e-25, -2.937558981812528e-27,  1.947880124434107e+00, -4.689819803418895e-04, -3.036811247218181e-06,
 -1.648922402718591e-08, -7.714818691765587e-11, -3.028604965567112e-13, -8.800268505230566e-16, -6.721878966197775e-19,  1.453613297129739e-20,  1.399044310336199e-22,
  8.470794697552102e-25,  3.822880081444057e-27,  1.978505120794007e+00, -1.988750860248027e-04, -1.357172841734382e-06, -8.049665864434831e-09, -4.346232219943200e-11,
 -2.167252115635511e-13, -9.968196940658819e-16, -4.159973912480075e-18, -1.505394287616192e-20, -4.091507681692494e-23, -2.088298831857436e-26,  7.804175197778239e-28,
  1.995889261249228e+00, -3.863779359484336e-05, -2.715296065578916e-07, -1.689257168507427e-09, -9.802457222590373e-12, -5.427149297223648e-14, -2.899988222031974e-16,
 -1.504948872724014e-18, -7.610386776377195e-21, -3.755829979611296e-23, -1.809105548602609e-25, -8.494748161639975e-28,  5.244683847938729e-04, -2.703123199353678e-06,
  1.044652435270725e-08, -3.587952925840156e-11,  1.154820978698349e-13, -3.567381523455297e-16,  1.070668507915152e-18, -3.147323059019591e-21,  9.096203649547390e-24,
 -2.597549479573960e-26,  7.324319376321681e-29, -2.053383861326578e-31,  4.719974869891168e-03, -2.429947263555747e-05,  9.366589000608473e-08, -3.202321966900148e-10,
  1.023355515453450e-12, -3.128868145140759e-15,  9.259264142577764e-18, -2.671914365031315e-20,  7.540950116845704e-23, -2.090420369159867e-25,  5.680350204520309e-28,
 -1.523001426688006e-30,  1.310968510245748e-02, -6.733894619087344e-05,  2.582208396699573e-07, -8.746573878659666e-10,  2.754479408606841e-12, -8.243288117166977e-15,
  2.367535631027155e-17, -6.560490760985779e-20,  1.753849200157457e-22, -4.525505606413522e-25,  1.116670608990434e-27, -2.631624725352006e-30,  2.569089893307565e-02,
 -1.315126896236237e-04,  5.003342390500355e-07, -1.670752733083073e-09,  5.142617833584006e-12, -1.487057143872203e-14,  4.062677037595303e-17, -1.047595095355393e-19,
  2.520332369568173e-22, -5.540186769164779e-25,  1.041236730974175e-27, -1.391364806223466e-30,  4.245932612576494e-02, -2.163513773591335e-04,  8.143171809787018e-07,
 -2.666324717884387e-09,  7.946059483239762e-12, -2.184236517832140e-14,  5.514284446291868e-17, -1.251771128034020e-19,  2.395392454597823e-22, -3.080037604813297e-25,
 -2.229455159596256e-28,  3.470060375773640e-30,  6.340878888967376e-02, -3.212178619247131e-04,  1.192543236583057e-06, -3.805924097393739e-09,  1.085711519386984e-11,
 -2.774263689699916e-14,  6.163325919570810e-17, -1.078356663475919e-19,  8.374029100889045e-23,  3.996105002183544e-25, -2.738797910275890e-27,  1.092876476159761e-29,
  8.853080907170778e-02, -4.452972140514213e-04,  1.625417857290905e-06, -5.021634071834055e-09,  1.351531376125108e-11, -3.102944263459948e-14,  5.472507413199930e-17,
 -3.838331619250182e-20, -2.357680501638321e-22,  1.503555328874286e-24, -5.782497706583969e-27,  1.703290879695855e-29,  1.178140652673467e-01, -5.875840246961988e-04,
  2.101346621283266e-06, -6.234178847977293e-09,  1.552472470955287e-11, -3.018645950690532e-14,  3.023389372559748e-17,  8.796723715566461e-20, -6.862767746351468e-22,
  2.705567242552495e-24, -7.811700060811200e-27,  1.572039057839441e-29,  1.512437002880433e-01, -7.468668198375760e-04,  2.606707601659361e-06, -7.354441828721412e-09,
  1.647589760568420e-11, -2.390216479687210e-14, -1.379675209076630e-17,  2.620467071052190e-19, -1.170580519867666e-21,  3.484264154585464e-24, -6.806986357294915e-27,
  1.373640802623954e-30,  1.888004537812761e-01, -9.217094301494352e-04,  3.125835226841468e-06, -8.285506952466958e-09,  1.597291790716129e-11, -1.127222516417165e-14,
 -7.608261705383789e-17,  4.577343732640452e-19, -1.529213006421039e-21,  3.192497186502713e-24, -1.028238649722168e-27, -2.725574488891641e-29,  2.304595881012491e-01,
 -1.110429167384407e-03,  3.641025779665080e-06, -8.925363431504309e-09,  1.366600593238299e-11,  7.982973069883227e-15, -1.512439242573044e-16,  6.314227703435849e-19,
 -1.561592203358452e-21,  1.252728372317128e-24,  9.906621508135463e-27, -6.300318524643607e-29,  2.761895675074284e-01, -1.311071697769535e-03,  4.132578352092345e-06,
 -9.170442284724842e-09,  9.289878141640426e-12,  3.329909129333262e-14, -2.292834548900007e-16,  7.251058570861476e-19, -1.069715309453323e-21, -2.563404289677024e-24,
  2.389948431992866e-26, -8.829494157034415e-29,  3.259504411219492e-01, -1.521382585205051e-03,  4.578889890765375e-06, -8.920180191818720e-09,  2.707675103164030e-12,
  6.306789856390750e-14, -2.956195405437996e-16,  6.742073966989947e-19,  7.557093242184761e-23, -7.822036522752001e-24,  3.569732474235136e-26, -7.792382405628792e-29,
  3.796918684727559e-01, -1.738775626035826e-03,  4.956629223400013e-06, -8.082827546920632e-09, -6.040465304592537e-12,  9.448773808329791e-14, -3.319383589240437e-16,
  4.209419891130587e-19,  1.852003222435256e-21, -1.317902500943808e-23,  3.732747954904919e-26, -8.898702104199676e-30,  4.373507125423967e-01, -1.960298345351561e-03,
  5.241022948743780e-06, -6.582724628959097e-09, -1.668628762544921e-11,  1.235082859901979e-13, -3.181515424754268e-16, -6.678082062806486e-20,  4.002841400815635e-21,
 -1.634598805644767e-23,  2.031568337493009e-26,  1.225125347808415e-28,  4.988481087157772e-01, -2.182595419255677e-03,  5.406296062133307e-06, -4.369248119423732e-09,
 -2.868365480824430e-11,  1.449283114541060e-13, -2.357177169486575e-16, -7.723628857342949e-19,  5.981652988388533e-21, -1.445345360837134e-23, -1.997506867366504e-26,
  2.810027463108502e-28,  5.640858986632020e-01, -2.401871395196696e-03,  5.426322275169678e-06, -1.427556487137168e-09, -4.116668076024140e-11,  1.527200164352295e-13,
 -7.246516560797530e-17, -1.607253926860126e-18,  6.966877724282431e-21, -4.975006177529747e-24, -7.844035688737031e-26,  3.808988868990504e-28,  6.329422960462491e-01,
 -2.613854996640089e-03,  5.275552894089137e-06,  2.208899115556331e-09, -5.292595714856885e-11,  1.406638851437318e-13,  1.712276993434013e-16, -2.394596023668886e-18,
  5.997532450565888e-21,  1.275116102482090e-23, -1.349028636913463e-25,  3.010126973823552e-28,  7.052666265313967e-01, -2.813768646418111e-03,  4.930307794473832e-06,
  6.444435418266065e-09, -6.241782442954645e-11,  1.033749812351439e-13,  4.755586998883875e-16, -2.870998525141140e-18,  2.276230797063541e-21,  3.566710441261271e-23,
 -1.535482998252044e-25, -5.629501620776690e-29,  7.808729593997685e-01, -2.996308792973973e-03,  4.370524960946060e-06,  1.110662634872545e-08, -6.782724015325619e-11,
  3.777005123051517e-14,  7.952394392373167e-16, -2.721224930518888e-18, -4.351020380846029e-21,  5.557791979993078e-23, -9.285661169153240e-26, -6.598645796337662e-28,
  8.595324251259170e-01, -3.155645385561370e-03,  3.582071169565297e-06,  1.593291154316928e-08, -6.721030764054239e-11, -5.505895408037753e-14,  1.056922134960781e-15,
 -1.660924178707258e-18, -1.281821470346008e-20,  5.957387379878611e-23,  6.949742012911750e-26, -1.239144599928011e-27,  9.409639984561524e-01, -3.285452658327387e-03,
  2.559706311915785e-06,  2.056126569659636e-08, -5.874566382123882e-11, -1.677667451874673e-13,  1.164131573642535e-15,  4.252798077630605e-19, -2.040198189557435e-20,
  3.408575977345628e-23,  2.998102625050819e-25, -1.275453695000732e-27,  1.024823529944353e+00, -3.378988475336436e-03,  1.310751521809102e-06,  2.452961440410115e-08,
 -4.112013450524049e-11, -2.849566579695029e-13,  1.014646170551389e-15,  3.306108632428756e-18, -2.285923646654607e-20, -2.627491262059801e-23,  4.790651634231982e-25,
 -2.484674360007847e-28,  1.110690847660998e+00, -3.429245964181815e-03, -1.405890320703390e-07,  2.729086899808563e-08, -1.405546264335653e-11, -3.825538609013783e-13,
  5.345183244270614e-16,  6.246887371108896e-18, -1.570507779675392e-20, -1.067848205591236e-22,  4.220040574275295e-25,  1.792355349497120e-27,  1.198054852120583e+00,
 -3.429208784529162e-03, -1.748498774754081e-06,  2.825271812920223e-08,  2.106218236094591e-11, -4.297006927640987e-13, -2.716816872206928e-16,  7.997585291785674e-18,
  3.009067840028288e-21, -1.650145280917493e-22, -9.244204986941270e-27,  3.612713895666814e-27,  1.286296732691777e+00, -3.372249132467169e-03, -3.440997923036711e-06,
  2.685265040001536e-08,  6.057316871021820e-11, -3.947936453207660e-13, -1.265899699655925e-15,  7.100748457943645e-18,  2.898749321102764e-20, -1.414615199592008e-22,
 -7.034792813261940e-25,  2.981913987996265e-27,  1.374671801514253e+00, -3.252712986810877e-03, -5.116689126237053e-06,  2.267697990916095e-08,  9.821025482570247e-11,
 -2.568227264266070e-13, -2.146853010679011e-15,  2.653235327006823e-18,  4.947327693465848e-20, -1.048520104580544e-24, -1.161003680552046e-24, -1.367927729069955e-27,
  1.462291046607487e+00, -3.066735153903126e-03, -6.644652612301668e-06,  1.562428995108014e-08,  1.254490394777332e-10, -2.113850848826962e-14, -2.495015158828892e-15,
 -4.604257898389024e-18,  4.685002109178912e-20,  2.051522101169599e-22, -7.224217679604694e-25, -6.689393222408528e-27,  1.548104430094191e+00, -2.813308649542866e-03,
 -7.870182340383543e-06,  6.093886715104666e-09,  1.330441822047697e-10,  2.656107934620231e-13, -1.941368240612167e-15, -1.154129515648468e-17,  1.134847308193483e-20,
  3.176184623114104e-22,  6.722242188096961e-25, -6.290777037188912e-27,  1.630889251863022e+00, -2.495585914419914e-03, -8.629653608416430e-06, -4.854990042062910e-09,
  1.140874286154573e-10,  5.127471922870465e-13, -4.510130218100610e-16, -1.346029826676913e-17, -4.211149347275034e-20,  1.738448884222592e-22,  1.813062447122834e-24,
  2.678407880980531e-27,  1.709248511850625e+00, -2.122298202406811e-03, -8.777431550734847e-06, -1.547294760394196e-08,  6.822798431950516e-11,  6.099341955446860e-13,
  1.427741152590640e-15, -7.345869400102067e-18, -7.195530651836836e-20, -1.705244838316027e-22,  1.077469959207266e-24,  1.030079836339868e-26,  1.781625854214127e+00,
 -1.709035279782641e-03, -8.225199569006926e-06, -2.355143957797928e-08,  5.336079545713187e-12,  4.851198501684874e-13,  2.652330072439441e-15,  3.992738478991922e-18,
 -4.317071734263961e-20, -3.677519395399799e-22, -1.077292392327904e-24,  3.697428439138753e-27,  1.846344695305128e+00, -1.278945799510225e-03, -6.988248907032041e-06,
 -2.701496884928520e-08, -5.460430452371011e-11,  1.735924585267726e-13,  2.343955140810941e-15,  1.180515447141385e-17,  2.269862142867270e-20, -1.523564777203723e-22,
 -1.714442171162317e-24, -8.108278759049888e-27,  1.901678383170017e+00, -8.622656025580114e-04, -5.224328428857469e-06, -2.481458213138138e-08, -8.851069085461102e-11,
 -1.625456956807095e-13,  6.956140519364376e-16,  9.109704277168835e-18,  5.379123082197435e-20,  1.900239282842317e-22,  7.871648915141371e-26, -4.639427579943734e-27,
  1.945954324110496e+00, -4.940894052110388e-04, -3.242291781723301e-06, -1.777320564393621e-08, -8.341783553720811e-11, -3.241495375375067e-13, -8.915301845307943e-16,
 -1.195684859918415e-19,  2.022460773200519e-20,  1.773140880458621e-22,  1.027386256772199e-24,  4.368826997717929e-27,  1.977687276775103e+00, -2.101310125398423e-04,
 -1.458088574849701e-06, -8.781079506130328e-09, -4.804578509687379e-11, -2.421024354871972e-13, -1.120265289109048e-15, -4.665354311763681e-18, -1.653258316405892e-20,
 -4.094488493998751e-23,  2.259462368397775e-26,  1.220801841242665e-27,  1.995730233341511e+00, -4.089386608249664e-05, -2.927788129882488e-07, -1.855172920128001e-09,
 -1.096104773575963e-11, -6.176594782973569e-14, -3.357605068957611e-16, -1.771587984450668e-18, -9.102272412192500e-21, -4.560039980349147e-23, -2.227177351338928e-25,
 -1.058804424878536e-27,  5.138203531833478e-04, -2.621242344123480e-06,  1.002682527785778e-08, -3.408752702674856e-11,  1.085973235316226e-13, -3.320675610930395e-16,
  9.864819133771344e-19, -2.870658193779416e-21,  8.211714446550788e-24, -2.321872899859271e-26,  6.477986922070280e-29, -1.799603667733153e-31,  4.624251682737651e-03,
 -2.356524298692804e-05,  8.991931915004411e-08, -3.043473028134852e-10,  9.629411572329858e-13, -2.915357557205779e-15,  8.543810763069769e-18, -2.442219038185043e-20,
  6.827732150463309e-23, -1.876064940315003e-25,  5.050438608981767e-28, -1.344220312503246e-30,  1.284439541861671e-02, -6.531442614200760e-05,  2.479840387938768e-07,
 -8.318743841010588e-10,  2.595150154665332e-12, -7.696503373758696e-15,  2.191460231079720e-17, -6.024486034874962e-20,  1.598699148628067e-22, -4.101211083869547e-25,
  1.006694057740426e-27, -2.371810935717750e-30,  2.517272849059047e-02, -1.275888353143249e-04,  4.807692519093479e-07, -1.590798143014825e-09,  4.854723867963314e-12,
 -1.392983493717917e-14,  3.780347326397406e-17, -9.700564253982669e-20,  2.328234380172490e-22, -5.136001156218802e-25,  9.795814780752725e-28, -1.406583348330886e-30,
  4.160675005864160e-02, -2.099626949086613e-04,  7.830699198179567e-07, -2.542611814546308e-09,  7.522166993484412e-12, -2.056014054703322e-14,  5.174352136132091e-17,
 -1.176907032959889e-19,  2.283253150245103e-22, -3.140933924180174e-25, -8.686851898174589e-29,  2.737534292045021e-30,  6.214271299771638e-02, -3.118572889051159e-04,
  1.147896377879928e-06, -3.636569727410092e-09,  1.031681148551195e-11, -2.629935609583763e-14,  5.865339344179093e-17, -1.049460333219221e-19,  9.626583161130427e-23,
  2.991966810979328e-25, -2.293362010096925e-27,  9.353656392790923e-30,  8.677525038530852e-02, -4.325312801661953e-04,  1.566435469242567e-06, -4.810282781101073e-09,
  1.290776767349478e-11, -2.972974173300176e-14,  5.355254449417686e-17, -4.510505364495309e-20, -1.856278115367042e-22,  1.286700213380280e-24, -5.073485511494673e-27,
  1.521687021037510e-29,  1.154968828182381e-01, -5.710683152088112e-04,  2.028007055507548e-06, -5.990572867214790e-09,  1.492843871262456e-11, -2.943368276740023e-14,
  3.240374473454629e-17,  6.750582417785184e-20, -5.943355510717597e-22,  2.406768436019152e-24, -7.132698169666648e-27,  1.510950276750398e-29,  1.482973876714528e-01,
 -7.263617272240264e-04,  2.520020158814842e-06, -7.094667384365445e-09,  1.599511602036234e-11, -2.414935794703779e-14, -6.965381266253598e-18,  2.265426819599658e-19,
 -1.050026380666653e-21,  3.213961818952915e-24, -6.690469073737004e-27,  3.800797637723600e-30,  1.851630058360043e-01, -8.970961257918703e-04,  3.027934794159430e-06,
 -8.031838774207759e-09,  1.573022358883688e-11, -1.294983300266594e-14, -6.393393381235115e-17,  4.106282739020530e-19, -1.415293967534769e-21,  3.129396832787748e-24,
 -2.079036010706058e-27, -2.069858649768681e-29,  2.260754547787313e-01, -1.081725650555971e-03,  3.535238001145656e-06, -8.705621372858936e-09,  1.379076992213201e-11,
  4.559674495145093e-15, -1.342563855217352e-16,  5.822446212452078e-19, -1.510003052097760e-21,  1.596419903173091e-24,  7.347271394945324e-27, -5.348678009648599e-29,
  2.710107086480092e-01, -1.278448676629493e-03,  4.023445900575856e-06, -9.016768533089201e-09,  9.902456149162661e-12,  2.803597699512497e-14, -2.094723244083566e-16,
  6.895754880497214e-19, -1.145705677572129e-21, -1.682830072064023e-24,  2.018671171875274e-26, -8.040826214500470e-29,  3.199374962487059e-01, -1.485178804849916e-03,
  4.472148058931805e-06, -8.867145594144755e-09,  3.899613830575269e-12,  5.619958603433450e-14, -2.767482847844187e-16,  6.723890104125299e-19, -1.811524609048569e-22,
 -6.463319075463787e-24,  3.222859972214618e-26, -7.930077436692115e-29,  3.728154556075906e-01, -1.699512070147895e-03,  4.859116379194764e-06, -8.164785678982472e-09,
 -4.229388265257885e-12,  8.666892271120813e-14, -3.193915623338389e-16,  4.729020252336059e-19,  1.404286796009806e-21, -1.169949974882221e-23,  3.651576568218073e-26,
 -2.717230319287354e-29,  4.295928690776767e-01, -1.918690486178943e-03,  5.160508540055558e-06, -6.830359157070157e-09, -1.429255721574897e-11,  1.158641470124087e-13,
 -3.183154210883836e-16,  5.206151830831026e-20,  3.430209563673697e-21, -1.543675492643790e-23,  2.487785338014824e-26,  8.570210133635072e-29,  4.902038849862462e-01,
 -2.139562358363364e-03,  5.351206091685088e-06, -4.805312412384789e-09, -2.584330282350677e-11,  1.390327162664887e-13, -2.547432824646949e-16, -5.894059775777351e-19,
  5.449808504310548e-21, -1.501811298199317e-23, -8.577274530732172e-27,  2.371793010830204e-28,  5.545651102417066e-01, -2.358540305597520e-03,  5.405340044367174e-06,
 -2.061897521393052e-09, -3.813318790468117e-11,  1.504658210377558e-13, -1.143781682340209e-16, -1.387752565141589e-18,  6.735286352877087e-21, -7.783401212315953e-24,
 -6.214399459228284e-26,  3.583481031271641e-28,  6.225714327423411e-01, -2.571558727042003e-03,  5.297072291681703e-06,  1.384790902415109e-09, -5.007690199334022e-11,
  1.439908403174211e-13,  1.069276432621381e-16, -2.196345101616775e-18,  6.362749833910747e-21,  7.632139396691314e-24, -1.207824011711519e-25,  3.375496007401516e-28,
  6.940909028911570e-01, -2.774033667786626e-03,  5.001719070303733e-06,  5.462883183889535e-09, -6.024265472331148e-11,  1.138331093498122e-13,  3.963750545289882e-16,
 -2.778802907685675e-18,  3.449430402611683e-21,  2.951218325063990e-23, -1.533321742330300e-25,  6.252447263118798e-29,  7.689584707692100e-01, -2.960829860212925e-03,
  4.497321277986492e-06,  1.002844454099148e-08, -6.688722696578953e-11,  5.592755467059923e-14,  7.173912469485050e-16, -2.829215303203420e-18, -2.423606672247187e-21,
  5.133375260759159e-23, -1.180991280453495e-25, -4.880138423631366e-28,  8.469683417157454e-01, -3.126242392471619e-03,  3.766781998923574e-06,  1.485009879437785e-08,
 -6.806182346193686e-11, -3.029524579044744e-14,  1.004999327795514e-15, -2.036360824419913e-18, -1.063637990587091e-20,  6.129432238336583e-23,  1.736281821851418e-26,
 -1.124307338865172e-27,  9.278646828979288e-01, -3.264004291027351e-03,  2.800696115688598e-06,  1.959601316050214e-08, -6.182101878105299e-11, -1.397572531539633e-13,
  1.167099646789300e-15, -2.057477587485008e-19, -1.897290069440948e-20,  4.491902025335567e-23,  2.410825195578213e-25, -1.381267675837759e-27,  1.011330395967878e+00,
 -3.367336650735005e-03,  1.600975658613718e-06,  2.382745226247219e-08, -4.656868475215802e-11, -2.595776988298085e-13,  1.096860280496464e-15,  2.563148026332373e-18,
 -2.346400600858564e-20, -7.458069533051329e-24,  4.587379403836677e-25, -6.654202993292507e-28,  1.096973682327926e+00, -3.429065114474789e-03,  1.853020036877126e-07,
  2.700552839428333e-08, -2.156439565677292e-11, -3.676866884861431e-13,  7.018414511631734e-16,  5.686219591543483e-18, -1.922791130228912e-20, -8.848512258803665e-23,
  4.889811980715774e-25,  1.243816964599834e-27,  1.184312195432969e+00, -3.441835570411582e-03, -1.407728729386591e-06,  2.852068292572447e-08,  1.242113638027708e-11,
 -4.335284677326419e-13, -4.729301057409457e-17,  7.999065084424008e-18, -2.900057369526145e-21, -1.622360263086242e-22,  1.470440518200125e-25,  3.458470214701747e-27,
  1.272754743452408e+00, -3.398472323198362e-03, -3.113216815897512e-06,  2.775707280573811e-08,  5.239010543763821e-11, -4.226894609739015e-13, -1.054895097406846e-15,
  7.941706621296206e-18,  2.342217536589738e-20, -1.667395872074110e-22, -5.548949348492201e-25,  3.740157215607644e-27,  1.361580843166785e+00, -3.292531700016041e-03,
 -4.835315677413906e-06,  2.420448132753882e-08,  9.256549634574042e-11, -3.072771740535710e-13, -2.050468537070626e-15,  4.226718914622647e-18,  4.858866608368649e-20,
 -4.829908893971436e-23, -1.191556376579375e-24, -7.851605899566086e-31,  1.449919027099307e+00, -3.119108340218390e-03, -6.445142627700779e-06,  1.762479822226327e-08,
  1.244179269327565e-10, -8.238988265112650e-14, -2.601878358038932e-15, -2.993037030956856e-18,  5.364527318408098e-20,  1.704687934241822e-22, -1.008416619417592e-24,
 -6.231563727189280e-27,  1.536725787313834e+00, -2.875941026946929e-03, -7.784116653662543e-06,  8.262450815322500e-09,  1.378645515837104e-10,  2.151918534095695e-13,
 -2.257687728127233e-15, -1.099057880757705e-17,  2.319530369120041e-20,  3.384551160888407e-22,  3.572095981935197e-25, -7.990305336295702e-27,  1.620768509599880e+00,
 -2.564824376120973e-03, -8.676624944258855e-06, -2.948270557062982e-09,  1.242028407781658e-10,  4.972542326463869e-13, -8.457255196786926e-16, -1.469353925183630e-17,
 -3.452467559283332e-20,  2.481224828665221e-22,  1.884873540863108e-24,  4.901869496763171e-28,  1.700617731628813e+00, -2.193240859456594e-03, -8.956148650641633e-06,
 -1.428192329242838e-08,  8.075129805866819e-11,  6.414662280486300e-13,  1.188962480349931e-15, -9.737438973768928e-18, -7.720652438566402e-20, -1.180768555442755e-22,
  1.550959974116963e-24,  1.112746043424790e-26,  1.774656323042241e+00, -1.775965133991338e-03, -8.506973101012380e-06, -2.338494944796366e-08,  1.568323155761670e-11,
  5.499487052356375e-13,  2.742738777880328e-15,  2.391499752316757e-18, -5.713890630216494e-20, -4.067774208164478e-22, -8.528498929220168e-25,  6.597906716408797e-27,
  1.841115026392470e+00, -1.336163077359836e-03, -7.317545764089416e-06, -2.785769261873204e-08, -5.054273112263959e-11,  2.338904334295214e-13,  2.683745456550978e-15,
  1.242981297978102e-17,  1.589242787943315e-20, -2.281702176199618e-22, -2.077814039397749e-24, -8.319873353508757e-27,  1.898143811290800e+00, -9.052756455702493e-04,
 -5.530704537078777e-06, -2.625576311073248e-08, -9.157296446754646e-11, -1.425892565648211e-13,  9.758144977385158e-16,  1.094065009287895e-17,  6.063408875302222e-20,
  1.884803443867789e-22, -1.719242190750642e-25, -6.841043910623552e-27,  1.943924706365957e+00, -5.209040432473772e-04, -3.463796065952653e-06, -1.916091723806336e-08,
 -9.011466066393942e-11, -3.455071135742897e-13, -8.847990840348583e-16,  6.380684039998340e-19,  2.739533888589515e-20,  2.224043637526702e-22,  1.230686360844663e-24,
  4.856006295319839e-27,  1.976822736998719e+00, -2.222306591200019e-04, -1.568238567882800e-06, -9.590054790371544e-09, -5.316759320850514e-11, -2.706174962707388e-13,
 -1.258521501202594e-15, -5.217692000292491e-18, -1.797588942139374e-20, -3.879972043725420e-23,  8.915611396563005e-26,  1.838608223407667e-27,  1.995561828086522e+00,
 -4.332822310656341e-05, -3.161353799420493e-07, -2.040887544976642e-09, -1.228114394696878e-11, -7.045394803369968e-14, -3.897023850760420e-16, -2.090941340204484e-18,
 -1.091613049696916e-20, -5.551410376094442e-23, -2.748872944694006e-25, -1.322628391702763e-27,  5.034932634055192e-04, -2.542634901244662e-06,  9.627985225498338e-09,
 -3.240184109176578e-11,  1.021863675631486e-13, -3.093275976096701e-16,  9.096601500391707e-19, -2.620772301379147e-21,  7.420634830508148e-24, -2.077919918022395e-26,
  5.735668722684326e-29, -1.579760504537136e-31,  4.531406653518148e-03, -2.286023954436481e-05,  8.635770519569661e-08, -2.893957885136525e-10,  9.066303811276199e-13,
 -2.718271168023353e-15,  7.889589487781276e-18, -2.234159131114967e-20,  6.187330051192603e-23, -1.685401481692272e-25,  4.494105834341163e-28, -1.188044528688797e-30,
  1.258704321756051e-02, -6.336978943708175e-05,  2.382456919321372e-07, -7.915554088273981e-10,  2.446345887155267e-12, -7.190230471152925e-15,  2.029720261458806e-17,
 -5.535768102058090e-20,  1.458058699846055e-22, -3.718699540652277e-25,  9.075647732495376e-28, -2.138215798827573e-30,  2.466994639340135e-02, -1.238177399826249e-04,
  4.621366911879860e-07, -1.515302947551543e-09,  4.584984273487495e-12, -1.305432040220432e-14,  3.518889378440099e-17, -8.984368484460863e-20,  2.150242238276031e-22,
 -4.756536139955596e-25,  9.178062933040140e-28, -1.398086629362823e-30,  4.077923800708123e-02, -2.038181657063388e-04,  7.532673519207433e-07, -2.425480397281786e-09,
  7.123119927693567e-12, -1.935702495268666e-14,  4.854876806392580e-17, -1.105656574119917e-19,  2.169827147863497e-22, -3.153465387073279e-25,  1.977898922904635e-29,
  2.128661580008120e-30,  6.091337771441434e-02, -3.028459065393121e-04,  1.105230842516012e-06, -3.475633149294356e-09,  9.804664999424483e-12, -2.492657908422813e-14,
  5.575952916503602e-17, -1.017101144574449e-19,  1.054810459573507e-22,  2.152753200195300e-25, -1.912709045283885e-27,  7.979852156424761e-30,  8.506982754823349e-02,
 -4.202272238106298e-04,  1.509931824941239e-06, -4.608445865426090e-09,  1.232591985886756e-11, -2.846026576099496e-14,  5.221313354506160e-17, -5.034189237237507e-20,
 -1.428027667169721e-22,  1.096646929160119e-24, -4.441424445951000e-27,  1.353552577560536e-29,  1.132446080606379e-01, -5.551277901886836e-04,  1.957534023525257e-06,
 -5.756384377575886e-09,  1.434768428494237e-11, -2.863538193217543e-14,  3.404028580005046e-17,  4.981960816183964e-20, -5.126691923243640e-22,  2.134536937501920e-24,
 -6.484579417603586e-27,  1.432744355665934e-29,  1.454317279840441e-01, -7.065377960719999e-04,  2.436403719073733e-06, -6.842616418441442e-09,  1.551095179280008e-11,
 -2.424410058033559e-14, -1.075570206827769e-18,  1.947417909370871e-19, -9.390953996380563e-22,  2.950248858082591e-24, -6.482405456970559e-27,  5.556527387002070e-30,
  1.816224638835919e-01, -8.732539172852965e-04,  2.933054023849261e-06, -7.782306721481531e-09,  1.545678808008688e-11, -1.435129053690140e-14, -5.305358178846687e-17,
  3.671236701720686e-19, -1.304336613409391e-21,  3.029703920463799e-24, -2.865826353006669e-27, -1.523435438371955e-29,  2.218044596606949e-01, -1.053857859462877e-03,
  3.432096915780458e-06, -8.484409131079184e-09,  1.385103442374460e-11,  1.527750284459104e-15, -1.186209991678041e-16,  5.348963353912171e-19, -1.447785377348799e-21,
  1.845831218230565e-24,  5.185616532926954e-27, -4.493002912011258e-29,  2.659606076580230e-01, -1.246691179974080e-03,  3.916212950659178e-06, -8.854110140734312e-09,
  1.041444465967206e-11,  2.323614512688260e-14, -1.906855226703063e-16,  6.520926593686238e-19, -1.192584173230974e-21, -9.437471951980990e-25,  1.682626681148567e-26,
 -7.233486374553820e-29,  3.140676631023449e-01, -1.449826099561537e-03,  4.366152614927809e-06, -8.796114332162471e-09,  4.958706675327805e-12,  4.978268859029783e-14,
 -2.580357939229350e-16,  6.631112451550586e-19, -3.914672543827384e-22, -5.243818930039056e-24,  2.875366716262939e-26, -7.831369878844882e-29,  3.660945312115730e-01,
 -1.661032070166954e-03,  4.760788794662912e-06, -8.219000761691055e-09, -2.571566615838898e-12,  7.916711904036717e-14, -3.055825078617837e-16,  5.113795892539381e-19,
  1.009068119029577e-21, -1.026710015694143e-23,  3.500524328557253e-26, -4.077156111284739e-29,  4.220001509027627e-01, -1.877737989253521e-03,  5.077247272327903e-06,
 -7.040916180035155e-09, -1.205148995070896e-11,  1.082539667642177e-13, -3.154030993079392e-16,  1.531354989689422e-19,  2.893218291194781e-21, -1.437591753169449e-23,
  2.793335368800534e-26,  5.403057802485143e-29,  4.817308799985588e-01, -2.096990184858942e-03,  5.291152056730378e-06, -5.196897471217804e-09, -2.312502393963554e-11,
  1.327400421479057e-13, -2.688867712546612e-16, -4.237091018387631e-19,  4.905380480037102e-21, -1.516513041750809e-23,  9.169921839122054e-28,  1.947166995134107e-28,
  5.452172634129057e-01, -2.315406700875506e-03,  5.377035277329126e-06, -2.648115922345053e-09, -3.515434495679560e-11,  1.472785396289957e-13, -1.502631997357037e-16,
 -1.177156046454679e-18,  6.414064332497917e-21, -9.962235568914407e-24, -4.701766282363697e-26,  3.281937384833393e-28,  6.123700372949924e-01, -2.529129079992724e-03,
  5.308977829407874e-06,  6.067179462787012e-10, -4.717628399797802e-11,  1.458423607707695e-13,  4.831531995871913e-17, -1.989243967197184e-18,  6.554184815004968e-21,
  3.104438247019137e-24, -1.054718143774758e-25,  3.555601553962424e-28,  6.830751880032706e-01, -2.733773906579422e-03,  5.061567106081959e-06,  4.517704661244063e-09,
 -5.787709637304663e-11,  1.224258455615111e-13,  3.202652386695216e-16, -2.652598630517736e-18,  4.402409353796476e-21,  2.346396641011272e-23, -1.483757131507954e-25,
  1.590379032259181e-28,  7.571878450654671e-01, -2.924388027023463e-03,  4.611281307210343e-06,  8.968105726212603e-09, -6.560295680161574e-11,  7.218723847827465e-14,
  6.373585320849462e-16, -2.878153236524414e-18, -6.653476496687237e-22,  4.622964589185471e-23, -1.359036686763891e-25, -3.230097079248917e-28,  8.345247430795030e-01,
 -3.095413882187468e-03,  3.938433445080186e-06,  1.375755284680820e-08, -6.843133711616712e-11, -6.895898974781523e-15,  9.435482585090588e-16, -2.341379738343571e-18,
 -8.428832458065179e-21,  6.104077892034230e-23, -2.896841043616048e-26, -9.773728742683279e-28,  9.148549421617633e-01, -3.240675131345272e-03,  3.029826137573285e-06,
  1.858603442418571e-08, -6.433687455700060e-11, -1.118830411220315e-13,  1.153094527551183e-15, -7.852659097628600e-19, -1.719702411211206e-20,  5.333238811191791e-23,
  1.793583373680383e-25, -1.412634589643217e-27,  9.978884574711250e-01, -3.353398179590314e-03,  1.882267866877282e-06,  2.304227405317939e-08, -5.149161813360783e-11,
 -2.324768032166100e-13,  1.158101072345586e-15,  1.811481616738470e-18, -2.341025265989821e-20,  1.019806372138597e-23,  4.215371641080502e-25, -1.012801727471231e-27,
  1.083262430112483e+00, -3.426292851272200e-03,  5.070585986190976e-07,  2.660263624043916e-08, -2.873716245407562e-11, -3.490042579452153e-13,  8.519900977986284e-16,
  5.023830857862894e-18, -2.204966156673895e-20, -6.800088915479618e-23,  5.310069927422543e-25,  6.645358637981203e-28,  1.170524500964435e+00, -3.451725687904019e-03,
 -1.064574226272179e-06,  2.865007077666309e-08,  3.757281657128321e-12, -4.319916494797684e-13,  1.745133576663227e-16,  7.814243111009625e-18, -8.598787249593647e-21,
 -1.533988383131225e-22,  2.923159198516473e-25,  3.115775209899510e-27,  1.259113171488032e+00, -3.422032119165946e-03, -2.775385712937933e-06,  2.852638565210736e-08,
  4.370156683121280e-11, -4.452595267078681e-13, -8.229651952098489e-16,  8.591223219412899e-18,  1.706132293106033e-20, -1.854676413374703e-22, -3.775687592809254e-25,
  4.280358107905756e-27,  1.348335225764206e+00, -3.330027716736969e-03, -4.536186960444854e-06,  2.563373448579686e-08,  8.593832662515062e-11, -3.548944798085608e-13,
 -1.910679539668847e-15,  5.744562259653034e-18,  4.599580521200138e-20, -9.554030785637603e-23, -1.160015318594521e-24,  1.437675969106796e-27,  1.437340858524507e+00,
 -3.169789796651981e-03, -6.221766365005635e-06,  1.959888488860217e-08,  1.221399157956531e-10, -1.456412632666373e-13, -2.660786278139449e-15, -1.186505780830444e-18,
  5.899214537629560e-20,  1.248895952718654e-22, -1.263718273393387e-24, -5.294917437893634e-27,  1.525098158632363e+00, -2.937779555927403e-03, -7.671600038714362e-06,
  1.049966733610496e-08,  1.416020985159848e-10,  1.574097271142179e-13, -2.553185173157356e-15, -1.005133556098709e-17,  3.554813423799244e-20,  3.452764177273019e-22,
 -2.622035320165560e-26, -9.370870000153526e-27,  1.610370210708231e+00, -2.634344361530859e-03, -8.699756490154145e-06, -8.827092711869352e-10,  1.339110180818202e-10,
  4.719037237613285e-13, -1.271165067890802e-15, -1.564086210325984e-17, -2.423687730271123e-20,  3.231818222960187e-22,  1.848214973018093e-24, -2.237061305690405e-27,
  1.691700416692506e+00, -2.265552632005927e-03, -9.119351481131470e-06, -1.288581528900331e-08,  9.384243123637545e-11,  6.664468935085228e-13,  8.811775814048750e-16,
 -1.226312198217181e-17, -8.022160980891591e-20, -4.614799472461404e-23,  2.046498040740053e-24,  1.126296233081153e-26,  1.767414580834349e+00, -1.845138271278115e-03,
 -8.785712299807699e-06, -2.304243054446859e-08,  2.734476085059068e-11,  6.163576142159037e-13,  2.781857691555077e-15,  3.227923621554858e-19, -7.231818291838963e-20,
 -4.341120878945393e-22, -4.889426040310084e-25,  1.001987614708657e-26,  1.835651157255836e+00, -1.396053981499639e-03, -7.656524148285683e-06, -2.862533498052397e-08,
 -4.519237008412230e-11,  3.025260275467572e-13,  3.037546676366569e-15,  1.279019140320348e-17,  6.094651124985506e-21, -3.185275184082458e-22, -2.436755475846686e-24,
 -7.862768482778645e-27,  1.894432186559226e+00, -9.508066742777021e-04, -5.854654391807311e-06, -2.774236418185265e-08, -9.416458121218771e-11, -1.152681905728156e-13,
  1.310323733434242e-15,  1.298754431045679e-17,  6.721611802667381e-20,  1.748135546955948e-22, -5.314847241222037e-25, -9.596875502808725e-27,  1.941784177920379e+00,
 -5.495591796192207e-04, -3.702609831218020e-06, -2.065917877005942e-08, -9.723516294783672e-11, -3.664210908429763e-13, -8.533862117912383e-16,  1.652750065410817e-18,
  3.634054463662212e-20,  2.760189954795956e-22,  1.452508028651437e-24,  5.191936575559561e-27,  1.975907972728578e+00, -2.352517741305586e-04, -1.688607376430930e-06,
 -1.048572705127022e-08, -5.889416332694006e-11, -3.026414194886850e-13, -1.412874169973008e-15, -5.814409025097428e-18, -1.928690698582990e-20, -3.338296522740188e-23,
  1.879185357580435e-25,  2.696221215178105e-27,  1.995383297059131e+00, -4.595871971276697e-05, -3.418532221615326e-07, -2.249187292061908e-09, -1.378870585750194e-11,
 -8.055075970382365e-14, -4.534554270289291e-16, -2.474475028063768e-18, -1.312741406692689e-20, -6.776592037154548e-23, -3.401264423594547e-25, -1.655586058755301e-27,
  4.934743476534574e-04, -2.467138975714349e-06,  9.248772642844853e-09, -3.081518990523193e-11,  9.621232593568957e-14, -2.883501761849498e-16,  8.394935928759021e-19,
 -2.394851256507312e-21,  6.712258527728423e-24, -1.861814383778543e-26,  5.083481408618841e-29, -1.389216870878610e-31,  4.441325767325473e-03, -2.218302636315565e-05,
  8.297023094516225e-08, -2.753145465151221e-10,  8.541089214566403e-13, -2.536209545906233e-15,  7.290856186135253e-18, -2.045535510808606e-20,  5.611721305734167e-23,
 -1.515677056262644e-25,  4.002048356895144e-28, -1.051627412553521e-30,  1.233731675787309e-02, -6.150116391493793e-05,  2.289772149971778e-07, -7.535383616316584e-10,
  2.307289728365389e-12, -6.721182679072567e-15,  1.881054492092270e-17, -5.089926407478797e-20,  1.330499042726266e-22, -3.373856662360590e-25,  8.181746222741218e-28,
 -1.928804136389106e-30,  2.418195619234937e-02, -1.201921534275181e-04,  4.443847447902675e-07, -1.443986845646029e-09,  4.332143386618770e-12, -1.223921247368586e-14,
  3.276707704457393e-17, -8.322992066030976e-20,  1.985467455255606e-22, -4.401652586337046e-25,  8.567958143098162e-28, -1.372868577132254e-30,  3.997583598237479e-02,
 -1.979065414779638e-04,  7.248328332576024e-07, -2.314545333440843e-09,  6.747384380558067e-12, -1.822823045041387e-14,  4.554843336020806e-17, -1.038035237078104e-19,
  2.056656219283517e-22, -3.128379212609972e-25,  1.019681371644415e-28,  1.622597356866038e-30,  5.971941734924574e-02, -2.941682607422549e-04,  1.064448273921506e-06,
 -3.322675012862468e-09,  9.319287025948066e-12, -2.362213691367145e-14,  5.295996513244299e-17, -9.822482378465896e-20,  1.119350856110786e-22,  1.454248210306665e-25,
 -1.588533594628627e-27,  6.782547607555397e-30,  8.341273199697739e-02, -4.083656647821085e-04,  1.455795198304590e-06, -4.415717192369456e-09,  1.176912900201366e-11,
 -2.722454652523477e-14,  5.074528212552643e-17, -5.431306316670020e-20, -1.063820228665106e-22,  9.304362630937648e-25, -3.880374870580619e-27,  1.198862733432412e-29,
  1.110549854115384e-01, -5.397399651156485e-04,  1.889816034337362e-06, -5.531358259770830e-09,  1.378325001988226e-11, -2.780346025273879e-14,  3.521676130021457e-17,
  3.459484416110959e-20, -4.403451590847988e-22,  1.887504927600473e-24, -5.873547833297436e-27,  1.343201102123993e-29,  1.426440451280333e-01, -6.873708297797922e-04,
  2.355765372696214e-06, -6.598319854305649e-09,  1.502623617887943e-11, -2.420778043233491e-14,  3.972098044910343e-18,  1.663405396614768e-19, -8.374912244531682e-22,
  2.696233466792447e-24, -6.209594057635271e-27,  6.762275903138538e-30,  1.781757915296227e-01, -8.501588538171958e-04,  2.841140508245239e-06, -7.537360089111639e-09,
  1.515783809544108e-11, -1.550583946965472e-14, -4.334222998103533e-17,  3.271066571580694e-19, -1.197479440488814e-21,  2.903054229112796e-24, -3.433921405740508e-27,
 -1.073771538814196e-29,  2.176433022790252e-01, -1.026804566951437e-03,  3.331614226461007e-06, -8.262697823211049e-09,  1.385430674377084e-11, -1.144600980964076e-15,
 -1.042822562814427e-16,  4.896667074429419e-19, -1.378057145292308e-21,  2.016021442087847e-24,  3.379182735901110e-27, -3.733860674082070e-29,  2.610358334766808e-01,
 -1.215783607192657e-03,  3.810977962832509e-06, -8.684003766901104e-09,  1.083485957911645e-11,  1.887445643182043e-14, -1.729654227206200e-16,  6.135101823978274e-19,
 -1.215189672217872e-21, -3.319896713889326e-25,  1.381968151984362e-26, -6.436497126922136e-29,  3.083375506424406e-01, -1.415317669847005e-03,  4.261107062596789e-06,
 -8.709139988663563e-09,  5.893927765327301e-12,  4.381105270860249e-14, -2.396708921804444e-16,  6.477791312630083e-19, -5.603663727414469e-22, -4.161889534185044e-24,
  2.536284196098660e-26, -7.557055247254540e-29,  3.595259500754999e-01, -1.623340853542784e-03,  4.661964888096231e-06, -8.247872638388285e-09, -1.060386784910785e-12,
  7.200827923045666e-14, -2.908654769687191e-16,  5.380224606000144e-19,  6.641953170885193e-22, -8.905860208298201e-24,  3.298699222709530e-26, -5.036028077108907e-29,
  4.145698953782887e-01, -1.837461091174891e-03,  4.991669454910837e-06, -7.216829030182158e-09, -9.961707980307860e-12,  1.007457374010258e-13, -3.098953840775113e-16,
  2.376577538794928e-19,  2.396294950192070e-21, -1.321923210719751e-23,  2.970702728248136e-26,  2.740501236717668e-29,  4.734271741109323e-01, -2.054916510022126e-03,
  5.226655747160268e-06, -5.546013796898902e-09, -2.053562736070051e-11,  1.261616274372112e-13, -2.786349453468304e-16, -2.754489240993347e-19,  4.362051539586661e-21,
 -1.496905767166592e-23,  8.596115639945034e-27,  1.548400735830537e-28,  5.360414547112390e-01, -2.272526867666581e-03,  5.341979608644334e-06, -3.187227612143643e-09,
 -3.224738870730148e-11,  1.432995479877407e-13, -1.804064110087312e-16, -9.779795616842978e-19,  6.024960367499737e-21, -1.156417536955977e-23, -3.333482435833884e-26,
  2.931509207123676e-28,  6.023384929078340e-01, -2.486640744847855e-03,  5.311825930825977e-06, -1.247233269592137e-10, -4.425222989184609e-11,  1.463573173242250e-13,
 -4.436062400245537e-18, -1.778505414315534e-18,  6.593792854289276e-21, -7.998145505292392e-25, -8.972406037329803e-26,  3.579098146413566e-28,  6.722213988200073e-01,
 -2.693080073800844e-03,  5.110305446334579e-06,  3.611651923697010e-09, -5.535764646190149e-11,  1.292375971800563e-13,  2.480836631479214e-16, -2.499336627656975e-18,
  5.142184043489890e-21,  1.769229541510497e-23, -1.396686626456508e-25,  2.330824965818577e-28,  7.455647299940875e-01, -2.887085036507010e-03,  4.712650952923280e-06,
  7.930812067085888e-09, -6.401277968299410e-11,  8.651587749900021e-14,  5.567147330066573e-16, -2.873890299822621e-18,  8.980625711635410e-22,  4.055502983360035e-23,
 -1.467223606586153e-25, -1.713985028420072e-28,  8.222071217783700e-01, -3.063264668014700e-03,  4.096954042965821e-06,  1.266275568367014e-08, -6.834826270029228e-11,
  1.493409741387202e-14,  8.745417939748408e-16, -2.576247785480578e-18, -6.262149947018204e-21,  5.907004124990238e-23, -6.835112585293102e-26, -8.104116842992693e-28,
  9.019421064758815e-01, -3.215562052556988e-03,  3.246613215501176e-06,  1.754023820863884e-08, -6.629988735510840e-11, -8.453298569901220e-14,  1.123700619054333e-15,
 -1.303587893090228e-18, -1.516285433349163e-20,  5.926948328171954e-23,  1.177545514286445e-25, -1.377367430391506e-27,  9.845067120252533e-01, -3.337248356694733e-03,
  2.153683460769194e-06,  2.218273776612186e-08, -5.585953713505986e-11, -2.041579178093326e-13,  1.198412627351825e-15,  1.071389552649990e-18, -2.275113397079241e-20,
  2.608397922183863e-23,  3.708264382588772e-25, -1.277997661564694e-27,  1.069567381720226e+00, -3.420967795488782e-03,  8.233048490711429e-07,  2.608815831987774e-08,
 -3.550179706615092e-11, -3.269503341980640e-13,  9.824406002756319e-16,  4.283219528126066e-18, -2.410987415671232e-20, -4.634603604552180e-23,  5.475618860792949e-25,
  9.202061209045818e-29,  1.156702743009972e+00, -3.458866711118301e-03, -7.206968534808373e-07,  2.864136995236635e-08, -4.823127455751084e-12, -4.252138519090653e-13,
  3.886473166637371e-16,  7.453241007639335e-18, -1.387887002967626e-20, -1.391016718628746e-22,  4.188845049217111e-25,  2.614194466810967e-27,  1.245382820726090e+00,
 -3.442854734888326e-03, -2.429170856216978e-06,  2.915337886894619e-08,  3.461864185681678e-11, -4.620686110098855e-13, -5.757898384066850e-16,  9.027816277405238e-18,
  1.015899873229366e-20, -1.967007546636856e-22, -1.820214929272922e-25,  4.563657437787423e-27,  1.334944516338776e+00, -3.365063973283741e-03, -4.220574211790578e-06,
  2.694953070562978e-08,  7.839574753536454e-11, -3.986577897064069e-13, -1.729805746455302e-15,  7.152590419447224e-18,  4.174021562195272e-20, -1.402564399820062e-22,
 -1.065557451431405e-24,  2.841038706600438e-27,  1.424563687172727e+00, -3.218590202997496e-03, -5.974961698336734e-06,  2.152634386585301e-08,  1.185869295971064e-10,
 -2.096816896380279e-13, -2.666976143505547e-15,  7.629896732984631e-19,  6.252552991979637e-20,  7.005908877584261e-23, -1.467686512101591e-24, -3.906547178562724e-27,
  1.513225147445591e+00, -2.998609639267151e-03, -7.531917379025506e-06,  1.278706388599415e-08,  1.441154451573000e-10,  9.289603397723664e-14, -2.816834576732068e-15,
 -8.715943817847661e-18,  4.785701536963980e-20,  3.356790754010849e-22, -4.601111523085100e-25, -1.025591692549122e-26,  1.599693622425413e+00, -2.703947653921001e-03,
 -8.697187866951406e-06,  1.333563679553433e-09,  1.430081339854081e-10,  4.360640466115164e-13, -1.718117918647555e-15, -1.621626710107564e-17, -1.130348362273506e-20,
  3.942423103691371e-22,  1.681942457506455e-24, -5.373349398615244e-27,  1.682491354598547e+00, -2.339099417983792e-03, -9.264529145740027e-06, -1.127667780843622e-08,
  1.073535354039910e-10,  6.831837187818327e-13,  5.017393473842493e-16, -1.484003453367005e-17, -8.029134099789080e-20,  4.546471879519123e-23,  2.528376417326854e-24,
  1.046856313336069e-26,  1.759891716892970e+00, -1.916521608140786e-03, -9.059177826042458e-06, -2.250267142798275e-08,  4.033887789502858e-11,  6.829546017931978e-13,
  2.756126320217132e-15, -2.244285146372050e-18, -8.818206255648005e-20, -4.437560402121657e-22,  3.437785813917105e-26,  1.380958652420049e-26,  1.829942244703553e+00,
 -1.458691996910362e-03, -8.004153804461485e-06, -2.929592575990714e-08, -3.838376374443742e-11,  3.797354058627905e-13,  3.396540619805616e-15,  1.278227859580583e-17,
 -7.207254108804597e-21, -4.225805821516809e-22, -2.755628063165182e-24, -6.447607379311101e-27,  1.890533140596726e+00, -9.990013191337091e-04, -6.196672755466358e-06,
 -2.926560364249572e-08, -9.612473136941507e-11, -7.920790576165345e-14,  1.704999578189999e-15,  1.523416832480201e-17,  7.301650232864618e-20,  1.441707505675292e-22,
 -1.024882729207603e-24, -1.292248317415612e-26,  1.939525091265405e+00, -5.801987109160569e-04, -3.960099945777761e-06, -2.227466334742060e-08, -1.047639294286665e-10,
 -3.862060349736850e-13, -7.892522822804421e-16,  2.986297518080381e-18,  4.737849961763869e-20,  3.387283220563003e-22,  1.683300813656400e-24,  5.235716725143999e-27,
  1.974939127761506e+00, -2.492804395176756e-04, -1.820295806337725e-06, -1.147835530110418e-08, -6.529963353470336e-11, -3.385748349533582e-13, -1.584487047344514e-15,
 -6.449117165708362e-18, -2.032192909235135e-20, -2.317308507445572e-23,  3.311501915613996e-25,  3.875192337432724e-27,  1.995193816129218e+00, -4.880538340742598e-05,
 -3.702223308125430e-07, -2.483310454049458e-09, -1.551441770773530e-11, -9.231493398793387e-14, -5.290081378247203e-16, -2.936360565590470e-18, -1.583048466247439e-20,
 -8.294461350312806e-23, -4.218690680553377e-25, -2.076210234495316e-27,  4.837514665349553e-04, -2.394602185225908e-06,  8.888039920915837e-09, -2.932085638891253e-11,
  9.064149221241758e-14, -2.689833340247896e-16,  7.753468183204003e-19, -2.190402241226371e-21,  6.077179430385659e-24, -1.670196913813178e-26,  4.509416473334586e-29,
 -1.224070617794455e-31,  4.353900584634346e-03, -2.153225109042301e-05,  7.974680721828180e-08, -2.620452811704142e-10,  8.050891709967742e-13, -2.367904010401675e-15,
  6.742447984001691e-18, -1.874390602281900e-20,  5.093810371968246e-23, -1.364487121133168e-25,  3.566118641187493e-28, -9.325529915138595e-31,  1.209491934146567e-02,
 -5.970489851271848e-05,  2.201518966432303e-07, -7.176730623027277e-10,  2.177267605656010e-12, -6.286361646266672e-15,  1.744319004043100e-17, -4.682984755501098e-20,
  1.214731713225583e-22, -3.062994091996537e-25,  7.375003480037265e-28, -1.741760913272473e-30,  2.370818963091631e-02, -1.167052268246680e-04,  4.274648468012441e-07,
 -1.376588876804852e-09,  4.095038119337162e-12, -1.148006434101566e-14,  3.052325251026802e-17, -7.712346309633635e-20,  1.833032213781230e-22, -4.070915290860985e-25,
  7.971544284569450e-28, -1.336731824552808e-30,  3.919563379129613e-02, -1.922171690252328e-04,  6.976941972531125e-07, -2.209445280029608e-09,  6.393519768597874e-12,
 -1.716921272163083e-14,  4.273238619852214e-17, -9.740149947487322e-20,  1.944928896534915e-22, -3.074609078539401e-25,  1.638155800736771e-28,  1.201253596997829e-30,
  5.855952648718551e-02, -2.858096635670132e-04,  1.025455455876810e-06, -3.177277830319468e-09,  8.859334016225278e-12, -2.238369212095447e-14,  5.026051987729498e-17,
 -9.457083531009166e-20,  1.160956461306498e-22,  8.753447759874886e-26, -1.313584441656077e-27,  5.738606451819349e-30,  8.180223093184115e-02, -3.969280973718075e-04,
  1.403918673099107e-06, -4.231701407528484e-09,  1.123669189664161e-11, -2.602526371675150e-14,  4.918168500536794e-17, -5.721030700942293e-20, -7.555695793479483e-23,
  7.853449558629890e-25, -3.384511598692060e-27,  1.057140775995009e-29,  1.089258474618250e-01, -5.248832349547950e-04,  1.824744726526496e-06, -5.315228588952208e-09,
  1.323570333009564e-11, -2.694816520885682e-14,  3.599804081565076e-17,  2.154679743812965e-20, -3.764840475316129e-22,  1.664102931507843e-24, -5.303585687803437e-27,
  1.246678055527402e-29,  1.399317583041823e-01, -6.688373757695186e-04,  2.278012096958941e-06, -6.361766610486908e-09,  1.454339585746639e-11, -2.405950003788081e-14,
  8.268690775085761e-18,  1.410465105725619e-19, -7.448236676654279e-22,  2.454052996105114e-24, -5.893918940801661e-27,  7.520208863482425e-30,  1.748200473122111e-01,
 -8.277874240244724e-04,  2.752136931025276e-06, -7.297369094788245e-09,  1.483803907651696e-11, -1.644037964024660e-14, -3.470419705612658e-17,  2.904321091394590e-19,
 -1.095545369240403e-21,  2.757379477704721e-24, -3.823265719063464e-27, -7.090628516067404e-30,  2.135887671904832e-01, -1.000544496864319e-03,  3.233790682628265e-06,
 -8.041343462686325e-09,  1.380747208132512e-11, -3.487762256333587e-15, -9.117787938472207e-17,  4.467531033795309e-19, -1.303424749628351e-21,  2.120354974823877e-24,
  1.885916099476925e-27, -3.068957835389032e-29,  2.562330189076288e-01, -1.185709641336517e-03,  3.707821806452674e-06, -8.507845886060870e-09,  1.117220570452370e-11,
  1.492502421836719e-14, -1.563326100895763e-16,  5.745341723296787e-19, -1.217852836795468e-21,  1.664374987187799e-25,  1.115742049471836e-26, -5.671383603196345e-29,
  3.027437981299599e-01, -1.381645184324563e-03,  4.157191119481777e-06, -8.608133778131723e-09,  6.714085933822600e-12,  3.827444719895660e-14, -2.218052861721032e-16,
  6.276395203849647e-19, -6.927246445011411e-22, -3.212780382783804e-24,  2.212165349086028e-26, -7.159057784046747e-29,  3.531065509952609e-01, -1.586441213735898e-03,
  4.562934930243695e-06, -8.253691629373610e-09,  3.112025083387611e-13,  6.521039781066643e-14, -2.755496972169219e-16,  5.543971331851306e-19,  3.667818383314942e-22,
 -7.632753643200233e-24,  3.062302416669601e-26, -5.659147389964124e-29,  4.072993656191672e-01, -1.797876702393690e-03,  4.904176372316229e-06, -7.360498730619057e-09,
 -8.020586170666732e-12,  9.339633471659708e-14, -3.022373226108559e-16,  3.069561999290362e-19,  1.942020046300379e-21, -1.201360116371686e-23,  3.041538919556615e-26,
  5.549937825168191e-30,  4.652907054299086e-01, -2.013374869004548e-03,  5.158214244595243e-06, -5.854763659096013e-09, -1.807981250228449e-11,  1.193971158482924e-13,
 -2.844737816253371e-16, -1.444064274019445e-19,  3.830895952981208e-21, -1.449995511436131e-23,  1.459335732869548e-26,  1.183732511544746e-28,  5.270365645872077e-01,
 -2.229952572770276e-03,  5.300730919141130e-06, -3.680502077159787e-09, -2.942680241325864e-11,  1.386625859887604e-13, -2.051549336342405e-16, -7.920745630915509e-19,
  5.587658045629929e-21, -1.265055019743036e-23, -2.125809870623883e-26,  2.555359335076277e-28,  5.924768929646590e-01, -2.444163938384251e-03,  5.306177568693291e-06,
 -8.093641220658255e-10, -4.133005882645423e-11,  1.456770665534775e-13, -5.128928395259652e-17, -1.568626719336538e-18,  6.504174765353674e-21, -4.076036759104211e-24,
 -7.416259597242814e-26,  3.475839766385264e-28,  6.615310969016526e-01, -2.652039129791499e-03,  5.148417215886388e-06,  2.746907644959880e-09, -5.271892447884490e-11,
  1.343709726093117e-13,  1.804941207272752e-16, -2.325653112792687e-18,  5.681174121069173e-21,  1.232763740669983e-23, -1.281816622355913e-25,  2.856395053884997e-28,
  7.340923706032698e-01, -2.849020425295392e-03,  4.801734848342831e-06,  6.921148804434632e-09, -6.215534622124200e-11,  9.891595955113386e-14,  4.768594715799269e-16,
 -2.822937582854295e-18,  2.250959482545776e-21,  3.457604556001875e-23, -1.512537744516112e-25, -3.784026989287269e-29,  8.100205505338084e-01, -3.029899784139998e-03,
  4.242359160579924e-06,  1.157268843024699e-08, -6.784564241451129e-11,  3.503678164917655e-14,  7.999169489365884e-16, -2.743206586417485e-18, -4.192967150107780e-21,
  5.567427478804764e-23, -1.001562560897254e-25, -6.346966928572278e-28,  8.891331115185569e-01, -3.188765368004002e-03,  3.450680203331756e-06,  1.646736666780590e-08,
 -6.772409034605678e-11, -5.805500412530333e-14,  1.080733766738855e-15, -1.753868171537158e-18, -1.295877093846068e-20,  6.279075372351021e-23,  5.897387456768323e-26,
 -1.286278769541096e-27,  9.711938415755662e-01, -3.318969611512321e-03,  2.414384140599087e-06,  2.125789136680284e-08, -5.965306767667670e-11, -1.751173287466117e-13,
  1.218379948525759e-15,  3.611267963174299e-19, -2.155921266200137e-20,  3.973378897320202e-23,  3.103731952008487e-25, -1.455243762986077e-27,  1.055898651838714e+00,
 -3.413139270030924e-03,  1.132743046599065e-06,  2.546913780538906e-08, -4.179576022098728e-11, -3.020211698412141e-13,  1.091348834708561e-15,  3.489233656414881e-18,
 -2.538457941640910e-20, -2.452311463054558e-23,  5.397072778717441e-25, -4.398316734380721e-28,  1.142857919060323e+00, -3.463259454763136e-03, -3.777422422109753e-07,
  2.849674248674110e-08, -1.321750375222832e-11, -4.134367194062097e-13,  5.903918206682537e-16,  6.932443023047017e-18, -1.855879683027537e-20, -1.202212692992776e-22,
  5.206130637196039e-25,  1.994001008327798e-27,  1.231574763071582e+00, -3.460880030075065e-03, -2.076314081352097e-06,  2.963268185244872e-08,  2.525971709706475e-11,
 -4.728240694557047e-13, -3.195320302126466e-16,  9.238593904100484e-18,  2.995350934334189e-21, -1.999429490938906e-22,  1.997561199605771e-26,  4.572506784460817e-27,
  1.321418808709607e+00, -3.397514286126748e-03, -3.889924079946399e-06,  2.813789249867563e-08,  7.002441962993614e-11, -4.376238777272014e-13, -1.511649783322838e-15,
  8.399531298522054e-18,  3.595743585495979e-20, -1.799937967406781e-22, -9.121214881106943e-25,  4.101080051018627e-27,  1.411595408064478e+00, -3.265324717691895e-03,
 -5.705410852231693e-06,  2.338671928930166e-08,  1.137561288562631e-10, -2.732047426734407e-13, -2.617304421397455e-15,  2.792523111439486e-18,  6.395396886043717e-20,
  8.409789213356920e-24, -1.601899349021084e-24, -2.140122381799031e-27,  1.501111225523260e+00, -3.058211882892808e-03, -7.364588335500407e-06,  1.510402150083829e-08,
  1.452784989794825e-10,  2.254751500004754e-14, -3.037654843966828e-15, -6.995611093761620e-18,  5.950023986331942e-20,  3.081287697812667e-22, -9.191222260018882e-25,
 -1.048999990581871e-26,  1.588738833924420e+00, -2.773421600094928e-03, -8.667176200205705e-06,  3.689068703196742e-09,  1.512801341842151e-10,  3.893532432025086e-13,
 -2.175014109179880e-15, -1.633843111680386e-17,  4.034386461369892e-21,  4.558153770151696e-22,  1.372381605217901e-24, -8.709228414737084e-27,  1.672985910030098e+00,
 -2.413726689555424e-03, -9.389090717977898e-06, -9.449204053027558e-09,  1.211024785697066e-10,  6.899511100398410e-13,  5.063816399072232e-17, -1.736277681705758e-17,
 -7.672739078563735e-20,  1.553317495983923e-22,  2.950915362117406e-24,  8.535904117542725e-27,  1.752078990300187e+00, -1.990063125492014e-03, -9.324875031585844e-06,
 -2.174440994772596e-08,  5.465263975688331e-11,  7.480139664165372e-13,  2.651388278290245e-15, -5.320191947041670e-18, -1.039756284914973e-19, -4.290796410331445e-22,
  7.277982513520680e-25,  1.769648539577453e-26,  1.823977169823289e+00, -1.524141265591370e-03, -8.359124451588613e-06, -2.984475819508551e-08, -2.994509282169252e-11,
  4.655063345891806e-13,  3.748773871425365e-15,  1.228645099381701e-17, -2.446648458439454e-20, -5.377907890044537e-22, -2.985306562337823e-24, -3.754743738740860e-27,
  1.886435727318694e+00, -1.050005701290948e-03, -6.557132640853196e-06, -3.081389945202086e-08, -9.726375473156337e-11, -3.290072356737500e-14,  2.164984766862257e-15,
  1.764464951064672e-17,  7.732177699198860e-20,  9.070661229878117e-23, -1.676320913027719e-24, -1.676389518729373e-26,  1.937139200936653e+00, -6.129777836772996e-04,
 -4.237711387532972e-06, -2.401367670809550e-08, -1.126697628023997e-10, -4.039616299839505e-13, -6.824819487217040e-16,  4.710958182633317e-18,  6.083947950448691e-20,
  4.105787657811391e-22,  1.905943581386068e-24,  4.781080454502409e-27,  1.973911983144680e+00, -2.644120568908872e-04, -1.964535157991280e-06, -1.257945030892641e-08,
 -7.246641640926570e-11, -3.788435822581376e-13, -1.774271682090792e-15, -7.109851062317527e-18, -2.087271621480661e-20, -6.079441834665327e-24,  5.352094868902390e-25,
  5.480621505830277e-27,  1.994992476158346e+00, -5.189072582088716e-05, -4.015746816871658e-07, -2.747030373957306e-09, -1.749464599333948e-11, -1.060578695701425e-13,
 -6.187914840128159e-16, -3.494156351525864e-18, -1.914358038456484e-20, -1.017939584417587e-22, -5.244669508636936e-25, -2.607854666397576e-27,  4.743130723231413e-04,
 -2.324881014867243e-06,  8.544716917525489e-09, -2.791263925897395e-11,  8.544305219328417e-14, -2.510895538412357e-16,  7.166501631607319e-19, -2.005214977652651e-21,
  5.507118306738176e-24, -1.500156074586508e-26,  4.003038213009331e-29, -1.081061486291357e-31,  4.269027918226630e-03, -2.090663936488316e-05,  7.667801758839184e-08,
 -2.495341021092914e-10,  7.593077001489365e-13, -2.212203461380300e-15,  6.239719597881584e-18, -1.718980646633443e-20,  4.627311135930552e-23, -1.229732943336491e-25,
  3.179145451534740e-28, -8.287937447206675e-31,  1.185956845826474e-02, -5.797754883944715e-05,  2.117447610676936e-07, -6.838202906019257e-10,  2.055622755830293e-12,
 -5.883030655930119e-15,  1.618475633603348e-17, -4.311358788825543e-20,  1.109593846346195e-22, -2.782817559882024e-25,  6.645928015327735e-28, -1.575541647905892e-30,
  2.324810509022177e-02, -1.133504876606784e-04,  4.113314540489929e-07, -1.312865997330424e-09,  3.872590866004361e-12, -1.077277026422809e-14,  2.844375541996808e-17,
 -7.148620502638327e-20,  1.692078125619572e-22, -3.763695608159716e-25,  7.392511631323955e-28, -1.294626151029592e-30,  3.843776272566494e-02, -1.867399555229995e-04,
  6.717834781083121e-07, -2.109841229475760e-09,  6.060173971707823e-12, -1.617566925012825e-14,  4.009062263216227e-17, -9.135346301619931e-20,  1.835539884390267e-22,
 -2.999594304346293e-25,  2.086924541229154e-28,  8.487389640578281e-31,  5.743245700475469e-02, -2.777561531188455e-04,  9.881640546004491e-07, -3.039045229809106e-09,
  8.423510392591782e-12, -2.120879308160229e-14,  4.766495155286723e-17, -9.081501853390981e-20,  1.183594173055974e-22,  3.976372161243881e-26, -1.081595235322354e-27,
  4.826351743062607e-30,  8.023666389507314e-02, -3.858968524188365e-04,  1.354200008200952e-06, -4.056014795691646e-09,  1.072785916924849e-11, -2.486437394208291e-14,
  4.755001604920843e-17, -5.920101308120179e-20, -4.961285383605252e-23,  6.588774500072702e-25, -2.948300837518866e-27,  9.275508107941307e-30,  1.068551115091487e-01,
 -5.105368486588613e-04,  1.762214977748479e-06, -5.107721919331161e-09,  1.270542161776857e-11, -2.607827995452635e-14,  3.644140663466406e-17,  1.041794294265990e-20,
 -3.202653941127056e-22,  1.462636821004831e-24, -4.777031818831080e-27,  1.146317642639050e-29,  1.372923790369381e-01, -6.509147244813917e-04,  2.203051222846846e-06,
 -6.132909719063620e-09,  1.406449665724793e-11, -2.381627309306552e-14,  1.189727279428317e-17,  1.185808427465650e-19, -6.606403194543959e-22,  2.225053966223664e-24,
 -5.553168227929640e-27,  7.914551320173826e-30,  1.715523828714649e-01, -8.061165916161407e-04,  2.665981963783762e-06, -7.062633489773324e-09,  1.450154108822205e-11,
 -1.717956602084179e-14, -2.704819308241718e-17,  2.569328372308820e-19, -9.990993122653178e-22,  2.599114624081640e-24, -4.068828248402448e-27, -4.185399899039069e-30,
  2.096377240059769e-01, -9.750564063101789e-04,  3.138617402756181e-06, -7.821096678099034e-09,  1.371682332377447e-11, -5.530564514136746e-15, -7.924116238988089e-17,
  4.062768601717807e-19, -1.226043444585219e-21,  2.170540332016334e-24,  6.652099062305496e-28, -2.494163988050393e-29,  2.515488632132997e-01, -1.156452383259054e-03,
  3.606809392488888e-06, -8.326901058200227e-09,  1.143446668106528e-11,  1.136168979971533e-14, -1.407897641042761e-16,  5.357401332943269e-19, -1.204409483629469e-21,
  5.649773458816994e-25,  8.821862336645345e-27, -4.953605365811596e-29,  2.972830808849861e-01, -1.348798963231183e-03,  4.054562406838271e-06, -8.494867796979456e-09,
  7.427751718160763e-12,  3.315940140210736e-14, -2.045579255250262e-16,  6.037864686533185e-19, -7.932039762184807e-22, -2.389551709612037e-24,  1.907464209425370e-26,
 -6.680977228854270e-29,  3.468331660659121e-01, -1.550333730033440e-03,  4.463962395544135e-06, -8.238632743843124e-09,  1.550541717317661e-12,  5.878456323159399e-14,
 -2.599019107822908e-16,  5.619691493949162e-19,  1.134398742633768e-22, -6.458839975769070e-24,  2.804727966269698e-26, -6.008521752582736e-29,  4.001857633377000e-01,
 -1.758998637536790e-03,  4.815140784484557e-06, -7.474275769735996e-09, -6.224465629827609e-12,  8.625240738170924e-14, -2.928358664515099e-16,  3.624159596088224e-19,
  1.531438185598253e-21, -1.079754989132209e-23,  3.025987291475842e-26, -1.193625461945894e-29,  4.573192857133467e-01, -1.972394922344703e-03,  5.086299015995329e-06,
 -6.125309206070010e-09, -1.576040184620852e-11,  1.125345989920054e-13, -2.868785346794250e-16, -3.004747963587740e-20,  3.320569533126579e-21, -1.382193315853451e-23,
  1.907044986494238e-26,  8.579631663811072e-29,  5.182012752484294e-01, -2.187731184614029e-03,  5.253830552175611e-06, -4.129419606528849e-09, -2.670448168586280e-11,
  1.334925093566189e-13, -2.248992613573905e-16, -6.206990174459386e-19,  5.119539438117918e-21, -1.328728009212386e-23, -1.085747901957750e-26,  2.172412759337549e-28,
  5.827850589611063e-01, -2.401764388166374e-03,  5.292593404010454e-06, -1.447418125989110e-09, -3.843226366644970e-11,  1.439424289372956e-13, -9.232293143877771e-17,
 -1.363383849649542e-18,  6.307679033792285e-21, -6.741965961811752e-24, -5.928047783150735e-26,  3.274970771743344e-28,  6.510055038499282e-01, -2.610734074380285e-03,
  5.176408478530624e-06,  1.925117807535247e-09, -4.999335323589134e-11,  1.379423304954624e-13,  1.179808074254195e-16, -2.137719114111549e-18,  6.035810087969616e-21,
  7.462766655126671e-24, -1.148225972789260e-25,  3.185304891081389e-28,  7.227736190024726e-01, -2.810291083360775e-03,  4.878888946500102e-06,  5.943084929565663e-09,
 -6.006893638511665e-11,  1.094213276595838e-13,  3.990044412016384e-16, -2.732159903916142e-18,  3.386712196065413e-21,  2.852732947763950e-23, -1.503614942055543e-25,
  7.479933606713922e-29,  7.979696826940028e-01, -2.995423815923320e-03,  4.374744671234426e-06,  1.049378076371122e-08, -6.695921891060060e-11,  5.329973225136089e-14,
  7.215242106903126e-16, -2.846137879551975e-18, -2.267064175342111e-21,  5.116125958671031e-23, -1.242220435313958e-25, -4.601178730173540e-28,  8.764344863386966e-01,
 -3.160387992903723e-03,  3.641753291796506e-06,  1.537588418545718e-08, -6.863002535721469e-11, -3.275145009785945e-14,  1.026162367355015e-15, -2.132034640548934e-18,
 -1.066915183646543e-20,  6.405462604456515e-23,  5.199467063220714e-27, -1.151975262830907e-27,  9.579581856308139e-01, -3.298650641081122e-03,  2.663641717559566e-06,
  2.027701433194320e-08, -6.286258101641144e-11, -1.458314252616507e-13,  1.219064357993040e-15, -3.036125848781098e-19, -1.992106749533306e-20,  5.083543418972369e-23,
  2.440545972425469e-25, -1.545202634706720e-27,  1.042266137658826e+00, -3.402866625158348e-03,  1.434165669934555e-06,  2.475353693065150e-08, -4.756682362512613e-11,
 -2.747488738093891e-13,  1.177571810181727e-15,  2.666921873412563e-18, -2.588479038815739e-20, -3.464014055548844e-24,  5.098709204139656e-25, -9.031464931118441e-28,
  1.129000997220469e+00, -3.464917767321917e-03, -3.732040983866308e-08,  2.821994716225982e-08, -2.132918458299183e-11, -3.970089747804645e-13,  7.755648369526794e-16,
  6.273492917912060e-18, -2.249259180982054e-20, -9.784214828064267e-23,  5.932974686723064e-25,  1.302037752902480e-27,  1.217700282759116e+00, -3.476062024316426e-03,
 -1.718610139272762e-06,  2.996085686635627e-08,  1.574752895696303e-11, -4.773844751387110e-13, -6.058821086579040e-17,  9.219822646901289e-18, -4.140217827771763e-21,
 -1.951778710566724e-22,  2.163783012353038e-25,  4.312070880575665e-27,  1.307768677256392e+00, -3.427264690873012e-03, -3.545842018698165e-06,  2.918637442470837e-08,
  6.092884194209055e-11, -4.709574378857151e-13, -1.261376164472404e-15,  9.439823738098229e-18,  2.886736986761649e-20, -2.125495498660228e-22, -7.082442771925240e-25,
  5.118827220770370e-27,  1.398444643117841e+00, -3.309814937612942e-03, -5.414040920360100e-06,  2.515972237182785e-08,  1.076714091198645e-10, -3.348506697890709e-13,
 -2.510505948320320e-15,  4.831377869949961e-18,  6.308593686541816e-20, -5.696690295616374e-23, -1.652149900153387e-24, -1.125200368650709e-28,  1.488761748283282e+00,
 -3.116364072570309e-03, -7.169391463652993e-06,  1.742806138621904e-08,  1.449857005099778e-10, -5.248160008100526e-14, -3.205264049874002e-15, -4.922114939104992e-18,
  6.982065881085493e-20,  2.622303206122190e-22, -1.371956818885219e-24, -9.961526004991375e-27,  1.577506811921742e+00, -2.842540213582580e-03, -8.608137120937210e-06,
  6.168856068996983e-09,  1.585082811525468e-10,  3.316933014566229e-13, -2.628144996136127e-15, -1.593699443362883e-17,  2.133060578537580e-20,  5.020721445256283e-22,
  9.167238255983722e-25, -1.196236067479870e-26,  1.663180107566411e+00, -2.489258988905580e-03, -9.490400210539168e-06, -7.401276397046458e-09,  1.348728662188553e-10,
  6.850610854523233e-13, -4.688863676393975e-16, -1.970511553705192e-17, -6.892783735852931e-20,  2.800308469225479e-22,  3.260678400107144e-24,  5.328028578457953e-27,
  1.743967909736147e+00, -2.065689832739942e-03, -9.580056563926575e-06, -2.074688565964886e-08,  7.023518326960418e-11,  8.094696916372791e-13,  2.453568847855072e-15,
 -8.887354253546286e-18, -1.187008167207577e-19, -3.833019281568688e-22,  1.587239057928446e-24,  2.127860119226760e-26,  1.817744580042740e+00, -1.592454214760029e-03,
 -8.719812894591759e-06, -3.024439512749216e-08, -1.970793089512587e-11,  5.594979643785163e-13,  4.078757127008792e-15,  1.117045192003463e-17, -4.600606278524575e-20,
 -6.593711255361877e-22, -3.062519468401361e-24,  5.319773850239149e-28,  1.882128411143849e+00, -1.103968316145600e-03, -6.936248853157133e-06, -3.237238746224522e-08,
 -9.736069880463560e-11,  2.526962614703024e-14,  2.694065036764659e-15,  2.015673695820036e-17,  7.919145282650025e-20,  7.684465581011636e-24, -2.505358176090013e-24,
 -2.095628451431310e-26,  1.934617617298594e+00, -6.480633969993409e-04, -4.536961170277008e-06, -2.588186774374729e-08, -1.209009097449357e-10, -4.185241258045619e-13,
 -5.209897737256187e-16,  6.909423733720604e-18,  7.704070515488361e-20,  4.907268679295585e-22,  2.092444778026156e-24,  3.536806935003788e-27,  1.972821917710707e+00,
 -2.807524538503433e-04, -2.122703057174385e-06, -1.380191063962976e-08, -8.048562875035857e-11, -4.238905305213636e-13, -1.982699032023991e-15, -7.776641683137324e-18,
 -2.064280187392498e-20,  2.074333261184550e-23,  8.216775305596008e-25,  7.645466670302232e-27,  1.994778272348551e+00, -5.524010589676903e-05, -4.362912381447835e-07,
 -3.044755427681137e-09, -1.977261075724945e-11, -1.221556614963130e-13, -7.257853149272532e-16, -4.169668521234107e-18, -2.321511104163409e-20, -1.252540017253859e-22,
 -6.534246314373060e-25, -3.279744669131512e-27,  4.651481746882518e-04, -2.257840221379276e-06,  8.217805036142186e-09, -2.658480897834273e-11,  8.058881016702403e-14,
 -2.345442766074223e-16,  6.628922948502333e-19, -1.837328132082036e-21,  4.994772202948160e-24, -1.349170900413471e-26,  3.555217162057570e-29, -9.575032329229444e-32,
  4.186609531663267e-03, -2.030498963986960e-05,  7.375506776457858e-08, -2.377311555545265e-10,  7.165230248512109e-13, -2.068062647005183e-15,  5.778486932320341e-18,
 -1.577751488724658e-20,  4.206643446201189e-23, -1.109585874890998e-25,  2.834769473675049e-28, -7.386835392625298e-31,  1.163099498648176e-02, -5.631586380256305e-05,
  2.037324418248594e-07, -6.518509098308840e-10,  1.941750737600226e-12, -5.508690516899881e-15,  1.502581542570334e-17, -3.971818011955868e-20,  1.014034492329997e-22,
 -2.530399793832902e-25,  5.985637179074552e-28, -1.428935397660329e-30,  2.280118613081378e-02, -1.101218163884126e-04,  3.959418390888669e-07, -1.252591765758603e-09,
  3.663802941070620e-12, -1.011353996184997e-14,  2.651594991402473e-17, -6.628274752249160e-20,  1.561771582556120e-22, -3.479259056539972e-25,  6.832499916748238e-28,
 -1.250977281341252e-30,  3.770139338640264e-02, -1.814653359614667e-04,  6.470366511091538e-07, -2.015415132707427e-09,  5.746078534614024e-12, -1.524353525785131e-14,
  3.761334635633651e-17, -8.565083339482849e-20,  1.729138707400115e-22, -2.909560385027394e-25,  2.393086050675602e-28,  5.507896672932976e-31,  5.633701524234450e-02,
 -2.699944554960550e-04,  9.524903700300371e-07, -2.907601172168766e-09,  8.010570367329188e-12, -2.009491906872408e-14,  4.517531405650388e-17, -8.701256251781117e-20,
  1.190611136676207e-22,  5.039180179167224e-28, -8.872276678982125e-28,  4.025202832169993e-30,  7.871443949857827e-02, -3.752550604795429e-04,  1.306541493950256e-06,
 -3.888285910141888e-09,  1.024184858929936e-11, -2.374322337486365e-14,  4.587356921249396e-17, -6.043109507967524e-20, -2.792094536225703e-23,  5.487512555419497e-25,
 -2.566645347870287e-27,  8.089495139112663e-30,  1.048407761943018e-01, -4.966808829441654e-04,  1.702124977677712e-06, -4.908560099691376e-09,  1.219261980078110e-11,
 -2.520129648738127e-14,  3.659728862917843e-17,  9.760190944527399e-22, -2.709311041057811e-22,  1.281343349629370e-24, -4.295080601856410e-27,  1.044199990907564e-29,
  1.347235082106120e-01, -6.335809049165493e-04,  2.130790832394119e-06, -5.911671775354854e-09,  1.359128344471451e-11, -2.349321175982882e-14,  1.493330983562992e-17,
  9.867979759241057e-20, -5.844522553951024e-22,  2.009940475605714e-24, -5.201797138278671e-27,  8.012736509834580e-30,  1.683700409901654e-01, -7.851238242244128e-04,
  2.582611063615075e-06, -6.833390451669549e-09,  1.415202261673659e-11, -1.774592063881636e-14, -2.028782954426795e-17,  2.264270209768357e-19, -9.084985915984566e-22,
  2.433387066332689e-24, -4.201110168304564e-27, -1.926981637080049e-30,  2.057871271111870e-01, -9.503191578116418e-04,  3.046077083148912e-06, -7.602611936796392e-09,
  1.358809298502430e-11, -7.300204426575282e-15, -6.840290617470278e-17,  3.682967810488542e-19, -1.147675744234621e-21,  2.176701556118433e-24, -3.214819639079800e-28,
 -2.004374574724449e-29,  2.469801341981949e-01, -1.127994473092998e-03,  3.507991206358796e-06, -8.142310288631851e-09,  1.162910357257650e-11,  8.158410126274293e-15,
 -1.263250967108278e-16,  4.975884180377958e-19, -1.178225670332372e-21,  8.762468249991434e-25,  6.789667766392335e-27, -4.293909820493837e-29,  2.919521153371778e-01,
 -1.316768148584664e-03,  3.953358094171061e-06, -8.370979313322304e-09,  8.043200089812330e-12,  2.844994085539175e-14, -1.880191750298243e-16,  5.771691561943522e-19,
 -8.661887894170209e-22, -1.683843134018256e-24,  1.624884198208702e-26, -6.158950125647571e-29,  3.407026291184896e-01, -1.515016976316215e-03,  4.365285369238796e-06,
 -8.204752103690882e-09,  2.665132305431642e-12,  5.273594197131884e-14, -2.441493951795277e-16,  5.620902528749751e-19, -9.952654813864442e-23, -5.390353870787857e-24,
  2.536739746800406e-26, -6.141546098919747e-29,  3.932262407746973e-01, -1.720837840912240e-03,  4.724907625854560e-06, -7.560445147290831e-09, -4.568849005046439e-12,
  7.935130518175621e-14, -2.820589133495446e-16,  4.054349111471958e-19,  1.164347593264373e-21, -9.601926142043082e-24,  2.942232861856081e-26, -2.553542400047732e-29,
  4.495106154551868e-01, -1.932002663266341e-03,  5.011355367731347e-06, -6.359844265243965e-09, -1.357856873889045e-11,  1.056509710498676e-13, -2.863059634459463e-16,
  6.840339426705683e-20,  2.837540847160479e-21, -1.299229848168895e-23,  2.220377354832063e-26,  5.730455889059285e-29,  5.095340879734818e-01, -2.145905814981492e-03,
  5.201801026380850e-06, -4.535631362326509e-09, -2.408992127791251e-11,  1.279044399345433e-13, -2.400576835300832e-16, -4.645930201347356e-19,  4.635582030254154e-21,
 -1.354154418455033e-23, -2.128991040758504e-27,  1.797390239007270e-28,  5.732625584285370e-01, -2.359503352632506e-03,  5.271629466734552e-06, -2.039436517214054e-09,
 -3.557854787694718e-11,  1.412911502398034e-13, -1.277114282602565e-16, -1.165851396583585e-18,  6.025691019638926e-21, -8.832551422904153e-24, -4.544679501880759e-26,
  3.003498428353419e-28,  6.406455174771435e-01, -2.569243788516915e-03,  5.194802015944686e-06,  1.147428820066255e-09, -4.721092584172989e-11,  1.400776389758973e-13,
  6.086294442395282e-17, -1.941133286591172e-18,  6.225229651146892e-21,  3.155926964597586e-24, -1.004061084733289e-25,  3.341263023051589e-28,  7.116109457235388e-01,
 -2.770990872890265e-03,  4.944513180720079e-06,  4.999983883530990e-09, -5.779087813755368e-11,  1.180925824955726e-13,  3.241673707556897e-16, -2.608506003196360e-18,
  4.306489029900392e-21,  2.260693988539046e-23, -1.449992068927521e-25,  1.652509540767384e-28,  7.860587552743954e-01, -2.959940282991028e-03,  4.494280106583187e-06,
  9.431874864604503e-09, -6.572654876876108e-11,  6.965347989288925e-14,  6.410865381906981e-16, -2.890210658548962e-18, -5.191249767655266e-22,  4.583703902856406e-23,
 -1.407842912635940e-25, -2.948126753581956e-28,  8.638523445782100e-01, -3.130534632687395e-03,  3.819658081070659e-06,  1.427388069967324e-08, -6.904380119152154e-11,
 -8.876366829751992e-15,  9.620320064697883e-16, -2.436608283663714e-18, -8.371235990038395e-21,  6.329548886752301e-23, -4.195846070597660e-26, -9.877155207712737e-28,
  9.448077179685686e-01, -3.276385520630138e-03,  2.900839971383662e-06,  1.924946550347586e-08, -6.548768754357202e-11, -1.167461740323296e-13,  1.201926348176982e-15,
 -9.100550185756853e-19, -1.793174246971144e-20,  5.922965530846772e-23,  1.755931858236569e-25, -1.554059097284577e-27,  1.028679480274174e+00, -3.390218475724917e-03,
  1.726465403158717e-06,  2.395006719150561e-08, -5.277361900605723e-11, -2.456846405737561e-13,  1.240658067106423e-15,  1.840464638179239e-18, -2.565304404827363e-20,
  1.601885733385551e-23,  4.615434165643630e-25, -1.277680829596294e-27,  1.115142864763227e+00, -3.463868171267673e-03,  2.990127640269013e-07,  2.781622832983640e-08,
 -2.906943378371114e-11, -3.763719466090566e-13,  9.406496781254244e-16,  5.502052635522289e-18, -2.557584292622079e-20, -7.317483639746963e-23,  6.348562732111263e-25,
  5.871989735001106e-28,  1.203770819014999e+00, -3.488369226676467e-03, -1.357883184777315e-06,  3.013644422749659e-08,  6.206104165137309e-12, -4.757621264401840e-13,
  1.946697252041538e-16,  8.976947213370856e-18, -1.096627360249740e-20, -1.828598644183747e-22,  3.958537775188838e-25,  3.809146322671949e-27,  1.294005125625025e+00,
 -3.454214634493417e-03, -3.190072266868905e-06,  3.008432952394216e-08,  5.122888121990304e-11, -4.979615552012226e-13, -9.853151956693069e-16,  1.023613820247364e-17,
  2.076207232001846e-20, -2.361443675555856e-22, -4.664207338289012e-25,  5.814915610500917e-27,  1.385120711499850e+00, -3.351890841675798e-03, -5.102019266950275e-06,
  2.682566518091664e-08,  1.003840011107600e-10, -3.932537013397404e-13, -2.347363979653924e-15,  6.804588074199908e-18,  5.985008832354059e-20, -1.225250196158443e-22,
 -1.610164586488387e-24,  2.025426501210562e-27,  1.476182961797116e+00, -3.172843328363299e-03, -6.946384393524410e-06,  1.973521366558964e-08,  1.431569821570608e-10,
 -1.308009731253362e-13, -3.310464809125102e-15, -2.548239107350548e-18,  7.817045558586552e-20,  1.989209672387560e-22, -1.783761867826337e-24, -8.623501777348628e-27,
  1.565999451209473e+00, -2.911065610044979e-03, -8.518686647565266e-06,  8.754482278250988e-09,  1.644757176125669e-10,  2.633570503606338e-13, -3.062063283418728e-15,
 -1.495922713535643e-17,  3.993034246361673e-20,  5.273374252218035e-22,  3.258521498366691e-25, -1.479708547562041e-26,  1.653070715868296e+00, -2.565499730066009e-03,
 -9.565818095492119e-06, -5.134504140354885e-09,  1.484156187126351e-10,  6.669478757068529e-13, -1.049811975044094e-15, -2.172394964213355e-17, -5.645361019476676e-20,
  4.139127639503753e-22,  3.400600169556538e-24,  8.243603835798601e-28,  1.735550321354977e+00, -2.143305781064571e-03, -9.821732250491526e-06, -1.949050061132782e-08,
  8.699100646472086e-11,  8.649277051042492e-13,  2.149568771782933e-15, -1.289242283540758e-17, -1.311230050884421e-19, -3.001979138795365e-22,  2.588032443812486e-24,
  2.402410980604474e-26,  1.811232941200902e+00, -1.663668923933147e-03, -9.084250817429852e-06, -3.046478058765839e-08, -7.514691217270099e-12,  6.609522736502915e-13,
  4.367182725558925e-15,  9.294960305003875e-18, -7.192787599103169e-20, -7.797379530145630e-22, -2.911130961101715e-24,  6.670117947491321e-27,  1.877599060290239e+00,
 -1.161038601471567e-03, -7.334035535393535e-06, -3.392240540199149e-08, -9.616153684518119e-11,  9.698572500993828e-14,  3.293824319744625e-15,  2.267406951483282e-17,
  7.743057745296060e-20, -1.122258787906187e-22, -3.520927922006595e-24, -2.517221604297751e-26,  1.931950758040115e+00, -6.856349412835370e-04, -4.859428304860426e-06,
 -2.788385452601051e-08, -1.293792481021631e-10, -4.284108268308595e-13, -2.902390972078853e-16,  9.673808181741506e-18,  9.624552434245605e-20,  5.769236749702127e-22,
  2.199753914865181e-24,  1.106372452952800e-27,  1.971663863923611e+00, -2.984191235934649e-04, -2.296340953375630e-06, -1.516016398942568e-08, -8.945730651555004e-11,
 -4.741619693333572e-13, -2.209531449231982e-15, -8.418215554076725e-18, -1.921625661046879e-20,  6.112983514598666e-23,  1.218661267060831e-24,  1.053375390921937e-26,
  1.994550092018266e+00, -5.888215424144088e-05, -4.748102745806305e-07, -3.381649790399703e-09, -2.239982147538835e-11, -1.410638175610990e-13, -8.536519449273106e-16,
 -4.990038917647645e-18, -2.823161912068843e-20, -1.545126634385881e-22, -8.156820563300239e-25, -4.128080207881078e-27,  4.562463087208771e-04, -2.193352282741550e-06,
  7.906371807989891e-09, -2.533206786045169e-11,  7.605294319839365e-14, -2.192345818630289e-16,  6.136136580016423e-19, -1.685000227202170e-21,  4.533682684089891e-24,
 -1.215063554159364e-26,  3.157887569235119e-29, -8.512426850236465e-32,  4.106551857681415e-03, -1.972616839419146e-05,  7.096973919137336e-08, -2.265902895452485e-10,
  6.765135961261141e-13, -1.934531707636590e-15,  5.354977011686441e-18, -1.449317482470411e-20,  3.826841349938457e-23, -1.002458014827147e-25,  2.527287043015661e-28,
 -6.609084819131436e-31,  1.140894244442253e-02, -5.471677320319713e-05,  1.960930656935009e-07, -6.216450664750380e-10,  1.835094902033428e-12, -5.161057835245565e-15,
  1.395779791952335e-17, -3.661452048233382e-20,  9.271018056300308e-23, -2.303159337326049e-25,  5.385692145216041e-28, -1.301153326993605e-30,  2.236694012462336e-02,
 -1.070134246770878e-04,  3.812558983490961e-07, -1.195555129294563e-09,  3.467748510746764e-12, -9.498874817953540e-15,  2.472815436147006e-17, -6.148031600667861e-20,
  1.441306136611351e-22, -3.216843728946479e-25,  6.291253470580726e-28, -1.210036232386826e-30,  3.698573363376707e-02, -1.763842426011183e-04,  6.233933890003535e-07,
 -1.925868598261349e-09,  5.450043967080683e-12, -1.436897797998784e-14,  3.529102720409646e-17, -8.028329006982202e-20,  1.626168802853829e-22, -2.809770953132100e-25,
  2.577708562114592e-28,  2.941502528585236e-31,  5.527205932485762e-02, -2.625119486825717e-04,  9.183550966484876e-07, -2.782589145349044e-09,  7.619318941056793e-12,
 -1.903951744716951e-14,  4.279225752162689e-17, -8.320883257846506e-20,  1.184811662065980e-22, -3.165793870227534e-26, -7.260345635990753e-28,  3.315125152602351e-30,
  7.723403229660865e-02, -3.649866161727329e-04,  1.260849802159845e-06, -3.728156006212326e-09,  9.777856273836827e-12, -2.266264596172825e-14,  4.417182247571149e-17,
 -6.102762261534548e-20, -9.931096082924865e-24,  4.528768408673623e-25, -2.235016155211792e-27,  6.998947471575430e-30,  1.028809182434536e-01, -4.832962156108850e-04,
  1.644376269697682e-06, -4.717462675252092e-09,  1.169737454737791e-11, -2.432357184569090e-14,  3.650994337438779e-17, -6.987999890492839e-21, -2.277872255302091e-22,
  1.118426901001786e-24, -3.858226747779017e-27,  9.414348664450652e-30,  1.322228331293465e-01, -6.168146772521708e-04,  2.061140094336262e-06, -5.697949778833148e-09,
  1.312521636595694e-11, -2.310370385116153e-14,  1.744510503701992e-17,  8.109558158493530e-20, -5.157549396241251e-22,  1.808892995545096e-24, -4.851648657114417e-27,
  7.866144004150848e-30,  1.652703535312214e-01, -7.647871162422331e-04,  2.501957180112614e-06, -6.609821794926534e-09,  1.379273202258432e-11, -1.815995441858333e-14,
 -1.434194286220011e-17,  1.987241314626976e-19, -8.239369335523897e-22,  2.264183635163786e-24, -4.246745182920404e-27, -2.349521069501112e-31,  2.020340151172526e-01,
 -9.263117822168378e-04,  2.956145099167542e-06, -7.386456246685670e-09,  1.342648635514385e-11, -8.822204176046152e-15, -5.859300203726563e-17,  3.328208071357032e-19,
 -1.069746897397077e-21,  2.147466941628988e-24, -1.110384545124858e-27, -1.594261164431765e-29,  2.425236698301481e-01, -1.100318199866045e-03,  3.411404740551257e-06,
 -7.955099352994475e-09,  1.176306039396572e-11,  5.289567981637432e-15, -1.129153710241205e-16,  4.604387440761930e-19, -1.142231086207174e-21,  1.111845752527572e-24,
  5.033569022231084e-27, -3.699612854056914e-29,  2.867476634215470e-01, -1.285540861409851e-03,  3.853696487263978e-06, -8.237975860727410e-09,  8.568366915454162e-12,
  2.412822569643970e-14, -1.722547400943345e-16,  5.486014560183717e-19, -9.157467191398765e-22, -1.086511296956847e-24,  1.365683207828788e-26, -5.622742362915379e-29,
  3.347117833444931e-01, -1.480487718430565e-03,  4.267117985731113e-06, -8.153985264504059e-09,  3.662527514952980e-12,  4.706468648990675e-14, -2.284832629964438e-16,
  5.559911074380155e-19, -2.759662995025938e-22, -4.429714473582411e-24,  2.266689195683695e-26, -6.110447599434764e-29,  3.864179117408264e-01, -1.683402605755566e-03,
  4.633794865746908e-06, -7.621214395888497e-09, -3.048577080889183e-12,  7.272201633662121e-14, -2.702354680443196e-16,  4.373880690583617e-19,  8.395616494355456e-22,
 -8.450743262102359e-24,  2.806230396300419e-26, -3.577456031328013e-29,  4.418622981343445e-01, -1.892220628052064e-03,  4.933802216445724e-06, -6.560569722348835e-09,
 -1.153405639351136e-11,  9.881244608164175e-14, -2.831885160016299e-16,  1.518970289976149e-19,  2.386343830335195e-21, -1.206120199777688e-23,  2.417306764232025e-26,
  3.286405314019771e-29,  5.010333398251978e-01, -2.104515477174198e-03,  5.145144209145334e-06, -4.900922554727544e-09, -2.159041530289238e-11,  1.220032638773062e-13,
 -2.510628649178687e-16, -3.240559319928429e-19,  4.148362241293743e-21, -1.347918637741340e-23,  4.987255224121901e-27,  1.441036501757101e-28,  5.639087227118562e-01,
 -2.317437673589425e-03,  5.243833371246977e-06, -2.586263945688045e-09, -3.278590844820477e-11,  1.378558330715047e-13, -1.577059138728449e-16, -9.784423726920091e-19,
  5.678100030365889e-21, -1.039521546617423e-23, -3.291839029036621e-26,  2.685307110244886e-28,  6.304517285121810e-01, -2.527642923834278e-03,  5.204131571716034e-06,
  4.145277205919013e-10, -4.439905176190306e-11,  1.409087172679887e-13,  9.311835849569711e-18, -1.740854408660199e-18,  6.270106857950461e-21, -5.650347775133626e-25,
 -8.563531287316598e-26,  3.350851101833250e-28,  7.006064524899153e-01, -2.731210305211995e-03,  4.999044306250870e-06,  4.094622817207282e-09, -5.535705888405016e-11,
  1.250124259942185e-13,  2.531729666988257e-16, -2.458780599759746e-18,  5.017892076484128e-21,  1.697408283077251e-23, -1.361461516180921e-25,  2.335746240966532e-28,
  7.742915943538922e-01, -2.923551078598226e-03,  4.601201460303284e-06,  8.392203088495764e-09, -6.418617677413787e-11,  8.406805416050535e-14,  5.601682595937926e-16,
 -2.881530010038996e-18,  1.026933062945495e-21,  3.999162245379658e-23, -1.503949057266581e-25, -1.450001972807809e-28,  8.513923788712067e-01, -3.099311007138195e-03,
  3.984314585139967e-06,  1.316899043737646e-08, -6.899611463006155e-11,  1.336552238587997e-14,  8.903964295858438e-16, -2.668435432906086e-18, -6.132805424930857e-21,
  6.080050548055018e-23, -8.146891536555497e-26, -8.064224148584556e-28,  9.317500269165060e-01, -3.252272806485039e-03,  3.125474737458594e-06,  1.818454062228183e-08,
 -6.753653928734798e-11, -8.826854596204714e-14,  1.168740831296763e-15, -1.448531951436008e-18, -1.568941284270488e-20,  6.489929079592460e-23,  1.083400080458935e-25,
 -1.492294853786144e-27,  1.015148029278748e+00, -3.375271866548386e-03,  2.008643074583169e-06,  2.306801342342779e-08, -5.738585639568121e-11, -2.153825548351299e-13,
  1.280809946928215e-15,  1.032241823608326e-18, -2.475841833646439e-20,  3.326808983655475e-23,  3.989230370068855e-25, -1.551561675829083e-27,  1.101294278409169e+00,
 -3.460149360944602e-03,  6.297725452106491e-07,  2.729217517125514e-08, -3.635912578666518e-11, -3.520424047372745e-13,  1.082888326161367e-15,  4.646416163038499e-18,
 -2.774870021583171e-20, -4.747047253876458e-23,  6.453234081322381e-25, -1.039384337746908e-28,  1.189797907779406e+00, -3.497784775859502e-03, -9.959630171428096e-07,
  3.015995847358294e-08, -3.242288239363378e-12, -4.681194182985033e-13,  4.401453501894826e-16,  8.524071658673986e-18, -1.722556194853340e-20, -1.638673141749240e-22,
  5.486660408470108e-25,  3.108797460064587e-27,  1.280139531003882e+00, -3.478277995315748e-03, -2.824474887290280e-06,  3.082313162058413e-08,  4.105674427029278e-11,
 -5.181026731076123e-13, -6.907026645280714e-16,  1.076141295958581e-17,  1.198788506370702e-20, -2.495608553358423e-22, -2.020494563037649e-25,  6.137848943516820e-27,
  1.371633592310166e+00, -3.391392676729677e-03, -4.770743697129673e-06,  2.836589626061070e-08,  9.197209211529259e-11, -4.470921924220357e-13, -2.130773209313511e-15,
  8.636997720133371e-18,  5.430702466319955e-20, -1.845273355925198e-22, -1.474797219221319e-24,  4.103294222480407e-27,  1.463382000884309e+00, -3.227428401519642e-03,
 -6.695919125163636e-06,  2.200046128427734e-08,  1.397421588119300e-10, -2.108195657188812e-13, -3.345820895803704e-15,  5.331413961690855e-20,  8.396094233513608e-20,
  1.205508035404759e-22, -2.119329021551243e-24, -6.508602724723962e-27,  1.554219618776502e+00, -2.978749777015737e-03, -8.397682692211957e-06,  1.142409836872787e-08,
  1.689748567833793e-10,  1.850032183381980e-13, -3.460168546837391e-15, -1.337650934861777e-17,  5.898593820899079e-20,  5.266755687238300e-22, -3.739890550470753e-25,
 -1.685725362970884e-26,  1.642655331951878e+00, -2.642231358154665e-03, -9.612749068108828e-06, -2.654721834757395e-09,  1.614523582751293e-10,  6.342637119984561e-13,
 -1.680946565035400e-15, -2.326582153750523e-17, -3.910992288795231e-20,  5.490713638432206e-22,  3.316055701346268e-24, -4.837405075292235e-27,  1.726818504396681e+00,
 -2.222790189287245e-03, -1.004668754529976e-05, -1.795758442406219e-08,  1.047737270238376e-10,  9.117021411182666e-13,  1.728367738806122e-15, -1.723919321593972e-17,
 -1.398071810288125e-19, -1.750307401854863e-22,  3.679681197240964e-24,  2.529755271314419e-26,  1.804430600654791e+00, -1.737806241871443e-03, -9.450094689582744e-06,
 -3.047348500832275e-08,  6.772101953514941e-12,  7.686009504471861e-13,  4.590841722957181e-15,  6.522370887033881e-18, -1.020035493256607e-19, -8.880694846509988e-22,
 -2.446368382982740e-24,  1.477972588217446e-26,  1.872834946517787e+00, -1.221365140736521e-03, -7.750257382262405e-06, -3.544095629191738e-08, -9.337845225314645e-11,
  1.839312251845684e-13,  3.962573114612969e-15,  2.505778813278085e-17,  7.057789766322477e-20, -2.763629942789270e-22, -4.712902705449203e-24, -2.886276158015557e-26,
  1.929128297706484e+00, -7.258846370549893e-04, -5.206738676849679e-06, -3.002274809197637e-08, -1.379932995369989e-10, -4.317583426176899e-13,  2.698916435150546e-17,
  1.310298871826068e-17,  1.186008046126179e-19,  6.648142679793994e-22,  2.164731342156560e-24, -3.029033287297133e-27,  1.970432258475622e+00, -3.175426113275332e-04,
 -2.487173324555028e-06, -1.667030939979356e-08, -9.949027514690091e-11, -5.300863371746524e-13, -2.453446907764952e-15, -8.987549067389488e-18, -1.601704392003840e-20,
  1.201926247448173e-22,  1.762179968884824e-24,  1.434072884574653e-26,  1.994306700537892e+00, -6.284927027215281e-05, -5.176372972429066e-07, -3.763779716863140e-09,
 -2.543784195373826e-11, -1.633355768107190e-13, -1.006904060714657e-15, -5.989119812433997e-18, -3.442781351472126e-20, -1.910695990430066e-22, -1.019944095422673e-24,
 -5.197024386256645e-27,  4.475975050731182e-04, -2.131296889250872e-06,  7.609545930160237e-09, -2.414951390151636e-11,  7.181178030003285e-14, -2.050580159917381e-16,
  5.684006787415659e-19, -1.546684516340437e-21,  4.118119406598247e-24, -1.095961416804254e-26,  2.803816179976196e-29, -7.606504317113809e-32,  4.028765735030451e-03,
 -1.916910569865637e-05,  6.831434647945917e-08, -2.160687497178946e-10,  6.390759871950721e-13, -1.810746853720703e-15,  4.965783422386503e-18, -1.332443175612420e-20,
  3.483470769420206e-23, -9.069791051926430e-26,  2.251493019738721e-28, -5.945211509374691e-31,  1.119316629011634e-02, -5.317737622329041e-05,  1.888061457278538e-07,
 -5.930914589632138e-10,  1.735142275686674e-12, -4.838045439361019e-15,  1.297290804134706e-17, -3.377640887960727e-20,  8.479308672008672e-23, -2.098846863316302e-25,
  4.837884867642504e-28, -1.191962453571313e-30,  2.194489697093885e-02, -1.040198351405672e-04,  3.672359742719875e-07, -1.141559303631600e-09,  3.283568982807096e-12,
 -8.925545852589395e-15,  2.306956909946106e-17, -5.704867321347343e-20,  1.329902130821090e-22, -2.975735721720748e-25,  5.766610616095840e-28, -1.176291845094097e-30,
  3.629002665596664e-02, -1.714880763154859e-04,  6.007968335227675e-07, -1.840921665602093e-09,  5.170955171091593e-12, -1.354838976463927e-14,  3.311444111035256e-17,
 -7.523938155283391e-20,  1.526897894528792e-22, -2.704762161837641e-25,  2.656118070290471e-28,  6.584005991335625e-32,  5.423649662301386e-02, -2.552966283150406e-04,
  8.856830940497148e-07, -2.663671348435449e-09,  7.248612225285953e-12, -1.804003425311153e-14,  4.051528007348047e-17, -7.944100152330595e-20,  1.168521272797735e-22,
 -5.797460534015086e-26, -5.944525437659045e-28,  2.675819602932129e-30,  7.579397979864455e-02, -3.550761437427304e-04,  1.217035831934432e-06, -3.575279310570364e-09,
  9.335066057482731e-12, -2.162304895216327e-14,  4.246093126464054e-17, -6.110123083685122e-20,  4.834706628661609e-24,  3.693321889250212e-25, -1.949591289371530e-27,
  5.986030481857466e-30,  1.009736893175984e-01, -4.703644986387446e-04,  1.588873765995362e-06, -4.534148925901729e-09,  1.121964554526056e-11, -2.345046869309834e-14,
  3.621807587362938e-17, -1.366197063857753e-20, -1.902047124693165e-22,  9.720790494506131e-25, -3.466685254360072e-27,  8.381797853992795e-30,  1.297881246116379e-01,
 -6.005955229941488e-04,  1.994009545035320e-06, -5.491619421942498e-09,  1.266750365100627e-11, -2.265957933612903e-14,  1.949424969881772e-17,  6.559656301216113e-20,
 -4.540453640418709e-22,  1.621658809000974e-24, -4.512655629052793e-27,  7.510153023202338e-30,  1.622507392945526e-01, -7.450850063398360e-04,  2.423951379739640e-06,
 -6.392060537960927e-09,  1.342652649185643e-11, -1.844029495144488e-14, -9.134770906217272e-18,  1.736295379735190e-19, -7.454829051021674e-22,  2.094491819030088e-24,
 -4.229188829718034e-27,  9.543296287273760e-31,  1.983755100767818e-01, -9.030135332097491e-04,  2.868790505237605e-06, -7.173117323174012e-09,  1.323671509920022e-11,
 -1.012040554445592e-14, -4.974171270675800e-17,  2.998159663774317e-19, -9.933970585314876e-22,  2.090061778559788e-24, -1.735457594809578e-27, -1.258970364869957e-29,
  2.381763794454185e-01, -1.073405600053165e-03,  3.317075828072594e-06, -7.766186987903244e-09,  1.184277515536437e-11,  2.730214484152510e-15, -1.005285293262114e-16,
  4.245635440154778e-19, -1.098958167280236e-21,  1.282226197035573e-24,  3.523605882915784e-27, -3.175842114484602e-29,  2.816665363703373e-01, -1.255104346516007e-03,
  3.755678551309940e-06, -8.097240931465537e-09,  9.010817266367161e-12,  2.017509819285660e-14, -1.573093099499651e-16,  5.187724158548672e-19, -9.456101919765699e-22,
 -5.881556604917695e-25,  1.129926285622477e-26, -5.097036835736451e-29,  3.288574881539842e-01, -1.446741100001115e-03,  4.169651877193505e-06, -8.088147143345958e-09,
  4.550240489290960e-12,  4.176676207232501e-14, -2.130619012797693e-16,  5.447784203036406e-19, -4.197606089429463e-22, -3.576444782435853e-24,  2.000742485383338e-26,
 -5.962400473260050e-29,  3.797578617955848e-01, -1.646698786064648e-03,  4.542094496153762e-06, -7.658704278590850e-09, -1.657986745537112e-12,  6.638608991062652e-14,
 -2.576566879183087e-16,  4.595998302073262e-19,  5.551384687595838e-22, -7.362103963087916e-24,  2.631563280216501e-26, -4.320145186274182e-29,  4.343718536202303e-01,
 -1.853068107126973e-03,  4.854032134703669e-06, -6.729672314863181e-09, -9.625385295271120e-12,  9.207519364966835e-14, -2.779302474066677e-16,  2.215018394761704e-19,
  1.969835518142293e-21, -1.107169130179065e-23,  2.515244403160383e-26,  1.226019188241719e-29,  4.926972197048115e-01, -2.063595257072908e-03,  5.084339912491967e-06,
 -5.227178884192183e-09, -1.921126444388455e-11,  1.158834261048642e-13, -2.583505707016947e-16, -1.990220463201953e-19,  3.668139620841597e-21, -1.316281914994090e-23,
  1.059029201043737e-26,  1.110459811204742e-28,  5.547226644801152e-01, -2.275619856895919e-03,  5.209741050815896e-06, -3.088996145969585e-09, -3.006875569969705e-11,
  1.337623122001086e-13, -1.826164513006819e-16, -8.029624315256766e-19,  5.282927605728433e-21, -1.148565890828397e-23, -2.185506994771837e-26,  2.340545107064916e-28,
  6.204244376592443e-01, -2.486001836292526e-03,  5.204936590178446e-06, -2.733157356947358e-10, -4.158247382152599e-11,  1.405699052338956e-13, -3.663068464930358e-17,
 -1.541168846416113e-18,  6.191640518833447e-21, -3.698023661159299e-24, -7.109423558642761e-26,  3.241284350536080e-28,  6.897618861652776e-01, -2.691036273937872e-03,
  5.042949016851341e-06,  3.229218926488901e-09, -5.280152933139608e-11,  1.302810991752132e-13,  1.866596169453673e-16, -2.289460977714591e-18,  5.533553428043074e-21,
  1.174917246801257e-23, -1.247552028556690e-25,  2.808574091681837e-28,  7.626716225970918e-01, -2.886355967414309e-03,  4.695803800704212e-06,  7.379378259454952e-09,
 -6.237688593434729e-11,  9.654890020425093e-14,  4.801535818635693e-16, -2.826804093421279e-18,  2.357174753127029e-21,  3.388803763402014e-23, -1.538371511646620e-25,
 -1.499227033502230e-29,  8.390598582609126e-01, -3.066823118127879e-03,  4.135731355347559e-06,  1.206832638700732e-08, -6.852126716556938e-11,  3.381826449010063e-14,
  8.132569230692886e-16, -2.830359176302738e-18, -4.010696561355844e-21,  5.688698523187155e-23, -1.128474783979002e-25, -6.199093783501972e-28,  9.187922992129157e-01,
 -3.226414644913317e-03,  3.337152356599908e-06,  1.709134228157542e-08, -6.902498162161376e-11, -6.076002009814786e-14,  1.121509542593269e-15, -1.912501414905856e-18,
 -1.329057901399859e-20,  6.795103583747909e-23,  4.511558057356783e-26, -1.373312437085639e-27,  1.001680810816693e+00, -3.358111382748499e-03,  2.279813474111710e-06,
  2.211705691997912e-08, -6.138422957984861e-11, -1.843845959349291e-13,  1.298822158977271e-15,  2.620774247336105e-19, -2.329053181705913e-20,  4.780218329695977e-23,
  3.265466001314802e-25, -1.721196126324864e-27,  1.087465816875845e+00, -3.453811571574924e-03,  9.535605137996529e-07,  2.665555687047338e-08, -4.313006723238213e-11,
 -3.245936297566918e-13,  1.200335060957345e-15,  3.736076213474015e-18, -2.899584999164828e-20, -2.193939444414672e-23,  6.266606549886979e-25, -7.308707544190793e-28,
  1.175793123246570e+00, -3.504306391306825e-03, -6.346616558916705e-07,  3.003383666462812e-08, -1.248005359681540e-11, -4.547594225296747e-13,  6.702471338997803e-16,
  7.882955210998088e-18, -2.269894262278534e-20, -1.394241063192472e-22,  6.673717369231292e-25,  2.269210410538687e-27,  1.266183584703190e+00, -3.499383909518113e-03,
 -2.451000444115281e-06,  3.139634554671566e-08,  3.055351769494211e-11, -5.310286981655332e-13, -3.853712079361657e-16,  1.100024768673773e-17,  2.923428623970497e-21,
 -2.522334321983522e-22,  6.791763977870467e-26,  6.069042225391076e-27,  1.357993879911294e+00, -3.428172744086909e-03, -4.421827469401294e-06,  2.976322213008748e-08,
  8.253943879754153e-11, -4.951388798036483e-13, -1.865685346608010e-15,  1.025753673342372e-17,  4.665088591526414e-20, -2.393426390698698e-22, -1.252507792207148e-24,
  5.948873939747365e-27,  1.450366877810115e+00, -3.279902071278779e-03, -6.418651601531151e-06,  2.419824775952603e-08,  1.347244753049727e-10, -2.907943388868611e-13,
 -3.306180846571583e-15,  2.792625677102662e-18,  8.671280938084471e-20,  3.082434703532364e-23, -2.346771206365959e-24, -3.735238806439070e-27,  1.542171190196252e+00,
 -3.045336669396211e-03, -8.244264777388889e-06,  1.415266124849378e-08,  1.718153189553258e-10,  9.769533895975458e-14, -3.805463846972763e-15, -1.118995608009278e-17,
  7.749469893468854e-20,  4.965107086328543e-22, -1.141224177271126e-24, -1.781004799910517e-26,  1.631932464024789e+00, -2.719215913575419e-03, -9.628695400786925e-06,
  2.758234508250967e-11,  1.736807883688877e-10,  5.859814241434173e-13, -2.346759677792043e-15, -2.417600106831674e-17, -1.702399339834196e-20,  6.755904372956811e-22,
  2.962536322318601e-24, -1.133183796439699e-26,  1.717765273939961e+00, -2.303995755670223e-03, -1.025151172701837e-05, -1.613325193415044e-08,  1.233808460625836e-10,
  9.468803024710402e-13,  1.182304582256850e-15, -2.178325783571254e-17, -1.431910815199369e-19, -5.661423009207000e-24,  4.782454119048909e-24,  2.441809455618503e-26,
  1.797325862377511e+00, -1.814866677209730e-03, -9.814599566705514e-06, -3.023611369503737e-08,  2.325868176568094e-11,  8.805736421535714e-13,  4.722837815564069e-15,
  2.729280950929779e-18, -1.355533671071661e-19, -9.701096188323791e-22, -1.583023425713118e-24,  2.474244231877986e-26,  1.867822752879074e+00, -1.285093450286734e-03,
 -8.184374394091653e-06, -3.690017232593357e-08, -8.869070412740861e-11,  2.876970502130897e-13,  4.694040362635134e-15,  2.711817667890487e-17,  5.692178997542971e-20,
 -4.910990046650710e-22, -6.041052287501586e-24, -3.119981273349929e-26,  1.926139115756990e+00, -7.690178279480652e-04, -5.580543497174269e-06, -3.229955428035645e-08,
 -1.465899590071560e-10, -4.262564343425116e-13,  4.507211387129242e-16,  1.729749950616416e-17,  1.440453292948118e-19,  7.470236778116996e-22,  1.898577625188507e-24,
 -9.516442662262371e-27,  1.969120987020340e+00, -3.382680610756645e-04, -2.697128560279594e-06, -1.835025345810251e-08, -1.107014933960997e-10, -5.920422805916663e-13,
 -2.711518904847503e-15, -9.415945243569314e-18, -1.025699600988999e-20,  2.046649414048070e-22,  2.497430539662291e-24,  1.928645009768382e-26,  1.994046725106232e+00,
 -6.717820626254291e-05, -5.653569026803126e-07, -4.198291223714203e-09, -2.896046520795261e-11, -1.896447582268701e-13, -1.191115980176335e-15, -7.209209114296465e-18,
 -4.209914913887578e-20, -2.368140100847948e-22, -1.277045160490653e-24, -6.539232864192338e-27,  4.391922620587063e-04, -2.071560472617345e-06,  7.326512717287291e-09,
 -2.303260796591174e-11,  6.784360370268262e-14, -1.919215515609606e-16,  5.268806223510530e-19, -1.421007382865319e-21,  3.742975673445464e-24, -9.902684568252185e-27,
  2.486366434260597e-29, -6.846532437684447e-32,  3.953166162383198e-03, -1.863279110902444e-05,  6.578169831893806e-08, -2.061269026582066e-10,  6.040232567415659e-13,
 -1.695922054430352e-15,  4.607826526164155e-18, -1.226027508068477e-20,  3.172554341683493e-23, -8.219799262992215e-26,  2.002510524106642e-28, -5.389882825009438e-31,
  1.098343326533966e-02, -5.169493073429572e-05,  1.818524827008296e-07, -5.660866692736722e-10,  1.641419815398972e-12, -4.537744758533856e-15,  1.206404604158614e-17,
 -3.118028972271352e-20,  7.757318301682878e-23, -1.915541384113675e-25,  4.333950751652884e-28, -1.101896194884861e-30,  2.153460789070451e-02, -1.011358624362482e-04,
  3.538466903729587e-07, -1.090420739101776e-09,  3.110467819836747e-12, -8.390573397613797e-15,  2.153020655213615e-17, -5.296003772415643e-20,  1.226803560379794e-22,
 -2.755348938513553e-25,  5.254286168322591e-28, -1.155012305815068e-30,  3.561354914883939e-02, -1.667686797039692e-04,  5.791933812366574e-07, -1.760311650455790e-09,
  4.907767014302614e-12, -1.277838040765397e-14,  3.107469426860554e-17, -7.050705021307671e-20,  1.431440053367567e-22, -2.598572553274730e-25,  2.637820216085316e-28,
 -1.477992869598584e-31,  5.322928134797872e-02, -2.483370752461730e-04,  8.544031673078764e-07, -2.550527875088823e-09,  6.897357210219247e-12, -1.709393925760296e-14,
  3.834293658816186e-17, -7.573949632773692e-20,  1.143637975683145e-22, -7.957449506782649e-26, -4.898384685680100e-28,  2.085513106868271e-30,  7.439287961753938e-02,
 -3.455089638663861e-04,  1.175014553103497e-06, -3.429323153645657e-09,  8.912657264916337e-12, -2.062448737327122e-14,  4.075415716972256e-17, -6.074833767114978e-20,
  1.678783453645497e-23,  2.963312450077998e-25, -1.707427431633985e-27,  5.028386424868817e-30,  9.911731296971582e-02, -4.578681312542041e-04,  1.535525740148423e-06,
 -4.358339585828583e-09,  1.075929410349983e-11, -2.258648167857769e-14,  3.575540315816913e-17, -1.921466365860445e-20, -1.576197870404857e-22,  8.404812157576398e-25,
 -3.120823838989496e-27,  7.335597704016446e-30,  1.274172341284291e-01, -5.849036330795490e-04,  1.929311320980529e-06, -5.292538880098942e-09,  1.221913119643842e-11,
 -2.217126601304375e-14,  2.113607288288235e-17,  5.196698692892593e-20, -3.988364391853623e-22,  1.447614128661443e-24, -4.193562578436021e-27,  6.963110604747692e-30,
  1.593087018134123e-01, -7.259965902911609e-04,  2.348523395049013e-06, -6.180196867688839e-09,  1.305590839942394e-11, -1.860381708841018e-14, -4.596017016932732e-18,
  1.509479605172602e-19, -6.731137869003362e-22,  1.926411336585139e-24, -4.169517671975315e-27,  1.684759978631133e-30,  1.948088164972135e-01, -8.804039342033708e-04,
  2.783976940077558e-06, -6.963011219160273e-09,  1.302303068846559e-11, -1.121699158955136e-14, -4.178069766159824e-17,  2.692167053830522e-19, -9.195302342333654e-22,
  2.010392691548255e-24, -2.228762224457222e-27, -9.948538456529468e-30,  2.339352445802922e-01, -1.047238545851135e-03,  3.225019878814574e-06, -7.576392869395825e-09,
  1.187419515511906e-11,  4.562528567684311e-16, -8.912596542432265e-17,  3.901599974302492e-19, -1.050585155393475e-21,  1.396600333389809e-24,  2.227810284008021e-27,
 -2.726816071601790e-29,  2.767055979497190e-01, -1.225445105370248e-03,  3.659389363025939e-06, -7.950040093857983e-09,  9.377723828103397e-12,  1.657054640664316e-14,
 -1.432099018267527e-16,  4.882570449940006e-19, -9.591752554912715e-22, -1.795551642633187e-25,  9.166770959946057e-27, -4.602937835261774e-29,  3.231366253135823e-01,
 -1.413770816674985e-03,  4.073057614751643e-06, -8.008933288792738e-09,  5.335668102268684e-12,  3.683469056541669e-14, -1.980144423204530e-16,  5.294354103584741e-19,
 -5.347340158874575e-22, -2.828003028604159e-24,  1.743088704296028e-26, -5.740274951042468e-29,  3.732431575953873e-01, -1.610730000127337e-03,  4.450073616595938e-06,
 -7.674941868015006e-09, -3.910508186372457e-13,  6.035852460055615e-14, -2.445776079759437e-16,  4.733230252790029e-19,  3.085764334389817e-22, -6.349162425865154e-24,
  2.429385521536081e-26, -4.837129437097614e-29,  4.270367307361997e-01, -1.814561354814614e-03,  4.772411631647451e-06, -6.869306637447274e-09, -7.850047040682896e-12,
  8.548605392891038e-14, -2.709042406623458e-16,  2.783541933204546e-19,  1.589445910085378e-21, -1.006008262650251e-23,  2.530332421512510e-26, -4.863909554345550e-30,
  4.845237837018619e-01, -2.023176493877738e-03,  5.019844871668789e-06, -5.516356317893998e-09, -1.695598473719624e-11,  1.096289702948102e-13, -2.623504630797204e-16,
 -8.913259587249419e-20,  3.202997606431494e-21, -1.265056688043939e-23,  1.480311584971662e-26,  8.095051370873348e-29,  5.457032948653014e-01, -2.234098177270933e-03,
  5.169873988201151e-06, -3.548939704529664e-09, -2.743906143711563e-11,  1.291284374542638e-13, -2.027958974962356e-16, -6.406736883639016e-19,  4.856095289224033e-21,
 -1.216431980719694e-23, -1.233685335640716e-26,  1.985294533108688e-28,  6.105636728410755e-01, -2.444386559874582e-03,  5.197757466149645e-06, -9.162061693011358e-10,
 -3.878324733398270e-11,  1.391951830934985e-13, -7.703332406375860e-17, -1.345687672965266e-18,  6.010713030748247e-21, -6.261934244567087e-24, -5.724920520865989e-26,
  3.038575258195347e-28,  6.790786536615919e-01, -2.650551841808648e-03,  5.076717412452461e-06,  2.405461406189342e-09, -5.015619659125239e-11,  1.340120374234180e-13,
  1.250906044802640e-16, -2.106558083913035e-18,  5.869767706503123e-21,  7.015697698400940e-24, -1.117145376303714e-25,  3.089020187285014e-28,  7.512018686667155e-01,
 -2.848452142675941e-03,  4.778433836079827e-06,  6.397395285001652e-09, -6.033703358254719e-11,  1.071323883346700e-13,  4.022340189395010e-16, -2.733041876014100e-18,
  3.466529094135566e-21,  2.775471880336024e-23, -1.520446534099683e-25,  9.265321500440292e-29,  8.268596284470121e-01, -3.033176567244267e-03,  4.273998911396400e-06,
  1.097843033968307e-08, -6.765620650831581e-11,  5.237278716267847e-14,  7.325114422863271e-16, -2.926855847675013e-18, -2.050095106784757e-21,  5.188167107912130e-23,
 -1.360949139077350e-25, -4.383497802704423e-28,  9.059413073974799e-01, -3.198915899373608e-03,  3.535586649620161e-06,  1.597866437825858e-08, -6.997559603314570e-11,
 -3.453218038783531e-14,  1.062374886068180e-15, -2.298427410855224e-18, -1.082601691304629e-20,  6.859205905876723e-23, -1.188823001513971e-26, -1.212066606854368e-27,
  9.882864992704292e-01, -3.338828221988550e-03,  2.539209066719123e-06,  2.110710237645481e-08, -6.476003797835907e-11, -1.532073481483712e-13,  1.296001980266518e-15,
 -4.533145061010025e-19, -2.135305336388159e-20,  5.932198940789165e-23,  2.489402425206809e-25, -1.790484931924845e-27,  1.073667836180673e+00, -3.444915835157217e-03,
  1.269077640835520e-06,  2.591513972434359e-08, -4.932593033899506e-11, -2.946356742509971e-13,  1.291870396026859e-15,  2.800336871135573e-18, -2.934373070552833e-20,
  2.319727915445789e-24,  5.824248208454656e-25, -1.261973039177939e-27,  1.161768019970357e+00, -3.507946140158242e-03, -2.757508097857121e-07,  2.976234181321829e-08,
 -2.139694738567117e-11, -4.361113468012508e-13,  8.800839758063177e-16,  7.081612331825805e-18, -2.721605386440902e-20, -1.109981540660161e-22,  7.472631690333385e-25,
  1.355474528673615e-27,  1.252149229845164e+00, -3.517477387836150e-03, -2.071662980242412e-06,  3.179983951945208e-08,  1.986542234189587e-11, -5.365793115313781e-13,
 -7.741292822739933e-17,  1.094955182816455e-17, -6.044626167841722e-21, -2.442808644676493e-22,  3.264638204181706e-25,  5.623995390411390e-27,  1.344212732383899e+00,
 -3.462097046372932e-03, -4.057079416135477e-06,  3.100229865780728e-08,  7.221299762205965e-11, -5.363084001683089e-13, -1.558935876557353e-15,  1.160337460048616e-17,
  3.720008950537459e-20, -2.837459837825841e-22, -9.570249535527874e-25,  7.407043073403157e-27,  1.437146461282557e+00, -3.330053593003719e-03, -6.115544882121708e-06,
  2.630303324406023e-08,  1.281230612574338e-10, -3.688904327956396e-13, -3.189103926710447e-15,  5.566806771694030e-18,  8.610158855706286e-20, -6.540709436943104e-23,
 -2.441224092559838e-24, -5.023774294730822e-28,  1.529859077016117e+00, -3.110564610359294e-03, -8.057890445624881e-06,  1.691227400238937e-08,  1.728320526277054e-10,
  2.900765176755604e-15, -4.081449574715513e-15, -8.434479635915983e-18,  9.435850711561514e-20,  4.352050462791240e-22, -1.921057667228240e-24, -1.739570265306407e-26,
  1.620901611181621e+00, -2.796196041990826e-03, -9.611314852823790e-06,  2.896940844808125e-09,  1.847821434716327e-10,  5.214977609254162e-13, -3.027501339870862e-15,
 -2.430985293218044e-17,  9.291907335849699e-21,  7.821175310949733e-22,  2.314158527597330e-24, -1.813905375861328e-26,  1.708384089889611e+00, -2.386747237781902e-03,
 -1.043263684298129e-05, -1.400633250467743e-08,  1.425501290014561e-10,  9.674198417341589e-13,  5.084682902938146e-16, -2.632965855556181e-17, -1.397000226809240e-19,
  2.062669130836040e-22,  5.787326690351660e-24,  2.075344715769907e-26,  1.789907074877482e+00, -1.894827102263746e-03, -1.017459892087012e-05, -2.971690767645055e-08,
  4.200715412454235e-11,  9.943159767860421e-13,  4.733205694205702e-15, -2.177107722305743e-18, -1.713251518150565e-19, -1.008393366662491e-21, -2.484257366947919e-25,
  3.608771653887554e-26,  1.862548591245514e+00, -1.352363299219233e-03, -8.635480348097649e-06, -3.826680939326642e-08, -8.174770126615319e-11,  4.096534853837328e-13,
  5.475844314008790e-15,  2.860746404916604e-17,  3.455981731625560e-20, -7.603758443120652e-22, -7.421762289346994e-24, -3.103529735726616e-26,  1.922971243844209e+00,
 -8.152530702343065e-04, -5.982489736798047e-06, -3.471243254719439e-08, -1.549648846906096e-10, -4.090809492460498e-13,  1.003725351234440e-15,  2.235092444586722e-17,
  1.721812644899108e-19,  8.120206552735665e-22,  1.281470759466135e-24, -1.911306383211768e-26,  1.967723322374501e+00, -3.607569358537692e-04, -2.928361392833216e-06,
 -2.021983015077161e-08, -1.232146190536732e-10, -6.603120409412261e-13, -2.978505284184379e-15, -9.605239273133440e-18, -8.706363195564885e-22,  3.232852555512828e-22,
  3.479522996062468e-24,  2.559686478700765e-26,  1.993768635986598e+00, -7.191075541264857e-05, -6.186469931855524e-07, -4.693626518525968e-09, -3.305640020066237e-11,
 -2.208143108305507e-13, -1.413189574100497e-15, -8.703235789489285e-18, -5.161747354143523e-20, -2.941172383168496e-22, -1.600315645930430e-24, -8.215260904773807e-27,
  };
  constexpr double w[14208] = {  8.372152836843015e-02, -2.968286955433387e-04,  1.109402771903882e-06, -4.310176748370014e-09,  1.716674551311504e-11,
 -6.932654065537256e-14,  2.817087611075364e-16, -1.146298276448894e-18,  4.657387454312406e-21, -1.886504290956534e-23,  7.611975289432560e-26, -3.058577426991582e-28,
  8.328931111315717e-02, -4.364194296870723e-04,  2.658726514271770e-06, -1.616079687243204e-08,  9.503624842989322e-11, -5.409152652833072e-13,  2.994725691972886e-15,
 -1.620004023508829e-17,  8.591771319715043e-20, -4.478879115031417e-22,  2.299507059015667e-24, -1.164532352776345e-26,  8.243432318686006e-02, -7.103690097049174e-04,
  6.386524462934678e-06, -5.242672867939159e-08,  4.005313234006778e-10, -2.898901654303634e-12,  2.009957224375844e-14, -1.344984004899761e-16,  8.732298761473881e-19,
 -5.522744209372672e-21,  3.413076135698410e-23, -2.066162947816480e-25,  8.117501069462864e-02, -1.108504488527389e-03,  1.347948306685224e-05, -1.421859381689215e-07,
  1.362143609555389e-09, -1.214723622715900e-11,  1.023500234175916e-13, -8.230105806840503e-16,  6.361338733985531e-18, -4.751721195392203e-20,  3.444429398805095e-22,
 -2.430859122603770e-24,  7.953795897066765e-02, -1.616269489686285e-03,  2.554676456067440e-05, -3.378454663559110e-07,  3.968581554014272e-09, -4.269222362341178e-11,
  4.284934625718543e-13, -4.062938409370177e-15,  3.671937940066594e-17, -3.184064226193925e-19,  2.662638992582308e-21, -2.155816011800670e-23,  7.755668309742292e-02,
 -2.215503302542781e-03,  4.443672097898860e-05, -7.228865504279915e-07,  1.023308812358786e-08, -1.306986608692008e-10,  1.539673444946714e-12, -1.697681926317469e-14,
  1.770430011464508e-16, -1.759768981267541e-18,  1.677143298126665e-20, -1.539680083597959e-22,  7.527015673056647e-02, -2.885379854033502e-03,  7.202560455685873e-05,
 -1.418145982164721e-06,  2.385034772885644e-08, -3.570500210984041e-10,  4.878607398797613e-12, -6.186244061819346e-14,  7.366249794524507e-16, -8.309122109158481e-18,
  8.938683308100581e-20, -9.218641012227752e-22,  7.272118125136549e-02, -3.603435358298631e-03,  1.100008538001436e-04, -2.584278167718436e-06,  5.100715719337448e-08,
 -8.852774024295860e-10,  1.388972885481835e-11, -2.006607275189110e-13,  2.704239420132514e-15, -3.432742235796063e-17,  4.135015026951494e-19, -4.753906851808673e-21,
  6.995470187958561e-02, -4.346611153854579e-03,  1.596610686320225e-04, -4.418562031552594e-06,  1.012417256040162e-07, -2.017533690999354e-09,  3.602901468695864e-11,
 -5.881721813924322e-13,  8.902513049075377e-15, -1.262503855397298e-16,  1.691094523298457e-18, -2.152906795796540e-20,  6.701617234587122e-02, -5.092242973318901e-03,
  2.217517437770981e-04, -7.145112364234676e-06,  1.881808297368310e-07, -4.268240020139738e-09,  8.606894187418419e-11, -1.576129373683121e-12,  2.660963000145850e-14,
 -4.188521102529001e-16,  6.200246477889044e-18, -8.689154157985936e-20,  6.395005642845247e-02, -5.818938517925794e-03,  2.963508034372301e-04, -1.099865100619039e-05,
  3.299402915941771e-07, -8.449408980918925e-09,  1.909958901905762e-10, -3.897117145542761e-12,  7.292946293687329e-14, -1.266648970780391e-15,  2.060517295894655e-17,
 -3.161711122980770e-19,  6.079853531359448e-02, -6.507299987682257e-03,  3.828117950212374e-04, -1.620308446429257e-05,  5.489701052010537e-07, -1.575465662037236e-08,
  3.965201670473686e-10, -8.958799392354270e-12,  1.847548889399069e-13, -3.521298502305362e-15,  6.262386380383103e-17, -1.046913726330181e-18,  5.760046698832287e-02,
 -7.140465109104093e-03,  4.797661524242433e-04, -2.294702936330106e-05,  8.711700073941971e-07, -2.782215792066058e-08,  7.747264315791559e-10, -1.926896770543148e-11,
  4.355364204475266e-13, -9.062734915016473e-15,  1.753496848472663e-16, -3.179001521915492e-18,  5.439062039946505e-02, -7.704457182974052e-03,  5.851800555485690e-04,
 -3.135898271654212e-05,  1.324191778110440e-06, -4.675235494389369e-08,  1.431728199680314e-09, -3.898499648616292e-11,  9.608318785399038e-13, -2.172239302711674e-14,
  4.551678378210419e-16, -8.909947970823499e-18,  5.119918528296540e-02, -8.188350004992347e-03,  6.964567312958850e-04, -4.148497865096122e-05,  1.934967265998946e-06,
 -7.505607711125464e-08,  2.513483135921131e-09, -7.453517951872413e-11,  1.993283205925958e-12, -4.873655836182701e-14,  1.101142450306406e-15, -2.317720065387517e-17,
  4.805154018624255e-02, -8.584265920604748e-03,  8.105719473598689e-04, -5.327131172917866e-05,  2.726634283322865e-06, -1.155141449208845e-07,  4.207376826516335e-09,
 -1.351984105550326e-10,  3.904861272120870e-12, -1.028026539568082e-13,  2.494054441498033e-15, -5.622258141246477e-17,  4.496824738797665e-02, -8.887234041588209e-03,
  9.242290602016059e-04, -6.655431050324609e-05,  3.715151422665556e-06, -1.709405677343103e-07,  6.737019928287020e-09, -2.334652611915650e-10,  7.249932556511652e-12,
 -2.046483669066561e-13,  5.309834426832000e-15, -1.277063538834176e-16,  4.196523458036572e-02, -9.094940597184143e-03,  1.034020170425296e-03, -8.105832962701653e-05,
  4.905975425672051e-06, -2.438568024693688e-07,  1.034811620626185e-08, -3.849575132593288e-10,  1.279755794042687e-11, -3.857501138947175e-13,  1.066274016733584e-14,
 -2.725982502190872e-16,  3.905411912707269e-02, -9.207404793697579e-03,  1.136581413479797e-03, -9.640222979914239e-05,  6.291205976284502e-06, -3.361017179401940e-07,
  1.528432848313179e-08, -6.076775204723627e-10,  2.153679359187971e-11, -6.904824901317626e-13,  2.025713786877301e-14, -5.485303473779826e-16,  3.624263079926128e-02,
 -9.226612015886019e-03,  1.228732771998339e-03, -1.121137606870697e-04,  7.847577342907824e-06, -4.484177398804613e-07,  2.175372172231131e-08, -9.204125386299657e-10,
  3.463655190009819e-11, -1.176629983416783e-12,  3.650465819811127e-14, -1.043346720221743e-15,  3.353509219914937e-02, -9.156132503063024e-03,  1.307595613838939e-03,
 -1.276505555720496e-04,  9.535598732337542e-06, -5.800649785948499e-07,  2.988835833313278e-08, -1.340240129112592e-09,  5.334379965992791e-11, -1.912985418803344e-12,
  6.254118934471895e-14, -1.880324621368470e-15,  3.093292157747021e-02, -9.000748598720873e-03,  1.370684049422090e-03, -1.424259532957069e-04,  1.130002830305505e-05,
 -7.285195045374953e-07,  3.970159279913712e-08, -1.879259495350180e-09,  7.881188717158366e-11, -2.972857831036756e-12,  1.020649228549091e-13, -3.217311875200815e-15,
  2.843512944754851e-02, -8.766108067329345e-03,  1.415968854258500e-03, -1.558376086655980e-04,  1.307172736032654e-05, -8.893080815978347e-07,  5.104913936741014e-08,
 -2.540881989311487e-09,  1.118646144064725e-10, -4.422844005393752e-12,  1.589237119074118e-13, -5.235408723886808e-15,  2.603878744129974e-02, -8.458415423744302e-03,
  1.441914907409581e-03, -1.672968265184582e-04,  1.477080065486849e-05, -1.056019772118250e-06,  6.360068624520738e-08, -3.316208951654594e-09,  1.527194149964003e-10,
 -6.307211761442485e-12,  2.364165093546089e-13, -8.113512029342112e-15,  2.373945458161395e-02, -8.084168187692267e-03,  1.447494743878272e-03, -1.762567201057915e-04,
  1.631080346883171e-05, -1.220516426658500e-06,  7.682845020542464e-08, -4.181157411031019e-09,  2.007111498646535e-10, -8.629577176783318e-12,  3.363416826534810e-13,
 -1.198756289956860e-14,  2.153155211149059e-02, -7.649940742935133e-03,  1.432181885757741e-03, -1.822375985574703e-04,  1.760369962941984e-05, -1.373341721331099e-06,
  9.001754586519754e-08, -5.095020634428850e-09,  2.540716811864596e-10, -1.133494835275542e-11,  4.579153317239276e-13, -1.689771556242159e-14,  1.940868296990078e-02,
 -7.162215177880960e-03,  1.395928147003724e-03, -1.848483730286471e-04,  1.856519460313199e-05, -1.504305190585114e-06,  1.023005357040302e-07, -6.001045234270436e-09,
  3.098248895784890e-10, -1.429625527034772e-11,  5.967738562149558e-13, -2.273212291307509e-14,  1.736389584938460e-02, -6.627256118263278e-03,  1.339129186490924e-03,
 -1.838031825540556e-04,  1.912004664687171e-05, -1.603196704547030e-06,  1.127153702367583e-07, -6.829369479797806e-09,  3.638487384583361e-10, -1.730977442439430e-11,
  7.443368763583629e-13, -2.918106567000858e-14,  1.538989654688859e-02, -6.051025053106058e-03,  1.262582320992384e-03, -1.789328340738768e-04,  1.920697403480916e-05,
 -1.660570669786625e-06,  1.202825902574043e-07, -7.502327133015865e-09,  4.111346005880445e-10, -2.010309092661251e-11,  8.878090118012858e-13, -3.571772768228117e-14,
  1.347921114767003e-02, -5.439128871576852e-03,  1.167440114369944e-03, -1.701909947293120e-04,  1.878282152706546e-05, -1.668529708656672e-06,  1.240946564724666e-07,
 -7.941730695461177e-09,  4.462417826397388e-10, -2.235736091386352e-11,  1.011022579175925e-12, -4.162022325404223e-14,  1.162430663570100e-02, -4.796797120572062e-03,
  1.055162632999661e-03, -1.576553498831065e-04,  1.782571639594993e-05, -1.621435563737612e-06,  1.234080645166853e-07, -8.077375618650796e-09,  4.639074989318146e-10,
 -2.374289114055837e-11,  1.096169176988748e-12, -4.604267919223061e-14,  9.817675022838037e-03, -4.128882724251701e-03,  9.274705875198950e-04, -1.415241413693805e-04,
  1.633702487132816e-05, -1.516480410282142e-06,  1.177278454438986e-07, -7.855722864581038e-09,  4.597369832774154e-10, -2.396397770691195e-11,  1.126262714386047e-12,
 -4.813202522292157e-14,  8.051887383014777e-03, -3.439881514495709e-03,  7.863009484034644e-04, -1.221086329943276e-04,  1.434200606200444e-05, -1.354063786634430e-06,
  1.068743261308132e-07, -7.247579364471458e-09,  4.308729449210081e-10, -2.280626033130510e-11,  1.087967754939910e-12, -4.717413667652600e-14,  6.319625322197884e-03,
 -2.733967184523825e-03,  6.337661644793953e-04, -9.982213899728798e-05,  1.188914734515981e-05, -1.137937663011896e-06,  9.102363510921270e-08, -6.253639730037100e-09,
  3.765347459204660e-10, -2.017827734167448e-11,  9.742733934263468e-13, -4.274179986734842e-14,  4.613705575756380e-03, -2.015042769187693e-03,  4.721184870461697e-04,
 -7.516641148985149e-05,  9.048260282914739e-06, -8.751041343922576e-07,  7.071629521228595e-08, -4.906988547088615e-09,  2.983293878438173e-10, -1.613899999744838e-11,
  7.864468384513894e-13, -3.481149635410392e-14,  2.927191141369502e-03, -1.286844982566048e-03,  3.037286625416814e-04, -4.871748505503601e-05,  5.907644673219569e-06,
 -5.754874674267014e-07,  4.683303650453479e-08, -3.272134608816931e-09,  2.002725080443314e-10, -1.090529601540283e-11,  5.348021865265853e-13, -2.381937875799746e-14,
  1.255312134872878e-03, -5.538583669978217e-04,  1.312587370627430e-04, -2.114058133397613e-05,  2.574041546320315e-06, -2.517517616222564e-07,  2.056770249916126e-08,
 -1.442517031405991e-09,  8.861892925554893e-11, -4.843031239261173e-12,  2.383457866817487e-13, -1.065210450411748e-14,  8.255164291321604e-02, -2.881557955399303e-04,
  1.059284063808417e-06, -4.046244336044422e-09,  1.584530944699510e-11, -6.293445264698183e-14,  2.516008634320949e-16, -1.007565822794814e-18,  4.029959790826227e-21,
 -1.607298634773114e-23,  6.386941494624060e-26, -2.527751107754557e-28,  8.158498023905252e-02, -4.159002835267109e-04,  2.473575668953858e-06, -1.472300703737688e-08,
  8.490148024128445e-11, -4.741886715432872e-13,  2.577312724372148e-15, -1.369185976250312e-17,  7.133302173001132e-20, -3.653833454242983e-22,  1.843670407850235e-24,
 -9.178190963830422e-27,  7.969119530971402e-02, -6.616885946391309e-04,  5.794022984557926e-06, -4.645706780696116e-08,  3.470877175757157e-10, -2.458720493892575e-12,
  1.669671536182059e-14, -1.094894520972967e-16,  6.969428757597213e-19, -4.323243010967772e-21,  2.621421787753926e-23, -1.557488380167134e-25,  7.694635810514439e-02,
 -1.007140679938100e-03,  1.189641229164902e-05, -1.222091743476645e-07,  1.142008806268239e-09, -9.945855093722302e-12,  8.191625622276075e-14, -6.443544223337791e-16,
  4.874949898285871e-18, -3.566156403752873e-20,  2.532739345810893e-22, -1.751985830389206e-24,  7.345739571931152e-02, -1.427093946165413e-03,  2.184713566565787e-05,
 -2.806565809271425e-07,  3.209004570851988e-09, -3.365065054469146e-11,  3.295947229801546e-13, -3.052486155552095e-15,  2.696539419406023e-17, -2.286990850674060e-19,
  1.871559260115109e-21, -1.483619539049239e-23,  6.935440113662882e-02, -1.892111065099189e-03,  3.666428587448430e-05, -5.782120003073177e-07,  7.953209144937964e-09,
 -9.886473789041391e-11,  1.134965565294547e-12, -1.220777418885580e-14,  1.242949539382489e-16, -1.207090198448096e-18,  1.124702609862043e-20, -1.010009252119252e-22,
  6.478175961549157e-02, -2.371262855442932e-03,  5.708093930812508e-05, -1.087851038528593e-06,  1.775258614644962e-08, -2.583391416268048e-10,  3.435993740885066e-12,
 -4.245865116932247e-14,  4.931466664108678e-16, -5.430314051017568e-18,  5.706749682154899e-20, -5.753074980073244e-22,  5.988899845269801e-02, -2.834836698160080e-03,
  8.335576413018399e-05, -1.893443771872176e-06,  3.622612208518152e-08, -6.106044927299891e-10,  9.317537924725382e-12, -1.310741673578175e-13,  1.721810983187827e-15,
 -2.132281468996684e-17,  2.507691717271318e-19, -2.816680407662665e-21,  5.482221053501830e-02, -3.256662867265849e-03,  1.151641301338498e-04, -3.079587752971854e-06,
  6.835415309897576e-08, -1.322046649115512e-09,  2.294859376357808e-11, -3.646095389432841e-13,  5.376698496621308e-15, -7.435551730997215e-17,  9.720215881771870e-19,
 -1.208580842770006e-20,  4.971674309382441e-02, -3.615835815303902e-03,  1.515850827853768e-04, -4.718340212618603e-06,  1.203417557790018e-07, -2.648334434130031e-09,
  5.189392535301261e-11, -9.246145913172082e-13,  1.520473405054999e-14, -2.333367123652915e-16,  3.370367474152728e-18, -4.612330240609741e-20,  4.469161683571942e-02,
 -3.897715205241480e-03,  1.911803913594785e-04, -6.855297849551025e-06,  1.991553079548319e-07, -4.948281096307559e-09,  1.086876253499640e-10, -2.157649895392045e-12,
  3.932771551865041e-14, -6.659290684115278e-16,  1.057049131323101e-17, -1.583892792016694e-19,  3.984588978073884e-02, -4.094200922270754e-03,  2.321456752505647e-04,
 -9.497860384183999e-06,  3.117353492200543e-07, -8.682101141373614e-09,  2.123730582704765e-10, -4.669254101960677e-12,  9.380608986908798e-14, -1.743385312693735e-15,
  3.025932784705762e-17, -4.940839622079916e-19,  3.525694466365932e-02, -4.203368999984364e-03,  2.725033660053091e-04, -1.260815169080225e-05,  4.639758865132318e-07,
 -1.438727672832983e-08,  3.895346016696850e-10, -9.431828809517395e-12,  2.077620520926500e-13, -4.217139363103962e-15,  7.966200668373157e-17, -1.411126070650070e-18,
  3.098048900360868e-02, -4.228619190437276e-03,  3.103041722279286e-04, -1.610210222569333e-05,  6.596343044081417e-07, -2.262912497535273e-08,  6.742484960729378e-10,
 -1.788383337713550e-11,  4.297975509972236e-13, -9.483746003333816e-15,  1.941167160441678e-16, -3.714689867399563e-18,  2.705193002776885e-02, -4.177515177488621e-03,
  3.438071890650185e-04, -1.985491940075263e-05,  8.993731705111626e-07, -3.392893289207464e-08,  1.106434477268928e-09, -3.198593381009842e-11,  8.347284677529255e-13,
 -1.993413228288517e-14,  4.402552379123451e-16, -9.065035581849104e-18,  2.348872616130883e-02, -4.060497463760119e-03,  3.716169369539610e-04, -2.371193681854940e-05,
  1.180123333492822e-06, -4.867865642797062e-08,  1.728328448089330e-09, -5.419399723620930e-11,  1.528824699165274e-12, -3.934583082451535e-14,  9.338573020248867e-16,
 -2.061025884329630e-17,  2.029331536381843e-02, -3.889623953683197e-03,  3.927659350201720e-04, -2.750292782075463e-05,  1.494900070150871e-06, -6.705582688185900e-08,
  2.579188160898782e-09, -8.731379959632687e-11,  2.651077490384722e-12, -7.322742388322924e-14,  1.860562491732673e-15, -4.385082108727828e-17,  1.745626377115862e-02,
 -3.677453764881094e-03,  4.067415251681793e-04, -3.105755368102786e-05,  1.833117174427726e-06, -8.895400039789681e-08,  3.688796171917374e-09, -1.342200685784832e-10,
  4.367855940055478e-12, -1.289764177347527e-13,  3.494923754085200e-15, -8.764855449451673e-17,  1.495934870490026e-02, -3.436145347471339e-03,  4.134637817677279e-04,
 -3.421970499088955e-05,  2.181351137833988e-06, -1.139422341928064e-07,  5.070710798275275e-09, -1.974508392004182e-10,  6.858942453472936e-12, -2.156857671017008e-13,
  6.210411902126929e-15, -1.651531897051156e-16,  1.277837178995313e-02, -3.176798324999484e-03,  4.132265229400453e-04, -3.685897927757659e-05,  2.524431342628008e-06,
 -1.412621386063800e-07,  6.716419284422694e-09, -2.787206775363281e-10,  1.029442059266033e-11, -3.434513303897464e-13,  1.047105746430667e-14, -2.942654832049795e-16,
  1.088557754281319e-02, -2.909034688007666e-03,  4.066155465087098e-04, -3.887824489461764e-05,  2.846687712548587e-06, -1.698643436351197e-07,  8.591500509580260e-09,
 -3.784243218234967e-10,  1.480400388292829e-11, -5.221049596861821e-13,  1.679575902841893e-14, -4.971473739001152e-16,  9.251621516777907e-03, -2.640791418035580e-03,
  3.944177186853338e-04, -4.021698793530825e-05,  3.133179691596106e-06, -1.984794159593876e-07,  1.063461175020424e-08, -4.952173400736829e-10,  2.044264899331369e-11,
 -7.594212291251754e-13,  2.568987186787748e-14, -7.983004241455139e-16,  7.847085346008793e-03, -2.378283351894901e-03,  3.775322520762474e-04, -4.085077823967075e-05,
  3.370755391798725e-06, -2.257129017522385e-07,  1.275964746713796e-08, -6.257574241568016e-10,  2.715806932802194e-11, -1.058996011332554e-12,  3.754559683734734e-14,
 -1.220924126712553e-15,  6.643572779249730e-03, -2.126090615392979e-03,  3.568923006830380e-04, -4.078763457290497e-05,  3.548836487003344e-06, -2.501512371023550e-07,
  1.486089180214569e-08, -7.646687879916724e-10,  3.476650276095415e-11, -1.418133614471525e-12,  5.252177714843859e-14, -1.781647662307505e-15,  5.614442463322157e-03,
 -1.887326980355504e-03,  3.334016352388718e-04, -4.006229143280042e-05,  3.659879790663113e-06, -2.704650305155384e-07,  1.682051983029508e-08, -9.047575437287520e-10,
  4.294249103731672e-11, -1.826164032134219e-12,  7.042273767759795e-14, -2.484243396945403e-15,  4.735242636529139e-03, -1.663851601319792e-03,  3.078881852579070e-04,
 -3.872939338091647e-05,  3.699518561770967e-06, -2.854982996385785e-07,  1.851748738680329e-08, -1.037465864548612e-09,  5.122655173033328e-11, -2.263611386198044e-12,
  9.060201200472151e-14, -3.313449127726962e-15,  3.983913317639878e-03, -1.456494627500730e-03,  2.810739452953749e-04, -3.685651934896485e-05,  3.666427136375917e-06,
 -2.943358330119607e-07,  1.983672991912134e-08, -1.153515935863146e-09,  5.905185286370302e-11, -2.702538340146142e-12,  1.119178008709832e-13, -4.230381725501001e-15,
  3.340816175982194e-03, -1.265275528609847e-03,  2.535592331171730e-04, -3.451773091965245e-05,  3.561977560096050e-06, -2.963450021698097e-07,  2.067766151954119e-08,
 -1.243668247621064e-09,  6.578793181407398e-11, -3.108213704876444e-12,  1.327615952605475e-13, -5.171064936353952e-15,  2.788643683173137e-03, -1.089600547470771e-03,
  2.258184980809493e-04, -3.178810182330326e-05,  3.389766496014249e-06, -2.911922281704135e-07,  2.096118110558712e-08, -1.299506592429671e-09,  7.079676619696063e-11,
 -3.442027269393218e-12,  1.511700636266860e-13, -6.049236837670298e-15,  2.312249367590785e-03, -9.284319273787248e-04,  1.982046655930568e-04, -2.873946369233368e-05,
  3.155087529584183e-06, -2.788373245870357e-07,  2.063468808829946e-08, -1.314164494031482e-09,  7.349460983531049e-11, -3.665353546631007e-12,  1.650151666829046e-13,
 -6.763873774984193e-15,  1.898431368301425e-03, -7.804262742114938e-04,  1.709591949149264e-04, -2.543742170388368e-05,  2.864412158415457e-06, -2.595108173828842e-07,
  1.967491782654493e-08, -1.282921978104909e-09,  7.341222441860288e-11, -3.743889534054831e-12,  1.722517295955462e-13, -7.210904894062864e-15,  1.535692822146014e-03,
 -6.440426796685350e-04,  1.442254589232057e-04, -2.193956417879235e-05,  2.524926460848893e-06, -2.336800757813487e-07,  1.808867388941005e-08, -1.203623124716720e-09,
  7.024648283257116e-11, -3.651893467311161e-12,  1.711888109270686e-13, -7.297611066083708e-15,  1.213995323051953e-03, -5.176232834488206e-04,  1.180635940453765e-04,
 -1.829471233512741e-05,  2.144153272477949e-06, -2.020098673831564e-07,  1.591172682404758e-08, -1.076888849922972e-09,  6.389759778172207e-11, -3.375746491299483e-12,
  1.607439762869045e-13, -6.957442341846950e-15,  9.245159853862667e-04, -3.994501218847679e-04,  9.246553347597583e-05, -1.454302455610157e-05,  1.729674399283368e-06,
 -1.653220834534451e-07,  1.320625825188250e-08, -9.061218479383898e-10,  5.448812486570115e-11, -2.916343440736932e-12,  1.406395924156379e-13, -6.162646209662496e-15,
  6.594152785186008e-04, -2.877830467054617e-04,  6.736955514023867e-05, -1.071678678685982e-05,  1.288957054966899e-06, -1.245583351261123e-07,  1.005727483135581e-08,
 -6.973198148429876e-10,  4.236210876244260e-11, -2.289976704798953e-12,  1.115077114857688e-13, -4.932285465614335e-15,  4.116302790138629e-04, -1.808882766912348e-04,
  4.267522686990686e-05, -6.841922019514212e-06,  8.293016264153892e-07, -8.074990862097911e-08,  6.568560072502876e-09, -4.587378635740716e-10,  2.806559553417350e-11,
 -1.527614585947218e-12,  7.488533586179925e-14, -3.333999954069187e-15,  1.749321732296709e-04, -7.716696165528669e-05,  1.828369198945893e-05, -2.944106913438598e-06,
  3.583879292976244e-07, -3.504390157010280e-08,  2.862391761447514e-09, -2.007099842519599e-10,  1.232766135884840e-11, -6.735643446990812e-13,  3.314197382137719e-14,
 -1.480870515388807e-15,  8.141566672261416e-02, -2.798715264088091e-04,  1.012209781913815e-06, -3.802470146321858e-09,  1.464479254759346e-11, -5.722051925335382e-14,
  2.251108487631690e-16, -8.873930191205926e-19,  3.494760818761446e-21, -1.372727311223362e-23,  5.373123893773540e-26, -2.094964719019103e-28,  7.995986904574627e-02,
 -3.967959888708461e-04,  2.304747703342994e-06, -1.343721858184233e-08,  7.600649201401879e-11, -4.166873549537294e-13,  2.224017471183790e-15, -1.160618409882145e-17,
  5.941485668252237e-20, -2.991143689532344e-22,  1.483715836892645e-24, -7.262545657990220e-27,  7.713374308825434e-02, -6.174755429557497e-04,  5.268303620387806e-06,
 -4.127628586041441e-08,  3.016846368451643e-10, -2.092404526976129e-12,  1.392121252436681e-14, -8.948776848964396e-17,  5.586388914501460e-19, -3.399808243450706e-21,
  2.023199167033397e-23, -1.180084485979087e-25,  7.309926952324661e-02, -9.175392485009730e-04,  1.053330076546880e-05, -1.054273831075261e-07,  9.613765223557558e-10,
 -8.179860109193238e-12,  6.587842316258848e-14, -5.070831549040628e-16,  3.756334141296083e-18, -2.691869723060031e-20,  1.873677085748467e-22, -1.270734400732824e-24,
  6.807841237662660e-02, -1.264964021615232e-03,  1.876642853097057e-05, -2.342942183628925e-07,  2.608644686296539e-09, -2.667562648015819e-11,  2.550639510504382e-13,
 -2.308062177449508e-15,  1.993602986125253e-17, -1.654250131832473e-19,  1.325186549369927e-21, -1.028817619714874e-23,  6.233150869151084e-02, -1.624528886048698e-03,
  3.042849416941492e-05, -4.654076341938148e-07,  6.222781976899150e-09, -7.531517659460833e-11,  8.428713616299942e-13, -8.846796082873662e-15,  8.797002405915303e-17,
 -8.349502594119805e-19,  7.607927253443872e-21, -6.684980041758942e-23,  5.613366019344107e-02, -1.962368937207388e-03,  4.557395296232680e-05, -8.410376790575739e-07,
  1.332264864805397e-08, -1.885242074508498e-10,  2.441568172750372e-12, -2.941041908413181e-14,  3.332960009135647e-16, -3.583776499340559e-18,  3.680154750424168e-20,
 -3.627483168196424e-22,  4.975222172886463e-02, -2.249877331364197e-03,  6.374534651387278e-05, -1.400516728424849e-06,  2.598236650831815e-08, -4.254440634484713e-10,
  6.315948267390859e-12, -8.654118623892786e-14,  1.108386571005540e-15, -1.339435148108098e-17,  1.538323935391498e-19, -1.688490273342404e-21,  4.342796055829409e-02,
 -2.466408713905588e-03,  8.398675350409673e-05, -2.170674328950453e-06,  4.668483237415776e-08, -8.765758208259179e-10,  1.479389819885697e-11, -2.288101080546207e-13,
  3.288045874143638e-15, -4.435097804630494e-17,  5.659512323442487e-19, -6.873882313360789e-21,  3.736157620785447e-02, -2.600528351650090e-03,  1.049672382393792e-04,
 -3.156840112161010e-06,  7.798688896956342e-08, -1.665491550033290e-09,  3.171840502795178e-11, -5.499589983392502e-13,  8.810322141472136e-15, -1.318399071186519e-16,
  1.858453440874695e-18, -2.483877744521354e-20,  3.170624580187829e-02, -2.649849205860047e-03,  1.251784259978528e-04, -4.337049058613652e-06,  1.220317546589484e-07,
 -2.942078842032473e-09,  6.279952977326004e-11, -1.213070743979233e-12,  2.153811519017437e-14, -3.555955347158837e-16,  5.508223253565658e-18, -8.060552561321337e-20,
  2.656591105704617e-02, -2.619736625610107e-03,  1.431565855233308e-04, -5.661313465375702e-06,  1.800072919040918e-07, -4.865399565320607e-09,  1.156714432958247e-10,
 -2.474879853536040e-12,  4.843859573642182e-14, -8.778599127045288e-16,  1.487081393507821e-17, -2.371700123276981e-19,  2.199830992328110e-02, -2.521296967489486e-03,
  1.576806926814910e-04, -7.056425742707702e-06,  2.516860100222262e-07, -7.577241415334602e-09,  1.994657919407123e-10, -4.701558511507511e-12,  1.009258344474444e-13,
 -1.998287493837487e-15,  3.685243197632395e-17, -6.378176235288560e-19,  1.802135540551979e-02, -2.369094509249301e-03,  1.679108944492198e-04, -8.435257017136242e-06,
  3.351766346503110e-07, -1.117085671973243e-08,  3.238014983601319e-10, -8.365156438535102e-12,  1.960133618235483e-13, -4.220996166375486e-15,  8.438718739354760e-17,
 -1.578528868770376e-18,  1.462137250172855e-02, -2.178980022744832e-03,  1.734507856749420e-04, -9.708425085853066e-06,  4.269676869976136e-07, -1.566187693439066e-08,
  4.972511505031626e-10, -1.401121890816292e-11,  3.567508726641484e-13, -8.319785309881725e-15,  1.795848893722099e-16, -3.616732965685780e-18,  1.176185761984255e-02,
 -1.966299374212931e-03,  1.743357525115623e-04, -1.079581528676455e-05,  5.222681861441370e-07, -2.096886530277737e-08,  7.255267247913159e-10, -2.219379404523095e-11,
  6.113728538374723e-13, -1.537767667477523e-14,  3.569919781337508e-16, -7.712028672875641e-18,  9.391729689250438e-03, -1.744619259329040e-03,  1.709636797703952e-04,
 -1.163576152486412e-05,  6.155756147810924e-07, -2.690909283589676e-08,  1.009764330333485e-09, -3.338306984103241e-11,  9.907472817281551e-13, -2.677116460250319e-14,
  6.659125888752522e-16, -1.537583827917805e-17,  7.452403709553662e-03, -1.524990075592707e-03,  1.639914117995681e-04, -1.219051528032389e-05,  7.013504959698704e-07,
 -3.321148126107319e-08,  1.345321285269956e-09, -4.786048108915264e-11,  1.524089908174546e-12, -4.407268089635218e-14,  1.170366468381946e-15, -2.878376263352495e-17,
  5.883359899868297e-03, -1.315681056647020e-03,  1.542207410948034e-04, -1.244762611756279e-05,  7.746629605225839e-07, -3.954447876089211e-08,  1.721408669214167e-09,
 -6.562277417232867e-11,  2.233417779869453e-12, -6.885924927351115e-14,  1.945258133316197e-15, -5.078512496600923e-17,  4.626157366609398e-03, -1.122275626964470e-03,
  1.424932268692898e-04, -1.241773058364168e-05,  8.316982818037837e-07, -4.555325407565698e-08,  2.121694604942275e-09, -8.631745840882222e-11,  3.127692282654861e-12,
 -1.024392078954062e-13,  3.067871180157977e-15, -8.474023946029510e-17,  3.627030743443096e-03, -9.480013922229232e-04,  1.296062699683703e-04, -1.212981006310741e-05,
  8.700534790176701e-07, -5.089893801952527e-08,  2.525788642133234e-09, -1.092265548608069e-10,  4.197871331886943e-12, -1.455357121669345e-13,  4.604872913480951e-15,
 -1.341368307500168e-16,  2.838313784150582e-03, -7.941799001430610e-04,  1.162558063902912e-04, -1.162517939785186e-05,  8.888092705089842e-07, -5.529295521753483e-08,
  2.911325376420669e-09, -1.333051606615872e-10,  5.414037789703396e-12, -1.979865012943356e-13,  6.596374060781317e-15, -2.019846860558408e-16,  2.218970842836569e-03,
 -6.607056343164994e-04,  1.030052304214973e-04, -1.095136312291939e-05,  8.884062851751854e-07, -5.852137672163032e-08,  3.256257931425084e-09, -1.572693063373645e-10,
  6.725393480094571e-12, -2.585262109781009e-13,  9.039818682686456e-15, -2.900529621004446e-16,  1.734506250126284e-03, -5.464924442790984e-04,  9.027639740331089e-05,
 -1.015671977302954e-05,  8.703827001691255e-07, -6.045690954492211e-08,  3.540968038380547e-09, -1.797174529530168e-10,  8.063314500969661e-12, -3.247068478864940e-13,
  1.187714116755832e-14, -3.980788626106019e-16,  1.356482912478737e-03, -4.498523554945937e-04,  7.835678727150742e-05, -9.286309860604940e-06,  8.370402515631380e-07,
 -6.105879657534507e-08,  3.749884307968496e-09, -1.992643541666842e-10,  9.347030215485285e-12, -3.929863179779942e-13,  1.498843709652733e-14, -5.231175229350898e-16,
  1.061831278077063e-03, -3.687929702778202e-04,  6.741672137598661e-05, -8.379166495050222e-06,  7.910999815581632e-07, -6.036291530802870e-08,  3.872436852039833e-09,
 -2.146658012022257e-10,  1.049099094860984e-11, -4.589814368655803e-13,  1.819434381736937e-14, -6.592039551845143e-16,  8.320793610383752e-04, -3.012343841187989e-04,
  5.753134877139364e-05, -7.466875229562955e-06,  7.353939588184344e-07, -5.846545068125837e-08,  3.903321780553458e-09, -2.249171947530002e-10,  1.141274387179771e-11,
 -5.178500048625223e-13,  2.126768534319778e-14, -7.974540436675962e-16,  6.525903039104922e-04, -2.451551939477317e-04,  4.870341762163131e-05, -6.573218969294926e-06,
  6.726206294558406e-07, -5.550369970647038e-08,  3.842168494618562e-09, -2.293160599033285e-10,  1.204017070157205e-11, -5.647443630920879e-13,  2.395314996906483e-14,
 -9.266523449017201e-16,  5.118587932905374e-04, -1.986810510525172e-04,  4.088421714489089e-05, -5.714584519046373e-06,  6.051741790391676e-07, -5.163707228089741e-08,
  3.692776935063629e-09, -2.274863510672189e-10,  1.231720183689475e-11, -5.952707068389029e-13,  2.599229621508799e-14, -1.034280152394262e-15,  4.008918457870408e-04,
 -1.601298033018270e-04,  3.399126763695021e-05, -4.900835296960058e-06,  5.350450851758665e-07, -4.703049074309798e-08,  3.462117962301530e-09, -2.193688841499774e-10,
  1.220750803835947e-11, -6.058942140853904e-13,  2.715034788856046e-14, -1.107851791907124e-15,  3.126819681962002e-04, -1.280259206610522e-04,  2.792223996677428e-05,
 -4.136402538520428e-06,  4.637808309252740e-07, -4.184144359884665e-08,  3.159276616915831e-09, -2.051864461294670e-10,  1.169607237985633e-11, -5.942460630851325e-13,
  2.724115374994516e-14, -1.136370053407956e-15,  2.417697880162731e-04, -1.010946360015656e-04,  2.256518829587967e-05, -3.421411550024506e-06,  3.924921208784640e-07,
 -3.621111797384081e-08,  2.794479680875474e-09, -1.853938354899265e-10,  1.078887449233584e-11, -5.593091902740642e-13,  2.614725494909730e-14, -1.111693179869470e-15,
  1.838871959503271e-04, -7.824375536430687e-05,  1.780552336540424e-05, -2.752723825212032e-06,  3.218897892054507e-07, -3.025942629508998e-08,  2.378300609103453e-09,
 -1.606226588254306e-10,  9.511127669976532e-12, -5.014798213062576e-13,  2.383298900262657e-14, -1.029625262148387e-15,  1.356693067105203e-04, -5.853881007276366e-05,
  1.353030531832512e-05, -2.124831036529040e-06,  2.523396565814831e-07, -2.408338182421328e-08,  1.921088431833168e-09, -1.316288613872811e-10,  7.904589207055994e-12,
 -4.225175547659486e-13,  2.034968627685548e-14, -8.905901708893236e-16,  9.442300918941347e-05, -4.117537860095627e-05,  9.630472825660084e-06, -1.530581354659235e-06,
  1.839259815065262e-07, -1.775815690423096e-08,  1.432631582796685e-09, -9.924857855116710e-11,  6.024443826623071e-12, -3.254066760785030e-13,  1.583306649312578e-14,
 -6.998138703684596e-16,  5.794183721200803e-05, -2.545158170829377e-05,  6.001731204116108e-06, -9.617727349265886e-07,  1.165205065030962e-07, -1.134046220948890e-08,
  9.220653290873013e-10, -6.436696689270808e-11,  3.936260693184981e-12, -2.141601641324840e-13,  1.049400063950977e-14, -4.670182457852721e-16,  2.438937378615714e-05,
 -1.075657405736867e-05,  2.548038437975169e-06, -4.101975940057418e-07,  4.992184114131857e-08, -4.880320781410984e-09,  3.985336613309248e-10, -2.793871250484855e-11,
  1.715619986999334e-12, -9.371821552505565e-14,  4.610301602808494e-15, -2.059566834707445e-16,  8.031209249704116e-02, -2.719524684460375e-04,  9.679492030200052e-07,
 -3.577023430426167e-09,  1.355245958387382e-11, -5.210382811018365e-14,  2.017580612908720e-16, -7.830701425833076e-19,  3.037144464889675e-21, -1.175144766737743e-23,
  4.531762275073598e-26, -1.741054394107190e-28,  7.840856819943967e-02, -3.789829350263929e-04,  2.150531791324344e-06, -1.228499131672916e-08,  6.818125584866468e-11,
 -3.670053245501043e-13,  1.924121549369152e-15, -9.866340855882798e-18,  4.964230039414181e-20, -2.456902091673393e-22,  1.198359542681486e-24, -5.768915597381445e-27,
  7.474510857393414e-02, -5.772313840939088e-04,  4.800625488091545e-06, -3.676678011023928e-08,  2.629846585494765e-10, -1.786451026736541e-12,  1.164848290075664e-14,
 -7.342303506944414e-17,  4.496434610260501e-19, -2.685492101053027e-21,  1.568855094071945e-23, -8.985831050439450e-26,  6.958998631148738e-02, -8.380837606302878e-04,
  9.355331251096202e-06, -9.127282494331794e-08,  8.125066557573271e-10, -6.756421280004646e-12,  5.322696108666572e-14, -4.010417953900879e-16,  2.909703326309606e-18,
 -2.043275842516688e-20,  1.394255571557176e-22, -9.273467537208946e-25,  6.330196364269665e-02, -1.125407654599715e-03,  1.618874221511752e-05, -1.965121430664800e-07,
  2.131463298531535e-09, -2.126266957091464e-11,  1.985423859689966e-13, -1.755987490239863e-15,  1.483502402753473e-17, -1.204722193768907e-19,  9.449856808647972e-22,
 -7.187036028282641e-24,  5.628712520207445e-02, -1.401855636766343e-03,  2.539462481821689e-05, -3.768732812295213e-07,  4.900236376900037e-09, -5.776649580793825e-11,
  6.304405252454093e-13, -6.459259709313084e-15,  6.274780732396265e-17, -5.822277731493847e-19,  5.189545689631546e-21, -4.462998561102511e-23,  4.895421138343870e-02,
 -1.634790540506514e-03,  3.664564632232586e-05, -6.551151060204410e-07,  1.007719544433226e-08, -1.387130495487255e-10,  1.749855727632612e-12, -2.055362501477483e-14,
  2.273339266479123e-16, -2.387582742811120e-18,  2.396405795342088e-20, -2.310137387863276e-22,  4.167538605838780e-02, -1.800669140837449e-03,  4.917724925173496e-05,
 -1.045390998716754e-06,  1.881200404647730e-08, -2.993376478144008e-10,  4.324555666533019e-12, -5.773192461432331e-14,  7.211071468733420e-16, -8.505715551294690e-18,
  9.541949686635373e-20, -1.023702204570813e-21,  3.475745848410888e-02, -1.887225847560930e-03,  6.189887963075076e-05, -1.546659732402741e-06,  3.224062187822147e-08,
 -5.878454645582610e-10,  9.648260428022176e-12, -1.452999699869647e-13,  2.035171681007787e-15, -2.678100537488611e-17,  3.336595470851957e-19, -3.959432544482677e-21,
  2.842593744899929e-02, -1.893393012343971e-03,  7.359361344051709e-05, -2.138881698576213e-06,  5.118991637472901e-08, -1.061098892767185e-09,  1.964416574861179e-11,
 -3.315181997323100e-13,  5.174738462391484e-15, -7.552079227243299e-17,  1.039082880620738e-18, -1.356526751463332e-20,  2.282165882848465e-02, -1.827399565524611e-03,
  8.314389470709240e-05, -2.783668073245848e-06,  7.586816068020446e-08, -1.775064091025345e-09,  3.682534427579652e-11, -6.922428243203545e-13,  1.197387674748248e-14,
 -1.927751831238869e-16,  2.914338746237917e-18, -4.165418165334887e-20,  1.800768830312783e-02, -1.703785803644685e-03,  8.972142393230788e-05, -3.429572133910354e-06,
  1.056421933490839e-07, -2.771241995716299e-09,  6.403793732345802e-11, -1.333424378832227e-12,  2.542627374532294e-14, -4.493758901685295e-16,  7.429910247673704e-18,
 -1.157473177073366e-19,  1.398307376883101e-02, -1.540127026699335e-03,  9.289883886946309e-05, -4.020659015411735e-06,  1.389869637383121e-07, -4.062350543314731e-09,
  1.039711472352114e-10, -2.385620709707385e-12,  4.990515385650016e-14, -9.638266520747098e-16,  1.735305951510639e-17, -2.934375048773386e-19,  1.069982217519369e-02,
 -1.354117296156257e-03,  9.266933354994494e-05, -4.506008745936309e-06,  1.736420909087979e-07, -5.621621049902309e-09,  1.585068084030554e-10, -3.988016720143062e-12,
  9.110447332476723e-14, -1.914465132425080e-15,  3.738128346237958e-17, -6.834613003613681e-19,  8.079992406269958e-03, -1.161415213730051e-03,  8.938668597496057e-05,
 -4.847717207259721e-06,  2.069440218527234e-07, -7.379551405333560e-09,  2.280648860602368e-10, -6.262570074190755e-12,  1.555525777631682e-13, -3.542058260981949e-15,
  7.471420629327142e-17, -1.471542396287975e-18,  6.030712079689546e-03, -9.743891056275202e-04,  8.365476483894833e-05, -5.025666642016065e-06,  2.362486552434827e-07,
 -9.229897334287498e-09,  3.111386336281277e-10, -9.282863322317481e-12,  2.496479972884155e-13, -6.135711639629014e-15,  1.392937208778223e-16, -2.944862670598945e-18,
  4.455932099746978e-03, -8.016876842156749e-04,  7.620015837008541e-05, -5.038455770987643e-06,  2.593376801387297e-07, -1.104388454937617e-08,  4.041806703681966e-10,
 -1.304537342886313e-11,  3.783263603141804e-13, -9.997856946148081e-15,  2.434022527960064e-16, -5.504613074821729e-18,  3.264601569485098e-03, -6.484361598938822e-04,
  6.775628810188323e-05, -4.900955218236020e-06,  2.747165815184036e-07, -1.268920429462104e-08,  5.019066391452845e-10, -1.745160724814644e-11,  5.436305449119068e-13,
 -1.539002533793844e-14,  4.003896195099634e-16, -9.653803346447183e-18,  2.375559878832590e-03, -5.168160280716436e-04,  5.897673589092712e-05, -4.639658411106873e-06,
  2.817526813713867e-07, -1.404919090805536e-08,  5.979622828954700e-10, -2.230728734928100e-11,  7.435513774569374e-13, -2.246835006764747e-14,  6.225141051225887e-16,
 -1.594976458869275e-17,  1.719782399119920e-03, -4.068078163653117e-04,  5.038410163308876e-05, -4.287216776532721e-06,  2.806496319658885e-07, -1.503794943051654e-08,
  6.857988328528135e-10, -2.734021719785187e-11,  9.714829715192320e-13, -3.122340539983935e-14,  9.181812387696908e-16, -2.491857038301751e-17,  1.240725682287767e-03,
 -3.169314106571946e-04,  4.235171042494756e-05, -3.877356781504310e-06,  2.722937525725451e-07, -1.560875599495728e-08,  7.595551228168451e-10, -3.223330183724276e-11,
  1.216493447824604e-12, -4.144044942470616e-14,  1.289137453439552e-15, -3.694043953124850e-17,  8.934703062119844e-04, -2.448829272874090e-04,  3.511024799868193e-05,
 -3.440953955349771e-06,  2.580281060794830e-07, -1.575508250451244e-08,  8.147624286818176e-10, -3.666531013395139e-11,  1.464397627619320e-12, -5.269234008273359e-14,
  1.728308508922581e-15, -5.212717044423395e-17,  6.432278852526162e-04, -1.880235734598092e-04,  2.876974828280605e-05, -3.003572707694418e-06,  2.394114433387559e-07,
 -1.550538211041574e-08,  8.487543841166989e-10, -4.035054508141642e-11,  1.699410253936825e-12, -6.436944171327316e-14,  2.218894214960367e-15, -7.021999523178074e-17,
  4.636210747851439e-04, -1.437166266944200e-04,  2.334825937139076e-05, -2.584403602378486e-06,  2.180064852719351e-07, -1.491385508767703e-08,  8.607501295944793e-10,
 -4.306978688964071e-11,  1.906025809115517e-12, -7.574149818090678e-14,  2.735054391225205e-15, -9.053544690562388e-17,  3.349986833559860e-04, -1.095325695882980e-04,
  1.880073590272796e-05, -2.196300653470638e-06,  1.952231885210777e-07, -1.404968516322281e-08,  8.516549202036346e-10, -4.468790243654774e-11,  2.070748475342016e-12,
 -8.603887696703382e-14,  3.244137325135839e-15, -1.119774587112156e-16,  2.429304980172973e-04, -8.335253918271784e-05,  1.504422086294349e-05, -1.846537073249886e-06,
  1.722244311518812e-07, -1.298686088023804e-08,  8.236700224427166e-10, -4.515713993159930e-11,  2.183374576304644e-12, -9.453702061756790e-14,  3.710039508999293e-15,
 -1.331188292330461e-16,  1.769427569644012e-04, -6.340103334489580e-05,  1.197754505544960e-05, -1.537920156042342e-06,  1.498880896151012e-07, -1.179597338581708e-08,
  7.798179755640238e-10, -4.450821402767786e-11,  2.237669573552937e-12, -1.006289508763096e-13,  4.097055086529928e-15, -1.523393040747576e-16,  1.295020285068397e-04,
 -4.823446495762724e-05,  9.495313105647729e-06, -1.269986305159904e-06,  1.288120671173004e-07, -1.053860213773196e-08,  7.234763972386177e-10, -4.283315691921417e-11,
  2.231431593754516e-12, -1.038752460061761e-13,  4.373528623038194e-15, -1.679957186864950e-16,  9.522579252251982e-05, -3.670584205007438e-05,  7.496847967731987e-06,
 -1.040094544316540e-06,  1.093467514450060e-07, -9.264263661003681e-09,  6.579851630478136e-10, -4.026443148952754e-11,  2.166052105140460e-12, -1.040271395711207e-13,
  4.514751196148272e-15, -1.785949229797591e-16,  7.028499340581566e-05, -2.791956596697814e-05,  5.891157831388269e-06, -8.443245192045632e-07,  9.164092345449325e-08,
 -8.009493514347229e-09,  5.863597200847777e-10, -3.695425219989063e-11,  2.045750419929503e-12, -1.010243056138937e-13,  4.504773337708463e-15, -1.829429037642247e-16,
  5.196101128536538e-05, -2.118507514940534e-05,  4.599039053160526e-06, -6.781505278680957e-07,  7.569049344482012e-08, -6.798455208874486e-09,  5.111159241557266e-10,
 -3.305690693431118e-11,  1.876671433627596e-12, -9.497312559978141e-14,  4.337067499824082e-15, -1.802516736636855e-16,  3.832223226140443e-05, -1.597413251882378e-05,
  3.553289654140445e-06, -5.369044675511452e-07,  6.138319215435725e-08, -5.644467345372561e-09,  4.341932108744321e-10, -2.871557568723653e-11,  1.666008779904169e-12,
 -8.611323730904881e-14,  4.014188424360631e-15, -1.701959696761110e-16,  2.799057898556270e-05, -1.188388484843592e-05,  2.697793264866889e-06, -4.160615478511586e-07,
  4.853562146154128e-08, -4.551941643858830e-09,  3.569535791094488e-10, -2.405402546723052e-11,  1.421267198883639e-12, -7.478013637197299e-14,  3.546712740757295e-15,
 -1.529215479570726e-16,  1.997411968533548e-05, -8.606167522289423e-06,  1.986013766097439e-06, -3.113891705165068e-07,  3.692151100894812e-08, -3.518368592867704e-09,
  2.802320416663166e-10, -1.917278750260267e-11,  1.149725687857248e-12, -6.137016703638084e-14,  2.951782279767477e-15, -1.290137996816495e-16,  1.354722802002897e-05,
 -5.902611875716960e-06,  1.379253704306144e-06, -2.189975535859186e-07,  2.629163488985199e-08, -2.536134686941824e-09,  2.044175347312143e-10, -1.414903239233126e-11,
  8.581196961363539e-13, -4.631219433028975e-14,  2.251548233358037e-15, -9.943886949556789e-17,  8.164451911756221e-06, -3.584757862749683e-06,  8.449047815797995e-07,
 -1.353278333302458e-07,  1.638711605011243e-08, -1.594116444702029e-09,  1.295520562339804e-10, -9.039479437117014e-12,  5.525434871243161e-13, -3.004885870873910e-14,
  1.471775035573751e-15, -6.547116623003576e-17,  3.402141114183405e-06, -1.500147561446753e-06,  3.552726785987501e-07, -5.717980621927654e-08,  6.957195078981140e-09,
 -6.799657748173424e-10,  5.551370262808300e-11, -3.890806362405348e-12,  2.388657967786250e-13, -1.304542214240277e-14,  6.416029167129047e-16, -2.865613576081251e-17,
  7.923950305856201e-02, -2.643769632022811e-04,  9.262924017701789e-07, -3.368264859199367e-09,  1.255708409705250e-11, -4.751414264574981e-14,  1.811315493659962e-16,
 -6.923149411671834e-19,  2.644957168219309e-21, -1.008299535921181e-23,  3.831625322962609e-26, -1.450802386471764e-28,  7.692613677475964e-02, -3.623503569779060e-04,
  2.009422950969366e-06, -1.125039382012499e-08,  6.128145586930771e-11, -3.239698450960587e-13,  1.668837272543002e-15, -8.410527709166891e-18,  4.160245879992175e-20,
 -2.024675625863193e-22,  9.712806085886587e-25, -4.599626313407054e-27,  7.251029629635886e-02, -5.405222738822655e-04,  4.383538957627639e-06, -3.283033895428536e-08,
  2.298927895064576e-10, -1.530016850087980e-12,  9.780365024056563e-15, -6.046749868818016e-17,  3.633700317982207e-19, -2.130372642232993e-21,  1.222092745257257e-23,
 -6.875308392461719e-26,  6.638069884278323e-02, -7.674110414451241e-04,  8.333813588889140e-06, -7.928797486457591e-08,  6.892947644023244e-10, -5.603845848854076e-12,
  4.319799137921592e-14, -3.186991858435741e-16,  2.265402544707043e-18, -1.559330490971018e-20,  1.043397122507829e-22, -6.807793377584711e-25,  5.904519587049785e-02,
 -1.004781258181479e-03,  1.402197879558178e-05, -1.655676589201398e-07,  1.750138634535024e-09, -1.703778174835730e-11,  1.554174697194909e-13, -1.343939790709814e-15,
  1.110854870396878e-17, -8.831227351732376e-20,  6.784930996722394e-22, -5.056523113966584e-24,  5.105914658403229e-02, -1.215538444938470e-03,  2.130694652345801e-05,
 -3.069476887979427e-07,  3.882657958027125e-09, -4.459736288490789e-11,  4.748060909142543e-13, -4.750178101244803e-15,  4.509480267183176e-17, -4.091819998936577e-19,
  3.568659030748584e-21, -3.004569819839124e-23,  4.295520003416516e-02, -1.370526831639133e-03,  2.966701545635797e-05, -5.139740919070804e-07,  7.680218196073185e-09,
 -1.028737576929949e-10,  1.264490382687689e-12, -1.448738806281079e-14,  1.564372360503267e-16, -1.605234500673389e-18,  1.575187178938945e-20, -1.485447660551676e-22,
  3.518676274160706e-02, -1.452733955203665e-03,  3.825781752268937e-05, -7.871598137345533e-07,  1.374457320034054e-08, -2.125973404148233e-10,  2.989867066592262e-12,
 -3.889907355572445e-14,  4.739737715700208e-16, -5.458280672004821e-18,  5.982553964262431e-20, -6.274917402412418e-22,  2.809268857417282e-02, -1.458323180331320e-03,
  4.608335477669929e-05, -1.113545147723755e-06,  2.250431786497989e-08, -3.985553606788610e-10,  6.363242219111073e-12, -9.333066680051286e-14,  1.274478986645266e-15,
 -1.636491122294493e-17,  1.991044244381298e-19, -2.308881000058218e-21,  2.188503073460254e-02, -1.394847619397241e-03,  5.221603873700348e-05, -1.466851841692858e-06,
  3.401765879436484e-08, -6.845689831575760e-10,  1.232229048890484e-11, -2.024435096954863e-13,  3.079527822329802e-15, -4.383901986513046e-17,  5.888366260191158e-19,
 -7.510001537363226e-21,  1.665673681773594e-02, -1.277644266158809e-03,  5.599093327299552e-05, -1.811653561240333e-06,  4.783417841287848e-08, -1.086240656063971e-09,
  2.190531524385475e-11, -4.007756746437165e-13,  6.754423511563714e-15, -1.060536043148013e-16,  1.564941559491425e-18, -2.184886812470302e-20,  1.240306727476419e-02,
 -1.125625869751841e-03,  5.711860178064606e-05, -2.110403450105099e-06,  6.298073097354894e-08, -1.603540442489646e-09,  3.601863157804004e-11, -7.299466216615844e-13,
  1.356161771401289e-14, -2.337544158330423e-16,  3.772455573417549e-18, -5.740873480354216e-20,  9.049593318282910e-03, -9.575182867879613e-04,  5.569665300043621e-05,
 -2.331097864088997e-06,  7.809464046996091e-08, -2.215985010395821e-09,  5.514126114035061e-11, -1.231627924656455e-12,  2.510773144563863e-14, -4.729984464728291e-16,
  8.313928785788882e-18, -1.373582310448478e-19,  6.480505916045472e-03, -7.891893636410677e-04,  5.213506828826002e-05, -2.453265507872455e-06,  9.167217069973338e-08,
 -2.882654705378673e-09,  7.905611022283876e-11, -1.936982818211728e-12,  4.313702899787908e-14, -8.845228367158042e-16,  1.686687875135569e-17, -3.014062377416100e-19,
  4.562886334094140e-03, -6.322677091653210e-04,  4.703207963023754e-05, -2.470773269996094e-06,  1.023581509926731e-07, -3.547699124831936e-09,  1.067088726081043e-10,
 -2.855120538935250e-12,  6.917117321691401e-14, -1.537726734356431e-15,  3.169298501046897e-17, -6.103851727379025e-19,  3.164758585631226e-03, -4.938976613582646e-04,
  4.104175743737908e-05, -2.391159378305825e-06,  1.091919373090811e-07, -4.150009749066873e-09,  1.362639992285526e-10, -3.964276175597479e-12,  1.040621728901975e-13,
 -2.498609120327916e-15,  5.546052346600014e-17, -1.147265209710063e-18,  2.166580339935977e-03, -3.772845536277609e-04,  3.476519392847926e-05, -2.232284113339921e-06,
  1.117469014792726e-07, -4.634294513629624e-09,  1.653621534452218e-10, -5.209160917666923e-12,  1.475825631293663e-13, -3.813302549466817e-15,  9.084095554205173e-17,
 -2.011701551573425e-18,  1.467045264987136e-03, -2.826452831159903e-04,  2.868159059630660e-05, -2.017663520102305e-06,  1.101416729666021e-07, -4.960470038071931e-09,
  1.915142417625398e-10, -6.506160727487818e-12,  1.981922708525930e-13, -5.491167828910465e-15,  1.399172635659246e-16, -3.306388861356184e-18,  9.846440022303470e-04,
 -2.082444641875865e-04,  2.312067611141119e-05, -1.771855487158162e-06,  1.049421451830854e-07, -5.109105184942222e-09,  2.125236419130033e-10, -7.755498667753951e-12,
  2.530810051969522e-13, -7.492599852723642e-15,  2.035286194595091e-16, -5.116042155266897e-18,  6.565040335358295e-04, -1.513074374543886e-04,  1.826789969503073e-05,
 -1.516868057742172e-06,  9.699903953195937e-08, -5.082116483173292e-09,  2.268266805445323e-10, -8.857220893544706e-12,  3.085015728256555e-13, -9.725969312653507e-15,
  2.807329867446507e-16, -7.482936070548789e-18,  4.357989977935307e-04, -1.087114972775219e-04,  1.418977209830660e-05, -1.270014654522491e-06,  8.727155353119318e-08,
 -4.899367263103601e-09,  2.336773449229697e-10, -9.726828679791743e-12,  3.603177190147218e-13, -1.205560218916608e-14,  3.685638925583109e-16, -1.038526434940232e-17,
  2.886652878383201e-04, -7.743991677121488e-05,  1.086733071366483e-05, -1.043167161170469e-06,  7.667719540424839e-08, -4.592752847892908e-09,  2.331562614759979e-10,
 -1.030684489527832e-11,  4.046273627273900e-13, -1.431936054535487e-14,  4.621846015791947e-16, -1.372490825747691e-17,  1.912128307776142e-04, -5.483247353061900e-05,
  8.228877785824057e-06, -8.430677826851870e-07,  6.598970629571960e-08, -4.199588709432690e-09,  2.260335033844938e-10, -1.057219040371085e-11,  4.383102545031393e-13,
 -1.635157545138129e-14,  5.554286185266125e-16, -1.732912621822636e-17,  1.269333995308961e-04, -3.868598751490125e-05,  6.176956747651834e-06, -6.722641383671306e-07,
  5.578910839740372e-08, -3.756784281518903e-09,  2.135443231644827e-10, -1.052919700351662e-11,  4.593861824929580e-13, -1.800582512725423e-14,  6.416046017885808e-16,
 -2.096688204810571e-17,  8.461329478080423e-05, -2.725854517475667e-05,  4.607761158985424e-06, -5.302761743801966e-07,  4.645539573878423e-08, -3.296663773408959e-09,
  1.971424170838785e-10, -1.020967211046538e-11,  4.671350344313400e-13, -1.917262860958971e-14,  7.143772840852717e-16, -2.437645718083726e-17,  5.673995827155220e-05,
 -1.922117482987232e-05,  3.423315974733738e-06, -4.147171707080563e-07,  3.819158826814076e-08, -2.844664729710800e-09,  1.782822812259740e-10, -9.662245792463857e-12,
  4.619962581303418e-13, -1.978906366968674e-14,  7.685328290714743e-16, -2.729813264298817e-17,  3.833452026643023e-05, -1.358782217393945e-05,  2.537853673860672e-06,
 -3.222156594125491e-07,  3.106161079502608e-08, -2.418682866704553e-09,  1.582603764876287e-10, -8.943244645339024e-12,  4.453116664154241e-13, -1.983973494898586e-14,
  8.004893383940752e-16, -2.950495222247689e-17,  2.612357172915020e-05, -9.642648817117063e-06,  1.880103927317175e-06, -2.490859851345646e-07,  2.503147563081736e-08,
 -2.029595267558836e-09,  1.381232491838153e-10, -8.108791656000168e-12,  4.189936329296920e-13, -1.935056722371147e-14,  8.084945225439248e-16, -3.082586498552446e-17,
  1.796646278436098e-05, -6.874651927603792e-06,  1.393050954441633e-06, -1.917605467327078e-07,  2.000638782354674e-08, -1.682452212262745e-09,  1.186350315826745e-10,
 -7.209061009485544e-12,  3.851937401734564e-13, -1.837807690232747e-14,  7.925322893516304e-16, -3.115814378828977e-17,  1.246726061569169e-05, -4.923589354032063e-06,
  1.032352960643071e-06, -1.470291692016433e-07,  1.586019422757183e-08, -1.377909352267146e-09,  1.002885638341991e-10, -6.284902005531418e-12,  3.460247615711365e-13,
 -1.699700263254656e-14,  7.540158547072886e-16, -3.046885552621513e-17,  8.715966268201737e-06, -3.537675383510253e-06,  7.642335893489098e-07, -1.121397858378995e-07,
  1.245637593202058e-08, -1.113604375649686e-09,  8.334265830814895e-11, -5.366544188458205e-12,  3.033623814915972e-13, -1.528868689324043e-14,  6.953683469863497e-16,
 -2.878744985457540e-17,  6.117985087356737e-06, -2.541761369749154e-06,  5.633316712396133e-07, -8.480963831421423e-08,  9.661431000604892e-09, -8.853136641291333e-10,
  6.787045956240672e-11, -4.473842992240182e-12,  2.587303463483363e-13, -1.333175621444841e-14,  6.195864575184832e-16, -2.619278377027458e-17,  4.282682949974486e-06,
 -1.814070043643379e-06,  4.107596954908764e-07, -6.318537877475418e-08,  7.352219732086431e-09, -6.878273912527689e-10,  5.380811386746411e-11, -3.617478394975150e-12,
  2.132577190835300e-13, -1.119577746865954e-14,  5.298591048428923e-16, -2.279809413189251e-17,  2.950885219389645e-06, -1.269514244431102e-06,  2.924681052091008e-07,
 -4.577876808844404e-08,  5.418957793474348e-09, -5.155485571177447e-10,  4.099735873782009e-11, -2.800603116453564e-12,  1.676899672907316e-13, -8.937883563807186e-15,
  4.292831382765364e-16, -1.873685036469468e-17,  1.947708300806042e-06, -8.478729435376529e-07,  1.979235571217378e-07, -3.139465912979291e-08,  3.765330979662966e-09,
 -3.628572741488798e-10,  2.921928594445943e-11, -2.020581823554050e-12,  1.224351596052963e-13, -6.601952748458460e-15,  3.206912092453135e-16, -1.415146797580304e-17,
  1.151686203957970e-06, -5.054375050374691e-07,  1.190668104828747e-07, -1.906086615960483e-08,  2.306921684017341e-09, -2.242999035758461e-10,  1.821950587556649e-11,
 -1.270643385398424e-12,  7.763176854752525e-14, -4.219864433340273e-15,  2.065922935026529e-16, -9.186076607859672e-18,  4.748242247413923e-07, -2.093241779411957e-07,
  4.956089729875896e-08, -7.974617081213367e-09,  9.700441064279769e-10, -9.478413561721650e-11,  7.736447564607939e-12, -5.420950403017240e-13,  3.327253564513987e-14,
 -1.816719544135192e-15,  8.932964295471899e-17, -3.988856258718675e-18,  7.819656462464780e-02, -2.571249558934745e-04,  8.870480916951778e-07, -3.174724003891301e-09,
  1.164875068892678e-11, -4.339036424209117e-14,  1.628791414695381e-16, -6.132003543408094e-19,  2.308086277901530e-21, -8.670651415564131e-24,  3.247469849485648e-26,
 -1.212084531473426e-28,  7.550805398431457e-02, -3.467988024001105e-04,  1.880094261519761e-06, -1.031962698305699e-08,  5.518425466889388e-11, -2.865997296506280e-13,
  1.450935896547761e-15, -7.188750449983487e-18,  3.496681248206915e-20, -1.673774794466912e-22,  7.899102175840294e-25, -3.680659517393797e-27,  7.041593403207082e-02,
 -5.069695331836445e-04,  4.010674581219813e-06, -2.938465630893688e-08,  2.015091015968573e-10, -1.314358855479878e-12,  8.239175140192424e-15, -4.997801768957016e-17,
  2.947928179216218e-19, -1.697031258767685e-21,  9.561811379691715e-24, -5.285058087276412e-26,  6.343862371074685e-02, -7.043670337105757e-04,  7.445006168781666e-06,
 -6.910243679848946e-08,  5.869027907549970e-10, -4.666476569564485e-12,  3.521034424388815e-14, -2.544376618444675e-16,  1.772472586019649e-18, -1.196217210257352e-20,
  7.851205503895214e-23, -5.026489586939435e-25,  5.523847885045680e-02, -9.001012791780174e-04,  1.219255844747091e-05, -1.401009289600630e-07,  1.443830916504823e-09,
 -1.372191831334922e-11,  1.223208073218470e-13, -1.034502190008849e-15,  8.368585652475296e-18, -6.514895491447397e-20,  4.903873330336345e-22, -3.582155695745068e-24,
  4.651598229873487e-02, -1.058824257457700e-03,  1.796876388203409e-05, -2.513840455209385e-07,  3.094679122919970e-09, -3.464770019795257e-11,  3.599714825286480e-13,
 -3.517675773278793e-15,  3.264412679170584e-17, -2.897452185778022e-19,  2.473300194540786e-21, -2.039147839021235e-23,  3.791145867501208e-02, -1.155918746049427e-03,
  2.417371807022661e-05, -4.060298928164362e-07,  5.896075120547291e-09, -7.687741943539349e-11,  9.210380546978042e-13, -1.029613349931561e-14,  1.085737626261260e-16,
 -1.088798467398622e-18,  1.044834001812874e-20, -9.641160451304400e-23,  2.993300953264491e-02, -1.181016100876971e-03,  3.000275135796731e-05, -5.977050877737188e-07,
  1.013011464085788e-08, -1.523630271767849e-10,  2.086497445631050e-12, -2.646312027649118e-14,  3.146326069665482e-16, -3.538393153721565e-18,  3.790060415051205e-20,
 -3.887335521934578e-22,  2.292000595538634e-02, -1.137541326617980e-03,  3.464281699751047e-05, -8.097593155988941e-07,  1.587040766684736e-08, -2.730820919150884e-10,
  4.242289210193494e-12, -6.061539592275901e-14,  8.071713306218806e-16, -1.011575285654720e-17,  1.202118885305771e-19, -1.362529455766744e-21,  1.704142777623524e-02,
 -1.039220360065145e-03,  3.747492426410162e-05, -1.017776189721552e-06,  2.287639324160891e-08, -4.470298828147459e-10,  7.825257427767176e-12, -1.251805592985814e-13,
  1.856091083729704e-15, -2.577823238689242e-17,  3.380740518283883e-19, -4.213027849785858e-21,  1.232073314463682e-02, -9.051480808941426e-04,  3.820932301622477e-05,
 -1.194957928415802e-06,  3.057037353318691e-08, -6.738879610418556e-10,  1.321195408990393e-11, -2.353001766059645e-13,  3.864383580622657e-15, -5.918280997408902e-17,
  8.525234335657968e-19, -1.162787473142731e-20,  8.675388085742804e-03, -7.550091280160920e-04,  3.691665466327737e-05, -1.318467004121912e-06,  3.812275090241506e-08,
 -9.421614875905751e-10,  2.057277300683434e-11, -4.058125646385288e-13,  7.346609105879858e-15, -1.235065397186136e-16,  1.945701793684191e-18, -2.892582836604936e-20,
  5.959575329087466e-03, -6.055493731949231e-04,  3.396242735858262e-05, -1.374509787192747e-06,  4.462546049016653e-08, -1.229333724740633e-09,  2.974117467538479e-11,
 -6.466683361593747e-13,  1.284697198927396e-14, -2.360799032532651e-16,  4.051182294811998e-18, -6.539500378296542e-20,  4.001630890173469e-03, -4.687239370324799e-04,
  2.988342341900459e-05, -1.360615827587277e-06,  4.929584923200279e-08, -1.505489357230470e-09,  4.015576400557894e-11, -9.580648772803005e-13,  2.079884846221195e-14,
 -4.161299319191814e-16,  7.749151703449354e-18, -1.353350066286339e-19,  2.631739567228151e-03, -3.513739439719907e-04,  2.525373115456254e-05, -1.284785553928614e-06,
  5.164261473514777e-08, -1.739434248810150e-09,  5.091252397339057e-11, -1.327157034041512e-12,  3.135794675217859e-14, -6.805011690252537e-16,  1.370260913019448e-17,
 -2.580302219385415e-19,  1.698975657623985e-03, -2.559557897468235e-04,  2.057796919566151e-05, -1.162303149706930e-06,  5.154491915038678e-08, -1.905325723646453e-09,
  6.092298481845725e-11, -1.727952697036660e-12,  4.426525205639715e-14, -1.038151716463374e-15,  2.252646022933557e-17, -4.558785382522870e-19,  1.079160448387415e-03,
 -1.817728477033527e-04,  1.622984858025729e-05, -1.011587068967409e-06,  4.923248412287914e-08, -1.987711576026672e-09,  6.913194997161979e-11, -2.124931203926136e-12,
  5.879772933099037e-14, -1.485079939626094e-15,  3.460947207456228e-17, -7.503469962222177e-19,  6.761036741489396e-04, -1.262615223699766e-04,  1.243564154764724e-05,
 -8.503916687022155e-07,  4.518928487402469e-08, -1.983630065126476e-09,  7.472649067100564e-11, -2.479511881145025e-12,  7.383919017433461e-14, -2.001611655925366e-15,
  4.993761260222785e-17, -1.156273072725051e-18,  4.188845181928603e-04, -8.605849305205392e-05,  9.290448458740054e-06, -6.931908693145853e-07,  4.002241548577810e-08,
 -1.901590346412851e-09,  7.727527809571826e-11, -2.757435359574625e-12,  8.806088681497670e-14, -2.553401505397693e-15,  6.798045484332849e-17, -1.675942062021248e-18,
  2.573345549763368e-04, -5.774279636456070e-05,  6.791513719124541e-06, -5.499830360540926e-07,  3.433746202734658e-08, -1.758266864402395e-09,  7.676734239495154e-11,
 -2.934882611716129e-12,  1.001613592739855e-13, -3.096262145775929e-15,  8.768993674947930e-17, -2.294868209754611e-18,  1.571909389484845e-04, -3.826321731024733e-05,
  4.875070053229695e-06, -4.262997782784598e-07,  2.864802750872208e-08, -1.574234590848322e-09,  7.355577197716991e-11, -3.001772790903685e-12,  1.090961061841611e-13,
 -3.583587114163382e-15,  1.076256503575548e-16, -2.980947719897028e-18,  9.574289553535657e-05, -2.512092607909179e-05,  3.448073959299249e-06, -3.239801008854674e-07,
  2.332915965058184e-08, -1.369997541322754e-09,  6.823890970407946e-11, -2.961772299381339e-12,  1.142363230896243e-13, -3.974284959015473e-15,  1.261780247004526e-16,
 -3.687661247941773e-18,  5.831292436259583e-05, -1.639208387586674e-05,  2.411113874065695e-06, -2.422604393207732e-07,  1.860990299567915e-08, -1.163118395981124e-09,
  6.152137543685584e-11, -2.829594691408577e-12,  1.154251235471594e-13, -4.239119975670304e-15,  1.418291342774194e-16, -4.360687685209766e-18,  3.561375131294248e-05,
 -1.066397216196930e-05,  1.672332476916508e-06, -1.788443294225969e-07,  1.459246382911215e-08, -9.667171143279424e-10,  5.409110225633742e-11, -2.626792817351812e-12,
  1.129344109715959e-13, -4.364068891872805e-15,  1.533828720272208e-16, -4.946215221359982e-18,  2.186964713167897e-05, -6.937118942651433e-06,  1.154103815996581e-06,
 -1.307645906217694e-07,  1.128419421179071e-08, -7.891814939243765e-10,  4.653359793403394e-11, -2.377333289078581e-12,  1.073518952925790e-13, -4.350359249593095e-15,
  1.601123532346947e-16, -5.398822358780443e-18,  1.353764138998231e-05, -4.525034085862272e-06,  7.947789996436901e-07, -9.497769694362938e-08,  8.631411827174723e-09,
 -6.347107168887395e-10,  3.928872155992156e-11, -2.103928157499493e-12,  9.943857644513940e-14, -4.211801396043460e-15,  1.618028282649908e-16, -5.687137468325823e-18,
  8.466730514015495e-06, -2.967109580330863e-06,  5.475953804225869e-07, -6.871122247950105e-08,  6.548363966149716e-09, -5.042774030994522e-10,  3.264367589514132e-11,
 -1.825613510440037e-12,  8.999319396494688e-14, -3.970564239349339e-15,  1.586994746893844e-16, -5.796333067583660e-18,  5.360275635280361e-06, -1.959863891009087e-06,
  3.782994498533781e-07, -4.962248981494993e-08,  4.938570954218938e-09, -3.966750505909769e-10,  2.675038493695821e-11, -1.556618375328446e-12,  7.974752261318650e-14,
 -3.652613137137155e-15,  1.513906254304688e-16, -5.727478403736028e-18,  3.439847101652279e-06, -1.306045926256385e-06,  2.624622694227804e-07, -3.583287795685208e-08,
  3.708501071534054e-09, -3.094418926267764e-10,  2.165501201147061e-11, -1.306275323011784e-12,  6.930180468004932e-14, -3.283750175189238e-15,  1.406642058116690e-16,
 -5.494517174203170e-18,  2.238683333085433e-06, -8.786651282490420e-07,  1.830094332146703e-07, -2.589214357296701e-08,  2.774953068611020e-09, -2.395671937686417e-10,
  1.732997956999005e-11, -1.079605934118448e-12,  5.909796101933671e-14, -2.886770889435002e-15,  1.273704238408403e-16, -5.119985319294541e-18,  1.476464701947393e-06,
 -5.964323474996206e-07,  1.281798061370760e-07, -1.871152205032710e-08,  2.067963488468486e-09, -1.839676639512318e-10,  1.370245347791607e-11, -8.782282614778828e-13,
  4.942155335557785e-14, -2.479850313610862e-15,  1.123123750888537e-16, -4.630551188249475e-18,  9.841056837339784e-07, -4.074196126679045e-07,  8.994877891025865e-08,
 -1.348962886161847e-08,  1.530917193857569e-09, -1.397668783998464e-10,  1.067650537544569e-11, -7.013183173677824e-13,  4.042148234028716e-14, -2.075993166339105e-15,
  9.617366691505892e-17, -4.053179443306837e-18,  6.588534086721829e-07, -2.783925982269169e-07,  6.286502774721373e-08, -9.643893858474390e-09,  1.119153329372487e-09,
 -1.044272733532907e-10,  8.148469942065832e-12, -5.464608784262984e-13,  3.213760145638671e-14, -1.683250042298740e-15,  7.948217706126970e-17, -3.412352634322467e-18,
  4.375430063487555e-07, -1.879358806246384e-07,  4.321912516967586e-08, -6.752785932793056e-09,  7.979367844945409e-10, -7.578332437749273e-11,  6.016315105310946e-12,
 -4.103142580327658e-13,  2.452912752679506e-14, -1.305386087986383e-15,  6.260315168919591e-17, -2.728456929437679e-18,  2.806393933870326e-07, -1.220523356432952e-07,
  2.846130312218498e-08, -4.509739838791079e-09,  5.403109031451677e-10, -5.201527180219754e-11,  4.184367609949806e-12, -2.890766033646599e-13,  1.749967552839950e-14,
 -9.427455993588537e-16,  4.575284354562235e-17, -2.017218562045450e-18,  1.626438767795326e-07, -7.134459466089847e-08,  1.679763050830487e-08, -2.687576583122846e-09,
  3.250981357206512e-10, -3.159208852102809e-11,  2.564828409529560e-12, -1.787816507594213e-13,  1.091745470922206e-14, -5.931549274242013e-16,  2.902528314308124e-17,
 -1.290002580091847e-18,  6.630570610150532e-08, -2.922393089247056e-08,  6.917453050544695e-09, -1.112762693035413e-09,  1.353225726584060e-10, -1.321909451884169e-11,
  1.078689661966382e-12, -7.556504962469329e-14,  4.636858396963491e-15, -2.531162459540303e-16,  1.244296046297333e-17, -5.554878663797671e-19,  7.718202067938633e-02,
 -2.501778540537391e-04,  8.500417184787228e-07, -2.995079747866942e-09,  1.081868560106732e-11, -3.967923383461385e-14,  1.466983574424053e-16, -5.440952469450984e-19,
  2.018095081856279e-21, -7.472257278982975e-24,  2.758830889628339e-26, -1.015210283219458e-28,  7.415017662273649e-02, -3.322388039559009e-04,  1.761373217433849e-06,
 -9.480709076015773e-09,  4.978481120798512e-11, -2.540716055009067e-13,  1.264451878947087e-15, -6.160426778251256e-18,  2.947300808000111e-20, -1.387942043701864e-22,
  6.445288673276363e-25, -2.955678354404212e-27,  6.845006828941431e-02, -4.762417198709543e-04,  3.676569649308686e-06, -2.636052152645639e-08,  1.770912551801217e-10,
 -1.132399214449375e-12,  6.963174575866581e-15, -4.145263735281255e-17,  2.400586958954423e-19, -1.357280542917045e-21,  7.513306184948478e-24, -4.081019178764373e-26,
  6.073524027010030e-02, -6.479710700844067e-04,  6.669182097514002e-06, -6.041502593651744e-08,  5.014781884074164e-10, -3.900887365052882e-12,  2.881950136830347e-14,
 -2.040433768336461e-16,  1.393412742908432e-18, -9.222921945308286e-21,  5.939171222020626e-23, -3.731971361267241e-25,  5.182303517896502e-02, -8.089128019690740e-04,
  1.064138962805730e-05, -1.190449654100793e-07,  1.196550958442507e-09, -1.110558988660971e-11,  9.677659182981247e-14, -8.007354933707168e-16,  6.341365845889065e-18,
 -4.835640954095705e-20,  3.567076490912301e-22, -2.554647109183860e-24,  4.255020287503218e-02, -9.263486007343093e-04,  1.522781092307079e-05, -2.069748904072785e-07,
  2.480711693491408e-09, -2.708127899390719e-11,  2.746596320093714e-13, -2.622489370281704e-15,  2.379718736847955e-17, -2.066720987428355e-19,  1.727160693320745e-21,
 -1.394802154402474e-23,  3.364582420689959e-02, -9.805242140313068e-04,  1.982028215836636e-05, -3.228834372490894e-07,  4.558109447935252e-09, -5.787293104855066e-11,
  6.760251420610206e-13, -7.375884104536634e-15,  7.597855241029936e-17, -7.448299495368491e-19,  6.991601312015261e-21, -6.314281515954685e-23,  2.564716902793117e-02,
 -9.671436305994609e-04,  2.371039289865099e-05, -4.575134162070929e-07,  7.529011109104396e-09, -1.101489979930821e-10,  1.469242786947743e-12, -1.817087113638260e-14,
  2.108640727382829e-16, -2.316414543574407e-18,  2.425329111617814e-20, -2.433106058637696e-22,  1.886817301083418e-02, -8.953322966966767e-04,  2.628549048893991e-05,
 -5.945225348660630e-07,  1.130320815168380e-08, -1.890211919922510e-10,  2.857918466380917e-12, -3.979039091421097e-14,  5.168191990376632e-16, -6.322959944383342e-18,
  7.340816799403518e-20, -8.134085239210188e-22,  1.341475966010844e-02, -7.826704955891189e-04,  2.719277014223541e-05, -7.141556441902174e-07,  1.556130876502383e-08,
 -2.953451776773606e-10,  5.028917245324881e-12, -7.834816714116273e-14,  1.132554475606376e-15, -1.534869301272182e-17,  1.965766167842785e-19, -2.394001616700038e-21,
  9.231190296945864e-03, -6.494388949616129e-04,  2.641005883382088e-05, -7.984373774039918e-07,  1.979446955459763e-08, -4.236442802477647e-10,  8.076193075984350e-12,
 -1.400338042023799e-13,  2.241437067372008e-15, -3.348740703400330e-17,  4.709647703208992e-19, -6.276251020212188e-21,  6.158763880429547e-03, -5.138681187031957e-04,
  2.421039701527625e-05, -8.358551170716631e-07,  2.341823778709686e-08, -5.618297432038276e-10,  1.192708852553455e-11, -2.290222104335854e-13,  4.040364519629720e-15,
 -6.625472838027706e-17,  1.018970664642899e-18, -1.479997122350610e-20,  3.991270320064830e-03, -3.893324072113482e-04,  2.105161213657272e-05, -8.238244350032981e-07,
  2.592044896431553e-08, -6.932314853535685e-10,  1.630633834118685e-11, -3.451547703168874e-13,  6.682487011587152e-15, -1.197887051453262e-16,  2.006908003166012e-18,
 -3.165307429216459e-20,  2.517754937029873e-03, -2.835461265047314e-04,  1.744241762345382e-05, -7.683234559469549e-07,  2.698745615696196e-08, -8.004126066613869e-10,
  2.076302587476248e-11, -4.823669507574274e-13,  1.020768705808415e-14, -1.992666519218965e-16,  3.623653302010983e-18, -6.184835637349880e-20,  1.549480382940018e-03,
 -1.992349650800437e-04,  1.383084711449810e-05, -6.812744694543929e-07,  2.656509334401657e-08, -8.694084336732429e-10,  2.475993701826896e-11, -6.287430993940698e-13,
  1.448703456035671e-14, -3.068648447868709e-16,  6.036330129481013e-18, -1.111293625852677e-19,  9.326028490327238e-04, -1.355536679769352e-04,  1.053959703884793e-05,
 -5.769514776644386e-07,  2.484147774888659e-08, -8.928703889933323e-10,  2.779674380932915e-11, -7.684824197255659e-13,  1.920853740860216e-14, -4.399629288278143e-16,
  9.331025521297035e-18, -1.847135824813355e-19,  5.504194506895149e-04, -8.962147789099486e-05,  7.749967577847955e-06, -4.687074317750075e-07,  2.217001338132756e-08,
 -8.711462608415303e-10,  2.952377108178528e-11, -8.852459998536791e-13,  2.391811228373189e-14, -5.903964260010525e-16,  1.345744314766736e-17, -2.855797704154390e-19,
  3.194503410545292e-04, -5.778601756747759e-05,  5.521007853939856e-06, -3.668364382912035e-07,  1.896813689901088e-08, -8.112296546689069e-10,  2.980895218345343e-11,
 -9.657618616942584e-13,  2.810747451953643e-14, -7.452614888339943e-16,  1.820047411662402e-17, -4.128141290698442e-19,  1.828626535238636e-04, -3.646805555846896e-05,
  3.825686334010135e-06, -2.777699270990944e-07,  1.562642606375929e-08, -7.242780168901203e-10,  2.874203522035961e-11, -1.002497677278211e-12,  3.132111093529912e-14,
 -8.891852943107072e-16,  2.319486425302100e-17, -5.606620416863363e-19,  1.035678938577445e-04, -2.260847414296410e-05,  2.588803415918219e-06, -2.043407798380617e-07,
  1.244933022192408e-08, -6.227199763711569e-10,  2.658471711096904e-11, -9.946596598085071e-13,  3.324765080369894e-14, -1.007387311647817e-15,  2.798358710380381e-17,
 -7.187708760936416e-19,  5.822747818617764e-05, -1.382003745439738e-05,  1.717565410407158e-06, -1.466500582139308e-07,  9.632369798293396e-09, -5.178316215557328e-10,
  2.369160018204125e-11, -9.474623660638332e-13,  3.376922622412056e-14, -1.088566559740547e-15,  3.210365421046104e-17, -8.736983190669227e-19,  3.260645343300965e-05,
 -8.360909939921139e-06,  1.121696958108827e-06, -1.030983848069046e-07,  7.268508255734082e-09, -4.182547886776340e-10,  2.042993035529969e-11, -8.701919712142909e-13,
  3.296013768374872e-14, -1.126776990356965e-15,  3.517318208686919e-17, -1.011290150367272e-18,  1.824953877057411e-05, -5.025023850362640e-06,  7.239355622698528e-07,
 -7.128984470205867e-08,  5.371257440736967e-09, -3.295032522248907e-10,  1.711852206940898e-11, -7.738395066553908e-13,  3.104398616740874e-14, -1.121891067124593e-15,
  3.695476765250385e-17, -1.119225891911428e-18,  1.024430344778840e-05, -3.011536898858741e-06,  4.635298089541883e-07, -4.867881456786639e-08,  3.902804994116519e-09,
 -2.542176408180297e-10,  1.399438423566242e-11, -6.689983936017101e-13,  2.832905954334793e-14, -1.078762324396795e-15,  3.738078223012419e-17, -1.189018331193134e-18,
  5.787455756976118e-06, -1.806332925840417e-06,  2.955676174413983e-07, -3.295083943279074e-08,  2.799234500366211e-09, -1.928292124973194e-10,  1.120516306017009e-11,
 -5.644369077535604e-13,  2.514292957409323e-14, -1.005560500302986e-15,  3.654016921914864e-17, -1.217005364203519e-18,  3.301482243769937e-06, -1.088175052023210e-06,
  1.883705445853789e-07, -2.219238630004109e-08,  1.989147802238926e-09, -1.443317311748092e-10,  8.819618581543590e-12, -4.664410306097241e-13,  2.178132220899408e-14,
 -9.118673158554956e-16,  3.463752480068659e-17, -1.204244817472799e-18,  1.907618867110722e-06, -6.605689572881350e-07,  1.203949592505790e-07, -1.492206666204383e-08,
  1.405198408553054e-09, -1.069650940992911e-10,  6.847049194607665e-12, -3.787952213204876e-13,  1.847777951000304e-14, -8.070182095399343e-16,  3.194018969591995e-17,
 -1.155547856153695e-18,  1.119501814277976e-06, -4.052470486014881e-07,  7.739887914163986e-08, -1.004711816827411e-08,  9.897996688640707e-10, -7.872227648707334e-11,
  5.258295614882004e-12, -3.031670616290041e-13,  1.539324613456373e-14, -6.989611850171136e-16,  2.872782955787524e-17, -1.078058380350502e-18,  6.687408964447153e-07,
 -2.518383939791168e-07,  5.016864242252675e-08, -6.790241025207839e-09,  6.968378862604077e-10, -5.766985019919571e-11,  4.003814039325111e-12, -2.396646385267002e-13,
  1.262038270187790e-14, -5.936877828300339e-16,  2.525393259955334e-17, -9.797889506204327e-19,  4.071718604473164e-07, -1.587722865826587e-07,  3.283742412507107e-08,
 -4.613465257356012e-09,  4.910745106837771e-10, -4.211475209739280e-11,  3.026956096917861e-12, -1.873959010283544e-13,  1.019618441975650e-14, -4.951409494017905e-16,
  2.172273919587410e-17, -8.684105788079257e-19,  2.527068335812116e-07, -1.015708157004650e-07,  2.170947546604549e-08, -3.151873796718982e-09,  3.464834254588075e-10,
 -3.066359239937865e-11,  2.272412883738473e-12, -1.449336570063025e-13,  8.117373558204848e-15, -4.054380232527753e-16,  1.828045592896634e-17, -7.504394316482218e-19,
  1.595611833704893e-07, -6.581263631779239e-08,  1.447066030170978e-08, -2.161324110877227e-09,  2.443053889252716e-10, -2.221732134475275e-11,  1.690714610869209e-12,
 -1.106517314903869e-13,  6.354838866119204e-15, -3.252473430471553e-16,  1.501704270273830e-17, -6.308289073401979e-19,  1.019444571300718e-07, -4.296334564810825e-08,
  9.673791277202374e-09, -1.479737834778558e-09,  1.712337417111823e-10, -1.593350782497415e-11,  1.239949501431495e-12, -8.293746466244824e-14,  4.865212781438731e-15,
 -2.541943816054558e-16,  1.197422321886403e-17, -5.128908002645364e-19,  6.512741523801161e-08, -2.792635041857444e-08,  6.410022460411682e-09, -9.996363086846533e-10,
  1.179007474921600e-10, -1.117711414410321e-11,  8.857584425201490e-13, -6.030470781399352e-14,  3.599048183329541e-15, -1.912212542962237e-16,  9.155986698998077e-18,
 -3.984366428177733e-19,  4.053017775374238e-08, -1.760931388892752e-08,  4.101724530114660e-09, -6.491948796717209e-10,  7.769378227443653e-11, -7.471412627033997e-12,
  6.004025780715447e-13, -4.143605708483973e-14,  2.505879143513477e-15, -1.348655362396464e-16,  6.539015073057993e-18, -2.880363256111492e-19,  2.299658946188975e-08,
 -1.008244000420059e-08,  2.372487047357497e-09, -3.793718791134837e-10,  4.586379429582792e-11, -4.454403976310070e-12,  3.614352857293724e-13, -2.518033958178424e-14,
  1.536851548321129e-15, -8.345569199894987e-17,  4.081754738438338e-18, -1.813215655026515e-19,  9.264362832177309e-09, -4.082259407437377e-09,  9.660323090410538e-10,
 -1.553564379866100e-10,  1.888768187469325e-11, -1.844561638447773e-12,  1.504778997038960e-13, -1.053862021160970e-14,  6.465097623344456e-16, -3.528268702249273e-17,
  1.734034065526773e-18, -7.739322419999623e-20,  7.619468638099910e-02, -2.435184005461241e-04,  8.151137728377981e-07, -2.828143212612955e-09,  1.005911120859939e-11,
 -3.633423298040520e-14,  1.323288266261829e-16, -4.836156754200169e-19,  1.767926953324772e-21, -6.453047445348824e-24,  2.349068366789714e-26, -8.524099859800809e-29,
  7.284870146585830e-02, -3.185897265434135e-04,  1.652221548427816e-06, -8.723211495613272e-09,  4.499340752910165e-11, -2.256925344576385e-13,  1.104446737845342e-15,
 -5.292503708250582e-18,  2.491078017983021e-20, -1.154353692119003e-22,  5.275901387816867e-25, -2.381621553226629e-27,  6.660198893039275e-02, -4.480479630408739e-04,
  3.376525138563442e-06, -2.369954490859774e-08,  1.560247201182136e-10, -9.783862170707542e-13,  5.903095482120068e-15, -3.449788637857509e-17,  1.961999598363212e-19,
 -1.089783794224525e-21,  5.928157144611066e-24, -3.165111929707874e-26,  5.824565640782355e-02, -5.973868269608916e-04,  5.989885742657746e-06, -5.297979188780916e-08,
  4.299391465213528e-10, -3.273030485999937e-12,  2.368371325825327e-14, -1.643383480096862e-16,  1.100469338323364e-18, -7.145666942603806e-21,  4.515904507641387e-23,
 -2.785807676759574e-25,  4.874903699630061e-02, -7.291864782681115e-04,  9.320778151437850e-06, -1.015580779137041e-07,  9.959614980970001e-10, -9.030583681822444e-12,
  7.695365501065035e-14, -6.231169723769045e-16,  4.832410532417243e-18, -3.610545097916820e-20,  2.610806639505585e-22, -1.833661041937364e-24,  3.907362446477878e-02,
 -8.138251090901430e-04,  1.296548240642062e-05, -1.712818533260708e-07,  1.999473813345318e-09, -2.129097976173575e-11,  2.108610982771185e-13, -1.967802874600172e-15,
  1.746562847634828e-17, -1.484593241095074e-19,  1.214969605407440e-21, -9.613136464295687e-24,  3.001795387289593e-02, -8.363031251385883e-04,  1.634773819528499e-05,
 -2.583973931843918e-07,  3.547489724053351e-09, -4.387485898973813e-11,  4.998632458464048e-13, -5.324619194034098e-15,  5.359399862623225e-17, -5.137408147329678e-19,
  4.718414418752032e-21, -4.171731362731139e-23,  2.212587486906705e-02, -7.975290257700887e-04,  1.887608304749814e-05, -3.529173792159538e-07,  5.641074343922249e-09,
 -8.030094256282450e-11,  1.043611766052124e-12, -1.258934988393190e-14,  1.426299922117193e-16, -1.530898747925133e-18,  1.567185402984578e-20, -1.538138089950695e-22,
  1.566621795155189e-02, -7.107758346523240e-04,  2.012268632287736e-05, -4.405355593627551e-07,  8.127274504177924e-09, -1.321235753189120e-10,  1.944770788224647e-12,
 -2.639081124289208e-14,  3.344223090672466e-16, -3.995078750115000e-18,  4.532293486407547e-20, -4.910632336459493e-22,  1.067031932672732e-02, -5.955848740669343e-04,
  1.994122849081997e-05, -5.065504629647031e-07,  1.070283266784807e-08, -1.973418321659153e-10,  3.269218374461193e-12, -4.961435652440465e-14,  6.993487108951050e-16,
 -9.250139134859543e-18,  1.157150515324543e-19, -1.377423976229081e-21,  7.002145281144671e-03, -4.716809127413242e-04,  1.848026772000020e-05, -5.401779842093454e-07,
  1.297986832519002e-08, -2.697581340907759e-10,  5.001271670821162e-12, -8.444023262832081e-14,  1.317489912424285e-15, -1.920467584767232e-17,  2.637373708783689e-19,
 -3.434468199759537e-21,  4.435114717930328e-03, -3.546990096485737e-04,  1.610247779464001e-05, -5.374462831194293e-07,  1.459180707503349e-08, -3.398724039207939e-10,
  7.015453665994458e-12, -1.311464778808810e-13,  2.254896808627061e-15, -3.607113352110080e-17,  5.416318390362741e-19, -7.686550689631973e-21,  2.716876086877389e-03,
 -2.543429951983086e-04,  1.325739425189471e-05, -5.016480427495869e-07,  1.529632254059451e-08, -3.971789814447097e-10,  9.083908401194074e-12, -1.871906051496150e-13,
  3.532103469276852e-15, -6.176608697884716e-17,  1.010342908632988e-18, -1.557039206436794e-20,  1.613212368010483e-03, -1.746068151648165e-04,  1.036164667183361e-05,
 -4.415192691563467e-07,  1.503421459617073e-08, -4.330103148235873e-10,  1.092367045032301e-11, -2.471075642282493e-13,  5.097226055748341e-15, -9.708503602915388e-17,
  1.724030038957915e-18, -2.875710238084841e-20,  9.307479991884986e-04, -1.152016899177982e-04,  7.722237262685500e-06, -3.682105958739329e-07,  1.392612187618011e-08,
 -4.427939045070097e-10,  1.226849015278440e-11, -3.034597764640561e-13,  6.817927373662304e-15, -1.409525205628814e-16,  2.708433364773029e-18, -4.874513348774517e-20,
  5.231809518636891e-04, -7.332717745863172e-05,  5.511735274837920e-06, -2.923314013386274e-07,  1.221748739992797e-08, -4.269060749750373e-10,  1.293759871233132e-11,
 -3.485882223089955e-13,  8.500361283264740e-15, -1.901174802686634e-16,  3.940564069123864e-18, -7.629304189802264e-20,  2.873494400248893e-04, -4.519976205678277e-05,
  3.783786831563204e-06, -2.219624844675410e-07,  1.020049546523815e-08, -3.899855655982543e-10,  1.287583216579763e-11, -3.765244897478947e-13,  9.931388215931422e-15,
 -2.395334654053582e-16,  5.339182804462463e-18, -1.108808594394401e-19,  1.546910561401093e-04, -2.708648660405058e-05,  2.509088559361464e-06, -1.619119378570066e-07,
  8.143231310122412e-09, -3.392012873478585e-10,  1.215375074564390e-11, -3.843586418338036e-13,  1.092946400238691e-14, -2.833776756538889e-16,  6.772625273288759e-18,
 -1.504401237284892e-19,  8.189746057391853e-05, -1.584278673766931e-05,  1.614079479979081e-06, -1.139823800811105e-07,  6.245074929231236e-09, -2.822506862640183e-10,
  1.093376460188071e-11, -3.726334790609840e-13,  1.138586746445411e-14, -3.163751156644077e-16,  8.083601695165410e-18, -1.915235941448197e-19,  4.279290127790800e-05,
 -9.081010296311406e-06,  1.011678490967362e-06, -7.779031373292629e-08,  4.622382859903785e-09, -2.257556639134986e-10,  9.419672480465404e-12, -3.447695209874639e-13,
  1.128300245506959e-14, -3.349646904530120e-16,  9.123235827714916e-18, -2.299160583577015e-19,  2.215130318959934e-05, -5.122339961642251e-06,  6.205589993090757e-07,
 -5.170379822616466e-08,  3.317438955494054e-09, -1.743875077173356e-10,  7.808557811384675e-12, -3.058781236451043e-13,  1.068683989980802e-14, -3.379336696126309e-16,
  9.782810320415915e-18, -2.615031975647782e-19,  1.140399684524109e-05, -2.855524232467891e-06,  3.741842135995552e-07, -3.362171510439507e-08,  2.319373517791203e-09,
 -1.307083704713307e-10,  6.257772642306381e-12, -2.614482806463640e-13,  9.720333460056784e-15, -3.263876923003770e-16,  1.001323213471536e-17, -2.831134197682340e-19,
  5.862838730623506e-06, -1.580057841593239e-06,  2.227955995669199e-07, -2.148893636600478e-08,  1.587036977897302e-09, -9.550548566677775e-11,  4.870876073452617e-12,
 -2.163008350314182e-13,  8.529549830843556e-15, -3.031779623781247e-16,  9.827804427751459e-18, -2.930746710724688e-19,  3.022407344574401e-06, -8.716373380408990e-07,
  1.315856013767567e-07, -1.356121126176857e-08,  1.067712846779360e-09, -6.834274013072402e-11,  3.699360283062523e-12, -1.739985015731868e-13,  7.253474401859050e-15,
 -2.720598065140712e-16,  9.290291098923999e-18, -2.913575919990314e-19,  1.568932977340999e-06, -4.814784043947091e-07,  7.743483541467111e-08, -8.488582194128856e-09,
  7.094811729089607e-10, -4.811229812656824e-11,  2.753746815994519e-12, -1.367014584614934e-13,  6.004027833873848e-15, -2.368696251522200e-16,  8.494545924530595e-18,
 -2.793337758992241e-19,  8.234725471613354e-07, -2.674619333297841e-07,  4.560254895925577e-08, -5.293385695495693e-09,  4.676820896350614e-10, -3.346648131427937e-11,
  2.017757968129794e-12, -1.053380804072082e-13,  4.857706745862511e-15, -2.009170049389784e-16,  7.542936032123271e-18, -2.592911871779170e-19,  4.387336441921494e-07,
 -1.500291010694146e-07,  2.698821861025665e-08, -3.302202649442018e-09,  3.071026532321612e-10, -2.309586639766443e-11,  1.461221576100799e-12, -7.992935857540589e-14,
  3.856582667567129e-15, -1.666639742846920e-16,  6.529031066281667e-18, -2.338841586857759e-19,  2.381417517583877e-07, -8.530154798324923e-08,  1.611191934984889e-08,
 -2.068699262890975e-09,  2.016392196512996e-10, -1.587231216029376e-11,  1.049655081298097e-12, -5.993542467680315e-14,  3.014863470976301e-15, -1.356615338486941e-16,
  5.527101903738590e-18, -2.056624162832654e-19,  1.320993963844875e-07, -4.931881529298005e-08,  9.734752694828501e-09, -1.305635643022928e-09,  1.328043433063077e-10,
 -1.089650664186252e-11,  7.502173234139862e-13, -4.454581384195146e-14,  2.327430844761738e-15, -1.086603722927399e-16,  4.588324758716240e-18, -1.767565931093913e-19,
  7.505624056807864e-08, -2.906610157693137e-08,  5.967011635961517e-09, -8.321745252401351e-10,  8.794450688195585e-11, -7.489599091550219e-12,  5.346696151292538e-13,
 -3.288409598190465e-14,  1.777866117842226e-15, -8.580487570049901e-17,  3.741989116530495e-18, -1.487317439989933e-19,  4.372450363467511e-08, -1.748078012596959e-08,
  3.714726578529811e-09, -5.362196691125582e-10,  5.861477700944409e-11, -5.158996619203798e-12,  3.802919986399676e-13, -2.412998778161027e-14,  1.344714422368527e-15,
 -6.683938667352897e-17,  2.999528461417448e-18, -1.225763653859022e-19,  2.608864534926215e-08, -1.071808139416322e-08,  2.346481117912158e-09, -3.489572656817892e-10,
  3.927776716969627e-11, -3.557254940865046e-12,  2.696214096565532e-13, -1.757739996534656e-14,  1.005689919976357e-15, -5.128447540971569e-17,  2.359484491607847e-18,
 -9.877682657347101e-20,  1.587018416013398e-08, -6.669789849770149e-09,  1.497209463293864e-09, -2.283183358371159e-10,  2.634148491319989e-11, -2.443936589051218e-12,
  1.896467596383919e-13, -1.265000851906936e-14,  7.400752452541913e-16, -3.856634662578731e-17,  1.812140947141173e-18, -7.742959415250464e-20,  9.733717146264717e-09,
 -4.166246809612031e-09,  9.543767990597454e-10, -1.485349156728421e-10,  1.748413481817927e-11, -1.654317239001538e-12,  1.308543795758927e-13, -8.892642133038914e-15,
  5.297811669279446e-16, -2.809936128337965e-17,  1.343193140555535e-18, -5.835640616868871e-20,  5.867745784114791e-09, -2.546687980969699e-09,  5.924976044082143e-10,
 -9.366527564285374e-11,  1.119646533866045e-11, -1.075473643477210e-12,  8.632854377208191e-14, -5.951382965772395e-15,  3.595339986978271e-16, -1.933008420443391e-17,
  9.362897637845724e-19, -4.120249403291633e-20,  3.255658596825107e-09, -1.426618705841275e-09,  3.354934470817058e-10, -5.361427707487144e-11,  6.477739227909403e-12,
 -6.287618111827988e-13,  5.098891612137290e-14, -3.550269514669402e-15,  2.165668771573977e-16, -1.175390707979938e-17,  5.745727975496163e-19, -2.551089446160945e-20,
  1.295198954219106e-09, -5.705776041864771e-10,  1.349847237017346e-10, -2.170195407658568e-11,  2.637699851678351e-12, -2.575244414034978e-13,  2.100285665828551e-14,
 -1.470522652910999e-15,  9.018771393954513e-17, -4.920625219555709e-18,  2.417712241357810e-19, -1.078799103205855e-20,  7.523344345156564e-02, -2.371305592887225e-04,
  7.821182950168517e-07, -2.672842845456034e-09,  9.363120778203567e-12, -3.331465153196688e-14,  1.195459467786095e-16, -4.305847039617453e-19,  1.551664818263315e-21,
 -5.584276059029347e-24,  2.004613424582922e-26, -7.174351365295906e-29,  7.160013197705577e-02, -3.057787640404416e-04,  1.551717951841640e-06, -8.038036393939255e-09,
  4.073307041133887e-11, -2.008777157516053e-13,  9.668198213752814e-16, -4.557972848536289e-18,  2.111102274585845e-20, -9.628572041654295e-23,  4.332119004592800e-25,
 -1.925439290893068e-27,  6.486207832890940e-02, -4.221323400803649e-04,  3.106487304949396e-06, -2.135230964952428e-08,  1.377990159905193e-10, -8.476284355651886e-13,
  5.019465507307575e-15, -2.880402757614973e-17,  1.609206390660608e-19, -8.783139438294901e-22,  4.696250464481468e-24, -2.465209607388279e-26,  5.594807958877432e-02,
 -5.518986094270450e-04,  5.393338129122357e-06, -4.659506269429698e-08,  3.698095090821520e-10, -2.756085553289934e-12,  1.953893078943080e-14, -1.329132320095537e-16,
  8.729891475773678e-19, -5.562435128122420e-21,  3.450823834699415e-23, -2.090406085585267e-25,  4.597407025845488e-02, -6.592372420303464e-04,  8.192042903379118e-06,
 -8.697287216654973e-08,  8.324909343524254e-10, -7.376721939835114e-12,  6.148940234422915e-14, -4.874088443753469e-16,  3.702653844639005e-18, -2.711310919439503e-20,
  1.922381673975813e-22, -1.324403620572897e-24,  3.601348159904331e-02, -7.178095863967470e-04,  1.108883970032166e-05, -1.424395235480867e-07,  1.620104505004330e-09,
 -1.683296185839342e-11,  1.628461269025854e-13, -1.485804691191270e-15,  1.290271892348138e-17, -1.073721844065587e-19,  8.607396236754253e-22, -6.674237151415176e-24,
  2.691594633611748e-02, -7.170220704137159e-04,  1.356055194216177e-05, -2.080531238658425e-07,  2.778817005884675e-09, -3.348928764205519e-11,  3.722439503778256e-13,
 -3.872409899834507e-15,  3.809631084086414e-17, -3.571822448634249e-19,  3.210599813002456e-21, -2.779625232675729e-23,  1.921297007764566e-02, -6.620397988046686e-04,
  1.513372074852875e-05, -2.742586546046219e-07,  4.259433804404940e-09, -5.901543643023137e-11,  7.475145182472795e-13, -8.798104301619770e-15,  9.734054284300949e-17,
 -1.021084675228849e-18,  1.022257457015382e-20, -9.817930546045490e-23,  1.311447232174154e-02, -5.689149485227957e-04,  1.553685352928511e-05, -3.293340294663574e-07,
  5.897421786792048e-09, -9.322847283251701e-11,  1.336297337034827e-12, -1.767887711998732e-14,  2.186173685171850e-16, -2.550721557236468e-18,  2.828260496531936e-20,
 -2.996981472429027e-22,  8.572288300665859e-03, -4.577327336261917e-04,  1.477246938717142e-05, -3.630472532433099e-07,  7.439954314860661e-09, -1.333006367395658e-10,
  2.149005132608972e-12, -3.177644874166661e-14,  4.368561823403146e-16, -5.640544834622737e-18,  6.893269240190194e-20, -8.021680970150891e-22,  5.374544951821195e-03,
 -3.466081208913953e-04,  1.308527762721686e-05, -3.698654149926145e-07,  8.615654119845078e-09, -1.739082250619697e-10,  3.136210844310231e-12, -5.156946016581162e-14,
  7.844526954217611e-16, -1.115834076954237e-17,  1.496535317690781e-19, -1.904635844581752e-21,  3.238102518688936e-03, -2.481704604338100e-04,  1.085616431771422e-05,
 -3.503246413121917e-07,  9.218171539475807e-09, -2.084783000158907e-10,  4.184699541254311e-12, -7.616846189024320e-14,  1.276505562549781e-15, -1.992235390327731e-17,
  2.920990199013276e-19, -4.050682193425592e-21,  1.878662172616867e-03, -1.687370985166653e-04,  8.477928600468272e-06, -3.101861883860318e-07,  9.166540097626337e-09,
 -2.310948151794836e-10,  5.139373905545550e-12, -1.031101925158322e-13,  1.896278313670639e-15, -3.235062743220884e-17,  5.166925214939842e-19, -7.780850237835908e-21,
  1.052025162165752e-03, -1.093933538080406e-04,  6.261343650257707e-06, -2.580670076877111e-07,  8.518356393092769e-09, -2.382472804709367e-10,  5.845029741158807e-12,
 -1.287456735792238e-13,  2.588677882497451e-15, -4.810691970987234e-17,  8.342198224228512e-19, -1.359874231639344e-20,  5.700886670542696e-04, -6.789183287086138e-05,
  4.393252434288521e-06, -2.027404011194335e-07,  7.436373620217973e-09, -2.296924030939414e-10,  6.191030956320513e-12, -1.491514611507323e-13,  3.267346744128809e-15,
 -6.592378223510990e-17,  1.237319059052762e-18, -2.176844134239776e-20,  2.997991745786378e-04, -4.049581748050904e-05,  2.941633997488953e-06, -1.511229768501704e-07,
  6.129303978327650e-09, -2.081717765554852e-10,  6.140304373035901e-12, -1.612151437447090e-13,  3.834755533156263e-15, -8.373975007245590e-17,  1.696055528744199e-18,
 -3.211251655292564e-20,  1.534757578520966e-04, -2.330831277310495e-05,  1.888046126039806e-06, -1.073898238498515e-07,  4.793505760811024e-09, -1.782666230756026e-10,
  5.732472543053972e-12, -1.634532244851526e-13,  4.208025394797084e-15, -9.915013946087734e-17,  2.160801525596268e-18, -4.390759029757236e-20,  7.674301954714317e-05,
 -1.299885966061703e-05,  1.166843102041466e-06, -7.309663698036778e-08,  3.574530557172689e-09, -1.449696184080287e-10,  5.063473983678194e-12, -1.562632154416403e-13,
  4.340264011684501e-15, -1.100160003148991e-16,  2.572543711369636e-18, -5.595079419518628e-20,  3.761971461496560e-05, -7.054047850207307e-06,  6.975517086415715e-07,
 -4.788613002230137e-08,  2.554132862720480e-09, -1.125172733536516e-10,  4.253213415127257e-12, -1.415883571814740e-13,  4.229637991154526e-15, -1.149976073478782e-16,
  2.877192528522651e-18, -6.679960305232852e-20,  1.814993565746520e-05, -3.741317960635355e-06,  4.052643164540513e-07, -3.033938347775052e-08,  1.757434549943092e-09,
 -8.376815874631793e-11,  3.414679025480248e-12, -1.222141193985375e-13,  3.914391795509653e-15, -1.138212980965817e-16,  3.038571936431011e-18, -7.510733355904060e-20,
  8.654385323453931e-06, -1.948284821777714e-06,  2.299243210890007e-07, -1.868241134983994e-08,  1.170319746153269e-09, -6.012483695841201e-11,  2.633624964690260e-12,
 -1.010064074574899e-13,  3.457876550035042e-15, -1.072177982359533e-16,  3.045555551805536e-18, -7.993330074368293e-20,  4.096587329560525e-06, -1.000884388177128e-06,
  1.280137587239493e-07, -1.123758446204174e-08,  7.581009620404343e-10, -4.181774064755713e-11,  1.961308988842544e-12, -8.033802948777520e-14,  2.930489719953658e-15,
 -9.660690969540148e-17,  2.911626047073049e-18, -8.092286119637097e-20,  1.933961911811395e-06, -5.097387579719091e-07,  7.029806911021541e-08, -6.636634076195843e-09,
  4.801532450301222e-10, -2.832903495919409e-11,  1.417589188581868e-12, -6.180850175820165e-14,  2.394686623115729e-15, -8.367957481423035e-17,  2.668253209768643e-18,
 -7.831423092145624e-20,  9.149563894204810e-07, -2.586573461442766e-07,  3.827120390461899e-08, -3.868155142206699e-09,  2.988900626380569e-10, -1.878914095221467e-11,
  9.995157211417177e-13, -4.623071953377739e-14,  1.896313393779814e-15, -7.002420760843770e-17,  2.355370927057440e-18, -7.279892785548664e-20,  4.359249799164102e-07,
 -1.314396086046760e-07,  2.076280928400571e-08, -2.236622632078639e-09,  1.838089489347689e-10, -1.226347385364212e-11,  6.909822872773442e-13, -3.378644763142650e-14,
  1.462399947950864e-15, -5.688550994909432e-17,  2.012352126174477e-18, -6.530698615000531e-20,  2.101947473607446e-07, -6.722934536996002e-08,  1.128270398054175e-08,
 -1.289558156555810e-09,  1.122423415931491e-10, -7.916590561553361e-12,  4.706930075216316e-13, -2.424397168728401e-14,  1.103565721040856e-15, -4.507344280137102e-17,
  1.671707876497931e-18, -5.679397505007064e-20,  1.030689017828213e-07, -3.478387190021098e-08,  6.171913638758306e-09, -7.450841385316485e-10,  6.839366619664515e-11,
 -5.079067119745652e-12,  3.174446360474253e-13, -1.716085942097043e-14,  8.186287461780647e-16, -3.498972794429965e-17,  1.356179222421976e-18, -4.808336023564232e-20,
  5.163142065787734e-08, -1.829027127428059e-08,  3.414649769576408e-09, -4.334202385730984e-10,  4.177713866527192e-11, -3.253184156639552e-12,  2.128988712037811e-13,
 -1.203422698433935e-14,  5.994515788936111e-16, -2.671978228967910e-17,  1.078686343262531e-18, -3.978395289744135e-20,  2.653127539588769e-08, -9.815435771203595e-09,
  1.918727613306668e-09, -2.548890804189443e-10,  2.568562464545987e-11, -2.088508527136122e-12,  1.425383915062360e-13, -8.392086357690639e-15,  4.348872742203325e-16,
 -2.014290215213776e-17,  8.440445413929316e-19, -3.227447099777222e-20,  1.403106463035682e-08, -5.394117993862223e-09,  1.098722501316183e-09, -1.520447823521249e-10,
  1.594678228440603e-11, -1.348111037405139e-12,  9.555510614840517e-14, -5.836509311711946e-15,  3.134441739201024e-16, -1.502999186272368e-17,  6.513632354072545e-19,
 -2.573293646837545e-20,  7.652185928973004e-09, -3.042054420498423e-09,  6.425010717500641e-10, -9.218164126282853e-11,  1.001665411985693e-11, -8.765297639517556e-13,
  6.425098369430633e-14, -4.054674407712662e-15,  2.247702050105343e-16, -1.111532597917180e-17,  4.963552440406146e-19, -2.018680856911071e-20,  4.303400951662863e-09,
 -1.760579278626811e-09,  3.836761305653947e-10, -5.679807940008611e-11,  6.364482437072887e-12, -5.739025626918653e-13,  4.331511747482935e-14, -2.812270175053315e-15,
  1.602648155679798e-16, -8.141128849009297e-18,  3.731570993733367e-19, -1.556535658772381e-20,  2.486534239244214e-09, -1.041946360145965e-09,  2.331346636364696e-10,
 -3.543687943486297e-11,  4.075419862347849e-12, -3.769422744087036e-13,  2.916225649080479e-14, -1.939526487623038e-15,  1.131482659609722e-16, -5.880099570922573e-18,
  2.755549712666964e-19, -1.174359760377135e-20,  1.461063818859810e-09, -6.241694739375674e-10,  1.426769092553348e-10, -2.215826612803524e-11,  2.602801312671048e-12,
 -2.457692026135784e-13,  1.940138785510769e-14, -1.315938927441732e-15,  7.825032069729026e-17, -4.142805587086924e-18,  1.976825008063597e-19, -8.573822519429730e-21,
  8.517043782157359e-10, -3.692376167731189e-10,  8.579715970794012e-11, -1.354620937741610e-11,  1.617265928788005e-12, -1.551578496480750e-13,  1.243985438524440e-14,
 -8.566027148201346e-16,  5.169111449909968e-17, -2.776115523866622e-18,  1.343244496830329e-19, -5.905047003358123e-21,  4.615231669773323e-10, -2.021233592194111e-10,
  4.750247724182876e-11, -7.586360973233372e-12,  9.160109951071140e-13, -8.885725122334079e-14,  7.201418003606529e-15, -5.011241705002204e-16,  3.055090916797883e-17,
 -1.657176058594086e-18,  8.096397849825637e-20, -3.592853193653875e-21,  1.811857090712828e-10, -7.979781360394918e-11,  1.887273498001324e-11, -3.033337550130750e-12,
  3.685696312909098e-13, -3.597381051661883e-14,  2.933067740540760e-15, -2.053020354996601e-16,  1.258777169961681e-17, -6.866000789118406e-19,  3.372658542213366e-20,
 -1.504509643903886e-21,  7.429723550100205e-02, -2.309994122617443e-04,  7.509215467957043e-07, -2.528211369882334e-09,  8.724570437609754e-12, -3.058479482128454e-14,
  1.081555674151966e-16, -3.839991815514122e-19,  1.364335037654123e-21, -4.842112524874068e-24,  1.714370679429779e-26, -6.052456743421339e-29,  7.040124876635934e-02,
 -2.937400641306852e-04,  1.459043279085345e-06, -7.417229027209299e-09,  3.693759672512195e-11, -1.791322687107120e-13,  8.481561396797684e-16, -3.934695126203928e-18,
  1.793727220189825e-20, -8.053859047181626e-23,  3.567918285445658e-25, -1.561663912991059e-27,  6.322168125806546e-02, -3.982691183620448e-04,  2.862949337304468e-06,
 -1.927686466767366e-08,  1.219886793290687e-10, -7.362854982737362e-13,  4.280538447887745e-15, -2.412623969491037e-17,  1.324367513072657e-19, -7.104735423909351e-22,
  3.734850607850356e-24, -1.928004826729955e-26,  5.382337402114846e-02, -5.108919089924458e-04,  4.867959280030119e-06, -4.109481629203931e-08,  3.190912567525103e-10,
 -2.328829262727031e-12,  1.618015558672116e-14, -1.079321337807977e-16,  6.955208097342827e-19, -4.349809199278008e-21,  2.649675292461461e-23, -1.576548344138949e-25,
  4.346188956131634e-02, -5.976598729094624e-04,  7.223666539023422e-06, -7.475752084971498e-08,  6.986740614089785e-10, -6.052208379923434e-12,  4.936396319767219e-14,
 -3.831638818408311e-16,  2.852017856429103e-18, -2.047354092098285e-20,  1.423718941629079e-22, -9.623873607789250e-25,  3.330942932789461e-02, -6.355195709367410e-04,
  9.524636834034773e-06, -1.190121229931048e-07,  1.319385324608802e-09, -1.338057649259403e-11,  1.264871607402395e-13, -1.128653748671233e-15,  9.592268213953825e-18,
 -7.816954533526968e-20,  6.139782859034800e-22, -4.666827456289229e-24,  2.425001856213765e-02, -6.178162901258611e-04,  1.131005523863837e-05, -1.684994625377659e-07,
  2.190251747422898e-09, -2.572985726026421e-11,  2.791143138753086e-13, -2.836488157844165e-15,  2.728215314194611e-17, -2.502538217644928e-19,  2.202075047253257e-21,
 -1.867316463532676e-23,  1.678763161168635e-02, -5.530596443081130e-04,  1.221551534342027e-05, -2.146532588474919e-07,  3.240259068142646e-09, -4.371060737954215e-11,
  5.397672846429617e-13, -6.200172925327276e-15,  6.700722594876546e-17, -6.871194225843957e-19,  6.729151061563205e-21, -6.325642804699815e-23,  1.106446388472612e-02,
 -4.589552225097343e-04,  1.209468354360058e-05, -2.483044000724038e-07,  4.317219971750792e-09, -6.638455422395673e-11,  9.268438864659222e-13, -1.195742197727304e-14,
  1.443315319698634e-16, -1.645086121524597e-18,  1.783217789437069e-20, -1.848439677679537e-22,  6.952736324263771e-03, -3.551413839749126e-04,  1.105047389497938e-05,
 -2.628101038236544e-07,  5.225065760935003e-09, -9.099190942836238e-11,  1.427877901027315e-12, -2.057600093369257e-14,  2.759518742578865e-16, -3.478818671131311e-18,
  4.154147193429143e-20, -4.726757773836697e-22,  4.172357764305773e-03, -2.575759978642889e-04,  9.371235183291767e-06, -2.561949319010372e-07,  5.786443802577804e-09,
 -1.134635136273906e-10,  1.990687261959940e-12, -3.188509890951471e-14,  4.729481842572629e-16, -6.565852832041990e-18,  8.601396578532593e-20, -1.070028102274621e-21,
  2.395657259785536e-03, -1.759141102451569e-04,  7.415495154921164e-06, -2.313834145549199e-07,  5.901494583886073e-09, -1.296122129854943e-10,  2.530296972645632e-12,
 -4.484866566899347e-14,  7.327054185822816e-16, -1.115795058759457e-17,  1.597601451266660e-19, -2.165129221682889e-21,  1.318892773366907e-03, -1.136214474888756e-04,
  5.502455716263340e-06, -1.946657204423488e-07,  5.575581373630394e-09, -1.364864248999722e-10,  2.951716220698061e-12, -5.766047809704578e-14,  1.033621243172237e-15,
 -1.720427453981570e-17,  2.683152174680344e-19, -3.948489561305558e-21,  6.978694508245330e-04, -6.969091073065317e-05,  3.846763885746075e-06, -1.533466439839896e-07,
  4.906563250772709e-09, -1.332604496545147e-10,  3.179440473618526e-12, -6.819145659722530e-14,  1.336530541107802e-15, -2.423403922240760e-17,  4.103789137676968e-19,
 -6.537716648317112e-21,  3.558587672945614e-04, -4.075761549641644e-05,  2.545390224740765e-06, -1.136685288722585e-07,  4.042961289392981e-09, -1.213005275729165e-10,
  3.180366012082579e-12, -7.462288990625429e-14,  1.593804521172664e-15, -3.138259676237817e-17,  5.753129840319753e-19, -9.893818120761669e-21,  1.753904931452928e-04,
 -2.282059583386568e-05,  1.601452248012675e-06, -7.967150064336655e-08,  3.135256898458657e-09, -1.034841469607410e-10,  2.970489200591473e-12, -7.598831320489686e-14,
  1.762935415133225e-15, -3.758317667910846e-17,  7.437551719111905e-19, -1.376985587168446e-20,  8.382600558480689e-05, -1.228396578237344e-05,  9.624284248714096e-07,
 -5.306061061398327e-08,  2.299803345269144e-09, -8.317507387114351e-11,  2.604461596734505e-12, -7.239673979210378e-14,  1.818838416161683e-15, -4.185955512051669e-17,
  8.917835239725191e-19, -1.772800906762126e-20,  3.899005522802581e-05, -6.384319844237331e-06,  5.550717473216394e-07, -3.374251761224790e-08,  1.603796164249990e-09,
 -6.330942307234451e-11,  2.154941880507309e-12, -6.488020792393644e-14,  1.759798856408404e-15, -4.359893526059880e-17,  9.972482949072193e-19, -2.123207056993449e-20,
  1.771869316786216e-05, -3.218160899327647e-06,  3.087054012790785e-07, -2.059152264443361e-08,  1.068738672519155e-09, -4.587325156421451e-11,  1.691487206789300e-12,
 -5.498398897502188e-14,  1.605354831074404e-15, -4.269538767074032e-17,  1.045729689996947e-18, -2.378469434396770e-20,  7.900541067052597e-06, -1.580758496236604e-06,
  1.663847240263525e-07, -1.212078255826176e-08,  6.841058662482101e-10, -3.180952789356835e-11,  1.266262410712461e-12, -4.430036964574719e-14,  1.388164184573414e-15,
 -3.952179106827741e-17,  1.033801783763900e-18, -2.505571600541300e-20,  3.472296889976023e-06, -7.603937283797108e-07,  8.735701163427780e-08, -6.918242436257902e-09,
  4.228865010427890e-10, -2.122238840576916e-11,  9.089460496963200e-13, -3.411632871888431e-14,  1.143944129536597e-15, -3.476711812705683e-17,  9.686675777711831e-19,
 -2.495338003286203e-20,  1.511601249746499e-06, -3.600665857886523e-07,  4.491834337895832e-08, -3.849875730468045e-09,  2.538350530574539e-10, -1.369783268031621e-11,
  6.290534147755134e-13, -2.525025613988694e-14,  9.032612966204999e-16, -2.922208561739602e-17,  8.648649114760742e-19, -2.361910331739789e-20,  6.551959553753625e-07,
 -1.687547418679503e-07,  2.274580545953973e-08, -2.100468543693590e-09,  1.487796656127624e-10, -8.601205124553133e-12,  4.220713468417237e-13, -1.805973360800553e-14,
  6.871261487670776e-16, -2.359437304157226e-17,  7.397336372976943e-19, -2.135990341397589e-20,  2.843037717885697e-07, -7.872368162579336e-08,  1.140812031153128e-08,
 -1.130050098579198e-09,  8.564196697351059e-11, -5.284281773417471e-12,  2.761072768191820e-13, -1.255203961825284e-14,  5.063572448000859e-16, -1.839963395833743e-17,
  6.093539365626764e-19, -1.855304306939360e-20,  1.241996110608729e-07, -3.676604881621341e-08,  5.700326789663986e-09, -6.030135671362535e-10,  4.869672049964440e-11,
 -3.194655451311217e-12,  1.771015178306157e-13, -8.525026967601140e-15,  3.634591765505192e-16, -1.393323086180654e-17,  4.859889413229367e-19, -1.555833992947693e-20,
  5.493896652425415e-08, -1.729146382416594e-08,  2.854425262895181e-09, -3.210347773962962e-10,  2.751086564315773e-11, -1.911435099082579e-12,  1.120118124795786e-13,
 -5.689249313879694e-15,  2.554956953752596e-16, -1.030002339604091e-17,  3.772222481021120e-19, -1.266033502228899e-20,  2.474886278864753e-08, -8.237531058521571e-09,
  1.440810202554168e-09, -1.715088225691256e-10,  1.553027903624373e-11, -1.138225960085183e-12,  7.024085339010784e-14, -3.750826164761907e-15,  1.768158998927763e-16,
 -7.471243022945699e-18,  2.863851086372471e-19, -1.004553232635637e-20,  1.141718795635200e-08, -3.997571824625208e-09,  7.372373846528995e-10, -9.245774409579734e-11,
  8.808373656900127e-12, -6.781911456644398e-13,  4.390021646700655e-14, -2.455387741673534e-15,  1.210645712287128e-16, -5.343216174742651e-18,  2.136539988205282e-19,
 -7.807475638032431e-21,  5.421602266516894e-09, -1.986548056963016e-09,  3.843909220376068e-10, -5.055202150774195e-11,  5.044541663089018e-12, -4.062968753761960e-13,
  2.747564258139606e-14, -1.603338199845649e-15,  8.237531888492820e-17, -3.783804636676409e-18,  1.572802645680338e-19, -5.967445860243644e-21,  2.661768829037270e-09,
 -1.015421131524747e-09,  2.051270234240630e-10, -2.815460427276223e-11,  2.929424654021659e-12, -2.457361162968995e-13,  1.728768370871518e-14, -1.048286246257603e-15,
  5.590259521916597e-17, -2.662399694168788e-18,  1.146236913146642e-19, -4.499597285385595e-21,  1.355342570348718e-09, -5.355851514578643e-10,  1.123886361802484e-10,
 -1.602128614523764e-11,  1.729993518219407e-12, -1.504648060887169e-13,  1.096415940942235e-14, -6.879538263286698e-16,  3.792524310319274e-17, -1.865409824571675e-18,
  8.286678331451908e-20, -3.353260666073579e-21,  7.165005025850117e-10, -2.918272996679509e-10,  6.328853305550995e-11, -9.323745848856134e-12,  1.039827702720863e-12,
 -9.333275926058108e-14,  7.012814294942142e-15, -4.533422340470688e-16,  2.572657236529050e-17, -1.301546329135649e-18,  5.942275455242551e-20, -2.469240211371011e-21,
  3.922484676418997e-10, -1.638522550692914e-10,  3.653579297335377e-11, -5.534421247839369e-12,  6.343423612170280e-13, -5.847888673800976e-14,  4.509819854981310e-15,
 -2.990122035076652e-16,  1.739149686484257e-17, -9.011753858354390e-19,  4.211210880535406e-20, -1.789840862404255e-21,  2.203160975641298e-10, -9.392778079213714e-11,
  2.142221416894697e-11, -3.319427398076342e-12,  3.890477897939548e-13, -3.665623974045752e-14,  2.887604718744382e-15, -1.954571534832928e-16,  1.159949260579900e-17,
 -6.129287893410223e-19,  2.919249096228653e-20, -1.263837239303561e-21,  1.239645995780279e-10, -5.367811965216857e-11,  1.245625144515839e-11, -1.964048691385224e-12,
  2.341775255072332e-13, -2.243778621299798e-14,  1.796712180110399e-15, -1.235703998498385e-16,  7.447961894500828e-18, -3.995398582121583e-19,  1.931046761022112e-20,
 -8.479910648436560e-22,  6.551775930726223e-11, -2.867623391384432e-11,  6.734884174405685e-12, -1.074862393322710e-12,  1.296967911894589e-13, -1.257292584106957e-14,
  1.018316855726597e-15, -7.081714789445226e-17,  4.314715285448239e-18, -2.339043196933603e-19,  1.142114238769572e-20, -5.065383909974109e-22,  2.536230948642818e-11,
 -1.116708993065944e-11,  2.640295934941477e-12, -4.242334924339011e-13,  5.153127366745602e-14, -5.028130615158720e-15,  4.098387622228781e-16, -2.867855280754072e-17,
  1.757875598139958e-18, -9.585630887381547e-20,  4.707269344474113e-21, -2.099297742965950e-22,  7.338506374271533e-02, -2.251110665403640e-04,  7.214008302243309e-07,
 -2.393374344123387e-09,  8.137985797246690e-12, -2.811330795479100e-14,  9.798952119621920e-17, -3.430022022057303e-19,  1.201747056196584e-21, -4.206750806420583e-24,
  1.469242642863562e-26, -5.117645404652379e-29,  6.924908332678224e-02, -2.824139631418151e-04,  1.373467795745487e-06, -6.853818971733634e-09,  3.354990912734684e-11,
 -1.600363015283132e-13,  7.456035857812414e-16, -3.404467111125495e-18,  1.527904468067551e-20, -6.755080505143942e-23,  2.947156421275199e-25, -1.270593988728766e-27,
  6.167299234476813e-02, -3.762587162424469e-04,  2.642869399601724e-06, -1.743749101484969e-08,  1.082379585960791e-10, -6.412027427228973e-13,  3.660686665032966e-15,
 -2.027024349459208e-17,  1.093563034734881e-19, -5.767489802783433e-22,  2.981503708018362e-24, -1.513907224984639e-26,  5.185468855835580e-02, -4.738374007783456e-04,
  4.403982860327158e-06, -3.634185399305041e-08,  2.761655282429973e-10, -1.974393423276885e-12,  1.344749144077243e-14, -8.798923321305341e-17,  5.564448761247279e-19,
 -3.416617630411589e-21,  2.044042186955984e-23, -1.194852475284998e-25,  4.118140383052604e-02, -5.432776607840583e-04,  6.389853516076540e-06, -6.448618913077975e-08,
  5.886587746220849e-10, -4.986547123220743e-12,  3.980965719232504e-14, -3.026707201536837e-16,  2.208035953728095e-18, -1.554305399752143e-20,  1.060349860564924e-22,
 -7.034386836112790e-25,  3.091118142914904e-02, -5.646955031579068e-04,  8.214827524786884e-06, -9.988806324152007e-08,  1.079739739466757e-09, -1.069186685511630e-11,
  9.879074079494778e-14, -8.623612219858093e-16,  7.174854385918125e-18, -5.727322985852696e-20,  4.408736644839291e-22, -3.285707856958936e-24,  2.194770064374766e-02,
 -5.348649458780634e-04,  9.482453397693227e-06, -1.372335761160098e-07,  1.736685498397478e-09, -1.989327566620622e-11,  2.106731689848756e-13, -2.092091765221792e-15,
  1.967864652491664e-17, -1.766474334376266e-19,  1.522030975741540e-21, -1.264445068425857e-23,  1.475568971873260e-02, -4.648196710379438e-04,  9.924020694965817e-06,
 -1.691538963130212e-07,  2.482690671172247e-09, -3.261827794550797e-11,  3.928040564516640e-13, -4.404768739565442e-15,  4.651250711924111e-17, -4.663722895404082e-19,
  4.468840864228045e-21, -4.112668804041295e-23,  9.404820819688615e-03, -3.730356631484653e-04,  9.489295172318803e-06, -1.887469052238569e-07,  3.187333775430556e-09,
 -4.768625926013197e-11,  6.486898384152411e-13, -8.163195511220791e-15,  9.620204748660985e-17, -1.071425726616140e-18,  1.135621269514130e-20, -1.151760706655936e-22,
  5.690843013929557e-03, -2.780583750495376e-04,  8.343840630225494e-06, -1.920851124667195e-07,  3.705956562325818e-09, -6.274372029889039e-11,  9.586195215741365e-13,
 -1.346534612272665e-14,  1.762071047325649e-16, -2.169337759866259e-18,  2.531675702327126e-20, -2.817159310412740e-22,  3.274536879736696e-03, -1.934865509592771e-04,
  6.785156355927300e-06, -1.794454958875443e-07,  3.930614366987512e-09, -7.488699481774853e-11,  1.278500108998252e-12, -1.995101904921103e-14,  2.886162368254571e-16,
 -3.911266385151422e-18,  5.005600650656140e-20, -6.087658949397989e-22,  1.795094664088168e-03, -1.262688616808001e-04,  5.129520153964079e-06, -1.547815946949408e-07,
  3.827069511280188e-09, -8.163605098660343e-11,  1.550219101774042e-12, -2.676084165782652e-14,  4.262565006532241e-16, -6.334602121170494e-18,  8.858316372799978e-20,
 -1.173367440213389e-21,  9.395476600013305e-04, -7.761412620244962e-05,  3.622757256520996e-06, -1.239335563251445e-07,  3.440623537824607e-09, -8.178743639742439e-11,
  1.720182550267026e-12, -3.272112611178668e-14,  5.717827208624424e-16, -9.286148800205247e-18,  1.414286996398602e-19, -2.033973644661236e-21,  4.706471346114651e-04,
 -4.512137562339540e-05,  2.401527326778099e-06, -9.258885955403775e-08,  2.871689772006483e-09, -7.573870364945328e-11,  1.757386556594025e-12, -3.670214781314183e-14,
  7.012232091008771e-16, -1.240602924336809e-17,  2.051586586113699e-19, -3.194214315246789e-21,  2.262552439073101e-04, -2.491147831471171e-05,  1.501149872742134e-06,
 -6.486072062958631e-08,  2.236866048831630e-09, -6.518578383936076e-11,  1.662434427784492e-12, -3.798860046539819e-14,  7.910381783812889e-16, -1.520006503806808e-17,
  2.721600088272138e-19, -4.574945369468321e-21,  1.047006858531797e-04, -1.311572567244696e-05,  8.888949205103856e-07, -4.281426005674300e-08,  1.634453443360220e-09,
 -5.242058410467834e-11,  1.464164663291445e-12, -3.648930721070064e-14,  8.256027668422344e-16, -1.718115509031380e-17,  3.321849330387174e-19, -6.013238765820591e-21,
  4.679696232947908e-05, -6.613258787325580e-06,  5.009550254305829e-07, -2.676212567361931e-08,  1.126046755095171e-09, -3.959585122189761e-11,  1.207100489906520e-12,
 -3.270529872885929e-14,  8.017027662532261e-16, -1.801912076857815e-17,  3.752141132303694e-19, -7.296173603994434e-21,  2.027822312750619e-05, -3.207786479631014e-06,
  2.699964695045320e-07, -1.592060661696355e-08,  7.352521031240584e-10, -2.824158421897720e-11,  9.365629077521536e-13, -2.750278591357498e-14,  7.283174722930739e-16,
 -1.763251404705473e-17,  3.944338427547640e-19, -8.219098268416048e-21,  8.554168608076780e-06, -1.503841022291123e-06,  1.398610545648790e-07, -9.060443981864061e-09,
  4.574092232164483e-10, -1.912259057586849e-11,  6.875789532958107e-13, -2.181792714083151e-14,  6.224180889550745e-16, -1.618818413807468e-17,  3.880452115398624e-19,
 -8.644213977362047e-21,  3.528770952100494e-06, -6.848021636034461e-07,  6.999715965663477e-08, -4.959244227791422e-09,  2.725980617509794e-10, -1.235959219778123e-11,
  4.802798463236558e-13, -1.641837238739472e-14,  5.031572690688319e-16, -1.402147302888084e-17,  3.592636215075778e-19, -8.535113580355988e-21,  1.430548327132318e-06,
 -3.045002493090687e-07,  3.403180999184008e-08, -2.625294808199708e-09,  1.565064608494527e-10, -7.668538178376061e-12,  3.209995191852284e-13, -1.178621631058059e-14,
  3.869242933056058e-16, -1.152211768035828e-17,  3.147663818354050e-19, -7.955845080401375e-21,  5.729588065345537e-07, -1.329539100194497e-07,  1.616610460702334e-08,
 -1.351952063517595e-09,  8.706966212320702e-11, -4.594122643217144e-12,  2.064774612469699e-13, -8.118039515812577e-15,  2.846659465622799e-16, -9.034014733669353e-18,
  2.624541541634884e-19, -7.040137994438745e-21,  2.280137590547253e-07, -5.734243292136300e-08,  7.548423971157463e-09, -6.813887433594529e-10,  4.722297805390912e-11,
 -2.673540380350874e-12,  1.285850274849738e-13, -5.396668276082871e-15,  2.015436151943434e-16, -6.797443760593358e-18,  2.094517895353372e-19, -5.947551045260186e-21,
  9.070760207469719e-08, -2.458182804230847e-08,  3.486312323990470e-09, -3.382274058467871e-10,  2.512503155932283e-11, -1.520738877900776e-12,  7.800372677153164e-14,
 -3.483531644222970e-15,  1.381368749730276e-16, -4.937075664484333e-18,  1.609097986046488e-19, -4.824129152620823e-21,  3.630192792673094e-08, -1.054215384748034e-08,
  1.603101184648871e-09, -1.664242212147709e-10,  1.319817664170645e-11, -8.508594679430126e-13,  4.638281979035084e-14, -2.196833445365578e-15,  9.220893319747739e-17,
 -3.481926586221139e-18,  1.196920021878661e-19, -3.778245695002217e-21,  1.471201022291000e-08, -4.553198670306301e-09,  7.388102060143818e-10, -8.171221521728401e-11,
  6.889805921269463e-12, -4.712834439475791e-13,  2.720509700015119e-14, -1.361875468634295e-15,  6.030893646942272e-17, -2.398609160484152e-18,  8.670375538069635e-20,
 -2.873425323980296e-21,  6.078070244282374e-09, -1.993897633157222e-09,  3.435538891090667e-10, -4.029936010291531e-11,  3.597631995493378e-12, -2.600780496143786e-13,
  1.583837676224513e-14, -8.350128815136011e-16,  3.887971655270226e-17, -1.623344886656211e-18,  6.151144940559105e-20, -2.133721427847055e-21,  2.576752525769931e-09,
 -8.911992501414043e-10,  1.622592377794563e-10, -2.009409361716296e-11,  1.891062358771081e-12, -1.438871506616072e-13,  9.208104135553308e-15, -5.093610629172580e-16,
  2.484770505035251e-17, -1.085399492704268e-18,  4.296970843921011e-20, -1.555158849860112e-21,  1.128014245861170e-09, -4.091420857237746e-10,  7.832244959125366e-11,
 -1.019191052485288e-11,  1.006628553415058e-12, -8.027167945680304e-14,  5.376259099463849e-15, -3.108205966803177e-16,  1.582588414787933e-17, -7.206331008544170e-19,
  2.970278713082500e-20, -1.117825200582945e-21,  5.127637652012585e-10, -1.940189949729722e-10,  3.885357902868290e-11, -5.286980898981064e-12,  5.454899899273955e-13,
 -4.538684948620658e-14,  3.167870737176594e-15, -1.906300830777495e-16,  1.009095768820486e-17, -4.771627318935160e-19,  2.040141688316639e-20, -7.955264074516887e-22,
  2.430958694146306e-10, -9.545478631193243e-11,  1.989368223608627e-11, -2.816664824300141e-12,  3.021325614052690e-13, -2.610880117791416e-14,  1.890658477516179e-15,
 -1.179149720526956e-16,  6.462402191955965e-18, -3.160654909863018e-19,  1.396364474979211e-20, -5.620590490669996e-22,  1.204718851308448e-10, -4.883601527513293e-11,
  1.053663574717080e-11, -1.544326169641959e-12,  1.713684188844625e-13, -1.530681998731155e-14,  1.144691464119325e-15, -7.365993110884984e-17,  4.161583273359113e-18,
 -2.096372750100318e-19,  9.531307738143769e-21, -3.944707910842453e-22,  6.232364313078007e-11, -2.594763614406950e-11,  5.764689300953302e-12, -8.700481771577774e-13,
  9.936670156691173e-14, -9.128591259445058e-15,  7.016095637320384e-16, -4.636617981998700e-17,  2.688247367045212e-18, -1.388686082161298e-19,  6.470018880940213e-21,
 -2.741953032730577e-22,  3.338324831413932e-11, -1.420150291014281e-11,  3.231188501001505e-12, -4.994787410405556e-13,  5.840260140663269e-14, -5.490078455777100e-15,
  4.315169223034007e-16, -2.914536892007535e-17,  1.726008820962744e-18, -9.101805698712787e-20,  4.326422371949589e-21, -1.869464749680470e-22,  1.809543323983267e-11,
 -7.825619880530338e-12,  1.813411584312187e-12, -2.855261915038001e-13,  3.399646878586308e-14, -3.252952934184131e-15,  2.601363909172363e-16, -1.786807901187251e-17,
  1.075616755285566e-18, -5.763051515765585e-20,  2.782099325776264e-21, -1.220322738716233e-22,  9.314712007004136e-12, -4.074343710033041e-12,  9.562191452792122e-13,
 -1.524997685856289e-13,  1.838817497297382e-14, -1.781332811372491e-15,  1.441776601562351e-16, -1.001998450970776e-17,  6.101008042760907e-19, -3.305336563182376e-20,
  1.612953998235203e-21, -7.149363189642822e-23,  3.552569792011514e-12, -1.563770609131776e-12,  3.696143720050235e-13, -5.936932009746458e-14,  7.209242651073427e-15,
 -7.032160124997234e-16,  5.730082270931623e-17, -4.008418312393118e-18,  2.456259970879103e-19, -1.338997274061675e-20,  6.573599253440275e-22, -2.930799519237422e-23,
  7.249598306306114e-02, -2.194525702529115e-04,  6.934434351180709e-07, -2.267540111257784e-09,  7.598481073109604e-12, -2.587259865315015e-14,  8.890185915976496e-17,
 -3.068602181271117e-19,  1.060361937333542e-21, -3.661688988308355e-24,  1.261750182102893e-26, -4.336844121074235e-29,  6.814089463892299e-02, -2.717463156066059e-04,
  1.294340198606038e-06, -6.341685411397055e-09,  3.052068291331028e-11, -1.432326356849754e-13,  6.567735433059487e-16, -2.952276679627862e-18,  1.304660447927013e-20,
 -5.680780593388539e-23,  2.441347873911286e-25, -1.036931013075419e-27,  6.020895845721277e-02, -3.559242644344273e-04,  2.443602109715158e-06, -1.580368867703510e-08,
  9.624846076440551e-11, -5.597800253631183e-13,  3.139146963629413e-15, -1.708127369711924e-17,  9.058872964236404e-20, -4.698082531874601e-22,  2.388852682780372e-24,
 -1.193374664391249e-26,  5.002714292959280e-02, -4.402777210311597e-04,  3.993144000965807e-06, -3.222237581950922e-08,  2.397154344644660e-10, -1.679314159394231e-12,
  1.121565768184120e-14, -7.200290195546080e-17,  4.469797077122699e-19, -2.695156241261961e-21,  1.583990453614374e-23, -9.098873522650457e-26,  3.910584635327671e-02,
 -4.951013105754138e-04,  5.669399982594712e-06, -5.581632860826437e-08,  4.978348644266591e-10, -4.125317643287342e-12,  3.224546164983453e-14, -2.402046806152513e-16,
  1.717920075230807e-18, -1.186138527962469e-20,  7.940323212123199e-23, -5.170960130425229e-25,  2.877663936442566e-02, -5.034932744126861e-04,  7.113165081805011e-06,
 -8.420186914922103e-08,  8.877827657641826e-10, -8.586488273669634e-12,  7.757172004966196e-14, -6.626155985991678e-16,  5.398449466757835e-18, -4.222257131024476e-20,
  3.186134672921847e-22, -2.328791106287372e-24,  1.995015951755657e-02, -4.651486987809558e-04,  7.990081119724219e-06, -1.123735222663495e-07,  1.384980948738506e-09,
 -1.547438580803284e-11,  1.600324846250976e-13, -1.553381895010128e-15,  1.429318252021479e-17, -1.255927878542713e-19,  1.059873744170111e-21, -8.628297991228846e-24,
  1.304323160779275e-02, -3.929180491376476e-04,  8.112535681521391e-06, -1.341766482601974e-07,  1.915415690225185e-09, -2.451715590784068e-11,  2.880110119949198e-13,
 -3.153752788352630e-15,  3.254753690856642e-17, -3.191852497496239e-19,  2.993251375204632e-21, -2.697465307975575e-23,  8.051296978844243e-03, -3.053815477509217e-04,
  7.501385274324101e-06, -1.446053573395021e-07,  2.372437282311397e-09, -3.454540474954414e-11,  4.579922987721075e-13, -5.623239367549612e-15,  6.471698822115230e-17,
 -7.044466257070711e-19,  7.302506555976672e-21, -7.248040174865138e-23,  4.698819350451090e-03, -2.196075571332635e-04,  6.356904912067720e-06, -1.416963496261397e-07,
  2.653621822034358e-09, -4.368977308295602e-11,  6.500546992819648e-13, -8.902735220887091e-15,  1.136995159731110e-16, -1.367283435134887e-18,  1.559755580300566e-20,
 -1.697710610315787e-22,  2.596887181122171e-03, -1.468534256929888e-04,  4.964647205305153e-06, -1.270431186804351e-07,  2.699353583403619e-09, -4.998038187653461e-11,
  8.304824883258478e-13, -1.262872197699743e-14,  1.782074590135080e-16, -2.357862193631505e-18,  2.948431987490063e-20, -3.506082737439928e-22,  1.361649260284168e-03,
 -9.173336831953271e-05,  3.591573234926584e-06, -1.048182745188298e-07,  2.512860812806844e-09, -5.206964422062745e-11,  9.619424020482913e-13, -1.617521425234409e-14,
  2.512323270694108e-16, -3.643988404527358e-18,  4.977524540402804e-20, -6.444915795474117e-22,  6.788102555189062e-04, -5.375618088234101e-05,  2.418371267016692e-06,
 -8.000436306233465e-08,  2.153011150513625e-09, -4.970358418129426e-11,  1.016767933813075e-12, -1.883513500081543e-14,  3.208728682311917e-16, -5.085192124597561e-18,
  7.563803570948431e-20, -1.063177298471473e-21,  3.225171050939082e-04, -2.967412311109078e-05,  1.522723501594592e-06, -5.677694786687082e-08,  1.706987530416422e-09,
 -4.371991264462634e-11,  9.866086471994229e-13, -2.006466693960564e-14,  3.737067838481741e-16, -6.451415491758027e-18,  1.041901956557392e-19, -1.585439705537046e-21,
  1.464424151750564e-04, -1.549377152515159e-05,  9.006828180189357e-07, -3.764877256801788e-08,  1.258858999123811e-09, -3.563035618573964e-11,  8.838445139387939e-13,
 -1.966930832357006e-14,  3.993071953642310e-16, -7.487607517596025e-18,  1.309421768524075e-19, -2.151476931829748e-21,  6.374255289143087e-05, -7.683883758640475e-06,
  5.027841810486196e-07, -2.344120639432597e-08,  8.679840140580944e-10, -2.704686815446474e-11,  7.350130541741461e-13, -1.784388627644641e-14,  3.937100632189075e-16,
 -7.997421544658471e-18,  1.510561242737302e-19, -2.673415470495997e-21,  2.668955946211873e-05, -3.635232859924151e-06,  2.661354481576437e-07, -1.377262373920778e-08,
  5.624294590368326e-10, -1.922498549370726e-11,  5.704970568732990e-13, -1.506377992650287e-14,  3.602359251422152e-16, -7.906213919406289e-18,  1.608938239427337e-19,
 -3.059970793161011e-21,  1.079140722242502e-05, -1.648138542049622e-06,  1.342341742948792e-07, -7.674959988971566e-09,  3.442876241125361e-10, -1.286437744795643e-11,
  4.155380237985922e-13, -1.189915567735234e-14,  3.075834405647640e-16, -7.275318154525845e-18,  1.591341885010919e-19, -3.244864848266086e-21,  4.231562627370133e-06,
 -7.195676049406921e-07,  6.484720929354890e-08, -4.078096559031436e-09,  2.001779568930925e-10, -8.148192562314526e-12,  2.856057624031726e-13, -8.844127731573662e-15,
  2.464561637140599e-16, -6.266864333043836e-18,  1.469854219978971e-19, -3.206127476440258e-21,  1.616839686830369e-06, -3.041007650698702e-07,  3.016742525265604e-08,
 -2.077620958304849e-09,  1.111703968863758e-10, -4.912902324641084e-12,  1.862888980375925e-13, -6.220444134043809e-15,  1.863765342021021e-16, -5.082051015201341e-18,
  1.275110561144456e-19, -2.968561139752715e-21,  6.051154642832259e-07, -1.250964326473419e-07,  1.359235741356351e-08, -1.020779951558926e-09,  5.931808087649400e-11,
 -2.836425195520264e-12,  1.159899989464383e-13, -4.164457117329388e-15,  1.337985482914797e-16, -3.902484681544270e-18,  1.044950470193345e-19, -2.590548855367935e-21,
  2.230923701804075e-07, -5.038957089058783e-08,  5.967661764099610e-09, -4.866552817441942e-10,  3.059711615325072e-11, -1.577697646918116e-12,  6.936111079783717e-14,
 -2.669903991662673e-15,  9.173364036213413e-17, -2.854583271113256e-18,  8.137303231958044e-20, -2.143173903067351e-21,  8.152371316570842e-08, -2.000184002923538e-08,
  2.569617801106114e-09, -2.265918310058607e-10,  1.535571400078685e-11, -8.508953354460824e-13,  4.008922317997339e-14, -1.649517219186729e-15,  6.043852165887528e-17,
 -2.001245908521445e-18,  6.057935285688625e-20, -1.690950188416134e-21,  2.972437206814880e-08, -7.877225236127804e-09,  1.092563624306044e-09, -1.037415201439016e-10,
  7.548927106270656e-12, -4.479461473858731e-13,  2.254314204133610e-14, -9.884601041079153e-16,  3.851057840999785e-17, -1.353138654529905e-18,  4.338209094167604e-20,
 -1.280115538971829e-21,  1.089000796898340e-08, -3.099933119438565e-09,  4.620001825230486e-10, -4.703581030507466e-11,  3.660774342739268e-12, -2.317796893236312e-13,
  1.241736004522125e-14, -5.783651844455288e-16,  2.388755943815749e-17, -8.880896388526621e-19,  3.007256589864340e-20, -9.355980708453170e-22,  4.038646857929330e-09,
 -1.228122959577775e-09,  1.957383029078708e-10, -2.127446267915126e-11,  1.763891386371163e-12, -1.187155775458588e-13,  6.746741447288733e-15, -3.326931087890849e-16,
  1.452049288193460e-17, -5.694688162198932e-19,  2.030786811404022e-20, -6.642712626176352e-22,  1.527700738696938e-09, -4.935854247653806e-10,  8.372228727021416e-11,
 -9.671382744543337e-12,  8.506848898998547e-13, -6.062377230570609e-14,  3.641309694004584e-15, -1.894343822377849e-16,  8.707789238183311e-18, -3.590912880229266e-19,
  1.344433712926669e-20, -4.609887272073310e-22,  5.939623623367694e-10, -2.027902842654121e-10,  3.642777933411635e-11, -4.451997354176721e-12,  4.136474139880982e-13,
 -3.108646026143460e-14,  1.965754462072356e-15, -1.074912813038125e-16,  5.185529501754358e-18, -2.240879880766229e-19,  8.779472715874205e-21, -3.145674348633224e-22,
  2.391282056902882e-10, -8.580924242755078e-11,  1.624203794554060e-11, -2.090160870441919e-12,  2.042209349930886e-13, -1.611578061464843e-14,  1.068510761427614e-15,
 -6.117387987075814e-17,  3.085488977527297e-18, -1.392214625315958e-19,  5.687943346056527e-21, -2.122413568815383e-22,  1.003767488605938e-10, -3.765341019809120e-11,
  7.471211974351735e-12, -1.007429481770571e-12,  1.030255406920051e-13, -8.498811048487949e-15,  5.882834529096518e-16, -3.511725455494527e-17,  1.844533463193555e-18,
 -8.656780191602727e-20,  3.674447594727500e-21, -1.422776493920409e-22,  4.418196716120951e-11, -1.723209875941469e-11,  3.565379036499963e-12, -5.011892530074224e-13,
  5.338469110591406e-14, -4.581936000209151e-15,  3.296182831471225e-16, -2.042657759345900e-17,  1.112599766332248e-18, -5.409127049364735e-20,  2.375951221852474e-21,
 -9.510323845506451e-23,  2.046688717638680e-11, -8.255099880803417e-12,  1.771376379647439e-12, -2.582179924569142e-13,  2.850168516304347e-14, -2.532693236471482e-15,
  1.884571427552036e-16, -1.206842341584220e-17,  6.786407661759458e-19, -3.403117841530768e-20,  1.540461453508171e-21, -6.348456185158915e-23,  9.978160298854256e-12,
 -4.139580546382059e-12,  9.161089622581343e-13, -1.377306081135006e-13,  1.567037517508522e-14, -1.434295138210502e-15,  1.098434429044219e-16, -7.233886546910673e-18,
  4.180020471605273e-19, -2.152275423876596e-20,  9.996045077876174e-22, -4.223357440450282e-23,  5.084442591293132e-12, -2.157972685682755e-12,  4.897399676278822e-13,
 -7.551109923581329e-14,  8.807200966446704e-15, -8.258941559209857e-16,  6.476108546312231e-17, -4.364022426519045e-18,  2.578646781540488e-19, -1.356867410590999e-20,
  6.436184305650255e-22, -2.775471210209089e-23,  2.649594303661085e-12, -1.144311687563373e-12,  2.647715058751042e-13, -4.162626679824854e-14,  4.948951456566472e-15,
 -4.728577854110987e-16,  3.776105994335764e-17, -2.590171303139094e-18,  1.557158648120523e-19, -8.332383614157603e-21,  4.017419252112997e-22, -1.760047201852045e-23,
  1.326359393355756e-12, -5.797737156663371e-13,  1.359666126965095e-13, -2.166782491172763e-14,  2.610721452776663e-15, -2.527257664061189e-16,  2.044054836997021e-17,
 -1.419578936951109e-18,  8.637734097587909e-20, -4.676569004669954e-21,  2.280628678058327e-22, -1.010250332606438e-23,  4.979637191808454e-13, -2.191301143104710e-13,
  5.177679770663144e-14, -8.313872722295882e-15,  1.009222124311321e-15, -9.841099532148565e-17,  8.016334484462328e-18, -5.605968071741900e-19,  3.434132811048849e-20,
 -1.871501528066314e-21,  9.185102128203808e-23, -4.093926281437281e-24,  7.162909841086239e-02, -2.140118364978574e-04,  6.669456997530146e-07, -2.149990955700966e-09,
  7.101688898836723e-12, -2.383834320788657e-14,  8.076567158963299e-17, -2.749439724754486e-19,  9.371842945947077e-22, -3.193144916177452e-24,  1.085728717663657e-26,
 -3.683150430313330e-29,  6.707414829133000e-02, -2.616879055773443e-04,  1.221078125097916e-06, -5.875442554262944e-09,  2.780719612115479e-11, -1.284166835035458e-13,
  5.796601690591805e-16, -2.565707603839878e-18,  1.116684149937654e-20, -4.789657290777483e-23,  2.027963638346641e-25, -8.487516486447850e-28,  5.882319382304511e-02,
 -3.371086700867312e-04,  2.262841072208895e-06, -1.434934157546797e-08,  8.576914412752415e-11, -4.898672302568884e-13,  2.699038217254952e-15, -1.443558150558453e-17,
  7.527623534925148e-20, -3.839770851840934e-22,  1.920830307609947e-24, -9.442615960278689e-27,  4.832756224998271e-02, -4.098165012919710e-04,  3.628425395072367e-06,
 -2.864165141157729e-08,  2.086655945779462e-10, -1.432800537410281e-12,  9.386065661303883e-15, -5.913709584638704e-17,  3.604561450509988e-19, -2.134891823816968e-21,
  1.232881915188725e-23, -6.960907852231145e-26,  3.721209270197506e-02, -4.522958916200388e-04,  5.044803691692582e-06, -4.847115335211114e-08,  4.225531447354126e-10,
 -3.426297031420968e-12,  2.622929057079157e-14, -1.914922773187039e-16,  1.342993372362808e-18, -9.097438234552754e-21,  5.977480437781779e-23, -3.822167254134860e-25,
  2.687040205857525e-02, -4.504005907911185e-04,  6.182613950112621e-06, -7.127600355792612e-08,  7.332626321806796e-10, -6.929206308766258e-12,  6.122492087547116e-14,
 -5.119129883067210e-16,  4.085124360021999e-18, -3.131344562954794e-20,  2.316943589707577e-22, -1.661259297102092e-24,  1.820936807730559e-02, -4.062674991650747e-04,
  6.764981626814418e-06, -9.249495556368598e-08,  1.110628350660602e-09, -1.210776091125032e-11,  1.223157299771069e-13, -1.160848101527492e-15,  1.045153896146256e-17,
 -8.991910095667646e-20,  7.433989653667031e-22, -5.931850853187997e-24,  1.159185184573990e-02, -3.339722166899418e-04,  6.671253824865371e-06, -1.071052104104174e-07,
  1.487608530805216e-09, -1.855670591069255e-11,  2.127120155885400e-13, -2.275111755605720e-15,  2.295363155728604e-17, -2.202147763552456e-19,  2.021569297748036e-21,
 -1.784366389228152e-23,  6.939649314828619e-03, -2.517150983348043e-04,  5.972872803999604e-06, -1.116260080973326e-07,  1.779810698867171e-09, -2.523054286618997e-11,
  3.260908203909463e-13, -3.907379932605899e-15,  4.392708167240076e-17, -4.674294985499099e-19,  4.740120303260662e-21, -4.605218521097173e-23,  3.912268572271873e-03,
 -1.748932513137974e-04,  4.884992029609298e-06, -1.054589929331991e-07,  1.917594489652384e-09, -3.071015414168376e-11,  4.450964361186788e-13, -5.944731814358168e-15,
  7.411288030878471e-17, -8.707267078650256e-19,  9.711457709140460e-21, -1.034137778880912e-22,  2.080197135059255e-03, -1.125695809638576e-04,  3.669486000162686e-06,
 -9.087693533687631e-08,  1.873444715763141e-09, -3.371863805644823e-11,  5.454177435375673e-13, -8.083703446266534e-15,  1.112937931058340e-16, -1.437932504899857e-18,
  1.757195888490489e-20, -2.043427809006321e-22,  1.045084767715937e-03, -6.742026089242500e-05,  2.544301318741897e-06, -7.182834314019577e-08,  1.669875322583208e-09,
 -3.361817672142956e-11,  6.043157834076323e-13, -9.899850233033143e-15,  1.499597609559596e-16, -2.123207979330858e-18,  2.833306053202314e-20, -3.586533846271586e-22,
  4.971361492383875e-04, -3.773154891822305e-05,  1.636054409048100e-06, -5.234330643541993e-08,  1.365593679208443e-09, -3.061982253995803e-11,  6.093008430279549e-13,
 -1.099309508791475e-14,  1.825964249742330e-16, -2.824105432550281e-18,  4.102862514355024e-20, -5.637022249857707e-22,  2.244464891943846e-04, -1.981228205472816e-05,
  9.801143512062731e-07, -3.534299004671405e-08,  1.030036664761195e-09, -2.562060579100345e-11,  5.623334851134295e-13, -1.113699111774619e-14,  2.022205044420602e-16,
 -3.406591551455907e-18,  5.373148335093147e-20, -7.991363107050262e-22,  9.643735869044079e-05, -9.800544860689943e-06,  5.495099237133362e-07, -2.221949486562037e-08,
  7.202881358857730e-10, -1.980012058655488e-11,  4.777293622833074e-13, -1.035373973903002e-14,  2.049219778785231e-16, -3.749837390780263e-18,  6.404814754984300e-20,
 -1.028628728178577e-21,  3.955606401924491e-05, -4.586330819346083e-06,  2.896607478069920e-07, -1.306980315328662e-08,  4.693439429391063e-10, -1.420785045057857e-11,
  3.756303411446576e-13, -8.882664633668977e-15,  1.911106044559234e-16, -3.789008296480173e-18,  6.991188376583153e-20, -1.209638284801275e-21,  1.554284305190847e-05,
 -2.039270417756122e-06,  1.442364981912962e-07, -7.228772186029316e-09,  2.864434297023936e-10, -9.516216546665755e-12,  2.748390707469649e-13, -7.071395972773567e-15,
  1.649534219952227e-16, -3.534704489727101e-18,  7.029115262663704e-20, -1.307355257302706e-21,  5.873563502358556e-06, -8.655411253225419e-07,  6.818367212599435e-08,
 -3.778783700581047e-09,  1.646032857643331e-10, -5.981500545416728e-12,  1.881516613435206e-13, -5.252786262619591e-15,  1.325124091724196e-16, -3.061705324711899e-18,
  6.547154723177284e-20, -1.306164224149062e-21,  2.144057789910907e-06, -3.524168419960575e-07,  3.075915560833934e-08, -1.877012252928134e-09,  8.955055279035386e-11,
 -3.547922150775381e-12,  1.211938933621964e-13, -3.661401507377473e-15,  9.964085690342406e-17, -2.476501223584632e-18,  5.682025833212766e-20, -1.213327197109929e-21,
  7.597407032003875e-07, -1.383895388517929e-07,  1.331597083771436e-08, -8.909955917183482e-10,  4.638974001441920e-11, -1.997403375685842e-12,  7.387801671206508e-14,
 -2.408806113397576e-15,  7.053921555358812e-17, -1.881510335625025e-18,  4.621481191199001e-20, -1.054054402927610e-21,  2.627561733268976e-07, -5.271568443721982e-08,
  5.564933314306676e-09, -4.066265408690743e-10,  2.302138918273226e-11, -1.073790320278193e-12,  4.287867728858931e-14, -1.504786219133044e-15,  4.729848539054153e-17,
 -1.350725524747922e-18,  3.543838263724849e-20, -8.614457936118950e-22,  8.922940285126948e-08, -1.960137781317547e-08,  2.259470280546725e-09, -1.795627978814313e-10,
  1.101501886434634e-11, -5.547689342720550e-13,  2.384616520317890e-14, -8.982647048247846e-16,  3.022748792775101e-17, -9.219565524453689e-19,  2.577786613657759e-20,
 -6.663671693242106e-22,  2.994947432727440e-08, -7.162798072062705e-09,  8.973920463130396e-10, -7.725181015685891e-11,  5.116104975024000e-12, -2.773162474483648e-13,
  1.279227027406464e-14, -5.157713006370113e-16,  1.853214892358837e-17, -6.021856615391822e-19,  1.790016397374420e-20, -4.909526677853876e-22,  1.000697857403114e-08,
 -2.591131410497944e-09,  3.512033618456915e-10, -3.261597557002573e-11,  2.323393109731495e-12, -1.350825599699952e-13,  6.666149504101428e-15, -2.868353890119775e-16,
  1.097410494194387e-17, -3.789031879702961e-19,  1.194416720668274e-20, -3.467439972135382e-22,  3.354215013163914e-09, -9.351518419177878e-10,  1.364908891181952e-10,
 -1.361818449183270e-11,  1.039511296616637e-12, -6.459908970034844e-14,  3.399274701824774e-15, -1.556168550066680e-16,  6.321153894199868e-18, -2.312632055958645e-19,
  7.710534620150715e-21, -2.363206570843699e-22,  1.137110297861110e-09, -3.394901343592919e-10,  5.310787593016785e-11, -5.668546178746130e-12,  4.618467684827866e-13,
 -3.056541886350585e-14,  1.709169444562806e-15, -8.297749204071738e-17,  3.567511027902129e-18, -1.378951906323638e-19,  4.849011444286348e-21, -1.564788937209173e-22,
  3.932314003374845e-10, -1.250369469007644e-10,  2.086403533359669e-11, -2.371930711058216e-12,  2.054337867144817e-13, -1.442368115697283e-14,  8.539929877273179e-16,
 -4.381692162350397e-17,  1.987415135557633e-18, -8.090643258481233e-20,  2.991604467385721e-21, -1.013514290513688e-22,  1.399339666432762e-10, -4.713087459889139e-11,
  8.347532604599902e-12, -1.006175354413147e-12,  9.224248622770726e-14, -6.843109336886419e-15,  4.273559352002249e-16, -2.308880257869162e-17,  1.100955488956092e-18,
 -4.704523443683854e-20,  1.823262735858090e-21, -6.464608971988494e-23,  5.168853680212156e-11, -1.833933488498458e-11,  3.430274302458471e-12, -4.363078507349115e-13,
  4.214897304561370e-14, -3.289830414184213e-15,  2.158233611801494e-16, -1.223038951759093e-17,  6.108070798812139e-19, -2.729835356749176e-20,  1.105028501593311e-21,
 -4.086726097360862e-23,  1.998154904226388e-11, -7.427204435044984e-12,  1.459453685718535e-12, -1.949156513778222e-13,  1.974800111014248e-14, -1.614397314429615e-15,
  1.107751950931846e-16, -6.557028669137776e-18,  3.416067175232625e-19, -1.590623536959472e-20,  6.700188807252160e-22, -2.575316737742672e-23,  8.142125132635703e-12,
 -3.153008578736913e-12,  6.473788496640464e-13, -9.031326017652155e-14,  9.548759722439422e-15, -8.136864957857989e-16,  5.812961044558276e-17, -3.578151356735562e-18,
  1.936311339039157e-19, -9.354686686407889e-21,  4.084082618140709e-22, -1.625169846795893e-23,  3.515279931914665e-12, -1.410289362573452e-12,  3.008697239140364e-13,
 -4.360646501573295e-14,  4.786194717225024e-15, -4.229887442781970e-16,  3.130827993372405e-17, -1.994670613786022e-18,  1.116108948530946e-19, -5.570052489565058e-21,
  2.509666090487963e-22, -1.029640265676847e-23,  1.610449256541167e-12, -6.656008994857296e-13,  1.466935064741152e-13, -2.196369627296482e-14,  2.488882385172558e-15,
 -2.269144654515480e-16,  1.731202620117283e-17, -1.135918425278361e-18,  6.540428100844168e-20, -3.356039971066004e-21,  1.553483190682874e-22, -6.542365725437146e-24,
  7.786217722238180e-13, -3.296554287050223e-13,  7.461056702192555e-14, -1.147270538706733e-14,  1.334555693560355e-15, -1.248238440529675e-16,  9.763250611277183e-18,
 -6.563078082274516e-19,  3.868881211119729e-20, -2.031120708444416e-21,  9.613077631738894e-23, -4.136554492730094e-24,  3.892344045250967e-13, -1.678624658048010e-13,
  3.877827528707836e-14, -6.086818880055757e-15,  7.225270724925351e-16, -6.892969222516557e-17,  5.496334496727692e-18, -3.764690617987039e-19,  2.260080788495494e-20,
 -1.207726868144480e-21,  5.815305960125293e-23, -2.544452008472506e-24,  1.891793323294157e-13, -8.263475084662614e-14,  1.936383230506988e-14, -3.083376512318854e-15,
  3.712179276558063e-16, -3.590727419383494e-17,  2.902004990327566e-18, -2.013938863430688e-19,  1.224548811724892e-20, -6.625237097757556e-22,  3.228750924512811e-23,
 -1.429300454338420e-24,  6.985011887178158e-14, -3.072839092314587e-14,  7.258117212607801e-15, -1.165039941376981e-15,  1.413753954683020e-16, -1.378105308942501e-17,
  1.122196308871214e-18, -7.845136981367882e-20,  4.804261475320339e-21, -2.617351806712871e-22,  1.284165406802692e-23, -5.721963677661478e-25,  7.078356147687724e-02,
 -2.087775743691134e-04,  6.418121712585884e-07, -2.040075307625712e-09,  6.643699296965883e-12, -2.198906270274212e-14,  7.347039735351985e-17, -2.467125759455806e-19,
  8.296732252867374e-22, -2.789580913632058e-24,  9.360843335196022e-27, -3.134623097124538e-29,  6.604649781204605e-02, -2.521939286626829e-04,  1.153159933714017e-06,
 -5.450341927759310e-09,  2.537236399003733e-11, -1.153280769157266e-13,  5.125746378662422e-16, -2.234461695313850e-18,  9.580011216112730e-21, -4.048452308009951e-23,
  1.689125111049733e-25, -6.967297710602934e-28,  5.750990603154647e-02, -3.196721030923645e-04,  2.098570535448724e-06, -1.305202716852258e-08,  7.658818322529469e-11,
 -4.296807314434249e-13,  2.326588803072696e-15, -1.223385960215022e-17,  6.274152024717688e-20, -3.148463080466955e-22,  1.549850581950575e-24, -7.498929711001487e-27,
  4.674425163875463e-02, -3.821092413983673e-04,  3.303849989856223e-06, -2.552055096720311e-08,  1.821345634386579e-10, -1.226169371062864e-12,  7.880802709821122e-15,
 -4.874269892614582e-17,  2.917854635682349e-19, -1.697920980175516e-21,  9.636953075912374e-24, -5.349215424601490e-26,  3.548009785030626e-02, -4.141541374577993e-04,
  4.501559610928086e-06, -4.222604692291811e-08,  3.599118006269576e-10, -2.856566096565746e-12,  2.142304143184060e-14, -1.533261368111267e-16,  1.054758337537729e-18,
 -7.011636247646920e-21,  4.522920980358384e-23, -2.840335744152401e-25,  2.516257285418757e-02, -4.041715167812830e-04,  5.393367753995287e-06, -6.057725754399932e-08,
  6.082836130790420e-10, -5.618020190901004e-12,  4.856399455537932e-14, -3.975706265749878e-16,  3.108432332023818e-18, -2.335758626956798e-20,  1.695056423735998e-22,
 -1.192515420181842e-24,  1.668591162897841e-02, -3.563027328759534e-04,  5.754159382255627e-06, -7.651305171234026e-08,  8.953794384011957e-10, -9.527233435660623e-12,
  9.404576997214069e-14, -8.729274487825437e-16,  7.692253801286155e-18, -6.481450244307588e-20,  5.250839853106794e-22, -4.107673234144099e-24,  1.035509924403017e-02,
 -2.853651125431468e-04,  5.517397008844155e-06, -8.601542480716035e-08,  1.162765131832508e-09, -1.413985779409300e-11,  1.582032763388219e-13, -1.653248866557468e-15,
  1.631017605595743e-17, -1.531200313347239e-19,  1.376318382222556e-21, -1.190132622430069e-23,  6.020507462949607e-03, -2.088418172916376e-04,  4.788852613779340e-06,
 -8.679522889661760e-08,  1.345359096645690e-09, -1.857273459689633e-11,  2.340733955493386e-13, -2.737986067541849e-15,  3.007463420031589e-17, -3.129248791046948e-19,
  3.104987142778164e-21, -2.953421467817524e-23,  3.283519798530287e-03, -1.403969322162423e-04,  3.785040783810989e-06, -7.916281862471612e-08,  1.398003110009950e-09,
 -2.178376577690044e-11,  3.076211821363024e-13, -4.007766325416468e-15,  4.878520387857732e-17, -5.600897130005207e-19,  6.108761371919848e-21, -6.365288261511542e-23,
  1.682381158251313e-03, -8.711319510031308e-05,  2.738668921585317e-06, -6.565586193655900e-08,  1.313531616209836e-09, -2.298568210828163e-11,  3.620255779857355e-13,
 -5.230731279482485e-15,  7.027526540278182e-17, -8.868010337191293e-19,  1.059238793018316e-20, -1.204797643345211e-22,  8.112333749406808e-04, -5.010581579806359e-05,
  1.822798005542897e-06, -4.978654261239523e-08,  1.122623661243268e-09, -2.196220123741446e-11,  3.842082893968950e-13, -6.132930466498080e-15,  9.061590781450106e-17,
 -1.252578192485111e-18,  1.633176855816281e-20, -2.021397499119115e-22,  3.688776805040408e-04, -2.682600620356726e-05,  1.121136554642899e-06, -3.469232684785134e-08,
  8.775484948584305e-10, -1.911372615197897e-11,  3.700183728778598e-13, -6.502877843072566e-15,  1.053263018012868e-16, -1.589967996521137e-18,  2.256387999505758e-20,
 -3.030521309554455e-22,  1.585427313152921e-04, -1.342231760489387e-05,  6.400867643486176e-07, -2.232260399415709e-08,  6.306731205504592e-10, -1.523543088140154e-11,
  3.252573717412140e-13, -6.273613874698551e-15,  1.110613346066115e-16, -1.825816298916198e-18,  2.812741353432146e-20, -4.088991103511836e-22,  6.458012778428536e-05,
 -6.301571989305808e-06,  3.407331003864262e-07, -1.332662085245968e-08,  4.188167269396081e-10, -1.118150240391147e-11,  2.624062497501392e-13, -5.538548544647789e-15,
  1.068725612906003e-16, -1.908464688738423e-18,  3.183770052691017e-20, -4.997969593275637e-22,  2.500731418570816e-05, -2.787521842934406e-06,  1.698853077138615e-07,
 -7.417307479943798e-09,  2.582917512203145e-10, -7.595283357321811e-12,  1.953451563873415e-13, -4.499357050700671e-15,  9.439009634656435e-17, -1.826485708233118e-18,
  3.292013219831975e-20, -5.568336051218456e-22,  9.237654372787330e-06, -1.166878439271898e-06,  7.970897066941448e-08, -3.867805525918393e-09,  1.486888732703872e-10,
 -4.800240599730485e-12,  1.349104010034492e-13, -3.381944576422557e-15,  7.694469140850928e-17, -1.609669882548451e-18,  3.127659718491060e-20, -5.688361879931649e-22,
  3.268113104664111e-06, -4.643964308983085e-07,  3.536873637937677e-08, -1.899353891471893e-09,  8.031840857961071e-11, -2.837850526317895e-12,  8.691077475105098e-14,
 -2.365104561288668e-15,  5.821865653473684e-17, -1.313761381206591e-18,  2.746101821136589e-20, -5.359318903989670e-22,  1.112271267697840e-06, -1.765984921132216e-07,
  1.492049381062715e-08, -8.831276780487662e-10,  4.093686766295118e-11, -1.578145774575274e-12,  5.252112642234019e-14, -1.547635002281365e-15,  4.112075539968975e-17,
 -9.987475393488596e-19,  2.241139713529098e-20, -4.684070233651925e-22,  3.660022067879419e-07, -6.451936697758872e-08,  6.018075969141960e-09, -3.910422123383475e-10,
  1.980199513523839e-11, -8.303906085184675e-13,  2.994896886559205e-14, -9.531942826075646e-16,  2.727337637261436e-17, -7.114102580800013e-19,  1.710186570673912e-20,
 -3.820294356682287e-22,  1.171008054225611e-07, -2.278173290021503e-08,  2.335064648797773e-09, -1.659176222446123e-10,  9.147348022723908e-12, -4.159995617803026e-13,
  1.621470235203935e-14, -5.559963152210952e-16,  1.709101315506251e-17, -4.777164327464139e-19,  1.227690065978499e-20, -2.925271002281839e-22,  3.665749920204184e-08,
 -7.825415693530022e-09,  8.773705837558285e-10, -6.790782278053095e-11,  4.062178341689583e-12, -1.997331063315393e-13,  8.390102870380535e-15, -3.091498838934853e-16,
  1.018479663980450e-17, -3.043583251764435e-19,  8.343696662767081e-21, -2.116214607192691e-22,  1.130598945761980e-08, -2.633556215851747e-09,  3.215326503737021e-10,
 -2.700331186018976e-11,  1.746596068880998e-12, -9.255877166171285e-14,  4.178173704282588e-15, -1.649931023601190e-16,  5.810948664326234e-18, -1.852169274489381e-19,
  5.404175074145157e-21, -1.455846959155141e-22,  3.461874709409343e-09, -8.750914144919956e-10,  1.158216686381947e-10, -1.051304336782927e-11,  7.326642225436258e-13,
 -4.171202770925454e-14,  2.017363017347109e-15, -8.513896504605492e-17,  3.197170486929802e-18, -1.084221086873058e-19,  3.359001035938367e-21, -9.589390613862642e-23,
  1.061155141205991e-09, -2.895151638284671e-10,  4.135161858987682e-11, -4.040465605202282e-12,  3.022894430755738e-13, -1.842676357119526e-14,  9.518415958381014e-16,
 -4.280514358235529e-17,  1.709153841810984e-18, -6.150387662363944e-20,  2.018088546242580e-21, -6.090596824933722e-23,  3.285431768508287e-10, -9.622370953983103e-11,
  1.476331634906746e-11, -1.546399292443792e-12,  1.237300979486419e-13, -8.047033843885091e-15,  4.424918921905857e-16, -2.113807336485842e-17,  8.947651615236418e-19,
 -3.406981557503491e-20,  1.180795856378601e-21, -3.757498264937823e-23,  1.037206608895776e-10, -3.243309629779536e-11,  5.320030346628296e-12, -5.948090680383099e-13,
  5.069416656485898e-14, -3.504519059922795e-15,  2.044184567186129e-16, -1.033847224169957e-17,  4.624600758010893e-19, -1.857590141448964e-20,  6.780326344150560e-22,
 -2.268572845021679e-23,  3.371869287612684e-11, -1.119545679251241e-11,  1.953737861687854e-12, -2.321107710401118e-13,  2.098308862871060e-14, -1.535754919653180e-15,
  9.466672814981389e-17, -5.050670192916476e-18,  2.379296119814821e-19, -1.004863267251973e-20,  3.850572746644676e-22, -1.350440032012339e-23,  1.140060883139829e-11,
 -3.996982025329435e-12,  7.383267607471376e-13, -9.276451768401440e-14,  8.855349399512489e-15, -6.832753561868330e-16,  4.432993446870220e-17, -2.485322364180696e-18,
  1.228430889285067e-19, -5.435511312144201e-21,  2.179116816608474e-22, -7.984223822291989e-24,  4.047868734850296e-12, -1.490099811218939e-12,  2.898174957605899e-13,
 -3.831673338409112e-14,  3.844108462338479e-15, -3.112799730080076e-16,  2.116364094112806e-17, -1.241645739853493e-18,  6.413433242699029e-20, -2.961628097322757e-21,
  1.237567808435662e-22, -4.720123479586443e-24,  1.522489974356224e-12, -5.851208405539319e-13,  1.191651277515998e-13, -1.649109296175394e-14,  1.729988378470190e-15,
 -1.463041873707933e-16,  1.037547865172721e-17, -6.341420921351908e-19,  3.408184315128908e-20, -1.635671892142939e-21,  7.095378771750148e-23, -2.806023647684417e-24,
  6.107570918534460e-13, -2.436388374546810e-13,  5.165872573528888e-14, -7.441519860640022e-15,  8.119156118471286e-16, -7.134045938487485e-17,  5.250886283803038e-18,
 -3.327285852627048e-19,  1.852031068084683e-20, -9.195987924355472e-22,  4.123104842311243e-23, -1.683594450732518e-24,  2.621486678636137e-13, -1.079115747407001e-13,
  2.367865149743739e-14, -3.529803314649376e-15,  3.982822957583138e-16, -3.616122635177583e-17,  2.747759925814086e-18, -1.795905813996080e-19,  1.030155098634352e-20,
 -5.266674571816492e-22,  2.429293111746422e-23, -1.019589291729215e-24,  1.199289096752789e-13, -5.064279446815899e-14,  1.142882768311241e-14, -1.752313646093186e-15,
  2.032605834480858e-16, -1.895910160681389e-17,  1.478951315344260e-18, -9.916125939338893e-20,  5.830826429877773e-21, -3.053690509456538e-22,  1.441881376524048e-23,
 -6.190395718182176e-25,  5.737901841948821e-14, -2.470768675291718e-14,  5.698104071584670e-15, -8.928813303102759e-16,  1.058114216936780e-16, -1.007808823502433e-17,
  8.023395755547421e-19, -5.487161620258926e-20,  3.289241586065946e-21, -1.755146529587105e-22,  8.439349989028498e-24, -3.687588554930644e-25,  2.703019431352751e-14,
 -1.179807617878588e-14,  2.762319850116268e-15, -4.394817550711449e-16,  5.286647377661677e-17, -5.109506344471270e-18,  4.126184294537184e-19, -2.861276395540808e-20,
  1.738448233464517e-21, -9.398707400021742e-23,  4.577106113252331e-24, -2.024785480845503e-25,  9.805391427219694e-15, -4.312209952997944e-15,  1.018188971310550e-15,
 -1.633755833663085e-16,  1.981815373114286e-17, -1.931154594432313e-18,  1.571996022887337e-19, -1.098585785689785e-20,  6.725333638601756e-22, -3.662738897134873e-23,
  1.796488146156714e-24, -8.002233869040511e-26,  6.995856763630211e-02, -2.037392263399815e-04,  6.179548539670659e-07, -1.937200859400563e-09,  6.221006514519761e-12,
 -2.030575876754840e-14,  6.691954163912032e-17, -2.217001775382363e-19,  7.356687194875690e-22, -2.441316186247158e-24,  8.085974245887944e-27, -2.673320939035682e-29,
  6.505576794756290e-02, -2.432235353817794e-04,  1.090117569449207e-06, -5.062188864535747e-09,  2.318392608743544e-11, -1.037437249135634e-13,  4.540914142760152e-16,
 -1.949974060631785e-18,  8.237147935985740e-21, -3.430300902489511e-23,  1.410597218281684e-25, -5.735452698423970e-28,  5.626383136660509e-02, -3.034898380929750e-04,
  1.949024604558630e-06, -1.189244379682846e-08,  6.852633309467263e-11, -3.777363643759960e-13,  2.010526695908576e-15, -1.039613399802287e-17,  5.244780181738747e-20,
 -2.589762932510628e-22,  1.254726911352548e-24, -5.976583529713309e-27,  4.526680427493816e-02, -3.568556865650858e-04,  3.014311089338983e-06, -2.279275423099394e-08,
  1.593972427742016e-10, -1.052406486014174e-12,  6.638042792614113e-15, -4.031353835837740e-17,  2.370670891471740e-19, -1.355677233847556e-21,  7.564021630444913e-24,
 -4.128607644914140e-26,  3.389242977636745e-02, -3.800747822754962e-04,  4.027599908600517e-06, -3.689796695779168e-08,  3.075930301408177e-10, -2.390338008684221e-12,
  1.756684909852089e-14, -1.232864519012765e-16,  8.321029886886671e-19, -5.429638292153409e-21,  3.439326291278132e-23, -2.121690097829416e-25,  2.362779961825011e-02,
 -3.637749759278867e-04,  4.721323255682900e-06, -5.168386767690131e-08,  5.067318336484403e-10, -4.575560562338707e-12,  3.870695078311537e-14, -3.103423065615505e-16,
  2.377937123268024e-18, -1.752092584550487e-20,  1.247353514293521e-22, -8.612475016513383e-25,  1.534727794445147e-02, -3.137122650492620e-04,  4.916046903626330e-06,
 -6.359653846001822e-08,  7.255610598741034e-10, -7.537642743400062e-12,  7.272613029289560e-14, -6.603836792272603e-16,  5.697145749595511e-18, -4.702537871105200e-20,
  3.734050456038451e-22, -2.864484732243238e-24,  9.295799737196605e-03, -2.450586310783802e-04,  4.588132723112099e-06, -6.948200241770141e-08,  9.144716906586981e-10,
 -1.084423058976176e-11,  1.184607893828193e-13, -1.209841192520688e-15,  1.167436297502217e-17, -1.072733877927341e-19,  9.443344075473047e-22, -8.001676387606413e-24,
  5.255647145528847e-03, -1.743575990814785e-04,  3.865128276079337e-06, -6.796012363423502e-08,  1.024393060762915e-09, -1.377579764499004e-11,  1.693468985277627e-13,
 -1.934202210699361e-15,  2.076350859123261e-17, -2.112994651309785e-19,  2.051925704254067e-21, -1.911280908215732e-23,  2.776972592915844e-03, -1.135668468652820e-04,
  2.956120266240631e-06, -5.991423658990732e-08,  1.027905632756385e-09, -1.558813070177943e-11,  2.145352440799796e-13, -2.727075263550593e-15,  3.241948012181017e-17,
 -3.637899414854070e-19,  3.880864722328967e-21, -3.957757995857025e-23,  1.373219150677184e-03, -6.803014554418559e-05,  2.063130433085946e-06, -4.789055957586852e-08,
  9.300388171789317e-10, -1.582729125604027e-11,  2.427770320723835e-13, -3.420303678201687e-15,  4.485094100841739e-17, -5.528843522396659e-19,  6.456047837978144e-21,
 -7.183610842939499e-23,  6.365819511435309e-04, -3.763822734806866e-05,  1.320112788806731e-06, -3.489049153552091e-08,  7.632118907085240e-10, -1.451175416586257e-11,
  2.471104468061711e-13, -3.844192576056595e-15,  5.541208038690849e-17, -7.479223953509206e-19,  9.529670941345300e-21, -1.153441390002836e-22,  2.771775030906382e-04,
 -1.930965203460262e-05,  7.778671645917509e-07, -2.328291937270990e-08,  5.710945223216591e-10, -1.208464336157687e-11,  2.276245850150446e-13, -3.897200329035274e-15,
  6.155990334301764e-17, -9.071202994363153e-19,  1.257649022139537e-20, -1.651394267745740e-22,  1.136131195147036e-04, -9.222237325700364e-06,  4.239312868596134e-07,
 -1.429857493422426e-08,  3.916412075230890e-10, -9.189351912428077e-12,  1.908358618393847e-13, -3.585111252172247e-15,  6.188282953875781e-17, -9.928805494396315e-19,
  1.494050689754696e-20, -2.123125409555308e-22,  4.395367594358080e-05, -4.116475733478176e-06,  2.146197218386115e-07, -8.118924601881241e-09,  2.473594745960178e-10,
 -6.413909085509561e-12,  1.464081247526901e-13, -3.009569131567927e-15,  5.661940984199119e-17, -9.867090086116973e-19,  1.607760505817654e-20, -2.467080266042686e-22,
  1.609749169217351e-05, -1.724294822398080e-06,  1.013820876298853e-07, -4.282545387574771e-09,  1.446001583923822e-10, -4.130200430099301e-12,  1.033322952630165e-13,
 -2.318106528911510e-15,  4.741663161941820e-17, -8.954842394820934e-19,  1.576565641329774e-20, -2.606898845303108e-22,  5.600274319098798e-06, -6.807130314852424e-07,
  4.489387594457625e-08, -2.108698939775192e-09,  7.863096904658696e-11, -2.466479801040016e-12,  6.744939266206405e-14, -1.647212190757188e-15,  3.654921625163298e-17,
 -7.463900147713038e-19,  1.416931231259084e-20, -2.519750013259822e-22,  1.858038967587291e-06, -2.544442852976948e-07,  1.872769637609477e-08, -9.742054898902282e-10,
  3.998279706196380e-11, -1.373275571467823e-12,  4.093989720626489e-14, -1.085788849880837e-15,  2.607563830726019e-17, -5.746107951114348e-19,  1.173883837582501e-20,
 -2.240827070212512e-22,  5.905273608277192e-07, -9.050725921000386e-08,  7.398537344776734e-09, -4.245836967312356e-10,  1.911615570831178e-11, -7.168597945932275e-13,
  2.323747716257928e-14, -6.677112334921900e-16,  1.731762591688916e-17, -4.109480675165764e-19,  9.017031866135114e-21, -1.844234241990116e-22,  1.807067839846542e-07,
 -3.080588138420832e-08,  2.783905580387772e-09, -1.755818772130272e-10,  8.644245005515592e-12, -3.529171607181072e-13,  1.240735779775686e-14, -3.853541335719979e-16,
  1.077018529821441e-17, -2.746588678073393e-19,  6.460341765796066e-21, -1.413105398976305e-22,  5.354974055649942e-08, -1.009451142082107e-08,  1.003958528325057e-09,
 -6.933180627732445e-11,  3.720442275277817e-12, -1.648977055458826e-13,  6.271235792607710e-15, -2.100322888249843e-16,  6.311838334344137e-18, -1.726232791937976e-19,
  4.344053439109864e-21, -1.014301083918439e-22,  1.546685165178029e-08, -3.205937955176934e-09,  3.493719134858587e-10, -2.632026208635799e-11,  1.534492868244022e-12,
 -7.362169058088519e-14,  3.020895621364559e-15, -1.088350067500927e-16,  3.508838832635149e-18, -1.026965449696582e-19,  2.759363746446537e-21, -6.864269232813953e-23,
  4.385873205305204e-09, -9.941697980937323e-10,  1.181974864876354e-10, -9.677923860400096e-12,  6.110047450114612e-13, -3.163891293408358e-14,  1.396903013962354e-15,
 -5.400180336232904e-17,  1.863402814399686e-18, -5.823498259330605e-20,  1.667162830087708e-21, -4.409594789924252e-23,  1.230884899801191e-09, -3.034863992865653e-10,
  3.919330011757722e-11, -3.474703524581573e-12,  2.367572315009865e-13, -1.319118819801402e-14,  6.249061664582669e-16, -2.585359493824982e-17,  9.524598723363465e-19,
 -3.170950248922834e-20,  9.650580169772270e-22, -2.708178379274148e-23,  3.449356897596571e-10, -9.201479827343393e-11,  1.285113587068789e-11, -1.228838252908918e-12,
  9.004953969749440e-14, -5.381075547219494e-15,  2.727025735518190e-16, -1.204049051393217e-17,  4.723346782465938e-19, -1.670967931876105e-20,  5.393380202353122e-22,
 -1.602090926876463e-23,  9.745726208850965e-11, -2.797724127164121e-11,  4.206699803697329e-12, -4.321090035554763e-13,  3.393003311901298e-14, -2.167206488564482e-15,
  1.171190303539411e-16, -5.502106815559549e-18,  2.291817188601160e-19, -8.592055326519780e-21,  2.933541586958519e-22, -9.201014487355158e-24,  2.805127688121081e-11,
 -8.619124240159212e-12,  1.388767130103088e-12, -1.525977399044158e-13,  1.278947737432119e-14, -8.700003367953494e-16,  4.996535809954545e-17, -2.489495206579081e-18,
  1.097663627564930e-19, -4.348160770450548e-21,  1.565939341191510e-22, -5.171915787408049e-24,  8.315833698618788e-12, -2.719859855818892e-12,  4.673434989973589e-13,
 -5.468758540687873e-14,  4.871981265345805e-15, -3.515835432083091e-16,  2.137945907132852e-17, -1.125780660356813e-18,  5.236736663801047e-20, -2.184832231610576e-21,
  8.274021320999848e-23, -2.868980676038753e-24,  2.567791182572164e-12, -8.889825589044432e-13,  1.620692772676949e-13, -2.010184800111251e-14,  1.895116088948649e-15,
 -1.444734723727222e-16,  9.264801371164592e-18, -5.136254256310574e-19,  2.511363396212797e-20, -1.099654993879204e-21,  4.364233935633664e-23, -1.583531835712984e-24,
  8.351319142008999e-13, -3.042920955019710e-13,  5.854606250505511e-14, -7.658295225147967e-15,  7.604028834588978e-16, -6.096095866167748e-17,  4.104801825037718e-18,
 -2.385863537792508e-19,  1.221304544664593e-20, -5.590914274842757e-22,  2.316688496995956e-23, -8.764506939850173e-25,  2.890721337908475e-13, -1.102041849566282e-13,
  2.225176491344254e-14, -3.053311016020766e-15,  3.176657886500360e-16, -2.665036564563078e-17,  1.875380655075517e-18, -1.137670390905347e-19,  6.070320183468726e-21,
 -2.893005027914712e-22,  1.246506318085733e-23, -4.897559882846597e-25,  1.074112747943857e-13, -4.258914121880593e-14,  8.971347544592703e-15, -1.283985372468655e-15,
  1.392079434542477e-16, -1.215701304156058e-17,  8.895030721711382e-19, -5.604204986777486e-20,  3.102159767921134e-21, -1.532097319044829e-22,  6.833786656970776e-24,
 -2.776533171609650e-25,  4.305964243325606e-14, -1.764934667905516e-14,  3.854667319065699e-15, -5.719514904852121e-16,  6.424289812161315e-17, -5.807109508597799e-18,
  4.393781826389535e-19, -2.859868680344029e-20,  1.633904563081004e-21, -8.321066290903934e-23,  3.823804974849556e-24, -1.599084072313076e-25,  1.858623713632696e-14,
 -7.826518970455921e-15,  1.760816244987720e-15, -2.691457173906673e-16,  3.112579479043930e-17, -2.894762097651497e-18,  2.251724811689884e-19, -1.505596062456010e-20,
  8.829570723948742e-22, -4.612267992746433e-23,  2.172375430218403e-24, -9.304155765126873e-26,  8.489859112573560e-15, -3.649823442761695e-15,  8.402052180291390e-16,
 -1.314203155330906e-16,  1.554640749243935e-17, -1.478169876059987e-18,  1.174828929203827e-19, -8.021511647379386e-21,  4.800846808773455e-22, -2.557820789786789e-23,
  1.228063467131293e-24, -5.358347302426025e-26,  3.869307899940437e-15, -1.687516601619120e-15,  3.947504983048148e-16, -6.274787385767962e-17,  7.541435115602620e-18,
 -7.282437860999571e-19,  5.875979292085516e-20, -4.071318480327978e-21,  2.471669781943026e-22, -1.335241562939632e-23,  6.497631588804046e-25, -2.872271675343653e-26,
  1.377545592831397e-15, -6.056152519626878e-16,  1.429428585906976e-16, -2.292746121915447e-17,  2.780148446187665e-18, -2.708072253051869e-19,  2.203616198621528e-20,
 -1.539440345651444e-21,  9.420852721991798e-23, -5.129002775925148e-24,  2.514808854638387e-25, -1.119821852243277e-26,  6.915335313021571e-02, -1.988869113438228e-04,
  5.952925354931306e-07, -1.840828477233315e-09,  5.830462624678533e-12, -1.877159988154593e-14,  6.102873593407630e-17, -1.995047813561594e-19,  6.533307050773358e-22,
 -2.140209916846288e-24,  6.997641727611830e-27, -2.284536822988785e-29,  6.409993966025469e-02, -2.347394277972238e-04,  1.031530357739003e-06, -4.707270950036186e-09,
  2.121376021912384e-11, -9.347204003725265e-14,  4.030042222946437e-16, -1.705102356817411e-18,  7.098005488141248e-21, -2.913436834651674e-23,  1.181009383663854e-25,
 -4.734330405670704e-28,  5.508017816017909e-02, -2.884503970001218e-04,  1.812652730993466e-06, -1.085393422497580e-08,  6.143149859218245e-11, -3.327954540314669e-13,
  1.741596172828756e-15, -8.857779812360471e-18,  4.396811867644752e-20, -2.136734773815740e-22,  1.019122001160069e-24, -4.779808678426850e-27,  4.388593742489456e-02,
 -3.337934392684737e-04,  2.755432611955921e-06, -2.040249629651258e-08,  1.398550584965507e-10, -9.058246654598662e-13,  5.608529474193739e-15, -3.345324229212091e-17,
  1.932979085090657e-19, -1.086530794708464e-21,  5.960849154606447e-24, -3.200015337132109e-26,  3.243388150642167e-02, -3.495449102188074e-04,  3.612846733805796e-06,
 -3.233714716271585e-08,  2.637375171639018e-10, -2.007320545415945e-12,  1.446001769874961e-14, -9.953834632762380e-17,  6.593039307566482e-19, -4.223874776837462e-21,
  2.627947450845473e-23, -1.592868775565388e-25,  2.224449872420138e-02, -3.283540254635840e-04,  4.146899011925647e-06, -4.426058106423463e-08,  4.238485196667348e-10,
 -3.742820275104101e-12,  3.099431775058527e-14, -2.434469207798665e-16,  1.828555778963299e-18, -1.321424525970494e-20,  9.231114767710424e-23, -6.256770400745328e-25,
  1.416651654759024e-02, -2.772500419129417e-04,  4.217858327370878e-06, -5.310468475340511e-08,  5.908649130425458e-10, -5.994970631069354e-12,  5.655241526141414e-14,
 -5.025085742786072e-16,  4.245251272466393e-18, -3.433545637397181e-20,  2.672916406551384e-22, -2.011175871163206e-24,  8.384025327546327e-03, -2.114555029889846e-04,
  3.835451425685688e-06, -5.644186086112380e-08,  7.234776738438137e-10, -8.368787570922691e-12,  8.928303059893524e-14, -8.913977805148781e-16,  8.415355785819137e-18,
 -7.570472304959942e-20,  6.528374982403130e-22, -5.421705522056203e-24,  4.615261294447594e-03, -1.464396146288107e-04,  3.139524574614830e-06, -5.357028150293679e-08,
  7.854937339089478e-10, -1.029278370313283e-11,  1.234518129843331e-13, -1.377148105687337e-15,  1.445161473765217e-17, -1.438711447844540e-19,  1.367657540388743e-21,
 -1.247756829410213e-23,  2.365815266845036e-03, -9.253617501023417e-05,  2.326380220793461e-06, -4.570609118317112e-08,  7.620046206289524e-10, -1.124946192495407e-11,
  1.509276048177488e-13, -1.872339065751680e-15,  2.174283393031555e-17, -2.385231103282808e-19,  2.489318199968510e-21, -2.485092100406597e-23,  1.130796796929668e-03,
 -5.359302963118586e-05,  1.568224496783858e-06, -3.525558649300812e-08,  6.647683914785967e-10, -1.100443469844814e-11,  1.644320129344182e-13, -2.259284908540538e-15,
  2.892235395051843e-17, -3.483532634422176e-19,  3.977382233584264e-21, -4.330174586941651e-23,  5.047655926682087e-04, -2.856460742758845e-05,  9.660693048215186e-07,
 -2.471203636311733e-08,  5.245034968919710e-10, -9.694857215934607e-12,  1.607220165150615e-13, -2.437143620892962e-15,  3.427825343721487e-17, -4.518497879927349e-19,
  5.626994224229004e-21, -6.661279246589982e-23,  2.108125729030785e-04, -1.406556653750692e-05,  5.461903151964451e-07, -1.581557894361755e-08,  3.762266862768137e-10,
 -7.735537491885484e-12,  1.417902014169545e-13, -2.365332803304110e-15,  3.644267146983348e-17, -5.242623226791317e-19,  7.101754192651000e-21, -9.117903005567737e-23,
  8.255420173697093e-05, -6.423097723528610e-06,  2.846026497544694e-07, -9.284252157473349e-09,  2.465537396917392e-10, -5.619435278544472e-12,  1.135300733343093e-13,
 -2.077524025434607e-15,  3.496837827317219e-17, -5.476119212436045e-19,  8.049573202777837e-21, -1.118255180317252e-22,  3.038818812142336e-05, -2.730581956712537e-06,
  1.372541295507571e-07, -5.021830528046521e-09,  1.483269804843193e-10, -3.735452699269037e-12,  8.294096603574041e-14, -1.660514464468766e-15,  3.045875015607187e-17,
 -5.180349050005766e-19,  8.244845218531218e-21, -1.236715011632157e-22,  1.054518456536853e-05, -1.084969770667526e-06,  6.153007480203529e-08, -2.514356017172051e-09,
  8.231238059321901e-11, -2.283584622279513e-12,  5.557452612536278e-14, -1.214266307826780e-15,  2.421732384344657e-17, -4.463601741240890e-19,  7.676148438291337e-21,
 -1.240790363764942e-22,  3.461349772954783e-06, -4.046387622079987e-07,  2.575734411014190e-08, -1.170873332266212e-09,  4.234371117426510e-11, -1.290390573190559e-12,
  3.433188446347699e-14, -8.167391772455765e-16,  1.767241494747102e-17, -3.522762910049175e-19,  6.533387393948056e-21, -1.135953580541259e-22,  1.078848345404684e-06,
 -1.422949846512087e-07,  1.011751087519648e-08, -5.096759168017795e-10,  2.029690947686279e-11, -6.775489922973659e-13,  1.965902239056869e-14, -5.080627628630914e-16,
  1.190214058065531e-17, -2.560901047074358e-19,  5.112609198114592e-21, -9.544764827597881e-23,  3.207249000310959e-07, -4.741966674842653e-08,  3.748717097290062e-09,
 -2.085045120194606e-10,  9.115150707738637e-12, -3.324159226916546e-13,  1.049301731624867e-14, -2.939481065579585e-16,  7.440290445724235e-18, -1.724686775252338e-19,
  3.699749589873320e-21, -7.403683947235936e-23,  9.140683942672293e-08, -1.505837765601811e-08,  1.317692738082608e-09, -8.063103143634606e-11,  3.857828394256555e-12,
 -1.532891937332956e-13,  5.251582411886786e-15, -1.591211784478745e-16,  4.342913906964432e-18, -1.082510296475634e-19,  2.490743256270883e-21, -5.333527573385448e-23,
  2.512055439098146e-08, -4.584807114115408e-09,  4.421820431033937e-10, -2.966283122839899e-11,  1.548579179597382e-12, -6.686449541769851e-14,  2.480228822657755e-15,
 -8.110396732482101e-17,  2.382006631901985e-18, -6.372248485238814e-20,  1.569775152808231e-21, -3.590712358129859e-23,  6.701333704226349e-09, -1.347613913775139e-09,
  1.426462081776748e-10, -1.045372231695527e-11,  5.936788560968260e-13, -2.778008797255412e-14,  1.112971072414758e-15, -3.918940176862458e-17,  1.235966155587121e-18,
 -3.541597525566237e-20,  9.323530684700814e-22, -2.274073975438948e-23,  1.748347782867563e-09, -3.853277020174658e-10,  4.457856438010944e-11, -3.556320840067235e-12,
  2.190260610274755e-13, -1.107620574321325e-14,  4.780735377241665e-16, -1.808408293968750e-17,  6.111121403351613e-19, -1.871803679296847e-20,  5.255655181828904e-22,
 -1.364320372694252e-23,  4.498659699417184e-10, -1.080945114438673e-10,  1.361067680190532e-11, -1.177750247301346e-12,  7.841034515305285e-14, -4.272917788412582e-15,
  1.981648654710626e-16, -8.032892386515196e-18,  2.901853981602520e-19, -9.480016366089516e-21,  2.833049373898333e-22, -7.811571419298784e-24,  1.152387500082528e-10,
 -3.003055478161745e-11,  4.097966103719151e-12, -3.831987793107408e-13,  2.748641644837106e-14, -1.609158953274823e-15,  7.995985811983266e-17, -3.464282788538389e-18,
  1.334487830260186e-19, -4.638910364263012e-21,  1.472176740525460e-22, -4.302264358567221e-24,  2.969366120349033e-11, -8.347975397363231e-12,  1.229165202508081e-12,
 -1.237256878630608e-13,  9.527821972113211e-15, -5.972955540940961e-16,  3.170401779297538e-17, -1.463900390947750e-18,  5.997032410992435e-20, -2.212521784263451e-21,
  7.438074347897575e-23, -2.298370958372563e-24,  7.783324614236589e-12, -2.348037478241488e-12,  3.713447181477463e-13, -4.007178578889555e-14,  3.300462106716339e-15,
 -2.207810151127761e-16,  1.247695151604975e-17, -6.120818815744345e-19,  2.658718581677822e-20, -1.038113889841053e-21,  3.686960617100652e-23, -1.201472976976447e-24,
  2.100534606116399e-12, -6.762499006706104e-13,  1.143257389905941e-13, -1.316801379937313e-14,  1.155305981589393e-15, -8.215289579905254e-17,  4.925270769531052e-18,
 -2.558299978190477e-19,  1.174454272953555e-20, -4.838079039721002e-22,  1.809846718835797e-23, -6.201729582097410e-25,  5.910442041712195e-13, -2.019216328122679e-13,
  3.630684776340106e-14, -4.442703976706485e-15,  4.133891657398115e-16, -3.111880053500075e-17,  1.971419550529109e-18, -1.080157449177416e-19,  5.221898083512543e-21,
 -2.261649567887028e-22,  8.881575729343785e-24, -3.189961834215511e-25,  1.756118717986127e-13, -6.329590991205770e-14,  1.203984308708471e-14, -1.557316242328749e-15,
  1.529521681768479e-16, -1.213361148526905e-17,  8.087535299619695e-19, -4.654896426699979e-20,  2.360355334911002e-21, -1.070698461014698e-22,  4.397625738465415e-24,
 -1.649609733887351e-25,  5.577207254806918e-14, -2.108109127464548e-14,  4.217956968476304e-15, -5.735910784351024e-16,  5.915668456935612e-17, -4.921088336921848e-18,
  3.434760353433979e-19, -2.067256675413967e-20,  1.094657523450575e-21, -5.178662804302370e-23,  2.215505995999955e-24, -8.645268016010904e-26,  1.913332819377684e-14,
 -7.537728940580268e-15,  1.576828641786353e-15, -2.241298176455991e-16,  2.413755254403600e-17, -2.094285315927893e-18,  1.522751195218371e-19, -9.535856891067113e-21,
  5.247629606317112e-22, -2.577060116396729e-23,  1.143197583845191e-24, -4.620288787559598e-26,  7.140805498635656e-15, -2.913524579817744e-15,  6.331617268095486e-16,
 -9.348389569137909e-17,  1.044970013905923e-17, -9.401606644530691e-19,  7.081233726519731e-20, -4.588911435121771e-21,  2.610638120865769e-22, -1.324087269412649e-23,
  6.060521668229504e-25, -2.524778201807773e-26,  2.899322944523086e-15, -1.217234472336508e-15,  2.729555882192925e-16, -4.158541629141704e-17,  4.793810623885653e-18,
 -4.444465560665319e-19,  3.446751283292347e-20, -2.297909573759600e-21,  1.343801076175759e-22, -7.000366643581217e-24,  3.288445000459278e-25, -1.404825271585393e-26,
  1.261119257385984e-15, -5.412177701452834e-16,  1.243508303538669e-16, -1.941279359428841e-17,  2.292103890988230e-18, -2.175349674964988e-19,  1.725850698820093e-20,
 -1.176338512912620e-21,  7.028534509876554e-23, -3.738614014212061e-24,  1.792160752077559e-25, -7.807748264140465e-27,  5.549774232808499e-16, -2.418359602566079e-16,
  5.651753957013253e-17, -8.975218575736373e-18,  1.077685815977775e-18, -1.039720447672984e-19,  8.381699757083307e-21, -5.802426080143941e-22,  3.519640179843072e-23,
 -1.899814997605953e-24,  9.237624374751539e-26, -4.080329502207827e-27,  1.936895749305639e-16, -8.512282681631241e-17,  2.008358306429621e-17, -3.220043670345600e-18,
  3.903033031064246e-19, -3.800367310538557e-20,  3.091259614898009e-21, -2.158737691657595e-22,  1.320590119119241e-23, -7.187119996039770e-25,  3.522689284939241e-26,
 -1.568084019325092e-27,  6.836719246436342e-02, -1.942113729660073e-04,  5.737501816186049e-07, -1.750466807423430e-09,  5.469236961048917e-12, -1.737165068992162e-14,
  5.572408545931882e-17, -1.797788430301456e-19,  5.810884367799552e-22, -1.879401508940166e-24,  6.066682105623604e-27, -1.956185513726535e-29,  6.317713664516815e-02,
 -2.267075025401397e-04,  9.770195947950419e-07, -4.382296578335900e-09,  1.943730191016790e-11, -8.434812421541680e-14,  3.582898594120919e-16, -1.493875049808861e-18,
  6.129412516573741e-21, -2.480172575415227e-23,  9.912506198022819e-26, -3.918376332385062e-28,  5.395457705773609e-02, -2.744539461289879e-04,  1.688090431945142e-06,
 -9.922088032752209e-09,  5.517427565590661e-11, -2.938212073841412e-13,  1.512173452793616e-15, -7.566401756355503e-18,  3.696166425318991e-20, -1.768206810800189e-22,
  8.303885518527966e-25, -3.835575664220050e-27,  4.259335194694859e-02, -3.126925884887984e-04,  2.523453747270453e-06, -1.830274013151777e-08,  1.230122050681718e-10,
 -7.817958450272851e-13,  4.752868654586683e-15, -2.785015120770082e-17,  1.581558124517922e-19, -8.740300972078456e-22,  4.715801589651283e-24, -2.490480556725443e-26,
  3.109114719142050e-02, -3.221255159658810e-04,  3.248853527328388e-06, -2.842056875641541e-08,  2.268475077442521e-10, -1.691474536931272e-12,  1.194682331993858e-14,
 -8.068364622506974e-17,  5.245907832372398e-19, -3.300499442871190e-21,  2.017375896343231e-23, -1.201710675592840e-25,  2.099422477689155e-02, -2.971934920068235e-04,
  3.654116097684891e-06, -3.803964344867612e-08,  3.559110082644721e-10, -3.074558108553355e-12,  2.493026669738385e-14, -1.918824504991617e-16,  1.413168841938454e-18,
 -1.001869502443292e-20,  6.869157623092481e-23, -4.571457116559190e-25,  1.312118161118711e-02, -2.459041408266606e-04,  3.633594901833347e-06, -4.454081873385846e-08,
  4.834731347488942e-10, -4.792277144966347e-12,  4.421199119609349e-14, -3.845356975475027e-16,  3.182052316002371e-18, -2.522422239039673e-20,  1.925559830062796e-22,
 -1.421405180940146e-24,  7.595542905332054e-03, -1.832963191432085e-04,  3.222434747660580e-06, -4.609676822496041e-08,  5.756553604880173e-10, -6.497423527985766e-12,
  6.771765807392349e-14, -6.611046545596673e-16,  6.107703102989816e-18, -5.380534093258545e-20,  4.546281362732620e-22, -3.701339803056167e-24,  4.075946133009619e-03,
 -1.236957978691432e-04,  2.565783132453728e-06, -4.250047405742017e-08,  6.063941803876774e-10, -7.744838137224601e-12,  9.065684183870703e-14, -9.879956709329056e-16,
  1.013758235631429e-17, -9.875357666646836e-20,  9.191652180372891e-22, -8.215388516905699e-24,  2.029690562505298e-03, -7.592766397014176e-05,  1.844226936432194e-06,
 -3.513362699210698e-08,  5.693665452608660e-10, -8.184979877146641e-12,  1.070775604838403e-13, -1.296693038226728e-15,  1.471267287276778e-17, -1.578230912049871e-19,
  1.611695472668146e-21, -1.575333225006217e-23,  9.390716971016164e-04, -4.257411810429947e-05,  1.202352315906699e-06, -2.618534756366135e-08,  4.795143712757551e-10,
 -7.723178418742326e-12,  1.124430302052037e-13, -1.507092498209091e-15,  1.883860101705794e-17, -2.217400902928657e-19,  2.475986266162206e-21, -2.637945457962269e-23,
  4.042697227435177e-04, -2.189304708650291e-05,  7.140990701599653e-07, -1.768272595079806e-08,  3.642342363858030e-10, -6.546067189767881e-12,  1.056726276954557e-13,
 -1.562217905422083e-15,  2.144347617438236e-17, -2.761009161274658e-19,  3.361100431698196e-21, -3.892178726725877e-23,  1.622177243161949e-04, -1.036351780418417e-05,
  3.879583257090592e-07, -1.086909621649217e-08,  2.507946076216822e-10, -5.011204943139006e-12,  8.939956084333746e-14, -1.453312040271775e-15,  2.184297937770158e-17,
 -3.068182497788305e-19,  4.061411505784167e-21, -5.099148320455157e-23,  6.079436735001678e-05, -4.532527428036720e-06,  1.935824739809680e-07, -6.108175093704143e-09,
  1.572840032328353e-10, -3.482527121330219e-12,  6.845443810995416e-14, -1.220322438124187e-15,  2.003133957772341e-17, -3.062105720484269e-19,  4.397358689432091e-21,
 -5.972490129857011e-23,  2.133053716708544e-05, -1.838298197622351e-06,  8.907763380258975e-08, -3.152143087060491e-09,  9.026131296272230e-11, -2.207858335168611e-12,
  4.768721848925861e-14, -9.298930254599728e-16,  1.663159890174507e-17, -2.760747821032236e-19,  4.292032131529533e-21, -6.293544035639008e-23,  7.026257297414704e-06,
 -6.940811094741211e-07,  3.795920256809171e-08, -1.500417881870565e-09,  4.762112823241125e-11, -1.283186287907923e-12,  3.037643453979363e-14, -6.464188730300650e-16,
  1.257016915806334e-17, -2.261169890511718e-19,  3.798356602323955e-21, -6.001971535208464e-23,  2.179924225575702e-06, -2.449693787833938e-07,  1.504644802341785e-08,
 -6.618274359411442e-10,  2.320958798352452e-11, -6.870770255906234e-13,  1.778376813801634e-14, -4.120928773404081e-16,  8.694936143094875e-18, -1.691728323433686e-19,
  3.065038167691639e-21, -5.210150388138590e-23,  6.394332819423486e-07, -8.118311447228713e-08,  5.574195906042527e-09, -2.718569851387724e-10,  1.050263979297609e-11,
 -3.406908837359059e-13,  9.619433701565119e-15, -2.422170327142857e-16,  5.534501795751803e-18, -1.162590458368903e-19,  2.267927561785740e-21, -4.140444816513862e-23,
  1.781105346049201e-07, -2.538735589792456e-08,  1.940022204121553e-09, -1.045446706790346e-10,  4.436448551730357e-12, -1.573003365290875e-13,  4.834109696101163e-15,
 -1.319990632927383e-16,  3.260091662336865e-18, -7.380692967935589e-20,  1.547653568971455e-21, -3.029731940893307e-23,  4.735074328121922e-08, -7.532819112727834e-09,
  6.379362320288888e-10, -3.785645264840221e-11,  1.759598314439900e-12, -6.802431029980308e-14,  2.270325332234177e-15, -6.709139028559593e-17,  1.787730680454700e-18,
 -4.354433732077009e-20,  9.798671730762496e-22, -2.053651692050952e-23,  1.208496854802814e-08, -2.133861373324653e-09,  1.994492756383390e-10, -1.299023882452387e-11,
  6.594827420926083e-13, -2.772904532203355e-14,  1.002839459852263e-15, -3.200765248241308e-17,  9.184381736850071e-19, -2.402579587364435e-20,  5.792282048972789e-22,
 -1.297620246572379e-23,  2.980990269242297e-09, -5.811102160521874e-10,  5.970674074717869e-11, -4.253933912933887e-12,  2.352088315616980e-13, -1.072936950071317e-14,
  4.195257487976445e-16, -1.443185591614140e-17,  4.450828707564851e-19, -1.248188566335136e-20,  3.218425119677036e-22, -7.694254270821415e-24,  7.161469131500666e-10,
 -1.533302531449742e-10,  1.724869478990489e-11, -1.339842997646445e-12,  8.045086051740644e-14, -3.971137448382816e-15,  1.674809373272524e-16, -6.196246135581988e-18,
  2.049709676698259e-19, -6.150594288158857e-21,  1.693119988383966e-22, -4.312060387327575e-24,  1.690254615935933e-10, -3.954446947141054e-11,  4.851001980187472e-12,
 -4.094240744682429e-13,  2.661677945779675e-14, -1.417834575879721e-15,  6.433755674113589e-17, -2.554048432904791e-18,  9.042801362539823e-20, -2.897545706564360e-21,
  8.499015406856031e-23, -2.301619472298290e-24,  3.957974618240776e-11, -1.006685795024469e-11,  1.341142095621729e-12, -1.225516809837257e-13,  8.598675793421756e-15,
 -4.928753801402772e-16,  2.400002879665853e-17, -1.019771221905838e-18,  3.855454849749372e-20, -1.316276444423425e-21,  4.105243942251334e-23, -1.179757237527516e-24,
  9.296572253186875e-12, -2.557306090613914e-12,  3.684302821410891e-13, -3.631463534444102e-14,  2.740691305408504e-15, -1.685220341075032e-16,  8.780464537086313e-18,
 -3.982564434126693e-19,  1.603713370710197e-20, -5.819537003985200e-22,  1.925421147380274e-23, -5.858645096188581e-25,  2.216909595210150e-12, -6.560650894500197e-13,
  1.017609690001064e-13, -1.077619778819439e-14,  8.716332021396858e-16, -5.730069446924556e-17,  3.184479126335680e-18, -1.537257946322957e-19,  6.574693171290250e-21,
 -2.529045661848581e-22,  8.853534864070331e-24, -2.845266171803347e-25,  5.438013732494870e-13, -1.721897218098367e-13,  2.861947624615696e-14, -3.242291436807331e-15,
  2.799608119652446e-16, -1.960427801206066e-17,  1.158074652508187e-18, -5.930273558386011e-20,  2.685353516945759e-21, -1.091674076898802e-22,  4.031969024514372e-24,
 -1.364716756853158e-25,  1.391366893241069e-13, -4.687257418222736e-14,  8.306480035062243e-15, -1.002096293831714e-15,  9.197261586527222e-17, -6.832403912599189e-18,
  4.273569652495644e-19, -2.312923014996378e-20,  1.104985320714657e-21, -4.731395416095887e-23,  1.837647251340920e-24, -6.530375319213051e-26,  3.766772830480827e-14,
 -1.342152474859185e-14,  2.522388648134921e-15, -3.224246456417912e-16,  3.130585232871761e-17, -2.456121210483416e-18,  1.619706412998727e-19, -9.226898716389154e-21,
  4.632410353907460e-22, -2.081285589435132e-23,  8.469570017500840e-25, -3.148819616287522e-26,  1.094264051211965e-14, -4.098760308942824e-15,  8.122148998684977e-16,
 -1.094056862947984e-16,  1.117965227385846e-17, -9.217326827611594e-19,  6.378130489565316e-20, -3.806932923805551e-21,  1.999719073574028e-22, -9.387264277904156e-24,
  3.986029321743166e-25, -1.544221081811652e-26,  3.454552011135427e-15, -1.351638340395386e-15,  2.806734544863917e-16, -3.960466030033275e-17,  4.235005032527584e-18,
 -3.649288901509548e-19,  2.635804411830875e-20, -1.640040159010260e-21,  8.969416123271157e-23, -4.378485651617860e-24,  1.931111977566411e-25, -7.761265844063824e-27,
  1.196256766422397e-15, -4.857076581142370e-16,  1.049946731917207e-16, -1.542059253364571e-17,  1.714889051795479e-18, -1.535217456791354e-19,  1.150754751328559e-20,
 -7.422658827462497e-22,  4.203786850361733e-23, -2.122857029842268e-24,  9.675818967591185e-26, -4.014578932341676e-27,  4.554267660985434e-16, -1.905930187498870e-16,
  4.258935112916619e-17, -6.465933652142452e-18,  7.428251503972565e-19, -6.864102181496989e-20,  5.306130108574855e-21, -3.526549468800751e-22,  2.056106321670104e-23,
 -1.067992070864542e-24,  5.002834222285264e-26, -2.131421669636097e-27,  1.881182959465739e-16, -8.058227153198085e-17,  1.847663413928763e-17, -2.878516152400450e-18,
  3.391873217001186e-19, -3.212793499802461e-20,  2.544080206988255e-21, -1.730849803295449e-22,  1.032325385576983e-23, -5.481656552688499e-25,  2.623320485275229e-26,
 -1.141033385486997e-27,  7.976795956413047e-17, -3.472810306951962e-17,  8.107837500357055e-18, -1.286252810843498e-18,  1.542909273929588e-19, -1.487106499303476e-20,
  1.197694805144955e-21, -8.283689385233298e-23,  5.020234807917864e-24, -2.707446348892791e-25,  1.315353637368300e-26, -5.805274135322717e-28,  2.725729878721723e-17,
 -1.197468736091982e-17,  2.824103610825089e-18, -4.526057070268366e-19,  5.483790834356725e-20, -5.337372082846139e-21,  4.339742767555001e-22, -3.029413198875638e-23,
  1.852509242127610e-24, -1.007823500637711e-25,  4.937926885484944e-27, -2.197274159055528e-28,  6.759939600588663e-02, -1.897039322285222e-04,  5.532583921797473e-07,
 -1.665667490425401e-09,  5.134780589403361e-12, -1.609263799705532e-14,  5.094075856687517e-17, -1.622213454797790e-19,  5.175983738447380e-22, -1.653097156578307e-24,
  5.268764401405531e-27, -1.678313182695031e-29,  6.228561319261412e-02, -2.190965343141599e-04,  9.262438225714802e-07, -4.084342070909808e-09,  1.783305202607256e-11,
 -7.622974410761571e-14,  3.190783745886824e-16, -1.311286868380100e-18,  5.303954774402054e-21, -2.116093600821676e-23,  8.339981860348787e-26, -3.251478383413916e-28,
  5.288303725525813e-02, -2.614109096412296e-04,  1.574134380250155e-06, -9.084408841961850e-09,  4.964427912713671e-11, -2.599433626082198e-13,  1.315959938346890e-15,
 -6.479382537862559e-18,  3.115546904454834e-20, -1.467477421723574e-22,  6.786984974424061e-25, -3.087972386030471e-27,  4.138161156383352e-02, -2.933511800563273e-04,
  2.315133427781027e-06, -1.645368964932632e-08,  1.084566493180349e-10, -6.765405799726464e-13,  4.039435632384370e-15, -2.325823969683467e-17,  1.298377514211655e-19,
 -7.056071491946967e-22,  3.744954859884567e-24, -1.946017071445094e-26,  2.985255066350300e-02, -2.974396460328112e-04,  2.928516133632424e-06, -2.504680123464648e-08,
  1.957116212443136e-10, -1.430068027402640e-12,  9.905888835197207e-15, -6.565186753994879e-17,  4.191083967603850e-19, -2.590115152347645e-21,  1.555694116052226e-23,
 -9.109200753521638e-26,  1.986115641736341e-02, -2.696941291457606e-04,  3.229879151303490e-06, -3.280622642110442e-08,  2.999929818429819e-10, -2.535909425049182e-12,
  2.014000117345091e-14, -1.519384924268518e-16,  1.097462936835597e-18, -7.634728190128116e-21,  5.138850515599788e-23, -3.358675863827820e-25,  1.219249396467523e-02,
 -2.188487632855687e-04,  3.142532819848824e-06, -3.751782449951880e-08,  3.974224326591427e-10, -3.849675838674053e-12,  3.474396743620005e-14, -2.958668800896558e-16,
  2.398766289058086e-18, -1.864122981353997e-20,  1.395761087566218e-22, -1.011031611438689e-24,  6.910621947574310e-03, -1.595822398671310e-04,  2.720517895638326e-06,
 -3.784348451782473e-08,  4.605667211607027e-10, -5.073917199850194e-12,  5.167507609678437e-14, -4.934358129855823e-16,  4.462258230368232e-18, -3.850378428450260e-20,
  3.188472783887827e-22, -2.545379090636397e-24,  3.619203683911812e-03, -1.050556646133815e-04,  2.109238427259791e-06, -3.392791066967222e-08,  4.711906675755288e-10,
 -5.867430687010196e-12,  6.704691714319875e-14, -7.140305488943984e-16,  7.165493175986073e-18, -6.831666785120385e-20,  6.227314510323830e-22, -5.453925363863509e-24,
  1.753020688382893e-03, -6.271698650274500e-05,  1.472301245919874e-06, -2.720518039625112e-08,  4.286788534503371e-10, -6.002442648639936e-12,  7.658872301295818e-14,
 -9.055914960395206e-16,  1.004175986381330e-17, -1.053534465025849e-19,  1.052966048935972e-21, -1.007900302096993e-23,  7.861925502957639e-04, -3.409262152745550e-05,
  9.295027407669017e-07, -1.961541058642141e-08,  3.489421194530095e-10, -5.469553248616292e-12,  7.760824308368473e-14, -1.014926187596918e-15,  1.239027325376200e-17,
 -1.425518170381703e-19,  1.556990699595628e-21, -1.623647305872480e-23,  3.269070239808619e-04, -1.693907697553774e-05,  5.329612846065115e-07, -1.277813822660996e-08,
  2.554961050772075e-10, -4.465622955160768e-12,  7.021018944823652e-14, -1.012130727629842e-15,  1.356082710120609e-17, -1.705815758131237e-19,  2.030248730697952e-21,
 -2.300165854194350e-23,  1.262320743663668e-04, -7.720274662703235e-06,  2.786410345960626e-07, -7.554133272865755e-09,  1.690989422646185e-10, -3.284128995013738e-12,
  5.703242398534412e-14, -9.036312115766565e-16,  1.325088289574175e-17, -1.817638182067169e-19,  2.351480443890976e-21, -2.887416576076043e-23,  4.535144001542547e-05,
 -3.239045091005612e-06,  1.333454524426706e-07, -4.070004568941563e-09,  1.016299994913949e-10, -2.186303917485428e-12,  4.181741552623698e-14, -7.263032186848330e-16,
  1.162807042364968e-17, -1.735309263935145e-19,  2.434805698999230e-21, -3.233439690170246e-23,  1.519371955824843e-05, -1.255420788602201e-06,  5.863942832040921e-08,
 -2.006912832960800e-09,  5.571584188549431e-11, -1.323789642791508e-12,  2.781520413908421e-14, -5.283227493376024e-16,  9.214258676749943e-18, -1.492885561821698e-19,
  2.267262243998501e-21, -3.250152816189938e-23,  4.759253869219824e-06, -4.511952311789785e-07,  2.379218613328170e-08, -9.096018694740719e-10,  2.798810565038631e-11,
 -7.324832406707754e-13,  1.686688834244415e-14, -3.495876095175510e-16,  6.628331265002622e-18, -1.163685608976294e-19,  1.909453990813350e-21, -2.949552300698223e-23,
  1.398195081187434e-06, -1.509636035573090e-07,  8.944787333870475e-09, -3.806383477460281e-10,  1.294289419268184e-11, -3.721695646310450e-13,  9.370760772209045e-15,
 -2.115000326922884e-16,  4.351332233573128e-18, -8.263170596356512e-20,  1.462469329818338e-21, -2.430401640487079e-23,  3.866673555568687e-07, -4.722845962560682e-08,
  3.130411320795161e-09, -1.477714148292759e-10,  5.537180761962491e-12, -1.745162003595953e-13,  4.794424325843861e-15, -1.176094376514965e-16,  2.620822892802470e-18,
 -5.374340013852456e-20,  1.024332992130473e-21, -1.828590442827606e-23,  1.010893310979599e-07, -1.388222548812936e-08,  1.025002241811238e-09, -5.349811864038951e-11,
  2.203130993688661e-12, -7.592967863601005e-14,  2.271327018210781e-15, -6.044212545113194e-17,  1.456352106065396e-18, -3.219684721547025e-20,  6.598430472136537e-22,
 -1.263469132125465e-23,  2.510957887797823e-08, -3.854746832173341e-09,  3.157731260866566e-10, -1.816487640612548e-11,  8.199497922020072e-13, -3.083098920833978e-14,
  1.002162685113045e-15, -2.887683958996566e-17,  7.510463302052165e-19, -1.787231849011039e-20,  3.932471871242069e-22, -8.065168660937647e-24,  5.960235570364212e-09,
 -1.017372854060615e-09,  9.210328997249209e-11, -5.821281907070674e-12,  2.872664251917364e-13, -1.175765516956170e-14,  4.144459625848874e-16, -1.290697732465007e-17,
  3.617323285652340e-19, -9.250648462789699e-21,  2.182007342317264e-22, -4.786285737113195e-24,  1.361143375067724e-09, -2.570033649234667e-10,  2.561451470585630e-11,
 -1.773225453704695e-12,  9.540953378109077e-14, -4.240869805492352e-15,  1.617685212121925e-16, -5.434628905403322e-18,  1.638375227005079e-19, -4.495231621241187e-21,
  1.134899013698941e-22, -2.658551975373197e-24,  3.013974223207302e-10, -6.263433273086315e-11,  6.846360200776853e-12, -5.174946068180521e-13,  3.027739608640000e-14,
 -1.458033402300341e-15,  6.005617158523328e-17, -2.172147523746493e-18,  7.030897020488152e-20, -2.066088823630522e-21,  5.573913125582572e-23, -1.392221528221495e-24,
  6.529043944612235e-11, -1.485958488417310e-11,  1.774547590979487e-12, -1.459822957487573e-13,  9.261341449998903e-15, -4.819634485208973e-16,  2.138744252144881e-17,
 -8.310481373636476e-19,  2.882478877500130e-20, -9.055107676706890e-22,  2.605798196941394e-23, -6.928030958548382e-25,  1.397837366090919e-11, -3.466871282827547e-12,
  4.505529758885599e-13, -4.020349881306642e-14,  2.757434808433176e-15, -1.546562532924008e-16,  7.375530470198789e-18, -3.071838835140357e-19,  1.139253158908227e-20,
 -3.818127233857161e-22,  1.169737803688495e-23, -3.304196002987811e-25,  2.991974782549186e-12, -8.045746565855561e-13,  1.133254398221894e-13, -1.092962406179411e-14,
  8.078434444509818e-16, -4.869045037462660e-17,  2.488723823294996e-18, -1.108208185598854e-19,  4.384182605905380e-21, -1.563999573785047e-22,  5.090076682103387e-24,
 -1.524413835489529e-25,  6.485375801507903e-13, -1.881094747384585e-13,  2.859264487766164e-14, -2.969166757758907e-15,  2.356839307535905e-16, -1.521630341973794e-17,
  8.310934037369115e-19, -3.945575671618778e-20,  1.660591441450933e-21, -6.289582737310581e-23,  2.169192544698065e-24, -6.871541786871063e-26,  1.443873021966551e-13,
 -4.492873296463304e-14,  7.335935888390031e-15, -8.168472370501446e-16,  6.936728957139648e-17, -4.780282378624208e-18,  2.780676871533646e-19, -1.402981823532373e-20,
  6.262962081302479e-22, -2.511285613926860e-23,  9.152842196382445e-25, -3.058619296163563e-26,  3.352420088287733e-14, -1.112805504061861e-14,  1.942187757877263e-15,
 -2.308424947293861e-16,  2.088417612838334e-17, -1.530079320714037e-18,  9.443575707413635e-20, -5.045753988315380e-21,  2.380914193953773e-22, -1.007375006302140e-23,
  3.867771803752642e-25, -1.359299258319775e-26,  8.248129000371977e-15, -2.903402634733347e-15,  5.387597971504700e-16, -6.801389068416158e-17,  6.524587697491454e-18,
 -5.059642503128161e-19,  3.299373621741059e-20, -1.859312917280164e-21,  9.237913470223228e-23, -4.108934101589436e-24,  1.655930398130904e-25, -6.099090264051489e-27,
  2.185095652750737e-15, -8.106057258908538e-16,  1.589974961519812e-16, -2.120264856487362e-17,  2.145549162276238e-18, -1.752339064343643e-19,  1.201581955179789e-20,
 -7.109224808388212e-22,  3.702865238703680e-23, -1.724085864052052e-24,  7.263307525321940e-26, -2.792558640285721e-27,  6.326592779057276e-16, -2.457322451965779e-16,
  5.062894183245477e-17, -7.088898742393813e-18,  7.523391470506875e-19, -6.435778953649487e-20,  4.615803399335942e-21, -2.852568771965670e-22,  1.549873303778931e-23,
 -7.518050004949873e-25,  3.295586540450273e-26, -1.316735442658955e-27,  2.025646922648721e-16, -8.181797155926613e-17,  1.758674791975025e-17, -2.568518968021020e-18,
  2.840815708905697e-19, -2.529739964676798e-20,  1.886531133315562e-21, -1.210853260871078e-22,  6.824912849481190e-24, -3.430619943151560e-25,  1.556694261176796e-26,
 -6.431163705712780e-28,  7.206918115476743e-17, -3.005742002216668e-17,  6.691419951517226e-18, -1.012110177738071e-18,  1.158511427623924e-19, -1.066747080435923e-20,
  8.218050694706791e-22, -5.443813613495050e-23,  3.163801838233278e-24, -1.638282435887279e-25,  7.651363630505876e-27, -3.250428828487894e-28,  2.818673732042023e-17,
 -1.205006696669564e-17,  2.756883336497839e-18, -4.285586945494625e-19,  5.039036239872479e-20, -4.763024944695070e-21,  3.764009202667950e-22, -2.555800475603997e-23,
  1.521455492436788e-24, -8.064105425985069e-26,  3.852327785827208e-27, -1.672725497079408e-28,  1.149080334969361e-17, -4.997860892532490e-18,  1.165578201024904e-18,
 -1.847115827201628e-19,  2.213338295995240e-20, -2.131083163921516e-21,  1.714619338366905e-22, -1.184734702859443e-23,  7.173143086545966e-25, -3.864965415416686e-26,
  1.876032486220859e-27, -8.272658792808106e-29,  3.839317331365690e-18, -1.686044427199090e-18,  3.974641119143685e-19, -6.367183053155127e-20,  7.711164184525941e-21,
 -7.502075194290185e-22,  6.097283628067005e-23, -4.254545687800374e-24,  2.600645518444465e-25, -1.414279190453706e-26,  6.926740992159531e-28, -3.081103518281681e-29,
  6.684930776055870e-02, -1.853564445070769e-04,  5.337529111237611e-07, -1.586020907689854e-09,  4.824795138223894e-12, -1.492274809716690e-14,  4.662178024567423e-17,
 -1.465711072915236e-19,  4.617090403579361e-22, -1.456394070563048e-24,  4.583542301646310e-27, -1.442703429124338e-29,  6.142374324498007e-02, -2.118778947894256e-04,
  8.788946935732290e-07, -3.810806066540233e-09,  1.638215817017466e-11, -6.899395795697919e-14,  2.846284243367139e-16, -1.153132125982677e-18,  4.598916173906064e-21,
 -1.809419775322132e-23,  7.033490713572070e-26, -2.704919812190337e-28,  5.186190790786199e-02, -2.492407672430397e-04,  1.469721157142958e-06, -8.330035019783090e-09,
  4.474710920129991e-11, -2.304294389062589e-13,  1.147736550496243e-15, -5.561949185012899e-18,  2.633016851702618e-20, -1.221324896567205e-22,  5.563862302694671e-25,
 -2.494025390248659e-27,  4.024403883141354e-02, -2.755913847142008e-04,  2.127670950821144e-06, -1.482157559144513e-08,  9.584488302513007e-11, -5.869618776778289e-13,
  3.442750305987786e-15, -1.948254489802343e-17,  1.069380170531871e-19, -5.716197781954656e-22,  2.984934790873155e-24, -1.526490838606064e-26,  2.870781717008196e-02,
 -2.751626226386889e-04,  2.645839187606053e-06, -2.213190770306283e-08,  1.693462573038584e-10, -1.212952276933249e-12,  8.242192323274550e-15, -5.361962589511855e-17,
  3.361625601758283e-19, -2.041144902713246e-21,  1.204956935783624e-23, -6.936844873709678e-26,  1.883167501584623e-02, -2.453518875708573e-04,  2.863411344471670e-06,
 -2.838719983459360e-08,  2.537832782656904e-10, -2.099872766109379e-12,  1.633873709881459e-14, -1.208477576922966e-16,  8.563086960773431e-19, -5.846857888972833e-21,
  3.864318049078849e-23, -2.480962219214182e-25,  1.136467333191289e-02, -1.954068279339801e-04,  2.728070114833017e-06, -3.173237575548954e-08,  3.281387724792336e-10,
 -3.107141559501222e-12,  2.744066206249561e-14, -2.288475345551795e-16,  1.818307561858900e-18, -1.385586742478534e-20,  1.017810091049172e-22, -7.236164476994848e-25,
  6.313112383483359e-03, -1.395166065708094e-04,  2.307467806267225e-06, -3.122328222390416e-08,  3.704495425265985e-10, -3.984572199378322e-12,  3.966594018184453e-14,
 -3.705637307377514e-16,  3.281041146706964e-18, -2.773734179505700e-20,  2.251599253339514e-22, -1.762878396396618e-24,  3.230320174485555e-03, -8.969051546988888e-05,
  1.743730993771873e-06, -2.724657863391089e-08,  3.684387486073935e-10, -4.474420066385405e-12,  4.992620916206635e-14, -5.197108055703724e-16,  5.102073821686513e-18,
 -4.762006752265435e-20,  4.252000939225449e-22, -3.649783890325051e-24,  1.523795320532882e-03, -5.213633969571366e-05,  1.183332073593452e-06, -2.121484801266281e-08,
  3.251311948546879e-10, -4.435515002025302e-12,  5.521398790544458e-14, -6.376047179531343e-16,  6.911186911941390e-18, -7.093278031592586e-20,  6.939955310616892e-22,
 -6.506692158330018e-24,  6.633271430326099e-04, -2.751092817137814e-05,  7.243095849218789e-07, -1.481517684790508e-08,  2.560880681681348e-10, -3.907511716147156e-12,
  5.404789181835976e-14, -6.897984574265911e-16,  8.226193815890326e-18, -9.252840257439275e-20,  9.887379626676941e-22, -1.009379599547330e-23,  2.667968144657443e-04,
 -1.322547981009471e-05,  4.014761566755671e-07, -9.321966932865873e-09,  1.809698185689713e-10, -3.076777638770983e-12,  4.712382768809779e-14, -6.625528369397700e-16,
  8.666585377328046e-18, -1.065234274419203e-19,  1.239766083659257e-21, -1.374416986249487e-23,  9.929403118779852e-05, -5.812298026970461e-06,  2.022767265502811e-07,
 -5.307452588825739e-09,  1.152788637701596e-10, -2.176509522891703e-12,  3.679976226182353e-14, -5.683710745169461e-16,  8.133072745083855e-18, -1.089621906730471e-19,
  1.377875156880094e-21, -1.654946852667639e-23,  3.425451890730969e-05, -2.342998729397879e-06,  9.297833321463666e-08, -2.745429057900399e-09,  6.648789829755470e-11,
 -1.389840066200662e-12,  2.587059398191766e-14, -4.378337235564828e-16,  6.837628643647072e-18, -9.962855176693659e-20,  1.365949064202713e-21, -1.773849358672581e-23,
  1.097675294689991e-05, -8.692817184896490e-07,  3.913655834209904e-08, -1.295482828740372e-09,  3.487065955104737e-11, -8.048255262023692e-13,  1.645245938555443e-14,
 -3.044163240903357e-16,  5.177529592634928e-18, -8.188312486017771e-20,  1.214896889377862e-21, -1.702707282216546e-23,  3.275459473531212e-06, -2.978912745951457e-07,
  1.514347460204087e-08, -5.599367922074181e-10,  1.670280831957942e-11, -4.245719038274702e-13,  9.510147844623350e-15, -1.919832173156929e-16,  3.549315880933151e-18,
 -6.081738208077360e-20,  9.748189694465050e-22, -1.472076068123339e-23,  9.128420477706984e-07, -9.465074484987674e-08,  5.408705562276655e-09, -2.226417113390510e-10,
  7.339776152747221e-12, -2.049923204783854e-13,  5.020749816175559e-15, -1.103708245367311e-16,  2.214089137185085e-18, -4.103644873176435e-20,  7.094719007638704e-22,
 -1.152640638743616e-23,  2.384311460299299e-07, -2.800166810963913e-08,  1.791100941534215e-09, -8.181672570322019e-11,  2.973088894065696e-12, -9.102954761047477e-14,
  2.433027397017861e-15, -5.813823209023490e-17,  1.263402830774766e-18, -2.528915426881164e-20,  4.709031249212766e-22, -8.219264922130882e-24,  5.860961154951599e-08,
 -7.749550700899507e-09,  5.526350563925734e-10, -2.792774534012752e-11,  1.115830521252670e-12, -3.737285035219675e-14,  1.087995464820373e-15, -2.821126943766349e-17,
  6.630597862538775e-19, -1.431262540305177e-20,  2.866424450128291e-22, -5.367887385843686e-24,  1.362474593215096e-08, -2.017012251373541e-09,  1.597462499794612e-10,
 -8.904535037320328e-12,  3.902153684362290e-13, -1.426692937135064e-14,  4.515419335214990e-16, -1.268359128959786e-17,  3.219204536942744e-19, -7.482738595806290e-21,
  1.609578869402417e-22, -3.229753876820274e-24,  3.012506086196175e-09, -4.967185875609068e-10,  4.352942146488862e-11, -2.668569191381914e-12,  1.279520339031498e-13,
 -5.096013786999915e-15,  1.750196728570946e-16, -5.316767365575198e-18,  1.454976693688500e-19, -3.636503098968797e-21,  8.390193020867756e-23, -1.801587018385956e-24,
  6.377934762384194e-10, -1.165456901602535e-10,  1.126011944816589e-11, -7.569919671960729e-13,  3.961626673316759e-14, -1.715103906402705e-15,  6.379868831803519e-17,
 -2.092379293907674e-18,  6.163955171419601e-20, -1.654081049142632e-21,  4.087616006922785e-23, -9.379825473224892e-25,  1.303116280998958e-10, -2.626189557525880e-11,
  2.787284021370653e-12, -2.048828549892702e-13,  1.167382997547630e-14, -5.481612297351724e-16,  2.204128066173374e-17, -7.790215877127084e-19,  2.466338647265739e-20,
 -7.094766810943446e-22,  1.875131111195345e-23, -4.591762234533539e-25,  2.592877578304118e-11, -5.735474412821291e-12,  6.662717750512206e-13, -5.338739497433636e-14,
  3.303213308610013e-15, -1.678424460773263e-16,  7.279893526409330e-18, -2.767467869817746e-19,  9.399147772482371e-21, -2.893520232364701e-22,  8.165860987489059e-24,
 -2.130602376053809e-25,  5.077221419983544e-12, -1.226775223203190e-12,  1.553993818669949e-13, -1.353084399810588e-14,  9.065810830941178e-16, -4.972315569143124e-17,
  2.321062183534396e-18, -9.470491055264869e-20,  3.443678816653111e-21, -1.132405834099256e-22,  3.406332097916783e-24, -9.453594733173278e-26,  9.901908568945227e-13,
 -2.600595237046271e-13,  3.578176058294727e-14, -3.374131957363564e-15,  2.440754557595860e-16, -1.441047476779660e-17,  7.221355193279739e-19, -3.155101827305246e-20,
  1.225597899610221e-21, -4.295938179786728e-23,  1.374618550491875e-24, -4.050076498043397e-26,  1.949610915986472e-13, -5.537396021850952e-14,  8.241332071471841e-15,
 -8.385715799549205e-16,  6.527583962370060e-17, -4.136131402503946e-18,  2.218829482282042e-19, -1.035329196197716e-20,  4.285580128299894e-22, -1.597399027354777e-23,
  5.424796453753836e-25, -1.693076623128544e-26,  3.934418580465847e-14, -1.202066199661344e-14,  1.926569885177293e-15, -2.106864415903112e-16,  1.758374649471252e-17,
 -1.191697228406173e-18,  6.821827762143932e-20, -3.389272939326391e-21,  1.490695955274944e-22, -5.892445893710054e-24,  2.118200664504268e-25, -6.984999255476977e-27,
  8.273766060280406e-15, -2.703966842140450e-15,  4.644244063750430e-16, -5.434488607660250e-17,  4.843035299221583e-18, -3.497171481469301e-19,  2.128533439139931e-20,
 -1.122117527244148e-21,  5.226843369932010e-23, -2.184106246301043e-24,  8.285571497933071e-26, -2.878370651962893e-27,  1.845319967326726e-15, -6.412616520940178e-16,
  1.174084440110033e-16, -1.462853928925525e-17,  1.385614470443853e-18, -1.061435165461489e-19,  6.840455132500337e-21, -3.811308378694052e-22,  1.873023016781378e-23,
 -8.243594079714310e-25,  3.288589058195280e-26, -1.199430059997633e-27,  4.444487959521214e-16, -1.631957197058490e-16,  3.166575502263425e-17, -4.178008874928090e-18,
  4.184448847078740e-19, -3.383709089699184e-20,  2.298042565449679e-21, -1.347122322389719e-22,  6.954198994470053e-24, -3.210187103422792e-25,  1.341218395562787e-26,
 -5.115566013362977e-28,  1.176133814294709e-16, -4.532765436355001e-17,  9.261500727112317e-18, -1.286141605528173e-18,  1.354104901913033e-19, -1.149431979235429e-20,
  8.182569784673608e-22, -5.020572633085151e-23,  2.708935191375610e-24, -1.305265990616032e-25,  5.684855821074891e-27, -2.257259842435392e-28,  3.469309655379479e-17,
 -1.393498436669802e-17,  2.977314513657538e-18, -4.322414861960603e-19,  4.752906596933827e-20, -4.208669307078237e-21,  3.121535498068680e-22, -1.993025899442958e-23,
  1.117673854354636e-24, -5.590668002648776e-26,  2.524881747744674e-27, -1.038363280259382e-28,  1.149465196696705e-17, -4.776462712773534e-18,  1.059091402276254e-18,
 -1.595556967648051e-19,  1.819265178391597e-20, -1.668858169347835e-21,  1.280980614636375e-22, -8.455632131646631e-24,  4.897486908142131e-25, -2.527693229846990e-26,
  1.176778066632968e-27, -4.983869922279862e-29,  4.243524786148740e-18, -1.810282164944475e-18,  4.131944215707509e-19, -6.408067610974527e-20,  7.517392374680062e-21,
 -7.089799091498446e-22,  5.590661791207861e-23, -3.788185508287772e-24,  2.250531135953180e-25, -1.190508054839977e-26,  5.676460950309986e-28, -2.460290943758078e-29,
  1.659217969808920e-18, -7.209254105002532e-19,  1.679384382030043e-19, -2.658298568015577e-20,  3.181760290686201e-21, -3.060148139048183e-22,  2.459492876988861e-23,
 -1.697650836369230e-24,  1.026832547009114e-25, -5.527283699415159e-27,  2.680373175089041e-28, -1.180870451670530e-29,  5.413018407425587e-19, -2.376181444326560e-19,
  5.599013224066617e-20, -8.965230323155281e-21,  1.085266914126825e-21, -1.055367944169119e-22,  8.573707358125384e-24, -5.979974106169195e-25,  3.653803917795722e-26,
 -1.986192170762884e-27,  9.723913676404194e-29, -4.323633459623814e-30,  6.611630331482476e-02, -1.811612601717833e-04,  5.151741847397783e-07, -1.511152396300619e-09,
  4.537205407618306e-12, -1.385145093388314e-14,  4.271699815668896e-17, -1.326011205434177e-19,  4.124316424080780e-22, -1.285135397702140e-24,  3.993961947209459e-27,
 -1.242560120394125e-29,  6.059001051511585e-02, -2.050253024977682e-04,  8.346933449258040e-07, -3.559370099777967e-09,  1.506805798854434e-11, -6.253428151950444e-14,
  2.543068540121960e-16, -1.015868518319514e-18,  3.995425242048076e-21, -1.550497581063572e-23,  5.945309152296562e-26, -2.255794913139865e-28,  5.088784402778814e-02,
 -2.378710092383652e-04,  1.373909083333908e-06, -7.649504621707995e-09,  4.040183805564154e-11, -2.046612809272498e-13,  1.003166332313644e-15, -4.785642489230621e-18,
  2.230890427800688e-20, -1.019246470246398e-22,  4.574512052644556e-25, -2.020580577795932e-27,  3.917462525183935e-02, -2.592562468363013e-04,  1.958639809284046e-06,
 -1.337766076961181e-08,  8.488963980231257e-11, -5.105135394191887e-13,  2.942210662195012e-15, -1.636798940686806e-17,  8.835634820823519e-20, -4.646397969886439e-22,
  2.387677281184653e-24, -1.201930429036410e-26,  2.764788076472286e-02, -2.550139548335893e-04,  2.395746458446201e-06, -1.960618155917599e-08,  1.469497343504337e-10,
 -1.032005004486147e-12,  6.881027132960539e-15, -4.395075650800293e-17,  2.706688653473656e-19, -1.615067636155017e-21,  9.372893926041624e-24, -5.306256245922113e-26,
  1.789401803218299e-02, -2.237412122341178e-04,  2.545808225350700e-06, -2.464243846445874e-08,  2.154482517192661e-10, -1.745435839618984e-12,  1.330899238443606e-14,
 -9.653545326356228e-17,  6.712014080697087e-19, -4.499182061230948e-21,  2.920505113063048e-23, -1.842226751165427e-25,  1.062440354024116e-02, -1.750206680388572e-04,
  2.376842443484451e-06, -2.694558139724083e-08,  2.720947962285324e-10, -2.519317718305895e-12,  2.177780595389440e-14, -1.779152194349369e-16,  1.385704722129852e-18,
 -1.035664053095133e-20,  7.465282340940917e-23, -5.210385751275524e-25,  5.789727143138669e-03, -1.224605565784188e-04,  1.965880157066163e-06, -2.588522225910064e-08,
  2.994951012532291e-10, -3.146098871349930e-12,  3.062151415784432e-14, -2.799500201496737e-16,  2.427511000001722e-18, -2.011040858879782e-20,  1.600632610879607e-22,
 -1.229356559000370e-24,  2.897520086659941e-03, -7.695468938083228e-05,  1.449387179344680e-06, -2.200699700901207e-08,  2.898429627281936e-10, -3.433838784934267e-12,
  3.742401765464581e-14, -3.808813456686764e-16,  3.658773330064976e-18, -3.343808454038909e-20,  2.925292287384547e-22, -2.461498324173450e-24,  1.332687462641483e-03,
 -4.360586274566094e-05,  9.572567107558357e-07, -1.665608107870421e-08,  2.483459635416405e-10, -3.301804588619021e-12,  4.010856153810234e-14, -4.524603724624715e-16,
  4.795190359608560e-18, -4.815608330342184e-20,  4.613132027685890e-22, -4.237274315265347e-24,  5.638374769125797e-04, -2.236343610852985e-05,  5.687445221820938e-07,
 -1.127855979750701e-08,  1.894864639644332e-10, -2.815213706705501e-12,  3.796787693767702e-14, -4.730152721643004e-16,  5.511573815169973e-18, -6.062123319454898e-20,
  6.338817037207374e-22, -6.336208977247554e-24,  2.196738380686695e-04, -1.041620782075351e-05,  3.051380641339382e-07, -6.863070713635511e-09,  1.293893973963471e-10,
 -2.140313532325139e-12,  3.194041974608571e-14, -4.380786573466374e-16,  5.595529892273876e-18, -6.721543809086804e-20,  7.650974251892601e-22, -8.301109511956760e-24,
  7.891816802035412e-05, -4.420507479911972e-06,  1.483594072900655e-07, -3.768170134814280e-09,  7.942944031854917e-11, -1.458155453944772e-12,  2.400759907026156e-14,
 -3.615162585755665e-16,  5.048831137626381e-18, -6.607518140876283e-20,  8.168398989199551e-22, -9.597945362807385e-24,  2.618452367522381e-05, -1.714780355386527e-06,
  6.559760191465816e-08, -1.874024208145667e-09,  4.402201159958268e-11, -8.943047527545415e-13,  1.620249011573981e-14, -2.672297738379216e-16,  4.071400421190057e-18,
 -5.792749415614208e-20,  7.761570100273637e-22, -9.857383817585662e-24,  8.039291308990224e-06, -6.099846894788247e-07,  2.646948043251879e-08, -8.474634229637042e-10,
  2.211863625843072e-11, -4.959499202405665e-13,  9.864419593460919e-15, -1.778147376416933e-16,  2.949539320335106e-18, -4.553742729003260e-20,  6.601129934144018e-22,
 -9.045869119905061e-24,  2.289289256839951e-06, -1.996502779209725e-07,  9.783166440794504e-09, -3.498424019553089e-10,  1.011702027447853e-11, -2.497827371326498e-13,
  5.442673054170022e-15, -1.070188669612901e-16,  1.929268931043568e-18, -3.226599393603093e-20,  5.052203565891628e-22, -7.458681352759329e-24,  6.063131090646721e-07,
 -6.034522282352270e-08,  3.324977420927765e-09, -1.323794337037395e-10,  4.230814393028934e-12, -1.147640540603089e-13,  2.734151845224912e-15, -5.853980163560172e-17,
  1.145027983365357e-18, -2.071271811484870e-20,  3.498036941074967e-22, -5.555801566830998e-24,  1.498462328709619e-07, -1.691158343946238e-08,  1.043578764727291e-09,
 -4.612027046792021e-11,  1.625030261600944e-12, -4.832973327775205e-14,  1.256617687077270e-15, -2.924780833289721e-17,  6.197663295279581e-19, -1.210871454577956e-20,
  2.202676559973330e-22, -3.758834093381919e-24,  3.469481624798439e-08, -4.414262576522396e-09,  3.039095684228722e-10, -1.486620443774450e-11,  5.761353681797838e-13,
 -1.874942175218893e-14,  5.311185873976778e-16, -1.341715322639452e-17,  3.075652231233386e-19, -6.481430134816032e-21,  1.268341278697805e-22, -2.322683134307585e-24,
  7.561321616645621e-09, -1.078705917726663e-09,  8.255796490711412e-11, -4.457592438389020e-12,  1.895823720481054e-13, -6.738066089515054e-15,  2.075956311081142e-16,
 -5.683335288581795e-18,  1.407389245945429e-19, -3.194808523545829e-21,  6.717201981382460e-23, -1.318508279399517e-24,  1.559813976436977e-09, -2.482523680202697e-10,
  2.104741321376676e-11, -1.250972186897443e-12,  5.825723087312037e-14, -2.257004384530779e-15,  7.550303028261885e-17, -2.236697428201726e-18,  5.975136368803539e-20,
 -1.459191389912220e-21,  3.292328144284148e-23, -6.918794273534026e-25,  3.065939604682900e-10, -5.417593573169628e-11,  5.070779904028828e-12, -3.308721224257813e-13,
  1.683425000523183e-14, -7.095500505415232e-16,  2.572892508004547e-17, -8.234758586667964e-19,  2.369754718576344e-20, -6.217637433991652e-22,  1.503556186203489e-23,
 -3.378775094152086e-25,  5.787074468474735e-11, -1.130040659783478e-11,  1.163721967867282e-12, -8.313554618998368e-14,  4.610568159554865e-15, -2.110001626687690e-16,
  8.278554130731643e-18, -2.858031013639078e-19,  8.846715811822336e-21, -2.490314475775414e-22,  6.445809426297936e-24, -1.546959127018987e-25,  1.058612762926131e-11,
 -2.273832366355697e-12,  2.567486961001180e-13, -2.002521497917362e-14,  1.207634623507023e-15, -5.988040917788593e-17,  2.537252407456006e-18, -9.431994199932424e-20,
  3.135304844260785e-21, -9.454602192194525e-23,  2.615597207409265e-24, -6.694746841948132e-26,  1.896876191049308e-12, -4.460952119822522e-13,  5.503448816596461e-14,
 -4.672532067166521e-15,  3.056235903885309e-16, -1.638187884146439e-17,  7.480792279701522e-19, -2.988703243125033e-20,  1.064984527442133e-21, -3.434514801928969e-23,
  1.013911876763649e-24, -2.763469384293026e-26,  3.370840119118002e-13, -8.638244947237582e-14,  1.160050329529279e-14, -1.068729846099989e-15,  7.560750853051762e-17,
 -4.369919855600418e-18,  2.145638420585877e-19, -9.192889846434737e-21,  3.504438250811597e-22, -1.206331559476021e-23,  3.793272762198127e-25, -1.098989634409786e-26,
  6.025506329955994e-14, -1.674276197260482e-14,  2.437799146515747e-15, -2.428642898315286e-16,  1.852584660886986e-17, -1.151300010581620e-18,  6.062207406666983e-20,
 -2.778552447971053e-21,  1.130528282820153e-22, -4.144718442667194e-24,  1.385270914648854e-25, -4.257460699659256e-27,  1.100957914775482e-14, -3.299752060484985e-15,
  5.186805484635936e-16, -5.566483216693318e-17,  4.562484061834414e-18, -3.038893497146736e-19,  1.710838264463752e-20, -8.364785180003899e-22,  3.622773972673593e-23,
 -1.410909344702217e-24,  4.999818527291722e-26, -1.626167672382995e-27,  2.093181168785897e-15, -6.729451743839926e-16,  1.136553337214124e-16, -1.308362507373807e-17,
  1.147728403259341e-18, -8.163062454505922e-20,  4.896493846084535e-21, -2.545381258239663e-22,  1.169746101518610e-23, -4.824789868216093e-25,  1.807516847008307e-26,
 -6.203869661824887e-28,  4.221655808634132e-16, -1.447216648551763e-16,  2.612506333932283e-17, -3.210390972341793e-18,  3.000552396957765e-19, -2.269171975874086e-20,
  1.444386383891177e-21, -7.952391682686550e-23,  3.863519840967515e-24, -1.681721967583780e-25,  6.637682700457136e-27, -2.396197637311763e-28,  9.216102090975035e-17,
 -3.347376019081553e-17,  6.421095674706300e-18, -8.377283321994513e-19,  8.299279966761876e-20, -6.640953718198553e-21,  4.464750277542931e-22, -2.591844728379014e-23,
  1.325458980912476e-24, -6.063368206941405e-26,  2.511236379782412e-27, -9.497895340921328e-29,  2.221261658613349e-17, -8.489776272989701e-18,  1.719360910263010e-18,
 -2.366906754648706e-19,  2.470940151727569e-20, -2.080345181136408e-21,  1.469298981930414e-22, -8.946751004753380e-24,  4.792048669999586e-25, -2.292693631293154e-26,
  9.917442067478672e-28, -3.912059725521300e-29,  6.013912482999684e-18, -2.401213532885463e-18,  5.097475436975209e-19, -7.353445696598022e-20,  8.035864988873511e-21,
 -7.073174539587860e-22,  5.215833845905694e-23, -3.311637165260679e-24,  1.847162081663998e-25, -9.191709115132392e-27,  4.130431541022989e-28, -1.690466296551909e-29,
  1.848750463737639e-18, -7.652145512062691e-19,  1.689466361751376e-19, -2.534423160242114e-20,  2.877793785474873e-21, -2.629273707383826e-22,  2.010341554475770e-23,
 -1.322032649000272e-24,  7.629474821508493e-26, -3.923968757454509e-27,  1.820656623104608e-28, -7.685755991646559e-30,  6.421205312805222e-19, -2.733029043611263e-19,
  6.222424664913781e-20, -9.625915998084595e-21,  1.126462172944204e-21, -1.059860730606891e-22,  8.338279364323463e-24, -5.637359829326972e-25,  3.341897658949755e-26,
 -1.764149577035730e-27,  8.394714325512952e-29, -3.631377360843918e-30,  2.401902154642784e-19, -1.042472856885752e-19,  2.425457244773193e-20, -3.834556198310373e-21,
  4.584128050963188e-22, -4.403755599878896e-23,  3.535350043685121e-24, -2.437564561622943e-25,  1.472797049996050e-26, -7.919628643466666e-28,  3.836647723456782e-29,
 -1.688639998326166e-30,  7.639421229546185e-20, -3.352095914023568e-20,  7.894799634878112e-21, -1.263517984040791e-21,  1.528794407163718e-22, -1.485978892043430e-23,
  1.206640318682236e-24, -8.412272136074027e-26,  5.137697186047178e-27, -2.791631952093391e-28,  1.366142188445711e-29, -6.071923533016312e-31,  6.539978792848829e-02,
 -1.771111885874838e-04,  4.974669627964825e-07, -1.440718875030917e-09,  4.270135259205952e-12, -1.286934727407714e-14,  3.918219479407884e-17, -1.201137503964817e-19,
  3.689154416440698e-22, -1.135790228108338e-24,  3.485695275757701e-27, -1.072251603738173e-29,  5.978299954998822e-02, -1.985145999359793e-04,  7.933872130485639e-07,
 -3.327964458456393e-09,  1.387617454945534e-11, -5.675830120350271e-14,  2.275717363516716e-16, -8.965055197952840e-19,  3.477765137340600e-21, -1.331395147761557e-23,
  5.036745085713545e-26, -1.885778715240941e-28,  4.995777628841822e-02, -2.272362263003479e-04,  1.285862644173229e-06, -7.034557039070707e-09,  3.653892148756064e-11,
 -1.821158641641481e-13,  8.786353217945967e-16, -4.127101365660982e-18,  1.894863739658429e-20, -8.528713365829599e-23,  3.771797508276838e-25, -1.641965106063856e-27,
  3.816795340425977e-02, -2.442069179020546e-04,  1.805932362085426e-06, -1.209742232319036e-08,  7.534996490981269e-11, -4.450954528895949e-13,  2.521101636255804e-15,
 -1.379077225213372e-17,  7.322825158462096e-20, -3.789215404751235e-22,  1.916575599147732e-24, -9.498549334079886e-27,  2.666472125046902e-02, -2.367506219127488e-04,
  2.173926294079297e-06, -1.741153521696046e-08,  1.278662398103596e-10, -8.807003141433608e-13,  5.763415460286088e-15, -3.615160307759936e-17,  2.187479479220689e-19,
 -1.282976030716067e-21,  7.321124298288440e-24, -4.076658209040713e-26,  1.703799266047798e-02, -2.045015262535624e-04,  2.269683815478369e-06, -2.145805843756602e-08,
  1.835266871581946e-10, -1.456170845992958e-12,  1.088386845739081e-14, -7.743802098926034e-17,  5.284418424783162e-19, -3.478281412583256e-21,  2.217980329439900e-23,
 -1.374901862535990e-25,  9.960402141262589e-03, -1.572289595324201e-04,  2.078041386759191e-06, -2.296836505611376e-08,  2.265561093393298e-10, -2.051744137067088e-12,
  1.736478849932952e-14, -1.390037983133230e-16,  1.061514896688387e-18, -7.783173030696652e-21,  5.506487941684737e-23, -3.773747980441545e-25,  5.329480735172786e-03,
 -1.078990785862528e-04,  1.682055019946729e-06, -2.155926135718721e-08,  2.433300400514724e-10, -2.497095116507751e-12,  2.376983399774690e-14, -2.127161235304426e-16,
  1.806837143239444e-18, -1.467189291070044e-20,  1.145243672254078e-22, -8.630411325267377e-25,  2.611323789052972e-03, -6.634200997774724e-05,  1.211010521055822e-06,
 -1.787352434870138e-08,  2.293480455598690e-10, -2.651444862999304e-12,  2.823245553012219e-14, -2.809986760024188e-16,  2.641893293297873e-18, -2.364738083023422e-20,
  2.027356627984799e-22, -1.672659100738574e-24,  1.172403408295160e-03, -3.668444997828559e-05,  7.792041170360777e-07, -1.316254763110492e-08,  1.909929976451087e-10,
 -2.475369404793823e-12,  2.935071996577843e-14, -3.235261238352533e-16,  3.353199012818620e-18, -3.295725712937732e-20,  3.091873759277023e-22, -2.782827541493158e-24,
  4.826939749705475e-04, -1.830728892920581e-05,  4.498833464168074e-07, -8.651869208058882e-09,  1.413167211816981e-10, -2.044842101243196e-12,  2.689651804350061e-14,
 -3.271670650709063e-16,  3.725528764718025e-18, -4.007739409680857e-20,  4.101524273215938e-22, -4.015091917488714e-24,  1.824153360501913e-04, -8.272338783578207e-06,
  2.339143295684681e-07, -5.097473391421806e-09,  9.335106225832488e-11, -1.502745565876053e-12,  2.185554982294637e-14, -2.924788210644804e-16,  3.648634826133048e-18,
 -4.284201595916912e-20,  4.770321840810241e-22, -5.066182939933674e-24,  6.335132330461509e-05, -3.394928428349626e-06,  1.098969471171897e-07, -2.702437317354244e-09,
  5.529402155608574e-11, -9.871773285257781e-13,  1.583000807484424e-14, -2.324500543358556e-16,  3.168886537579117e-18, -4.051825094915428e-20,  4.897567759395074e-22,
 -5.630566905837324e-24,  2.024780901001175e-05, -1.269212424964598e-06,  4.680725923996812e-08, -1.293934623114101e-09,  2.948706411854858e-11, -5.822439717325278e-13,
  1.026880000337033e-14, -1.650764084793076e-16,  2.453952632216129e-18, -3.409781264641276e-20,  4.465391162771364e-22, -5.546927638891983e-24,  5.966052570912633e-06,
 -4.335687809991907e-07,  1.813344640834988e-08, -5.615726895818359e-10,  1.421311423251305e-11, -3.096342165928490e-13,  5.992820850677505e-15, -1.052520240716157e-16,
  1.702908678499497e-18, -2.566782835018756e-20,  3.635655233072845e-22, -4.871726275271562e-24,  1.624067628961570e-06, -1.357637038840674e-07,  6.411915717124919e-09,
 -2.217438711651129e-10,  6.216848916512557e-12, -1.490889450163747e-13,  3.160315154747798e-15, -6.053040317525818e-17,  1.064094680265308e-18, -1.737098619971219e-20,
  2.657183239953537e-22, -3.835286898841410e-24,  4.094917976776106e-07, -3.910260466613778e-08,  2.077026256231175e-09, -7.997408762463384e-11,  2.477752990327930e-12,
 -6.527645893529854e-14,  1.512707791637677e-15, -3.154467629940692e-17,  6.016117515541164e-19, -1.062149697989970e-20,  1.752253970211717e-22, -2.720724551634731e-24,
  9.593107858922398e-08, -1.039876807151210e-08,  6.188748570258404e-10, -2.645665293629466e-11,  9.037608938231775e-13, -2.610624463978729e-14,  6.602760183919004e-16,
 -1.496803236356280e-17,  3.092652670862675e-19, -5.897366407791627e-21,  1.047964970769602e-22, -1.748361341689874e-24,  2.095913112025858e-08, -2.564416029366184e-09,
  1.703866976345636e-10, -8.065542573493425e-12,  3.031313676068661e-13, -9.583564498384488e-15,  2.641203691106758e-16, -6.499649992694165e-18,  1.452996587053171e-19,
 -2.988957796364980e-21,  5.714605219133614e-23, -1.023268572358856e-24,  4.289872147588669e-09, -5.893589986788106e-10,  4.356808869527254e-11, -2.277808755011078e-12,
  9.399282029994045e-14, -3.246664220110343e-15,  9.735155159264507e-17, -2.597079956493888e-18,  6.273705409668464e-20, -1.390598053483686e-21,  2.857387756639675e-23,
 -5.485746507579129e-25,  8.270303850181488e-10, -1.269565888332208e-10,  1.040772321288719e-11, -5.994702351732217e-13,  2.710459681254174e-14, -1.021139245055804e-15,
  3.326348360565088e-17, -9.606799164330577e-19,  2.504643548365578e-20, -5.975136231664414e-22,  1.318097740259851e-23, -2.710372177705842e-25,  1.511524550603367e-10,
 -2.580665198510558e-11,  2.338563905626772e-12, -1.480286129361372e-13,  7.318721422109126e-15, -3.002087980269786e-16,  1.060772365870440e-17, -3.312130210470820e-19,
  9.308048943497913e-21, -2.387143403815744e-22,  5.647202523759679e-24, -1.242432214136749e-25,  2.639226562759972e-11, -4.989139092229527e-12,  4.981689718631041e-13,
 -3.456747595575465e-14,  1.864947159974185e-15, -8.314235290621255e-17,  3.181623466843482e-18, -1.072473145092856e-19,  3.244517358707436e-21, -8.934180791202686e-23,
  2.263921009064296e-24, -5.323240868130037e-26,  4.443078509615478e-12, -9.258496282714193e-13,  1.015374142438389e-13, -7.703478961157693e-15,  4.525290085911638e-16,
 -2.188485040233372e-17,  9.054417195169409e-19, -3.289878558590744e-20,  1.069882333640603e-21, -3.158965194408553e-23,  8.563539603283461e-25, -2.149392127101468e-26,
  7.290099075132726e-13, -1.667086951402623e-13,  2.001402310123658e-14, -1.655687804777386e-15,  1.056526145080778e-16, -5.531201949902814e-18,  2.469537795017644e-19,
 -9.655449078019666e-21,  3.369990444819424e-22, -1.065344394716762e-23,  3.085184854777467e-25, -8.254579992532575e-27,  1.180672580545024e-13, -2.949375668189390e-14,
  3.862549029206712e-15, -3.473936558253323e-16,  2.401860623615539e-17, -1.358086455427328e-18,  6.529632635415585e-20, -2.741806217030033e-21,  1.025180326834760e-22,
 -3.463891006808527e-24,  1.069849691267894e-25, -3.046478065385367e-27,  1.915417809589619e-14, -5.201820747397338e-15,  7.403354281152814e-16, -7.215600465875359e-17,
  5.389768404443368e-18, -3.282857379467040e-19,  1.695619443611910e-20, -7.629338665197519e-22,  3.049529433821520e-23, -1.099056547248711e-24,  3.613301445076178e-26,
 -1.093018802652103e-27,  3.165662560865941e-15, -9.298948627019992e-16,  1.432324563184317e-16, -1.507320504909896e-17,  1.212409375887436e-18, -7.930870821353919e-20,
  4.388221650675644e-21, -2.110112260552429e-22,  8.993751602529254e-24, -3.449113246967389e-25,  1.204244708960880e-26, -3.861147562375909e-28,  5.432453529680290e-16,
 -1.716582350120712e-16,  2.848477122885878e-17, -3.223367480902049e-18,  2.781363496200149e-19, -1.947106055867894e-20,  1.150296509786324e-21, -5.892796400470516e-23,
  2.670209350907373e-24, -1.086536010931398e-25,  4.017665277704950e-27, -1.361729180078407e-28,  9.884555827700417e-17, -3.340048666569578e-17,  5.940251185169295e-18,
 -7.194335070691235e-19,  6.630397209850065e-20, -4.946986162229222e-21,  3.108247462903306e-22, -1.690063719757232e-23,  8.112689586811236e-25, -3.490637129244654e-26,
  1.362441316564743e-27, -4.865820063763904e-29,  1.949975000761665e-17, -7.001020445457850e-18,  1.326773562500777e-18, -1.710510981981752e-19,  1.675197012676689e-20,
 -1.325681413772578e-21,  8.817958601823835e-23, -5.066579078239770e-24,  2.565501292155124e-25, -1.162457637662853e-26,  4.770428129222783e-28, -1.788354771971145e-29,
  4.265422154059657e-18, -1.615877150007199e-18,  3.241812910079351e-19, -4.421542546701837e-20,  4.574548518892431e-21, -3.818124438131015e-22,  2.674174881795804e-23,
 -1.615261276979009e-24,  8.584683056345984e-26, -4.076589008737905e-27,  1.750713459253698e-28, -6.858094367244385e-30,  1.055889089037012e-18, -4.189100417649270e-19,
  8.832078524114580e-20, -1.265464120142085e-20,  1.373805397580104e-21, -1.201533178158746e-22,  8.805849718203566e-24, -5.557917840717856e-25,  3.082399281562875e-26,
 -1.525399915736663e-27,  6.818230893235060e-29, -2.776250382464563e-30,  3.000088085173685e-19, -1.236543740039104e-19,  2.717590375695662e-20, -4.058224993993322e-21,
  4.587649132157107e-22, -4.173505061489838e-23,  3.177847319652703e-24, -2.081451457789455e-25,  1.196577717094058e-26, -6.131306955381313e-28,  2.834611850228817e-29,
 -1.192473018156816e-30,  9.769342963430305e-20, -4.147902329367883e-20,  9.418307179049744e-21, -1.453075073237018e-21,  1.695987578917079e-22, -1.591655171797465e-23,
  1.249127142091504e-24, -8.425038134128019e-26,  4.982993459559939e-27, -2.624627498697196e-28,  1.246252706515368e-29, -5.379891602887537e-31,  3.486418313238038e-20,
 -1.511395639316422e-20,  3.511880479627264e-21, -5.544891540530257e-22,  6.620301258376109e-23, -6.351877831245250e-24,  5.093135505003994e-25, -3.507510297751525e-26,
  2.116857642720417e-27, -1.137037982377456e-28,  5.502480092604279e-30, -2.419333691595512e-31,  1.079293744009039e-20, -4.733709283170913e-21,  1.114315161236500e-21,
 -1.782492617869421e-22,  2.155644961944027e-23, -2.094240859717599e-24,  1.699738945023106e-25, -1.184439431555857e-26,  7.230493869278996e-28, -3.927012074599168e-29,
  1.920919652970911e-30, -8.534023653449861e-32,  6.469919476526170e-02, -1.731994651493605e-04,  4.805799379497241e-07, -1.374405832822782e-09,  4.021886359888921e-12,
 -1.196803566211196e-14,  3.597832364456772e-17, -1.089366577802261e-19,  3.304270662956263e-22, -1.005354170630465e-24,  3.046674688860772e-27, -9.271041633747263e-30,
  5.900138763743968e-02, -1.923235545922221e-04,  7.547472303006907e-07, -3.114738554334897e-09,  1.279365563008728e-11, -5.158565915166583e-14,  2.039582465195696e-16,
 -7.925126923602358e-19,  3.032814302106700e-21, -1.145578307549388e-23,  4.276341908075067e-26, -1.580168440162458e-28,  4.906888423431906e-02, -2.172773148606878e-04,
  1.204839106588505e-06, -6.477965185696080e-09,  3.309845885713604e-11, -1.623495405059772e-13,  7.711238689645150e-16, -3.567094106531172e-18,  1.613332568254909e-20,
 -7.155061915733496e-23,  3.118564044621929e-25, -1.338227766988350e-27,  3.721912931489643e-02, -2.303202959057482e-04,  1.667713429373353e-06, -1.095987732115951e-08,
  6.702315963913813e-11, -3.889700147382789e-13,  2.165816485072102e-15, -1.165171107495317e-17,  6.087194296387799e-20, -3.100033152267520e-22,  1.543634553351244e-24,
 -7.533295024737111e-27,  2.575122570204990e-02, -2.201614771228333e-04,  1.976705205685307e-06, -1.549940239626740e-08,  1.115573753531331e-10, -7.537750289120221e-13,
  4.842609707171286e-15, -2.983747331869948e-17,  1.774267469602833e-19, -1.023076570322027e-21,  5.741598569594709e-24, -3.145267584492712e-26,  1.625473835200199e-02,
 -1.873262479727593e-04,  2.028888642220483e-06, -1.874113046945645e-08,  1.568491751649339e-10, -1.219176192664555e-12,  8.934676894656966e-15, -6.237131022606468e-17,
  4.178357283128912e-19, -2.701198067052961e-21,  1.692430422314973e-23, -1.031200791067074e-25,  9.363072433054800e-03, -1.416484645363806e-04,  1.822886133846990e-06,
 -1.965036011519818e-08,  1.893923070420163e-10, -1.678100519270758e-12,  1.390897087733656e-14, -1.091238000834200e-16,  8.172679113482814e-19, -5.879988183216387e-21,
  4.083946775553867e-23, -2.748806017078521e-25,  4.923247473797511e-03, -9.541490100468824e-05,  1.445150625260066e-06, -1.803643353720763e-08,  1.986422623278323e-10,
 -1.992016376709621e-12,  1.854973929465180e-14, -1.625334889089453e-16,  1.352707932827998e-18, -1.076907396129390e-20,  8.245679865083670e-23, -6.098160917103679e-25,
  2.364056571677249e-03, -5.745327593694580e-05,  1.016908025004443e-06, -1.459388446353651e-08,  1.825038592451826e-10, -2.059462416340549e-12,  2.143045815115804e-14,
 -2.086472860369458e-16,  1.920403654301035e-18, -1.683917121375040e-20,  1.415080267155683e-22, -1.144973111506793e-24,  1.037201196892153e-03, -3.103419758661904e-05,
  6.380711874128060e-07, -1.046732050427106e-08,  1.478543302900517e-10, -1.868548262536394e-12,  2.163158147171147e-14, -2.330407541973901e-16,  2.362690369044036e-18,
 -2.273213673186936e-20,  2.088948375278766e-22, -1.842691891203818e-24,  4.160558477852404e-04, -1.508796855934632e-05,  3.583833742982384e-07, -6.685791633918817e-09,
  1.061973804403515e-10, -1.497010221856983e-12,  1.920869795832785e-14, -2.281844073898165e-16,  2.539901278147494e-18, -2.672887671161153e-20,  2.677777138065416e-22,
 -2.567645354818437e-24,  1.527142549817535e-04, -6.622423313278006e-06,  1.807997826891529e-07, -3.818360120201448e-09,  6.794072614510297e-11, -1.064595266665448e-12,
  1.509279946229982e-14, -1.971128106718205e-16,  2.402062182320857e-18, -2.757513711759501e-20,  3.004026383219983e-22, -3.123381625427885e-24,  5.134398658266763e-05,
 -2.631806471883219e-06,  8.218566891715383e-08, -1.957061806623233e-09,  3.887643723475855e-11, -6.751253824798994e-13,  1.054616962114558e-14, -1.510401368469103e-16,
  2.010293090796298e-18, -2.511725103396729e-20,  2.968942035206607e-22, -3.340172282026335e-24,  1.583179343445435e-05, -9.496479458710594e-07,  3.376595722433227e-08,
 -9.033354035031785e-10,  1.997376330397273e-11, -3.834068056819135e-13,  6.583556831694796e-15, -1.031700318290401e-16,  1.496647906838749e-18, -2.031230569029433e-20,
  2.600262645791170e-22, -3.159693314212894e-24,  4.484128778069448e-06, -3.120151644676314e-07,  1.257749504538739e-08, -3.767909385607286e-10,  9.248530725872947e-12,
 -1.957764365257830e-13,  3.687570340852076e-15, -6.310892177947963e-17,  9.960313329335886e-19, -1.465882515647265e-20,  2.028986938767414e-22, -2.658813764740874e-24,
  1.168869971912255e-06, -9.362354549026372e-08,  4.261334545328149e-09, -1.425212321641314e-10,  3.873939448918474e-12, -9.024374190323247e-14,  1.861077503197219e-15,
 -3.472411556407630e-17,  5.953064578807752e-19, -9.486462811947964e-21,  1.417714850267613e-22, -2.000713989524407e-24,  2.810709096507917e-07, -2.573895292005350e-08,
  1.317773387066045e-09, -4.906696117646032e-11,  1.473633110075601e-12, -3.770523557279217e-14,  8.499330455742721e-16, -1.726251771745980e-17,  3.210163637396591e-19,
 -5.531626551280383e-21,  8.914475805745230e-23, -1.353179197872333e-24,  6.252829749649624e-08, -6.506586895661192e-09,  3.733690761328713e-10, -1.543710916917447e-11,
  5.111963266268135e-13, -1.434115868083438e-14,  3.528041364485413e-16, -7.789379568567038e-18,  1.569224625376290e-19, -2.920483677745106e-21,  5.069511736752298e-23,
 -8.268361459554876e-25,  1.291435505041421e-08, -1.518618951866744e-09,  9.734248001098198e-11, -4.457956197377730e-12,  1.624523386907274e-13, -4.988745256488359e-15,
  1.337470337153295e-16, -3.205864758191194e-18,  6.988372982035015e-20, -1.403183671932280e-21,  2.620873105165465e-23, -4.588429366502784e-25,  2.486905871600018e-09,
 -3.288012458630856e-10,  2.346722639303515e-11, -1.187609562766675e-12,  4.753523052297886e-14, -1.595390242311504e-15,  4.654905348161670e-17, -1.209860760762717e-18,
  2.850579431848854e-20, -6.168695244004671e-22,  1.238580177127069e-23, -2.325436226972127e-25,  4.488362453118266e-10, -6.640682171843577e-11,  5.261116792043217e-12,
 -2.935425478540685e-13,  1.288155196273773e-14, -4.717792372198993e-16,  1.496084290619253e-17, -4.211429323158373e-19,  1.071336080118705e-20, -2.496166731318280e-22,
  5.382644335038994e-24, -1.082799277371844e-25,  7.639814575643430e-11, -1.259277740280477e-11,  1.104134632075100e-12, -6.776586070408441e-14,  3.254387545220712e-15,
 -1.298647363443953e-16,  4.469935106225920e-18, -1.361149149132319e-19,  3.734466740012750e-21, -9.358943002926791e-23,  2.165353934668590e-24, -4.662935903739742e-26,
  1.235746559522285e-11, -2.259509525124181e-12,  2.186056242593921e-13, -1.472489635853317e-14,  7.724322252269868e-16, -3.353086885155833e-17,  1.250963980166486e-18,
 -4.115666201206072e-20,  1.216454442884260e-21, -3.275559328204755e-23,  8.123350302853390e-25, -1.870809156446794e-26,  1.916784022811894e-12, -3.871362628188577e-13,
  4.120553490410152e-14, -3.038942814580375e-15,  1.737916616318803e-16, -8.193010379305506e-18,  3.308159624855289e-19, -1.174324943095168e-20,  3.734560731738391e-22,
 -1.079242636699216e-23,  2.865777607512356e-25, -7.050910318235562e-27,  2.882224591227367e-13, -6.402810679011736e-14,  7.474131494264981e-15, -6.020297649579439e-16,
  3.745450671297400e-17, -1.914021266615530e-18,  8.350555846008287e-20, -3.193521052698656e-21,  1.091216460919685e-22, -3.379963751201604e-24,  9.597757810541332e-26,
 -2.519773452685027e-27,  4.255859863469787e-14, -1.035316394995407e-14,  1.321101622141413e-15, -1.159058830451316e-16,  7.826258782088572e-18, -4.326356485290599e-19,
  2.035629494815897e-20, -8.372447172728793e-22,  3.068882221796150e-23, -1.017276678680680e-24,  3.084598295888026e-26, -8.629164867556281e-28,  6.265164699521271e-15,
 -1.661322629456785e-15,  2.309116859920388e-16, -2.199979160317592e-17,  1.607967625958253e-18, -9.592487803752267e-20,  4.856926015057149e-21, -2.144010677778575e-22,
  8.414078722497100e-24, -2.979412086497885e-25,  9.630161655161081e-27, -2.865819900589700e-28,  9.358690987703379e-16, -2.691687983839829e-16,  4.059174413500390e-17,
 -4.185344261330386e-18,  3.301179493264232e-19, -2.119290997591355e-20,  1.151710570110963e-21, -5.443253765297311e-23,  2.281834543117780e-24, -8.612188429878590e-26,
  2.961000948317418e-27, -9.354202632677315e-29,  1.447411380417186e-16, -4.491182940879793e-17,  7.316023864909623e-18, -8.131751525937677e-19,  6.896743904265311e-20,
 -4.748850545977396e-21,  2.761269222842562e-22, -1.393130344423726e-23,  6.220738235483156e-25, -2.495780740146476e-26,  9.103884740847541e-28, -3.045481394574037e-29,
  2.370637228201310e-17, -7.889423005182342e-18,  1.381269921224681e-18, -1.647488818117071e-19,  1.496127426296763e-20, -1.100559467218902e-21,  6.821372159498455e-23,
 -3.660757115174316e-24,  1.735243920336788e-25, -7.376194801172969e-27,  2.845576678556776e-28, -1.004904500099416e-29,  4.213653528429080e-18, -1.494351318890364e-18,
  2.795823936722398e-19, -3.559421436554065e-20,  3.443841239300116e-21, -2.693612040626001e-22,  1.771637960761865e-23, -1.006973421838651e-24,  5.046011940893878e-26,
 -2.263569077862910e-27,  9.199700190198653e-29, -3.416874454313773e-30,  8.335326070904452e-19, -3.127961588480412e-19,  6.212836437676519e-20, -8.390691946579377e-21,
  8.598596645210984e-22, -7.111016917094841e-23,  4.936521400894067e-24, -2.956424195772182e-25,  1.558398094652110e-26, -7.341967581244654e-28,  3.129082403961346e-29,
 -1.216796585707548e-30,  1.879133066589461e-19, -7.404452852004813e-20,  1.549710309216141e-20, -2.204410668414443e-21,  2.376368708606564e-22, -2.064306127446519e-23,
  1.503020855148368e-24, -9.426813659985094e-26,  5.196379986121361e-27, -2.556530678363013e-28,  1.136282099349319e-29, -4.601651871703241e-31,  4.914927097387285e-20,
 -2.016641370911118e-20,  4.410313657218003e-21, -6.553988316721006e-22,  7.373949927250042e-23, -6.677566990766166e-24,  5.062054117701587e-25, -3.301451235782680e-26,
  1.890126280677297e-27, -9.646690085860993e-29,  4.442789058898118e-30, -1.862132216273696e-31,  1.494984470845087e-20, -6.330762782835027e-21,  1.433323111527484e-21,
 -2.204999075533292e-22,  2.566388503461863e-23, -2.401958374745148e-24,  1.880092133304399e-25, -1.264851402100582e-26,  7.462620391390200e-28, -3.921381813994446e-29,
  1.857734479839949e-30, -8.001915861594187e-32,  5.075232018319898e-21, -2.197391327863678e-21,  5.098729657623790e-22, -8.039109935221392e-23,  9.585125340583852e-24,
 -9.184248496871696e-25,  7.354711255932724e-26, -5.058664321346972e-27,  3.049315713171603e-28, -1.635973967226719e-29,  7.908003687234249e-31, -3.473187097801011e-32,
  1.526517190103239e-21, -6.692044458593843e-22,  1.574472843750074e-22, -2.517227234423655e-23,  3.042581411086762e-24, -2.954379392036918e-25,  2.396632661610473e-26,
 -1.669232563678708e-27,  1.018501881215039e-28, -5.529056870178435e-30,  2.703322873235643e-31, -1.200460436382363e-32,  6.401398324962637e-02, -1.694197210643171e-04,
  4.644654193324711e-07, -1.311924637037362e-09,  3.790919412090885e-12, -1.113999640790974e-14,  3.307085075643114e-17, -9.891933027905234e-20,  2.963330872082796e-22,
 -8.912668471179861e-25,  2.666709551185827e-27, -8.032352181702825e-30,  5.824393746614348e-02, -1.864316810450335e-04,  7.185653534234548e-07, -2.918035160349262e-09,
  1.180915010954015e-11, -4.694634843337252e-14,  1.830668705093229e-16, -7.017441583619756e-19,  2.649591759573225e-21, -9.876507117051663e-24,  3.638456203473138e-26,
 -1.327134314227052e-28,  4.821857246771616e-02, -2.079407819588599e-04,  1.130176992615424e-06, -5.973393163761511e-09,  3.002873931046659e-11, -1.449850699158408e-13,
  6.781022522118782e-16, -3.089743870242394e-18,  1.376854657614134e-20, -6.017821163734418e-23,  2.585427501894934e-25, -1.093809507784955e-27,  3.632372357532514e-02,
 -2.174870057034494e-04,  1.542381259212624e-06, -9.947024836801258e-09,  5.973822453764806e-11, -3.406951824751013e-13,  1.865242818566457e-15, -9.871073021611609e-18,
  5.074777807610168e-20, -2.544072356050760e-22,  1.247358976702109e-24, -5.995437903385953e-27,  2.490107049974931e-02, -2.050625692625565e-04,  1.800944099361682e-06,
 -1.382904656304284e-08,  9.757960661570436e-11, -6.469687232395783e-13,  4.081411758127530e-15, -2.470735526539184e-17,  1.444169456409892e-19, -8.188648097092061e-22,
  4.520534952526996e-24, -2.436674039240171e-26,  1.553652913120836e-02, -1.719538304164934e-04,  1.818284121802844e-06, -1.641552873765441e-08,  1.344759591897197e-10,
 -1.024275205411476e-12,  7.361734275193627e-15, -5.043418418163240e-17,  3.317588014839437e-19, -2.106936497674707e-21,  1.297353971276982e-23, -7.771364207682458e-26,
  8.824220831809625e-03, -1.279595158696710e-04,  1.604211963301569e-06, -1.687143007665155e-08,  1.589354392388164e-10, -1.378180453106121e-12,  1.118993589914033e-14,
 -8.606503926503597e-17,  6.322944414555602e-19, -4.464885032178641e-21,  3.045040169873549e-23, -2.013319847877574e-25,  4.563411986465737e-03, -8.466829216839321e-05,
  1.246542677731185e-06, -1.515415479129060e-08,  1.629090844468765e-10, -1.596879192300255e-12,  1.455078418420647e-14, -1.248622625056896e-16,  1.018446771532796e-18,
 -7.950937799970792e-21,  5.973062522629613e-23, -4.336093706185414e-25,  2.149471032687404e-03, -4.997183534337203e-05,  8.580279174908482e-07, -1.197725958165936e-08,
  1.460183551541675e-10, -1.608816117435199e-12,  1.636479433332116e-14, -1.558927483247861e-16,  1.405002855872702e-18, -1.207156396105884e-20,  9.945587628464419e-23,
 -7.893522225312272e-25,  9.225312788060055e-04, -2.639451044644473e-05,  5.255097751285783e-07, -8.374485347592044e-09,  1.151875513479694e-10, -1.419850713248414e-12,
  1.605253945090053e-14, -1.690619695580690e-16,  1.677049196185677e-18, -1.579850483870547e-20,  1.422363969136587e-22, -1.229936476761910e-24,  3.609679597581658e-04,
 -1.251505674662417e-05,  2.874363727799686e-07, -5.203124821886273e-09,  8.039368656953139e-11, -1.104307473658098e-12,  1.382630405988729e-14, -1.604386244188901e-16,
  1.746012538394111e-18, -1.797851458375126e-20,  1.763523900809448e-22, -1.656663156217583e-24,  1.288512690937849e-04, -5.342325498756864e-06,  1.408581148611772e-07,
 -2.883693962124062e-09,  4.986532002281382e-11, -7.607526741341398e-13,  1.051562540623387e-14, -1.340555903941597e-16,  1.596156486947577e-18, -1.791786150316138e-20,
  1.910116125837951e-22, -1.944663974006655e-24,  4.199667473695143e-05, -2.058629182228917e-06,  6.202839362385262e-08, -1.430623735683712e-09,  2.759675120641205e-11,
 -4.662577284321042e-13,  7.096536571978594e-15, -9.914596645629842e-17,  1.288575888722631e-18, -1.573495835090926e-20,  1.819137550663720e-22, -2.003065099070737e-24,
  1.251176980572000e-05, -7.179790351060806e-07,  2.461570728300485e-08, -6.374081324463534e-10,  1.367703458733070e-11, -2.552647965341470e-13,  4.268240647228009e-15,
 -6.521359582589340e-17,  9.233254756991425e-19, -1.224154491670487e-20,  1.532070424865289e-22, -1.821367233969023e-24,  3.411867035917443e-06, -2.272346476232037e-07,
  8.828728380615210e-09, -2.558718207315565e-10,  6.091619592412276e-12, -1.253144953891992e-13,  2.297377021276251e-15, -3.831656516898553e-17,  5.899849688430147e-19,
 -8.478990144807946e-21,  1.146983018072704e-22, -1.470001606552184e-24,  8.530503056657101e-07, -6.544307704064428e-08,  2.870460150657572e-09, -9.284588821774428e-11,
  2.446884830325823e-12, -5.537286437238082e-14,  1.111065705643204e-15, -2.019592627327314e-17,  3.376829893008892e-19, -5.253208151059624e-21,  7.670566399092199e-23,
 -1.058454364777956e-24,  1.959688647601639e-07, -1.720200166218500e-08,  8.487398391887162e-10, -3.055894744452837e-11,  8.896604003217399e-13, -2.210825970551135e-14,
  4.847656058454569e-16, -9.589849914035052e-18,  1.738925148413178e-19, -2.924665293471175e-21,  4.604299833625770e-23, -6.832928231237531e-25,  4.147355551007019e-08,
 -4.140710363088132e-09,  2.290431891878931e-10, -9.157562388286819e-12,  2.939459665622035e-13, -8.008396003882436e-15,  1.916226306041581e-16, -4.120349641192579e-18,
  8.093247642744911e-20, -1.470033782928970e-21,  2.492608567783226e-23, -3.974375627241406e-25,  8.112200877784473e-09, -9.162586973369993e-10,  5.664118456501344e-11,
 -2.509019132754769e-12,  8.863724669293121e-14, -2.643600629502725e-15,  6.893848459788305e-17, -1.609375119395656e-18,  3.420662709874483e-20, -6.703484681619897e-22,
  1.223115888800819e-23, -2.093494142554808e-25,  1.472409602124549e-09, -1.872202117971376e-10,  1.289544024171252e-11, -6.315045135563526e-13,  2.451189762682791e-14,
 -7.991884973446032e-16,  2.268590412261126e-17, -5.743752020704947e-19,  1.319748947040236e-20, -2.787901327076560e-22,  5.469124571119303e-24, -1.004061493492652e-25,
  2.492170391078601e-10, -3.551190729815821e-11,  2.717572788263799e-12, -1.468191561124998e-13,  6.251144147172293e-15, -2.225035697792196e-16,  6.867222800738328e-18,
 -1.883734954497111e-19,  4.674717719162210e-21, -1.063568359613840e-22,  2.241457175551841e-24, -4.410396269731348e-26,  3.957331056896642e-11, -6.292362477266287e-12,
  5.335035122928837e-13, -3.173278860376633e-14,  1.479642091084433e-15, -5.741902876444623e-17,  1.924582195070062e-18, -5.713888000318596e-20,  1.530054711473493e-21,
 -3.746032533951103e-23,  8.474512591230755e-25, -1.785808481189025e-26,  5.938754666226677e-12, -1.049393080117585e-12,  9.830745776969426e-14, -6.424367970949431e-15,
  3.275166119288666e-16, -1.383742398374800e-17,  5.031009662627635e-19, -1.614909321997208e-20,  4.661724515718925e-22, -1.227101996700517e-23,  2.977420522462807e-25,
 -6.714077631634993e-27,  8.498399671801962e-13, -1.662108547657961e-13,  1.715655600174799e-14, -1.229199335022566e-15,  6.839542530566728e-17, -3.141482457138173e-18,
  1.237365319399929e-19, -4.289349621439039e-21,  1.333395907824272e-22, -3.769995332015416e-24,  9.802096094857396e-26, -2.363245756409708e-27,  1.172251033432203e-13,
 -2.527312682508793e-14,  2.866211907209608e-15, -2.246298643357850e-16,  1.361628090918829e-17, -6.788122345458419e-19,  2.892379958941961e-20, -1.081403740737240e-21,
  3.615827561720378e-23, -1.096866102945856e-24,  3.052759095570413e-26, -7.861129510305753e-28,  1.579014114740523e-14, -3.736986310712968e-15,  4.642240204703991e-16,
 -3.969924214165045e-17,  2.616063697213256e-18, -1.412940271162004e-19,  6.502107747669535e-21, -2.617995928768628e-22,  9.402224966840497e-24, -3.056089956330413e-25,
  9.093245848999300e-27, -2.497959925152188e-28,  2.109389782229645e-15, -5.455927800840568e-16,  7.399280871708454e-17, -6.885530885631599e-18,  4.920765350099315e-19,
 -2.873145999192885e-20,  1.425150314041954e-21, -6.168348340796443e-23,  2.375377602084888e-24, -8.259556062211991e-26,  2.623331099204463e-27, -7.676175849421625e-29,
  2.846170943467495e-16, -8.007164711263079e-17,  1.181146799094010e-17, -1.192244388767867e-18,  9.214306344386540e-20, -5.801249381279333e-21,  3.094327104573290e-22,
 -1.436492280614284e-23,  5.919124574543410e-25, -2.197359564854266e-26,  7.435446706833047e-28, -2.313213216022151e-29,  3.961943406045910e-17, -1.206048483485122e-17,
  1.926906839158049e-18, -2.101957276176287e-19,  1.750902175456171e-20, -1.184964750469982e-21,  6.776891430551612e-23, -3.365160716352304e-24,  1.479849699571507e-25,
 -5.850541779801922e-27,  2.104103594924368e-28, -6.943514706626378e-30,  5.828778104160895e-18, -1.908811606506754e-18,  3.287117019233014e-19, -3.858125506596768e-20,
  3.449842134216347e-21, -2.500264022140690e-22,  1.527713609894292e-23, -8.086903515299754e-25,  3.783055690515876e-26, -1.587822488629578e-27,  6.051058317110039e-29,
 -2.111929137231649e-30,  9.307589118115458e-19, -3.258066350796214e-19,  6.013294370740968e-20, -7.554622985408264e-21,  7.216175910100678e-22, -5.574941034600652e-23,
  3.623500332414874e-24, -2.036188188670503e-25,  1.009214635184564e-26, -4.479642231412800e-28,  1.802216860824847e-29, -6.628501907022618e-31,  1.659113229444744e-19,
 -6.163563141238352e-20,  1.211246222406257e-20, -1.618813875418967e-21,  1.642213713392271e-22, -1.344919631296297e-23,  9.249268326150766e-25, -5.489453571621642e-26,
  2.868564117200998e-27, -1.340180309674907e-28,  5.665866680841684e-30, -2.186254724622008e-31,  3.392538763738663e-20, -1.327033466017418e-20,  2.755734303407613e-21,
 -3.889771707305190e-22,  4.161888115281321e-23, -3.589292916739880e-24,  2.595211953236190e-25, -1.616806600404348e-26,  8.854981253363346e-28, -4.329473118803828e-29,
  1.912786663651208e-30, -7.701777212271519e-32,  8.133920851796777e-21, -3.321249988356566e-21,  7.225285462019126e-22, -1.068133540349017e-22,  1.195685176153043e-23,
 -1.077469426782081e-24,  8.129408545025214e-26, -5.277848888171587e-27,  3.008395873080187e-28, -1.528917520058430e-29,  7.012769713959414e-31, -2.927794832847792e-32,
  2.302012266078935e-21, -9.720679265453031e-22,  2.193994895139407e-22, -3.364790388480964e-23,  3.904484569257252e-24, -3.643674513215966e-25,  2.843995876914089e-26,
 -1.908129366872669e-27,  1.122845078261050e-28, -5.885293086133110e-30,  2.781325636360808e-31, -1.195202159472394e-32,  7.410909882833860e-22, -3.204321408180641e-22,
  7.424040806187927e-23, -1.168789362093173e-23,  1.391521407762031e-24, -1.331427368034311e-25,  1.064732139208156e-26, -7.313591759409230e-28,  4.402873955085844e-29,
 -2.359215464332454e-30,  1.139024743949201e-31, -4.996754952097290e-33,  2.161589124755542e-22, -9.471392144105816e-23,  2.227138477397974e-23, -3.558682332008669e-24,
  4.298993980543025e-25, -4.172088391319447e-26,  3.382647094704169e-27, -2.354754322145166e-28,  1.436050390762977e-29, -7.791901516581946e-31,  3.807853274583166e-32,
 -1.690152189969815e-33,  6.334363753954182e-02, -1.657659556193716e-04,  4.490790367177320e-07, -1.253010124286152e-09,  3.575837553764724e-12, -1.037849027210605e-14,
  3.042918606394256e-17, -8.993012588537597e-20,  2.660853047335562e-22, -7.913433587694156e-25,  2.337168734363539e-27, -6.974188495306580e-30,  5.750949045949316e-02,
 -1.808200816565014e-04,  6.846523807464654e-07, -2.736367967490351e-09,  1.091261579117026e-11, -4.277926741977602e-14,  1.645535379156021e-16, -6.223762306252404e-19,
  2.318886476176097e-21, -8.531447528996924e-24,  3.102127991551033e-26, -1.117132206626676e-28,  4.740444944143082e-02, -1.991781358476113e-04,  1.061286129513139e-06,
 -5.515275244232104e-09,  2.728502397824537e-11, -1.297009154086222e-13,  5.974457515476040e-16, -2.681907497607010e-18,  1.177724518449352e-20, -5.073792393066497e-23,
  2.149073503135673e-25, -8.965350925500868e-28,  3.547771995484877e-02, -2.056096665326850e-04,  1.428534601643125e-06, -9.043382973022993e-09,  5.335050524829051e-11,
 -2.990706620691700e-13,  1.610276706070885e-15, -8.384546105364550e-18,  4.242710871764798e-20, -2.094122114849212e-22,  1.011180210085071e-24, -4.787679671610727e-27,
  2.410862053697072e-02, -1.912932189952145e-04,  1.643952802557995e-06, -1.236619184779585e-08,  8.556632234972556e-11, -5.568203417442388e-13,  3.450110083072275e-15,
 -2.052477388734066e-17,  1.179498787034608e-19, -6.577869489285117e-22,  3.572741885284012e-24, -1.895287077391155e-26,  1.487660843718676e-02, -1.581604221893557e-04,
  1.633561281535023e-06, -1.441865713618886e-08,  1.156488016069269e-10, -8.634064919990320e-13,  6.087479451095140e-15, -4.093766554768353e-17,  2.644809984580329e-19,
 -1.650420790311384e-21,  9.989505817057621e-24, -5.884039354033157e-26,  8.336826315043558e-03, -1.158944223076938e-04,  1.416148128046750e-06, -1.453516027233890e-08,
  1.338734346396750e-10, -1.136393993101781e-12,  9.040799506443843e-15, -6.818460565352213e-17,  4.915039582641443e-19, -3.407162256656080e-21,  2.282163598200599e-23,
 -1.482555004457742e-25,  4.243591290211632e-03, -7.538134853137172e-05,  1.079336519089164e-06, -1.278526155325870e-08,  1.341984688014853e-10, -1.286180261028459e-12,
  1.147095796994391e-14, -9.642547414053698e-17,  7.709867689009451e-19, -5.903776551060940e-21,  4.352434977602135e-23, -3.102075536463873e-25,  1.962454879329476e-03,
 -4.364511724268483e-05,  7.273220251088244e-07, -9.878434366980393e-09,  1.174406662282615e-10, -1.263736216778001e-12,  1.256901169765768e-14, -1.171812159619141e-16,
  1.034385938162839e-18, -8.710116337395840e-21,  7.037038232492553e-23, -5.479551329067002e-25,  8.247664812459565e-04, -2.256310627379559e-05,  4.352005113946345e-07,
 -6.739234861026638e-09,  9.028895962057379e-11, -1.085819111050441e-12,  1.199187647728500e-14, -1.234960435292073e-16,  1.198884808198743e-18, -1.106060878520381e-20,
  9.758236133929855e-23, -8.273253908053411e-25,  3.151400742211311e-04, -1.044501723085908e-05,  2.320423125132691e-07, -4.076906526649754e-09,  6.129223351686721e-11,
 -8.206226457856366e-13,  1.002787526027667e-14, -1.136912606770802e-16,  1.209952531239194e-18, -1.219292352815440e-20,  1.171265537671835e-22, -1.078158462149174e-24,
  1.095342648998847e-04, -4.341387717977130e-06,  1.105799265190656e-07, -2.195036410140344e-09,  3.689745778435129e-11, -5.481958062521073e-13,  7.389792849676214e-15,
 -9.197723403270276e-17,  1.070238888517240e-18, -1.175040863834591e-20,  1.226010656706358e-22, -1.222415310841036e-24,  3.465561807426646e-05, -1.624218613547413e-06,
  4.723005170331461e-08, -1.055289351158048e-09,  1.977193219284248e-11, -3.250715643996693e-13,  4.821669126939799e-15, -6.572655202089954e-17,  8.343024521034387e-19,
 -9.958589578922292e-21,  1.126264014286376e-22, -1.213949393806703e-24,  9.990044457402855e-06, -5.482835109692832e-07,  1.812779696319051e-08, -4.544177547490060e-10,
  9.463881491679332e-12, -1.717685426972040e-13,  2.797262183775799e-15, -4.167640517067002e-17,  5.760045428994382e-19, -7.461296441628938e-21,  9.130682129364454e-23,
 -1.062115576861257e-24,  2.626852374155759e-06, -1.674024288696609e-07,  6.269146972630789e-09, -1.757901628481366e-10,  4.059732938593742e-12, -8.117168876107837e-14,
  1.448586609061221e-15, -2.354827675754526e-17,  3.537855654795339e-19, -4.965607402468266e-21,  6.565495819731459e-23, -8.230520741924188e-25,  6.309885001646644e-07,
 -4.634607210365978e-08,  1.958880538377571e-09, -6.127890301474828e-11,  1.565918469844328e-12, -3.442768511986054e-14,  6.721780825564435e-16, -1.190431463469762e-17,
  1.941439027515905e-19, -2.948678700530382e-21,  4.207105004450068e-23, -5.676876068580864e-25,  1.387202109666800e-07, -1.166683370276751e-08,  5.546713611311452e-10,
 -1.931068262111662e-11,  5.449680340815028e-13, -1.315317645468683e-14,  2.805550515987177e-16, -5.406010147918118e-18,  9.558963539876286e-20, -1.569257773634458e-21,
  2.413481672521890e-23, -3.501769650708278e-25,  2.797808743873461e-08, -2.678699222617876e-09,  1.427993800322964e-10, -5.520419789817567e-12,  1.717500629092681e-13,
 -4.544020036768864e-15,  1.057509326517885e-16, -2.214544891832634e-18,  4.241084357980295e-20, -7.518209520755202e-22,  1.245245913836743e-23, -1.941018170836052e-25,
  5.192131182531247e-09, -5.629549612847402e-10,  3.355148191403225e-11, -1.437255047013642e-12,  4.921603445714423e-14, -1.425457026230841e-15,  3.615398973285476e-17,
 -8.219690639481928e-19,  1.703348742196214e-20, -3.257776987272108e-22,  5.806318208447479e-24, -9.715578951795955e-26,  8.898851690448108e-10, -1.087482736503642e-10,
  7.225783089192830e-12, -3.423168448129661e-13,  1.288222293164761e-14, -4.079486222394938e-16,  1.126440968021276e-17, -2.777820755651389e-19,  6.223639697543291e-21,
 -1.283237468693559e-22,  2.459293928891007e-24, -4.414385553048069e-26,  1.415105973457343e-10, -1.940616840576006e-11,  1.433751778417962e-12, -7.497566229876109e-14,
  3.096306904145528e-15, -1.070818107076185e-16,  3.215792766375774e-18, -8.594153340152279e-20,  2.080158906785229e-21, -4.620538091272504e-23,  9.515432236075649e-25,
 -1.831055553408341e-26,  2.099900959879984e-11, -3.218362949765085e-12,  2.637111840820162e-13, -1.519425794027841e-14,  6.876197091054051e-16, -2.594041858762377e-17,
  8.464403220197162e-19, -2.449413950085372e-20,  6.399978751254681e-22, -1.530400830724163e-23,  3.384470007631296e-25, -6.977596179640101e-27,  2.928452208263492e-12,
 -4.996452452486769e-13,  4.529200047200749e-14, -2.869979357746733e-15,  1.421248097992659e-16, -5.841793982666435e-18,  2.069095034199132e-19, -6.477670517107566e-21,
  1.825653562590778e-22, -4.696383889691087e-24,  1.114567861023192e-25, -2.460275145552622e-27,  3.871601643853778e-13, -7.325554173408938e-14,  7.327681310230481e-15,
 -5.096927908458226e-16,  2.757841873423645e-17, -1.233537365131440e-18,  4.737367931902503e-20, -1.603017607817278e-21,  4.869118618062497e-23, -1.346393405546328e-24,
  3.426501220683751e-26, -8.092465293503613e-28,  4.904451099254299e-14, -1.025174894914120e-14,  1.128632912141716e-15, -8.600144544897819e-17,  5.076056494692685e-18,
 -2.467266016764398e-19,  1.026191469780024e-20, -3.749080383054201e-22,  1.226089699517123e-23, -3.641019093055359e-25,  9.928017781169197e-27, -2.506589289489308e-28,
  6.030859462089602e-15, -1.387145991781087e-15,  1.676072646594365e-16, -1.396037115830196e-17,  8.971736891121322e-19, -4.731301521205489e-20,  2.128170868001554e-21,
 -8.383799467242444e-23,  2.948554145224981e-24, -9.393038257576007e-26,  2.741243206850930e-27, -7.391201149257378e-29,  7.312628383884083e-16, -1.843002869370784e-16,
  2.436578915598354e-17, -2.212824884602553e-18,  1.545085310400772e-19, -8.823622194230797e-21,  4.284907200398083e-22, -1.817307993363153e-23,  6.863213027690130e-25,
 -2.342154687641950e-26,  7.306018716899961e-28, -2.101041164992689e-29,  8.908924855533394e-17, -2.449093351028415e-17,  3.530531188039534e-18, -3.485789985865045e-19,
  2.637654455878337e-20, -1.627412620046531e-21,  8.514081886440228e-23, -3.879874042493784e-24,  1.570494737776706e-25, -5.731177726623058e-27,  1.907621206590698e-28,
 -5.841350908574715e-30,  1.114933299505881e-17, -3.326318695358257e-18,  5.207675665148599e-19, -5.570486544068843e-20,  4.553719407767364e-21, -3.026829718041070e-22,
  1.701437786719031e-23, -8.309954199257567e-25,  3.596681840062005e-26, -1.400354084547026e-27,  4.962666614871886e-29, -1.614644739276659e-30,  1.470496320625287e-18,
 -4.734309096799917e-19,  8.012153219090381e-20, -9.246413758378192e-21,  8.134681069705368e-22, -5.804383935996810e-23,  3.493935363843842e-24, -1.823127003044994e-25,
  8.411686958440882e-27, -3.483994502222319e-28,  1.310864772797189e-29, -4.519287490943774e-31,  2.103644472876102e-19, -7.262246876675199e-20,  1.321220137256429e-20,
 -1.636743923798719e-21,  1.542404714720708e-22, -1.176203187527021e-23,  7.549940980527286e-25, -4.191977824882825e-26,  2.053866202187880e-27, -9.015925736914334e-29,
  3.588664556302285e-30, -1.306410302214358e-31,  3.366915531391893e-20, -1.237400239920223e-20,  2.404297519108537e-21, -3.177807544577181e-22,  3.189303266930672e-23,
 -2.585063855193742e-24,  1.760204915383105e-25, -1.034742145745851e-26,  5.357641325347490e-28, -2.481015608645239e-29,  1.040000004008400e-30, -3.980269994746509e-32,
  6.218561757635248e-21, -2.413462167341362e-21,  4.970043725372202e-22, -6.957710229222171e-23,  7.385203692936553e-24, -6.320253359898892e-25,  4.536038161408586e-26,
 -2.805833681946451e-27,  1.526189880694029e-28, -7.412846387564419e-30,  3.254260265444221e-31, -1.302328423004130e-32,  1.360738115000460e-21, -5.527227813423287e-22,
  1.195658029804533e-22, -1.757721218465439e-23,  1.956964295509364e-24, -1.754256034049290e-25,  1.316895450837287e-26, -8.508141281597520e-28,  4.826992262847726e-29,
 -2.442108469846757e-30,  1.115274867344468e-31, -4.636796326793424e-33,  3.568371922717187e-22, -1.502221838886028e-22,  3.379269478463666e-23, -5.165403320121677e-24,
  5.974565290504933e-25, -5.558066705297582e-26,  4.325156028928765e-27, -2.893450096986176e-28,  1.697887414108672e-29, -8.875277076391289e-31,  4.183431047682183e-32,
 -1.793215414669666e-33,  1.085728470175156e-22, -4.687650271160082e-23,  1.084330864944068e-23, -1.704358576867673e-24,  2.025971613010440e-25, -1.935527987759996e-26,
  1.545545618623884e-27, -1.060114350958502e-28,  6.373227494391644e-30, -3.410452121291308e-31,  1.644439865567491e-32, -7.204991432426249e-34,  3.064663285906294e-23,
 -1.342129294562009e-23,  3.154066709013366e-24, -5.036789247087564e-25,  6.081010378221907e-26, -5.898098067763435e-27,  4.779369503274514e-28, -3.325224509683951e-29,
  2.026807544780851e-30, -1.099156807962173e-31,  5.368779019794946e-33, -2.381806506450107e-34,  6.268766510552515e-02, -1.622325107054713e-04,  4.343794720624474e-07,
 -1.197418441366074e-09,  3.375371654654102e-12, -9.677469857126179e-15,  2.802619124933624e-17, -8.185375043688930e-20,  2.392082877683461e-22, -7.037173493700027e-25,
  2.050716290745131e-27, -6.069779596508336e-30,  5.679696071342934e-02, -1.754713037006786e-04,  6.528360211763208e-07, -2.568401997521768e-09,  1.009515390410221e-11,
 -3.903099128974063e-14,  1.481213457401953e-16, -5.528557810516016e-19,  2.032954444293240e-21, -7.383529014165633e-24,  2.650180651301439e-26, -9.424417819504907e-29,
  4.662430853894760e-02, -1.909453507042575e-04,  9.976390419275596e-07, -5.098712724411220e-09,  2.482852322546850e-11, -1.162223820568082e-13,  5.273653502621496e-16,
 -2.332675762239708e-18,  1.009636107784748e-20, -4.288113106893189e-23,  1.790944987985040e-25, -7.368454723244310e-28,  3.467747044920946e-02, -1.946014020953385e-04,
  1.324944857998827e-06, -8.235603541445745e-09,  4.773730656836645e-11, -2.630945088496897e-13,  1.393436779049689e-15, -7.140087715830609e-18,  3.556828104307197e-20,
 -1.728815596080350e-22,  8.222785219449810e-25, -3.835826287011011e-27,  2.336884285252292e-02, -1.787127178212152e-04,  1.503419423158341e-06, -1.108191099467709e-08,
  7.521350660989029e-11, -4.805084504413008e-13,  2.924885606176852e-15, -1.710323309620832e-17,  9.665295160795029e-20, -5.302534308143749e-22,  2.834150206232278e-24,
 -1.479937104248043e-26,  1.426905065255157e-02, -1.457538336776763e-04,  1.471094521151202e-06, -1.269885647346329e-08,  9.975353951616150e-11, -7.301579402344527e-13,
  5.051302062838813e-15, -3.335258895700992e-17,  2.116753780329560e-19, -1.298174747227876e-21,  7.725254994853041e-24, -4.475299201280779e-26,  7.894851546449078e-03,
 -1.052281652250578e-04,  1.253864523113847e-06, -1.256383768862742e-08,  1.131694302215433e-10, -9.406548929514337e-13,  7.334570671749583e-15, -5.425483066840662e-17,
  3.838186310722444e-19, -2.612529312581915e-21,  1.719004485902779e-23, -1.097419209495514e-25,  3.958412672314128e-03, -6.732570912387526e-05,  9.379936150722019e-07,
 -1.082978698029693e-08,  1.110228170799355e-10, -1.040673340175300e-12,  9.086744936170227e-15, -7.484345362113141e-17,  5.867561791150577e-19, -4.407980143576901e-21,
  3.189756930671020e-23, -2.232463338619386e-25,  1.798803494131384e-03, -3.827058170207667e-05,  6.192712484108971e-07, -8.186243311587351e-09,  9.493490597494631e-11,
 -9.979839020406239e-13,  9.707819653172013e-15, -8.859852033621812e-17,  7.661701440009931e-19, -6.324374109159620e-21,  5.011574802560220e-23, -3.829409082366485e-25,
  7.409976986817876e-04, -1.938198124456707e-05,  3.623284118600667e-07, -5.453807306316710e-09,  7.119147491762398e-11, -8.355162284076852e-13,  9.016212622157163e-15,
 -9.081516987366725e-17,  8.629913695310663e-19, -7.798904879045080e-21,  6.743933497932784e-23, -5.607085979880573e-25,  2.767848299178174e-04, -8.768866217710126e-06,
  1.885014568331470e-07, -3.215462584558855e-09,  4.704962011758225e-11, -6.141541294138950e-13,  7.326536957157848e-15, -8.117698523404390e-17,  8.450304720759104e-19,
 -8.335574940429887e-21,  7.843128376644179e-23, -7.075761486635278e-25,  9.378431400516044e-05, -3.552848677156135e-06,  8.744881560281733e-08, -1.683562815467739e-09,
  2.751694490768643e-11, -3.982346050676058e-13,  5.236488014349316e-15, -6.364742449981705e-17,  7.239033378339739e-19, -7.774981875042243e-21,  7.941256601007848e-23,
 -7.755869460084517e-25,  2.884121135043436e-05, -1.292110282735941e-06,  3.626891677800693e-08, -7.852378266708473e-10,  1.429292481727263e-11, -2.287213702506672e-13,
  3.306839363401421e-15, -4.399030686257202e-17,  5.454673628894308e-19, -6.365597287717827e-21,  7.043645908609516e-23, -7.432905575038490e-25,  8.055736941565078e-06,
 -4.227382294397588e-07,  1.348076457763523e-08, -3.271932225294886e-10,  6.615127632086706e-12, -1.167797733807716e-13,  1.852533627999677e-15, -2.691939220949579e-17,
  3.632375770293887e-19, -4.597837356790234e-21,  5.502411975764743e-23, -6.263718677901366e-25,  2.045599432746591e-06, -1.246950684365212e-07,  4.501383481615018e-09,
 -1.221360631994726e-10,  2.736523838650840e-12, -5.318720927790784e-14,  9.240977482635020e-16, -1.464377837058983e-17,  2.146933564801037e-19, -2.943304774649005e-21,
  3.804216615703480e-23, -4.665236989887560e-25,  4.728279671195401e-07, -3.323763609501047e-08,  1.353697104608292e-09, -4.095796676441289e-11,  1.014939157970201e-12,
 -2.168081465164908e-14,  4.119356735367988e-16, -7.108678714883386e-18,  1.130900809306045e-19, -1.677093027324534e-21,  2.338324901147758e-23, -3.085664997281588e-25,
  9.964562491156884e-08, -8.025992630619544e-09,  3.676370806789065e-10, -1.237571361338717e-11,  3.385638131679899e-13, -7.936838361976357e-15,  1.646900562437847e-16,
 -3.091211790992314e-18,  5.330300973520983e-20, -8.541753402614985e-22,  1.283457862163000e-23, -1.820734329188125e-25,  1.918638762967961e-08, -1.760673783983258e-09,
  9.043838786286352e-11, -3.380175697352213e-12,  1.019250517683012e-13, -2.618671744014898e-15,  5.927420726861341e-17, -1.208872849803708e-18,  2.257252231499420e-20,
 -3.905302868997172e-22,  6.318492075490981e-24, -9.628331504965352e-26,  3.384289315248755e-09, -3.520397720631438e-10,  2.022208602831244e-11, -8.375683746680773e-13,
  2.779719496616983e-14, -7.817692726559926e-16,  1.928359611070508e-17, -4.269407435692957e-19,  8.625631568332616e-21, -1.609971645576195e-22,  2.802808998353426e-24,
 -4.584676724455781e-26,  5.487237300860179e-10, -6.440555876580953e-11,  4.126650995401437e-12, -1.890725442977496e-13,  6.897092484394067e-15, -2.121062820182392e-16,
  5.696319162883062e-18, -1.368029698759893e-19,  2.988372215513785e-21, -6.013560396299703e-23,  1.125792560198284e-24, -1.975592057309763e-26,  8.213214033905417e-11,
 -1.083188423595500e-11,  7.722507827602453e-13, -3.907466753282484e-14,  1.564741711427160e-15, -5.256604220800513e-17,  1.535733964164764e-18, -3.997855342562090e-20,
  9.436366846655854e-22, -2.046060304604905e-23,  4.116808179483586e-25, -7.746355019764027e-27,  1.141003381990421e-11, -1.684232418489665e-12,  1.332967780866449e-13,
 -7.436307546996164e-15,  3.265021114326730e-16, -1.197031499578023e-17,  3.801374372637448e-19, -1.071927486927357e-20,  2.732245792264431e-22, -6.379872446019369e-24,
  1.378949661634750e-25, -2.780808689875605e-27,  1.481178842800458e-12, -2.438009441099367e-13,  2.137089878963952e-14, -1.312385377374513e-15,  6.310190600396019e-17,
 -2.522311191447861e-18,  8.699813276961589e-20, -2.655520656367689e-21,  7.304935534734931e-23, -1.835891595559954e-24,  4.260437531297322e-26, -9.203401402374738e-28,
  1.811888127173974e-13, -3.313628414760246e-14,  3.209708245041813e-15, -2.166146045080187e-16,  1.139120097010347e-17, -4.959266982346181e-19,  1.856232283125818e-20,
 -6.128644256762972e-22,  1.818259588927126e-23, -4.915436146221898e-25,  1.224036395369479e-26, -2.830892659402096e-28,  2.110551577607381e-14, -4.273100072977961e-15,
  4.563005524712591e-16, -3.378264042818469e-17,  1.940321770323708e-18, -9.190033242052430e-20,  3.729165807643474e-21, -1.330648593154628e-22,  4.254447620873414e-24,
 -1.236272852368326e-25,  3.301258320631116e-27, -8.168852851874738e-29,  2.371370713755953e-15, -5.295431131338150e-16,  6.218086563059395e-17, -5.040522971221840e-18,
  3.156945514882546e-19, -1.624516530069581e-20,  7.138231676993739e-22, -2.749836160336406e-23,  9.465817055126644e-25, -2.953964322786759e-26,  8.451514488053143e-28,
 -2.235687317710299e-29,  2.610952292753124e-16, -6.405202648528578e-17,  8.247468548403272e-18, -7.303767254352533e-19,  4.978922983873009e-20, -2.779058540994147e-21,
  1.320393194793843e-22, -5.484114848136034e-24,  2.029986005968263e-25, -6.795331752760208e-27,  2.080758163507604e-28, -5.877929380675367e-30,  2.871532336601440e-17,
 -7.705426858207432e-18,  1.084500730716021e-18, -1.046445215916464e-19,  7.746543543208651e-21, -4.680462421783511e-22,  2.400077947440797e-23, -1.072918597135853e-24,
  4.263681701411331e-26, -1.528635949883921e-27,  5.002129965759398e-29, -1.506814799648733e-30,  3.227797539454197e-18, -9.428304339755786e-19,  1.445066639683986e-19,
 -1.514415404387867e-20,  1.213953916602424e-21, -7.919069144602061e-23,  4.372172592412322e-24, -2.098924354196362e-25,  8.935461132869830e-27, -3.424122011182200e-28,
  1.195044799563574e-29, -3.831409634636296e-31,  3.809697858889451e-19, -1.204682071822192e-19,  2.001758058081741e-20, -2.269502807945761e-21,  1.962899620495400e-22,
 -1.377905518141073e-23,  8.165377291397262e-25, -4.197127040036070e-26,  1.908758580165319e-27, -7.796883038697137e-29,  2.894711493679446e-30, -9.852481602445591e-32,
  4.869434384478937e-20, -1.656453496702304e-20,  2.968063428438192e-21, -3.622783622068687e-22,  3.365592581957426e-23, -2.531587007471458e-24,  1.603763345120323e-25,
 -8.792849314442931e-27,  4.256103744886829e-28, -1.846644086621323e-29,  7.268261357640750e-31, -2.617535222103373e-32,  6.972939435321808e-21, -2.533381558664949e-21,
  4.863429872271087e-22, -6.352696740881119e-23,  6.303454822142403e-24, -5.053528246921506e-25,  3.404970128186057e-26, -1.981472444297261e-27,  1.016029127927023e-28,
 -4.661232950920786e-30,  1.936409464854886e-31, -7.347215554772852e-33,  1.158358694975507e-21, -4.458007922514767e-22,  9.098583549679096e-23, -1.262576423435808e-23,
  1.328781310390641e-24, -1.127873236848204e-25,  8.031061205678415e-27, -4.930154531818689e-28,  2.662172594475106e-29, -1.283992727664940e-30,  5.598799124963156e-32,
 -2.226098076054858e-33,  2.302786481662256e-22, -9.301325898726361e-23,  1.999909026321255e-23, -2.922473632015632e-24,  3.234875181638100e-25, -2.883565493835943e-26,
  2.152981801303700e-27, -1.383771347114244e-28,  7.811459663792701e-30, -3.933040106985064e-31,  1.787851504936237e-32, -7.400025989887670e-34,  5.570987343841808e-23,
 -2.337585583937381e-23,  5.239569438970307e-24, -7.980462288805132e-25,  9.198621612233436e-26, -8.528695786015948e-27,  6.615378556555240e-28, -4.411782655479584e-29,
  2.581082580566406e-30, -1.345295598111483e-31,  6.323494589568935e-33, -2.703291281726554e-34,  1.596277905047650e-23, -6.881198500134423e-24,  1.588990054987436e-24,
 -2.493288570003740e-25,  2.958792056317696e-26, -2.822096544368662e-27,  2.249927931914214e-28, -1.540908753754666e-29,  9.250040435722353e-31, -4.942856797388779e-32,
  2.380054978350748e-33, -1.041423165758795e-34,  4.350726156196378e-24, -1.904278748275508e-24,  4.472342237793364e-25, -7.137462135655475e-26,  8.611831645213225e-27,
 -8.347708202060631e-28,  6.760327496641746e-29, -4.700742932691715e-30,  2.863603978318324e-31, -1.552106097547240e-32,  7.577131213472730e-34, -3.359773336748045e-35,
  6.204559540749823e-02, -1.588140473891901e-04,  4.203282156050664e-07, -1.144925107895457e-09,  3.188367272116468e-12, -9.031502005229013e-15,  2.583775294812654e-17,
 -7.458910296092848e-20,  2.152887830097539e-22, -6.267937610731510e-25,  1.801089523923238e-27, -5.296988101128655e-30,  5.610532947628415e-02, -1.703692110431136e-04,
  6.229591831219365e-07, -2.412936477433923e-09,  9.348866300004183e-12, -3.565472585792053e-14,  1.335136008249438e-16, -4.918573967656589e-19,  1.785270465008809e-21,
 -6.401912854581948e-24,  2.268501685451424e-26, -7.968023404945920e-29,  4.587611116537434e-02, -1.832023955191188e-04,  9.387634891480507e-07, -4.719385817554654e-09,
  2.262553556273287e-11, -1.043142627562436e-13,  4.663510281060490e-16, -2.032970105628009e-18,  8.674143732419273e-21, -3.632565916758556e-23,  1.496225804086473e-25,
 -6.072112718500138e-28,  3.391965587104144e-02, -1.843845560807282e-04,  1.230532460119120e-06, -7.512150447395252e-09,  4.279428859716787e-11, -2.319280124057974e-13,
  1.208556694594007e-15, -6.095450354165370e-18,  2.989806779898786e-20, -1.431315747244155e-22,  6.706981862359396e-25, -3.083082967345565e-27,  2.267723241607885e-02,
 -1.671975424667003e-04,  1.377351776765664e-06, -9.951718943533948e-09,  6.626825416640489e-11, -4.157252716396173e-13,  2.486574787133746e-15, -1.429509747484172e-17,
  7.945672088735442e-20, -4.289086011476581e-22,  2.256367321044334e-24, -1.159996980865091e-26,  1.370864461125978e-02, -1.345685582241895e-04,  1.327823180139016e-06,
 -1.121334249246469e-08,  8.629082954838713e-11, -6.194088842707836e-13,  4.205638316677200e-15, -2.727073442811375e-17,  1.700594374395681e-19, -1.025217139802281e-21,
  5.999463501952963e-24, -3.418871182954740e-26,  7.493087513507376e-03, -9.577090128775184e-05,  1.113371531642922e-06, -1.089455991222312e-08,  9.600039995198135e-11,
 -7.815493140101779e-13,  5.974141290318935e-15, -4.335364263629207e-17,  3.010630463624560e-19, -2.012587711691004e-21,  1.301133313436359e-23, -8.164596284875113e-26,
  3.703335309939460e-03, -6.031290000131734e-05,  8.180440408866797e-07, -9.208756658700260e-09,  9.223079779173571e-11, -8.457554279890372e-13,  7.231789359554015e-15,
 -5.837800729274037e-17,  4.488499428622268e-19, -3.308848066062918e-21,  2.350720972570421e-23, -1.615926368257843e-25,  1.655041906576610e-03, -3.368496778424778e-05,
  5.295302258465395e-07, -6.815099422001181e-09,  7.711763654129049e-11, -7.921921775983682e-13,  7.538656410877235e-15, -6.736773134666688e-17,  5.708534695434299e-19,
 -4.620223313373924e-21,  3.591708875794291e-23, -2.693692857308996e-25,  6.688782933358058e-04, -1.672697029380254e-05,  3.032015155159227e-07, -4.437480729181506e-09,
  5.645416342912643e-11, -6.467623830756438e-13,  6.821250296507649e-15, -6.721568678954562e-17,  6.253755205022208e-19, -5.537163260460317e-21,  4.694006660721959e-23,
 -3.828000078043956e-25,  2.444979232518238e-04, -7.403274339480145e-06,  1.540562883370228e-07, -2.552100699553932e-09,  3.635548655562883e-11, -4.627941235526228e-13,
  5.391030978032636e-15, -5.838788057233164e-17,  5.946422208201314e-19, -5.742925880232696e-21,  5.293946159277249e-23, -4.681686476492500e-25,  8.085397044768234e-05,
 -2.927148339379411e-06,  6.964542356899701e-08, -1.300742791944108e-09,  2.067716320414903e-11, -2.915650475122168e-13,  3.740603077695789e-15, -4.440890881085593e-17,
  4.938094393864959e-19, -5.189319482537846e-21,  5.189557372377773e-23, -4.965533302846341e-25,  2.419845785524371e-05, -1.036084273485886e-06,  2.808013121887617e-08,
 -5.892201647944534e-10,  1.042173001611856e-11, -1.623593371477238e-13,  2.288564830192630e-15, -2.971629902669721e-17,  3.600131934040374e-19, -4.108313450980015e-21,
  4.448491151179738e-23, -4.596694842752717e-25,  6.557934080147492e-06, -3.289610660945039e-07,  1.011960127772996e-08, -2.378547016246801e-10,  4.669277524983064e-12,
 -8.018940620400240e-14,  1.239380026236869e-15, -1.756800382696426e-17,  2.314786482890737e-19, -2.863635998935509e-21,  3.351923043518234e-23, -3.734620960510936e-25,
  1.610512272715588e-06, -9.387585219344645e-08,  3.266907008922216e-09, -8.578321159155193e-11,  1.864983015715523e-12, -3.524116315737524e-14,  5.962075147219115e-16,
 -9.211214166256930e-18,  1.318037795032901e-19, -1.765172263081085e-21,  2.230526212492695e-23, -2.676189848954454e-25,  3.587740786034219e-07, -2.412775153673582e-08,
  9.468977005685696e-10, -2.771167981070344e-11,  6.659631885546378e-13, -1.382387553773362e-14,  2.556284917674467e-16, -4.298886942561838e-18,  6.671974127205588e-20,
 -9.661853897932905e-22,  1.316565159196662e-23, -1.699198585682291e-25,  7.259899135163801e-08, -5.597642806587388e-09,  2.470151906033620e-10, -8.040123501794742e-12,
  2.132290998224508e-13, -4.855404288678946e-15,  9.801797512062986e-17, -1.792251843426088e-18,  3.013979187810603e-20, -4.714935336908786e-22,  6.921851722922426e-24,
 -9.601388866156441e-26,  1.336827413447134e-08, -1.175221412247353e-09,  5.815489384115901e-11, -2.101259510621399e-12,  6.140816085939474e-14, -1.532081886763874e-15,
  3.372968636680909e-17, -6.699613370396276e-19,  1.219735395993538e-20, -2.059620041898309e-22,  3.255167241401614e-24, -4.849339465716954e-26,  2.245319512940220e-09,
 -2.239485643252936e-10,  1.239539200379322e-11, -4.963155529353250e-13,  1.596257305852874e-14, -4.358942760532431e-16,  1.045627057589415e-17, -2.254346328480788e-19,
  4.440235915578515e-21, -8.087820695353529e-23,  1.375282813884654e-24, -2.199095538285086e-26,  3.450355728623103e-10, -3.887172288242473e-11,  2.400831605164773e-12,
 -1.063588920506549e-13,  3.760181986774502e-15, -1.122816028306379e-16,  2.932495763980516e-18, -6.858059630237226e-20,  1.460499006889581e-21, -2.868122408819445e-23,
  5.244628976275027e-25, -8.997067300907396e-27,  4.870080997268035e-11, -6.172409330983032e-12,  4.244541927156489e-13, -2.077369499679385e-14,  8.064384580837099e-16,
 -2.631060184124633e-17,  7.476510299092334e-19, -1.895545397554227e-20,  4.362453451068953e-22, -9.232114550056288e-24,  1.814647235529345e-25, -3.338394248050090e-27,
  6.345596669092998e-12, -9.014095963960930e-13,  6.886928493618916e-14, -3.718483749906795e-15,  1.583446058806529e-16, -5.640070439716140e-18,  1.742694511910584e-19,
 -4.787424406260349e-21,  1.190143860380078e-22, -2.713117669064525e-24,  5.730231275091419e-26, -1.130113583974399e-27,  7.681401451096270e-13, -1.218700100251771e-13,
  1.032367652838871e-14, -6.140878210531566e-16,  2.865577172255568e-17, -1.113480023934515e-18,  3.738713738398508e-20, -1.112314574590158e-21,  2.985628374694959e-23,
 -7.328816347913031e-25,  1.662621919636102e-26, -3.513967782970667e-28,  8.708443122647570e-14, -1.537906106516669e-14,  1.441491542530646e-15, -9.433042014067970e-17,
  4.818665718724830e-18, -2.040973279154733e-19,  7.442152181142863e-21, -2.396583105327102e-22,  6.942339763577972e-24, -1.834207261930821e-25,  4.467798076790748e-27,
 -1.011550188532679e-28,  9.340639854760116e-15, -1.829913906664367e-15,  1.893833483624368e-16, -1.361363992743932e-17,  7.604127632386079e-19, -3.507584778165857e-20,
  1.387927674837876e-21, -4.834724890801475e-23,  1.510583835637107e-24, -4.293467425597885e-26,  1.122353739684760e-27, -2.720887831623750e-29,  9.599705647911217e-16,
 -2.079047136522541e-16,  2.370413600083573e-17, -1.868636111941386e-18,  1.139803084144347e-19, -5.719632424112764e-21,  2.453718361070006e-22, -9.238242934034596e-24,
  3.111033965118764e-25, -9.505942281391224e-27,  2.665113911695318e-28, -6.913750692296106e-30,  9.603469382180155e-17, -2.290735671956036e-17,  2.870065182695068e-18,
 -2.476379994020880e-19,  1.646879340436730e-20, -8.978243278439298e-22,  4.170893779567389e-23, -1.695460674567280e-24,  6.147751274858828e-26, -2.017581650198366e-27,
  6.061316487115607e-29, -1.681155462259979e-30,  9.534828897862197e-18, -2.494746858971068e-18,  3.424829172058320e-19, -3.226795657641556e-20,  2.335014431156854e-21,
 -1.380540084677047e-22,  6.933959658474939e-24, -3.038799638046059e-25,  1.184821317735602e-26, -4.170917920496866e-28,  1.341050355364138e-29, -3.971957730069085e-31,
  9.619650494340750e-19, -2.748121957543143e-19,  4.119481443590290e-20, -4.225909235392088e-21,  3.318965248743035e-22, -2.123198383611263e-23,  1.150523607467873e-24,
 -5.425214991131150e-26,  2.270256901099066e-27, -8.557344982657885e-29,  2.939543183964519e-30, -9.281678082466464e-32,  1.014420451704817e-19, -3.147395607188014e-20,
  5.130115902627795e-21, -5.709003428262093e-22,  4.850340334670169e-23, -3.347079567042538e-24,  1.951225067718551e-25, -9.873268571997471e-27,  4.422950884146896e-28,
 -1.780702814516631e-29,  6.519675142555539e-31, -2.189539463334478e-32,  1.155511941576462e-20, -3.869737809763061e-21,  6.823148406801362e-22, -8.198980561227289e-23,
  7.503160340645886e-24, -5.562962640225057e-25,  3.475688117385203e-26, -1.880447075731583e-27,  8.986791965697964e-29, -3.851708070139076e-30,  1.498243870984493e-31,
 -5.334923657755291e-33,  1.475250754358781e-21, -5.294440707106403e-22,  1.003444054457223e-22, -1.294398761025284e-23,  1.268941080671714e-24, -1.005576085164297e-25,
  6.700266917046435e-27, -3.857611096526894e-28,  1.957815456788563e-29, -8.893557957372926e-31,  3.659701929133703e-32, -1.375971164920945e-33,  2.194800485316893e-22,
 -8.370940179448473e-23,  1.692196806543662e-23, -2.326235650188513e-24,  2.426068784251782e-25, -2.041319914794266e-26,  1.441359966458543e-27, -8.777116520837304e-29,
  4.702798717009436e-30, -2.251345557665251e-31,  9.746709471578484e-33, -3.848715645353792e-34,  3.945228744183622e-23, -1.583921390460235e-23,  3.383523194974813e-24,
 -4.912667780454381e-25,  5.404024176026091e-26, -4.788278733321655e-27,  3.554497802883353e-28, -2.271887829159359e-29,  1.275652339951167e-30, -6.389914875060963e-32,
  2.890344666641357e-33, -1.190663519988095e-34,  8.764345200020022e-24, -3.664482975073271e-24,  8.181999917511862e-25, -1.241438460735426e-25,  1.425606038638826e-26,
 -1.317024781977993e-27,  1.018022283014412e-28, -6.766498332994862e-30,  3.945966706582225e-31, -2.050327222057087e-32,  9.608744552616836e-34, -4.095977903429408e-35,
  2.355843872058009e-24, -1.013843990553135e-24,  2.336801504777166e-25, -3.659902485720606e-26,  4.335379014288719e-27, -4.127853304132709e-28,  3.285383802359746e-29,
 -2.246388430694640e-30,  1.346377102787634e-31, -7.183567562781722e-33,  3.453911571840978e-34, -1.509167107868445e-35,  6.185060980333602e-25, -2.705546323000679e-25,
  6.349960434811878e-26, -1.012719958106102e-26,  1.221110547868982e-27, -1.182896949403838e-28,  9.573583855035382e-30, -6.652847868079455e-31,  4.050376574925063e-32,
 -2.194078357271759e-33,  1.070509574858101e-34, -4.744145119888773e-36,  6.141697866158836e-02, -1.555055243460856e-04,  4.068893440087203e-07, -1.095323275777240e-09,
  3.013773061249751e-12, -8.435699752442942e-15,  2.384241178401039e-17, -6.804743435332103e-20,  1.939666737352439e-22, -5.592097742168920e-25,  1.582910302151637e-27,
 -4.637649992720506e-30,  5.543364011577902e-02, -1.654988687242622e-04,  5.948784558794762e-07, -2.268889840042571e-09,  8.666731996202179e-12, -3.260941484299838e-14,
  1.205079577158631e-16, -4.382477459715618e-19,  1.570324227680208e-21, -5.560890745394834e-24,  1.945466249515196e-26, -6.751249675657693e-29,  4.515797160982438e-02,
 -1.759128186801044e-04,  8.842359816485901e-07, -4.373478213500880e-09,  2.064672089930679e-11, -9.377471863021536e-14,  4.131252294148725e-16, -1.775216274051002e-18,
  7.468009414259271e-21, -3.084246686466472e-23,  1.253050888468392e-25, -5.016830673930672e-28,  3.320125122342512e-02, -1.748895821468403e-04,  1.144346784908920e-06,
 -6.863030496741668e-09,  3.843249665919607e-11, -2.048671940113561e-13,  1.050539225262539e-15, -5.216232202717873e-18,  2.519725107078662e-20, -1.188309403292433e-22,
  5.486798017041874e-25, -2.485810053294053e-27,  2.202974818363394e-02, -1.566389972881486e-04,  1.264028666668556e-06, -8.954831523793689e-09,  5.851953193666260e-11,
 -3.605769822764775e-13,  2.119706057150656e-15, -1.198306567493148e-17,  6.552472514384020e-20, -3.480875160454798e-22,  1.802687257083465e-24, -9.125823140966653e-27,
  1.319079527296172e-02, -1.244616492338746e-04,  1.201155260963646e-06, -9.926559463857301e-09,  7.485319419279647e-11, -5.270541134340134e-13,  3.513009831399388e-15,
 -2.237583079248332e-17,  1.371318157423642e-19, -8.128187023910735e-22,  4.678344473815249e-24, -2.623043221952736e-26,  7.127025225587022e-03, -8.736189511603435e-05,
  9.913611809486608e-07, -9.476205087143998e-09,  8.171023623760918e-11, -6.517116249998405e-13,  4.884900840500800e-15, -3.478505490838026e-17,  2.371725706316935e-19,
 -1.557454878165301e-21,  9.895129125232339e-24, -6.104305582369387e-26,  3.474506344763841e-03, -5.418670814266537e-05,  7.158640148781784e-07, -7.859482415924255e-09,
  7.692686096873842e-11, -6.902883580315355e-13,  5.781599991617435e-15, -4.575227628169456e-17,  3.450727370930484e-19, -2.496740587996780e-21,  1.741780767894254e-23,
 -1.176233790728093e-25,  1.528284673858475e-03, -2.975601805699455e-05,  4.546596552614851e-07, -5.698743656397241e-09,  6.294033079012922e-11, -6.319800939929928e-13,
  5.884947937269688e-15, -5.150601781858929e-17,  4.277632100392673e-19, -3.395328296325097e-21,  2.589949531272085e-23, -1.906837756521851e-25,  6.065048392707088e-04,
 -1.449993002088107e-05,  2.549716408648312e-07, -3.629402631928722e-09,  4.501452076160491e-11, -5.035474923342235e-13,  5.191816746638707e-15, -5.006126050697089e-17,
  4.561336504018916e-19, -3.957773511284337e-21,  3.289825342196471e-23, -2.632026661333987e-25,  2.171688542673425e-04, -6.284096558882493e-06,  1.266371035212586e-07,
 -2.037949548159481e-09,  2.827138000408822e-11, -3.510548415379091e-13,  3.994185292292468e-15, -4.229571742270539e-17,  4.215200864569642e-19, -3.986580432279974e-21,
  3.601020616479767e-23, -3.122264063325318e-25,  7.016824065665579e-05, -2.427209880672401e-06,  5.584380272350854e-08, -1.012073567371643e-09,  1.565143234706716e-11,
 -2.150856371545732e-13,  2.692922195869329e-15, -3.123458416747729e-17,  3.396293787390868e-19, -3.492807303366823e-21,  3.420633712533062e-23, -3.207115120283148e-25,
  2.046232152204373e-05, -8.371197936721157e-07,  2.191176486867689e-08, -4.457268050032496e-10,  7.662592034855266e-12, -1.162419437627941e-13,  1.597797077168831e-15,
 -2.025486018832687e-17,  2.397998532685506e-19, -2.676385601684802e-21,  2.836381103104268e-23, -2.870394372812308e-25,  5.387571064265949e-06, -2.582633990832806e-07,
  7.665482416006494e-09, -1.745137379822260e-10,  3.327049327137449e-12, -5.559685045456324e-14,  8.373543825766669e-16, -1.158043651491144e-17,  1.490224284721858e-19,
 -1.802079991367502e-21,  2.063454979139635e-23, -2.250532895597687e-25,  1.281411252677442e-06, -7.139983336902825e-08,  2.395585564495441e-09, -6.088442672083301e-11,
  1.284593220572074e-12, -2.360363451554999e-14,  3.888944870669281e-16, -5.858712986675606e-18,  8.183191331222058e-20, -1.070743689156066e-21,  1.322982122511304e-23,
 -1.553172181956037e-25,  2.755378745709118e-07, -1.772062206417681e-08,  6.701438207021177e-10, -1.897171279725121e-11,  4.422092715319169e-13, -8.920796571028168e-15,
  1.605689755435032e-16, -2.631768594715297e-18,  3.985281660606089e-20, -5.636204712020691e-22,  7.506693063657520e-24, -9.476578876253552e-26,  5.362271501841239e-08,
 -3.956076090980234e-09,  1.681708599947642e-10, -5.292792213685096e-12,  1.360835509650772e-13, -3.010143784076376e-15,  5.912372329421950e-17, -1.053225799398612e-18,
  1.727487749549942e-20, -2.638296270413465e-22,  3.784543121817154e-24, -5.133357621047746e-26,  9.459006367709270e-09, -7.962114270389020e-10,  3.795057136162603e-11,
 -1.325542720970185e-12,  3.754401467604246e-14, -9.096170511926969e-16,  1.947807832173532e-17, -3.768081182132670e-19,  6.689099895867913e-21, -1.102430368430123e-22,
  1.702077837180237e-24, -2.478984780305617e-26,  1.515487507731550e-09, -1.448503197250082e-10,  7.723252500307789e-12, -2.989108321458475e-13,  9.315714678544490e-15,
 -2.469868267109731e-16,  5.761586933149177e-18, -1.209598315322067e-19,  2.322641758110372e-21, -4.128579988759604e-23,  6.857120785446968e-25, -1.071830011588655e-26,
  2.211253663424846e-10, -2.389624527572156e-11,  1.422204123317608e-12, -6.090587045628112e-14,  2.086524832935675e-15, -6.049004183864029e-17,  1.536240542824420e-18,
 -3.498249745093814e-20,  7.262413460696146e-22, -1.391710334156795e-23,  2.485593361839937e-25, -4.168100227747533e-27,  2.948759415999670e-11, -3.589012850249167e-12,
  2.379485880762956e-13, -1.126100664720159e-14,  4.236829444035392e-16, -1.342186442139003e-17,  3.709081911733239e-19, -9.157193717248973e-21,  2.054567580612766e-22,
 -4.243208295914524e-24,  8.146742829179781e-26, -1.465176111492666e-27,  3.610380837531059e-12, -4.931677151616843e-13,  3.635409628195254e-14, -1.898985279312626e-15,
  7.840184969234935e-17, -2.712373380494134e-18,  8.152353202404867e-20, -2.181349530274956e-21,  5.287853822203861e-23, -1.176643343924214e-24,  2.427946908828806e-26,
 -4.682128116722386e-28,  4.082838138661613e-13, -6.238383443278272e-14,  5.103744916551311e-15, -2.939187958333156e-16,  1.330544027628114e-17, -5.024087251834397e-19,
  1.641670139487833e-20, -4.759156085222473e-22,  1.246126161932851e-23, -2.986878122561781e-25,  6.622553856915825e-27, -1.369115993818025e-28,  4.297181127680887e-14,
 -7.321221366401904e-15,  6.635540877668948e-16, -4.208022194245005e-17,  2.087020758843432e-18, -8.596184054503412e-20,  3.052375767842082e-21, -9.583691823741813e-23,
  2.709682616875793e-24, -6.994500297062204e-26,  1.666024552029746e-27, -3.691583893478994e-29,  4.250623600442654e-15, -8.049676466431747e-16,  8.067625569983400e-17,
 -5.626958867045559e-18,  3.054821224438930e-19, -1.371603536174177e-20,  5.289811512859362e-22, -1.798056217296779e-23,  5.487662268271443e-25, -1.525004982782475e-26,
  3.901094324299832e-28, -9.262135675180802e-30,  4.000776596823974e-16, -8.394514443552294e-17,  9.284947778131143e-18, -7.112653361172740e-19,  4.222368076162505e-20,
 -2.064945942541573e-21,  8.643903712736291e-23, -3.179032591926711e-24,  1.046792639415039e-25, -3.130347762044870e-27,  8.596327345158819e-29, -2.185996238622642e-30,
  3.639435140115394e-17, -8.431724539804523e-18,  1.026962438629116e-18, -8.626177139350537e-20,  5.592330394798008e-21, -2.975713279930328e-22,  1.350779912781800e-23,
 -5.370818191672489e-25,  1.906639098124809e-26, -6.131280357815251e-28,  1.806317161105494e-29, -4.916602650435977e-31,  3.262789727218631e-18, -8.314732106144216e-19,
  1.112278543017353e-19, -1.022369718098626e-20,  7.226064777556153e-22, -4.177495677917401e-23,  2.053725669500880e-24, -8.817792661299986e-26,  3.371142453663060e-27,
 -1.164563485718916e-28,  3.677048707993890e-30, -1.070248914361157e-31,  2.953051754851546e-19, -8.241714716840125e-20,  1.207099071608673e-20, -1.211001864142344e-21,
  9.310803591730466e-23, -5.836481873300451e-24,  3.101844383540598e-25, -1.435702427976054e-26,  5.901712275983309e-28, -2.186785513399963e-29,  7.389214255836601e-31,
 -2.296542031027101e-32,  2.778428897160924e-20, -8.449402626740281e-21,  1.349625029021801e-21, -1.472876169577358e-22,  1.228163104686177e-23, -8.324908632344266e-25,
  4.770712573494852e-26, -2.374711503005524e-27,  1.047193487125419e-28, -4.152817556551541e-30,  1.498539200136830e-31, -4.962883282159768e-33,  2.813722989554444e-21,
 -9.267797289048117e-22,  1.606533744376676e-22, -1.898875197939926e-23,  1.710389824982309e-24, -1.248986605233113e-25,  7.690750852928962e-27, -4.103232466316352e-28,
  1.934871717557180e-29, -8.186796433576482e-31,  3.145380314717637e-32, -1.106783606705661e-33,  3.191787710435684e-22, -1.130570187776271e-22,  2.113723109801920e-23,
 -2.690589081020600e-24,  2.604098090805542e-25, -2.038401232524671e-26,  1.342279947499663e-27, -7.641060982617997e-29,  3.836087130043441e-30, -1.724488329256446e-31,
  7.025458729984994e-33, -2.616120991388696e-34,  4.234263261078221e-23, -1.599379716540392e-23,  3.200239945043059e-24, -4.355391725979211e-25,  4.498494050785794e-26,
 -3.749963339215450e-27,  2.624223711368407e-28, -1.584338202578315e-29,  8.419151817298154e-31, -3.998628361191625e-32,  1.717978325934937e-33, -6.734424587537257e-35,
  6.848388936552248e-24, -2.731587976334480e-24,  5.794403729925588e-25, -8.355257281691061e-26,  9.129711484542192e-27, -8.037538334861034e-28,  5.929710523014291e-29,
 -3.767549083938573e-30,  2.103402383687696e-31, -1.047851749714136e-32,  4.714779065533146e-34, -1.932417344321772e-35,  1.390198766019218e-24, -5.790332472843073e-25,
  1.287469701981117e-25, -1.945393527714426e-26,  2.225042107237584e-27, -2.047621842673171e-28,  1.576857885825898e-29, -1.044335806332417e-30,  6.069180255313806e-32,
 -3.143094118500008e-33,  1.468294357614245e-34, -6.239820755914428e-36,  3.491074067214968e-25, -1.499667113363203e-25,  3.449663105078816e-26, -5.392118048545676e-27,
  6.374903442967366e-28, -6.058346871095402e-29,  4.813126491622755e-30, -3.285225030569293e-31,  1.965681827305093e-32, -1.047078199677828e-33,  5.026523907360699e-35,
 -2.192993918876886e-36,  8.805750320797115e-26, -3.849490343033753e-26,  9.028443418257921e-27, -1.438874859031367e-27,  1.733745332297753e-28, -1.678343435471688e-29,
  1.357436986561560e-30, -9.426960791782041e-32,  5.735696766362343e-33, -3.105110862524538e-34,  1.514108634319969e-35, -6.706157446581598e-37,  6.080138468977350e-02,
 -1.523021779884169e-04,  3.940293183215997e-07, -1.048422163679559e-09,  2.850630460921191e-12, -7.885662598424752e-15,  2.202103911161726e-17, -6.215077428063764e-20,
  1.749272154109574e-22, -4.998027667168268e-25,  1.391521471530702e-27, -4.077092369741415e-30,  5.478099352448530e-02, -1.608464390041191e-04,  5.684627597235770e-07,
 -2.135286564378220e-09,  8.042500243674848e-12, -2.985897655622545e-14,  1.089114686099962e-16, -3.910558742517786e-19,  1.383452348937277e-21, -4.838985753297629e-24,
  1.671473645208996e-26, -5.732645382343594e-29,  4.446814347119126e-02, -1.690433809926297e-04,  8.336761369842057e-07, -4.057612345821368e-09,  1.886648572241343e-11,
 -8.443017386790156e-14,  3.666045772316451e-16, -1.553079436751816e-18,  6.442825132492238e-21, -2.624512288582675e-23,  1.051890480190471e-25, -4.155453583718368e-28,
  3.251949521152189e-02, -1.660540824303416e-04,  1.065549031910848e-06, -6.279567466560839e-09,  3.457590642587998e-11, -1.813195998473940e-13,  9.151589836949092e-16,
 -4.474335917442573e-18,  2.128938737660869e-20, -9.892345187403908e-23,  4.501545398367074e-25, -2.010352715714122e-27,  2.142275785680718e-02, -1.469412132236740e-04,
  1.161959234523184e-06, -8.073557192831421e-09,  5.179072129472281e-11, -3.135045095570098e-13,  1.811746297458792e-15, -1.007360488730844e-17,  5.420027241470039e-20,
 -2.834101626554907e-22,  1.445154030189135e-24, -7.205208733946600e-27,  1.271144046533563e-02, -1.153092943141468e-04,  1.088888875983452e-06, -8.808860480775532e-09,
  6.510693841344652e-11, -4.497900880597556e-13,  2.943767641163299e-15, -1.842182112203171e-17,  1.109780745725163e-19, -6.468734881937302e-22,  3.662717722884057e-24,
 -2.020877280292738e-26,  6.792749353331086e-03, -7.986458912880202e-05,  8.850805376489304e-07, -8.267061618526310e-09,  6.977370941524799e-11, -5.453533678954425e-13,
  4.009259324281662e-15, -2.802119547510382e-17,  1.876257651217741e-19, -1.210561952675154e-21,  7.559943164775212e-24, -4.585834349280529e-26,  3.268644231513311e-03,
 -4.881712940482613e-05,  6.285028974055031e-07, -6.731973702260765e-09,  6.441102466738353e-11, -5.657334233123754e-13,  4.642519576096199e-15, -3.602311245706644e-17,
  2.665764755528445e-19, -1.893493564776627e-21,  1.297382490987308e-23, -8.608602445256957e-26,  1.416125014160530e-03, -2.637607381907423e-05,  3.919234784943767e-07,
 -4.785605094722463e-09,  5.160384031887647e-11, -5.066067535765565e-13,  4.617377651998305e-15, -3.958868943449148e-17,  3.223198100886273e-19, -2.509564508364786e-21,
  1.878746516864593e-23, -1.358161245048785e-25,  5.523251599667858e-04, -1.262284792893680e-05,  2.154285578967876e-07, -2.983416279555232e-09,  3.608406490792766e-11,
 -3.942381966097160e-13,  3.974717355514181e-15, -3.751172848284168e-17,  3.347917276254064e-19, -2.847333625607841e-21,  2.321207736414439e-23, -1.822237663685122e-25,
  1.939139705329903e-04, -5.361633151590427e-06,  1.046798989653027e-07, -1.636944663656004e-09,  2.212030976049918e-11, -2.680048363099528e-13,  2.979007380730377e-15,
 -3.085016261707604e-17,  3.009284490074204e-19, -2.787665144740332e-21,  2.467916769319856e-23, -2.098349812306705e-25,  6.128159054474834e-05, -2.025087307685852e-06,
  4.507011344793756e-08, -7.928294399074617e-10,  1.193106716390713e-11, -1.598296093781832e-13,  1.953338812840956e-15, -2.213956463522089e-17,  2.354560831298990e-19,
 -2.370195361579672e-21,  2.273581119803885e-23, -2.089148305764211e-25,  1.743328079001977e-05, -6.813003852514313e-07,  1.722818979930116e-08, -3.398188097630322e-10,
  5.679416686958275e-12, -8.391510023649766e-14,  1.125035565342249e-15, -1.392642690153544e-17,  1.611537635253277e-19, -1.759444996023086e-21,  1.825304088409509e-23,
 -1.809378389763263e-25,  4.465076626163494e-06, -2.044891653767275e-07,  5.857277897696520e-09, -1.291858010002525e-10,  2.392362793519450e-12, -3.890720130995343e-14,
  5.711439322082959e-16, -7.707967152092882e-18,  9.689062970262034e-20, -1.145494470520722e-21,  1.283300195068983e-23, -1.370321954737318e-25,  1.029963890565144e-06,
 -5.484103155646144e-08,  1.774217175463190e-09, -4.365127233403607e-11,  8.939580852139297e-13, -1.597506162148830e-14,  2.563737672669948e-16, -3.766732292870351e-18,
  5.136430393165773e-20, -6.567367543996761e-22,  7.935391643042996e-24, -9.116901380146928e-26,  2.140893419067281e-07, -1.316214669546664e-08,  4.796631727465625e-10,
 -1.313699298292298e-11,  2.970331973749942e-13, -5.824169496552050e-15,  1.020534708247583e-16, -1.630455902407167e-18,  2.409279946232974e-20, -3.328037118111948e-22,
  4.332904211540692e-24, -5.350932842817755e-26,  4.013369124300315e-08, -2.831868610406715e-09,  1.159595007954782e-10, -3.528986882907061e-12,  8.797072416313553e-14,
 -1.890423699862835e-15,  3.612991727884359e-17, -6.270937421192186e-19,  1.003267660805810e-20, -1.496014044012337e-22,  2.097028500490747e-24, -2.781647207863700e-26,
  6.793410666320248e-09, -5.472547265854053e-10,  2.512136438361812e-11, -8.481725844725258e-13,  2.328281113036567e-14, -5.478081942654383e-16,  1.141014545631916e-17,
 -2.149918855965024e-19,  3.721531269149394e-21, -5.986699901083520e-23,  9.029782058466520e-25, -1.285804737202496e-26,  1.040078500251409e-09, -9.520991232148415e-11,
  4.889139149579463e-12, -1.828805115102658e-13,  5.522622189299345e-15, -1.421572326258108e-16,  3.224807544989152e-18, -6.592587744246180e-20,  1.234106322225073e-21,
 -2.140745102035652e-23,  3.472863784802186e-25, -5.306455466993319e-27,  1.443613937646779e-10, -1.495496939040262e-11,  8.573977833295986e-13, -3.548772844376627e-14,
  1.177912903814315e-15, -3.315058568099902e-17,  8.186152661670011e-19, -1.814980307805359e-20,  3.672897162335470e-22, -6.867947866489309e-24,  1.197988362690689e-25,
 -1.963646487044296e-27,  1.822216908207463e-11, -2.128353790169612e-12,  1.359887938954311e-13, -6.221333100665568e-15,  2.268085807400924e-16, -6.975388478065685e-18,
  1.874322123969905e-19, -4.505529597298141e-21,  9.854072051060654e-23, -1.985854686412589e-24,  3.723854260712617e-26, -6.546624961705592e-28,  2.100482461776689e-12,
 -2.756837630114305e-13,  1.959760472537446e-14, -9.899976897189929e-16,  3.961637082864520e-17, -1.330851573201788e-18,  3.890131080419710e-20, -1.013637333645621e-21,
  2.395605202628069e-23, -5.202404425877175e-25,  1.048625832232260e-26, -1.977028583505777e-28,  2.223242592203878e-13, -3.268707056470989e-14,  2.581122633335096e-15,
 -1.438411656802306e-16,  6.314436722879333e-18, -2.316184148881194e-19,  7.363094551787155e-21, -2.079336998382021e-22,  5.309723145101130e-24, -1.242461094607303e-25,
  2.691799331651252e-27, -5.442214060601057e-29,  2.176263997672178e-14, -3.573676866828241e-15,  3.129783165395376e-16, -1.922340723493289e-17,  9.252134698055471e-19,
 -3.704281604216597e-20,  1.280385440115691e-21, -3.918176252849133e-23,  1.080936644678856e-24, -2.725219009821004e-26,  6.345705360188216e-28, -1.375715009077757e-29,
  1.988500983964759e-15, -3.636518912009973e-16,  3.526679023353361e-17, -2.385070524604371e-18,  1.257764403318412e-19, -5.494171762703773e-21,  2.064254775144104e-22,
 -6.843793825917272e-24,  2.039469285908714e-25, -5.539327431079277e-27,  1.386148696521824e-28, -3.222028026653918e-30,  1.716433156211069e-16, -3.485446865675147e-17,
  3.736690339661096e-18, -2.779484482400253e-19,  1.604791948689135e-20, -7.644063457766661e-22,  3.120545852951619e-23, -1.120505138629603e-24,  3.605968397329870e-26,
 -1.054870860639205e-27,  2.836177375661869e-29, -7.066930262975950e-31,  1.421236784836373e-17, -3.194471084433674e-18,  3.778752131637291e-19, -3.087378664424433e-20,
  1.949710795565930e-21, -1.011908747712910e-22,  4.485568827334836e-24, -1.743476851462727e-25,  6.056264213540731e-27, -1.907346875568814e-28,  5.507636074925413e-30,
 -1.470489984252089e-31,  1.151030006983734e-18, -2.853607457592763e-19,  3.716032486405749e-20, -3.329263879517465e-21,  2.296493566873744e-22, -1.297207691479962e-23,
  6.237758898713142e-25, -2.622168817381465e-26,  9.823783303511214e-28, -3.328288120120039e-29,  1.031433484215480e-30, -2.948661208690561e-32,  9.343014477039710e-20,
 -2.544528484491474e-20,  3.637533708147773e-21, -3.565570707818339e-22,  2.681387896732583e-23, -1.645717133012642e-24,  8.571686907350994e-26, -3.891631610673472e-27,
  1.570420430870346e-28, -5.716606568931784e-30,  1.899000448992141e-31, -5.806121077089543e-33,  7.833885929596849e-21, -2.332485109112650e-21,  3.647341627419356e-22,
 -3.899806281378689e-23,  3.188846473603353e-24, -2.121459547980938e-25,  1.194183344441432e-26, -5.843349935808943e-28,  2.534831913384820e-29, -9.895167569392362e-31,
  3.517015573465287e-32, -1.147960691336954e-33,  7.037539317862925e-22, -2.277521527420754e-22,  3.877639209569441e-23, -4.504169241807386e-24,  3.989902221168364e-25,
 -2.867364270174927e-26,  1.738791361370887e-27, -9.141917448857731e-29,  4.250670494491938e-30, -1.774429282186293e-31,  6.729573781204356e-33, -2.338692262268298e-34,
  7.069425923781446e-23, -2.469291857797351e-23,  4.550148753069288e-24, -5.710774671061745e-25,  5.452655361105735e-26, -4.212936340639661e-27,  2.739793266307366e-28,
 -1.541103458069056e-29,  7.648599360332142e-31, -3.400704929722133e-32,  1.370841293010894e-33, -5.053136692582295e-35,  8.326157176672142e-24, -3.112456700638682e-24,
  6.159963643223100e-25, -8.294079209180565e-26,  8.478474705422561e-27, -6.997835296930090e-28,  4.850632553060124e-29, -2.901847456129245e-30,  1.528567637042356e-31,
 -7.198952298621127e-33,  3.068048244140001e-34, -1.193371174008953e-35,  1.205550534200867e-24, -4.774789801443987e-25,  1.005253848676290e-25, -1.438824277640413e-26,
  1.560957088989182e-27, -1.364772197699337e-28,  1.000211432025100e-29, -6.314708756638612e-31,  3.503992271477776e-32, -1.735370563118310e-33,  7.764356696789999e-35,
 -3.165175277146681e-36,  2.224693859814626e-25, -9.227700202281172e-26,  2.042534225939255e-26, -3.072586132494645e-27,  3.499104212268761e-28, -3.206694020846022e-29,
  2.459563934640659e-30, -1.622673003259438e-31,  9.395315746204275e-33, -4.848325523023705e-34,  2.257149399626190e-35, -9.560768893588238e-37,  5.196152374166540e-26,
 -2.227742827126230e-26,  5.113394007831895e-27, -7.975531512394934e-28,  9.409483661592217e-29, -8.924169935880198e-30,  7.076089744134443e-31, -4.820745151493703e-32,
  2.879221515808248e-33, -1.531025841082595e-34,  7.337367635547244e-36, -3.196004852156173e-37,  1.255651528818581e-26, -5.485472001763016e-27,  1.285575715081227e-27,
 -2.047294010484258e-28,  2.465019658870349e-29, -2.384522649258669e-30,  1.927232767403804e-31, -1.337483863308367e-32,  8.132307275002522e-34, -4.399705844807609e-35,
  2.144027935026372e-36, -9.490355024223938e-38,  6.019840184589925e-02, -1.491995041367523e-04,  3.817167997715195e-07, -1.004045647390085e-09,  2.698064500244302e-12,
 -7.377424032986066e-15,  2.035655449217391e-17, -5.683058931204725e-20,  1.578943116253735e-22, -4.475844439794695e-25,  1.222840635448561e-27, -3.603827416884780e-30,
  5.414654392046841e-02, -1.563990876024251e-04,  5.435921441320526e-07, -2.011245611040461e-09,  7.470597737616270e-12, -2.737164998946739e-14,  9.855639438079333e-17,
 -3.494483916800235e-19,  1.220699668164582e-21, -4.218220083930841e-24,  1.438573348361111e-26, -4.878389140737684e-29,  4.380500746623154e-02, -1.625637309049697e-04,
  7.867417566731402e-07, -3.768793726786947e-09,  1.726246176124291e-11, -7.613104629508129e-14,  3.258682890546113e-16, -1.361248603806002e-18,  5.569530504245447e-21,
 -2.238146704006670e-23,  8.850684537098712e-26, -3.450494271695257e-28,  3.187186334248248e-02, -1.578219728254594e-04,  9.933975908827426e-07, -5.754211984037773e-09,
  3.115938912267427e-11, -1.607853491760792e-13,  7.989036596893108e-16, -3.846746072794044e-18,  1.803202188616642e-20, -8.256843099972128e-23,  3.703595812316116e-25,
 -1.630663333766706e-27,  2.085299003946314e-02, -1.380194446564980e-04,  1.069848943491332e-06, -7.292796348073479e-09,  4.593357757348769e-11, -2.732203847797228e-13,
  1.552509357426789e-15, -8.491875418624387e-18,  4.496592030915813e-20, -2.314770314871073e-22,  1.162390635170882e-24, -5.708730412419805e-27,  1.226698016677134e-02,
 -1.070039591057364e-04,  9.891479269278826e-07, -7.835445629166542e-09,  5.677784639181710e-11, -3.849486479380684e-13,  2.474365904659863e-15, -1.521649703711318e-17,
  9.012675310841885e-20, -5.167104878828055e-22,  2.878718914383738e-24, -1.563283359846572e-26,  6.486849730180490e-03, -7.316258158356324e-05,  7.922303756298793e-07,
 -7.232965784146654e-09,  5.976865499233066e-11, -4.579060862159655e-13,  3.302564949102235e-15, -2.265982094786754e-17,  1.490352360765416e-19, -9.449642841135538e-22,
  5.801731107762733e-24, -3.461180363687972e-26,  3.082943777904494e-03, -4.409554338281868e-05,  5.535480003124709e-07, -5.786187180286949e-09,  5.413358745804127e-11,
 -4.655123581868746e-13,  3.743724464971376e-15, -2.849012461271070e-17,  2.069058773879776e-19, -1.443061611004136e-21,  9.713155023388044e-24, -6.333926415032002e-26,
  1.316546636280092e-03, -2.345709150446188e-05,  3.391343478364627e-07, -4.035336605583473e-09,  4.249577600282915e-11, -4.080045490733042e-13,  3.640681970898129e-15,
 -3.058585675131790e-17,  2.441763039117956e-19, -1.865262031704950e-21,  1.370748981069112e-23, -9.731640903064649e-26,  5.050669921247167e-04, -1.103337583830486e-05,
  1.828472989198114e-07, -2.464302805503092e-09,  2.907403335212757e-11, -3.103269887643285e-13,  3.060158068887717e-15, -2.827384719220599e-17,  2.472329333112991e-19,
 -2.061420090166318e-21,  1.648479203630381e-23, -1.270082147688083e-25,  1.740258957370349e-04, -4.597134091190458e-06,  8.699505506389288e-08, -1.322291096063379e-09,
  1.741046033326955e-11, -2.058724955359567e-13,  2.236192396664959e-15, -2.265232669556246e-17,  2.163203028352089e-19, -1.963178457869418e-21,  1.703728251319576e-23,
 -1.420800166562082e-25,  5.384638896329594e-05, -1.699564342789965e-06,  3.660376487210462e-08, -6.251543512378071e-10,  9.157150894047625e-12, -1.196099473376440e-13,
  1.427242256529310e-15, -1.581121313619880e-17,  1.645010546973796e-19, -1.621192214180095e-21,  1.523483508750060e-23, -1.372227489567240e-25,  1.495992803802134e-05,
 -5.583600061370850e-07,  1.364461771050187e-08, -2.610303109453699e-10,  4.242318546553258e-12, -6.106464265664377e-14,  7.986915026325406e-16, -9.656262087050212e-18,
  1.092387965233484e-19, -1.166888401660455e-21,  1.185250645193293e-23, -1.151053481719737e-25,  3.731864667073668e-06, -1.632357784818287e-07,  4.513262548262747e-09,
 -9.645590873938742e-11,  1.735472658991983e-12, -2.747410068412714e-14,  3.931718588197299e-16, -5.178907156165270e-18,  6.360246504805556e-20, -7.352732028715819e-22,
  8.060638100059467e-24, -8.428209046410214e-26,  8.359835423657089e-07, -4.252167409026936e-08,  1.326670759667914e-09, -3.160241888155411e-11,  6.283181951506688e-13,
 -1.092181515101228e-14,  1.707573669585582e-16, -2.447167968657648e-18,  3.258410110002921e-20, -4.071632580051210e-22,  4.811902120354534e-24, -5.410884569250630e-26,
  1.682203457265308e-07, -9.882683242657658e-09,  3.470826402860025e-10, -9.197336653111288e-12,  2.017520501802449e-13, -3.845579213860396e-15,  6.560735797630485e-17,
 -1.021853418057443e-18,  1.473638498002254e-20, -1.988472970718557e-22,  2.530997081704543e-24, -3.058008892063066e-26,  3.042371051437042e-08, -2.052250482176630e-09,
  8.094691163934570e-11, -2.382185406321109e-12,  5.757948697267025e-14, -1.202182802655471e-15,  2.235917401763770e-17, -3.781560591215289e-19,  5.901863385998011e-21,
 -8.593290286962164e-23,  1.177188876893731e-24, -1.527181010317730e-26,  4.949825719529118e-09, -3.814084323947032e-10,  1.686002563610184e-11, -5.502459595139119e-13,
  1.463940462765903e-14, -3.345120238365799e-16,  6.777563800984193e-18, -1.243904186528864e-19,  2.099735473860517e-21, -3.297144562083705e-23,  4.858625747513046e-25,
 -6.764521907340096e-27,  7.254329323045004e-10, -6.356448774365994e-11,  3.143002802451046e-12, -1.136141537705018e-13,  3.324268507891997e-15, -8.307687871152687e-17,
  1.832662494998153e-18, -3.648313275611152e-20,  6.658103222011562e-22, -1.127102831510815e-23,  1.785971971670793e-25, -2.667656811818807e-27,  9.595649312479879e-11,
 -9.523029403455785e-12,  5.257827453848537e-13, -2.102926449627781e-14,  6.762077598661645e-16, -1.847317857047687e-17,  4.435252492824675e-19, -9.573950809634304e-21,
  1.888505833502939e-22, -3.445660007028055e-24,  5.869876507433954e-26, -9.404356295783270e-28,  1.148663762655218e-11, -1.286579729797267e-12,  7.919095045499541e-14,
 -3.501283432479890e-15,  1.236605993895825e-16, -3.691572266458022e-18,  9.643952615341894e-20, -2.256916533315059e-21,  4.811222925868410e-23, -9.460338438575334e-25,
  1.732492520015782e-26, -2.977010376644534e-28,  1.248978384240031e-12, -1.573827542042484e-13,  1.078371407419865e-14, -5.266322575393846e-16,  2.042030714016249e-17,
 -6.659606084953488e-19,  1.892769949386790e-20, -4.801926989255662e-22,  1.106259027136902e-23, -2.344252007410750e-25,  4.615105586464168e-27, -8.505574080931562e-29,
  1.239706646358716e-13, -1.752320721257516e-14,  1.334768544924829e-15, -7.194820595558166e-17,  3.061681668027058e-18, -1.090615623032625e-19,  3.372070078331392e-21,
 -9.274112596726648e-23,  2.309052792745561e-24, -5.273590892471803e-26,  1.116167973089363e-27, -2.206458966112801e-29,  1.130735922225062e-14, -1.787975400564668e-15,
  1.512058404751139e-16, -8.990004943322567e-18,  4.196938491723140e-19, -1.632682368271290e-20,  5.491428414557744e-22, -1.637318807637820e-23,  4.406026655956784e-25,
 -1.084642083197816e-26,  2.468315507708315e-28, -5.234239943825823e-30,  9.560488277708625e-16, -1.686688277062268e-16,  1.581570576652169e-17, -1.036453190956518e-18,
  5.306286525163054e-20, -2.253917695854673e-21,  8.246189028163757e-23, -2.665495141875455e-24,  7.752953336360413e-26, -2.057339412193073e-27,  5.034397566489023e-29,
 -1.145301113029995e-30,  7.579713810844713e-17, -1.487974929768583e-17,  1.544868058021410e-18, -1.114990990844249e-19,  6.257089014948052e-21, -2.901187846602278e-22,
  1.154394356887092e-23, -4.045015050809894e-25,  1.271654590988947e-26, -3.637493732420127e-28,  9.571282954551492e-30, -2.335913672340746e-31,  5.719424295358942e-18,
 -1.245780985446398e-18,  1.429850925589920e-19, -1.135404653655536e-20,  6.979360484621626e-22, -3.530755770164047e-23,  1.527417153500301e-24, -5.800281885143299e-26,
  1.970443149000904e-27, -6.074488944480035e-29,  1.718415120197066e-30, -4.498320255941439e-32,  4.187231130216013e-19, -1.008727905595285e-19,  1.277440668561702e-20,
 -1.114534772708443e-21,  7.496877308381360e-23, -4.134572283783014e-24,  1.943309048735482e-25, -7.992965490849213e-27,  2.932669724144241e-28, -9.738947091587538e-30,
  2.960599220097183e-31, -8.308750369606620e-33,  3.048126146750437e-20, -8.091234985762587e-21,  1.127805515295464e-21, -1.079108485864121e-22,  7.930621903239665e-24,
 -4.761963356534897e-25,  2.428929380020188e-26, -1.080928781684637e-27,  4.279226030380015e-29, -1.529362582662129e-30,  4.991535032762725e-32, -1.500494253034366e-33,
  2.275527655237076e-21, -6.625820758194094e-22,  1.013238768649528e-22, -1.060408992717485e-23,  8.495281097861633e-25, -5.542381177130495e-26,  3.062160557933082e-27,
 -1.471855080505908e-28,  6.276595357825777e-30, -2.410307853889636e-31,  8.432958067189469e-33, -2.711206877191626e-34,  1.809724802848003e-22, -5.748242196727978e-23,
  9.602708125223434e-24, -1.095152272944830e-24,  9.532156080654068e-26, -6.736187433901861e-27,  4.019743291001572e-28, -2.081160489396126e-29,  9.535026142240778e-31,
 -3.924461433050867e-32,  1.468283997163123e-33, -5.036582405729393e-35,  1.604687363409962e-23, -5.521961284783391e-24,  1.001963940417924e-24, -1.238847392499871e-25,
  1.165957398274387e-26, -8.885331669905629e-28,  5.702620980371040e-29, -3.167361218360816e-30,  1.553045879056966e-31, -6.825305013034355e-33,  2.720775126139680e-34,
 -9.922431690505253e-36,  1.670588414566593e-24, -6.175601465536682e-25,  1.207994865198755e-25, -1.607990488541598e-26,  1.625709462938694e-27, -1.327675387910204e-28,
  9.110027986248338e-30, -5.397239349106075e-31,  2.816638937871958e-32, -1.314709219130566e-33,  5.555102468136770e-35, -2.143038599424110e-36,  2.154131917739587e-25,
 -8.467199710320201e-26,  1.768233448746137e-26, -2.510801647247976e-27,  2.703044902476299e-28, -2.345898356729249e-29,  1.707091955494971e-30, -1.070434335873920e-31,
  5.901082619793753e-33, -2.904271103981210e-34,  1.291622458474205e-35, -5.235069150217612e-37,  3.594083462010204e-26, -1.484081119927221e-26,  3.269020560083011e-27,
 -4.893990014351527e-28,  5.547422040590649e-29, -5.061059542159861e-30,  3.865158741145466e-31, -2.539450297926789e-32,  1.464505913530854e-33, -7.528545204154693e-35,
  3.492082397733434e-36, -1.473968205068937e-37,  7.770766599782180e-27, -3.324481533579107e-27,  7.612981436606765e-28, -1.184673620414867e-28,  1.394523045282599e-29,
 -1.319718802114049e-30,  1.044226430707990e-31, -7.099652311602176e-33,  4.232065286738118e-34, -2.246186199064733e-35,  1.074532924790294e-36, -4.672336401896823e-38,
  1.793478811439997e-27, -7.829418939617489e-28,  1.833436010121998e-28, -2.917423914985619e-29,  3.509919070440119e-30, -3.392688644874117e-31,  2.740007298574907e-32,
 -1.900160908974792e-33,  1.154540174894085e-34, -6.241964278180510e-36,  3.039758531565040e-37, -1.344656210448530e-38,  5.960763601216582e-02, -1.461932410999796e-04,
  3.699224816271270e-07, -9.620309892270515e-10,  2.555275589640667e-12, -6.907405415829600e-15,  1.883367786119288e-17, -5.202664242586216e-20,  1.426246188156875e-22,
 -4.017206032349039e-25,  1.073223248309076e-27, -3.209439829868078e-30,  5.352949500458716e-02, -1.521448990222521e-04,  5.201567162930702e-07, -1.895970242792281e-09,
  6.946047954667168e-12, -2.511943357970424e-14,  8.929665199037701e-17, -3.127087040983219e-19,  1.078704391760738e-21, -3.683517692433749e-24,  1.240162038114977e-26,
 -4.160856205775748e-29,  4.316706046201483e-02, -1.564461165822044e-04,  7.431245237009739e-07, -3.504362979821040e-09,  1.581506292364571e-11, -6.874816824999662e-14,
  2.901320540872235e-16, -1.195260691056580e-18,  4.824027802152898e-21, -1.912698170687039e-23,  7.463843583076725e-26, -2.872064287870590e-28,  3.125604414382531e-02,
 -1.501427567223762e-04,  9.272355073562791e-07, -5.280381125699695e-09,  2.812702028618309e-11, -1.428416119349285e-13,  6.988458552338815e-16, -3.314556205793467e-18,
  1.530979433912295e-20, -6.909461571904442e-23,  3.055446090068146e-25, -1.326511382800410e-27,  2.031749269846344e-02, -1.297986159321127e-04,  9.865710290494104e-07,
 -6.599627909164427e-09,  4.082332132942695e-11, -2.386582243475538e-13,  1.333690066690965e-15, -7.177792117612549e-18,  3.741249763728008e-20, -1.896397713311116e-22,
  9.379870877992135e-25, -4.538489090219056e-27,  1.185421626012435e-02, -9.945199836153240e-05,  9.003292560833630e-07, -6.985504507767206e-09,  4.963982437687925e-11,
 -3.303671362648132e-13,  2.086035319011295e-15, -1.260912090577368e-17,  7.344219053753628e-20, -4.142223374944933e-22,  2.271090621168222e-24, -1.214092726891307e-26,
  6.206347451960846e-03, -6.715633293289366e-05,  7.108837421817983e-07, -6.345832146626997e-09,  5.135441376809229e-11, -3.857492185699277e-13,  2.730046475749400e-15,
 -1.839302049539021e-17,  1.188511402938533e-19, -7.407104925295051e-22,  4.471830023576917e-24, -2.624212947191153e-26,  2.914998514937173e-03, -3.993084918508132e-05,
  4.890184439082823e-07, -4.989908296536507e-09,  4.566089086985472e-11, -3.845329313136259e-13,  3.031389588336024e-15, -2.263048431580358e-17,  1.613259044899979e-19,
 -1.105034014005119e-21,  7.308163805584846e-24, -4.684372939230794e-26,  1.227853272146892e-03, -2.092674473456716e-05,  2.945352392824840e-07, -3.416213519356343e-09,
  3.514439298491876e-11, -3.300805482301599e-13,  2.884282760665901e-15, -2.374862573240568e-17,  1.859446928661152e-19, -1.393913913094947e-21,  1.005748207688185e-23,
 -7.013676920401961e-26,  4.636823321774699e-04, -9.681422889833514e-06,  1.558741841797771e-07, -2.045034062534478e-09,  2.354215147479557e-11, -2.455534912358263e-13,
  2.368942026776542e-15, -2.143268875874431e-17,  1.836570087468430e-19, -1.501603260284793e-21,  1.178149384002861e-23, -8.910234705890879e-26,  1.569350818022853e-04,
 -3.960202975504866e-06,  7.267197884159123e-08, -1.073949704780792e-09,  1.378210280006964e-11, -1.590937321864259e-13,  1.689085404210638e-15, -1.674066537032998e-17,
  1.565417723178279e-19, -1.392090800534294e-21,  1.184525038265616e-23, -9.690448224052178e-26,  4.758957111641597e-05, -1.434421309268747e-06,  2.990769830195084e-08,
 -4.960568771176080e-10,  7.074490035387284e-12, -9.012386228663299e-14,  1.050225626430802e-15, -1.137424844045035e-17,  1.157924760233638e-19, -1.117441072659391e-21,
  1.028934026767974e-23, -9.086241760259761e-26,  1.292647826958377e-05, -4.606650896405281e-07,  1.088235247383269e-08, -2.019673510970190e-10,  3.192699162932516e-12,
 -4.478131670366850e-14,  5.715390924251005e-16, -6.750314371756319e-18,  7.466993330709483e-20, -7.805446769632408e-22,  7.763872277839084e-24, -7.388043303527782e-26,
  3.144418384534292e-06, -1.313261718289454e-07,  3.505799475007870e-09, -7.261696439960243e-11,  1.269698504653419e-12, -1.957050296728688e-14,  2.730819677662371e-16,
 -3.511514794560630e-18,  4.214095513253748e-20, -4.764517078398394e-22,  5.112077034000280e-24, -5.234842039055621e-26,  6.849428720739106e-07, -3.326958369144219e-08,
  1.001214254287498e-09, -2.309548909390459e-11,  4.458694315962592e-13, -7.540385278615420e-15,  1.148708822761975e-16, -1.606062116432410e-18,  2.088435278988281e-20,
 -2.550848775132285e-22,  2.948958407878128e-24, -3.246040832678178e-26,  1.336143492473712e-07, -7.497951854822318e-09,  2.537973959066267e-10, -6.507892216593683e-12,
  1.385183424878835e-13, -2.567034551923946e-15,  4.264660999515329e-17, -6.476469096524194e-19,  9.116438106174897e-21, -1.201819816068884e-22,  1.495708985188069e-24,
 -1.768246202432633e-26,  2.334873297173631e-08, -1.505012790912020e-09,  5.718033578829970e-11, -1.627356251475997e-12,  3.814362523708362e-14, -7.738453128472366e-16,
  1.400766640064931e-17, -2.308762718427006e-19,  3.515426812305493e-21, -4.998559382501568e-23,  6.692561128511925e-25, -8.492269744395194e-27,  3.657150645691421e-09,
 -2.694145235196988e-10,  1.146737245450239e-11, -3.617598973628873e-13,  9.328693434990503e-15, -2.070288247427544e-16,  4.080579776015093e-18, -7.295392763575626e-20,
  1.200978583599348e-21, -1.840967828433351e-23,  2.650549484817783e-25, -3.608380353575553e-27,  5.139560306546332e-10, -4.308205794395031e-11,  2.050818851620473e-12,
 -7.163672974415214e-14,  2.030840665411983e-15, -4.927451380307131e-17,  1.057060918081675e-18, -2.049169997940892e-20,  3.645945888284515e-22, -6.023323500733940e-24,
  9.322824312172692e-26, -1.361295123637149e-27,  6.490555436773223e-11, -6.166972569457726e-12,  3.278062970340568e-13, -1.266747344741189e-14,  3.945725310906753e-16,
 -1.046275392655186e-17,  2.442268810685358e-19, -5.132567418031197e-21,  9.868304431865142e-23, -1.756808770564546e-24,  2.922837273287352e-26, -4.577061542298410e-28,
  7.382276915198974e-12, -7.923674299529377e-13,  4.696592404043290e-14, -2.006324752842013e-15,  6.863710704550147e-17, -1.988627362658033e-18,  5.050324003070635e-20,
 -1.150534903595156e-21,  2.390428592138393e-23, -4.585802173483031e-25,  8.201065760372472e-27, -1.377321222565376e-28,  7.586469903532714e-13, -9.170905624865242e-14,
  6.053939612763746e-15, -2.857197237584241e-16,  1.073242867364209e-17, -3.397229985568511e-19,  9.386674523863136e-21, -2.318253212573654e-22,  5.205341425909099e-24,
 -1.076213174716650e-25,  2.069106428300282e-27, -3.727201208999919e-29,  7.075448184534221e-14, -9.606843665377512e-15,  7.054801795989420e-16, -3.676642283889629e-17,
  1.516105142272038e-18, -5.243083832563014e-20,  1.576296185766597e-21, -4.221091721102441e-23,  1.024493082916599e-24, -2.283272377143665e-26,  4.720231407734622e-28,
 -9.121906178307825e-30,  6.024992948649584e-15, -9.165282923210675e-16,  7.479448497322097e-17, -4.302352224394424e-18,  1.947366016433463e-19, -7.357957951648813e-21,
  2.407352378143699e-22, -6.991294769616198e-24,  1.834613861358490e-25, -4.408650928728537e-27,  9.802695589294835e-29, -2.032813634673084e-30,  4.722613260581831e-16,
 -8.029534524554828e-17,  7.274172818724141e-18, -4.616327241297262e-19,  2.293220950484485e-20, -9.467399693382408e-22,  3.371425077419831e-23, -1.062081973362474e-24,
  3.014098326138763e-26, -7.811706268976117e-28,  1.868680165418220e-29, -4.159344699998496e-31,  3.444675830894890e-17, -6.530240641572263e-18,  6.560198296724600e-19,
 -4.590742350243472e-20,  2.502381052462763e-21, -1.128774260513210e-22,  4.375541686602877e-24, -1.495450832241133e-25,  4.590582481620920e-27, -1.283434565794839e-28,
  3.303711650107039e-30, -7.894281002157802e-32,  2.371892188471273e-18, -5.000813888214568e-19,  5.563869919344730e-20, -4.290405575276485e-21,  2.565255850960240e-22,
 -1.264085214389768e-23,  5.333550558970542e-25, -1.977679308552310e-26,  6.567010664738325e-28, -1.980698983712843e-29,  5.486743923359228e-31, -1.407560178157963e-32,
  1.571112289780072e-19, -3.673446599320514e-20,  4.519376957858982e-21, -3.836400624002078e-22,  2.514359851979269e-23, -1.352884448972376e-24,  6.211061354530169e-26,
 -2.497972728368199e-27,  8.970544432354819e-29, -2.918284848066413e-30,  8.697781280689264e-32, -2.395045790967970e-33,  1.025918778003650e-20, -2.651114177454159e-21,
  3.599178148671337e-22, -3.358347756900669e-23,  2.409897340699182e-24, -1.414521411431670e-25,  7.060406649600648e-27, -3.077678132372301e-28,  1.194504382868299e-29,
 -4.188745100580720e-31,  1.342413493847627e-32, -3.965333464234597e-34,  6.814422561908732e-22, -1.938130500244951e-22,  2.895337387914703e-23, -2.962961642238084e-24,
  2.323528881573270e-25, -1.485307772692424e-26,  8.048218860182682e-28, -3.797173698504174e-29,  1.590695567564571e-30, -6.005121226712092e-32,  2.066863860295619e-33,
 -6.541299740735949e-35,  4.789293742285438e-23, -1.491367491866286e-23,  2.441967425424225e-24, -2.731684820248242e-25,  2.334116296864669e-26, -1.620615701385255e-27,
  9.509083440315826e-29, -4.844382127050047e-30,  2.185465110668687e-31, -8.862741519397890e-33,  3.269059895272787e-34, -1.106181009842487e-35,  3.737106543265554e-24,
 -1.265657397924310e-24,  2.259230475667216e-25, -2.749340698190180e-26,  2.548449813094164e-27, -1.913967270729971e-28,  1.211370550152360e-29, -6.638977633068491e-31,
  3.213905548672446e-32, -1.395228661083378e-33,  5.496749023768025e-35, -1.982136348693331e-36,  3.424106757460129e-25, -1.250685641097164e-25,  2.415952193033713e-26,
 -3.176848381611650e-27,  3.174288562903644e-28, -2.563286146140463e-29,  1.739937361689134e-30, -1.020216656107837e-31,  5.271650857163024e-33, -2.437347714056080e-34,
  1.020516119540355e-35, -3.902693383466666e-37,  3.910978303143477e-26, -1.524706256779804e-26,  3.156410621942222e-27, -4.443725562800026e-28,  4.744594619769254e-29,
 -4.085152921260297e-30,  2.950198104138520e-31, -1.836481993389844e-32,  1.005360637467566e-33, -4.914909827668455e-35,  2.171803207574696e-36, -8.748473851060754e-38,
  5.866026436983546e-27, -2.410428553840628e-27,  5.281593198573329e-28, -7.865983508366465e-29,  8.871482083444351e-30, -8.054596433559901e-31,  6.122807311490462e-32,
 -4.004843514194530e-33,  2.299736763554891e-34, -1.177373680206100e-35,  5.439707355985654e-37, -2.287384897883657e-38,  1.168069421367227e-27, -4.985716642683382e-28,
  1.138836737994770e-28, -1.767735684588441e-29,  2.075806504690625e-30, -1.959844820757257e-31,  1.547219215780140e-32, -1.049659532850874e-33,  6.243873734019287e-35,
 -3.307292802740089e-36,  1.579083193012365e-37, -6.853489543711386e-39,  2.566231880756323e-28, -1.119427703070295e-28,  2.619155714804729e-29, -4.164118856334656e-30,
  5.005594320090529e-31, -4.834447709217902e-32,  3.901296643184143e-33, -2.703411827455354e-34,  1.641366184295660e-35, -8.867517681144647e-37,  4.315326370168196e-38,
 -1.907609761259707e-39,  5.902870966069818e-02, -1.432793540416043e-04,  3.586189355475402e-07, -9.222276917267296e-10,  2.421532177306441e-12, -6.472375441736882e-15,
  1.743871109091267e-17, -4.768603056017702e-20,  1.289022815085063e-22, -3.615163407509853e-25,  9.393256460740088e-28, -2.888712681340576e-30,  5.292909644009874e-02,
 -1.480727999780359e-04,  4.980556843775032e-07, -1.788739050403095e-09,  6.464400907273466e-12, -2.307760265359882e-14,  8.100479504385820e-17, -2.802195978940758e-19,
  9.546027054273633e-22, -3.222216402858581e-24,  1.070736831789654e-26, -3.557486463658035e-29,  4.255290559472049e-02, -1.506651302129757e-04,  7.025462353575200e-07,
 -3.261954420764583e-09,  1.450710792502588e-11, -6.216977909413809e-14,  2.587263733032189e-16, -1.051356560367809e-18,  4.186285475797448e-21, -1.637950755976116e-23,
  6.308159033366527e-26, -2.396266276887654e-28,  3.066991809788092e-02, -1.429708917593836e-04,  8.664797203731644e-07, -4.852322751244398e-09,  2.543067029385994e-11,
 -1.271298588496246e-13,  6.125393079979077e-16, -2.862192031710937e-18,  1.302901130006493e-20, -5.796435363001003e-23,  2.527469842814842e-25, -1.082130499774927e-27,
  1.981359701119394e-02, -1.222120776870736e-04,  9.111424710448830e-07, -5.982966928935011e-09,  3.635463653457888e-11, -2.089321759387501e-13,  1.148495806654702e-15,
 -6.082956574718791e-18,  3.121532825584428e-20, -1.558277047528674e-22,  7.592984994454602e-25, -3.620121989125469e-27,  1.147030105762770e-02, -9.257165155931097e-05,
  8.210590773737122e-07, -6.241521300962559e-09,  4.350584886195770e-11, -2.842865630416168e-13,  1.763759465916752e-15, -1.048102368916216e-17,  6.004436543392306e-20,
 -3.332235232190471e-22,  1.798314329207815e-24, -9.465357411515165e-27,  5.948632952025717e-03, -6.176045858677603e-05,  6.394202568848638e-07, -5.582489094132687e-09,
  4.425504603627168e-11, -3.260018507171643e-13,  2.264512133238452e-15, -1.498404842804851e-17,  9.514522527272753e-20, -5.829564303607028e-22,  3.461387137451220e-24,
 -1.998434714487528e-26,  2.762736974542657e-03, -3.624635730641372e-05,  4.332814383402452e-07, -4.317111778301191e-09,  3.864930572000062e-11, -3.188349056503874e-13,
  2.464409636606804e-15, -1.805193357886817e-17,  1.263450773090507e-19, -8.501145525177168e-22,  5.525251251308093e-24, -3.481824797663066e-26,  1.148612088243778e-03,
 -1.872536015644161e-05,  2.567082789534063e-07, -2.903169572384329e-09,  2.918443582375194e-11, -2.682086578088102e-13,  2.295601075783739e-15, -1.852930402192430e-17,
  1.423184348167040e-19, -1.047174123532108e-21,  7.419821045146167e-24, -5.083474331780365e-26,  4.273037771747046e-04, -8.526541724422961e-06,  1.334412329985638e-07,
 -1.704751797536646e-09,  1.915424987961499e-11, -1.952830400106934e-13,  1.843585006808582e-15, -1.633678551451506e-17,  1.372150376767445e-19, -1.100340448164153e-21,
  8.472012083017068e-24, -6.290689012455352e-26,  1.421803919959064e-04, -3.426856263017065e-06,  6.100938491162952e-08, -8.768382394083452e-10,  1.097038104963510e-11,
 -1.236577233062436e-13,  1.283550147595557e-15, -1.244946269677229e-17,  1.140184525170590e-19, -9.937485964485389e-22,  8.292289522220303e-24, -6.656138143139478e-26,
  4.229525531256146e-05, -1.217174790994639e-06,  2.457884250556870e-08, -3.960165597562856e-10,  5.500286093172684e-12, -6.835600199252006e-14,  7.780981544685432e-16,
 -8.240313649735099e-18,  8.210073187390342e-20, -7.759910071028795e-22,  7.002643169316145e-24, -6.063816923760867e-26,  1.124372801929289e-05, -3.824958144640781e-07,
  8.737937311687495e-09, -1.573636061065366e-10,  2.420225077241583e-12, -3.308644630480656e-14,  4.121512311041043e-16, -4.756362847426804e-18,  5.145624045760742e-20,
 -5.264687887732962e-22,  5.128990963864331e-24, -4.783259046570075e-26,  2.670138668901847e-06, -1.064476214397076e-07,  2.744438766437336e-09, -5.510784796223002e-11,
  9.365890794294922e-13, -1.405856477492623e-14,  1.913174051941875e-16, -2.402080360387763e-18,  2.817428463956123e-20, -3.115907026424488e-22,  3.272610748962808e-24,
 -3.282545613621649e-26,  5.662859506342216e-07, -2.625773559312784e-08,  7.623416826827269e-10, -1.703228045124396e-11,  3.193452249206780e-13, -5.255338561068428e-15,
  7.802425811720049e-17, -1.064454787311114e-18,  1.351998092561181e-20, -1.614397502816049e-22,  1.825982158974767e-24, -1.967789818414811e-26,  1.072371675340477e-07,
 -5.745843483131920e-09,  1.874708236945151e-10, -4.652333028919125e-12,  9.609876880172896e-14, -1.731779929961762e-15,  2.802050886578588e-17, -4.149670703811872e-19,
  5.702277353744124e-21, -7.345278275026042e-23,  8.939415134581722e-25, -1.034207211245200e-26,  1.813312168127431e-08, -1.116375762629296e-09,  4.085678119490762e-11,
 -1.124596357048475e-12,  2.556419083063695e-14, -5.040185814415936e-16,  8.880513173843156e-18, -1.426600216416557e-19,  2.119495218408736e-21, -2.943365823248919e-23,
  3.852110464057066e-25, -4.781463645804239e-27,  2.738683783044796e-09, -1.927858834622801e-10,  7.900680232622792e-12, -2.409279095792706e-13,  6.022085452717448e-15,
 -1.298109334371541e-16,  2.489241590808645e-18, -4.335543262861493e-20,  6.961048457216281e-22, -1.041735619721894e-23,  1.465528511171935e-25, -1.950986330519174e-27,
  3.696878108234185e-10, -2.962850372564217e-11,  1.357601582801045e-12, -4.582249027506224e-14,  1.258618305208238e-15, -2.964914909980015e-17,  6.185570599994431e-19,
 -1.167731609230337e-20,  2.025661561182856e-22, -3.266054917535654e-24,  4.938010126414311e-26, -7.048910295652613e-28,  4.465272420666594e-11, -4.059290375120981e-12,
  2.076822346847430e-13, -7.753000123199118e-15,  2.339139659293913e-16, -6.020263972967348e-18,  1.366230618731590e-19, -2.795298960243901e-21,  5.238584650355023e-23,
 -9.099594059066730e-25,  1.478510300542060e-26, -2.263011217633739e-28,  4.834632200102127e-12, -4.969178622798432e-13,  2.835345127533669e-14, -1.170028418923209e-15,
  3.876530464968022e-17, -1.089944815938508e-18,  2.690638117696130e-20, -5.966577317476616e-22,  1.208121586209966e-23, -2.261072562996564e-25,  3.948546620499957e-27,
 -6.480915201319604e-29,  4.704878312031282e-13, -5.451944588468914e-14,  3.465743348148697e-15, -1.580254691364727e-16,  5.748926768521274e-18, -1.765930012025166e-19,
  4.742746309394859e-21, -1.140121503641082e-22,  2.494785635790885e-24, -5.031931538053839e-26,  9.446699380554255e-28, -1.663081686041143e-29,  4.131233127719503e-14,
 -5.383505048350182e-15,  3.809266645835968e-16, -1.918596914624632e-17,  7.664064712697960e-19, -2.572439207172802e-20,  7.518314720522926e-22, -1.959872225768975e-23,
  4.636088291777553e-25, -1.008089877024318e-26,  2.035233992389966e-28, -3.844349147767029e-30,  3.290863403974112e-15, -4.811493104611622e-16,  3.786483840711917e-17,
 -2.106186082318965e-18,  9.239004632403913e-20, -3.389370522393257e-21,  1.078354791269623e-22, -3.049469358254936e-24,  7.801335972726263e-26, -1.829547760503698e-27,
  3.973809632974457e-29, -8.056763226479371e-31,  2.395982016389115e-16, -3.921944298149943e-17,  3.430090386346005e-18, -2.106709170155089e-19,  1.014931338610222e-20,
 -4.070626403305053e-22,  1.410373642158850e-23, -4.328490358309775e-25,  1.198106959046054e-26, -3.031746018276633e-28,  7.087547478890969e-30, -1.543036725248256e-31,
  1.610718376225140e-17, -2.945515774009049e-18,  2.860679848453372e-19, -1.939592617172330e-20,  1.026315911735411e-21, -4.501372149459464e-23,  1.699019425047762e-24,
 -5.661253647951216e-26,  1.696165613883846e-27, -4.633098976237240e-29,  1.166257056501970e-30, -2.727532511955205e-32,  1.013617620923099e-18, -2.066183729265651e-19,
  2.226281976819999e-20, -1.665748348537689e-21,  9.680475930265062e-23, -4.643595422266071e-24,  1.909795128367095e-25, -6.910915406474929e-27,  2.241926449796186e-28,
 -6.612518104073782e-30,  1.792840841382832e-31, -4.505406755122945e-33,  6.081348136521897e-20, -1.378335503966316e-20,  1.645700434993079e-21, -1.357989907989466e-22,
  8.664930013043735e-24, -4.545284439307427e-25,  2.036876489892472e-26, -8.005114858930828e-28,  2.812010168097871e-29, -8.956589134942705e-31,  2.615808921290694e-32,
 -7.063838772297151e-34,  3.563756190029377e-21, -8.953927813305326e-22,  1.182690695948953e-22, -1.075133370210103e-23,  7.526310316503841e-25, -4.314917721709974e-26,
  2.105992730930836e-27, -8.985782832951947e-29,  3.416877910024117e-30, -1.174911153475445e-31,  3.695118762572725e-33, -1.071937616880611e-34,  2.105307703975057e-22,
 -5.841520493836095e-23,  8.515331609793913e-24, -8.512426698199447e-25,  6.528130627109957e-26, -4.085381241986556e-27,  2.169295128684704e-28, -1.003865802501464e-29,
  4.128207106967394e-31, -1.531055225132524e-32,  5.180679910967743e-34, -1.613039008280233e-35,  1.305585377523782e-23, -3.981015670696781e-24,  6.382179290526990e-25,
 -6.995683659777116e-26,  5.862595490704094e-27, -3.995787098959214e-28,  2.303455792627095e-29, -1.153819237162534e-30,  5.121732687517285e-32, -2.045071147002989e-33,
  7.431977890843735e-35, -2.479222191602435e-36,  8.939397006032581e-25, -2.976471796783018e-25,  5.221416481418436e-26, -6.248045582493289e-27,  5.698847042407523e-28,
 -4.214537280798038e-29,  2.628408658741890e-30, -1.420354091061230e-31,  6.783750182793104e-33, -2.907158705344506e-34,  1.131216919387522e-35, -4.031029590362274e-37,
  7.177826804861134e-26, -2.588194837426353e-26,  4.932983973502723e-27, -6.402452203073150e-28,  6.317520230317027e-29, -5.040561170504894e-30,  3.382379314900516e-31,
 -1.961565888166911e-32,  1.002956737680287e-33, -4.590603966068805e-35,  1.903573556536910e-36, -7.212580198530512e-38,  7.222532598282276e-27, -2.790834539841439e-27,
  5.723414123360911e-28, -7.983782718210615e-29,  8.449000483170996e-30, -7.213003633342566e-31,  5.166736268351206e-32, -3.191237981458888e-33,  1.733983332821759e-34,
 -8.416371500056339e-36,  3.693555979584296e-37, -1.478086436055526e-38,  9.680062966371005e-28, -3.956642741989586e-28,  8.620209536548638e-29, -1.276628537635257e-29,
  1.432014715848514e-30, -1.293380420059951e-31,  9.782652147991385e-33, -6.368029480150329e-34,  3.639967758435710e-35, -1.855308096679365e-36,  8.535676255104596e-38,
 -3.574713932622169e-39,  1.765534830130020e-28, -7.517053065401631e-29,  1.712348173663047e-29, -2.650755793911387e-30,  3.104527933939363e-31, -2.923663837386860e-32,
  2.302483719559854e-33, -1.558380237334235e-34,  9.249096190676109e-36, -4.888508246811801e-37,  2.329184235843534e-38, -1.008888066592599e-39,  3.678925060529830e-29,
 -1.603482569889485e-29,  3.748285726845924e-30, -5.953838107215180e-31,  7.150558016353374e-32, -6.900044682440142e-33,  5.563471567914716e-34, -3.852052206070869e-35,
  2.336896550506258e-36, -1.261539323598216e-37,  6.134616242500535e-39, -2.709874176612334e-40,  5.846126097527706e-02, -1.404540205221648e-04,  3.477804710086120e-07,
 -8.844964626178947e-10,  2.296164166036487e-12, -6.069414543457906e-15,  1.615934421513981e-17, -4.376238318851626e-20,  1.165340993606883e-22, -3.264069366047319e-25,
  8.179557567912337e-28, -2.640081385931164e-30,  5.234464062389987e-02, -1.441724900650686e-04,  4.771965020637552e-07, -1.688898028990735e-09,  6.021671862268104e-12,
 -2.122429381659752e-14,  7.356944174620479e-17, -2.514486142868876e-19,  8.459492864999635e-22, -2.823669532716339e-24,  9.256927255965065e-27, -3.049899673999760e-29,
  4.196124335394136e-02, -1.451974805636999e-04,  6.647554987679746e-07, -3.039460222810598e-09,  1.332349817909852e-11, -5.629899226476546e-14,  2.310785557999596e-16,
 -9.263629199742061e-19,  3.639612088271966e-21, -1.405501899837848e-23,  5.342840371788077e-26, -2.003941194660239e-28,  3.011153894682549e-02, -1.362652365260104e-04,
  8.106118009022057e-07, -4.465000477179467e-09,  2.302882665023963e-11, -1.133453596784503e-13,  5.379346152093687e-16, -2.476789348392163e-18,  1.111335897967737e-20,
 -4.874570056906026e-23,  2.096189235675449e-25, -8.851921088493345e-28,  1.933888582789186e-02, -1.152005399964985e-04,  8.427037155330206e-07, -5.433280197386750e-09,
  3.243839795906861e-11, -1.833042567001615e-13,  9.913542051928174e-16, -5.168258865892114e-18,  2.611591327245512e-20, -1.284160767431859e-22,  6.165451957502537e-25,
 -2.896925259846009e-27,  1.111269319578241e-02, -8.629135602487144e-05,  7.501569407120686e-07, -5.588709637248718e-09,  3.822072572864521e-11, -2.452714468287202e-13,
  1.495481728221674e-15, -8.738432997243375e-18,  4.924867896618156e-20, -2.689754811707473e-22,  1.429061584170380e-24, -7.407115554984778e-27,  5.711413936579894e-03,
 -5.690149565746158e-05,  5.764729008643033e-07, -4.923752427504577e-09,  3.824620724536382e-11, -2.763626316460125e-13,  1.884609878917084e-15, -1.225009154555835e-17,
  7.645274344313576e-20, -4.606061522230972e-22,  2.690312521901122e-24, -1.528430613124441e-26,  2.624370175521724e-03, -3.297727912551002e-05,  3.849859584368705e-07,
 -3.746686864164557e-09,  3.282537059673058e-11, -2.653244844553651e-13,  2.011244871341508e-15, -1.445872760316633e-17,  9.937571554216036e-20, -6.569520643924802e-22,
  4.196950829933011e-24, -2.600640732702682e-26,  1.077608032000818e-03, -1.680349696622842e-05,  2.245041681980691e-07, -2.476306087771807e-09,  2.433170142037622e-11,
 -2.188583432395410e-13,  1.835256298022719e-15, -1.452511058406286e-17,  1.094640255603490e-19, -7.907211118442936e-22,  5.503057734803452e-24, -3.704787801964858e-26,
  3.952100915277136e-04, -7.535911939565466e-06,  1.147015154711513e-07, -1.427272097357221e-09,  1.565641471028895e-11, -1.560643809195192e-13,  1.442109028543308e-15,
 -1.251935102976194e-17,  1.030896614222708e-19, -8.109749836387378e-22,  6.128675910576405e-24, -4.468717011395055e-26,  1.293864552272864e-04, -2.978063120763075e-06,
  5.146398337813846e-08, -7.195351321905368e-10,  8.779041641586182e-12, -9.665415002141287e-14,  9.810925427350293e-16, -9.314575119495229e-18,  8.356953933754705e-20,
 -7.140065791667320e-22,  5.843944129530585e-24, -4.603446136092981e-26,  3.779170334808559e-05, -1.038154445947126e-06,  2.031264080432838e-08, -3.180077218021052e-10,
  4.302651986315951e-12, -5.217751695928846e-14,  5.803080110374834e-16, -6.010820881391162e-18,  5.862382959804905e-20, -5.427952682034760e-22,  4.801384490032058e-24,
 -4.077714329992211e-26,  9.842459325241926e-06, -3.195344794435671e-07,  7.061703391149789e-09, -1.234385352539427e-10,  1.847517161380653e-12, -2.462308135298699e-14,
  2.994363414821752e-16, -3.377193879052743e-18,  3.573948352215226e-20, -3.579718382270552e-22,  3.416380568179790e-24, -3.123019795129594e-26,  2.284404395464042e-06,
 -8.690239048138175e-08,  2.164528271105535e-09, -4.214347445063106e-11,  6.963716588542122e-13, -1.018169465251092e-14,  1.351598898113517e-16, -1.657293741665822e-18,
  1.900215783625400e-20, -2.056032612725217e-22,  2.114198525033604e-24, -2.077510801322881e-26,  4.722708940584166e-07, -2.089706374804725e-08,  5.854467979173473e-10,
 -1.267118558116445e-11,  2.307816744463292e-13, -3.696430045234119e-15,  5.349423847880268e-17, -7.122442424984971e-19,  8.837782315246414e-21, -1.031858122512327e-22,
  1.142026512300818e-24, -1.205090864822042e-26,  8.693345770551701e-08, -4.445663137693658e-09,  1.398337282160341e-10, -3.358907324494167e-12,  6.734397531654464e-14,
 -1.180314197256999e-15,  1.860300989083551e-17, -2.687037223166380e-19,  3.605140093159184e-21, -4.538272822887205e-23,  5.401871367367560e-25, -6.116487137611234e-27,
  1.424475157328237e-08, -8.372457740864055e-10,  2.951724191054927e-11, -7.858638952951478e-13,  1.732740060416793e-14, -3.320380702756094e-16,  5.695305658580880e-18,
 -8.918428549186823e-20,  1.293016792628573e-21, -1.753932329600061e-23,  2.244004029411960e-25, -2.724978417126118e-27,  2.077717220325307e-09, -1.396850772960862e-10,
  5.511477173982787e-12, -1.624698498025243e-13,  3.936627940323647e-15, -8.242932138561389e-17,  1.537953094545168e-18, -2.609818279908778e-20,  4.087201568019499e-22,
 -5.971994821024866e-24,  8.209939718725970e-26, -1.068853284823180e-27,  2.698427912926099e-10, -2.066515555821162e-11,  9.113285892630607e-13, -2.972112126306341e-14,
  7.909745954074096e-16, -1.809125707619348e-17,  3.670684485519862e-19, -6.748673939537979e-21,  1.141450708362880e-22, -1.796251607428429e-24,  2.652984095785943e-26,
 -3.702458706359051e-28,  3.122832078549677e-11, -2.714464745023729e-12,  1.336404164494571e-13, -4.819016750146321e-15,  1.408224687921473e-16, -3.517727448766331e-18,
  7.761209771762277e-20, -1.545960126495139e-21,  2.824004098060319e-23, -4.786342176654676e-25,  7.595083566728669e-27, -1.136262843205866e-28,  3.224651641579654e-12,
 -3.171615315921500e-13,  1.741504970621970e-14, -6.940696409246437e-16,  2.226814323962987e-17, -6.075383053085533e-19,  1.457741740674319e-20, -3.146423002721862e-22,
  6.208584540675617e-24, -1.133557717318301e-25,  1.932939413971238e-27, -3.100529099300531e-29,  2.977504509181356e-13, -3.304805119898448e-14,  2.022199586862464e-15,
 -8.905520567452053e-17,  3.137112759684509e-18, -9.349868013070740e-20,  2.440465846250038e-21, -5.709728629896687e-23,  1.217435902229562e-24, -2.395291998787569e-26,
  4.390617686811628e-28, -7.553617183050472e-30,  2.466477665648634e-14, -3.082104464505952e-15,  2.100221257985345e-16, -1.021920085872881e-17,  3.953302085654200e-19,
 -1.287559533514641e-20,  3.657421295142407e-22, -9.279420338215388e-24,  2.138996938894380e-25, -4.537196578302367e-27,  8.944316357113419e-29, -1.651122995807636e-30,
  1.841715703176472e-15, -2.585616331094927e-16,  1.960995031411830e-17, -1.054266751340751e-18,  4.480165317192462e-20, -1.595239307368334e-21,  4.934011443226308e-23,
 -1.358286887227443e-24,  3.386782876275541e-26, -7.749549495754584e-28,  1.643877182083391e-29, -3.257876337287384e-31,  1.248013427492749e-16, -1.964724793245964e-17,
  1.657655860776693e-18, -9.847419616851363e-20,  4.598555039143506e-21, -1.791009275234515e-22,  6.035219572756263e-24, -1.803849088720400e-25,  4.868303590645029e-27,
 -1.202406043182630e-28,  2.746269301428095e-30, -5.846474715642017e-32,  7.747348319781500e-18, -1.365132790230159e-18,  1.280663589361240e-19, -8.407133756881185e-21,
  4.315758894505288e-22, -1.839500479965758e-23,  6.757296492814410e-25, -2.194164878021244e-26,  6.413667461309233e-28, -1.710958916754234e-29,  4.210153730228118e-31,
 -9.633573603750564e-33,  4.463200574533896e-19, -8.785701378687723e-20,  9.159070736457122e-21, -6.644145824744907e-22,  3.750376950025998e-23, -1.750126941918156e-24,
  7.012024355959426e-26, -2.474968968186410e-27,  7.839946996170220e-29, -2.260215252884786e-30,  5.995293138978898e-32, -1.475226586137700e-33,  2.428575584119475e-20,
 -5.329104110287587e-21,  6.168663173066223e-22, -4.943627136034216e-23,  3.068528244268120e-24, -1.568093930276178e-25,  6.854613973466989e-27, -2.630852008809130e-28,
  9.034636825147272e-30, -2.815883026617751e-31,  8.054418757471574e-33, -2.131977873375526e-34,  1.278126484147057e-21, -3.118251817847954e-22,  4.002864557643724e-23,
 -3.541638781230563e-24,  2.416491285051572e-25, -1.352077994435199e-26,  6.447975217550329e-28, -2.691058070517852e-29,  1.001888340792680e-30, -3.376012091412068e-32,
  1.041338737318289e-33, -2.965082010994507e-35,  6.714582656771745e-23, -1.815203700560288e-23,  2.579066957837668e-24, -2.515877703522007e-25,  1.885067422742942e-26,
 -1.153894408586911e-27,  5.999310762886998e-29, -2.720970249309811e-30,  1.097633668679493e-31, -3.996567426458996e-33,  1.328647052064701e-34, -4.067316344161350e-36,
  3.669536621342989e-24, -1.094295206274512e-24,  1.715669961039024e-25, -1.840815817423355e-26,  1.511532837173101e-27, -1.010401641371120e-28,  5.717750838617927e-30,
 -2.813832740043012e-31,  1.228082951320031e-32, -4.824814678119532e-34,  1.726344996227925e-35, -5.673753033751050e-37,  2.198879293592088e-25, -7.189749264708342e-26,
  1.238154868381962e-26, -1.455403621083565e-27,  1.305016348398217e-28, -9.495198985921708e-30,  5.830310506844164e-31, -3.104130589461121e-32,  1.461632782176687e-33,
 -6.179089062495005e-35,  2.373199573468897e-36, -8.351743327722867e-38,  1.540779069085222e-26, -5.479358616909820e-27,  1.029453592514721e-27, -1.317610055858973e-28,
  1.282850463742203e-29, -1.010532117921794e-30,  6.698547645404283e-32, -3.839559597145826e-33,  1.941336092792201e-34, -8.790938374473864e-36,  3.608083197052293e-37,
 -1.353727156768963e-38,  1.358246999439641e-27, -5.198180850019362e-28,  1.055279874133471e-28, -1.457528242148379e-29,  1.527815714059895e-30, -1.292445531618379e-31,
  9.177275430304333e-33, -5.621112947793132e-34,  3.029911225768557e-35, -1.459417827100118e-36,  6.357831303040975e-38, -2.526462987497889e-39,  1.616442373248221e-28,
 -6.569104158344336e-29,  1.422356148368211e-29, -2.093688622520656e-30,  2.334764824144992e-31, -2.096870737460459e-32,  1.577443623358738e-33, -1.021535350012629e-34,
  5.810212987866009e-36, -2.947455533364004e-37,  1.349869575130801e-38, -5.628648743880051e-40,  2.684634257480351e-29, -1.139915790936476e-29,  2.588960456394394e-30,
 -3.995997478653438e-31,  4.666724571885278e-32, -4.382789686998559e-33,  3.442492154046190e-34, -2.324067788070393e-35,  1.375998018396170e-36, -7.255716802726314e-38,
  3.449321080187616e-39, -1.490869171160909e-40,  5.284812220806605e-30, -2.301387813605307e-30,  5.374436318661164e-31, -8.528482151378641e-32,  1.023288330264791e-32,
 -9.865176988788509e-34,  7.947051449648806e-35, -5.497583320892571e-36,  3.332350932436273e-37, -1.797443844866290e-38,  8.733664680685299e-40, -3.855002005721792e-41,
  };
  int offset = -37;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 37;
    if (std::isnan(t)) {
      fill_n(rr+offset, 37, 0.5);
      fill_n(ww+offset, 37, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 37; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=37; ++j) {
        const int boxof = it*444+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
