<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    axyl-encoding-schemes.php                               */
/* Author:      Paul Waite                                              */
/* Description: Metadata encoding schemes maintenance page.             */
/*                                                                      */
/* ******************************************************************** */
include_once("application.php");

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page("Metadata Encoding Schemes", "maint", $theme);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");
include_once("maintainer-defs.php");

//debug_on(DBG_SQL|DBG_DUMP|DBG_DIAGNOSTIC);
//debug_on(DBG_ALL);

// -----------------------------------------------------------------------
// AUTHORISATION
// No guests allowed to see content..
if (!$RESPONSE->ismemberof_group_in("Admin,Editor")) {
  $RESPONSE->send();
  exit;
}

// Meta-elements maintainer form..
$maint = new maintainer("Metadata Encoding Schemes", "ax_enc_scheme");
$maint->setalign("center");
$maint->detail_table("Scheme Metadata Values", "ax_enc_value", "", 300);
$maint->detail_table("Scheme Qualifiers", "ax_enc_qualifier", "display_order", 300);
$maint->set_hiddenfields("display_order");
$ELEMENT_MAINTAINER = $maint->render();

// #######################################################################
// OUTPUT..
$RESPONSE->plugin("MAIN_CONTENT",  $ELEMENT_MAINTAINER);

// -----------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>