/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import nz.net.catalyst.ELog;
import nz.net.catalyst.Log;
import nz.net.catalyst.lucene.server.Application;
import nz.net.catalyst.lucene.server.ApplicationMissingException;
import nz.net.catalyst.lucene.server.Constants;
import nz.net.catalyst.lucene.server.ECommand;
import nz.net.catalyst.lucene.server.IPackage;
import nz.net.catalyst.lucene.server.Transmission;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;

public class UnIndex
implements IPackage,
Constants {
    private final Transmission input;
    private Application application;

    UnIndex(Transmission transmission) {
        this.input = transmission;
    }

    Transmission execute() {
        boolean purge = false;
        String id = null;
        Transmission response = new Transmission(ECommand.UNINDEX_RESPONSE);
        response.setSerial(this.input.getSerial());
        int count = -1;
        String purgeHeader = this.input.get("Purge", NO_APP);
        if (purgeHeader != null) {
            purge = true;
        } else {
            id = this.input.get("Id", NO_APP);
            if (id == null) {
                return this.error("Mandatory 'Id' header is missing");
            }
        }
        String appName = this.input.get("Application", NO_APP);
        try {
            this.application = Application.getAppOrDefault(appName);
        }
        catch (ApplicationMissingException e) {
            return this.error(e.getMessage());
        }
        this.input.setApplication(this.application);
        String domain = this.input.get("Domain");
        if (domain == null) {
            return this.error("'Domain' header is missing and is not in Application defaults");
        }
        File luceneStoreDir = Application.getIndexDirectory(this.application);
        long beforeOpen = System.currentTimeMillis();
        long afterReaderOpen = 0L;
        long afterReaderClose = 0L;
        long afterDelete = 0L;
        IndexReader reader = null;
        try {
            try {
                Term keyField;
                reader = IndexReader.open((File)luceneStoreDir);
                afterReaderOpen = System.currentTimeMillis();
                if (purge) {
                    Log.log(ELog.NOTICE, "About to PURGE All documents from domain: " + domain);
                    keyField = new Term("Domain", domain);
                } else {
                    keyField = new Term("\u0000Domain\u0000Id", String.valueOf(domain) + "\u0000" + id);
                }
                count = reader.deleteDocuments(keyField);
                afterDelete = System.currentTimeMillis();
                Log.debug("Deleted " + count + " documents (this should always be one unless purging.)");
            }
            catch (FileNotFoundException e) {
                Log.log(ELog.ERROR, "Possible Cause: Index is brandnew and contains no files yet.\nYou need to index something before deleting it!");
                Log.log(ELog.ERROR, e.toString());
                Transmission transmission = this.error("Attempt to delete on non-existing index. Index either missing or empty.");
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable e2) {
                        String message = "Error while closing IndexReader after delete: " + e2.toString();
                        Log.log(ELog.ERROR, message);
                        return this.error(message);
                    }
                }
                return transmission;
            }
            catch (IOException e) {
                Transmission transmission;
                block30: {
                    String message = "Error while deleting previous document Domain=" + domain + ", " + "Id" + '=' + id + ": " + e.toString();
                    Log.log(ELog.ERROR, message);
                    transmission = this.error(message);
                    if (reader == null) break block30;
                    try {
                        reader.close();
                    }
                    catch (Throwable e3) {
                        String string = "Error while closing IndexReader after delete: " + e3.toString();
                        Log.log(ELog.ERROR, string);
                        return this.error(string);
                    }
                }
                return transmission;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable e) {
                    String string = "Error while closing IndexReader after delete: " + e.toString();
                    Log.log(ELog.ERROR, string);
                    return this.error(string);
                }
            }
        }
        afterReaderClose = System.currentTimeMillis();
        if (count == 1) {
            response.add("Status", "Successfully deleted document with id: " + id);
        } else if (count > 1) {
            response.add("Status", "Purge Successful.  Deleted " + count + " documents");
        } else {
            response.add("Status", "No documents deleted");
        }
        Log.debug("Open" + String.valueOf(afterReaderOpen - beforeOpen));
        Log.debug("Delete" + String.valueOf(afterDelete - afterReaderOpen));
        Log.debug("Close" + String.valueOf(afterReaderClose - afterDelete));
        return response;
    }

    private Transmission error(String message) {
        Transmission response = new Transmission(ECommand.UNINDEX_RESPONSE);
        response.setSerial(this.input.getSerial());
        response.add("Error", message);
        return response;
    }
}

