/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.testclient;

import java.util.Random;
import nz.net.catalyst.lucene.testclient.SequentialClient;

public class SequentialControl {
    public static long startTime = 0L;
    public static int timeToRun = 1;
    public static int repeatCount = 10;
    public static int thread_count = 1;
    public static int errorCount = 0;
    public static boolean run = true;
    public static int requestsCompleted = 0;
    public static int threadsRunning = thread_count;
    public static long threadTime = 0L;
    public static String[] queries = new String[]{"QUERY\nApplication: nqst\nField-Name: date\nField-Type: Date\nField-Indexed: Yes\nField-Stored: No\nRange-Field: date\nRange-From: 2002-02-16\nQuery: Text:snow\nLimit: 100\nSort: date:dsc\nEND\n"};

    public static void main(String[] args) throws Exception {
        SequentialControl sc = new SequentialControl();
        sc.go();
    }

    public void go() {
        System.out.println("============= STATISTICS ==============");
        System.out.println("Time\tThreads\tCompl\tAvgTime\tThroughput");
        int query_number = 0;
        while (query_number < queries.length) {
            System.out.println("Query Number: " + query_number);
            int repeatCounter = 1;
            while (repeatCounter <= repeatCount) {
                SequentialControl sequentialControl = this;
                synchronized (sequentialControl) {
                    try {
                        this.wait(2000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                errorCount = 0;
                run = true;
                requestsCompleted = 0;
                threadsRunning = thread_count;
                threadTime = 0L;
                startTime = System.currentTimeMillis();
                Random r = new Random();
                int i22 = 0;
                while (i22 < thread_count) {
                    Thread t = new Thread(new SequentialClient("T" + i22, query_number, 0));
                    t.start();
                    ++i22;
                }
                SequentialControl i22 = this;
                synchronized (i22) {
                    try {
                        this.wait(1000 * timeToRun);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                run = false;
                while (threadsRunning > 0) {
                    i22 = this;
                    synchronized (i22) {
                        try {
                            this.wait(500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                long totalTime = System.currentTimeMillis() - startTime;
                System.out.println(String.valueOf(timeToRun) + "\t" + thread_count + "\t" + requestsCompleted + "\t" + threadTime / (long)requestsCompleted + "\t" + (double)requestsCompleted / ((double)totalTime / 1000.0));
                ++repeatCounter;
            }
            ++query_number;
        }
        System.out.println("============= ALL DONE ==============");
    }
}

