/*
    AWFFull - A Webalizer Fork, Full o' features
    
    Copyright (C) 2004, 2005, 2006 by Stephen McInerney (spm@stedee.id.au)

    $Id: options.c 263 2006-08-27 04:28:43Z steve $

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/

/***************************************************************************
 ***************************************************************************
 * options.c
 *
 * Deal with Command line options
 ***************************************************************************
 ***************************************************************************/

#include "awffull.h"                            /* main header              */

/************************************************************************
 *                              GLOBALS                                 *
 ************************************************************************/

/************************************************************************
 *                              FUNCTIONS                               *
 ************************************************************************/
void process_options(int, char *[]);            /* Process command line options */
void display_version(void);                     /* Display the Version Information */
void display_usage(int);                        /* Display the program Command Line Options, and exit */
void display_gnu_info(int);                     /* Display the GNU Disclaimer, and exit */


/************************************************************************
 * display_version                                                      *
 *                                                                      *
 * Display the Version Information                                      *
 ************************************************************************/
void
display_version(void)
{
    printf("%s\n", PACKAGE_STRING);
    printf(_("\
Copyright 1997-2001 by Bradford L. Barrett\n\
Copyright 2002, 2004 by Stanislaw Yurievich Pusep\n\
Copyright 2004, 2005, 2006 by Steve McInerney\n\n"));

}


/************************************************************************
 * display_usage                                                        *
 *                                                                      *
 * Display the Command Line Use and Exit with the passed exit_code      *
 ************************************************************************/
void
display_usage(int exit_code)
{
    display_version();
    printf("%s: %s %s\n%s", _("Usage"), PACKAGE, _("[options] [log file]"), h_msg);
    exit(exit_code);
}


/************************************************************************
 * display_gnu_info                                                     *
 *                                                                      *
 * Display the GNU standard disclaimer                                  *
 ************************************************************************/
void
display_gnu_info(int exit_code)
{
    display_version();
    printf(_("\
There is NO warranty; not even for MERCHANTABILITY or FITNESS FOR A\n\
PARTICULAR PURPOSE.  You may redistribute copies of %s under the terms\n\
of the GNU General Public License.\n\
For more information about these matters, see the file named COPYING.\n"), PACKAGE_NAME);
    exit(exit_code);
}


/************************************************************************
 * process_options                                                      *
 *                                                                      *
 * Process the individual commandline arguments                         *
 ************************************************************************/
void
process_options(int argc, char *argv[])
{
    int opt;
    int option_index = 0;

    const char *short_options = "a:A:c:C:de:E:fF:g:GhHiI:l:Lm:M:n:o:pP:qQr:R:s:S:t:Tu:U:vVx:XYZ:?";
    const struct option long_options[] = {
        {"config", 1, NULL, 'c'},
        {"debug", 0, NULL, 'd'},
        {"fold", 0, NULL, 'f'},
        {"help", 0, NULL, 'h'},
        {"ignore_history", 0, NULL, 'i'},
        {"logtype", 1, NULL, 'F'},
        {"match_counts", 0, NULL, 0},
        {"output", 1, NULL, 'o'},
        {"preserve_state", 0, NULL, 'p'},
        {"quiet", 0, NULL, 'q'},
        {"timing", 0, NULL, 'T'},
        {"use_geoip", 0, NULL, 0},
        {"verbose", 0, NULL, 'v'},
        {"version", 0, NULL, 'V'},
        {"vquiet", 0, NULL, 'Q'},
        {NULL, 0, NULL, 0}
    };

    do {
        opt = getopt_long(argc, argv, short_options, long_options, &option_index);
        switch (opt) {
        case 0:
            if (strncmp("match_counts", long_options[option_index].name, strlen("match_counts")) == 0) {
                display_match_counts = true;
            } else if (strncmp("use_geoip", long_options[option_index].name, strlen("use_geoip")) == 0) {
                use_geoip = true;
            }
            break;
        case 'a':
            add_list_member(optarg, &hidden_agents, USESPACE);
            break;                              /* Hide agents   */
        case 'A':
            ntop_agents = atoi(optarg);
            break;                              /* Top agents          */
        case 'c':
            get_config(optarg);
            break;                              /* Config file         */
        case 'C':
            ntop_ctrys = atoi(optarg);
            break;                              /* Top countries       */
        case 'd':
            ERRVPRINT(VERBOSE1, "%s\n", _("Use of \"Debug\" has been deprecated."));
            break;                              /* Debug               */
        case 'e':
            ntop_entry = atoi(optarg);
            break;                              /* Top entry pages     */
        case 'E':
            ntop_exit = atoi(optarg);
            break;                              /* Top exit pages      */
        case 'f':
            fold_seq_err = 1;
            break;                              /* Fold sequence errs  */
        case 'F':
            force_log_type = true;
            if (strncmp(optarg, "auto", 4) == 0) {
                log_type = LOG_AUTO;
                force_log_type = false;
            } else if (strncmp(optarg, "clf", 3) == 0) {
                log_type = LOG_CLF;
            } else if (strncmp(optarg, "ftp", 3) == 0) {
                log_type = LOG_FTP;
            } else if (strncmp(optarg, "squid", 5) == 0) {
                log_type = LOG_SQUID;
            } else if (strncmp(optarg, "combined", 8) == 0) {
                log_type = LOG_COMBINED;
            } else if (strncmp(optarg, "domino", 8) == 0) {
                log_type = LOG_DOMINO;
            } else {
                ERRVPRINT(VERBOSE0, "%s %s\n", _("Unknown Log Type:"), optarg);
                display_usage(0);
                exit(1);
            }
            break;                              /* define log type     */
        case 'g':
            group_domains = atoi(optarg);
            break;                              /* GroupDomains (0=no) */
        case 'G':
            hourly_graph = 0;
            break;                              /* no hourly graph     */
        case 'h':
            display_usage(0);
            break;                              /* help                */
        case 'H':
            hourly_stats = 0;
            break;                              /* no hourly stats     */
        case 'i':
            ignore_hist = 1;
            break;                              /* Ignore history      */
        case 'I':
            add_list_member(optarg, &index_alias, USESPACE);
            break;                              /* Index alias     */
        case 'l':
            graph_lines = atoi(optarg);
            break;                              /* Graph Lines         */
        case 'L':
            graph_legend = 0;
            break;                              /* Graph Legends       */
        case 'm':
            visit_timeout = atoi(optarg);
            break;                              /* Visit Timeout       */
        case 'M':
            mangle_agent = atoi(optarg);
            break;                              /* mangle user agents  */
        case 'n':
            hname = optarg;
            break;                              /* Hostname            */
        case 'o':
            out_dir = optarg;
            break;                              /* Output directory    */
        case 'p':
            incremental = 1;
            break;                              /* Incremental run     */
        case 'P':
            add_list_member(optarg, &page_type, USESPACE);
            break;                              /* page view types   */
        case 'q':
            verbose = 1;
            break;                              /* Quiet (verbose=1)   */
        case 'Q':
            verbose = 0;
            break;                              /* Really Quiet        */
        case 'r':
            add_list_member(optarg, &hidden_refs, USESPACE);
            break;                              /* Hide referrer */
        case 'R':
            ntop_refs = atoi(optarg);
            break;                              /* Top referrers       */
        case 's':
            add_list_member(optarg, &hidden_sites, USESPACE);
            break;                              /* Hide site     */
        case 'S':
            ntop_sites = atoi(optarg);
            break;                              /* Top sites           */
        case 't':
            msg_title = optarg;
            break;                              /* Report title        */
        case 'T':
            time_me = 1;
            break;                              /* TimeMe              */
        case 'u':
            add_list_member(optarg, &hidden_urls, USESPACE);
            break;                              /* hide URL      */
        case 'U':
            ntop_urls = atoi(optarg);
            break;                              /* Top urls            */
        case 'x':
            html_ext = optarg;
            break;                              /* HTML file extension */
        case 'X':
            hide_sites = 1;
            break;                              /* Hide ind. sites     */
        case 'Y':
            ctry_graph = 0;
            break;                              /* Supress ctry graph  */
        case 'Z':
            index_months = atoi(optarg);
            break;                              /* Number of Months to display on the main Index  */
        case 'v':
            g_verbosity++;
            if (g_verbosity > VERBOSE_MAX) {
                g_verbosity = VERBOSE_MAX;
                ERRVPRINT(VERBOSE0, "%s\n", _("Warning: Too many 'v' options. Setting to Max Verboseness"));
            }
            break;
        case 'V':
            display_gnu_info(0);
            break;
        case '?':
            display_usage(0);
            break;
        case -1:
            break;
        default:
            exit(1);                            /* FIXME! */
        }
    } while (opt != -1);
}

/************************************************************************
 ************************************************************************
 *                      END OF FILE                                     *
 ************************************************************************
 ************************************************************************/
