/*
   strupr.S
   Convert a string to upper case

   Contributors:
     Created by Reiner Patommel

   THIS SOFTWARE IS NOT COPYRIGHTED

   This source code is offered for use in the public domain.  You may
   use, modify or distribute it freely.

   This code is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  ALL WARRANTIES, EXPRESS OR IMPLIED ARE HEREBY
   DISCLAIMED.  This includes but is not limited to warranties of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/
#include "macros.inc"

#define str_hi r25
#define str_lo r24
#define temp   r21

; char *strupr(char *string)

    .text
    .global _U(strupr)
    .type   _U(strupr), @function

_U(strupr):
    LOAD_X(str_lo, str_hi)
.strupr_loop:
    LD    temp, X           ; get 1st character
    TST   temp              ; is it end of string
    BREQ  .strupr_done
    ANDI  temp, 0xDF        ; make upper case
    CPI   temp, 'A'         ; test on [a .. z]
    BRLT  .strupr_next
    CPI   temp, 'Z'+1
    BRGE  .strupr_next
    ST    X, temp           ; ok, it is a char --> store it
.strupr_next:
    ADIW  XL, 1				; point to next character
	RJMP  .strupr_loop
.strupr_done:
    RET
.strupr_end:
	.size _U(strupr), .strupr_end - _U(strupr)
