
#include "macros.inc"

#define dest_hi r25
#define dest_lo r24
#define src_hi r23
#define src_lo r22
#define len_hi r21
#define len_lo r20

; char *strncat(char *dest, const char *src, size_t len)

	.text
	.global	_U(strncat)
	.type	_U(strncat), @function
_U(strncat):
	LOAD_Z(src_lo, src_hi)
	LOAD_X(dest_lo, dest_hi)
.strncat_skip:
	ld	__tmp_reg__, X+
	tst	__tmp_reg__
	brne	.strncat_skip
	sbiw	XL, 1		; undo post-increment (point the the NUL)
.strncat_loop:
	subi	len_lo, lo8(1)
	sbci	len_hi, hi8(1)
	brcs	.strncat_done
	ld	__tmp_reg__, Z+
	tst	__tmp_reg__
	st	X+, __tmp_reg__
	brne	.strncat_loop
; return dest (unchanged)
	ret
.strncat_done:
	st	X, __zero_reg__
; return dest (unchanged)
	ret
.strncat_end:
	.size	_U(strncat), .strncat_end - _U(strncat)

