# Configure paths for libxvidcore

dnl AM_PATH_XVID([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl Test for libxvidcore, and define XVID_CFLAGS and XVID_LIBS
dnl
AC_DEFUN([AM_PATH_XVID],
[
    AC_ARG_WITH(xvid_prefix, [  --with-xvid-prefix=PFX  where old XviD is installed.],
		[], with_xvid_prefix="")

    XVID_CFLAGS=""
    XVID_LIBS=""

    have_xvid=no
    ac_save_CPPFLAGS=$CPPFLAGS
    if test -n "$with_xvid_prefix" ; then
	CPPFLAGS="-I$with_xvid_prefix $CPPFLAGS"
	AC_CHECK_HEADER(include/xvid.h,
			XVID_CFLAGS="-I$with_xvid_prefix/include"
			XVID_LIBS="-L$with_xvid_prefix/lib"
			have_xvid=yes)
	if test "$have_xvid" = no ; then
	    AC_CHECK_HEADER(xvid.h,
			    XVID_CFLAGS="-I$with_xvid_prefix"
			    XVID_LIBS="-L$with_xvid_prefix"
			    have_xvid=yes)
	fi
    else
	AC_CHECK_HEADER(xvid.h, have_xvid=yes)
    fi
    CPPFLAGS=$ac_save_CPPFLAGS

    AC_AVM_CHECK_LIB(xvid, [for xvid_init in -lxvidcore],
                     XVID_CFLAGS, XVID_LIBS, -lxvidcore, [
#include <stdio.h>
#include <xvid.h>], [
    XVID_INIT_PARAM xinit;

    xinit.cpu_flags = 0;
    xvid_init(NULL, 0, &xinit, NULL);

    if (xinit.api_version != API_VERSION) {
        printf("Header file and library are out of sync. Header file supports\n"
               "version %d.%d API and shared library supports version %d.%d API.\n",
               API_VERSION >> 16, API_VERSION & 0xFFFF,
               xinit.api_version >> 16, xinit.api_version & 0xFFFF);
        ret = 1;
    }		     ], [$1], [$2])
])

