%{
/*
 *  $Id: defParse.y,v 1.13 2002/03/29 04:13:03 bkorb Exp $
 *  Parse rules for the macro definitions
 */

/*
 *  AutoGen copyright 1992-2002 Bruce Korb
 *
 *  AutoGen is free software.
 *  You may redistribute it and/or modify it under the terms of the
 *  GNU General Public License, as published by the Free Software
 *  Foundation; either version 2, or (at your option) any later version.
 *
 *  AutoGen is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with AutoGen.  See the file "COPYING".  If not,
 *  write to:  The Free Software Foundation, Inc.,
 *             59 Temple Place - Suite 330,
 *             Boston,  MA  02111-1307, USA.
 */


/*
 *  Declarations
 */
#include "autogen.h"

extern YYSTYPE addSibMacro( YYSTYPE, YYSTYPE );
extern YYSTYPE makeMacro( YYSTYPE, YYSTYPE, teValType );
extern YYSTYPE makeMacroList( YYSTYPE, YYSTYPE, teValType );
extern YYSTYPE startList( YYSTYPE );
extern YYSTYPE appendList( YYSTYPE, YYSTYPE );
extern YYSTYPE findPlace( YYSTYPE, YYSTYPE );
extern YYSTYPE identify( YYSTYPE );

extern int yyparse( void );

%}

%start definitions

/*
 * Keywords
 */
%token TK_AUTOGEN TK_DEFINITIONS

%token TK_END TK_VAR_NAME TK_OTHER_NAME TK_STRING TK_NUMBER


%% /* * * * *  RULES * * * * */
definitions : identity def_list TK_END
            { $$ = (YYSTYPE)(rootDefCtx.pDefs = (tDefEntry*)$2); } ;

/*
 *  The list definitions are in byacc (yacc, list-last) order.
 *  It should be reversed for bison.  Multiple 'identity'-es are allowed
 *  (all but the first are ignored).
 */
def_list    : definition           { $$ = $1; }
            | definition def_list  { $$ = addSibMacro( $1, $2 ); }
            | identity   def_list  { $$ = $2; }
            ;

identity    : TK_AUTOGEN TK_DEFINITIONS anyname ';'
                { $$ = identify( $3 ); }
            ;

definition  : value_name ';'
                { $$ = makeMacro( $1, (YYSTYPE)"", VALTYP_TEXT ); }

            | value_name '=' text_list ';'
                { $$ = makeMacroList( $1, $3, VALTYP_TEXT ); }

            | value_name '=' block_list ';'
                { $$ = makeMacroList( $1, $3, VALTYP_BLOCK ); }
            ;

text_list   : anystring                { $$ = startList( $1 ); }
            | anystring ',' text_list  { $$ = appendList( $1, $3 ); }
            ;

block_list  : def_block                { $$ = startList( $1 ); }
            | def_block ',' block_list { $$ = appendList( $1, $3 ); }
            ;

def_block   : '{' def_list '}'         { $$ = $2; } ;

anystring   : anyname       { $$ = $1; }
            | TK_STRING     { $$ = $1; }
            | TK_NUMBER     { $$ = $1; } ;

anyname     : TK_OTHER_NAME { $$ = $1; }
            | TK_VAR_NAME   { $$ = $1; } ;

value_name  : TK_VAR_NAME
                { $$ = findPlace( (YYSTYPE)$1, (YYSTYPE)NULL ); }

            | TK_VAR_NAME '[' TK_NUMBER ']'
                { $$ = findPlace( (YYSTYPE)$1, (YYSTYPE)$3 ); }

            | TK_VAR_NAME '[' TK_VAR_NAME ']'
                { $$ = findPlace( (YYSTYPE)$1, (YYSTYPE)$3 ); }
            ;

/* end of defParse.y */
