/*
 * X11 client for Atom-4
 * Header file
 *
 * $Id: xatom4.h,v 1.16 2003/04/08 09:57:43 hsteoh Exp hsteoh $
 */

#ifndef XATOM4_H
#define XATOM4_H

#include "event.h"
#include "game.h"
#include "interface.h"
#include "xsprite.h"
#include "xscoreboard.h"
#include "xtriboard.h"
#include "xutil.h"


class XAtom4 : public appwindow {
  xconnection *conn;			// [R] connection to X server
  atom4 *game;				// [R] game engine
  xsprite_engine *eng;			// [O]
  xtriboard *boardpane;			// [O] game board
  xscoreboard *scorepane;		// [O] score panes

  int *exitflag;			// exit indicator checked by event
					// loop

  // Multiplayer support
  class gamestate_notifier : public atom4notifier {
    XAtom4 *app;			// [R]
  public:
    gamestate_notifier(XAtom4 *appwin) : app(appwin) {}
    void notify_move(atom4 *src, int player, elist<boardchange> &chg);
    void notify_clear(atom4 *src);
  } notifier;
public:
  // *exitflag should point to a variable which this class will use to
  // indicate to the event loop that it should exit. Of course, whether this
  // is actually what is monitored by the event loop is main()'s decision.
  XAtom4(xconnection *conn, atom4 *game, int *exitflag);
  ~XAtom4();

  // Maintenance
  void refresh();

  // Event handlers
  void expose(XExposeEvent ev);
  void key_press(XKeyPressedEvent ev);
  void mouse_buttondown(XButtonPressedEvent ev);
};

class x11ui : public interface {
  xconnection conn;
  XAtom4 game_app;
public:
  x11ui(char *xserver, atom4 *game, eventloop *loop, int *exitflag);
  ~x11ui();
};

#endif // XATOM4_H
